/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.jooq.tools.JooqLogger;
import org.jooq.util.Database;
import org.jooq.util.Generator;
import org.jooq.util.GeneratorStrategy;
import org.jooq.util.GeneratorStrategyWrapper;

abstract class AbstractGenerator
implements Generator {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractGenerator.class);
    boolean generateDeprecated = true;
    boolean generateRelations = true;
    boolean generateInstanceFields = true;
    boolean generateGeneratedAnnotation = true;
    boolean useSchemaVersionProvider = false;
    boolean useCatalogVersionProvider = false;
    boolean generateRoutines = true;
    boolean generateSequences = true;
    boolean generateUDTs = true;
    boolean generateTables = true;
    boolean generateRecords = true;
    boolean generatePojos = false;
    boolean generatePojosEqualsAndHashCode = false;
    boolean generatePojosToString = true;
    boolean generateImmutablePojos = false;
    boolean generateInterfaces = false;
    boolean generateImmutableInterfaces = false;
    boolean generateDaos = false;
    boolean generateJPAAnnotations = false;
    boolean generateValidationAnnotations = false;
    boolean generateSpringAnnotations = false;
    boolean generateQueues = true;
    boolean generateLinks = true;
    boolean generateGlobalObjectReferences = true;
    boolean generateGlobalCatalogReferences = true;
    boolean generateGlobalSchemaReferences = true;
    boolean generateGlobalRoutineReferences = true;
    boolean generateGlobalSequenceReferences = true;
    boolean generateGlobalTableReferences = true;
    boolean generateGlobalUDTReferences = true;
    boolean generateGlobalQueueReferences = true;
    boolean generateGlobalLinkReferences = true;
    boolean fluentSetters = false;
    String generateFullyQualifiedTypes = "";
    boolean generateJavaTimeTypes = false;
    boolean generateTableValuedFunctions = false;
    boolean generateEmptyCatalogs = false;
    boolean generateEmptySchemas = false;
    protected GeneratorStrategyWrapper strategy;
    protected String targetEncoding = "UTF-8";
    final Language language;

    AbstractGenerator(Language language) {
        this.language = language;
    }

    void logDatabaseParameters(Database db) {
        String url = "";
        try {
            Connection connection = db.getConnection();
            if (connection != null) {
                url = connection.getMetaData().getURL();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        log.info((Object)"License parameters");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"  Thank you for using jOOQ and jOOQ's code generator");
        log.info((Object)"");
        log.info((Object)"Database parameters");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"  dialect", (Object)db.getDialect());
        log.info((Object)"  URL", (Object)url);
        log.info((Object)"  target dir", (Object)this.getTargetDirectory());
        log.info((Object)"  target package", (Object)this.getTargetPackage());
        log.info((Object)"  includes", Arrays.asList(db.getIncludes()));
        log.info((Object)"  excludes", Arrays.asList(db.getExcludes()));
        log.info((Object)"  includeExcludeColumns", (Object)db.getIncludeExcludeColumns());
        log.info((Object)"----------------------------------------------------------");
    }

    void logGenerationRemarks(Database db) {
        log.info((Object)"Generation remarks");
        log.info((Object)"----------------------------------------------------------");
        if (this.contains(db.getIncludes(), ',') && db.getIncluded().isEmpty()) {
            log.info((Object)"  includes", (Object)"The <includes/> element takes a Java regular expression, not a comma-separated list. This might be why no objects were included.");
        }
        if (this.contains(db.getExcludes(), ',') && db.getExcluded().isEmpty()) {
            log.info((Object)"  excludes", (Object)"The <excludes/> element takes a Java regular expression, not a comma-separated list. This might be why no objects were excluded.");
        }
    }

    private boolean contains(String[] array, char c) {
        if (array == null) {
            return false;
        }
        for (String string : array) {
            if (string == null || string.indexOf(c) <= -1) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setStrategy(GeneratorStrategy strategy) {
        this.strategy = new GeneratorStrategyWrapper(this, strategy, this.language);
    }

    @Override
    public GeneratorStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public boolean generateDeprecated() {
        return this.generateDeprecated;
    }

    @Override
    public void setGenerateDeprecated(boolean generateDeprecated) {
        this.generateDeprecated = generateDeprecated;
    }

    @Override
    public boolean generateRelations() {
        return this.generateRelations || this.generateTables || this.generateDaos;
    }

    @Override
    public void setGenerateRelations(boolean generateRelations) {
        this.generateRelations = generateRelations;
    }

    @Override
    public boolean generateTableValuedFunctions() {
        return this.generateTableValuedFunctions;
    }

    @Override
    public void setGenerateTableValuedFunctions(boolean generateTableValuedFunctions) {
        this.generateTableValuedFunctions = generateTableValuedFunctions;
    }

    @Override
    public boolean generateInstanceFields() {
        return this.generateInstanceFields;
    }

    @Override
    public void setGenerateInstanceFields(boolean generateInstanceFields) {
        this.generateInstanceFields = generateInstanceFields;
    }

    @Override
    public boolean generateGeneratedAnnotation() {
        return this.generateGeneratedAnnotation || this.useSchemaVersionProvider || this.useCatalogVersionProvider;
    }

    @Override
    public void setGenerateGeneratedAnnotation(boolean generateGeneratedAnnotation) {
        this.generateGeneratedAnnotation = generateGeneratedAnnotation;
    }

    @Override
    public boolean useSchemaVersionProvider() {
        return this.useSchemaVersionProvider;
    }

    @Override
    public void setUseSchemaVersionProvider(boolean useSchemaVersionProvider) {
        this.useSchemaVersionProvider = useSchemaVersionProvider;
    }

    @Override
    public boolean useCatalogVersionProvider() {
        return this.useCatalogVersionProvider;
    }

    @Override
    public void setUseCatalogVersionProvider(boolean useCatalogVersionProvider) {
        this.useCatalogVersionProvider = useCatalogVersionProvider;
    }

    @Override
    public boolean generateRoutines() {
        return this.generateRoutines;
    }

    @Override
    public void setGenerateRoutines(boolean generateRoutines) {
        this.generateRoutines = generateRoutines;
    }

    @Override
    public boolean generateSequences() {
        return this.generateSequences;
    }

    @Override
    public void setGenerateSequences(boolean generateSequences) {
        this.generateSequences = generateSequences;
    }

    @Override
    public boolean generateUDTs() {
        return this.generateUDTs;
    }

    @Override
    public void setGenerateUDTs(boolean generateUDTs) {
        this.generateUDTs = generateUDTs;
    }

    @Override
    public boolean generateTables() {
        return this.generateTables || this.generateRecords || this.generateDaos;
    }

    @Override
    public void setGenerateTables(boolean generateTables) {
        this.generateTables = generateTables;
    }

    @Override
    public boolean generateRecords() {
        return this.generateRecords || this.generateDaos;
    }

    @Override
    public void setGenerateRecords(boolean generateRecords) {
        this.generateRecords = generateRecords;
    }

    @Override
    public boolean generatePojos() {
        return this.generatePojos || this.generateImmutablePojos || this.generateDaos;
    }

    @Override
    public void setGeneratePojos(boolean generatePojos) {
        this.generatePojos = generatePojos;
    }

    @Override
    public boolean generateImmutablePojos() {
        return this.generateImmutablePojos;
    }

    @Override
    public void setGenerateImmutablePojos(boolean generateImmutablePojos) {
        this.generateImmutablePojos = generateImmutablePojos;
    }

    @Override
    public boolean generateInterfaces() {
        return this.generateInterfaces || this.generateImmutableInterfaces;
    }

    @Override
    public void setGenerateInterfaces(boolean generateInterfaces) {
        this.generateInterfaces = generateInterfaces;
    }

    @Override
    public boolean generateImmutableInterfaces() {
        return this.generateImmutableInterfaces || this.generateInterfaces && this.generateImmutablePojos;
    }

    @Override
    public void setGenerateImmutableInterfaces(boolean generateImmutableInterfaces) {
        this.generateImmutableInterfaces = generateImmutableInterfaces;
    }

    @Override
    public boolean generateDaos() {
        return this.generateDaos;
    }

    @Override
    public void setGenerateDaos(boolean generateDaos) {
        this.generateDaos = generateDaos;
    }

    @Override
    public boolean generateJPAAnnotations() {
        return this.generateJPAAnnotations;
    }

    @Override
    public void setGenerateJPAAnnotations(boolean generateJPAAnnotations) {
        this.generateJPAAnnotations = generateJPAAnnotations;
    }

    @Override
    public boolean generateValidationAnnotations() {
        return this.generateValidationAnnotations;
    }

    @Override
    public void setGenerateValidationAnnotations(boolean generateValidationAnnotations) {
        this.generateValidationAnnotations = generateValidationAnnotations;
    }

    @Override
    public boolean generateSpringAnnotations() {
        return this.generateSpringAnnotations;
    }

    @Override
    public void setGenerateSpringAnnotations(boolean generateSpringAnnotations) {
        this.generateSpringAnnotations = generateSpringAnnotations;
    }

    @Override
    public boolean generateGlobalObjectReferences() {
        return this.generateGlobalObjectReferences;
    }

    @Override
    public void setGenerateGlobalObjectReferences(boolean generateGlobalObjectReferences) {
        this.generateGlobalObjectReferences = generateGlobalObjectReferences;
    }

    @Override
    public boolean generateGlobalCatalogReferences() {
        return this.generateGlobalObjectReferences() && this.generateGlobalCatalogReferences;
    }

    @Override
    public void setGenerateGlobalCatalogReferences(boolean globalCatalogReferences) {
        this.generateGlobalCatalogReferences = globalCatalogReferences;
    }

    @Override
    public boolean generateGlobalSchemaReferences() {
        return this.generateGlobalObjectReferences() && this.generateGlobalSchemaReferences;
    }

    @Override
    public void setGenerateGlobalSchemaReferences(boolean globalSchemaReferences) {
        this.generateGlobalSchemaReferences = globalSchemaReferences;
    }

    @Override
    public boolean generateGlobalRoutineReferences() {
        return this.generateRoutines() && this.generateGlobalObjectReferences() && this.generateGlobalRoutineReferences;
    }

    @Override
    public void setGenerateGlobalRoutineReferences(boolean generateGlobalRoutineReferences) {
        this.generateGlobalRoutineReferences = generateGlobalRoutineReferences;
    }

    @Override
    public boolean generateGlobalSequenceReferences() {
        return this.generateSequences() && this.generateGlobalObjectReferences() && this.generateGlobalSequenceReferences;
    }

    @Override
    public void setGenerateGlobalSequenceReferences(boolean generateGlobalSequenceReferences) {
        this.generateGlobalSequenceReferences = generateGlobalSequenceReferences;
    }

    @Override
    public boolean generateGlobalTableReferences() {
        return this.generateTables() && this.generateGlobalObjectReferences() && this.generateGlobalTableReferences;
    }

    @Override
    public void setGenerateGlobalTableReferences(boolean generateGlobalTableReferences) {
        this.generateGlobalTableReferences = generateGlobalTableReferences;
    }

    @Override
    public boolean generateGlobalUDTReferences() {
        return this.generateUDTs() && this.generateGlobalObjectReferences() && this.generateGlobalUDTReferences;
    }

    @Override
    public void setGenerateGlobalUDTReferences(boolean generateGlobalUDTReferences) {
        this.generateGlobalUDTReferences = generateGlobalUDTReferences;
    }

    @Override
    public boolean generateGlobalQueueReferences() {
        return this.generateQueues() && this.generateGlobalObjectReferences() && this.generateGlobalQueueReferences;
    }

    @Override
    public void setGenerateGlobalQueueReferences(boolean globalQueueReferences) {
        this.generateGlobalQueueReferences = globalQueueReferences;
    }

    @Override
    public boolean generateGlobalLinkReferences() {
        return this.generateLinks() && this.generateGlobalObjectReferences() && this.generateGlobalLinkReferences;
    }

    @Override
    public void setGenerateGlobalLinkReferences(boolean globalLinkReferences) {
        this.generateGlobalLinkReferences = globalLinkReferences;
    }

    @Override
    public boolean generateQueues() {
        return this.generateQueues;
    }

    @Override
    public void setGenerateQueues(boolean queues) {
        this.generateQueues = queues;
    }

    @Override
    public boolean generateLinks() {
        return this.generateLinks;
    }

    @Override
    public void setGenerateLinks(boolean links) {
        this.generateLinks = links;
    }

    @Override
    public boolean fluentSetters() {
        return this.fluentSetters;
    }

    @Override
    public void setFluentSetters(boolean fluentSetters) {
        this.fluentSetters = fluentSetters;
    }

    @Override
    public boolean generatePojosEqualsAndHashCode() {
        return this.generatePojosEqualsAndHashCode;
    }

    @Override
    public void setGeneratePojosEqualsAndHashCode(boolean generatePojosEqualsAndHashCode) {
        this.generatePojosEqualsAndHashCode = generatePojosEqualsAndHashCode;
    }

    @Override
    public boolean generatePojosToString() {
        return this.generatePojosToString;
    }

    @Override
    public void setGeneratePojosToString(boolean generatePojosToString) {
        this.generatePojosToString = generatePojosToString;
    }

    @Override
    @Deprecated
    public String fullyQualifiedTypes() {
        return this.generateFullyQualifiedTypes();
    }

    @Override
    @Deprecated
    public void setFullyQualifiedTypes(String fullyQualifiedTypes) {
        this.setGenerateFullyQualifiedTypes(fullyQualifiedTypes);
    }

    @Override
    public String generateFullyQualifiedTypes() {
        return this.generateFullyQualifiedTypes;
    }

    @Override
    public void setGenerateFullyQualifiedTypes(String generateFullyQualifiedTypes) {
        this.generateFullyQualifiedTypes = generateFullyQualifiedTypes;
    }

    @Override
    public boolean generateJavaTimeTypes() {
        return this.generateJavaTimeTypes;
    }

    @Override
    public void setGenerateJavaTimeTypes(boolean generateJavaTimeTypes) {
        this.generateJavaTimeTypes = generateJavaTimeTypes;
    }

    @Override
    public boolean generateEmptyCatalogs() {
        return this.generateEmptyCatalogs;
    }

    @Override
    public void setGenerateEmptyCatalogs(boolean generateEmptyCatalogs) {
        this.generateEmptyCatalogs = generateEmptyCatalogs;
    }

    @Override
    public boolean generateEmptySchemas() {
        return this.generateEmptySchemas;
    }

    @Override
    public void setGenerateEmptySchemas(boolean generateEmptySchemas) {
        this.generateEmptySchemas = generateEmptySchemas;
    }

    @Override
    public void setTargetDirectory(String directory) {
        this.strategy.setTargetDirectory(directory);
    }

    @Override
    public String getTargetDirectory() {
        return this.strategy.getTargetDirectory();
    }

    @Override
    public void setTargetPackage(String packageName) {
        this.strategy.setTargetPackage(packageName);
    }

    @Override
    public String getTargetPackage() {
        return this.strategy.getTargetPackage();
    }

    @Override
    public String getTargetEncoding() {
        return this.targetEncoding;
    }

    @Override
    public void setTargetEncoding(String encoding) {
        this.targetEncoding = encoding;
    }

    protected void empty(File file, String suffix) {
        this.empty(file, suffix, Collections.emptySet(), Collections.emptySet());
    }

    protected void empty(File file, String suffix, Set<File> keep, Set<File> ignore) {
        if (file != null) {
            if (file.getParentFile() == null) {
                log.warn((Object)"WARNING: Root directory configured for code generation. Not deleting anything from previous generations!");
                return;
            }
            for (File file2 : ignore) {
                if (!file.getAbsolutePath().startsWith(file2.getAbsolutePath())) continue;
                return;
            }
            if (file.isDirectory()) {
                File[] fileArray;
                File[] children = file.listFiles();
                if (children != null) {
                    for (File child : children) {
                        this.empty(child, suffix, keep, ignore);
                    }
                }
                if ((fileArray = file.listFiles()) != null && fileArray.length == 0) {
                    file.delete();
                }
            } else if (file.getName().endsWith(suffix) && !keep.contains(file)) {
                file.delete();
            }
        }
    }

    static enum Language {
        JAVA,
        SCALA,
        XML;

    }
}

