/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.tools.StringUtils;
import org.jooq.util.GeneratorException;

public abstract class GeneratorWriter<W extends GeneratorWriter<W>> {
    private static final Pattern PATTERN_LIST = Pattern.compile("\\[(?:\\[before=([^\\]]+)\\])?(?:\\[separator=([^\\]]+)\\])?(?:\\[after=([^\\]]+)\\])?(?:\\[(.*)\\])\\]", 32);
    private final File file;
    private final StringBuilder sb;
    private int indentTabs;
    private boolean newline = true;

    protected GeneratorWriter(File file) {
        file.getParentFile().mkdirs();
        this.file = file;
        this.sb = new StringBuilder();
    }

    public final File file() {
        return this.file;
    }

    public final W print(char value) {
        this.print("" + value);
        return (W)this;
    }

    public final W print(int value) {
        this.print("" + value);
        return (W)this;
    }

    public final W print(String string) {
        this.print(string, new Object[0]);
        return (W)this;
    }

    /*
     * WARNING - void declaration
     */
    public final W print(String string, Object ... args) {
        if (this.newline && this.indentTabs > 0) {
            this.sb.append(StringUtils.leftPad((String)"", (int)this.indentTabs, (char)'\t'));
            this.newline = false;
            this.indentTabs = 0;
        }
        if (args.length > 0) {
            List<Object> originals = Arrays.asList(args);
            ArrayList<Object> translated = new ArrayList<Object>();
            while (true) {
                for (Object object : originals) {
                    if (object instanceof Class) {
                        translated.add(this.ref((Class)object));
                        continue;
                    }
                    if (object instanceof Object[] || object instanceof Collection) {
                        void var6_6;
                        if (object instanceof Collection) {
                            Object[] objectArray = ((Collection)object).toArray();
                        }
                        int start = string.indexOf("[[");
                        int end = string.indexOf("]]");
                        String expression = string.substring(start, end + 2);
                        StringBuilder replacement = new StringBuilder();
                        Matcher m = PATTERN_LIST.matcher(expression);
                        m.find();
                        String gBefore = StringUtils.defaultString((String)m.group(1));
                        String gSeparator = StringUtils.defaultString((String)m.group(2), (String)", ");
                        String gAfter = StringUtils.defaultString((String)m.group(3));
                        String gContent = m.group(4);
                        String separator = gBefore;
                        for (Object o : (Object[])var6_6) {
                            translated.add(o);
                            replacement.append(separator);
                            replacement.append(gContent);
                            separator = gSeparator;
                        }
                        if (((Object[])var6_6).length > 0) {
                            replacement.append(gAfter);
                        }
                        string = string.substring(0, start) + replacement + string.substring(end + 2);
                        continue;
                    }
                    translated.add(object);
                }
                if (!string.contains("[[")) break;
                originals = translated;
                translated = new ArrayList();
            }
            this.sb.append(String.format(string, translated.toArray()));
        } else {
            this.sb.append(string);
        }
        return (W)this;
    }

    public final W println() {
        if (this.sb.length() > 0) {
            this.sb.append("\n");
            this.newline = true;
        }
        return (W)this;
    }

    public final W println(int value) {
        this.print(value);
        this.println();
        return (W)this;
    }

    public final W println(String string) {
        this.print(string);
        this.println();
        return (W)this;
    }

    public final W println(String string, Object ... args) {
        this.print(string, args);
        this.println();
        return (W)this;
    }

    public final W tab(int tabs) {
        this.indentTabs = tabs;
        return (W)this;
    }

    public final int tab() {
        return this.indentTabs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean close() {
        String newContent = this.beforeClose(this.sb.toString());
        if (StringUtils.isBlank((String)newContent)) {
            return false;
        }
        try {
            String oldContent = null;
            if (this.file.exists()) {
                try (RandomAccessFile old = null;){
                    old = new RandomAccessFile(this.file, "r");
                    byte[] oldBytes = new byte[(int)old.length()];
                    old.readFully(oldBytes);
                    oldContent = new String(oldBytes, "UTF-8");
                }
            }
            if (oldContent == null || !oldContent.equals(newContent)) {
                PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF-8"));
                writer.append(newContent);
                writer.flush();
                writer.close();
            }
            return true;
        }
        catch (IOException e) {
            throw new GeneratorException("Error writing " + this.file.getAbsolutePath());
        }
    }

    protected String beforeClose(String string) {
        return string;
    }

    protected final String ref(Class<?> clazz) {
        return clazz == null ? null : this.ref(clazz.getName());
    }

    protected final String ref(String clazzOrId) {
        return clazzOrId == null ? null : this.ref(Arrays.asList(clazzOrId), 1).get(0);
    }

    protected final String[] ref(String[] clazzOrId) {
        return clazzOrId == null ? new String[]{} : this.ref(Arrays.asList(clazzOrId), 1).toArray(new String[clazzOrId.length]);
    }

    protected final List<String> ref(List<String> clazzOrId) {
        return clazzOrId == null ? Collections.emptyList() : this.ref(clazzOrId, 1);
    }

    protected final String ref(String clazzOrId, int keepSegments) {
        return clazzOrId == null ? null : this.ref(Arrays.asList(clazzOrId), keepSegments).get(0);
    }

    protected final String[] ref(String[] clazzOrId, int keepSegments) {
        return clazzOrId == null ? new String[]{} : this.ref(Arrays.asList(clazzOrId), keepSegments).toArray(new String[clazzOrId.length]);
    }

    protected List<String> ref(List<String> clazzOrId, int keepSegments) {
        return clazzOrId == null ? Collections.emptyList() : clazzOrId;
    }

    public String toString() {
        return "GenerationWriter [" + this.file + "]";
    }
}

