/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.tools.StringUtils;
import org.jooq.util.GeneratorWriter;

public class JavaWriter
extends GeneratorWriter<JavaWriter> {
    private static final String SERIAL_STATEMENT = "__SERIAL_STATEMENT__";
    private static final String IMPORT_STATEMENT = "__IMPORT_STATEMENT__";
    private final Pattern fullyQualifiedTypes;
    private final Set<String> qualifiedTypes = new TreeSet<String>();
    private final Map<String, String> unqualifiedTypes = new TreeMap<String, String>();
    private final String className;
    private final boolean isJava;
    private final boolean isScala;
    private final Pattern REF_PATTERN = Pattern.compile("((?:[\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*)((?:<.*>|\\[.*\\])*)");

    public JavaWriter(File file, String fullyQualifiedTypes) {
        super(file);
        this.className = file.getName().replaceAll("\\.(java|scala)$", "");
        this.isJava = file.getName().endsWith(".java");
        this.isScala = file.getName().endsWith(".scala");
        this.fullyQualifiedTypes = fullyQualifiedTypes == null ? null : Pattern.compile(fullyQualifiedTypes);
    }

    public JavaWriter print(Class<?> clazz) {
        this.printClass(clazz.getCanonicalName());
        return this;
    }

    public JavaWriter printClass(String clazz) {
        this.print(this.ref(clazz));
        return this;
    }

    public JavaWriter javadoc(String string, Object ... args) {
        int t = this.tab();
        String escaped = string.replace("*/", "* /");
        ((JavaWriter)this.tab(t)).println();
        ((JavaWriter)this.tab(t)).println("/**");
        ((JavaWriter)this.tab(t)).println(" * " + escaped, args);
        ((JavaWriter)this.tab(t)).println(" */");
        return this;
    }

    public JavaWriter header(String header, Object ... args) {
        int t = this.tab();
        ((JavaWriter)this.tab(t)).println();
        ((JavaWriter)this.tab(t)).println("// -------------------------------------------------------------------------");
        ((JavaWriter)this.tab(t)).println("// " + header, args);
        ((JavaWriter)this.tab(t)).println("// -------------------------------------------------------------------------");
        return this;
    }

    public JavaWriter override() {
        this.println("@Override");
        return this;
    }

    public JavaWriter overrideIf(boolean override) {
        if (override) {
            this.println("@Override");
        }
        return this;
    }

    public JavaWriter overrideInherit() {
        int t = this.tab();
        ((JavaWriter)this.tab(t)).javadoc("{@inheritDoc}", new Object[0]);
        ((JavaWriter)this.tab(t)).println("@Override");
        return this;
    }

    public void printSerial() {
        if (this.isJava) {
            this.println();
            this.println("\tprivate static final long serialVersionUID = %s;", SERIAL_STATEMENT);
        }
    }

    public void printImports() {
        this.println(IMPORT_STATEMENT);
    }

    @Override
    protected String beforeClose(String string) {
        StringBuilder importString = new StringBuilder();
        String pkg = "";
        Matcher m = Pattern.compile("(?s:^.*?\\Rpackage\\s+(.*?);?\\R.*?$)").matcher(string);
        if (m.find()) {
            pkg = m.group(1);
        }
        Pattern samePackagePattern = Pattern.compile(pkg + "\\.[^\\.]+");
        String previous = "";
        for (String imp : this.qualifiedTypes) {
            if (this.isJava && imp.startsWith("java.lang.") || imp.endsWith("." + this.className) || pkg.length() > 0 && samePackagePattern.matcher(imp).matches()) continue;
            String topLevelPackage = imp.split("\\.")[0];
            if (!topLevelPackage.equals(previous)) {
                importString.append("\n");
            }
            importString.append("import ").append(imp).append(this.isScala ? "\n" : ";\n");
            previous = topLevelPackage;
        }
        string = string.replaceAll(IMPORT_STATEMENT, Matcher.quoteReplacement(importString.toString()));
        string = string.replaceAll(SERIAL_STATEMENT, Matcher.quoteReplacement(String.valueOf(string.hashCode())));
        return string;
    }

    @Override
    protected List<String> ref(List<String> clazz, int keepSegments) {
        ArrayList<String> result = new ArrayList<String>();
        if (clazz != null) {
            for (String c : clazz) {
                Matcher m;
                if (c.contains(".") && (this.fullyQualifiedTypes == null || !this.fullyQualifiedTypes.matcher(c).matches()) && (m = this.REF_PATTERN.matcher(c)).find()) {
                    List<String> split = Arrays.asList(m.group(1).split("\\."));
                    String qualifiedType = StringUtils.join((Object[])split.subList(0, split.size() - keepSegments + 1).toArray(), (String)".");
                    String unqualifiedType = split.get(split.size() - keepSegments);
                    String remainder = StringUtils.join((Object[])split.subList(split.size() - keepSegments, split.size()).toArray(), (String)".");
                    if (!(this.className.equals(unqualifiedType) || this.unqualifiedTypes.containsKey(unqualifiedType) && !qualifiedType.equals(this.unqualifiedTypes.get(unqualifiedType)))) {
                        this.unqualifiedTypes.put(unqualifiedType, qualifiedType);
                        this.qualifiedTypes.add(qualifiedType);
                        c = remainder + m.group(2);
                    }
                }
                result.add(c);
            }
        }
        return result;
    }
}

