/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.File;
import java.lang.reflect.TypeVariable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jooq.AggregateFunction;
import org.jooq.Configuration;
import org.jooq.DataType;
import org.jooq.EnumType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.Package;
import org.jooq.Parameter;
import org.jooq.Record;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UDT;
import org.jooq.UDTField;
import org.jooq.UniqueKey;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractKeys;
import org.jooq.impl.AbstractRoutine;
import org.jooq.impl.DAOImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.PackageImpl;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.SequenceImpl;
import org.jooq.impl.TableImpl;
import org.jooq.impl.TableRecordImpl;
import org.jooq.impl.UDTImpl;
import org.jooq.impl.UDTRecordImpl;
import org.jooq.impl.UpdatableRecordImpl;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StopWatch;
import org.jooq.tools.StringUtils;
import org.jooq.tools.reflect.Reflect;
import org.jooq.tools.reflect.ReflectException;
import org.jooq.util.AbstractGenerator;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.AttributeDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.Database;
import org.jooq.util.Definition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.ForeignKeyDefinition;
import org.jooq.util.GenerationUtil;
import org.jooq.util.GeneratorException;
import org.jooq.util.GeneratorStrategy;
import org.jooq.util.GeneratorWriter;
import org.jooq.util.IdentityDefinition;
import org.jooq.util.JavaWriter;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ParameterDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.UniqueKeyDefinition;
import org.jooq.util.postgres.PostgresDatabase;

public class JavaGenerator
extends AbstractGenerator {
    private static final JooqLogger log = JooqLogger.getLogger(JavaGenerator.class);
    private static final String NO_FURTHER_INSTANCES_ALLOWED = "No further instances allowed";
    private static final int INITIALISER_SIZE = 500;
    private final StopWatch watch = new StopWatch();
    private Database database;

    @Override
    public final void generate(Database db) {
        this.database = db;
        String url = null;
        try {
            url = this.database.getConnection().getMetaData().getURL();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        log.info((Object)"License parameters");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"  Thank you for using jOOQ and jOOQ's code generator");
        log.info((Object)"");
        log.info((Object)"Database parameters");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"  dialect", (Object)this.database.getDialect());
        log.info((Object)"  URL", (Object)url);
        log.info((Object)"  target dir", (Object)this.getTargetDirectory());
        log.info((Object)"  target package", (Object)this.getTargetPackage());
        log.info((Object)"  includes", Arrays.asList(this.database.getIncludes()));
        log.info((Object)"  excludes", Arrays.asList(this.database.getExcludes()));
        log.info((Object)"  includeExcludeColumns", (Object)this.database.getIncludeExcludeColumns());
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"");
        log.info((Object)"DefaultGenerator parameters");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"  strategy", this.strategy.delegate.getClass());
        log.info((Object)"  deprecated", (Object)this.generateDeprecated());
        log.info((Object)"  generated annotation", (Object)this.generateGeneratedAnnotation());
        log.info((Object)"  JPA annotations", (Object)this.generateJPAAnnotations());
        log.info((Object)"  validation annotations", (Object)this.generateValidationAnnotations());
        log.info((Object)"  instance fields", (Object)this.generateInstanceFields());
        log.info((Object)"  records", (Object)(this.generateRecords() + (!this.generateRecords && this.generateDaos ? " (forced to true because of <daos/>)" : "")));
        log.info((Object)"  pojos", (Object)(this.generatePojos() + (!this.generatePojos && this.generateDaos ? " (forced to true because of <daos/>)" : (!this.generatePojos && this.generateImmutablePojos ? " (forced to true because of <immutablePojos/>)" : ""))));
        log.info((Object)"  immutable pojos", (Object)this.generateImmutablePojos());
        log.info((Object)"  interfaces", (Object)this.generateInterfaces());
        log.info((Object)"  daos", (Object)this.generateDaos());
        log.info((Object)"  relations", (Object)(this.generateRelations() + (!this.generateRelations && this.generateDaos ? " (forced to true because of <daos/>)" : "")));
        log.info((Object)"  global references", (Object)this.generateGlobalObjectReferences());
        log.info((Object)"----------------------------------------------------------");
        if (!this.generateInstanceFields()) {
            log.warn((Object)"");
            log.warn((Object)"Deprecation warnings");
            log.warn((Object)"----------------------------------------------------------");
            log.warn((Object)"  <generateInstanceFields/> = false is deprecated! Please adapt your configuration.");
        }
        log.info((Object)"");
        log.info((Object)"Generation remarks");
        log.info((Object)"----------------------------------------------------------");
        if (this.generateImmutablePojos && this.generateInterfaces) {
            log.info((Object)"  immutable pojos", (Object)"Immutable POJOs do not have any setters. Hence, setters are also missing from interfaces");
        } else {
            log.info((Object)"  none");
        }
        log.info((Object)"");
        log.info((Object)"----------------------------------------------------------");
        String targetPackage = this.getTargetPackage();
        File targetPackageDir = new File(this.getTargetDirectory() + File.separator + targetPackage.replace('.', File.separatorChar));
        log.info((Object)"Emptying", (Object)targetPackageDir.getAbsolutePath());
        this.empty(targetPackageDir, ".java");
        log.info((Object)"Generating schemata", (Object)("Total: " + this.database.getSchemata().size()));
        for (SchemaDefinition schema : this.database.getSchemata()) {
            try {
                this.generate(schema);
            }
            catch (Exception e) {
                throw new GeneratorException("Error generating code for schema " + schema, e);
            }
        }
    }

    private final void generate(SchemaDefinition schema) {
        this.generateSchema(schema);
        if (this.generateGlobalObjectReferences() && this.database.getSequences(schema).size() > 0) {
            this.generateSequences(schema);
        }
        if (this.database.getTables(schema).size() > 0) {
            this.generateTables(schema);
        }
        if (this.generatePojos() && this.database.getTables(schema).size() > 0) {
            this.generatePojos(schema);
        }
        if (this.generateDaos() && this.database.getTables(schema).size() > 0) {
            this.generateDaos(schema);
        }
        if (this.generateGlobalObjectReferences() && this.database.getTables(schema).size() > 0) {
            this.generateTableReferences(schema);
        }
        if (this.generateRelations() && this.database.getTables(schema).size() > 0) {
            this.generateRelations(schema);
        }
        if (this.generateRecords() && this.database.getTables(schema).size() > 0) {
            this.generateRecords(schema);
        }
        if (this.generateInterfaces() && this.database.getTables(schema).size() > 0) {
            this.generateInterfaces(schema);
        }
        if (this.database.getUDTs(schema).size() > 0) {
            this.generateUDTs(schema);
        }
        if (this.database.getUDTs(schema).size() > 0) {
            this.generateUDTRecords(schema);
        }
        if (this.database.getUDTs(schema).size() > 0) {
            this.generateUDTRoutines(schema);
        }
        if (this.generateGlobalObjectReferences() && this.database.getUDTs(schema).size() > 0) {
            this.generateUDTReferences(schema);
        }
        if (this.database.getArrays(schema).size() > 0) {
            this.generateArrays(schema);
        }
        if (this.database.getEnums(schema).size() > 0) {
            this.generateEnums(schema);
        }
        if (this.database.getRoutines(schema).size() > 0 || this.hasTableValuedFunctions(schema)) {
            this.generateRoutines(schema);
        }
        if (this.database.getPackages(schema).size() > 0) {
            this.generatePackages(schema);
        }
        this.watch.splitInfo("GENERATION FINISHED!");
    }

    private boolean hasTableValuedFunctions(SchemaDefinition schema) {
        for (TableDefinition table : this.database.getTables(schema)) {
            if (!table.isTableValuedFunction()) continue;
            return true;
        }
        return false;
    }

    protected void generateRelations(SchemaDefinition schema) {
        String keyType;
        log.info((Object)"Generating Keys");
        JavaWriter out = new JavaWriter(new File(this.getStrategy().getFile((Definition)schema).getParentFile(), "Keys.java"));
        this.printPackage(out, (Definition)schema);
        this.printClassJavadoc(out, "A class modelling foreign key relationships between tables of the <code>" + schema.getOutputName() + "</code> schema");
        out.println("public class Keys {");
        ((JavaWriter)out.tab(1)).header("IDENTITY definitions", new Object[0]);
        out.println();
        ArrayList<IdentityDefinition> allIdentities = new ArrayList<IdentityDefinition>();
        ArrayList<UniqueKeyDefinition> allUniqueKeys = new ArrayList<UniqueKeyDefinition>();
        ArrayList<ForeignKeyDefinition> allForeignKeys = new ArrayList<ForeignKeyDefinition>();
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                IdentityDefinition identity = table.getIdentity();
                if (identity == null) continue;
                String identityType = this.getStrategy().getFullJavaClassName(identity.getColumn().getContainer(), GeneratorStrategy.Mode.RECORD);
                String columnType = this.getJavaType(identity.getColumn().getType());
                String identityId = this.getStrategy().getJavaIdentifier(identity.getColumn().getContainer());
                int block = allIdentities.size() / 500;
                ((JavaWriter)out.tab(1)).println("public static final %s<%s, %s> IDENTITY_%s = Identities%s.IDENTITY_%s;", Identity.class, identityType, columnType, identityId, block, identityId);
                allIdentities.add(identity);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table " + table), (Throwable)e);
            }
        }
        ((JavaWriter)out.tab(1)).header("UNIQUE and PRIMARY KEY definitions", new Object[0]);
        out.println();
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                List uniqueKeys = table.getUniqueKeys();
                for (UniqueKeyDefinition uniqueKey : uniqueKeys) {
                    keyType = this.getStrategy().getFullJavaClassName((Definition)uniqueKey.getTable(), GeneratorStrategy.Mode.RECORD);
                    String keyId = this.getStrategy().getJavaIdentifier((Definition)uniqueKey);
                    int block = allUniqueKeys.size() / 500;
                    ((JavaWriter)out.tab(1)).println("public static final %s<%s> %s = UniqueKeys%s.%s;", UniqueKey.class, keyType, keyId, block, keyId);
                    allUniqueKeys.add(uniqueKey);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table " + table), (Throwable)e);
            }
        }
        ((JavaWriter)out.tab(1)).header("FOREIGN KEY definitions", new Object[0]);
        out.println();
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                List foreignKeys = table.getForeignKeys();
                for (ForeignKeyDefinition foreignKey : foreignKeys) {
                    keyType = this.getStrategy().getFullJavaClassName((Definition)foreignKey.getKeyTable(), GeneratorStrategy.Mode.RECORD);
                    String referencedType = this.getStrategy().getFullJavaClassName((Definition)foreignKey.getReferencedTable(), GeneratorStrategy.Mode.RECORD);
                    String keyId = this.getStrategy().getJavaIdentifier((Definition)foreignKey);
                    int block = allForeignKeys.size() / 500;
                    ((JavaWriter)out.tab(1)).println("public static final %s<%s, %s> %s = ForeignKeys%s.%s;", ForeignKey.class, keyType, referencedType, keyId, block, keyId);
                    allForeignKeys.add(foreignKey);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while generating reference " + table), (Throwable)e);
            }
        }
        int identityCounter = 0;
        int uniqueKeyCounter = 0;
        int foreignKeyCounter = 0;
        ((JavaWriter)out.tab(1)).header("[#1459] distribute members to avoid static initialisers > 64kb", new Object[0]);
        for (IdentityDefinition identity : allIdentities) {
            this.printIdentity(out, identityCounter, identity);
            ++identityCounter;
        }
        if (identityCounter > 0) {
            out.println("\t}");
        }
        for (UniqueKeyDefinition uniqueKey : allUniqueKeys) {
            this.printUniqueKey(out, uniqueKeyCounter, uniqueKey);
            ++uniqueKeyCounter;
        }
        if (uniqueKeyCounter > 0) {
            out.println("\t}");
        }
        for (ForeignKeyDefinition foreignKey : allForeignKeys) {
            this.printForeignKey(out, foreignKeyCounter, foreignKey);
            ++foreignKeyCounter;
        }
        if (foreignKeyCounter > 0) {
            out.println("\t}");
        }
        out.println("}");
        out.close();
        this.watch.splitInfo("Keys generated");
    }

    protected void printIdentity(JavaWriter out, int identityCounter, IdentityDefinition identity) {
        int block = identityCounter / 500;
        if (identityCounter % 500 == 0) {
            if (identityCounter > 0) {
                ((JavaWriter)out.tab(1)).println("}");
            }
            out.println();
            ((JavaWriter)out.tab(1)).println("private static class Identities%s extends %s {", block, AbstractKeys.class);
        }
        ((JavaWriter)out.tab(2)).println("public static %s<%s, %s> %s = createIdentity(%s, %s);", Identity.class, this.getStrategy().getFullJavaClassName((Definition)identity.getTable(), GeneratorStrategy.Mode.RECORD), this.getJavaType(identity.getColumn().getType()), this.getStrategy().getJavaIdentifier((Definition)identity), this.getStrategy().getFullJavaIdentifier(identity.getColumn().getContainer()), this.getStrategy().getFullJavaIdentifier((Definition)identity.getColumn()));
    }

    protected void printUniqueKey(JavaWriter out, int uniqueKeyCounter, UniqueKeyDefinition uniqueKey) {
        int block = uniqueKeyCounter / 500;
        if (uniqueKeyCounter % 500 == 0) {
            if (uniqueKeyCounter > 0) {
                ((JavaWriter)out.tab(1)).println("}");
            }
            out.println();
            ((JavaWriter)out.tab(1)).println("private static class UniqueKeys%s extends %s {", block, AbstractKeys.class);
        }
        ((JavaWriter)out.tab(2)).println("public static final %s<%s> %s = createUniqueKey(%s, [[%s]]);", UniqueKey.class, this.getStrategy().getFullJavaClassName((Definition)uniqueKey.getTable(), GeneratorStrategy.Mode.RECORD), this.getStrategy().getJavaIdentifier((Definition)uniqueKey), this.getStrategy().getFullJavaIdentifier((Definition)uniqueKey.getTable()), this.getStrategy().getFullJavaIdentifiers(uniqueKey.getKeyColumns()));
    }

    protected void printForeignKey(JavaWriter out, int foreignKeyCounter, ForeignKeyDefinition foreignKey) {
        int block = foreignKeyCounter / 500;
        if (foreignKeyCounter % 500 == 0) {
            if (foreignKeyCounter > 0) {
                ((JavaWriter)out.tab(1)).println("}");
            }
            out.println();
            ((JavaWriter)out.tab(1)).println("private static class ForeignKeys%s extends %s {", block, AbstractKeys.class);
        }
        ((JavaWriter)out.tab(2)).println("public static final %s<%s, %s> %s = createForeignKey(%s, %s, [[%s]]);", ForeignKey.class, this.getStrategy().getFullJavaClassName((Definition)foreignKey.getKeyTable(), GeneratorStrategy.Mode.RECORD), this.getStrategy().getFullJavaClassName((Definition)foreignKey.getReferencedTable(), GeneratorStrategy.Mode.RECORD), this.getStrategy().getJavaIdentifier((Definition)foreignKey), this.getStrategy().getFullJavaIdentifier((Definition)foreignKey.getReferencedKey()), this.getStrategy().getFullJavaIdentifier((Definition)foreignKey.getKeyTable()), this.getStrategy().getFullJavaIdentifiers(foreignKey.getKeyColumns()));
    }

    protected void generateRecords(SchemaDefinition schema) {
        log.info((Object)"Generating records");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateRecord(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table record " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table records generated");
    }

    protected void generateRecord(TableDefinition table) {
        String columnMember;
        int i;
        ColumnDefinition column;
        int keyDegree;
        ColumnDefinition column2;
        int i2;
        log.info((Object)"Generating record", (Object)this.getStrategy().getFileName((Definition)table, GeneratorStrategy.Mode.RECORD));
        UniqueKeyDefinition key = table.getPrimaryKey();
        String className = this.getStrategy().getJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD);
        String tableIdentifier = this.getStrategy().getFullJavaIdentifier((Definition)table);
        String recordType = this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD);
        List<String> interfaces = this.getStrategy().getJavaClassImplements((Definition)table, GeneratorStrategy.Mode.RECORD);
        JavaWriter out = new JavaWriter(this.getStrategy().getFile((Definition)table, GeneratorStrategy.Mode.RECORD));
        this.printPackage(out, (Definition)table, GeneratorStrategy.Mode.RECORD);
        this.printClassJavadoc(out, (Definition)table);
        this.printTableJPAAnnotation(out, table);
        Class baseClass = this.generateRelations() && key != null ? UpdatableRecordImpl.class : TableRecordImpl.class;
        int degree = table.getColumns().size();
        String rowType = null;
        String rowTypeRecord = null;
        if (degree <= 22) {
            rowType = this.getRowType(table.getColumns());
            rowTypeRecord = Record.class.getName() + degree + "<" + rowType + ">";
            interfaces.add(rowTypeRecord);
        }
        if (this.generateInterfaces()) {
            interfaces.add(this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.INTERFACE));
        }
        out.println("public class %s extends %s<%s>[[before= implements ][%s]] {", className, baseClass, recordType, interfaces);
        out.printSerial();
        for (i2 = 0; i2 < degree; ++i2) {
            column2 = table.getColumn(i2);
            String comment = StringUtils.defaultString((String)column2.getComment());
            String setterReturnType = this.fluentSetters() ? className : "void";
            String setter = this.getStrategy().getJavaSetterName((Definition)column2, GeneratorStrategy.Mode.DEFAULT);
            String getter = this.getStrategy().getJavaGetterName((Definition)column2, GeneratorStrategy.Mode.DEFAULT);
            String type = this.getJavaType(column2.getType());
            String name = column2.getQualifiedOutputName();
            ((JavaWriter)out.tab(1)).javadoc("Setter for <code>%s</code>.%s", name, StringUtils.defaultIfBlank((String)(" " + comment), (String)""));
            ((JavaWriter)out.tab(1)).overrideIf(this.generateInterfaces() && !this.generateImmutablePojos());
            ((JavaWriter)out.tab(1)).println("public %s %s(%s value) {", setterReturnType, setter, type);
            ((JavaWriter)out.tab(2)).println("setValue(%s, value);", i2);
            if (this.fluentSetters()) {
                ((JavaWriter)out.tab(2)).println("return this;");
            }
            ((JavaWriter)out.tab(1)).println("}");
            ((JavaWriter)out.tab(1)).javadoc("Getter for <code>%s</code>.%s", name, StringUtils.defaultIfBlank((String)(" " + comment), (String)""));
            this.printColumnJPAAnnotation(out, column2);
            this.printColumnValidationAnnotation(out, column2);
            ((JavaWriter)out.tab(1)).overrideIf(this.generateInterfaces());
            ((JavaWriter)out.tab(1)).println("public %s %s() {", type, getter);
            ((JavaWriter)out.tab(2)).println("return (%s) getValue(%s);", type, i2);
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.generateRelations() && key != null && (keyDegree = key.getKeyColumns().size()) <= 22) {
            String keyType = this.getRowType(key.getKeyColumns());
            ((JavaWriter)out.tab(1)).header("Primary key information", new Object[0]);
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s%s<%s> key() {", Record.class, keyDegree, keyType);
            ((JavaWriter)out.tab(2)).println("return (%s%s) super.key();", Record.class, keyDegree);
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (degree <= 22) {
            String colType;
            ((JavaWriter)out.tab(1)).header("Record%s type implementation", degree);
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s%s<%s> fieldsRow() {", Row.class, degree, rowType);
            ((JavaWriter)out.tab(2)).println("return (%s%s) super.fieldsRow();", Row.class, degree);
            ((JavaWriter)out.tab(1)).println("}");
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s%s<%s> valuesRow() {", Row.class, degree, rowType);
            ((JavaWriter)out.tab(2)).println("return (%s%s) super.valuesRow();", Row.class, degree);
            ((JavaWriter)out.tab(1)).println("}");
            for (i2 = 1; i2 <= degree; ++i2) {
                column2 = table.getColumn(i2 - 1);
                colType = this.getJavaType(column2.getType());
                String colIdentifier = this.getStrategy().getFullJavaIdentifier((Definition)column2);
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public %s<%s> field%s() {", Field.class, colType, i2);
                ((JavaWriter)out.tab(2)).println("return %s;", colIdentifier);
                ((JavaWriter)out.tab(1)).println("}");
            }
            for (i2 = 1; i2 <= degree; ++i2) {
                column2 = table.getColumn(i2 - 1);
                colType = this.getJavaType(column2.getType());
                String colGetter = this.getStrategy().getJavaGetterName((Definition)column2, GeneratorStrategy.Mode.RECORD);
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public %s value%s() {", colType, i2);
                ((JavaWriter)out.tab(2)).println("return %s();", colGetter);
                ((JavaWriter)out.tab(1)).println("}");
            }
            for (i2 = 1; i2 <= degree; ++i2) {
                column2 = table.getColumn(i2 - 1);
                colType = this.getJavaType(column2.getType());
                String colSetter = this.getStrategy().getJavaSetterName((Definition)column2, GeneratorStrategy.Mode.RECORD);
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public %s value%s(%s value) {", className, i2, colType);
                ((JavaWriter)out.tab(2)).println("%s(value);", colSetter);
                ((JavaWriter)out.tab(2)).println("return this;");
                ((JavaWriter)out.tab(1)).println("}");
            }
            ArrayList<String> arguments = new ArrayList<String>();
            for (int i3 = 1; i3 <= degree; ++i3) {
                column = table.getColumn(i3 - 1);
                String colType2 = this.getJavaType(column.getType());
                arguments.add(colType2 + " value" + i3);
            }
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s values([[%s]]) {", className, arguments);
            ((JavaWriter)out.tab(2)).println("return this;");
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.generateInterfaces() && !this.generateImmutablePojos()) {
            this.printFromAndInto(out, table);
        }
        ((JavaWriter)out.tab(1)).header("Constructors", new Object[0]);
        ((JavaWriter)out.tab(1)).javadoc("Create a detached %s", className);
        ((JavaWriter)out.tab(1)).println("public %s() {", className);
        ((JavaWriter)out.tab(2)).println("super(%s);", tableIdentifier);
        ((JavaWriter)out.tab(1)).println("}");
        ArrayList<String> arguments = new ArrayList<String>();
        for (i = 0; i < degree; ++i) {
            column = table.getColumn(i);
            columnMember = this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.DEFAULT);
            String type = this.getJavaType(column.getType());
            arguments.add(type + " " + columnMember);
        }
        ((JavaWriter)out.tab(1)).javadoc("Create a detached, initialised %s", className);
        ((JavaWriter)out.tab(1)).println("public %s([[%s]]) {", className, arguments);
        ((JavaWriter)out.tab(2)).println("super(%s);", tableIdentifier);
        out.println();
        for (i = 0; i < degree; ++i) {
            column = table.getColumn(i);
            columnMember = this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.DEFAULT);
            ((JavaWriter)out.tab(2)).println("setValue(%s, %s);", i, columnMember);
        }
        ((JavaWriter)out.tab(1)).println("}");
        this.generateRecordClassFooter(table, out);
        out.println("}");
        out.close();
    }

    protected void generateRecordClassFooter(TableDefinition table, JavaWriter out) {
    }

    private final String getRowType(Collection<? extends ColumnDefinition> columns) {
        StringBuilder result = new StringBuilder();
        String separator = "";
        for (ColumnDefinition columnDefinition : columns) {
            result.append(separator);
            result.append(this.getJavaType(columnDefinition.getType()));
            separator = ", ";
        }
        return result.toString();
    }

    protected void generateInterfaces(SchemaDefinition schema) {
        log.info((Object)"Generating interfaces");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateInterface(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table record " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table records generated");
    }

    protected void generateInterface(TableDefinition table) {
        log.info((Object)"Generating interface", (Object)this.getStrategy().getFileName((Definition)table, GeneratorStrategy.Mode.INTERFACE));
        String className = this.getStrategy().getJavaClassName((Definition)table, GeneratorStrategy.Mode.INTERFACE);
        List<String> interfaces = this.getStrategy().getJavaClassImplements((Definition)table, GeneratorStrategy.Mode.INTERFACE);
        JavaWriter out = new JavaWriter(this.getStrategy().getFile((Definition)table, GeneratorStrategy.Mode.INTERFACE));
        this.printPackage(out, (Definition)table, GeneratorStrategy.Mode.INTERFACE);
        this.printClassJavadoc(out, (Definition)table);
        this.printTableJPAAnnotation(out, table);
        out.println("public interface %s [[before=extends ][%s]] {", className, interfaces);
        for (ColumnDefinition column : table.getColumns()) {
            String comment = StringUtils.defaultString((String)column.getComment());
            String setterReturnType = this.fluentSetters() ? className : "void";
            String setter = this.getStrategy().getJavaSetterName((Definition)column, GeneratorStrategy.Mode.DEFAULT);
            String getter = this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.DEFAULT);
            String type = this.getJavaType(column.getType());
            String name = column.getQualifiedOutputName();
            if (!this.generateImmutablePojos()) {
                ((JavaWriter)out.tab(1)).javadoc("Setter for <code>%s</code>.%s", name, StringUtils.defaultIfBlank((String)(" " + comment), (String)""));
                ((JavaWriter)out.tab(1)).println("public %s %s(%s value);", setterReturnType, setter, type);
            }
            ((JavaWriter)out.tab(1)).javadoc("Getter for <code>%s</code>.%s", name, StringUtils.defaultIfBlank((String)(" " + comment), (String)""));
            this.printColumnJPAAnnotation(out, column);
            this.printColumnValidationAnnotation(out, column);
            ((JavaWriter)out.tab(1)).println("public %s %s();", type, getter);
        }
        if (!this.generateImmutablePojos()) {
            String local = this.getStrategy().getJavaClassName((Definition)table, GeneratorStrategy.Mode.INTERFACE);
            String qualified = this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.INTERFACE);
            ((JavaWriter)out.tab(1)).header("FROM and INTO", new Object[0]);
            ((JavaWriter)out.tab(1)).javadoc("Load data from another generated Record/POJO implementing the common interface %s", local);
            ((JavaWriter)out.tab(1)).println("public void from(%s from);", qualified);
            ((JavaWriter)out.tab(1)).javadoc("Copy data into another generated Record/POJO implementing the common interface %s", local);
            ((JavaWriter)out.tab(1)).println("public <E extends %s> E into(E into);", qualified);
        }
        this.generateInterfaceClassFooter(table, out);
        out.println("}");
        out.close();
    }

    protected void generateInterfaceClassFooter(TableDefinition table, JavaWriter out) {
    }

    protected void generateUDTs(SchemaDefinition schema) {
        log.info((Object)"Generating UDTs");
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            try {
                this.generateUDT(schema, udt);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating udt " + udt), (Throwable)e);
            }
        }
        this.watch.splitInfo("UDTs generated");
    }

    protected void generateUDT(SchemaDefinition schema, UDTDefinition udt) {
        log.info((Object)"Generating UDT ", (Object)this.getStrategy().getFileName((Definition)udt));
        String className = this.getStrategy().getJavaClassName((Definition)udt);
        String recordType = this.getStrategy().getFullJavaClassName((Definition)udt, GeneratorStrategy.Mode.RECORD);
        List<String> interfaces = this.getStrategy().getJavaClassImplements((Definition)udt, GeneratorStrategy.Mode.DEFAULT);
        String schemaId = this.getStrategy().getFullJavaIdentifier((Definition)schema);
        String udtId = this.getStrategy().getJavaIdentifier((Definition)udt);
        JavaWriter out = new JavaWriter(this.getStrategy().getFile((Definition)udt));
        this.printPackage(out, (Definition)udt);
        this.printClassJavadoc(out, (Definition)udt);
        if (udt.getRoutines().size() > 0) {
            interfaces.add(Package.class.getName());
        }
        out.println("public class %s extends %s<%s>[[before= implements ][%s]] {", className, UDTImpl.class, recordType, interfaces);
        out.printSerial();
        this.printSingletonInstance(out, (Definition)udt);
        this.printRecordTypeMethod(out, (Definition)udt);
        for (AttributeDefinition attribute : udt.getAttributes()) {
            String attrType = this.getJavaType(attribute.getType());
            String attrTypeRef = this.getJavaTypeReference(attribute.getDatabase(), attribute.getType());
            String attrId = this.getStrategy().getJavaIdentifier((Definition)attribute);
            String attrName = attribute.getName();
            String attrComment = StringUtils.defaultString((String)attribute.getComment());
            ((JavaWriter)out.tab(1)).javadoc("The attribute <code>%s</code>.%s", attribute.getQualifiedOutputName(), StringUtils.defaultIfBlank((String)(" " + attrComment), (String)""));
            ((JavaWriter)out.tab(1)).println("public static final %s<%s, %s> %s = createField(\"%s\", %s, %s);", UDTField.class, recordType, attrType, attrId, attrName, attrTypeRef, udtId);
        }
        for (RoutineDefinition routine : udt.getRoutines()) {
            try {
                if (!routine.isSQLUsable()) {
                    this.printConvenienceMethodProcedure(out, routine, false);
                    continue;
                }
                if (!routine.isAggregate()) {
                    this.printConvenienceMethodFunction(out, routine, false);
                }
                this.printConvenienceMethodFunctionAsField(out, routine, false);
                this.printConvenienceMethodFunctionAsField(out, routine, true);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating routine " + routine), (Throwable)e);
            }
        }
        ((JavaWriter)out.tab(1)).javadoc(NO_FURTHER_INSTANCES_ALLOWED, new Object[0]);
        ((JavaWriter)out.tab(1)).println("private %s() {", className);
        ((JavaWriter)out.tab(2)).println("super(\"%s\", %s);", udt.getOutputName(), schemaId);
        out.println();
        ((JavaWriter)out.tab(2)).println("// Initialise data type");
        ((JavaWriter)out.tab(2)).println("getDataType();");
        ((JavaWriter)out.tab(1)).println("}");
        this.generateUDTClassFooter(udt, out);
        out.println("}");
        out.close();
    }

    protected void generateUDTClassFooter(UDTDefinition udt, JavaWriter out) {
    }

    protected void generateUDTRecords(SchemaDefinition schema) {
        log.info((Object)"Generating UDT records");
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            try {
                this.generateUDTRecord(udt);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating UDT record " + udt), (Throwable)e);
            }
        }
        this.watch.splitInfo("UDT records generated");
    }

    protected void generateUDTRecord(UDTDefinition udt) {
        log.info((Object)"Generating UDT record", (Object)this.getStrategy().getFileName((Definition)udt, GeneratorStrategy.Mode.RECORD));
        String className = this.getStrategy().getJavaClassName((Definition)udt, GeneratorStrategy.Mode.RECORD);
        String recordType = this.getStrategy().getFullJavaClassName((Definition)udt, GeneratorStrategy.Mode.RECORD);
        List<String> interfaces = this.getStrategy().getJavaClassImplements((Definition)udt, GeneratorStrategy.Mode.RECORD);
        String udtId = this.getStrategy().getFullJavaIdentifier((Definition)udt);
        JavaWriter out = new JavaWriter(this.getStrategy().getFile((Definition)udt, GeneratorStrategy.Mode.RECORD));
        this.printPackage(out, (Definition)udt, GeneratorStrategy.Mode.RECORD);
        this.printClassJavadoc(out, (Definition)udt);
        out.println("public class %s extends %s<%s>[[before= implements ][%s]] {", className, UDTRecordImpl.class, recordType, interfaces);
        out.printSerial();
        out.println();
        for (AttributeDefinition attribute : udt.getAttributes()) {
            String comment = StringUtils.defaultString((String)attribute.getComment());
            String setterReturnType = this.fluentSetters() ? className : "void";
            String setter = this.getStrategy().getJavaSetterName((Definition)attribute, GeneratorStrategy.Mode.DEFAULT);
            String getter = this.getStrategy().getJavaGetterName((Definition)attribute, GeneratorStrategy.Mode.DEFAULT);
            String type = this.getJavaType(attribute.getType());
            String id = this.getStrategy().getFullJavaIdentifier((Definition)attribute);
            String name = attribute.getQualifiedOutputName();
            ((JavaWriter)out.tab(1)).javadoc("Setter for <code>%s</code>.%s", name, StringUtils.defaultIfBlank((String)(" " + comment), (String)""));
            ((JavaWriter)out.tab(1)).println("public %s %s(%s value) {", setterReturnType, setter, type);
            ((JavaWriter)out.tab(2)).println("setValue(%s, value);", id);
            if (this.fluentSetters()) {
                ((JavaWriter)out.tab(2)).println("return this;");
            }
            ((JavaWriter)out.tab(1)).println("}");
            ((JavaWriter)out.tab(1)).javadoc("Getter for <code>%s</code>.%s", name, StringUtils.defaultIfBlank((String)(" " + comment), (String)""));
            ((JavaWriter)out.tab(1)).println("public %s %s() {", type, getter);
            ((JavaWriter)out.tab(2)).println("return getValue(%s);", id);
            ((JavaWriter)out.tab(1)).println("}");
        }
        for (RoutineDefinition routine : udt.getRoutines()) {
            boolean instance = routine.getInParameters().size() > 0 && ((ParameterDefinition)routine.getInParameters().get(0)).getInputName().toUpperCase().equals("SELF");
            try {
                if (!routine.isSQLUsable()) {
                    this.printConvenienceMethodProcedure(out, routine, instance);
                    continue;
                }
                if (routine.isAggregate()) continue;
                this.printConvenienceMethodFunction(out, routine, instance);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating routine " + routine), (Throwable)e);
            }
        }
        ((JavaWriter)out.tab(1)).javadoc("Create a new <code>%s</code> record", udt.getQualifiedOutputName());
        ((JavaWriter)out.tab(1)).println("public %s() {", className);
        ((JavaWriter)out.tab(2)).println("super(%s);", udtId);
        ((JavaWriter)out.tab(1)).println("}");
        this.generateUDTRecordClassFooter(udt, out);
        out.println("}");
        out.close();
    }

    protected void generateUDTRecordClassFooter(UDTDefinition udt, JavaWriter out) {
    }

    protected void generateUDTRoutines(SchemaDefinition schema) {
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            if (udt.getRoutines().size() <= 0) continue;
            try {
                log.info((Object)"Generating member routines");
                for (RoutineDefinition routine : udt.getRoutines()) {
                    try {
                        this.generateRoutine(schema, routine);
                    }
                    catch (Exception e) {
                        log.error((Object)("Error while generating member routines " + routine), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while generating UDT " + udt), (Throwable)e);
            }
            this.watch.splitInfo("Member procedures routines");
        }
    }

    protected void generateUDTReferences(SchemaDefinition schema) {
        log.info((Object)"Generating UDT references");
        JavaWriter out = new JavaWriter(new File(this.getStrategy().getFile((Definition)schema).getParentFile(), "UDTs.java"));
        this.printPackage(out, (Definition)schema);
        this.printClassJavadoc(out, "Convenience access to all UDTs in " + schema.getOutputName());
        out.println("public class UDTs {");
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            String className = this.getStrategy().getFullJavaClassName((Definition)udt);
            String id = this.getStrategy().getJavaIdentifier((Definition)udt);
            String fullId = this.getStrategy().getFullJavaIdentifier((Definition)udt);
            ((JavaWriter)out.tab(1)).javadoc("The type <code>%s</code>", udt.getQualifiedOutputName());
            ((JavaWriter)out.tab(1)).println("public static %s %s = %s;", className, id, fullId);
        }
        out.println("}");
        out.close();
        this.watch.splitInfo("UDT references generated");
    }

    protected void generateArrays(SchemaDefinition schema) {
        log.info((Object)"Generating ARRAYs");
        for (ArrayDefinition array : this.database.getArrays(schema)) {
            try {
                this.generateArray(schema, array);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating ARRAY record " + array), (Throwable)e);
            }
        }
        this.watch.splitInfo("ARRAYs generated");
    }

    protected void generateArray(SchemaDefinition schema, ArrayDefinition array) {
        log.info((Object)"Generating ARRAY", (Object)this.getStrategy().getFileName((Definition)array, GeneratorStrategy.Mode.RECORD));
    }

    protected void generateArrayClassFooter(ArrayDefinition array, JavaWriter out) {
    }

    protected void generateEnums(SchemaDefinition schema) {
        log.info((Object)"Generating ENUMs");
        for (EnumDefinition e : this.database.getEnums(schema)) {
            try {
                this.generateEnum(e);
            }
            catch (Exception ex) {
                log.error((Object)("Error while generating enum " + e), (Throwable)ex);
            }
        }
        this.watch.splitInfo("Enums generated");
    }

    protected void generateEnum(EnumDefinition e) {
        log.info((Object)"Generating ENUM", (Object)this.getStrategy().getFileName((Definition)e, GeneratorStrategy.Mode.ENUM));
        String className = this.getStrategy().getJavaClassName((Definition)e, GeneratorStrategy.Mode.ENUM);
        List<String> interfaces = this.getStrategy().getJavaClassImplements((Definition)e, GeneratorStrategy.Mode.ENUM);
        JavaWriter out = new JavaWriter(this.getStrategy().getFile((Definition)e, GeneratorStrategy.Mode.ENUM));
        this.printPackage(out, (Definition)e);
        this.printClassJavadoc(out, (Definition)e);
        interfaces.add(EnumType.class.getName());
        out.println("public enum %s[[before= implements ][%s]] {", className, interfaces);
        List literals = e.getLiterals();
        for (int i = 0; i < literals.size(); ++i) {
            String literal = (String)literals.get(i);
            String terminator = i == literals.size() - 1 ? ";" : ",";
            String identifier = GenerationUtil.convertToJavaIdentifier(literal);
            if (identifier.equals(this.getStrategy().getJavaPackageName((Definition)e).replaceAll("\\..*", ""))) {
                identifier = identifier + "_";
            }
            out.println();
            ((JavaWriter)out.tab(1)).println("%s(\"%s\")%s", identifier, literal, terminator);
        }
        out.println();
        ((JavaWriter)out.tab(1)).println("private final java.lang.String literal;");
        out.println();
        ((JavaWriter)out.tab(1)).println("private %s(java.lang.String literal) {", className);
        ((JavaWriter)out.tab(2)).println("this.literal = literal;");
        ((JavaWriter)out.tab(1)).println("}");
        ((JavaWriter)out.tab(1)).overrideInherit();
        ((JavaWriter)out.tab(1)).println("public %s getSchema() {", Schema.class);
        ((JavaWriter)out.tab(2)).println("return %s;", e.isSynthetic() || !(e.getDatabase() instanceof PostgresDatabase) ? "null" : this.getStrategy().getFullJavaIdentifier((Definition)e.getSchema()));
        ((JavaWriter)out.tab(1)).println("}");
        ((JavaWriter)out.tab(1)).overrideInherit();
        ((JavaWriter)out.tab(1)).println("public java.lang.String getName() {");
        ((JavaWriter)out.tab(2)).println("return %s;", e.isSynthetic() ? "null" : "\"" + e.getName().replace("\"", "\\\"") + "\"");
        ((JavaWriter)out.tab(1)).println("}");
        ((JavaWriter)out.tab(1)).overrideInherit();
        ((JavaWriter)out.tab(1)).println("public java.lang.String getLiteral() {");
        ((JavaWriter)out.tab(2)).println("return literal;");
        ((JavaWriter)out.tab(1)).println("}");
        this.generateEnumClassFooter(e, out);
        out.println("}");
        out.close();
    }

    protected void generateEnumClassFooter(EnumDefinition e, JavaWriter out) {
    }

    protected void generateRoutines(SchemaDefinition schema) {
        log.info((Object)"Generating routines and table-valued functions");
        JavaWriter outR = new JavaWriter(new File(this.getStrategy().getFile((Definition)schema).getParentFile(), "Routines.java"));
        this.printPackage(outR, (Definition)schema);
        this.printClassJavadoc(outR, "Convenience access to all stored procedures and functions in " + schema.getOutputName());
        outR.println("public class Routines {");
        for (RoutineDefinition routine : this.database.getRoutines(schema)) {
            this.printRoutine(outR, routine);
            try {
                this.generateRoutine(schema, routine);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating routine " + routine), (Throwable)e);
            }
        }
        for (TableDefinition table : this.database.getTables(schema)) {
            if (!table.isTableValuedFunction()) continue;
            this.printTableValuedFunction(outR, table);
        }
        outR.println("}");
        outR.close();
        this.watch.splitInfo("Routines generated");
    }

    protected void printRoutine(JavaWriter out, RoutineDefinition routine) {
        if (!routine.isSQLUsable()) {
            this.printConvenienceMethodProcedure(out, routine, false);
        } else {
            if (!routine.isAggregate()) {
                this.printConvenienceMethodFunction(out, routine, false);
            }
            this.printConvenienceMethodFunctionAsField(out, routine, false);
            this.printConvenienceMethodFunctionAsField(out, routine, true);
        }
    }

    protected void printTableValuedFunction(JavaWriter out, TableDefinition table) {
        this.printConvenienceMethodTableValuedFunctionAsField(out, table, false);
        this.printConvenienceMethodTableValuedFunctionAsField(out, table, true);
    }

    protected void generatePackages(SchemaDefinition schema) {
        log.info((Object)"Generating packages");
        for (PackageDefinition pkg : this.database.getPackages(schema)) {
            try {
                this.generatePackage(schema, pkg);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating package " + pkg), (Throwable)e);
            }
        }
        this.watch.splitInfo("Packages generated");
    }

    protected void generatePackage(SchemaDefinition schema, PackageDefinition pkg) {
        log.info((Object)"Generating package", (Object)pkg);
        String className = this.getStrategy().getJavaClassName((Definition)pkg);
        String schemaIdentifier = this.getStrategy().getFullJavaIdentifier((Definition)schema);
        List<String> interfaces = this.getStrategy().getJavaClassImplements((Definition)pkg, GeneratorStrategy.Mode.DEFAULT);
        JavaWriter out = new JavaWriter(this.getStrategy().getFile((Definition)pkg));
        this.printPackage(out, (Definition)pkg);
        this.printClassJavadoc(out, "Convenience access to all stored procedures and functions in " + pkg.getName());
        out.println("public class %s extends %s[[before= implements ][%s]] {", className, PackageImpl.class, interfaces);
        out.printSerial();
        this.printSingletonInstance(out, (Definition)pkg);
        for (RoutineDefinition routine : pkg.getRoutines()) {
            this.printRoutine(out, routine);
            try {
                this.generateRoutine(schema, routine);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating routine " + routine), (Throwable)e);
            }
        }
        ((JavaWriter)out.tab(1)).javadoc(NO_FURTHER_INSTANCES_ALLOWED, new Object[0]);
        ((JavaWriter)out.tab(1)).println("private %s() {", className);
        ((JavaWriter)out.tab(2)).println("super(\"%s\", %s);", pkg.getOutputName(), schemaIdentifier);
        ((JavaWriter)out.tab(1)).println("}");
        this.generatePackageClassFooter(pkg, out);
        out.println("}");
        out.close();
    }

    protected void generatePackageClassFooter(PackageDefinition pkg, JavaWriter out) {
    }

    protected void generateTableReferences(SchemaDefinition schema) {
        log.info((Object)"Generating table references");
        JavaWriter out = new JavaWriter(new File(this.getStrategy().getFile((Definition)schema).getParentFile(), "Tables.java"));
        this.printPackage(out, (Definition)schema);
        this.printClassJavadoc(out, "Convenience access to all tables in " + schema.getOutputName());
        out.println("public class Tables {");
        for (TableDefinition table : this.database.getTables(schema)) {
            String className = this.getStrategy().getFullJavaClassName((Definition)table);
            String id = this.getStrategy().getJavaIdentifier((Definition)table);
            String fullId = this.getStrategy().getFullJavaIdentifier((Definition)table);
            String comment = !StringUtils.isBlank((String)table.getComment()) ? table.getComment() : "The table " + table.getQualifiedOutputName();
            ((JavaWriter)out.tab(1)).javadoc(comment, new Object[0]);
            ((JavaWriter)out.tab(1)).println("public static final %s %s = %s;", className, id, fullId);
        }
        out.println("}");
        out.close();
        this.watch.splitInfo("Table refs generated");
    }

    protected void generateDaos(SchemaDefinition schema) {
        log.info((Object)"Generating DAOs");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateDao(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table DAO " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table DAOs generated");
    }

    protected void generateDao(TableDefinition table) {
        List columns;
        String className = this.getStrategy().getJavaClassName((Definition)table, GeneratorStrategy.Mode.DAO);
        String tableRecord = this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD);
        String daoImpl = DAOImpl.class.getName();
        String tableIdentifier = this.getStrategy().getFullJavaIdentifier((Definition)table);
        String tType = "Void";
        String pType = this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO);
        UniqueKeyDefinition key = table.getPrimaryKey();
        ColumnDefinition keyColumn = null;
        if (key != null && (columns = key.getKeyColumns()).size() == 1) {
            keyColumn = (ColumnDefinition)columns.get(0);
            tType = this.getJavaType(keyColumn.getType());
        }
        if (keyColumn == null) {
            log.info((Object)"Skipping DAO generation", (Object)this.getStrategy().getFileName((Definition)table, GeneratorStrategy.Mode.DAO));
            return;
        }
        log.info((Object)"Generating DAO", (Object)this.getStrategy().getFileName((Definition)table, GeneratorStrategy.Mode.DAO));
        JavaWriter out = new JavaWriter(this.getStrategy().getFile((Definition)table, GeneratorStrategy.Mode.DAO));
        this.printPackage(out, (Definition)table, GeneratorStrategy.Mode.DAO);
        this.printClassJavadoc(out, (Definition)table);
        out.println("public class %s extends %s<%s, %s, %s> {", className, daoImpl, tableRecord, pType, tType);
        ((JavaWriter)out.tab(1)).javadoc("Create a new %s without any configuration", className);
        ((JavaWriter)out.tab(1)).println("public %s() {", className);
        ((JavaWriter)out.tab(2)).println("super(%s, %s.class);", tableIdentifier, pType);
        ((JavaWriter)out.tab(1)).println("}");
        ((JavaWriter)out.tab(1)).javadoc("Create a new %s with an attached configuration", className);
        ((JavaWriter)out.tab(1)).println("public %s(%s configuration) {", className, Configuration.class);
        ((JavaWriter)out.tab(2)).println("super(%s, %s.class, configuration);", tableIdentifier, pType);
        ((JavaWriter)out.tab(1)).println("}");
        ((JavaWriter)out.tab(1)).overrideInherit();
        ((JavaWriter)out.tab(1)).println("protected %s getId(%s object) {", tType, pType);
        ((JavaWriter)out.tab(2)).println("return object.%s();", this.getStrategy().getJavaGetterName((Definition)keyColumn, GeneratorStrategy.Mode.POJO));
        ((JavaWriter)out.tab(1)).println("}");
        block0: for (ColumnDefinition column : table.getColumns()) {
            String colName = column.getOutputName();
            String colClass = this.getStrategy().getJavaClassName((Definition)column, GeneratorStrategy.Mode.POJO);
            String colType = this.getJavaType(column.getType());
            String colIdentifier = this.getStrategy().getFullJavaIdentifier((Definition)column);
            ((JavaWriter)out.tab(1)).javadoc("Fetch records that have <code>%s IN (values)</code>", colName);
            ((JavaWriter)out.tab(1)).println("public %s<%s> fetchBy%s(%s... values) {", List.class, pType, colClass, colType);
            ((JavaWriter)out.tab(2)).println("return fetch(%s, values);", colIdentifier);
            ((JavaWriter)out.tab(1)).println("}");
            for (UniqueKeyDefinition uk : column.getUniqueKeys()) {
                if (uk.getKeyColumns().size() != 1 || !((ColumnDefinition)uk.getKeyColumns().get(0)).equals(column)) continue;
                ((JavaWriter)out.tab(1)).javadoc("Fetch a unique record that has <code>%s = value</code>", colName);
                ((JavaWriter)out.tab(1)).println("public %s fetchOneBy%s(%s value) {", pType, colClass, colType);
                ((JavaWriter)out.tab(2)).println("return fetchOne(%s, value);", colIdentifier);
                ((JavaWriter)out.tab(1)).println("}");
                continue block0;
            }
        }
        this.generateDaoClassFooter(table, out);
        out.println("}");
        out.close();
    }

    protected void generateDaoClassFooter(TableDefinition table, JavaWriter out) {
    }

    protected void generatePojos(SchemaDefinition schema) {
        log.info((Object)"Generating table POJOs");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generatePojo(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table POJO " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table POJOs generated");
    }

    protected void generatePojo(TableDefinition table) {
        log.info((Object)"Generating table POJO", (Object)this.getStrategy().getFileName((Definition)table, GeneratorStrategy.Mode.POJO));
        String className = this.getStrategy().getJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO);
        String superName = this.getStrategy().getJavaClassExtends((Definition)table, GeneratorStrategy.Mode.POJO);
        List<String> interfaces = this.getStrategy().getJavaClassImplements((Definition)table, GeneratorStrategy.Mode.POJO);
        if (this.generateInterfaces()) {
            interfaces.add(this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.INTERFACE));
        }
        JavaWriter out = new JavaWriter(this.getStrategy().getFile((Definition)table, GeneratorStrategy.Mode.POJO));
        this.printPackage(out, (Definition)table, GeneratorStrategy.Mode.POJO);
        this.printClassJavadoc(out, (Definition)table);
        this.printTableJPAAnnotation(out, table);
        out.println("public class %s[[before= extends ][%s]][[before= implements ][%s]] {", className, JavaGenerator.list(superName), interfaces);
        out.printSerial();
        out.println();
        int maxLength = 0;
        for (ColumnDefinition column : table.getColumns()) {
            maxLength = Math.max(maxLength, this.getJavaType(column.getType()).length());
        }
        for (ColumnDefinition column : table.getColumns()) {
            ((JavaWriter)out.tab(1)).println("private %s%s %s;", this.generateImmutablePojos() ? "final " : "", StringUtils.rightPad((String)this.getJavaType(column.getType()), (int)maxLength), this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO));
        }
        if (!this.generateImmutablePojos()) {
            out.println();
            ((JavaWriter)out.tab(1)).print("public %s() {}", className);
            out.println();
        }
        out.println();
        ((JavaWriter)out.tab(1)).print("public %s(", className);
        String separator1 = "";
        for (ColumnDefinition column : table.getColumns()) {
            out.println(separator1);
            ((JavaWriter)out.tab(2)).print("%s %s", StringUtils.rightPad((String)this.getJavaType(column.getType()), (int)maxLength), this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO));
            separator1 = ",";
        }
        out.println();
        ((JavaWriter)out.tab(1)).println(") {");
        for (ColumnDefinition column : table.getColumns()) {
            String columnMember = this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO);
            ((JavaWriter)out.tab(2)).println("this.%s = %s;", columnMember, columnMember);
        }
        ((JavaWriter)out.tab(1)).println("}");
        for (ColumnDefinition column : table.getColumns()) {
            String columnType = this.getJavaType(column.getType());
            String columnSetterReturnType = this.fluentSetters() ? className : "void";
            String columnSetter = this.getStrategy().getJavaSetterName((Definition)column, GeneratorStrategy.Mode.POJO);
            String columnGetter = this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.POJO);
            String columnMember = this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO);
            out.println();
            this.printColumnJPAAnnotation(out, column);
            this.printColumnValidationAnnotation(out, column);
            ((JavaWriter)out.tab(1)).overrideIf(this.generateInterfaces());
            ((JavaWriter)out.tab(1)).println("public %s %s() {", columnType, columnGetter);
            ((JavaWriter)out.tab(2)).println("return this.%s;", columnMember);
            ((JavaWriter)out.tab(1)).println("}");
            if (this.generateImmutablePojos()) continue;
            out.println();
            ((JavaWriter)out.tab(1)).overrideIf(this.generateInterfaces());
            ((JavaWriter)out.tab(1)).println("public %s %s(%s %s) {", columnSetterReturnType, columnSetter, columnType, columnMember);
            ((JavaWriter)out.tab(2)).println("this.%s = %s;", columnMember, columnMember);
            if (this.fluentSetters()) {
                ((JavaWriter)out.tab(2)).println("return this;");
            }
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.generateInterfaces() && !this.generateImmutablePojos()) {
            this.printFromAndInto(out, table);
        }
        this.generatePojoClassFooter(table, out);
        out.println("}");
        out.close();
    }

    protected void generatePojoClassFooter(TableDefinition table, JavaWriter out) {
    }

    protected void generateTables(SchemaDefinition schema) {
        log.info((Object)"Generating tables");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateTable(schema, table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Tables generated");
    }

    protected void generateTable(SchemaDefinition schema, TableDefinition table) {
        UniqueKeyDefinition primaryKey = table.getPrimaryKey();
        boolean updatable = this.generateRelations() && primaryKey != null;
        String className = this.getStrategy().getJavaClassName((Definition)table);
        String fullClassName = this.getStrategy().getFullJavaClassName((Definition)table);
        String fullTableId = this.getStrategy().getFullJavaIdentifier((Definition)table);
        String recordType = this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD);
        List<String> interfaces = this.getStrategy().getJavaClassImplements((Definition)table, GeneratorStrategy.Mode.DEFAULT);
        String comment = StringUtils.defaultString((String)table.getComment());
        log.info((Object)"Generating table", (Object)(this.getStrategy().getFileName((Definition)table) + " [input=" + table.getInputName() + ", output=" + table.getOutputName() + ", pk=" + (primaryKey != null ? primaryKey.getName() : "N/A") + "]"));
        JavaWriter out = new JavaWriter(this.getStrategy().getFile((Definition)table));
        this.printPackage(out, (Definition)table);
        this.printClassJavadoc(out, (Definition)table);
        out.println("public class %s extends %s<%s>[[before= implements ][%s]] {", className, TableImpl.class, recordType, interfaces);
        out.printSerial();
        this.printSingletonInstance(out, (Definition)table);
        this.printRecordTypeMethod(out, (Definition)table);
        for (ColumnDefinition columnDefinition : table.getColumns()) {
            String columnType = this.getJavaType(columnDefinition.getType());
            String columnTypeRef = this.getJavaTypeReference(columnDefinition.getDatabase(), columnDefinition.getType());
            String columnId = this.getStrategy().getJavaIdentifier((Definition)columnDefinition);
            String columnName = columnDefinition.getName();
            String columnComment = StringUtils.defaultString((String)columnDefinition.getComment());
            String isStatic = this.generateInstanceFields() ? "" : "static ";
            String tableRef = this.generateInstanceFields() ? "this" : this.getStrategy().getJavaIdentifier((Definition)table);
            ((JavaWriter)out.tab(1)).javadoc("The column <code>%s</code>.%s", columnDefinition.getQualifiedOutputName(), StringUtils.defaultIfBlank((String)(" " + columnComment), (String)""));
            ((JavaWriter)out.tab(1)).println("public %sfinal %s<%s, %s> %s = createField(\"%s\", %s, %s, \"%s\");", isStatic, TableField.class, recordType, columnType, columnId, columnName, columnTypeRef, tableRef, this.escapeString(columnComment));
        }
        if (this.generateInstanceFields()) {
            ((JavaWriter)out.tab(1)).javadoc("Create a <code>%s</code> table reference", table.getQualifiedOutputName());
            ((JavaWriter)out.tab(1)).println("public %s() {", className);
        } else {
            ((JavaWriter)out.tab(1)).javadoc(NO_FURTHER_INSTANCES_ALLOWED, new Object[0]);
            ((JavaWriter)out.tab(1)).println("private %s() {", className);
        }
        ((JavaWriter)out.tab(2)).println("this(\"%s\", null);", table.getOutputName());
        ((JavaWriter)out.tab(1)).println("}");
        String schemaId = this.getStrategy().getFullJavaIdentifier((Definition)schema);
        if (this.generateInstanceFields()) {
            ((JavaWriter)out.tab(1)).javadoc("Create an aliased <code>%s</code> table reference", table.getQualifiedOutputName());
            ((JavaWriter)out.tab(1)).println("public %s(%s alias) {", className, String.class);
            ((JavaWriter)out.tab(2)).println("this(alias, %s);", fullTableId);
            ((JavaWriter)out.tab(1)).println("}");
        }
        out.println();
        ((JavaWriter)out.tab(1)).println("private %s(%s alias, %s<%s> aliased) {", className, String.class, Table.class, recordType);
        ((JavaWriter)out.tab(2)).println("this(alias, aliased, null);");
        ((JavaWriter)out.tab(1)).println("}");
        out.println();
        ((JavaWriter)out.tab(1)).println("private %s(%s alias, %s<%s> aliased, %s<?>[] parameters) {", className, String.class, Table.class, recordType, Field.class);
        ((JavaWriter)out.tab(2)).println("super(alias, %s, aliased, parameters, \"%s\");", schemaId, this.escapeString(comment));
        ((JavaWriter)out.tab(1)).println("}");
        if (this.generateRelations()) {
            List foreignKeys;
            List uniqueKeys;
            IdentityDefinition identityDefinition = table.getIdentity();
            if (identityDefinition != null) {
                String identityType = this.getJavaType(identityDefinition.getColumn().getType());
                String identityFullId = this.getStrategy().getFullJavaIdentifier((Definition)identityDefinition);
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public %s<%s, %s> getIdentity() {", Identity.class, recordType, identityType);
                ((JavaWriter)out.tab(2)).println("return %s;", identityFullId);
                ((JavaWriter)out.tab(1)).println("}");
            }
            if (primaryKey != null) {
                String keyFullId = this.getStrategy().getFullJavaIdentifier((Definition)primaryKey);
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public %s<%s> getPrimaryKey() {", UniqueKey.class, recordType);
                ((JavaWriter)out.tab(2)).println("return %s;", keyFullId);
                ((JavaWriter)out.tab(1)).println("}");
            }
            if ((uniqueKeys = table.getUniqueKeys()).size() > 0) {
                List<String> keyFullIds = this.getStrategy().getFullJavaIdentifiers(uniqueKeys);
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public %s<%s<%s>> getKeys() {", List.class, UniqueKey.class, recordType);
                ((JavaWriter)out.tab(2)).println("return %s.<%s<%s>>asList([[%s]]);", Arrays.class, UniqueKey.class, recordType, keyFullIds);
                ((JavaWriter)out.tab(1)).println("}");
            }
            if ((foreignKeys = table.getForeignKeys()).size() > 0) {
                List<String> keyFullIds = this.getStrategy().getFullJavaIdentifiers(foreignKeys);
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public %s<%s<%s, ?>> getReferences() {", List.class, ForeignKey.class, recordType);
                ((JavaWriter)out.tab(2)).println("return %s.<%s<%s, ?>>asList([[%s]]);", Arrays.class, ForeignKey.class, recordType, keyFullIds);
                ((JavaWriter)out.tab(1)).println("}");
            }
        }
        if (updatable) {
            String columnId;
            String columnType;
            block1: for (String pattern : this.database.getRecordVersionFields()) {
                for (ColumnDefinition column : table.getColumns()) {
                    if (!column.getName().matches(pattern.trim()) && !column.getQualifiedName().matches(pattern.trim())) continue;
                    columnType = this.getJavaType(column.getType());
                    columnId = this.getStrategy().getFullJavaIdentifier((Definition)column);
                    ((JavaWriter)out.tab(1)).overrideInherit();
                    ((JavaWriter)out.tab(1)).println("public %s<%s, %s> getRecordVersion() {", TableField.class, recordType, columnType);
                    ((JavaWriter)out.tab(2)).println("return %s;", columnId);
                    ((JavaWriter)out.tab(1)).println("}");
                    break block1;
                }
            }
            block3: for (String pattern : this.database.getRecordTimestampFields()) {
                for (ColumnDefinition column : table.getColumns()) {
                    if (!column.getName().matches(pattern.trim()) && !column.getQualifiedName().matches(pattern.trim())) continue;
                    columnType = this.getJavaType(column.getType());
                    columnId = this.getStrategy().getFullJavaIdentifier((Definition)column);
                    ((JavaWriter)out.tab(1)).overrideInherit();
                    ((JavaWriter)out.tab(1)).println("public %s<%s, %s> getRecordTimestamp() {", TableField.class, recordType, columnType);
                    ((JavaWriter)out.tab(2)).println("return %s;", columnId);
                    ((JavaWriter)out.tab(1)).println("}");
                    break block3;
                }
            }
        }
        if (this.generateInstanceFields()) {
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s as(%s alias) {", fullClassName, String.class);
            if (table.isTableValuedFunction()) {
                ((JavaWriter)out.tab(2)).println("return new %s(alias, this, parameters);", fullClassName);
            } else {
                ((JavaWriter)out.tab(2)).println("return new %s(alias, this);", fullClassName);
            }
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.generateInstanceFields()) {
            ((JavaWriter)out.tab(1)).javadoc("Rename this table", new Object[0]);
            ((JavaWriter)out.tab(1)).println("public %s rename(%s name) {", fullClassName, String.class);
            if (table.isTableValuedFunction()) {
                ((JavaWriter)out.tab(2)).println("return new %s(name, null, parameters);", fullClassName);
            } else {
                ((JavaWriter)out.tab(2)).println("return new %s(name, null);", fullClassName);
            }
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (table.isTableValuedFunction()) {
            boolean parametersAsField;
            boolean[] blArray = new boolean[]{false, true};
            int len$ = blArray.length;
            for (int i$ = 0; !(i$ >= len$ || (parametersAsField = blArray[i$]) && table.getParameters().size() == 0); ++i$) {
                ((JavaWriter)out.tab(1)).javadoc("Call this table-valued function", new Object[0]);
                ((JavaWriter)out.tab(1)).print("public %s call(", fullClassName);
                this.printParameterDeclarations(out, table, parametersAsField);
                out.println(") {");
                ((JavaWriter)out.tab(2)).print("return new %s(getName(), null, new %s[] { ", fullClassName, Field.class);
                String separator = "";
                for (ParameterDefinition parameter : table.getParameters()) {
                    out.print(separator);
                    if (parametersAsField) {
                        out.print("%s", this.getStrategy().getJavaMemberName((Definition)parameter));
                    } else {
                        out.print("%s.val(%s)", DSL.class, this.getStrategy().getJavaMemberName((Definition)parameter));
                    }
                    separator = ", ";
                }
                out.println(" });");
                ((JavaWriter)out.tab(1)).println("}");
            }
        }
        this.generateTableClassFooter(table, out);
        out.println("}");
        out.close();
    }

    private String escapeString(String comment) {
        return comment.replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r");
    }

    protected void generateTableClassFooter(TableDefinition table, JavaWriter out) {
    }

    protected void generateSequences(SchemaDefinition schema) {
        log.info((Object)"Generating sequences");
        JavaWriter out = new JavaWriter(new File(this.getStrategy().getFile((Definition)schema).getParentFile(), "Sequences.java"));
        this.printPackage(out, (Definition)schema);
        this.printClassJavadoc(out, "Convenience access to all sequences in " + schema.getOutputName());
        out.println("public class Sequences {");
        for (SequenceDefinition sequence : this.database.getSequences(schema)) {
            String seqType = this.getJavaType(sequence.getType());
            String seqId = this.getStrategy().getJavaIdentifier((Definition)sequence);
            String seqName = sequence.getOutputName();
            String schemaId = this.getStrategy().getFullJavaIdentifier((Definition)schema);
            String typeRef = this.getJavaTypeReference(sequence.getDatabase(), sequence.getType());
            ((JavaWriter)out.tab(1)).javadoc("The sequence <code>%s</code>", sequence.getQualifiedOutputName());
            ((JavaWriter)out.tab(1)).println("public static final %s<%s> %s = new %s<%s>(\"%s\", %s, %s);", Sequence.class, seqType, seqId, SequenceImpl.class, seqType, seqName, schemaId, typeRef);
        }
        out.println("}");
        out.close();
        this.watch.splitInfo("Sequences generated");
    }

    protected void generateSchema(SchemaDefinition schema) {
        log.info((Object)"Generating schema", (Object)this.getStrategy().getFileName((Definition)schema));
        log.info((Object)"----------------------------------------------------------");
        String schemaName = schema.getQualifiedOutputName();
        String schemaId = this.getStrategy().getJavaIdentifier((Definition)schema);
        String className = this.getStrategy().getJavaClassName((Definition)schema);
        List<String> interfaces = this.getStrategy().getJavaClassImplements((Definition)schema, GeneratorStrategy.Mode.DEFAULT);
        JavaWriter out = new JavaWriter(this.getStrategy().getFile((Definition)schema));
        this.printPackage(out, (Definition)schema);
        this.printClassJavadoc(out, (Definition)schema);
        out.println("public class %s extends %s[[before= implements ][%s]] {", className, SchemaImpl.class, interfaces);
        out.printSerial();
        ((JavaWriter)out.tab(1)).javadoc("The singleton instance of <code>%s</code>", schemaName);
        ((JavaWriter)out.tab(1)).println("public static final %s %s = new %s();", className, schemaId, className);
        ((JavaWriter)out.tab(1)).javadoc(NO_FURTHER_INSTANCES_ALLOWED, new Object[0]);
        ((JavaWriter)out.tab(1)).println("private %s() {", className);
        ((JavaWriter)out.tab(2)).println("super(\"%s\");", schema.getOutputName());
        ((JavaWriter)out.tab(1)).println("}");
        if (this.generateGlobalObjectReferences()) {
            this.printSchemaReferences(out, this.database.getSequences(schema), Sequence.class, true);
        }
        this.printSchemaReferences(out, this.database.getTables(schema), Table.class, true);
        this.printSchemaReferences(out, this.database.getUDTs(schema), UDT.class, true);
        this.generateSchemaClassFooter(schema, out);
        out.println("}");
        out.close();
    }

    protected void generateSchemaClassFooter(SchemaDefinition schema, JavaWriter out) {
    }

    protected void printFromAndInto(JavaWriter out, TableDefinition table) {
        String qualified = this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.INTERFACE);
        ((JavaWriter)out.tab(1)).header("FROM and INTO", new Object[0]);
        ((JavaWriter)out.tab(1)).overrideInherit();
        ((JavaWriter)out.tab(1)).println("public void from(%s from) {", qualified);
        for (ColumnDefinition column : table.getColumns()) {
            String setter = this.getStrategy().getJavaSetterName((Definition)column, GeneratorStrategy.Mode.INTERFACE);
            String getter = this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.INTERFACE);
            ((JavaWriter)out.tab(2)).println("%s(from.%s());", setter, getter);
        }
        ((JavaWriter)out.tab(1)).println("}");
        ((JavaWriter)out.tab(1)).overrideInherit();
        ((JavaWriter)out.tab(1)).println("public <E extends %s> E into(E into) {", qualified);
        ((JavaWriter)out.tab(2)).println("into.from(this);");
        ((JavaWriter)out.tab(2)).println("return into;");
        ((JavaWriter)out.tab(1)).println("}");
    }

    protected void printSchemaReferences(JavaWriter out, List<? extends Definition> definitions, Class<?> type, boolean isGeneric) {
        if (out != null && !definitions.isEmpty()) {
            int i;
            String generic = isGeneric ? "<?>" : "";
            List<String> references = this.getStrategy().getFullJavaIdentifiers(definitions);
            out.println();
            ((JavaWriter)out.tab(1)).override();
            ((JavaWriter)out.tab(1)).println("public final %s<%s%s> get%ss() {", List.class, type, generic, type.getSimpleName());
            ((JavaWriter)out.tab(2)).println("%s result = new %s();", List.class, ArrayList.class);
            for (i = 0; i < definitions.size(); i += 500) {
                ((JavaWriter)out.tab(2)).println("result.addAll(get%ss%s());", type.getSimpleName(), i / 500);
            }
            ((JavaWriter)out.tab(2)).println("return result;");
            ((JavaWriter)out.tab(1)).println("}");
            for (i = 0; i < definitions.size(); i += 500) {
                out.println();
                ((JavaWriter)out.tab(1)).println("private final %s<%s%s> get%ss%s() {", List.class, type, generic, type.getSimpleName(), i / 500);
                ((JavaWriter)out.tab(2)).println("return %s.<%s%s>asList([[before=\n\t\t\t][separator=,\n\t\t\t][%s]]);", Arrays.class, type, generic, references.subList(i, Math.min(i + 500, references.size())));
                ((JavaWriter)out.tab(1)).println("}");
            }
        }
    }

    protected void printTableJPAAnnotation(JavaWriter out, TableDefinition table) {
        SchemaDefinition schema = table.getSchema();
        if (this.generateJPAAnnotations()) {
            out.println("@javax.persistence.Entity");
            out.print("@javax.persistence.Table(name = \"");
            out.print(table.getName().replace("\"", "\\\""));
            out.print("\"");
            if (!schema.isDefaultSchema()) {
                out.print(", schema = \"");
                out.print(schema.getOutputName().replace("\"", "\\\""));
                out.print("\"");
            }
            StringBuilder sb = new StringBuilder();
            String glue1 = "";
            for (UniqueKeyDefinition uk : table.getUniqueKeys()) {
                if (uk.getKeyColumns().size() <= 1) continue;
                sb.append(glue1);
                sb.append("\t@javax.persistence.UniqueConstraint(columnNames = {");
                String glue2 = "";
                for (ColumnDefinition column : uk.getKeyColumns()) {
                    sb.append(glue2);
                    sb.append("\"");
                    sb.append(column.getName().replace("\"", "\\\""));
                    sb.append("\"");
                    glue2 = ", ";
                }
                sb.append("})");
                glue1 = ",\n";
            }
            if (sb.length() > 0) {
                out.println(", uniqueConstraints = {");
                out.println(sb.toString());
                out.print("}");
            }
            out.println(")");
        }
    }

    protected void printColumnJPAAnnotation(JavaWriter out, ColumnDefinition column) {
        if (this.generateJPAAnnotations()) {
            UniqueKeyDefinition pk = column.getPrimaryKey();
            List uks = column.getUniqueKeys();
            if (pk != null && pk.getKeyColumns().size() == 1) {
                out.println("\t@javax.persistence.Id");
            }
            String unique = "";
            for (UniqueKeyDefinition uk : uks) {
                if (uk.getKeyColumns().size() != 1) continue;
                unique = ", unique = true";
                break;
            }
            String nullable = "";
            if (!column.getType().isNullable()) {
                nullable = ", nullable = false";
            }
            String length = "";
            String precision = "";
            String scale = "";
            if (column.getType().getLength() > 0) {
                length = ", length = " + column.getType().getLength();
            } else if (column.getType().getPrecision() > 0) {
                precision = ", precision = " + column.getType().getPrecision();
                if (column.getType().getScale() > 0) {
                    scale = ", scale = " + column.getType().getScale();
                }
            }
            out.print("\t@javax.persistence.Column(name = \"");
            out.print(column.getName().replace("\"", "\\\""));
            out.print("\"");
            out.print(unique);
            out.print(nullable);
            out.print(length);
            out.print(precision);
            out.print(scale);
            out.println(")");
        }
    }

    protected void printColumnValidationAnnotation(JavaWriter out, ColumnDefinition column) {
        if (this.generateValidationAnnotations()) {
            int length;
            DataTypeDefinition type = column.getType();
            if (!column.getType().isNullable()) {
                ((JavaWriter)out.tab(1)).println("@javax.validation.constraints.NotNull");
            }
            if ("java.lang.String".equals(this.getJavaType(type)) && (length = type.getLength()) > 0) {
                ((JavaWriter)out.tab(1)).println("@javax.validation.constraints.Size(max = %s)", length);
            }
        }
    }

    protected void generateRoutine(SchemaDefinition schema, RoutineDefinition routine) {
        log.info((Object)"Generating routine", (Object)this.getStrategy().getFileName((Definition)routine));
        String className = this.getStrategy().getJavaClassName((Definition)routine);
        String returnType = routine.getReturnValue() == null ? Void.class.getName() : this.getJavaType(routine.getReturnType());
        List<Object> returnTypeRef = JavaGenerator.list(routine.getReturnValue() != null ? this.getJavaTypeReference(this.database, routine.getReturnType()) : null);
        List<String> interfaces = this.getStrategy().getJavaClassImplements((Definition)routine, GeneratorStrategy.Mode.DEFAULT);
        String schemaId = this.getStrategy().getFullJavaIdentifier((Definition)schema);
        List<String> packageId = this.getStrategy().getFullJavaIdentifiers(new Definition[]{routine.getPackage()});
        JavaWriter out = new JavaWriter(this.getStrategy().getFile((Definition)routine));
        this.printPackage(out, (Definition)routine);
        this.printClassJavadoc(out, (Definition)routine);
        out.println("public class %s extends %s<%s>[[before= implements ][%s]] {", className, AbstractRoutine.class, returnType, interfaces);
        out.printSerial();
        for (ParameterDefinition parameter : routine.getAllParameters()) {
            String paramType = this.getJavaType(parameter.getType());
            String paramTypeRef = this.getJavaTypeReference(parameter.getDatabase(), parameter.getType());
            String paramId = this.getStrategy().getJavaIdentifier((Definition)parameter);
            String paramName = parameter.getName();
            String paramComment = StringUtils.defaultString((String)parameter.getComment());
            List<String> isDefaulted = JavaGenerator.list(parameter.isDefaulted() ? "true" : null);
            ((JavaWriter)out.tab(1)).javadoc("The parameter <code>%s</code>.%s", parameter.getQualifiedOutputName(), StringUtils.defaultIfBlank((String)(" " + paramComment), (String)""));
            ((JavaWriter)out.tab(1)).println("public static final %s<%s> %s = createParameter(\"%s\", %s[[before=, ][%s]]);", Parameter.class, paramType, paramId, paramName, paramTypeRef, isDefaulted);
        }
        ((JavaWriter)out.tab(1)).javadoc("Create a new routine call instance", new Object[0]);
        ((JavaWriter)out.tab(1)).println("public %s() {", className);
        ((JavaWriter)out.tab(2)).println("super(\"%s\", %s[[before=, ][%s]][[before=, ][%s]]);", routine.getName(), schemaId, packageId, returnTypeRef);
        if (routine.getAllParameters().size() > 0) {
            out.println();
        }
        for (ParameterDefinition parameter : routine.getAllParameters()) {
            String paramId = this.getStrategy().getJavaIdentifier((Definition)parameter);
            if (parameter.equals(routine.getReturnValue())) {
                ((JavaWriter)out.tab(2)).println("setReturnParameter(%s);", paramId);
                continue;
            }
            if (routine.getInParameters().contains(parameter)) {
                if (routine.getOutParameters().contains(parameter)) {
                    ((JavaWriter)out.tab(2)).println("addInOutParameter(%s);", paramId);
                    continue;
                }
                ((JavaWriter)out.tab(2)).println("addInParameter(%s);", paramId);
                continue;
            }
            ((JavaWriter)out.tab(2)).println("addOutParameter(%s);", paramId);
        }
        if (routine.getOverload() != null) {
            ((JavaWriter)out.tab(2)).println("setOverloaded(true);");
        }
        ((JavaWriter)out.tab(1)).println("}");
        for (ParameterDefinition parameter : routine.getInParameters()) {
            String setterReturnType = this.fluentSetters() ? className : "void";
            String setter = this.getStrategy().getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            String numberValue = parameter.getType().isGenericNumberType() ? "Number" : "Value";
            String numberField = parameter.getType().isGenericNumberType() ? "Number" : "Field";
            String paramId = this.getStrategy().getJavaIdentifier((Definition)parameter);
            String paramFullId = this.getStrategy().getFullJavaIdentifier((Definition)parameter);
            ((JavaWriter)out.tab(1)).javadoc("Set the <code>%s</code> parameter IN value to the routine", parameter.getOutputName());
            ((JavaWriter)out.tab(1)).println("public void %s(%s value) {", setter, this.getNumberType(parameter.getType()));
            ((JavaWriter)out.tab(2)).println("set%s(%s, value);", numberValue, paramFullId);
            ((JavaWriter)out.tab(1)).println("}");
            if (!routine.isSQLUsable()) continue;
            ((JavaWriter)out.tab(1)).javadoc("Set the <code>%s</code> parameter to the function to be used with a {@link org.jooq.Select} statement", parameter.getOutputName());
            ((JavaWriter)out.tab(1)).println("public %s %s(%s<%s> field) {", setterReturnType, setter, Field.class, this.getExtendsNumberType(parameter.getType()));
            ((JavaWriter)out.tab(2)).println("set%s(%s, field);", numberField, paramId);
            if (this.fluentSetters()) {
                ((JavaWriter)out.tab(2)).println("return this;");
            }
            ((JavaWriter)out.tab(1)).println("}");
        }
        for (ParameterDefinition parameter : routine.getAllParameters()) {
            boolean isReturnValue = parameter.equals(routine.getReturnValue());
            boolean isOutParameter = routine.getOutParameters().contains(parameter);
            if (!isOutParameter || isReturnValue) continue;
            String paramName = parameter.getOutputName();
            String paramType = this.getJavaType(parameter.getType());
            String paramGetter = this.getStrategy().getJavaGetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            String paramId = this.getStrategy().getJavaIdentifier((Definition)parameter);
            ((JavaWriter)out.tab(1)).javadoc("Get the <code>%s</code> parameter OUT value from the routine", paramName);
            ((JavaWriter)out.tab(1)).println("public %s %s() {", paramType, paramGetter);
            ((JavaWriter)out.tab(2)).println("return getValue(%s);", paramId);
            ((JavaWriter)out.tab(1)).println("}");
        }
        this.generateRoutineClassFooter(routine, out);
        out.println("}");
        out.close();
    }

    protected void generateRoutineClassFooter(RoutineDefinition routine, JavaWriter out) {
    }

    protected void printConvenienceMethodFunctionAsField(JavaWriter out, RoutineDefinition function, boolean parametersAsField) {
        if (function.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        if (parametersAsField && function.getInParameters().isEmpty()) {
            return;
        }
        String className = this.getStrategy().getFullJavaClassName((Definition)function);
        ((JavaWriter)out.tab(1)).javadoc("Get <code>%s</code> as a field", function.getQualifiedOutputName());
        ((JavaWriter)out.tab(1)).print("public static %s<%s> %s(", function.isAggregate() ? AggregateFunction.class : Field.class, this.getJavaType(function.getReturnType()), this.getStrategy().getJavaMethodName((Definition)function, GeneratorStrategy.Mode.DEFAULT));
        String separator = "";
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.print(separator);
            if (parametersAsField) {
                out.print("%s<%s>", Field.class, this.getExtendsNumberType(parameter.getType()));
            } else {
                out.print(this.getNumberType(parameter.getType()));
            }
            out.print(" %s", this.getStrategy().getJavaMemberName((Definition)parameter));
            separator = ", ";
        }
        out.println(") {");
        ((JavaWriter)out.tab(2)).println("%s f = new %s();", className, className);
        for (ParameterDefinition parameter : function.getInParameters()) {
            String paramSetter = this.getStrategy().getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            String paramMember = this.getStrategy().getJavaMemberName((Definition)parameter);
            ((JavaWriter)out.tab(2)).println("f.%s(%s);", paramSetter, paramMember);
        }
        out.println();
        ((JavaWriter)out.tab(2)).println("return f.as%s();", function.isAggregate() ? "AggregateFunction" : "Field");
        ((JavaWriter)out.tab(1)).println("}");
    }

    protected void printConvenienceMethodTableValuedFunctionAsField(JavaWriter out, TableDefinition function, boolean parametersAsField) {
        if (function.getParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        if (parametersAsField && function.getParameters().isEmpty()) {
            return;
        }
        String className = this.getStrategy().getFullJavaClassName((Definition)function);
        ((JavaWriter)out.tab(1)).javadoc("Get <code>%s</code> as a field", function.getQualifiedOutputName());
        ((JavaWriter)out.tab(1)).print("public static %s %s(", className, this.getStrategy().getJavaMethodName((Definition)function, GeneratorStrategy.Mode.DEFAULT));
        this.printParameterDeclarations(out, function, parametersAsField);
        out.println(") {");
        ((JavaWriter)out.tab(2)).print("return %s.call(", this.getStrategy().getFullJavaIdentifier((Definition)function));
        String separator = "";
        for (ParameterDefinition parameter : function.getParameters()) {
            out.print(separator);
            out.print("%s", this.getStrategy().getJavaMemberName((Definition)parameter));
            separator = ", ";
        }
        out.println(");");
        ((JavaWriter)out.tab(1)).println("}");
    }

    private void printParameterDeclarations(JavaWriter out, TableDefinition function, boolean parametersAsField) {
        String sep1 = "";
        for (ParameterDefinition parameter : function.getParameters()) {
            out.print(sep1);
            if (parametersAsField) {
                out.print("%s<%s>", Field.class, this.getExtendsNumberType(parameter.getType()));
            } else {
                out.print(this.getNumberType(parameter.getType()));
            }
            out.print(" %s", this.getStrategy().getJavaMemberName((Definition)parameter));
            sep1 = ", ";
        }
    }

    private String disambiguateJavaMemberName(Collection<? extends Definition> definitions, String defaultName) {
        HashSet<String> names = new HashSet<String>();
        for (Definition definition : definitions) {
            names.add(this.getStrategy().getJavaMemberName(definition));
        }
        String name = defaultName;
        while (names.contains(name)) {
            name = name + "_";
        }
        return name;
    }

    protected void printConvenienceMethodFunction(JavaWriter out, RoutineDefinition function, boolean instance) {
        String paramMember;
        if (function.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        String className = this.getStrategy().getFullJavaClassName((Definition)function);
        String functionName = function.getQualifiedOutputName();
        String functionType = this.getJavaType(function.getReturnType());
        String methodName = this.getStrategy().getJavaMethodName((Definition)function, GeneratorStrategy.Mode.DEFAULT);
        String configurationArgument = this.disambiguateJavaMemberName(function.getInParameters(), "configuration");
        ((JavaWriter)out.tab(1)).javadoc("Call <code>%s</code>", functionName);
        ((JavaWriter)out.tab(1)).print("public %s%s %s(", !instance ? "static " : "", functionType, methodName);
        String glue = "";
        if (!instance) {
            out.print("%s %s", Configuration.class, configurationArgument);
            glue = ", ";
        }
        for (ParameterDefinition parameter : function.getInParameters()) {
            if (instance && parameter.equals(function.getInParameters().get(0))) continue;
            String paramType = this.getNumberType(parameter.getType());
            paramMember = this.getStrategy().getJavaMemberName((Definition)parameter);
            out.print("%s%s %s", glue, paramType, paramMember);
            glue = ", ";
        }
        out.println(") {");
        ((JavaWriter)out.tab(2)).println("%s f = new %s();", className, className);
        for (ParameterDefinition parameter : function.getInParameters()) {
            String paramSetter = this.getStrategy().getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            paramMember = instance && parameter.equals(function.getInParameters().get(0)) ? "this" : this.getStrategy().getJavaMemberName((Definition)parameter);
            ((JavaWriter)out.tab(2)).println("f.%s(%s);", paramSetter, paramMember);
        }
        out.println();
        ((JavaWriter)out.tab(2)).println("f.execute(%s);", instance ? "configuration()" : configurationArgument);
        ((JavaWriter)out.tab(2)).println("return f.getReturnValue();");
        ((JavaWriter)out.tab(1)).println("}");
    }

    protected void printConvenienceMethodProcedure(JavaWriter out, RoutineDefinition procedure, boolean instance) {
        if (procedure.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Procedure " + procedure + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        String className = this.getStrategy().getFullJavaClassName((Definition)procedure);
        String configurationArgument = this.disambiguateJavaMemberName(procedure.getInParameters(), "configuration");
        ((JavaWriter)out.tab(1)).javadoc("Call <code>%s</code>", procedure.getQualifiedOutputName());
        out.print("\tpublic ");
        if (!instance) {
            out.print("static ");
        }
        if (procedure.getOutParameters().size() == 0) {
            out.print("void ");
        } else if (procedure.getOutParameters().size() == 1) {
            out.print(this.getJavaType(((ParameterDefinition)procedure.getOutParameters().get(0)).getType()));
            out.print(" ");
        } else {
            out.print(className + " ");
        }
        out.print(this.getStrategy().getJavaMethodName((Definition)procedure, GeneratorStrategy.Mode.DEFAULT));
        out.print("(");
        String glue = "";
        if (!instance) {
            out.print(Configuration.class);
            out.print(" ");
            out.print(configurationArgument);
            glue = ", ";
        }
        for (ParameterDefinition parameter : procedure.getInParameters()) {
            if (instance && parameter.equals(procedure.getInParameters().get(0))) continue;
            out.print(glue);
            out.print(this.getNumberType(parameter.getType()));
            out.print(" ");
            out.print(this.getStrategy().getJavaMemberName((Definition)parameter));
            glue = ", ";
        }
        out.println(") {");
        ((JavaWriter)out.tab(2)).println("%s p = new %s();", className, className);
        for (ParameterDefinition parameter : procedure.getInParameters()) {
            String setter = this.getStrategy().getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            String arg = instance && parameter.equals(procedure.getInParameters().get(0)) ? "this" : this.getStrategy().getJavaMemberName((Definition)parameter);
            ((JavaWriter)out.tab(2)).println("p.%s(%s);", setter, arg);
        }
        out.println();
        ((JavaWriter)out.tab(2)).println("p.execute(%s);", instance ? "configuration()" : configurationArgument);
        if (procedure.getOutParameters().size() > 0) {
            String getter = this.getStrategy().getJavaGetterName((Definition)procedure.getOutParameters().get(0), GeneratorStrategy.Mode.DEFAULT);
            if (instance) {
                ((JavaWriter)out.tab(2)).println("from(p.%s());", getter);
            }
            if (procedure.getOutParameters().size() == 1) {
                ((JavaWriter)out.tab(2)).println("return p.%s();", getter);
            } else if (procedure.getOutParameters().size() > 1) {
                ((JavaWriter)out.tab(2)).println("return p;");
            }
        }
        ((JavaWriter)out.tab(1)).println("}");
    }

    protected void printRecordTypeMethod(JavaWriter out, Definition definition) {
        String className = this.getStrategy().getFullJavaClassName(definition, GeneratorStrategy.Mode.RECORD);
        ((JavaWriter)out.tab(1)).javadoc("The class holding records for this type", new Object[0]);
        ((JavaWriter)out.tab(1)).override();
        ((JavaWriter)out.tab(1)).println("public %s<%s> getRecordType() {", Class.class, className);
        ((JavaWriter)out.tab(2)).println("return %s.class;", className);
        ((JavaWriter)out.tab(1)).println("}");
    }

    protected void printSingletonInstance(JavaWriter out, Definition definition) {
        String className = this.getStrategy().getFullJavaClassName(definition);
        String identifier = this.getStrategy().getJavaIdentifier(definition);
        ((JavaWriter)out.tab(1)).javadoc("The singleton instance of <code>%s</code>", definition.getQualifiedOutputName());
        ((JavaWriter)out.tab(1)).println("public static final %s %s = new %s();", className, identifier, className);
    }

    protected void printClassJavadoc(JavaWriter out, Definition definition) {
        this.printClassJavadoc(out, definition.getComment());
    }

    protected void printClassJavadoc(JavaWriter out, String comment) {
        out.println("/**");
        out.println(" * This class is generated by jOOQ.");
        if (comment != null && comment.length() > 0) {
            out.println(" *");
            this.printJavadocParagraph(out, comment, "");
        }
        out.println(" */");
        if (this.generateGeneratedAnnotation()) {
            out.println("@javax.annotation.Generated(value    = { \"http://www.jooq.org\", \"%s\" },", "3.3.0");
            out.println("                            comments = \"This class is generated by jOOQ\")");
        }
        out.println("@java.lang.SuppressWarnings({ \"all\", \"unchecked\", \"rawtypes\" })");
    }

    protected void printJavadocParagraph(JavaWriter out, String comment, String indent) {
        this.printParagraph(out, comment, indent + " * ");
    }

    protected void printParagraph(GeneratorWriter<?> out, String comment, String indent) {
        boolean newLine = true;
        int lineLength = 0;
        for (int i = 0; i < comment.length(); ++i) {
            if (newLine) {
                out.print(indent);
                newLine = false;
            }
            out.print(comment.charAt(i));
            ++lineLength;
            if (comment.charAt(i) == '\n') {
                lineLength = 0;
                newLine = true;
                continue;
            }
            if (lineLength <= 70 || !Character.isWhitespace(comment.charAt(i))) continue;
            out.println();
            lineLength = 0;
            newLine = true;
        }
        if (!newLine) {
            out.println();
        }
    }

    protected void printPackage(JavaWriter out, Definition definition) {
        this.printPackage(out, definition, GeneratorStrategy.Mode.DEFAULT);
    }

    protected void printPackage(JavaWriter out, Definition definition, GeneratorStrategy.Mode mode) {
        out.println("/**");
        out.println(" * This class is generated by jOOQ");
        out.println(" */");
        out.println("package %s;", this.getStrategy().getJavaPackageName(definition, mode));
        out.println();
    }

    protected String getExtendsNumberType(DataTypeDefinition type) {
        return this.getNumberType(type, "? extends ");
    }

    protected String getNumberType(DataTypeDefinition type) {
        return this.getNumberType(type, "");
    }

    protected String getNumberType(DataTypeDefinition type, String prefix) {
        if (type.isGenericNumberType()) {
            return prefix + Number.class.getName();
        }
        return this.getJavaType(type);
    }

    protected String getSimpleJavaType(DataTypeDefinition type) {
        return GenerationUtil.getSimpleJavaType(this.getJavaType(type));
    }

    protected String getJavaTypeReference(Database db, DataTypeDefinition type) {
        if (this.database.isArrayType(type.getType())) {
            String baseType = GenerationUtil.getArrayBaseType(db.getDialect(), type.getType(), type.getUserType());
            return this.getTypeReference(db, type.getSchema(), baseType, 0, 0, 0, true, false, baseType) + ".getArrayDataType()";
        }
        return this.getTypeReference(db, type.getSchema(), type.getType(), type.getPrecision(), type.getScale(), type.getLength(), type.isNullable(), type.isDefaulted(), type.getUserType());
    }

    protected String getJavaType(DataTypeDefinition type) {
        return this.getType(type.getDatabase(), type.getSchema(), type.getType(), type.getPrecision(), type.getScale(), type.getUserType(), Object.class.getName());
    }

    protected String getType(Database db, SchemaDefinition schema, String t, int p, int s, String u, String defaultType) {
        String type;
        block14: {
            type = defaultType;
            if (db.isArrayType(t)) {
                String baseType = GenerationUtil.getArrayBaseType(db.getDialect(), t, u);
                type = this.getType(db, schema, baseType, p, s, baseType, defaultType) + "[]";
            } else if (db.getArray(schema, u) != null) {
                type = this.getStrategy().getFullJavaClassName((Definition)db.getArray(schema, u), GeneratorStrategy.Mode.RECORD);
            } else if (db.getEnum(schema, u) != null) {
                type = this.getStrategy().getFullJavaClassName((Definition)db.getEnum(schema, u));
            } else if (db.getUDT(schema, u) != null) {
                type = this.getStrategy().getFullJavaClassName((Definition)db.getUDT(schema, u), GeneratorStrategy.Mode.RECORD);
            } else if (db.getConfiguredCustomType(u) != null) {
                type = u;
            } else {
                try {
                    Class clazz = DefaultDataType.getType((SQLDialect)db.getDialect(), (String)t, (int)p, (int)s);
                    type = clazz.getCanonicalName();
                    if (clazz.getTypeParameters().length > 0) {
                        type = type + "<";
                        String separator = "";
                        for (TypeVariable var : clazz.getTypeParameters()) {
                            type = type + separator;
                            type = type + ((Class)var.getBounds()[0]).getCanonicalName();
                            separator = ", ";
                        }
                        type = type + ">";
                    }
                }
                catch (SQLDialectNotSupportedException e) {
                    if (defaultType != null) break block14;
                    throw e;
                }
            }
        }
        return type;
    }

    protected String getTypeReference(Database db, SchemaDefinition schema, String t, int p, int s, int l, boolean n, boolean d, String u) {
        StringBuilder sb = new StringBuilder();
        if (db.getArray(schema, u) != null) {
            ArrayDefinition array = this.database.getArray(schema, u);
            sb.append(this.getJavaTypeReference(db, array.getElementType()));
            sb.append(".asArrayDataType(");
            sb.append(this.getStrategy().getFullJavaClassName((Definition)array, GeneratorStrategy.Mode.RECORD));
            sb.append(".class)");
        } else if (db.getUDT(schema, u) != null) {
            UDTDefinition udt = db.getUDT(schema, u);
            sb.append(this.getStrategy().getFullJavaIdentifier((Definition)udt));
            sb.append(".getDataType()");
        } else if (db.getEnum(schema, u) != null) {
            sb.append("org.jooq.util.");
            sb.append(db.getDialect().getName().toLowerCase());
            sb.append(".");
            sb.append(db.getDialect().getName());
            sb.append("DataType.");
            sb.append(DefaultDataType.normalise((String)DefaultDataType.getDataType((SQLDialect)db.getDialect(), String.class).getTypeName()));
            sb.append(".asEnumDataType(");
            sb.append(this.getStrategy().getFullJavaClassName((Definition)db.getEnum(schema, u)));
            sb.append(".class)");
        } else {
            DataType dataType = null;
            try {
                dataType = DefaultDataType.getDataType((SQLDialect)db.getDialect(), (String)t, (int)p, (int)s).nullable(n).defaulted(d);
            }
            catch (SQLDialectNotSupportedException ignore) {
                // empty catch block
            }
            if (dataType != null && dataType.getSQLDataType() != null) {
                DataType sqlDataType = dataType.getSQLDataType();
                sb.append(SQLDataType.class.getCanonicalName());
                sb.append(".");
                sb.append(DefaultDataType.normalise((String)sqlDataType.getTypeName()));
                if (dataType.hasPrecision() && p > 0) {
                    sb.append(".precision(").append(p);
                    if (dataType.hasScale() && s > 0) {
                        sb.append(", ").append(s);
                    }
                    sb.append(")");
                }
                if (dataType.hasLength() && l > 0) {
                    sb.append(".length(").append(l).append(")");
                }
                if (!dataType.nullable()) {
                    sb.append(".nullable(false)");
                }
                if (dataType.defaulted()) {
                    sb.append(".defaulted(true)");
                }
                if (db.getConfiguredCustomType(u) != null) {
                    sb.append(".asConvertedDataType(new ");
                    sb.append(db.getConfiguredCustomType(u).getConverter());
                    sb.append("())");
                }
            } else {
                String typeClass = "org.jooq.util." + db.getDialect().getName().toLowerCase() + "." + db.getDialect().getName() + "DataType";
                sb.append(typeClass);
                sb.append(".");
                try {
                    String type1 = this.getType(db, schema, t, p, s, u, null);
                    String type2 = this.getType(db, schema, t, 0, 0, u, null);
                    String typeName = DefaultDataType.normalise((String)t);
                    Reflect.on((String)typeClass).field(typeName);
                    sb.append(typeName);
                    if (!type1.equals(type2)) {
                        Class clazz = DefaultDataType.getType((SQLDialect)db.getDialect(), (String)t, (int)p, (int)s);
                        sb.append(".asNumberDataType(");
                        sb.append(clazz.getCanonicalName());
                        sb.append(".class)");
                    }
                }
                catch (SQLDialectNotSupportedException e) {
                    sb = new StringBuilder();
                    sb.append(DefaultDataType.class.getName());
                    sb.append(".getDefaultDataType(\"");
                    sb.append(t.replace("\"", "\\\""));
                    sb.append("\")");
                }
                catch (ReflectException e) {
                    sb = new StringBuilder();
                    sb.append(DefaultDataType.class.getName());
                    sb.append(".getDefaultDataType(\"");
                    sb.append(t.replace("\"", "\\\""));
                    sb.append("\")");
                }
            }
        }
        return sb.toString();
    }

    protected boolean match(DataTypeDefinition type1, DataTypeDefinition type2) {
        return this.getJavaType(type1).equals(this.getJavaType(type2));
    }

    private static final <T> List<T> list(T object) {
        ArrayList<T> result = new ArrayList<T>();
        if (object != null && !"".equals(object)) {
            result.add(object);
        }
        return result;
    }
}

