/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXB;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.util.DefaultGeneratorStrategy;
import org.jooq.util.Generator;
import org.jooq.util.GeneratorStrategy;
import org.jooq.util.JavaGenerator;
import org.jooq.util.MatcherStrategy;
import org.jooq.util.jaxb.Configuration;
import org.jooq.util.jaxb.Database;
import org.jooq.util.jaxb.Generate;
import org.jooq.util.jaxb.Jdbc;
import org.jooq.util.jaxb.Matchers;
import org.jooq.util.jaxb.Property;
import org.jooq.util.jaxb.Schema;
import org.jooq.util.jaxb.Strategy;
import org.jooq.util.jaxb.Target;

public class GenerationTool {
    private static final JooqLogger log = JooqLogger.getLogger(GenerationTool.class);
    private ClassLoader loader;
    private Connection connection;
    private boolean close;

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        InputStream in;
        if (args.length < 1) {
            GenerationTool.error();
        }
        if ((in = GenerationTool.class.getResourceAsStream(args[0])) == null) {
            log.error((Object)("Cannot find " + args[0]));
            log.error((Object)"-----------");
            log.error((Object)"Please be sure it is located on the classpath and qualified as a classpath location.");
            log.error((Object)"If it is located at the current working directory, try adding a '/' to the path");
            GenerationTool.error();
        }
        log.info((Object)"Initialising properties", (Object)args[0]);
        try {
            GenerationTool.main(GenerationTool.load(in));
        }
        catch (Exception e) {
            log.error((Object)("Cannot read " + args[0] + ". Error : " + e.getMessage()));
            e.printStackTrace();
            GenerationTool.error();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static void main(Configuration configuration) throws Exception {
        new GenerationTool().run(configuration);
    }

    public void run(Configuration configuration) throws Exception {
        Jdbc j = configuration.getJdbc();
        org.jooq.util.jaxb.Generator g = configuration.getGenerator();
        GenerationTool.errorIfNull(g, "The <generator/> tag is mandatory.");
        if (g.getStrategy() == null) {
            g.setStrategy(new Strategy());
        }
        if (g.getTarget() == null) {
            g.setTarget(new Target());
        }
        try {
            GeneratorStrategy strategy;
            if (this.connection == null) {
                GenerationTool.errorIfNull(j, "The <jdbc/> tag is mandatory.");
                this.loadClass(j.getDriver());
                Properties properties = new Properties();
                for (Property p : j.getProperties()) {
                    properties.put(p.getKey(), p.getValue());
                }
                if (!properties.containsKey("user")) {
                    properties.put("user", StringUtils.defaultString((String)j.getUser()));
                }
                if (!properties.containsKey("password")) {
                    properties.put("password", StringUtils.defaultString((String)j.getPassword()));
                }
                this.connection = DriverManager.getConnection(StringUtils.defaultString((String)j.getUrl()), properties);
                this.close = true;
            } else {
                j = (Jdbc)StringUtils.defaultIfNull((Object)j, (Object)new Jdbc());
            }
            Class<JavaGenerator> generatorClass = !StringUtils.isBlank((String)g.getName()) ? this.loadClass(GenerationTool.trim(g.getName())) : JavaGenerator.class;
            Generator generator = (Generator)generatorClass.newInstance();
            Matchers matchers = g.getStrategy().getMatchers();
            if (matchers != null) {
                strategy = new MatcherStrategy(matchers);
                if (g.getStrategy().getName() != null) {
                    log.warn((Object)("WARNING: Matchers take precedence over custom strategy. Strategy ignored: " + g.getStrategy().getName()));
                }
            } else {
                Class<DefaultGeneratorStrategy> strategyClass = !StringUtils.isBlank((String)g.getStrategy().getName()) ? this.loadClass(GenerationTool.trim(g.getStrategy().getName())) : DefaultGeneratorStrategy.class;
                strategy = (GeneratorStrategy)strategyClass.newInstance();
            }
            generator.setStrategy(strategy);
            Database d = g.getDatabase();
            GenerationTool.errorIfNull(d, "The <database/> tag is mandatory.");
            Class<?> databaseClass = this.loadClass(GenerationTool.trim(d.getName()));
            org.jooq.util.Database database = (org.jooq.util.Database)databaseClass.newInstance();
            List schemata = d.getSchemata();
            if (schemata.isEmpty()) {
                Schema schema = new Schema();
                schema.setInputSchema(GenerationTool.trim(d.getInputSchema()));
                schema.setOutputSchema(GenerationTool.trim(d.getOutputSchema()));
                schemata.add(schema);
            } else {
                if (!StringUtils.isBlank((String)d.getInputSchema())) {
                    log.warn((Object)"WARNING: Cannot combine configuration properties /configuration/generator/database/inputSchema and /configuration/generator/database/schemata");
                }
                if (!StringUtils.isBlank((String)d.getOutputSchema())) {
                    log.warn((Object)"WARNING: Cannot combine configuration properties /configuration/generator/database/outputSchema and /configuration/generator/database/schemata");
                }
            }
            for (Schema schema : schemata) {
                if (StringUtils.isBlank((String)schema.getInputSchema())) {
                    if (!StringUtils.isBlank((String)j.getSchema())) {
                        log.warn((Object)"WARNING: The configuration property jdbc.Schema is deprecated and will be removed in the future. Use /configuration/generator/database/inputSchema instead");
                    }
                    schema.setInputSchema(GenerationTool.trim(j.getSchema()));
                }
                if (schema.getOutputSchema() != null) continue;
                schema.setOutputSchema(GenerationTool.trim(schema.getInputSchema()));
            }
            if (schemata.size() == 1 && StringUtils.isBlank((String)((Schema)schemata.get(0)).getInputSchema())) {
                log.info((Object)"No <inputSchema/> was provided. Generating ALL available schemata instead!");
            }
            database.setConnection(this.connection);
            database.setConfiguredSchemata(schemata);
            database.setIncludes(new String[]{StringUtils.defaultString((String)d.getIncludes())});
            database.setExcludes(new String[]{StringUtils.defaultString((String)d.getExcludes())});
            database.setIncludeExcludeColumns(Boolean.TRUE.equals(d.isIncludeExcludeColumns()));
            database.setRecordVersionFields(new String[]{StringUtils.defaultString((String)d.getRecordVersionFields())});
            database.setRecordTimestampFields(new String[]{StringUtils.defaultString((String)d.getRecordTimestampFields())});
            database.setConfiguredCustomTypes(d.getCustomTypes());
            database.setConfiguredEnumTypes(d.getEnumTypes());
            database.setConfiguredForcedTypes(d.getForcedTypes());
            if (d.getEnumTypes().size() > 0) {
                log.warn((Object)"WARNING: The configuration property /configuration/generator/database/enumTypes is experimental and deprecated and will be removed in the future.");
            }
            if (d.isDateAsTimestamp() != null) {
                database.setDateAsTimestamp(d.isDateAsTimestamp().booleanValue());
            }
            if (d.isUnsignedTypes() != null) {
                database.setSupportsUnsignedTypes(d.isUnsignedTypes().booleanValue());
            }
            if (StringUtils.isBlank((String)g.getTarget().getPackageName())) {
                g.getTarget().setPackageName("org.jooq.generated");
            }
            if (StringUtils.isBlank((String)g.getTarget().getDirectory())) {
                g.getTarget().setDirectory("target/generated-sources/jooq");
            }
            generator.setTargetPackage(g.getTarget().getPackageName());
            generator.setTargetDirectory(g.getTarget().getDirectory());
            if (g.getGenerate() == null) {
                g.setGenerate(new Generate());
            }
            if (g.getGenerate().isRelations() != null) {
                generator.setGenerateRelations(g.getGenerate().isRelations());
            }
            if (g.getGenerate().isDeprecated() != null) {
                generator.setGenerateDeprecated(g.getGenerate().isDeprecated());
            }
            if (g.getGenerate().isInstanceFields() != null) {
                generator.setGenerateInstanceFields(g.getGenerate().isInstanceFields());
            }
            if (g.getGenerate().isGeneratedAnnotation() != null) {
                generator.setGenerateGeneratedAnnotation(g.getGenerate().isGeneratedAnnotation());
            }
            if (g.getGenerate().isRecords() != null) {
                generator.setGenerateRecords(g.getGenerate().isRecords());
            }
            if (g.getGenerate().isPojos() != null) {
                generator.setGeneratePojos(g.getGenerate().isPojos());
            }
            if (g.getGenerate().isImmutablePojos() != null) {
                generator.setGenerateImmutablePojos(g.getGenerate().isImmutablePojos());
            }
            if (g.getGenerate().isInterfaces() != null) {
                generator.setGenerateInterfaces(g.getGenerate().isInterfaces());
            }
            if (g.getGenerate().isDaos() != null) {
                generator.setGenerateDaos(g.getGenerate().isDaos());
            }
            if (g.getGenerate().isJpaAnnotations() != null) {
                generator.setGenerateJPAAnnotations(g.getGenerate().isJpaAnnotations());
            }
            if (g.getGenerate().isValidationAnnotations() != null) {
                generator.setGenerateValidationAnnotations(g.getGenerate().isValidationAnnotations());
            }
            if (g.getGenerate().isGlobalObjectReferences() != null) {
                generator.setGenerateGlobalObjectReferences(g.getGenerate().isGlobalObjectReferences());
            }
            if (g.getGenerate().isFluentSetters() != null) {
                generator.setFluentSetters(g.getGenerate().isFluentSetters());
            }
            strategy.setInstanceFields(generator.generateInstanceFields());
            generator.generate(database);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (this.close && this.connection != null) {
                this.connection.close();
            }
        }
    }

    private Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            if (this.loader == null) {
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    return Thread.currentThread().getContextClassLoader().loadClass(className);
                }
            }
            return this.loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (className.startsWith("org.jooq.util.")) {
                log.warn((Object)"Licensing", (Object)"With jOOQ 3.2, licensing has changed, and your database may no longer be supported with jOOQ Open Source Edition. See http://www.jooq.org/licensing for details");
            }
            throw e;
        }
    }

    private static String trim(String string) {
        return string == null ? null : string.trim();
    }

    private static void errorIfNull(Object o, String message) {
        if (o == null) {
            log.error((Object)(message + " For details, see " + "http://www.jooq.org/xsd/jooq-codegen-3.2.0.xsd"));
            System.exit(-1);
        }
    }

    private static void error() {
        log.error((Object)"Usage : GenerationTool <configuration-file>");
        System.exit(-1);
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static Configuration load(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GenerationTool.copyLarge(in, out);
        String xml = out.toString();
        xml = xml.replaceAll("<(\\w+:)?configuration xmlns(:\\w+)?=\"http://www.jooq.org/xsd/jooq-codegen-\\d+\\.\\d+\\.\\d+.xsd\">", "<$1configuration xmlns$2=\"http://www.jooq.org/xsd/jooq-codegen-3.2.0.xsd\">");
        xml = xml.replace("<configuration>", "<configuration xmlns=\"http://www.jooq.org/xsd/jooq-codegen-3.2.0.xsd\">");
        return (Configuration)JAXB.unmarshal((Reader)new StringReader(xml), Configuration.class);
    }
}

