/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.codegen.Files;
import org.jooq.codegen.GeneratorException;
import org.jooq.tools.StringUtils;

public abstract class GeneratorWriter<W extends GeneratorWriter<W>> {
    private static final Pattern PATTERN_LIST = Pattern.compile("\\[\n   (?:\\[before=([^]]+)])?\n   (?:\\[separator=([^]]+)])?\n   (?:\\[after=([^]]+)])?\n   (?:\\[(.*)])\n]\n", 36);
    private final Files files;
    private final File file;
    private final String encoding;
    private final StringBuilder sb;
    private int indentTabsThisLine;
    private int indentTabsAllLines;
    private String tabString = "    ";
    private String newlineString = "\n";
    private int printMarginForBlockComment = 80;
    private boolean newline = true;
    private boolean blockComment = false;

    protected GeneratorWriter(File file) {
        this(file, null, null);
    }

    protected GeneratorWriter(File file, String encoding) {
        this(file, encoding, null);
    }

    protected GeneratorWriter(File file, Files files) {
        this(file, null, files);
    }

    protected GeneratorWriter(File file, String encoding, Files files) {
        this.files = files == null ? new Files() : files;
        this.file = file;
        this.encoding = encoding;
        this.sb = new StringBuilder();
        this.files.mkdirs(file.getParentFile());
    }

    public String tabString() {
        return this.tabString;
    }

    public void tabString(String string) {
        this.tabString = string.replace("\\t", "\t").replace("\\s", " ");
    }

    public String newlineString() {
        return this.newlineString;
    }

    public void newlineString(String string) {
        this.newlineString = string.replace("\\n", "\n").replace("\\r", "\r");
    }

    public int printMarginForBlockComment() {
        return this.printMarginForBlockComment;
    }

    public void printMarginForBlockComment(int i) {
        this.printMarginForBlockComment = i;
    }

    public File file() {
        return this.file;
    }

    public W print(char value) {
        this.print("" + value);
        return (W)this;
    }

    public W print(int value) {
        this.print("" + value);
        return (W)this;
    }

    public W print(String string) {
        this.print(string, new Object[0]);
        return (W)this;
    }

    /*
     * WARNING - void declaration
     */
    public W print(String string, Object ... args) {
        if (((String)(string = ((String)string).replace("\n", this.newlineString).replace("\t", this.tabString))).startsWith("}") || ((String)string).startsWith("]") || ((String)string).startsWith(")")) {
            --this.indentTabsAllLines;
        } else if (((String)string).endsWith("*/")) {
            this.blockComment = false;
        }
        if (this.indentTabsAllLines < 0 && !Boolean.getBoolean("mute-indentation-error")) {
            new IllegalStateException("A formatting error has been produced\n\nThis is most likely due to a mismatch of opening and closing brackets, e.g. [], {}, ().\nThe problematic file is {file}\n\nSee also https://github.com/jOOQ/jOOQ/issues/10196\n".replace("{file}", String.valueOf(this.file))).printStackTrace(System.err);
        }
        int indentTabsThisLine0 = this.indentTabsThisLine;
        StringBuilder indent = new StringBuilder();
        if (this.newline) {
            this.newline = false;
            if (this.indentTabsThisLine + this.indentTabsAllLines > 0) {
                for (int i = 0; i < this.indentTabsThisLine + this.indentTabsAllLines; ++i) {
                    indent.append(this.tabString);
                }
                this.indentTabsThisLine = 0;
            }
            if (this.blockComment) {
                indent.append(" * ");
            }
            this.sb.append((CharSequence)indent);
        }
        if (((String)string).endsWith("{") || ((String)string).endsWith("[") || ((String)string).endsWith("(")) {
            ++this.indentTabsAllLines;
        } else if (((String)string).startsWith("if") || ((String)string).startsWith("else") || ((String)string).startsWith("for") || ((String)string).startsWith("while")) {
            this.indentTabsThisLine = indentTabsThisLine0 + 1;
        } else if (((String)string).startsWith("/*")) {
            this.blockComment = true;
        }
        if (args.length > 0) {
            List<Object> originals = Arrays.asList(args);
            ArrayList<Object> translated = new ArrayList<Object>();
            while (true) {
                for (Object object : originals) {
                    if (object instanceof Class) {
                        translated.add(this.ref((Class)object));
                        continue;
                    }
                    if (object instanceof Object[] || object instanceof Collection) {
                        void var8_10;
                        if (object instanceof Collection) {
                            Object[] objectArray = ((Collection)object).toArray();
                        }
                        int start = ((String)string).indexOf("[[");
                        int end = ((String)string).indexOf("]]");
                        String expression = ((String)string).substring(start, end + 2);
                        StringBuilder replacement = new StringBuilder();
                        Matcher m = PATTERN_LIST.matcher(expression);
                        m.find();
                        String gBefore = StringUtils.defaultString((String)m.group(1));
                        String gSeparator = StringUtils.defaultString((String)m.group(2), (String)", ");
                        String gAfter = StringUtils.defaultString((String)m.group(3));
                        String gContent = m.group(4);
                        String separator = gBefore;
                        for (Object o : (Object[])var8_10) {
                            translated.add(o);
                            replacement.append(separator);
                            replacement.append(gContent);
                            separator = gSeparator;
                        }
                        if (((Object[])var8_10).length > 0) {
                            replacement.append(gAfter);
                        }
                        string = ((String)string).substring(0, start) + String.valueOf(replacement) + ((String)string).substring(end + 2);
                        continue;
                    }
                    translated.add(object);
                }
                if (!((String)string).contains("[[") || originals.equals(translated)) break;
                originals = translated;
                translated = new ArrayList();
            }
            try {
                this.appendWrapped(String.format((String)string, translated.toArray()), indent.toString());
            }
            catch (Exception e) {
                throw new RuntimeException("Error when formatting " + (String)string + " with args " + String.valueOf(Arrays.asList(args)) + " in file " + String.valueOf(this.file), e);
            }
        } else {
            this.appendWrapped((String)string, indent.toString());
        }
        return (W)this;
    }

    private void appendWrapped(String string, String indent) {
        block8: {
            if (this.blockComment) {
                int indentLength = indent.length();
                int stringLength = string.length();
                int newlineStringLength = this.newlineString.length();
                int lineLength = indentLength;
                boolean whitespaceEncountered = false;
                block0: for (int i = 0; i < stringLength; ++i) {
                    int p;
                    if (this.peek(string, i, this.newlineString)) {
                        this.sb.append(this.newlineString).append(indent);
                        lineLength = indentLength;
                        i += newlineStringLength - 1;
                        whitespaceEncountered = false;
                        continue;
                    }
                    if (i > 0 && this.peek(string, i, "@deprecated")) {
                        int l = "@deprecated".length();
                        this.sb.append(this.newlineString).append(indent).append("@deprecated");
                        lineLength = indentLength + l;
                        i += l - 1;
                        continue;
                    }
                    int j = 0;
                    while ((p = i + j) < stringLength) {
                        boolean end = p + 1 >= stringLength;
                        boolean whitespace = Character.isWhitespace(string.charAt(p));
                        whitespaceEncountered |= whitespace;
                        if (j > 0 && whitespace || end) {
                            if (this.printMarginForBlockComment > 0 && (lineLength += end ? j + 1 : j) > this.printMarginForBlockComment && (!end || whitespaceEncountered)) {
                                this.sb.append(this.newlineString).append(indent);
                                lineLength = indentLength + j - 1;
                                ++i;
                            }
                            this.sb.append(string.subSequence(i, p));
                            i = p - 1;
                            if (!end) continue block0;
                            this.sb.append(string.charAt(p));
                            break block8;
                        }
                        ++j;
                    }
                }
            } else {
                this.sb.append(string.replace(this.newlineString, this.newlineString + indent));
            }
        }
    }

    private boolean peek(String string, int i, String peek) {
        for (int j = 0; j < peek.length(); ++j) {
            if (i + j < string.length() && string.charAt(i + j) == peek.charAt(j)) continue;
            return false;
        }
        return true;
    }

    public W printlnIf(boolean condition) {
        if (condition) {
            this.println();
        }
        return (W)this;
    }

    public W println() {
        if (this.sb.length() > 0) {
            this.sb.append(this.newlineString);
            this.newline = true;
        }
        return (W)this;
    }

    public W println(int value) {
        this.print(value);
        this.println();
        return (W)this;
    }

    public W println(String string) {
        this.print(string);
        this.println();
        return (W)this;
    }

    public W println(String string, Object ... args) {
        this.print(string, args);
        this.println();
        return (W)this;
    }

    public W indentInc() {
        ++this.indentTabsAllLines;
        return (W)this;
    }

    public W indentDec() {
        --this.indentTabsAllLines;
        return (W)this;
    }

    public W indent(int tabs) {
        this.indentTabsAllLines = tabs;
        return (W)this;
    }

    public int indent() {
        return this.indentTabsAllLines;
    }

    public W tab(int tabs) {
        this.indentTabsThisLine = tabs;
        return (W)this;
    }

    public int tab() {
        return this.indentTabsThisLine;
    }

    public CloseResult close() {
        String newContent = this.beforeClose(this.sb.toString());
        if (StringUtils.isBlank((String)newContent)) {
            return new CloseResult(false, false);
        }
        try {
            String oldContent = null;
            if (this.file.exists() && this.file.length() == (long)newContent.getBytes(this.encoding()).length) {
                try (RandomAccessFile old = new RandomAccessFile(this.file, "r");){
                    byte[] oldBytes = new byte[(int)old.length()];
                    old.readFully(oldBytes);
                    oldContent = new String(oldBytes, this.encoding());
                }
            }
            if (oldContent == null || !oldContent.equals(newContent)) {
                if (oldContent != null) {
                    this.file.delete();
                }
                PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), this.encoding()));
                writer.append(newContent);
                writer.flush();
                writer.close();
                return new CloseResult(true, true);
            }
            return new CloseResult(true, false);
        }
        catch (IOException e) {
            throw new GeneratorException("Error writing " + this.file.getAbsolutePath(), e);
        }
    }

    protected String encoding() {
        return this.encoding != null ? this.encoding : "UTF-8";
    }

    protected String beforeClose(String string) {
        if (this.indentTabsAllLines > 0 && !Boolean.getBoolean("mute-indentation-error")) {
            new IllegalStateException("A formatting error has been produced\n\nThis is most likely due to a mismatch of opening and closing brackets, e.g. [], {}, ().\nThe problematic file is {file}\n\nSee also https://github.com/jOOQ/jOOQ/issues/10196\n".replace("{file}", String.valueOf(this.file))).printStackTrace(System.err);
        }
        return string;
    }

    public String ref(Class<?> clazz) {
        return clazz == null ? null : this.ref(clazz.getName());
    }

    public String ref(String clazzOrId) {
        return clazzOrId == null ? null : this.ref(Arrays.asList(clazzOrId), 1).get(0);
    }

    public String[] ref(String[] clazzOrId) {
        return clazzOrId == null ? new String[]{} : this.ref(Arrays.asList(clazzOrId), 1).toArray(new String[clazzOrId.length]);
    }

    public List<String> ref(List<String> clazzOrId) {
        return clazzOrId == null ? Collections.emptyList() : this.ref(clazzOrId, 1);
    }

    protected String ref(String clazzOrId, int keepSegments) {
        return clazzOrId == null ? null : this.ref(Arrays.asList(clazzOrId), keepSegments).get(0);
    }

    protected String[] ref(String[] clazzOrId, int keepSegments) {
        return clazzOrId == null ? new String[]{} : this.ref(Arrays.asList(clazzOrId), keepSegments).toArray(new String[clazzOrId.length]);
    }

    protected List<String> ref(List<String> clazzOrId, int keepSegments) {
        return clazzOrId == null ? Collections.emptyList() : clazzOrId;
    }

    public String content() {
        return this.sb.toString();
    }

    public String toString() {
        return "GenerationWriter [" + String.valueOf(this.file) + "]";
    }

    public static class CloseResult {
        public final boolean affected;
        public final boolean modified;

        CloseResult(boolean affected, boolean modified) {
            this.affected = affected;
            this.modified = modified;
        }
    }
}

