/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import jakarta.xml.bind.DatatypeConverter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.invoke.CallSite;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.TypeVariable;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.AggregateFunction;
import org.jooq.Catalog;
import org.jooq.Check;
import org.jooq.Configuration;
import org.jooq.Constants;
import org.jooq.DataType;
import org.jooq.Domain;
import org.jooq.EnumType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Parameter;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UDT;
import org.jooq.UDTField;
import org.jooq.UniqueKey;
import org.jooq.codegen.AbstractGenerator;
import org.jooq.codegen.Files;
import org.jooq.codegen.GenerationUtil;
import org.jooq.codegen.GeneratorException;
import org.jooq.codegen.GeneratorStrategy;
import org.jooq.codegen.GeneratorWriter;
import org.jooq.codegen.JavaWriter;
import org.jooq.codegen.Language;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractRoutine;
import org.jooq.impl.CatalogImpl;
import org.jooq.impl.DAOImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.EmbeddableRecordImpl;
import org.jooq.impl.Internal;
import org.jooq.impl.LazySchema;
import org.jooq.impl.LazySupplier;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.TableImpl;
import org.jooq.impl.TableRecordImpl;
import org.jooq.impl.UDTImpl;
import org.jooq.impl.UDTRecordImpl;
import org.jooq.impl.UpdatableRecordImpl;
import org.jooq.meta.AbstractTypedElementDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.AttributeDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.ConstraintDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EmbeddableColumnDefinition;
import org.jooq.meta.EmbeddableDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.IdentityDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.JavaTypeResolver;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.ParameterDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.TypedElementDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.UniqueKeyDefinition;
import org.jooq.meta.jaxb.GeneratedAnnotationType;
import org.jooq.meta.postgres.PostgresDatabase;
import org.jooq.meta.postgres.PostgresRoutineDefinition;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StopWatch;
import org.jooq.tools.StringUtils;
import org.jooq.tools.reflect.Reflect;
import org.jooq.tools.reflect.ReflectException;

public class JavaGenerator
extends AbstractGenerator {
    private static final JooqLogger log = JooqLogger.getLogger(JavaGenerator.class);
    private static final Set<SQLDialect> SUPPORT_TABLE_AS_UDT = SQLDialect.supportedBy((SQLDialect[])new SQLDialect[]{SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB});
    private static final String NO_FURTHER_INSTANCES_ALLOWED = "No further instances allowed";
    private static final Map<DataType<?>, String> SQLDATATYPE_LITERAL_LOOKUP;
    private static final Set<String> SQLDATATYPE_WITH_LENGTH;
    private static final Set<String> SQLDATATYPE_WITH_PRECISION;
    private static final String KLIST = "kotlin.collections.List";
    private static final String KMUTABLELIST = "kotlin.collections.MutableList";
    private static final Set<String> PRIMITIVE_WRAPPERS;
    private final StopWatch watch = new StopWatch();
    private Database database;
    private String isoDate;
    private Map<SchemaDefinition, String> schemaVersions;
    private Map<CatalogDefinition, String> catalogVersions;
    private Set<File> affectedFiles = new LinkedHashSet<File>();
    private Set<File> modifiedFiles = new LinkedHashSet<File>();
    private Set<File> directoriesNotForRemoval = new LinkedHashSet<File>();
    private boolean scala;
    private final boolean scalaConfigured;
    private boolean kotlin;
    private final boolean kotlinConfigured;
    private final String semicolon;
    private final String emptyparens;
    private final String tokenVoid;
    private final Files fileCache;
    private String visibility;
    private static final EmbeddableFilter EMBEDDABLES_OR_COLUMNS;
    private static final EmbeddableFilter EMBEDDABLES_AND_COLUMNS;
    private static final Pattern P_IS;
    private static final Pattern SQUARE_BRACKETS;
    private static final Pattern P_SCALA_WHITESPACE_SUFFIX;

    public JavaGenerator() {
        this(Language.JAVA);
    }

    JavaGenerator(Language language) {
        super(language);
        this.scala = language == Language.SCALA;
        this.scalaConfigured = this.scala;
        this.kotlin = language == Language.KOTLIN;
        this.kotlinConfigured = this.kotlin;
        this.tokenVoid = this.scala || this.kotlin ? "Unit" : "void";
        this.semicolon = this.scala || this.kotlin ? "" : ";";
        this.emptyparens = this.scala ? "" : "()";
        this.fileCache = new Files();
    }

    private String visibilityPublic() {
        if (this.scala) {
            return "";
        }
        if (this.kotlin) {
            return "".equals(this.visibility()) ? this.visibility() : "public ";
        }
        return "public ";
    }

    private String visibility(boolean effectivelyPublic) {
        return effectivelyPublic ? this.visibilityPublic() : this.visibility();
    }

    private String visibility() {
        if (this.visibility == null) {
            switch (this.generateVisibilityModifier()) {
                case NONE: {
                    this.visibility = "";
                    break;
                }
                case PUBLIC: {
                    this.visibility = this.scala ? "" : "public ";
                    break;
                }
                case INTERNAL: {
                    this.visibility = this.scala ? "" : (this.kotlin ? "internal " : "public ");
                    break;
                }
                default: {
                    this.visibility = this.scala || this.kotlin ? "" : "public ";
                }
            }
        }
        return this.visibility;
    }

    @Override
    public final void generate(Database db) {
        this.isoDate = DatatypeConverter.printDateTime((Calendar)Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        this.schemaVersions = new LinkedHashMap<SchemaDefinition, String>();
        this.catalogVersions = new LinkedHashMap<CatalogDefinition, String>();
        this.database = db;
        this.database.addFilter((Database.Filter)new AvoidAmbiguousClassesFilter());
        this.database.setIncludeRelations(this.generateRelations());
        this.database.setTableValuedFunctions(this.generateTableValuedFunctions());
        this.logDatabaseParameters(db);
        log.info((Object)"");
        log.info((Object)"JavaGenerator parameters");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"  annotations (generated)", (Object)(this.generateGeneratedAnnotation() + (!this.generateGeneratedAnnotation && (this.useSchemaVersionProvider || this.useCatalogVersionProvider) ? " (forced to true because of <schemaVersionProvider/> or <catalogVersionProvider/>)" : "")));
        log.info((Object)"  annotations (JPA: any)", (Object)this.generateJPAAnnotations());
        log.info((Object)"  annotations (JPA: version)", (Object)this.generateJPAVersion());
        log.info((Object)"  annotations (validation)", (Object)this.generateValidationAnnotations());
        log.info((Object)"  comments", (Object)this.generateComments());
        log.info((Object)"  comments on attributes", (Object)this.generateCommentsOnAttributes());
        log.info((Object)"  comments on catalogs", (Object)this.generateCommentsOnCatalogs());
        log.info((Object)"  comments on columns", (Object)this.generateCommentsOnColumns());
        log.info((Object)"  comments on keys", (Object)this.generateCommentsOnKeys());
        log.info((Object)"  comments on links", (Object)this.generateCommentsOnLinks());
        log.info((Object)"  comments on packages", (Object)this.generateCommentsOnPackages());
        log.info((Object)"  comments on parameters", (Object)this.generateCommentsOnParameters());
        log.info((Object)"  comments on queues", (Object)this.generateCommentsOnQueues());
        log.info((Object)"  comments on routines", (Object)this.generateCommentsOnRoutines());
        log.info((Object)"  comments on schemas", (Object)this.generateCommentsOnSchemas());
        log.info((Object)"  comments on sequences", (Object)this.generateCommentsOnSequences());
        log.info((Object)"  comments on tables", (Object)this.generateCommentsOnTables());
        log.info((Object)"  comments on udts", (Object)this.generateCommentsOnUDTs());
        log.info((Object)"  sources", (Object)this.generateSources());
        log.info((Object)"  sources on views", (Object)this.generateSourcesOnViews());
        log.info((Object)"  daos", (Object)this.generateDaos());
        log.info((Object)"  deprecated code", (Object)this.generateDeprecated());
        log.info((Object)"  global references (any)", (Object)this.generateGlobalObjectReferences());
        log.info((Object)"  global references (catalogs)", (Object)this.generateGlobalCatalogReferences());
        log.info((Object)"  global references (keys)", (Object)this.generateGlobalKeyReferences());
        log.info((Object)"  global references (links)", (Object)this.generateGlobalLinkReferences());
        log.info((Object)"  global references (queues)", (Object)this.generateGlobalQueueReferences());
        log.info((Object)"  global references (routines)", (Object)this.generateGlobalRoutineReferences());
        log.info((Object)"  global references (schemas)", (Object)this.generateGlobalSchemaReferences());
        log.info((Object)"  global references (sequences)", (Object)this.generateGlobalSequenceReferences());
        log.info((Object)"  global references (tables)", (Object)this.generateGlobalTableReferences());
        log.info((Object)"  global references (udts)", (Object)this.generateGlobalUDTReferences());
        log.info((Object)"  indexes", (Object)this.generateIndexes());
        log.info((Object)"  instance fields", (Object)this.generateInstanceFields());
        log.info((Object)"  interfaces", (Object)(this.generateInterfaces() + (!this.generateInterfaces && this.generateImmutableInterfaces ? " (forced to true because of <immutableInterfaces/>)" : "")));
        log.info((Object)"  interfaces (immutable)", (Object)this.generateInterfaces());
        log.info((Object)"  javadoc", (Object)this.generateJavadoc());
        log.info((Object)"  keys", (Object)this.generateKeys());
        log.info((Object)"  links", (Object)this.generateLinks());
        log.info((Object)"  pojos", (Object)(this.generatePojos() + (!this.generatePojos && this.generateDaos ? " (forced to true because of <daos/>)" : (!this.generatePojos && this.generateImmutablePojos ? " (forced to true because of <immutablePojos/>)" : ""))));
        log.info((Object)"  pojos (immutable)", (Object)this.generateImmutablePojos());
        log.info((Object)"  queues", (Object)this.generateQueues());
        log.info((Object)"  records", (Object)(this.generateRecords() + (!this.generateRecords && this.generateDaos ? " (forced to true because of <daos/>)" : "")));
        log.info((Object)"  routines", (Object)this.generateRoutines());
        log.info((Object)"  sequences", (Object)this.generateSequences());
        log.info((Object)"  sequenceFlags", (Object)this.generateSequenceFlags());
        log.info((Object)"  table-valued functions", (Object)this.generateTableValuedFunctions());
        log.info((Object)"  tables", (Object)(this.generateTables() + (!this.generateTables && this.generateRecords ? " (forced to true because of <records/>)" : (!this.generateTables && this.generateDaos ? " (forced to true because of <daos/>)" : ""))));
        log.info((Object)"  udts", (Object)this.generateUDTs());
        log.info((Object)"  relations", (Object)(this.generateRelations() + (!this.generateRelations && this.generateTables ? " (forced to true because of <tables/>)" : (!this.generateRelations && this.generateDaos ? " (forced to true because of <daos/>)" : ""))));
        log.info((Object)"----------------------------------------------------------");
        if (!this.generateInstanceFields()) {
            log.warn((Object)"");
            log.warn((Object)"Deprecation warnings");
            log.warn((Object)"----------------------------------------------------------");
            log.warn((Object)"  <generateInstanceFields/> = false is deprecated! This feature is no longer maintained and will be removed in jOOQ 4.0. Please adapt your configuration.");
        }
        log.info((Object)"");
        this.logGenerationRemarks(db);
        log.info((Object)"");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"Generating catalogs", (Object)("Total: " + this.database.getCatalogs().size()));
        StopWatch w = new StopWatch();
        for (CatalogDefinition catalog : this.database.getCatalogs()) {
            try {
                if (this.generateCatalogIfEmpty(catalog)) {
                    this.generate(catalog);
                    continue;
                }
                log.info((Object)"Excluding empty catalog", (Object)catalog);
            }
            catch (Exception e) {
                throw new GeneratorException("Error generating code for catalog " + catalog, e);
            }
        }
        long time = w.split();
        log.info((Object)("Affected files: " + this.affectedFiles.size()));
        log.info((Object)("Modified files: " + this.modifiedFiles.size()));
        if (this.modifiedFiles.isEmpty() && this.catalogVersions.isEmpty() && this.schemaVersions.isEmpty()) {
            log.info((Object)"No modified files", (Object)("This code generation run has not produced any file modifications.\nThis means, the schema has not changed, and no other parameters (jOOQ version, driver version, database version,\nand any configuration elements) have not changed either.\n\nIn automated builds, it is recommended to prevent unnecessary code generation runs. This run took: " + StopWatch.format((long)time) + "\nPossible means to prevent this:\n- Use manual code generation and check in generated sources: https://www.jooq.org/doc/latest/manual/code-generation/codegen-version-control/\n- Use schema version providers: https://www.jooq.org/doc/latest/manual/code-generation/codegen-advanced/codegen-config-database/codegen-database-version-providers/\n- Use gradle tasks and inputs: https://github.com/etiennestuder/gradle-jooq-plugin/blob/master/README.md"));
        }
        log.info((Object)"Removing excess files");
        this.empty(this.getStrategy().getFileRoot(), this.scala ? ".scala" : (this.kotlin ? ".kt" : ".java"), this.affectedFiles, this.directoriesNotForRemoval);
        this.directoriesNotForRemoval.clear();
        this.affectedFiles.clear();
    }

    private boolean generateCatalogIfEmpty(CatalogDefinition catalog) {
        return this.generateEmptyCatalogs() || catalog.getSchemata().stream().anyMatch(this::generateSchemaIfEmpty);
    }

    private final boolean generateSchemaIfEmpty(SchemaDefinition schema) {
        return this.generateEmptySchemas() || !this.database.getArrays(schema).isEmpty() || !this.database.getDomains(schema).isEmpty() || !this.database.getEmbeddables(schema).isEmpty() || !this.database.getEnums(schema).isEmpty() || !this.database.getPackages(schema).isEmpty() || !this.database.getRoutines(schema).isEmpty() || !this.database.getSequences(schema).isEmpty() || !this.database.getTables(schema).isEmpty() || !this.database.getUDTs(schema).isEmpty();
    }

    private void generate(CatalogDefinition catalog) {
        String newVersion = catalog.getDatabase().getCatalogVersionProvider().version(catalog);
        if (StringUtils.isBlank((String)newVersion)) {
            log.info((Object)("No schema version is applied for catalog " + catalog.getInputName() + ". Regenerating."));
        } else {
            this.catalogVersions.put(catalog, newVersion);
            String oldVersion = this.readVersion(this.getFile((Definition)catalog), "catalog");
            if (StringUtils.isBlank((String)oldVersion)) {
                log.info((Object)("No previous version available for catalog " + catalog.getInputName() + ". Regenerating."));
            } else if (!oldVersion.equals(newVersion)) {
                log.info((Object)("Existing version " + oldVersion + " is not up to date with " + newVersion + " for catalog " + catalog.getInputName() + ". Regenerating."));
            } else {
                log.info((Object)("Existing version " + oldVersion + " is up to date with " + newVersion + " for catalog " + catalog.getInputName() + ". Ignoring catalog."));
                this.directoriesNotForRemoval.add(this.getFile((Definition)catalog).getParentFile());
                return;
            }
        }
        this.generateCatalog(catalog);
        log.info((Object)"Generating schemata", (Object)("Total: " + catalog.getSchemata().size()));
        for (SchemaDefinition schema : catalog.getSchemata()) {
            try {
                if (this.generateSchemaIfEmpty(schema)) {
                    this.generate(schema);
                    continue;
                }
                log.info((Object)"Excluding empty schema", (Object)schema);
            }
            catch (Exception e) {
                throw new GeneratorException("Error generating code for schema " + schema, e);
            }
        }
    }

    private void generate(SchemaDefinition schema) {
        String newVersion = schema.getDatabase().getSchemaVersionProvider().version(schema);
        if (StringUtils.isBlank((String)newVersion)) {
            log.info((Object)("No schema version is applied for schema " + schema.getInputName() + ". Regenerating."));
        } else {
            this.schemaVersions.put(schema, newVersion);
            String oldVersion = this.readVersion(this.getFile((Definition)schema), "schema");
            if (StringUtils.isBlank((String)oldVersion)) {
                log.info((Object)("No previous version available for schema " + schema.getInputName() + ". Regenerating."));
            } else if (!oldVersion.equals(newVersion)) {
                log.info((Object)("Existing version " + oldVersion + " is not up to date with " + newVersion + " for schema " + schema.getInputName() + ". Regenerating."));
            } else {
                log.info((Object)("Existing version " + oldVersion + " is up to date with " + newVersion + " for schema " + schema.getInputName() + ". Ignoring schema."));
                this.directoriesNotForRemoval.add(this.getFile((Definition)schema).getParentFile());
                return;
            }
        }
        this.generateSchema(schema);
        if (this.generateGlobalSequenceReferences() && this.database.getSequences(schema).size() > 0) {
            this.generateSequences(schema);
        }
        if (this.generateTables() && this.database.getTables(schema).size() > 0) {
            this.generateTables(schema);
        }
        if (this.generateEmbeddables() && this.database.getEmbeddables(schema).size() > 0) {
            this.generateEmbeddables(schema);
        }
        if (this.generateEmbeddables() && this.generateInterfaces() && this.database.getEmbeddables(schema).size() > 0) {
            this.generateEmbeddableInterfaces(schema);
        }
        if (this.generateEmbeddables() && this.generatePojos() && this.database.getEmbeddables(schema).size() > 0) {
            this.generateEmbeddablePojos(schema);
        }
        if (this.generatePojos() && this.database.getTables(schema).size() > 0) {
            this.generatePojos(schema);
        }
        if (this.generateDaos() && this.database.getTables(schema).size() > 0) {
            this.generateDaos(schema);
        }
        if (this.generateGlobalTableReferences() && this.database.getTables(schema).size() > 0) {
            this.generateTableReferences(schema);
        }
        if (this.generateGlobalKeyReferences() && this.generateRelations() && this.database.getTables(schema).size() > 0) {
            this.generateRelations(schema);
        }
        if (this.generateGlobalIndexReferences() && this.database.getTables(schema).size() > 0) {
            this.generateIndexes(schema);
        }
        if (this.generateRecords() && this.database.getTables(schema).size() > 0) {
            this.generateRecords(schema);
        }
        if (this.generateInterfaces() && this.database.getTables(schema).size() > 0) {
            this.generateInterfaces(schema);
        }
        if (this.generateUDTs() && this.database.getUDTs(schema).size() > 0) {
            this.generateUDTs(schema);
        }
        if (this.generateUDTs() && this.generatePojos() && this.database.getUDTs(schema).size() > 0) {
            this.generateUDTPojos(schema);
        }
        if (this.generateUDTs() && this.database.getUDTs(schema).size() > 0) {
            this.generateUDTRecords(schema);
        }
        if (this.generateUDTs() && this.generateInterfaces() && this.database.getUDTs(schema).size() > 0) {
            this.generateUDTInterfaces(schema);
        }
        if (this.generateUDTs() && this.generateRoutines() && this.database.getUDTs(schema).size() > 0) {
            this.generateUDTRoutines(schema);
        }
        if (this.generateUDTs() && this.generateGlobalUDTReferences() && this.database.getUDTs(schema).size() > 0) {
            this.generateUDTReferences((Definition)schema);
        }
        if (this.generateUDTs() && this.database.getArrays(schema).size() > 0) {
            this.generateArrays(schema);
        }
        if (this.generateUDTs() && this.database.getEnums(schema).size() > 0) {
            this.generateEnums(schema);
        }
        if (this.generateUDTs() && this.database.getDomains(schema).size() > 0) {
            this.generateDomainReferences(schema);
        }
        if (this.generateRoutines() && (this.database.getRoutines(schema).size() > 0 || this.hasTableValuedFunctions(schema))) {
            this.generateRoutines(schema);
        }
        this.watch.splitInfo("Generation finished: " + schema.getQualifiedName());
        log.info((Object)"");
    }

    private boolean hasTableValuedFunctions(SchemaDefinition schema) {
        return this.database.getTables(schema).stream().anyMatch(TableDefinition::isTableValuedFunction);
    }

    protected void generateRelations(SchemaDefinition schema) {
        String keyType;
        log.info((Object)"Generating Keys");
        boolean empty = true;
        JavaWriter out = this.newJavaWriter(this.getStrategy().getGlobalReferencesFile((Definition)schema, ConstraintDefinition.class));
        out.refConflicts(this.getStrategy().getJavaIdentifiers(this.database.getKeys(schema)));
        out.refConflicts(this.getStrategy().getJavaIdentifiers(this.database.getForeignKeys(schema)));
        this.printGlobalReferencesPackage(out, (Definition)schema, ConstraintDefinition.class);
        if (!this.kotlin) {
            this.printClassJavadoc(out, "A class modelling foreign key relationships and constraints of tables in " + this.schemaNameOrDefault((Definition)schema) + ".");
            this.printClassAnnotations(out, (Definition)schema, GeneratorStrategy.Mode.DEFAULT);
        }
        String referencesClassName = this.getStrategy().getGlobalReferencesJavaClassName((Definition)schema, ConstraintDefinition.class);
        if (this.scala) {
            out.println("%sobject %s {", this.visibility(), referencesClassName);
        } else if (!this.kotlin) {
            out.println("%sclass %s {", this.visibility(), referencesClassName);
        }
        boolean distributeUniqueKeys = this.database.getKeys(schema).size() > this.maxMembersPerInitialiser();
        boolean distributeForeignKeys = this.database.getForeignKeys(schema).size() > this.maxMembersPerInitialiser();
        ArrayList<UniqueKeyDefinition> allUniqueKeys = new ArrayList<UniqueKeyDefinition>();
        ArrayList<ForeignKeyDefinition> allForeignKeys = new ArrayList<ForeignKeyDefinition>();
        try {
            for (UniqueKeyDefinition uniqueKey : this.database.getKeys(schema)) {
                empty = false;
                keyType = out.ref(this.getStrategy().getFullJavaClassName((Definition)uniqueKey.getTable(), GeneratorStrategy.Mode.RECORD));
                String keyId = this.getStrategy().getJavaIdentifier((Definition)uniqueKey);
                int block = allUniqueKeys.size() / this.maxMembersPerInitialiser();
                if (allUniqueKeys.isEmpty()) {
                    out.header("UNIQUE and PRIMARY KEY definitions", new Object[0]);
                    out.println();
                }
                if (distributeUniqueKeys) {
                    if (this.scala) {
                        out.println("%sval %s = UniqueKeys%s.%s", this.visibility(), keyId, block, keyId);
                    } else if (this.kotlin) {
                        out.println("%sval %s: %s<%s> = UniqueKeys%s.%s", this.visibility(), keyId, UniqueKey.class, keyType, block, keyId);
                    } else {
                        out.println("%sstatic final %s<%s> %s = UniqueKeys%s.%s;", this.visibility(), UniqueKey.class, keyType, keyId, block, keyId);
                    }
                } else {
                    this.printUniqueKey(out, -1, uniqueKey, distributeUniqueKeys);
                }
                allUniqueKeys.add(uniqueKey);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while generating unique keys for schema " + schema), (Throwable)e);
        }
        try {
            for (ForeignKeyDefinition foreignKey : this.database.getForeignKeys(schema)) {
                empty = false;
                keyType = out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getKeyTable(), GeneratorStrategy.Mode.RECORD));
                String referencedType = out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getReferencedTable(), GeneratorStrategy.Mode.RECORD));
                String keyId = this.getStrategy().getJavaIdentifier((Definition)foreignKey);
                int block = allForeignKeys.size() / this.maxMembersPerInitialiser();
                if (allForeignKeys.isEmpty()) {
                    out.header("FOREIGN KEY definitions", new Object[0]);
                    out.println();
                }
                if (distributeForeignKeys) {
                    if (this.scala) {
                        out.println("%sval %s = ForeignKeys%s.%s", this.visibility(), keyId, block, keyId);
                    } else if (this.kotlin) {
                        out.println("%sval %s: %s<%s, %s> = ForeignKeys%s.%s", this.visibility(), keyId, ForeignKey.class, keyType, referencedType, block, keyId);
                    } else {
                        out.println("%sstatic final %s<%s, %s> %s = ForeignKeys%s.%s;", this.visibility(), ForeignKey.class, keyType, referencedType, keyId, block, keyId);
                    }
                } else {
                    this.printForeignKey(out, -1, foreignKey, distributeForeignKeys);
                }
                allForeignKeys.add(foreignKey);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while generating foreign keys for schema " + schema), (Throwable)e);
        }
        int uniqueKeyCounter = 0;
        int foreignKeyCounter = 0;
        if (distributeUniqueKeys || distributeForeignKeys) {
            out.header("[#1459] [#10554] [#10653] distribute members to avoid static initialisers > 64kb", new Object[0]);
            if (distributeUniqueKeys) {
                for (UniqueKeyDefinition uniqueKey : allUniqueKeys) {
                    this.printUniqueKey(out, uniqueKeyCounter++, uniqueKey, distributeUniqueKeys);
                }
                if (uniqueKeyCounter > 0) {
                    out.println("}");
                }
            }
            if (distributeForeignKeys) {
                for (ForeignKeyDefinition foreignKey : allForeignKeys) {
                    this.printForeignKey(out, foreignKeyCounter++, foreignKey, distributeForeignKeys);
                }
                if (foreignKeyCounter > 0) {
                    out.println("}");
                }
            }
        }
        this.generateRelationsClassFooter(schema, out);
        if (!this.kotlin) {
            out.println("}");
        }
        if (empty) {
            log.info((Object)"Skipping empty keys");
        } else {
            this.closeJavaWriter(out);
            this.watch.splitInfo("Keys generated");
        }
    }

    protected void generateRelationsClassFooter(SchemaDefinition schema, JavaWriter out) {
    }

    protected void generateIndexes(SchemaDefinition schema) {
        log.info((Object)"Generating Indexes");
        if (this.database.getIndexes(schema).isEmpty()) {
            log.info((Object)"Skipping empty indexes");
            return;
        }
        JavaWriter out = this.newJavaWriter(this.getStrategy().getGlobalReferencesFile((Definition)schema, IndexDefinition.class));
        out.refConflicts(this.getStrategy().getJavaIdentifiers(this.database.getIndexes(schema)));
        this.printGlobalReferencesPackage(out, (Definition)schema, IndexDefinition.class);
        if (!this.kotlin) {
            this.printClassJavadoc(out, "A class modelling indexes of tables in " + this.schemaNameOrDefault((Definition)schema) + ".");
            this.printClassAnnotations(out, (Definition)schema, GeneratorStrategy.Mode.DEFAULT);
        }
        String referencesClassName = this.getStrategy().getGlobalReferencesJavaClassName((Definition)schema, IndexDefinition.class);
        if (this.scala) {
            out.println("%sobject %s {", this.visibility(), referencesClassName);
        } else if (!this.kotlin) {
            out.println("%sclass %s {", this.visibility(), referencesClassName);
        }
        boolean distributeIndexes = this.database.getIndexes(schema).size() > this.maxMembersPerInitialiser();
        ArrayList<IndexDefinition> allIndexes = new ArrayList<IndexDefinition>();
        out.header("INDEX definitions", new Object[0]);
        out.println();
        for (IndexDefinition index : this.database.getIndexes(schema)) {
            try {
                String keyId = this.getStrategy().getJavaIdentifier((Definition)index);
                int block = allIndexes.size() / this.maxMembersPerInitialiser();
                if (distributeIndexes) {
                    if (this.scala) {
                        out.println("%sval %s = Indexes%s.%s", this.visibility(), keyId, block, keyId);
                    } else if (this.kotlin) {
                        out.println("%sval %s: %s = Indexes%s.%s", this.visibility(), keyId, Index.class, block, keyId);
                    } else {
                        out.println("%sstatic final %s %s = Indexes%s.%s;", this.visibility(), Index.class, keyId, block, keyId);
                    }
                } else {
                    this.printIndex(out, -1, index, distributeIndexes);
                }
                allIndexes.add(index);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating index " + index), (Throwable)e);
            }
        }
        int indexCounter = 0;
        if (distributeIndexes) {
            out.header("[#1459] [#10554] [#10653] distribute members to avoid static initialisers > 64kb", new Object[0]);
            for (IndexDefinition index : allIndexes) {
                this.printIndex(out, indexCounter, index, distributeIndexes);
                ++indexCounter;
            }
            if (indexCounter > 0) {
                out.println("}");
            }
        }
        this.generateIndexesClassFooter(schema, out);
        if (!this.kotlin) {
            out.println("}");
        }
        this.closeJavaWriter(out);
        this.watch.splitInfo("Indexes generated");
    }

    protected void generateIndexesClassFooter(SchemaDefinition schema, JavaWriter out) {
    }

    protected void printIndex(JavaWriter out, int indexCounter, IndexDefinition index, boolean distributeIndexes) {
        int block = indexCounter / this.maxMembersPerInitialiser();
        if (indexCounter % this.maxMembersPerInitialiser() == 0) {
            if (indexCounter > 0) {
                out.println("}");
            }
            out.println();
            if (this.scala || this.kotlin) {
                out.println("private object Indexes%s {", block);
            } else {
                out.println("private static class Indexes%s {", block);
            }
        }
        if (this.scala) {
            out.print("%sval %s: %s = ", this.visibility(), this.scalaWhitespaceSuffix(this.getStrategy().getJavaIdentifier((Definition)index)), Index.class);
        } else if (this.kotlin) {
            out.print("%sval %s: %s = ", this.visibility(), this.getStrategy().getJavaIdentifier((Definition)index), Index.class);
        } else {
            out.print("%sstatic final %s %s = ", this.visibility(), Index.class, this.getStrategy().getJavaIdentifier((Definition)index));
        }
        this.printCreateIndex(out, index);
        out.println("%s", this.semicolon);
    }

    private void printCreateIndex(JavaWriter out, IndexDefinition index) {
        String sortFieldSeparator = "";
        StringBuilder orderFields = new StringBuilder();
        for (IndexColumnDefinition column : index.getIndexColumns()) {
            orderFields.append(sortFieldSeparator);
            orderFields.append(out.ref(this.getStrategy().getFullJavaIdentifier((Definition)column.getColumn()), this.colRefSegments(null)));
            orderFields.append(column.getSortOrder() == SortOrder.DESC ? ".desc()" : "");
            sortFieldSeparator = ", ";
        }
        if (this.scala) {
            out.print("%s.createIndex(%s.name(\"%s\"), %s, Array[%s [_] ](%s), %s)", Internal.class, DSL.class, this.escapeString(index.getOutputName()), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)index.getTable()), 2), OrderField.class, orderFields, index.isUnique());
        } else if (this.kotlin) {
            out.print("%s.createIndex(%s.name(\"%s\"), %s, arrayOf(%s), %s)", Internal.class, DSL.class, this.escapeString(index.getOutputName()), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)index.getTable()), 2), orderFields, index.isUnique());
        } else {
            out.print("%s.createIndex(%s.name(\"%s\"), %s, new %s[] { %s }, %s)", Internal.class, DSL.class, this.escapeString(index.getOutputName()), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)index.getTable()), 2), OrderField.class, orderFields, index.isUnique());
        }
    }

    protected void printUniqueKey(JavaWriter out, int uniqueKeyCounter, UniqueKeyDefinition uniqueKey, boolean distributeUniqueKeys) {
        int block = uniqueKeyCounter / this.maxMembersPerInitialiser();
        if (distributeUniqueKeys && uniqueKeyCounter % this.maxMembersPerInitialiser() == 0) {
            if (uniqueKeyCounter > 0) {
                out.println("}");
            }
            out.println();
            if (this.scala || this.kotlin) {
                out.println("private object UniqueKeys%s {", block);
            } else {
                out.println("private static class UniqueKeys%s {", block);
            }
        }
        if (this.scala) {
            out.print("%sval %s: %s[%s] = ", this.visibility(), this.scalaWhitespaceSuffix(this.getStrategy().getJavaIdentifier((Definition)uniqueKey)), UniqueKey.class, out.ref(this.getStrategy().getFullJavaClassName((Definition)uniqueKey.getTable(), GeneratorStrategy.Mode.RECORD)));
        } else if (this.kotlin) {
            out.print("%sval %s: %s<%s> = ", this.visibility(), this.getStrategy().getJavaIdentifier((Definition)uniqueKey), UniqueKey.class, out.ref(this.getStrategy().getFullJavaClassName((Definition)uniqueKey.getTable(), GeneratorStrategy.Mode.RECORD)));
        } else {
            out.print("%sstatic final %s<%s> %s = ", this.visibility(), UniqueKey.class, out.ref(this.getStrategy().getFullJavaClassName((Definition)uniqueKey.getTable(), GeneratorStrategy.Mode.RECORD)), this.getStrategy().getJavaIdentifier((Definition)uniqueKey));
        }
        this.printCreateUniqueKey(out, uniqueKey);
        out.println("%s", this.semicolon);
    }

    private void printCreateUniqueKey(JavaWriter out, UniqueKeyDefinition uniqueKey) {
        this.printCreateNonEmbeddableUniqueKey(out, uniqueKey);
    }

    private void printCreateNonEmbeddableUniqueKey(JavaWriter out, UniqueKeyDefinition uniqueKey) {
        if (this.scala) {
            out.print("%s.createUniqueKey(%s, %s.name(\"%s\"), Array([[%s]]).asInstanceOf[Array[%s[%s, _] ] ], %s)", Internal.class, out.ref(this.getStrategy().getFullJavaIdentifier((Definition)uniqueKey.getTable()), 2), DSL.class, this.escapeString(uniqueKey.getOutputName()), out.ref(this.getStrategy().getFullJavaIdentifiers(uniqueKey.getKeyColumns()), this.colRefSegments(null)), TableField.class, out.ref(this.getStrategy().getJavaClassName((Definition)uniqueKey.getTable(), GeneratorStrategy.Mode.RECORD)), uniqueKey.enforced());
        } else if (this.kotlin) {
            out.print("%s.createUniqueKey(%s, %s.name(\"%s\"), arrayOf([[%s]]), %s)", Internal.class, out.ref(this.getStrategy().getFullJavaIdentifier((Definition)uniqueKey.getTable()), 2), DSL.class, this.escapeString(uniqueKey.getOutputName()), out.ref(this.getStrategy().getFullJavaIdentifiers(uniqueKey.getKeyColumns()), this.colRefSegments(null)), uniqueKey.enforced());
        } else {
            out.print("%s.createUniqueKey(%s, %s.name(\"%s\"), new %s[] { [[%s]] }, %s)", Internal.class, out.ref(this.getStrategy().getFullJavaIdentifier((Definition)uniqueKey.getTable()), 2), DSL.class, this.escapeString(uniqueKey.getOutputName()), TableField.class, out.ref(this.getStrategy().getFullJavaIdentifiers(uniqueKey.getKeyColumns()), this.colRefSegments(null)), uniqueKey.enforced());
        }
    }

    protected void printForeignKey(JavaWriter out, int foreignKeyCounter, ForeignKeyDefinition foreignKey, boolean distributeForeignKey) {
        int block = foreignKeyCounter / this.maxMembersPerInitialiser();
        if (distributeForeignKey && foreignKeyCounter % this.maxMembersPerInitialiser() == 0) {
            if (foreignKeyCounter > 0) {
                out.println("}");
            }
            out.println();
            if (this.scala || this.kotlin) {
                out.println("private object ForeignKeys%s {", block);
            } else {
                out.println("private static class ForeignKeys%s {", block);
            }
        }
        if (this.scala) {
            out.print("%sval %s: %s[%s, %s] = ", this.visibility(), this.scalaWhitespaceSuffix(this.getStrategy().getJavaIdentifier((Definition)foreignKey)), ForeignKey.class, out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getKeyTable(), GeneratorStrategy.Mode.RECORD)), out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getReferencedTable(), GeneratorStrategy.Mode.RECORD)));
        } else if (this.kotlin) {
            out.print("%sval %s: %s<%s, %s> = ", this.visibility(), this.getStrategy().getJavaIdentifier((Definition)foreignKey), ForeignKey.class, out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getKeyTable(), GeneratorStrategy.Mode.RECORD)), out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getReferencedTable(), GeneratorStrategy.Mode.RECORD)));
        } else {
            out.print("%sstatic final %s<%s, %s> %s = ", this.visibility(), ForeignKey.class, out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getKeyTable(), GeneratorStrategy.Mode.RECORD)), out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getReferencedTable(), GeneratorStrategy.Mode.RECORD)), this.getStrategy().getJavaIdentifier((Definition)foreignKey));
        }
        this.printCreateNonEmbeddableForeignKey(out, foreignKey);
        out.println("%s", this.semicolon);
    }

    private void printCreateNonEmbeddableForeignKey(JavaWriter out, ForeignKeyDefinition foreignKey) {
        if (this.scala) {
            out.print("%s.createForeignKey(%s, %s.name(\"%s\"), Array([[%s]]).asInstanceOf[Array[%s[%s, _] ] ], %s, Array([[%s]]).asInstanceOf[Array[%s[%s, _] ] ], %s)", Internal.class, out.ref(this.getStrategy().getFullJavaIdentifier((Definition)foreignKey.getKeyTable()), 2), DSL.class, this.escapeString(foreignKey.getOutputName()), out.ref(this.getStrategy().getFullJavaIdentifiers(foreignKey.getKeyColumns()), this.colRefSegments(null)), TableField.class, out.ref(this.getStrategy().getJavaClassName((Definition)foreignKey.getTable(), GeneratorStrategy.Mode.RECORD)), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)foreignKey.getReferencedKey()), 2), out.ref(this.getStrategy().getFullJavaIdentifiers(foreignKey.getReferencedColumns()), this.colRefSegments(null)), TableField.class, out.ref(this.getStrategy().getJavaClassName((Definition)foreignKey.getReferencedTable(), GeneratorStrategy.Mode.RECORD)), foreignKey.enforced());
        } else if (this.kotlin) {
            out.print("%s.createForeignKey(%s, %s.name(\"%s\"), arrayOf([[%s]]), %s, arrayOf([[%s]]), %s)", Internal.class, out.ref(this.getStrategy().getFullJavaIdentifier((Definition)foreignKey.getKeyTable()), 2), DSL.class, this.escapeString(foreignKey.getOutputName()), out.ref(this.getStrategy().getFullJavaIdentifiers(foreignKey.getKeyColumns()), this.colRefSegments(null)), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)foreignKey.getReferencedKey())), out.ref(this.getStrategy().getFullJavaIdentifiers(foreignKey.getReferencedColumns()), this.colRefSegments(null)), foreignKey.enforced());
        } else {
            out.print("%s.createForeignKey(%s, %s.name(\"%s\"), new %s[] { [[%s]] }, %s, new %s[] { [[%s]] }, %s)", Internal.class, out.ref(this.getStrategy().getFullJavaIdentifier((Definition)foreignKey.getKeyTable()), 2), DSL.class, this.escapeString(foreignKey.getOutputName()), TableField.class, out.ref(this.getStrategy().getFullJavaIdentifiers(foreignKey.getKeyColumns()), this.colRefSegments(null)), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)foreignKey.getReferencedKey()), 2), TableField.class, out.ref(this.getStrategy().getFullJavaIdentifiers(foreignKey.getReferencedColumns()), this.colRefSegments(null)), foreignKey.enforced());
        }
    }

    protected void generateRecords(SchemaDefinition schema) {
        log.info((Object)"Generating table records");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateRecord(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table record " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table records generated");
    }

    protected void generateRecord(TableDefinition table) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)table, GeneratorStrategy.Mode.RECORD));
        log.info((Object)"Generating record", (Object)out.file().getName());
        this.generateRecord0((Definition)table, out);
        this.closeJavaWriter(out);
    }

    protected void generateUDTRecord(UDTDefinition udt) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)udt, GeneratorStrategy.Mode.RECORD));
        log.info((Object)"Generating record", (Object)out.file().getName());
        this.generateRecord0((Definition)udt, out);
        this.closeJavaWriter(out);
    }

    protected void generateRecord(TableDefinition table, JavaWriter out) {
        this.generateRecord0((Definition)table, out);
    }

    protected void generateUDTRecord(UDTDefinition udt, JavaWriter out) {
        this.generateRecord0((Definition)udt, out);
    }

    private final void generateRecord0(Definition tableUdtOrEmbeddable, JavaWriter out) {
        int keyDegree;
        UniqueKeyDefinition key = tableUdtOrEmbeddable instanceof TableDefinition ? ((TableDefinition)tableUdtOrEmbeddable).getPrimaryKey() : null;
        String className = this.getStrategy().getJavaClassName(tableUdtOrEmbeddable, GeneratorStrategy.Mode.RECORD);
        String tableIdentifier = !(tableUdtOrEmbeddable instanceof EmbeddableDefinition) ? out.ref(this.getStrategy().getFullJavaIdentifier(tableUdtOrEmbeddable), 2) : null;
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements(tableUdtOrEmbeddable, GeneratorStrategy.Mode.RECORD));
        this.printPackage(out, tableUdtOrEmbeddable, GeneratorStrategy.Mode.RECORD);
        if (tableUdtOrEmbeddable instanceof TableDefinition) {
            this.generateRecordClassJavadoc((TableDefinition)tableUdtOrEmbeddable, out);
        } else if (tableUdtOrEmbeddable instanceof EmbeddableDefinition) {
            this.generateEmbeddableClassJavadoc((EmbeddableDefinition)tableUdtOrEmbeddable, out);
        } else {
            this.generateUDTRecordClassJavadoc((UDTDefinition)tableUdtOrEmbeddable, out);
        }
        this.printClassAnnotations(out, tableUdtOrEmbeddable, GeneratorStrategy.Mode.RECORD);
        if (tableUdtOrEmbeddable instanceof TableDefinition) {
            this.printTableJPAAnnotation(out, (TableDefinition)tableUdtOrEmbeddable);
        }
        Class baseClass = tableUdtOrEmbeddable instanceof UDTDefinition ? UDTRecordImpl.class : (tableUdtOrEmbeddable instanceof EmbeddableDefinition ? EmbeddableRecordImpl.class : (this.generateRelations() && key != null ? UpdatableRecordImpl.class : TableRecordImpl.class));
        List<Definition> embeddablesAndColumns = this.embeddablesAndColumns(tableUdtOrEmbeddable);
        List<Definition> embeddablesAndUnreplacedColumns = this.embeddablesAndUnreplacedColumns(tableUdtOrEmbeddable);
        List<Definition> replacingEmbeddablesAndUnreplacedColumns = this.replacingEmbeddablesAndUnreplacedColumns(tableUdtOrEmbeddable);
        List<Definition> embeddablesOrColumns = this.embeddablesOrColumns(tableUdtOrEmbeddable);
        int degree = replacingEmbeddablesAndUnreplacedColumns.size();
        String rowType = null;
        String rowTypeRecord = null;
        if (this.generateRecordsImplementingRecordN() && degree > 0 && degree <= 22) {
            rowType = this.refRowType(out, replacingEmbeddablesAndUnreplacedColumns);
            rowTypeRecord = this.scala ? out.ref(Record.class.getName() + degree) + "[" + rowType + "]" : out.ref(Record.class.getName() + degree) + "<" + rowType + ">";
            interfaces.add(rowTypeRecord);
        }
        if (this.generateInterfaces()) {
            interfaces.add(out.ref(this.getStrategy().getFullJavaClassName(tableUdtOrEmbeddable, GeneratorStrategy.Mode.INTERFACE)));
        }
        if (this.scala) {
            if (tableUdtOrEmbeddable instanceof EmbeddableDefinition) {
                out.println("%sclass %s extends %s[%s](%s.%s.getDataType.getRow)[[before= with ][separator= with ][%s]] {", this.visibility(), className, baseClass, className, out.ref(this.getStrategy().getFullJavaIdentifier((Definition)((EmbeddableDefinition)tableUdtOrEmbeddable).getTable()), 2), this.getStrategy().getJavaIdentifier(tableUdtOrEmbeddable), interfaces);
            } else {
                out.println("%sclass %s extends %s[%s](%s)[[before= with ][separator= with ][%s]] {", this.visibility(), className, baseClass, className, tableIdentifier, interfaces);
            }
        } else if (this.kotlin) {
            if (tableUdtOrEmbeddable instanceof EmbeddableDefinition) {
                out.println("%sopen class %s() : %s<%s>(%s.%s.dataType.row)[[before=, ][%s]] {", this.visibility(), className, baseClass, className, out.ref(this.getStrategy().getFullJavaIdentifier((Definition)((EmbeddableDefinition)tableUdtOrEmbeddable).getTable()), 2), this.getStrategy().getJavaIdentifier(tableUdtOrEmbeddable), interfaces);
            } else {
                out.println("%sopen class %s() : %s<%s>(%s)[[before=, ][%s]] {", this.visibility(), className, baseClass, className, tableIdentifier, interfaces);
            }
        } else {
            out.println("%sclass %s extends %s<%s>[[before= implements ][%s]] {", this.visibility(), className, baseClass, className, interfaces);
        }
        out.printSerial();
        for (Definition column : embeddablesAndUnreplacedColumns) {
            int index = replacingEmbeddablesAndUnreplacedColumns.indexOf(column);
            if (column instanceof EmbeddableDefinition) {
                EmbeddableDefinition embeddable = (EmbeddableDefinition)column;
                this.generateEmbeddableRecordSetter(embeddable, index, out);
                this.generateEmbeddableRecordGetter(embeddable, index, out);
                continue;
            }
            TypedElementDefinition c = (TypedElementDefinition)column;
            if (tableUdtOrEmbeddable instanceof TableDefinition) {
                this.generateRecordSetter(c, index, out);
                this.generateRecordGetter(c, index, out);
                continue;
            }
            if (tableUdtOrEmbeddable instanceof EmbeddableDefinition) {
                this.generateEmbeddableSetter(c, index, out);
                this.generateEmbeddableGetter(c, index, out);
                continue;
            }
            this.generateUDTRecordSetter(c, index, out);
            this.generateUDTRecordGetter(c, index, out);
        }
        if (this.generateRelations() && key != null && (keyDegree = key.getKeyColumns().size()) <= 22) {
            String recordNType = out.ref(Record.class.getName() + keyDegree);
            String keyType = this.refRowType(out, key.getKeyColumns());
            out.header("Primary key information", new Object[0]);
            if (this.scala) {
                out.println();
                out.println("%soverride def key: %s[%s] = super.key.asInstanceOf[ %s[%s] ]", this.visibilityPublic(), recordNType, keyType, recordNType, keyType);
            } else if (this.kotlin) {
                out.println();
                out.println("%soverride fun key(): %s<%s> = super.key() as %s<%s>", this.visibilityPublic(), recordNType, keyType, recordNType, keyType);
            } else {
                out.overrideInherit();
                this.printNonnullAnnotation(out);
                out.println("%s%s<%s> key() {", this.visibilityPublic(), recordNType, keyType);
                out.println("return (%s) super.key();", recordNType);
                out.println("}");
            }
        }
        if (tableUdtOrEmbeddable instanceof UDTDefinition) {
            for (RoutineDefinition routine : ((UDTDefinition)tableUdtOrEmbeddable).getRoutines()) {
                boolean instance = routine.getInParameters().size() > 0 && ((ParameterDefinition)routine.getInParameters().get(0)).getInputName().toUpperCase(this.getStrategy().getTargetLocale()).equals("SELF");
                try {
                    if (!routine.isSQLUsable()) {
                        this.printConvenienceMethodProcedure(out, routine, instance);
                        continue;
                    }
                    if (routine.isAggregate()) continue;
                    this.printConvenienceMethodFunction(out, routine, instance);
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating routine " + routine), (Throwable)e);
                }
            }
        }
        if (this.generateRecordsImplementingRecordN() && degree > 0 && degree <= 22) {
            String colMember;
            String colGetter;
            String colTypeFull;
            int i;
            String recordNType = out.ref(Row.class.getName() + degree);
            out.header("Record%s type implementation", degree);
            if (this.scala) {
                out.println();
                out.println("%soverride def fieldsRow: %s[%s] = super.fieldsRow.asInstanceOf[ %s[%s] ]", this.visibilityPublic(), recordNType, rowType, recordNType, rowType);
            } else if (this.kotlin) {
                out.println();
                out.println("%soverride fun fieldsRow(): %s<%s> = super.fieldsRow() as %s<%s>", this.visibilityPublic(), recordNType, rowType, recordNType, rowType);
            } else {
                out.overrideInherit();
                this.printNonnullAnnotation(out);
                out.println("%s%s<%s> fieldsRow() {", this.visibilityPublic(), recordNType, rowType);
                out.println("return (%s) super.fieldsRow();", recordNType);
                out.println("}");
            }
            if (this.scala) {
                out.println();
                out.println("%soverride def valuesRow: %s[%s] = super.valuesRow.asInstanceOf[ %s[%s] ]", this.visibilityPublic(), recordNType, rowType, recordNType, rowType);
            } else if (this.kotlin) {
                out.println("%soverride fun valuesRow(): %s<%s> = super.valuesRow() as %s<%s>", this.visibilityPublic(), recordNType, rowType, recordNType, rowType);
            } else {
                out.overrideInherit();
                this.printNonnullAnnotation(out);
                out.println("%s%s<%s> valuesRow() {", this.visibilityPublic(), recordNType, rowType);
                out.println("return (%s) super.valuesRow();", recordNType);
                out.println("}");
            }
            for (i = 1; i <= degree; ++i) {
                Definition column = replacingEmbeddablesAndUnreplacedColumns.get(i - 1);
                if (column instanceof EmbeddableColumnDefinition) {
                    column = ((EmbeddableColumnDefinition)column).getReferencingColumn();
                }
                colTypeFull = this.getJavaType(column, out);
                String string = out.ref(colTypeFull);
                String colIdentifierFull = out.ref(this.getStrategy().getFullJavaIdentifier(column), this.colRefSegments(column));
                String colIdentifier = this.getStrategy().getJavaIdentifier(column);
                if (this.scala) {
                    this.printDeprecationIfUnknownType(out, colTypeFull);
                    if (tableUdtOrEmbeddable instanceof EmbeddableDefinition) {
                        out.println("%soverride def field%s: %s[%s] = field(%s).asInstanceOf[%s [%s] ]", this.visibilityPublic(), i, Field.class, string, i - 1, Field.class, string);
                        continue;
                    }
                    out.println("%soverride def field%s: %s[%s] = %s", this.visibilityPublic(), i, Field.class, string, colIdentifierFull);
                    continue;
                }
                if (this.kotlin) {
                    this.printDeprecationIfUnknownType(out, colTypeFull);
                    if (tableUdtOrEmbeddable instanceof EmbeddableDefinition) {
                        out.println("%soverride fun field%s(): %s<%s?> = field(%s) as %s<%s?>", this.visibilityPublic(), i, Field.class, string, i - 1, Field.class, string);
                        continue;
                    }
                    if (tableUdtOrEmbeddable instanceof UDTDefinition) {
                        out.println("%soverride fun field%s(): %s<%s%s> = %s.%s", this.visibilityPublic(), i, Field.class, string, column instanceof EmbeddableDefinition ? "" : "?", out.ref(this.getStrategy().getFullJavaIdentifier(((AttributeDefinition)column).getContainer()), 2), colIdentifier);
                        continue;
                    }
                    out.println("%soverride fun field%s(): %s<%s%s> = %s", this.visibilityPublic(), i, Field.class, string, column instanceof EmbeddableDefinition ? "" : "?", colIdentifierFull);
                    continue;
                }
                if (this.printDeprecationIfUnknownType(out, colTypeFull)) {
                    out.override();
                } else {
                    out.overrideInherit();
                }
                this.printNonnullAnnotation(out);
                out.println("%s%s<%s> field%s() {", this.visibilityPublic(), Field.class, string, i);
                if (tableUdtOrEmbeddable instanceof EmbeddableDefinition) {
                    out.println("return (%s<%s>) field(%s);", Field.class, string, i - 1);
                } else {
                    out.println("return %s;", colIdentifierFull);
                }
                out.println("}");
            }
            for (i = 1; i <= degree; ++i) {
                Definition column = replacingEmbeddablesAndUnreplacedColumns.get(i - 1);
                colTypeFull = this.getJavaType(column, out);
                String string = out.ref(colTypeFull);
                colGetter = this.getStrategy().getJavaGetterName(column, GeneratorStrategy.Mode.RECORD);
                colMember = this.getStrategy().getJavaMemberName(column, GeneratorStrategy.Mode.POJO);
                if (this.scala) {
                    this.printDeprecationIfUnknownType(out, colTypeFull);
                    out.println("%soverride def component%s: %s = %s", this.visibilityPublic(), i, string, colGetter);
                    continue;
                }
                if (this.kotlin) {
                    this.printDeprecationIfUnknownType(out, colTypeFull);
                    out.println("%soverride fun component%s(): %s? = %s", this.visibilityPublic(), i, string, colMember);
                    continue;
                }
                if (this.printDeprecationIfUnknownType(out, colTypeFull)) {
                    out.override();
                } else {
                    out.overrideInherit();
                }
                this.printNullableOrNonnullAnnotation(out, column);
                out.println("%s%s component%s() {", this.visibilityPublic(), string, i);
                out.println("return %s();", colGetter);
                out.println("}");
            }
            for (i = 1; i <= degree; ++i) {
                Definition column = replacingEmbeddablesAndUnreplacedColumns.get(i - 1);
                colTypeFull = this.getJavaType(column, out);
                String string = out.ref(colTypeFull);
                colGetter = this.getStrategy().getJavaGetterName(column, GeneratorStrategy.Mode.RECORD);
                colMember = this.getStrategy().getJavaMemberName(column, GeneratorStrategy.Mode.POJO);
                if (this.scala) {
                    this.printDeprecationIfUnknownType(out, colTypeFull);
                    out.println("%soverride def value%s: %s = %s", this.visibilityPublic(), i, string, colGetter);
                    continue;
                }
                if (this.kotlin) {
                    this.printDeprecationIfUnknownType(out, colTypeFull);
                    out.println("%soverride fun value%s(): %s? = %s", this.visibilityPublic(), i, string, colMember);
                    continue;
                }
                if (this.printDeprecationIfUnknownType(out, colTypeFull)) {
                    out.override();
                } else {
                    out.overrideInherit();
                }
                this.printNullableOrNonnullAnnotation(out, column);
                out.println("%s%s value%s() {", this.visibilityPublic(), string, i);
                out.println("return %s();", colGetter);
                out.println("}");
            }
            for (i = 1; i <= degree; ++i) {
                Definition column = replacingEmbeddablesAndUnreplacedColumns.get(i - 1);
                colTypeFull = this.getJavaType(column, out);
                String string = out.ref(colTypeFull);
                String colSetter = this.getStrategy().getJavaSetterName(column, GeneratorStrategy.Mode.RECORD);
                colMember = this.getStrategy().getJavaMemberName(column, GeneratorStrategy.Mode.POJO);
                if (this.scala) {
                    out.println();
                    this.printDeprecationIfUnknownType(out, colTypeFull);
                    out.println("%soverride def value%s(value: %s): %s = {", this.visibilityPublic(), i, string, className);
                    out.println("%s(value)", colSetter);
                    out.println("this");
                    out.println("}");
                    continue;
                }
                if (this.kotlin) {
                    out.println();
                    this.printDeprecationIfUnknownType(out, colTypeFull);
                    out.println("%soverride fun value%s(value: %s%s): %s {", this.visibilityPublic(), i, string, column instanceof EmbeddableDefinition ? "" : "?", className);
                    out.println("this.%s = value", colMember);
                    out.println("return this");
                    out.println("}");
                    continue;
                }
                String nullableAnnotation = this.nullableOrNonnullAnnotation(out, column);
                if (this.printDeprecationIfUnknownType(out, colTypeFull)) {
                    out.override();
                } else {
                    out.overrideInherit();
                }
                this.printNonnullAnnotation(out);
                out.println("%s%s value%s([[before=@][after= ][%s]]%s value) {", this.visibilityPublic(), className, i, JavaGenerator.list(nullableAnnotation), this.varargsIfArray(string));
                out.println("%s(value);", colSetter);
                out.println("return this;");
                out.println("}");
            }
            ArrayList<CallSite> arguments = new ArrayList<CallSite>(degree);
            ArrayList<CallSite> calls = new ArrayList<CallSite>(degree);
            for (int i2 = 1; i2 <= degree; ++i2) {
                Definition definition = replacingEmbeddablesAndUnreplacedColumns.get(i2 - 1);
                String colType2 = this.getJavaTypeRef(definition, out);
                if (this.scala) {
                    arguments.add((CallSite)((Object)("value" + i2 + " : " + colType2)));
                    calls.add((CallSite)((Object)("this.value" + i2 + "(value" + i2 + ")")));
                    continue;
                }
                if (this.kotlin) {
                    arguments.add((CallSite)((Object)("value" + i2 + ": " + colType2 + (definition instanceof EmbeddableDefinition ? "" : "?"))));
                    calls.add((CallSite)((Object)("this.value" + i2 + "(value" + i2 + ")")));
                    continue;
                }
                String nullableAnnotation = this.nullableOrNonnullAnnotation(out, definition);
                arguments.add((CallSite)((Object)((String)(nullableAnnotation == null ? "" : "@" + nullableAnnotation + " ") + colType2 + " value" + i2)));
                calls.add((CallSite)((Object)("value" + i2 + "(value" + i2 + ");")));
            }
            if (this.scala) {
                out.println();
                out.println("%soverride def values([[%s]]): %s = {", this.visibilityPublic(), arguments, className);
                for (String string : calls) {
                    out.println(string);
                }
                out.println("this");
                out.println("}");
            } else if (this.kotlin) {
                out.println();
                out.println("%soverride fun values([[%s]]): %s {", this.visibilityPublic(), arguments, className);
                for (String string : calls) {
                    out.println(string);
                }
                out.println("return this");
                out.println("}");
            } else {
                out.overrideInherit();
                this.printNonnullAnnotation(out);
                out.println("%s%s values([[%s]]) {", this.visibilityPublic(), className, arguments);
                for (String string : calls) {
                    out.println(string);
                }
                out.println("return this;");
                out.println("}");
            }
        }
        if (this.generateInterfaces()) {
            this.printFromAndInto(out, tableUdtOrEmbeddable, GeneratorStrategy.Mode.RECORD);
        }
        if (!this.scala && !this.kotlin) {
            out.header("Constructors", new Object[0]);
            out.javadoc("Create a detached %s", className);
            out.println("%s%s() {", this.visibility(), className);
            if (tableUdtOrEmbeddable instanceof EmbeddableDefinition) {
                out.println("super(%s.%s.getDataType().getRow());", out.ref(this.getStrategy().getFullJavaIdentifier((Definition)((EmbeddableDefinition)tableUdtOrEmbeddable).getTable()), 2), this.getStrategy().getJavaIdentifier(tableUdtOrEmbeddable));
            } else {
                out.println("super(%s);", tableIdentifier);
            }
            out.println("}");
        }
        this.generateRecordConstructor(tableUdtOrEmbeddable, out, replacingEmbeddablesAndUnreplacedColumns, false);
        if (!replacingEmbeddablesAndUnreplacedColumns.equals(embeddablesOrColumns)) {
            this.generateRecordConstructor(tableUdtOrEmbeddable, out, embeddablesOrColumns, false);
        }
        if (this.generatePojos()) {
            this.generateRecordConstructor(tableUdtOrEmbeddable, out, replacingEmbeddablesAndUnreplacedColumns, true);
        }
        if (tableUdtOrEmbeddable instanceof TableDefinition) {
            this.generateRecordClassFooter((TableDefinition)tableUdtOrEmbeddable, out);
        } else if (tableUdtOrEmbeddable instanceof EmbeddableDefinition) {
            this.generateEmbeddableClassFooter((EmbeddableDefinition)tableUdtOrEmbeddable, out);
        } else {
            this.generateUDTRecordClassFooter((UDTDefinition)tableUdtOrEmbeddable, out);
        }
        out.println("}");
    }

    private List<Definition> embeddablesOrColumns(Definition tableUdtOrEmbeddable) {
        return this.embeddablesAndColumns(tableUdtOrEmbeddable, EMBEDDABLES_OR_COLUMNS);
    }

    private List<Definition> embeddablesAndUnreplacedColumns(Definition tableUdtOrEmbeddable) {
        return this.embeddablesAndColumns(tableUdtOrEmbeddable, (result, duplicates, index, embeddable) -> EMBEDDABLES_AND_COLUMNS.accept(result, duplicates, index, embeddable));
    }

    private List<Definition> replacingEmbeddablesAndUnreplacedColumns(Definition tableUdtOrEmbeddable) {
        return this.embeddablesAndColumns(tableUdtOrEmbeddable, (result, duplicates, index, embeddable) -> {});
    }

    private List<Definition> embeddablesAndColumns(Definition tableUdtOrEmbeddable) {
        return this.embeddablesAndColumns(tableUdtOrEmbeddable, EMBEDDABLES_AND_COLUMNS);
    }

    private List<Definition> embeddablesAndColumns(Definition tableUdtOrEmbeddable, EmbeddableFilter filter) {
        ArrayList<? extends TypedElementDefinition<? extends Definition>> result = new ArrayList<TypedElementDefinition<? extends Definition>>(this.getTypedElements(tableUdtOrEmbeddable));
        if (tableUdtOrEmbeddable instanceof TableDefinition) {
            HashSet<EmbeddableDefinition> duplicates = new HashSet<EmbeddableDefinition>();
            for (EmbeddableDefinition embeddable : ((TableDefinition)tableUdtOrEmbeddable).getReferencedEmbeddables()) {
                for (EmbeddableColumnDefinition embeddableColumn : embeddable.getColumns()) {
                    int index = result.indexOf(embeddableColumn.getReferencingColumn());
                    if (index < 0) continue;
                    filter.accept(result, duplicates, index, embeddable);
                }
            }
        }
        return result;
    }

    private void generateRecordConstructor(Definition tableUdtOrEmbeddable, JavaWriter out, Collection<? extends Definition> columns, boolean pojoArgument) {
        if (pojoArgument && !this.generatePojos()) {
            return;
        }
        String className = this.getStrategy().getJavaClassName(tableUdtOrEmbeddable, GeneratorStrategy.Mode.RECORD);
        String pojoNameFull = this.getStrategy().getFullJavaClassName(tableUdtOrEmbeddable, GeneratorStrategy.Mode.POJO);
        String tableIdentifier = !(tableUdtOrEmbeddable instanceof EmbeddableDefinition) ? out.ref(this.getStrategy().getFullJavaIdentifier(tableUdtOrEmbeddable), 2) : null;
        int degree = columns.size();
        if (pojoArgument || degree > 0 && degree < 256) {
            ArrayList<CallSite> arguments = new ArrayList<CallSite>(degree);
            ArrayList<CallSite> properties = new ArrayList<CallSite>(degree);
            for (Definition definition : columns) {
                String columnMember = this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.DEFAULT);
                String type = this.getJavaTypeRef(definition, out);
                if (this.scala) {
                    arguments.add((CallSite)((Object)(columnMember + " : " + type)));
                } else if (this.kotlin) {
                    arguments.add((CallSite)((Object)(columnMember + ": " + type + "? = null")));
                } else {
                    String nullableAnnotation = definition instanceof EmbeddableDefinition ? null : this.nullableOrNonnullAnnotation(out, definition);
                    arguments.add((CallSite)((Object)((String)(nullableAnnotation == null ? "" : "@" + nullableAnnotation + " ") + type + " " + columnMember)));
                }
                properties.add((CallSite)((Object)("\"" + this.escapeString(columnMember) + "\"")));
            }
            out.javadoc("Create a detached, initialised %s", className);
            if (this.scala) {
                if (pojoArgument) {
                    out.println("%sdef this(value: %s) = {", this.visibility(), out.ref(pojoNameFull));
                } else {
                    out.println("%sdef this([[%s]]) = {", this.visibility(), arguments);
                }
                out.println("this()", tableIdentifier);
                out.println();
            } else if (this.kotlin) {
                if (pojoArgument) {
                    out.println("%sconstructor(value: %s?): this() {", this.visibility(), out.ref(pojoNameFull));
                } else {
                    out.println("%sconstructor([[%s]]): this() {", this.visibility(), arguments);
                }
            } else {
                if (this.generateConstructorPropertiesAnnotationOnRecords()) {
                    out.println("@%s({ [[%s]] })", out.ref("java.beans.ConstructorProperties"), properties);
                }
                if (pojoArgument) {
                    out.println("%s%s(%s value) {", this.visibility(), className, out.ref(pojoNameFull));
                } else {
                    out.println("%s%s([[%s]]) {", this.visibility(), className, arguments);
                }
                if (tableUdtOrEmbeddable instanceof EmbeddableDefinition) {
                    out.println("this();", tableIdentifier);
                } else {
                    out.println("super(%s);", tableIdentifier);
                }
                out.println();
            }
            if (pojoArgument && degree > 0) {
                out.println("if (value != null) {");
            }
            for (Definition definition : columns) {
                String udtArrayElementType;
                String udtType;
                if (definition instanceof EmbeddableDefinition) {
                    if (this.kotlin) {
                        if (pojoArgument) {
                            out.println("this.%s = %s(%s) ?: %s([[%s]])", this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO), out.ref(this.getStrategy().getFullJavaClassName(definition, GeneratorStrategy.Mode.RECORD)), this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO), out.ref(this.getStrategy().getFullJavaClassName(definition, GeneratorStrategy.Mode.RECORD)), Collections.nCopies(((EmbeddableDefinition)definition).getColumns().size(), "null"));
                            continue;
                        }
                        out.println("this.%s = %s ?: %s([[%s]])", this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO), this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO), out.ref(this.getStrategy().getFullJavaClassName(definition, GeneratorStrategy.Mode.RECORD)), Collections.nCopies(((EmbeddableDefinition)definition).getColumns().size(), "null"));
                        continue;
                    }
                    if (this.scala) {
                        if (pojoArgument) {
                            out.println("this.%s(new %s(value.%s))", this.getStrategy().getJavaSetterName(definition, GeneratorStrategy.Mode.RECORD), out.ref(this.getStrategy().getFullJavaClassName(definition, GeneratorStrategy.Mode.RECORD)), this.getStrategy().getJavaGetterName(definition, GeneratorStrategy.Mode.DEFAULT));
                            continue;
                        }
                        out.println("this.%s(%s)", this.getStrategy().getJavaSetterName(definition, GeneratorStrategy.Mode.RECORD), this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.DEFAULT));
                        continue;
                    }
                    if (pojoArgument) {
                        out.println("%s(new %s(value.%s()));", this.getStrategy().getJavaSetterName(definition, GeneratorStrategy.Mode.RECORD), out.ref(this.getStrategy().getFullJavaClassName(definition, GeneratorStrategy.Mode.RECORD)), this.generatePojosAsJavaRecordClasses() ? this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO) : this.getStrategy().getJavaGetterName(definition, GeneratorStrategy.Mode.DEFAULT));
                        continue;
                    }
                    out.println("%s(%s);", this.getStrategy().getJavaSetterName(definition, GeneratorStrategy.Mode.RECORD), this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.DEFAULT));
                    continue;
                }
                TypedElementDefinition t = (TypedElementDefinition)definition;
                JavaTypeResolver r = this.resolver(out, GeneratorStrategy.Mode.RECORD);
                boolean isUDT = t.getType(r).isUDT();
                boolean isArray = t.getType(r).isArray();
                boolean isUDTArray = t.getType(r).isUDTArray();
                boolean isArrayOfUDTs = this.isArrayOfUDTs(t, r);
                String string = udtType = isUDT || isArray ? out.ref(this.getJavaType(((TypedElementDefinition)definition).getType(r), out, GeneratorStrategy.Mode.RECORD)) : "";
                String string2 = isUDTArray ? out.ref(this.database.getArray(t.getType(r).getSchema(), t.getType(r).getQualifiedUserType()).getElementType(r).getJavaType(r)) : (udtArrayElementType = isArrayOfUDTs ? out.ref(this.getArrayBaseType(t.getType(r).getJavaType(r))) : "");
                if (this.kotlin) {
                    if (pojoArgument) {
                        if (isUDTArray) {
                            out.println("this.%s = value.%s?.let { %s(it.map { it?.let { %s(it) } }) }", this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO), this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO), udtType, udtArrayElementType);
                            continue;
                        }
                        if (isArrayOfUDTs) {
                            out.println("this.%s = value.%s?.let { it.map { it?.let { %s(it) } }.toTypedArray() }", this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO), this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO), udtArrayElementType);
                            continue;
                        }
                        if (isUDT || isArray) {
                            out.println("this.%s = value.%s?.let { %s(it) }", this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO), this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO), udtType);
                            continue;
                        }
                        out.println("this.%s = value.%s", this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO), this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO));
                        continue;
                    }
                    out.println("this.%s = %s", this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO), this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO));
                    continue;
                }
                if (this.scala) {
                    if (pojoArgument) {
                        if (isUDTArray) {
                            out.println("this.%s(if (value.%s == null) null else new %s(value.%s.stream().map { it => new %s(it) }.collect(%s.toList())))", this.getStrategy().getJavaSetterName(definition, GeneratorStrategy.Mode.POJO), this.getStrategy().getJavaGetterName(definition, GeneratorStrategy.Mode.POJO), udtType, this.getStrategy().getJavaGetterName(definition, GeneratorStrategy.Mode.POJO), udtArrayElementType, Collectors.class);
                            continue;
                        }
                        if (isArrayOfUDTs) {
                            out.println("this.%s(if (value.%s == null) null else value.%s.map { it => new %s(it) })", this.getStrategy().getJavaSetterName(definition, GeneratorStrategy.Mode.POJO), this.getStrategy().getJavaGetterName(definition, GeneratorStrategy.Mode.POJO), this.getStrategy().getJavaGetterName(definition, GeneratorStrategy.Mode.POJO), udtArrayElementType);
                            continue;
                        }
                        if (isUDT || isArray) {
                            out.println("this.%s(if (value.%s == null) null else new %s(value.%s))", this.getStrategy().getJavaSetterName(definition, GeneratorStrategy.Mode.RECORD), this.getStrategy().getJavaGetterName(definition, GeneratorStrategy.Mode.POJO), udtType, this.getStrategy().getJavaGetterName(definition, GeneratorStrategy.Mode.POJO));
                            continue;
                        }
                        out.println("this.%s(value.%s)", this.getStrategy().getJavaSetterName(definition, GeneratorStrategy.Mode.RECORD), this.getStrategy().getJavaGetterName(definition, GeneratorStrategy.Mode.POJO));
                        continue;
                    }
                    out.println("this.%s(%s)", this.getStrategy().getJavaSetterName(definition, GeneratorStrategy.Mode.RECORD), this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO));
                    continue;
                }
                if (pojoArgument) {
                    if (isUDTArray) {
                        out.println("%s(value.%s() == null ? null : new %s(value.%s().stream().map(%s::new).collect(%s.toList())));", this.getStrategy().getJavaSetterName(definition, GeneratorStrategy.Mode.RECORD), this.getStrategy().getJavaGetterName(definition, GeneratorStrategy.Mode.POJO), udtType, this.generatePojosAsJavaRecordClasses() ? this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO) : this.getStrategy().getJavaGetterName(definition, GeneratorStrategy.Mode.POJO), udtArrayElementType, Collectors.class);
                        continue;
                    }
                    if (isArrayOfUDTs) {
                        out.println("%s(value.%s() == null ? null : %s.of(value.%s()).map(%s::new).toArray(%s[]::new));", this.getStrategy().getJavaSetterName(definition, GeneratorStrategy.Mode.RECORD), this.getStrategy().getJavaGetterName(definition, GeneratorStrategy.Mode.POJO), Stream.class, this.generatePojosAsJavaRecordClasses() ? this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO) : this.getStrategy().getJavaGetterName(definition, GeneratorStrategy.Mode.POJO), udtArrayElementType, udtArrayElementType);
                        continue;
                    }
                    if (isUDT || isArray) {
                        out.println("%s(value.%s() == null ? null : new %s(value.%s()));", this.getStrategy().getJavaSetterName(definition, GeneratorStrategy.Mode.RECORD), this.getStrategy().getJavaGetterName(definition, GeneratorStrategy.Mode.POJO), udtType, this.generatePojosAsJavaRecordClasses() ? this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO) : this.getStrategy().getJavaGetterName(definition, GeneratorStrategy.Mode.POJO));
                        continue;
                    }
                    out.println("%s(value.%s());", this.getStrategy().getJavaSetterName(definition, GeneratorStrategy.Mode.RECORD), this.generatePojosAsJavaRecordClasses() ? this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO) : this.getStrategy().getJavaGetterName(definition, GeneratorStrategy.Mode.POJO));
                    continue;
                }
                out.println("%s(%s);", this.getStrategy().getJavaSetterName(definition, GeneratorStrategy.Mode.RECORD), this.getStrategy().getJavaMemberName(definition, GeneratorStrategy.Mode.POJO));
            }
            if (pojoArgument && degree > 0) {
                out.println("}");
            }
            out.println("}");
        }
    }

    private boolean isArrayOfUDTs(TypedElementDefinition<?> t, JavaTypeResolver r) {
        String javaType = t.getType(r).getJavaType(r);
        if (!this.isArrayType(javaType)) {
            return false;
        }
        String baseType = this.getArrayBaseType(javaType);
        for (UDTDefinition udt : t.getDatabase().getUDTs()) {
            if (!baseType.equals(this.getStrategy().getFullJavaClassName((Definition)udt, GeneratorStrategy.Mode.RECORD))) continue;
            return true;
        }
        return false;
    }

    private String getJavaType(Definition column, JavaWriter out) {
        return this.getJavaType(column, out, GeneratorStrategy.Mode.RECORD);
    }

    private String getJavaType(Definition column, JavaWriter out, GeneratorStrategy.Mode mode) {
        return column instanceof EmbeddableDefinition ? this.getStrategy().getFullJavaClassName(column, mode) : this.getJavaType(((TypedElementDefinition)column).getType(this.resolver(out)), out);
    }

    private String getJavaTypeRef(Definition column, JavaWriter out) {
        return out.ref(this.getJavaType(column, out));
    }

    protected void generateRecordSetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generateRecordSetter0(column, index, out);
    }

    protected void generateEmbeddableSetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generateRecordSetter0(column, index, out);
    }

    protected void generateUDTRecordSetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generateRecordSetter0(column, index, out);
    }

    private final void generateRecordSetter0(TypedElementDefinition<?> column, int index, JavaWriter out) {
        boolean override;
        String className = this.getStrategy().getJavaClassName(column.getContainer(), GeneratorStrategy.Mode.RECORD);
        String setterReturnType = this.generateFluentSetters() && !this.kotlin ? className : this.tokenVoid;
        String setter = this.getStrategy().getJavaSetterName((Definition)column, GeneratorStrategy.Mode.RECORD);
        String member = this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO);
        String typeFull = this.getJavaType(column.getType(this.resolver(out)), out);
        String type = out.ref(typeFull);
        String name = column.getQualifiedOutputName();
        boolean isUDT = column.getType(this.resolver(out)).isUDT();
        boolean isArray = column.getType(this.resolver(out)).isArray();
        boolean isUDTArray = column.getType(this.resolver(out)).isUDTArray();
        boolean bl = override = this.generateInterfaces() && !this.generateImmutableInterfaces() && !isUDT;
        if (!this.generateInterfaces() || !isArray) {
            if (!this.kotlin && !this.printDeprecationIfUnknownType(out, typeFull)) {
                out.javadoc("Setter for <code>%s</code>.[[before= ][%s]]", name, JavaGenerator.list(this.escapeEntities(this.comment((Definition)column))));
            }
            if (this.scala) {
                out.println("%sdef %s(value: %s): %s = {", this.visibility(override), setter, type, setterReturnType);
                out.println("set(%s, value)", index);
                if (this.generateFluentSetters()) {
                    out.println("this");
                }
                out.println("}");
            } else if (this.kotlin) {
                out.println();
                if (column instanceof ColumnDefinition) {
                    this.printColumnJPAAnnotation(out, (ColumnDefinition)column);
                }
                this.printValidationAnnotation(out, column);
                this.printKotlinSetterAnnotation(out, column, GeneratorStrategy.Mode.RECORD);
                out.println("%s%svar %s: %s?", this.visibility(this.generateInterfaces()), this.generateInterfaces() ? "override " : "", member, type);
                ((JavaWriter)out.tab(1)).println("set(value): %s = set(%s, value)", setterReturnType, index);
            } else {
                String nullableAnnotation = this.nullableOrNonnullAnnotation(out, (Definition)column);
                out.overrideIf(override);
                out.println("%s%s %s([[before=@][after= ][%s]]%s value) {", this.visibility(override), setterReturnType, setter, JavaGenerator.list(nullableAnnotation), this.varargsIfArray(type));
                out.println("set(%s, value);", index);
                if (this.generateFluentSetters()) {
                    out.println("return this;");
                }
                out.println("}");
            }
        }
        if (this.generateInterfaces() && !this.generateImmutableInterfaces() && (isUDT || isArray)) {
            String columnTypeFull = this.getJavaType(column.getType(this.resolver(out, GeneratorStrategy.Mode.RECORD)), out, GeneratorStrategy.Mode.RECORD);
            String columnType = out.ref(columnTypeFull);
            String columnTypeInterface = out.ref(this.getJavaType(column.getType(this.resolver(out, GeneratorStrategy.Mode.INTERFACE)), out, GeneratorStrategy.Mode.INTERFACE));
            if (!this.printDeprecationIfUnknownType(out, columnTypeFull)) {
                out.javadoc("Setter for <code>%s</code>.[[before= ][%s]]", name, JavaGenerator.list(this.escapeEntities(this.comment((Definition)column))));
            }
            out.override();
            if (this.scala) {
                out.println("%sdef %s(value: %s): %s = {", this.visibility(), setter, columnTypeInterface, setterReturnType);
                out.println("if (value == null)");
                out.println("set(%s, null)", index);
                out.println("else");
                out.println("set(%s, value.into(new %s()))", index, type);
                if (this.generateFluentSetters()) {
                    out.println("this");
                }
                out.println("}");
            } else if (!this.kotlin) {
                String nullableAnnotation = this.nullableOrNonnullAnnotation(out, (Definition)column);
                out.println("%s%s %s([[before=@][after= ][%s]]%s value) {", this.visibility(), setterReturnType, setter, JavaGenerator.list(nullableAnnotation), this.varargsIfArray(columnTypeInterface));
                out.println("if (value == null)");
                out.println("set(%s, null);", index);
                if (isUDT) {
                    out.println("else");
                    out.println("set(%s, value.into(new %s()));", index, type);
                } else if (isArray) {
                    ArrayDefinition array = this.database.getArray(column.getType(this.resolver(out)).getSchema(), column.getType(this.resolver(out)).getQualifiedUserType());
                    String componentType = out.ref(this.getJavaType(array.getElementType(this.resolver(out, GeneratorStrategy.Mode.RECORD)), out, GeneratorStrategy.Mode.RECORD));
                    String componentTypeInterface = out.ref(this.getJavaType(array.getElementType(this.resolver(out, GeneratorStrategy.Mode.INTERFACE)), out, GeneratorStrategy.Mode.INTERFACE));
                    out.println("else {");
                    out.println("%s a = new %s();", columnType, columnType);
                    out.println();
                    out.println("for (%s i : value)", componentTypeInterface);
                    if (isUDTArray) {
                        out.println("a.add(i.into(new %s()));", componentType);
                    } else {
                        out.println("a.add(i);", componentType);
                    }
                    out.println();
                    out.println("set(1, a);");
                    out.println("}");
                }
                if (this.generateFluentSetters()) {
                    out.println("return this;");
                }
                out.println("}");
            }
        }
    }

    protected void generateEmbeddableRecordSetter(EmbeddableDefinition embeddable, int index, JavaWriter out) {
        boolean override;
        String className = this.getStrategy().getJavaClassName((Definition)embeddable.getReferencingTable(), GeneratorStrategy.Mode.RECORD);
        String setterReturnType = this.generateFluentSetters() ? className : this.tokenVoid;
        String member = this.getStrategy().getJavaMemberName((Definition)embeddable, GeneratorStrategy.Mode.POJO);
        String setter = this.getStrategy().getJavaSetterName((Definition)embeddable, GeneratorStrategy.Mode.RECORD);
        String typeFull = this.getStrategy().getFullJavaClassName((Definition)embeddable, this.generateInterfaces() ? GeneratorStrategy.Mode.INTERFACE : GeneratorStrategy.Mode.RECORD);
        String type = out.ref(typeFull);
        String name = embeddable.getQualifiedOutputName();
        boolean bl = override = this.generateInterfaces() && !this.generateImmutableInterfaces();
        if (!this.kotlin && !this.printDeprecationIfUnknownType(out, typeFull)) {
            out.javadoc("Setter for the embeddable <code>%s</code>.", name);
        }
        if (this.scala) {
            out.println("%sdef %s(value: %s): %s = {", this.visibility(override), setter, type, setterReturnType);
        } else if (this.kotlin) {
            out.println();
            out.println("%s%svar %s: %s", this.visibility(override), this.generateInterfaces() ? "override " : "", member, type);
            ((JavaWriter)out.tab(1)).println("set(value): %s {", setterReturnType);
        } else {
            out.overrideIf(override);
            out.println("%s%s %s([[before=@][after= ][%s]]%s value) {", this.visibility(override), setterReturnType, setter, JavaGenerator.list(this.nonnullAnnotation(out)), type);
        }
        if (index > -1) {
            if (this.kotlin) {
                ((JavaWriter)out.tab(1)).println("set(%s, value)", index);
            } else {
                out.println("set(%s, value)%s", index, this.semicolon);
            }
        } else {
            for (EmbeddableColumnDefinition column : embeddable.getColumns()) {
                int position = column.getReferencingColumnPosition() - 1;
                if (this.kotlin) {
                    ((JavaWriter)out.tab(1)).println("set(%s, value.%s)", position, this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO));
                    continue;
                }
                out.println("set(%s, value.%s%s)%s", position, this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.RECORD), this.emptyparens, this.semicolon);
            }
        }
        if (this.generateFluentSetters()) {
            if (this.scala) {
                out.println("this");
            } else {
                out.println("return this%s", this.semicolon);
            }
        }
        if (this.kotlin) {
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            out.println("}");
        }
    }

    protected void generateRecordGetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generateRecordGetter0(column, index, out);
    }

    protected void generateEmbeddableGetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generateRecordGetter0(column, index, out);
    }

    protected void generateUDTRecordGetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generateRecordGetter0(column, index, out);
    }

    private final void generateRecordGetter0(TypedElementDefinition<?> column, int index, JavaWriter out) {
        String getter = this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.RECORD);
        String typeFull = this.getJavaType(column.getType(this.resolver(out)), out);
        String type = out.ref(typeFull);
        String name = column.getQualifiedOutputName();
        if (!this.kotlin) {
            if (!this.printDeprecationIfUnknownType(out, typeFull)) {
                out.javadoc("Getter for <code>%s</code>.[[before= ][%s]]", name, JavaGenerator.list(this.escapeEntities(this.comment((Definition)column))));
            }
            if (column instanceof ColumnDefinition) {
                this.printColumnJPAAnnotation(out, (ColumnDefinition)column);
            }
            this.printValidationAnnotation(out, column);
        }
        this.printNullableOrNonnullAnnotation(out, (Definition)column);
        boolean override = this.generateInterfaces();
        if (this.scala) {
            out.println("%sdef %s: %s = get(%s).asInstanceOf[%s]", this.visibility(override), this.scalaWhitespaceSuffix(getter), type, index, type);
        } else if (this.kotlin) {
            String nullable = column instanceof EmbeddableDefinition ? "" : "?";
            ((JavaWriter)out.tab(1)).println("get(): %s%s = get(%s) as %s%s", type, nullable, index, type, nullable);
        } else {
            out.overrideIf(override);
            out.println("%s%s %s() {", this.visibility(override), type, getter);
            if (Object.class.getName().equals(typeFull)) {
                out.println("return get(%s);", index);
            } else {
                out.println("return (%s) get(%s);", type, index);
            }
            out.println("}");
        }
    }

    protected void generateEmbeddableRecordGetter(EmbeddableDefinition embeddable, int index, JavaWriter out) {
        String getter = this.getStrategy().getJavaGetterName((Definition)embeddable, GeneratorStrategy.Mode.RECORD);
        String typeFull = this.getStrategy().getFullJavaClassName((Definition)embeddable, GeneratorStrategy.Mode.RECORD);
        String type = out.ref(typeFull);
        String declaredType = out.ref(this.getStrategy().getFullJavaClassName((Definition)embeddable, this.generateInterfaces() ? GeneratorStrategy.Mode.INTERFACE : GeneratorStrategy.Mode.RECORD));
        String name = embeddable.getQualifiedOutputName();
        if (!this.kotlin && !this.printDeprecationIfUnknownType(out, typeFull)) {
            out.javadoc("Getter for the embeddable <code>%s</code>.", name);
        }
        boolean override = this.generateInterfaces();
        if (this.scala) {
            out.print("%sdef %s: %s = ", this.visibility(override), this.scalaWhitespaceSuffix(getter), type);
        } else if (this.kotlin) {
            ((JavaWriter)out.tab(1)).print("get(): %s = ", declaredType);
        } else {
            out.overrideIf(override);
            out.println("%s%s %s() {", this.visibility(override), type, getter);
        }
        if (index > -1) {
            if (this.scala) {
                out.println("get(%s).asInstanceOf[%s]", index, type);
            } else if (this.kotlin) {
                ((JavaWriter)out.tab(1)).println("get(%s) as %s", index, type);
            } else if (Object.class.getName().equals(typeFull)) {
                out.println("return get(%s);", index);
            } else {
                out.println("return (%s) get(%s);", type, index);
            }
        } else {
            if (this.scala) {
                out.println("new %s(", type);
            } else if (this.kotlin) {
                ((JavaWriter)out.tab(1)).println("%s(", type);
            } else {
                out.println("return new %s(", type);
            }
            this.forEach(embeddable.getColumns(), (column, separator) -> {
                String columnType = out.ref(this.getJavaType(column.getReferencingColumn().getType(this.resolver(out)), out));
                int position = column.getReferencingColumnPosition() - 1;
                if (this.scala) {
                    out.println("get(%s).asInstanceOf[%s]%s", position, columnType, separator);
                } else if (this.kotlin) {
                    ((JavaWriter)out.tab(1)).println("get(%s) as %s?%s", position, columnType, separator);
                } else if (Object.class.getName().equals(typeFull)) {
                    out.println("get(%s)%s", position, separator);
                } else {
                    out.println("(%s) get(%s)%s", columnType, position, separator);
                }
            });
            if (this.scala) {
                out.println(")");
            } else if (this.kotlin) {
                ((JavaWriter)out.tab(1)).println(")");
            } else {
                out.println(");");
            }
        }
        if (!this.scala && !this.kotlin) {
            out.println("}");
        }
    }

    private int colRefSegments(Definition column) {
        if (column instanceof TypedElementDefinition && ((TypedElementDefinition)column).getContainer() instanceof UDTDefinition) {
            return 2;
        }
        if (!this.getStrategy().getInstanceFields()) {
            return 2;
        }
        return 3;
    }

    protected void generateRecordClassFooter(TableDefinition table, JavaWriter out) {
    }

    protected void generateRecordClassJavadoc(TableDefinition table, JavaWriter out) {
        if (this.generateCommentsOnTables()) {
            this.printClassJavadoc(out, (Definition)table);
        } else {
            this.printClassJavadoc(out, "The table <code>" + table.getQualifiedInputName() + "</code>.");
        }
    }

    protected void generateEmbeddableClassFooter(EmbeddableDefinition embeddable, JavaWriter out) {
    }

    protected void generateEmbeddableClassJavadoc(EmbeddableDefinition embeddable, JavaWriter out) {
        this.printClassJavadoc(out, "The embeddable <code>" + embeddable.getQualifiedInputName() + "</code>.");
    }

    private String refRowType(JavaWriter out, Collection<? extends Definition> columns) {
        StringBuilder result = new StringBuilder();
        this.forEach(columns, "", ", ", (column, separator) -> {
            result.append(this.getJavaTypeRef((Definition)column, out));
            if (this.kotlin && !(column instanceof EmbeddableDefinition)) {
                result.append("?");
            }
            result.append((String)separator);
        });
        return result.toString();
    }

    protected void generateInterfaces(SchemaDefinition schema) {
        log.info((Object)"Generating table interfaces");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateInterface(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table interface " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table interfaces generated");
    }

    protected void generateInterface(TableDefinition table) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)table, GeneratorStrategy.Mode.INTERFACE));
        log.info((Object)"Generating interface", (Object)out.file().getName());
        this.generateInterface(table, out);
        this.closeJavaWriter(out);
    }

    protected void generateUDTInterface(UDTDefinition udt) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)udt, GeneratorStrategy.Mode.INTERFACE));
        log.info((Object)"Generating interface", (Object)out.file().getName());
        this.generateInterface0((Definition)udt, out);
        this.closeJavaWriter(out);
    }

    protected void generateEmbeddableInterface(EmbeddableDefinition embeddable) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)embeddable, GeneratorStrategy.Mode.INTERFACE));
        log.info((Object)"Generating interface", (Object)out.file().getName());
        this.generateInterface0((Definition)embeddable, out);
        this.closeJavaWriter(out);
    }

    protected void generateInterface(TableDefinition table, JavaWriter out) {
        this.generateInterface0((Definition)table, out);
    }

    protected void generateUDTInterface(UDTDefinition udt, JavaWriter out) {
        this.generateInterface0((Definition)udt, out);
    }

    private final void generateInterface0(Definition tableUdtOrEmbeddable, JavaWriter out) {
        String className = this.getStrategy().getJavaClassName(tableUdtOrEmbeddable, GeneratorStrategy.Mode.INTERFACE);
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements(tableUdtOrEmbeddable, GeneratorStrategy.Mode.INTERFACE));
        this.printPackage(out, tableUdtOrEmbeddable, GeneratorStrategy.Mode.INTERFACE);
        if (tableUdtOrEmbeddable instanceof TableDefinition) {
            this.generateInterfaceClassJavadoc((TableDefinition)tableUdtOrEmbeddable, out);
        } else if (tableUdtOrEmbeddable instanceof EmbeddableDefinition) {
            this.generateEmbeddableClassJavadoc((EmbeddableDefinition)tableUdtOrEmbeddable, out);
        } else {
            this.generateUDTInterfaceClassJavadoc((UDTDefinition)tableUdtOrEmbeddable, out);
        }
        this.printClassAnnotations(out, tableUdtOrEmbeddable, GeneratorStrategy.Mode.INTERFACE);
        if (tableUdtOrEmbeddable instanceof TableDefinition) {
            this.printTableJPAAnnotation(out, (TableDefinition)tableUdtOrEmbeddable);
        }
        if (this.scala) {
            out.println("%strait %s[[before= extends ][%s]] {", this.visibility(), className, interfaces);
        } else if (this.kotlin) {
            out.println("%sinterface %s[[before= : ][%s]] {", this.visibility(), className, interfaces);
        } else {
            out.println("%sinterface %s[[before= extends ][%s]] {", this.visibility(), className, interfaces);
        }
        List<? extends TypedElementDefinition<? extends Definition>> typedElements = this.getTypedElements(tableUdtOrEmbeddable);
        for (int i = 0; i < typedElements.size(); ++i) {
            TypedElementDefinition<? extends Definition> column = typedElements.get(i);
            if (!this.generateImmutableInterfaces()) {
                if (tableUdtOrEmbeddable instanceof TableDefinition) {
                    this.generateInterfaceSetter(column, i, out);
                } else {
                    this.generateUDTInterfaceSetter(column, i, out);
                }
            }
            if (tableUdtOrEmbeddable instanceof TableDefinition) {
                this.generateInterfaceGetter(column, i, out);
                continue;
            }
            this.generateUDTInterfaceGetter(column, i, out);
        }
        if (tableUdtOrEmbeddable instanceof TableDefinition) {
            List embeddables = ((TableDefinition)tableUdtOrEmbeddable).getReferencedEmbeddables();
            for (int i = 0; i < embeddables.size(); ++i) {
                EmbeddableDefinition embeddable = (EmbeddableDefinition)embeddables.get(i);
                this.generateEmbeddableInterfaceSetter(embeddable, i, out);
                this.generateEmbeddableInterfaceGetter(embeddable, i, out);
            }
        }
        if (!this.generateImmutableInterfaces()) {
            String local = this.getStrategy().getJavaClassName(tableUdtOrEmbeddable, GeneratorStrategy.Mode.INTERFACE);
            String qualified = out.ref(this.getStrategy().getFullJavaClassName(tableUdtOrEmbeddable, GeneratorStrategy.Mode.INTERFACE));
            out.header("FROM and INTO", new Object[0]);
            out.javadoc("Load data from another generated Record/POJO implementing the common interface %s", local);
            if (this.scala) {
                out.println("%sdef from(from: %s)", this.visibilityPublic(), qualified);
            } else if (this.kotlin) {
                out.println("%sfun from(from: %s)", this.visibilityPublic(), qualified);
            } else {
                out.println("%svoid from(%s from);", this.visibilityPublic(), qualified);
            }
            if (!this.scala) {
                out.javadoc("Copy data into another generated Record/POJO implementing the common interface %s", local);
                if (this.kotlin) {
                    out.println("%sfun <E : %s> into(into: E): E", this.visibilityPublic(), qualified);
                } else {
                    out.println("%s<E extends %s> E into(E into);", this.visibilityPublic(), qualified);
                }
            }
        }
        if (tableUdtOrEmbeddable instanceof TableDefinition) {
            this.generateInterfaceClassFooter((TableDefinition)tableUdtOrEmbeddable, out);
        } else if (tableUdtOrEmbeddable instanceof EmbeddableDefinition) {
            this.generateEmbeddableClassFooter((EmbeddableDefinition)tableUdtOrEmbeddable, out);
        } else {
            this.generateUDTInterfaceClassFooter((UDTDefinition)tableUdtOrEmbeddable, out);
        }
        out.println("}");
    }

    protected void generateInterfaceSetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generateInterfaceSetter0(column, index, out);
    }

    protected void generateEmbeddableInterfaceSetter(EmbeddableDefinition embeddable, int index, JavaWriter out) {
        String className = this.getStrategy().getJavaClassName((Definition)embeddable.getReferencingTable(), GeneratorStrategy.Mode.INTERFACE);
        String setterReturnType = this.generateFluentSetters() ? className : this.tokenVoid;
        String setter = this.getStrategy().getJavaSetterName((Definition)embeddable, GeneratorStrategy.Mode.INTERFACE);
        String typeFull = this.getStrategy().getFullJavaClassName((Definition)embeddable, GeneratorStrategy.Mode.INTERFACE);
        String type = out.ref(typeFull);
        if (!this.kotlin && !this.printDeprecationIfUnknownType(out, typeFull)) {
            out.javadoc("Setter for <code>%s</code>.", embeddable.getQualifiedOutputName());
        }
        if (this.scala) {
            out.println("%sdef %s(value: %s): %s", this.visibilityPublic(), setter, type, setterReturnType);
        } else if (!this.kotlin) {
            out.println("%s%s %s([[before=@][after= ][%s]]%s value);", this.visibilityPublic(), setterReturnType, setter, JavaGenerator.list(this.nonnullAnnotation(out)), type);
        }
    }

    protected void generateUDTInterfaceSetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generateInterfaceSetter0(column, index, out);
    }

    private final void generateInterfaceSetter0(TypedElementDefinition<?> column, int index, JavaWriter out) {
        String className = this.getStrategy().getJavaClassName(column.getContainer(), GeneratorStrategy.Mode.INTERFACE);
        String setterReturnType = this.generateFluentSetters() ? className : this.tokenVoid;
        String setter = this.getStrategy().getJavaSetterName((Definition)column, GeneratorStrategy.Mode.INTERFACE);
        String typeFull = this.getJavaType(column.getType(this.resolver(out, GeneratorStrategy.Mode.INTERFACE)), out, GeneratorStrategy.Mode.INTERFACE);
        String type = out.ref(typeFull);
        String name = column.getQualifiedOutputName();
        if (!this.kotlin && !this.printDeprecationIfUnknownType(out, typeFull)) {
            out.javadoc("Setter for <code>%s</code>.[[before= ][%s]]", name, JavaGenerator.list(this.escapeEntities(this.comment((Definition)column))));
        }
        if (this.scala) {
            out.println("%sdef %s(value: %s): %s", this.visibilityPublic(), setter, type, setterReturnType);
        } else if (!this.kotlin) {
            out.println("%s%s %s([[before=@][after= ][%s]]%s value);", this.visibilityPublic(), setterReturnType, setter, JavaGenerator.list(this.nullableOrNonnullAnnotation(out, (Definition)column)), this.varargsIfArray(type));
        }
    }

    protected void generateInterfaceGetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generateInterfaceGetter0(column, index, out);
    }

    protected void generateEmbeddableInterfaceGetter(EmbeddableDefinition embeddable, int index, JavaWriter out) {
        String member = this.getStrategy().getJavaMemberName((Definition)embeddable, GeneratorStrategy.Mode.POJO);
        String getter = this.getStrategy().getJavaGetterName((Definition)embeddable, GeneratorStrategy.Mode.INTERFACE);
        String typeFull = this.getStrategy().getFullJavaClassName((Definition)embeddable, GeneratorStrategy.Mode.INTERFACE);
        String type = out.ref(typeFull);
        String name = embeddable.getQualifiedOutputName();
        if (!this.kotlin && !this.printDeprecationIfUnknownType(out, typeFull)) {
            out.javadoc("Getter for <code>%s</code>.", name);
        }
        this.printNonnullAnnotation(out);
        if (this.scala) {
            out.println("%sdef %s: %s", this.visibilityPublic(), this.scalaWhitespaceSuffix(getter), type);
        } else if (this.kotlin) {
            out.println("%s%s %s: %s", this.visibilityPublic(), this.generateImmutableInterfaces() ? "val" : "var", member, type);
        } else {
            out.println("%s%s %s();", this.visibilityPublic(), type, getter);
        }
    }

    protected void generateUDTInterfaceGetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generateInterfaceGetter0(column, index, out);
    }

    private final void generateInterfaceGetter0(TypedElementDefinition<?> column, int index, JavaWriter out) {
        String member = this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO);
        String getter = this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.INTERFACE);
        String typeFull = this.getJavaType(column.getType(this.resolver(out, GeneratorStrategy.Mode.INTERFACE)), out, GeneratorStrategy.Mode.INTERFACE);
        String type = out.ref(typeFull);
        String name = column.getQualifiedOutputName();
        if (!this.kotlin && !this.printDeprecationIfUnknownType(out, typeFull)) {
            out.javadoc("Getter for <code>%s</code>.[[before= ][%s]]", name, JavaGenerator.list(this.escapeEntities(this.comment((Definition)column))));
        }
        if (column instanceof ColumnDefinition) {
            this.printColumnJPAAnnotation(out, (ColumnDefinition)column);
        }
        this.printValidationAnnotation(out, column);
        this.printNullableOrNonnullAnnotation(out, (Definition)column);
        if (this.kotlin) {
            this.printKotlinSetterAnnotation(out, column, GeneratorStrategy.Mode.INTERFACE);
        }
        if (this.scala) {
            out.println("%sdef %s: %s", this.visibilityPublic(), this.scalaWhitespaceSuffix(getter), type);
        } else if (this.kotlin) {
            out.println("%s%s %s: %s?", this.visibilityPublic(), this.generateImmutableInterfaces() ? "val" : "var", member, type);
        } else {
            out.println("%s%s %s();", this.visibilityPublic(), type, getter);
        }
    }

    protected void generateInterfaceClassFooter(TableDefinition table, JavaWriter out) {
    }

    protected void generateInterfaceClassJavadoc(TableDefinition table, JavaWriter out) {
        if (this.generateCommentsOnTables()) {
            this.printClassJavadoc(out, (Definition)table);
        } else {
            this.printClassJavadoc(out, "The table <code>" + table.getQualifiedInputName() + "</code>.");
        }
    }

    protected void generateUDTs(SchemaDefinition schema) {
        log.info((Object)"Generating UDTs");
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            try {
                this.generateUDT(schema, udt);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating udt " + udt), (Throwable)e);
            }
        }
        this.watch.splitInfo("UDTs generated");
    }

    protected void generateUDT(SchemaDefinition schema, UDTDefinition udt) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)udt));
        log.info((Object)"Generating UDT ", (Object)out.file().getName());
        if (log.isDebugEnabled()) {
            for (AttributeDefinition attribute : udt.getAttributes()) {
                log.debug((Object)"With attribute", (Object)("name=" + attribute.getOutputName() + ", matching type names=" + attribute.getDefinedType().getMatchNames()));
            }
        }
        this.generateUDT(udt, out);
        this.closeJavaWriter(out);
    }

    protected void generateUDT(UDTDefinition udt, JavaWriter out) {
        SchemaDefinition schema = udt.getSchema();
        PackageDefinition pkg = udt.getPackage();
        boolean synthetic = udt.isSynthetic();
        String className = this.getStrategy().getJavaClassName((Definition)udt);
        String recordType = out.ref(this.getStrategy().getFullJavaClassName((Definition)udt, GeneratorStrategy.Mode.RECORD));
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)udt, GeneratorStrategy.Mode.DEFAULT));
        String schemaId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)schema), 2);
        String packageId = pkg == null ? null : out.ref(this.getStrategy().getFullJavaIdentifier((Definition)pkg), 2);
        String udtId = out.ref(this.getStrategy().getJavaIdentifier((Definition)udt), 2);
        this.printPackage(out, (Definition)udt);
        if (this.scala) {
            out.println("object %s {", className);
            this.printSingletonInstance(out, (Definition)udt);
            for (AttributeDefinition attribute : udt.getAttributes()) {
                String attrId = out.ref(this.getStrategy().getJavaIdentifier((Definition)attribute), 2);
                out.javadoc("The attribute <code>%s</code>.[[before= ][%s]]", attribute.getQualifiedOutputName(), JavaGenerator.list(this.escapeEntities(this.comment((Definition)attribute))));
                out.println("val %s = %s.%s", attrId, udtId, attrId);
            }
            out.println("}");
            out.println();
        }
        this.generateUDTClassJavadoc(udt, out);
        this.printClassAnnotations(out, (Definition)udt, GeneratorStrategy.Mode.DEFAULT);
        if (this.scala) {
            out.println("%sclass %s extends %s[%s](\"%s\", null, %s, %s)[[before= with ][separator= with ][%s]] {", this.visibility(), className, UDTImpl.class, recordType, this.escapeString(udt.getOutputName()), packageId, synthetic, interfaces);
        } else if (this.kotlin) {
            out.println("%sopen class %s : %s<%s>(\"%s\", null, %s, %s)[[before=, ][%s]] {", this.visibility(), className, UDTImpl.class, recordType, this.escapeString(udt.getOutputName()), packageId, synthetic, interfaces);
            out.println();
            out.println("public companion object {");
            out.javadoc("The reference instance of <code>%s</code>", udt.getQualifiedOutputName());
            out.println("public val %s: %s = %s()", this.getStrategy().getJavaIdentifier((Definition)udt), className, className);
            out.println("}");
        } else {
            out.println("%sclass %s extends %s<%s>[[before= implements ][%s]] {", this.visibility(), className, UDTImpl.class, recordType, interfaces);
            out.printSerial();
            this.printSingletonInstance(out, (Definition)udt);
        }
        this.printRecordTypeMethod(out, (Definition)udt);
        for (AttributeDefinition attribute : udt.getAttributes()) {
            String attrTypeFull = this.getJavaType(attribute.getType(this.resolver(out)), out);
            String attrType = out.ref(attrTypeFull);
            String attrTypeRef = this.getJavaTypeReference(attribute.getDatabase(), attribute.getType(this.resolver(out)), out);
            String attrId = out.ref(this.getStrategy().getJavaIdentifier((Definition)attribute), 2);
            String attrName = attribute.getName();
            List<String> converter = out.ref(JavaGenerator.list(attribute.getType(this.resolver(out)).getConverter()));
            List<String> binding = out.ref(JavaGenerator.list(attribute.getType(this.resolver(out)).getBinding()));
            if (!this.printDeprecationIfUnknownType(out, attrTypeFull)) {
                out.javadoc("The attribute <code>%s</code>.[[before= ][%s]]", attribute.getQualifiedOutputName(), JavaGenerator.list(this.escapeEntities(this.comment((Definition)attribute))));
            }
            if (this.scala) {
                out.println("private val %s: %s[%s, %s] = %s.createField(%s.name(\"%s\"), %s, this, \"%s\"" + this.converterTemplate(converter) + this.converterTemplate(binding) + ")", this.scalaWhitespaceSuffix(attrId), UDTField.class, recordType, attrType, UDTImpl.class, DSL.class, this.escapeString(attrName), attrTypeRef, this.escapeString(""), converter, binding);
                continue;
            }
            if (this.kotlin) {
                out.println("%sval %s: %s<%s, %s> = %s.createField(%s.name(\"%s\"), %s, this, \"%s\"" + this.converterTemplate(converter) + this.converterTemplate(binding) + ")", this.visibility(), attrId, UDTField.class, recordType, attrType, UDTImpl.class, DSL.class, this.escapeString(attrName), attrTypeRef, this.escapeString(""), converter, binding);
                continue;
            }
            out.println("%sstatic final %s<%s, %s> %s = createField(%s.name(\"%s\"), %s, %s, \"%s\"" + this.converterTemplate(converter) + this.converterTemplate(binding) + ");", this.visibility(), UDTField.class, recordType, attrType, attrId, DSL.class, this.escapeString(attrName), attrTypeRef, udtId, this.escapeString(""), converter, binding);
        }
        for (RoutineDefinition routine : udt.getRoutines()) {
            try {
                if (!routine.isSQLUsable()) {
                    this.printConvenienceMethodProcedure(out, routine, false);
                    continue;
                }
                if (!routine.isAggregate()) {
                    this.printConvenienceMethodFunction(out, routine, false);
                }
                this.printConvenienceMethodFunctionAsField(out, routine, false);
                this.printConvenienceMethodFunctionAsField(out, routine, true);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating routine " + routine), (Throwable)e);
            }
        }
        if (!this.scala && !this.kotlin) {
            out.javadoc(NO_FURTHER_INSTANCES_ALLOWED, new Object[0]);
            out.println("private %s() {", className);
            out.println("super(\"%s\", null, %s, %s);", udt.getOutputName(), packageId, synthetic);
            out.println("}");
        }
        if (this.scala) {
            out.println();
            out.println("%soverride def getSchema: %s = %s", this.visibilityPublic(), Schema.class, schemaId);
        } else if (this.kotlin) {
            out.println();
            out.println("%s override fun getSchema(): %s = %s", this.visibilityPublic(), Schema.class, schemaId);
        } else {
            out.overrideInherit();
            out.println("%s%s getSchema() {", this.visibilityPublic(), Schema.class);
            out.println("return %s != null ? %s : new %s(%s.name(\"%s\"));", schemaId, schemaId, SchemaImpl.class, DSL.class, schema.getOutputName());
            out.println("}");
        }
        this.generateUDTClassFooter(udt, out);
        out.println("}");
        this.closeJavaWriter(out);
    }

    protected void generateUDTClassFooter(UDTDefinition udt, JavaWriter out) {
    }

    protected void generateUDTClassJavadoc(UDTDefinition udt, JavaWriter out) {
        if (this.generateCommentsOnUDTs()) {
            this.printClassJavadoc(out, (Definition)udt);
        } else {
            this.printClassJavadoc(out, "The udt <code>" + udt.getQualifiedInputName() + "</code>.");
        }
    }

    protected void generateUDTPojos(SchemaDefinition schema) {
        log.info((Object)"Generating UDT POJOs");
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            try {
                this.generateUDTPojo(udt);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating UDT POJO " + udt), (Throwable)e);
            }
        }
        this.watch.splitInfo("UDT POJOs generated");
    }

    protected void generateUDTPojoClassFooter(UDTDefinition udt, JavaWriter out) {
    }

    protected void generateUDTPojoClassJavadoc(UDTDefinition udt, JavaWriter out) {
        if (this.generateCommentsOnUDTs()) {
            this.printClassJavadoc(out, (Definition)udt);
        } else {
            this.printClassJavadoc(out, "The udt <code>" + udt.getQualifiedInputName() + "</code>.");
        }
    }

    protected void generateUDTInterfaces(SchemaDefinition schema) {
        log.info((Object)"Generating UDT interfaces");
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            try {
                this.generateUDTInterface(udt);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating UDT interface " + udt), (Throwable)e);
            }
        }
        this.watch.splitInfo("UDT interfaces generated");
    }

    protected void generateUDTInterfaceClassFooter(UDTDefinition udt, JavaWriter out) {
    }

    protected void generateUDTInterfaceClassJavadoc(UDTDefinition udt, JavaWriter out) {
        if (this.generateCommentsOnUDTs()) {
            this.printClassJavadoc(out, (Definition)udt);
        } else {
            this.printClassJavadoc(out, "The udt <code>" + udt.getQualifiedInputName() + "</code>.");
        }
    }

    protected void generateUDTRecords(SchemaDefinition schema) {
        log.info((Object)"Generating UDT records");
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            try {
                this.generateUDTRecord(udt);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating UDT record " + udt), (Throwable)e);
            }
        }
        this.watch.splitInfo("UDT records generated");
    }

    protected void generateUDTRecordClassFooter(UDTDefinition udt, JavaWriter out) {
    }

    protected void generateUDTRecordClassJavadoc(UDTDefinition udt, JavaWriter out) {
        if (this.generateCommentsOnUDTs()) {
            this.printClassJavadoc(out, (Definition)udt);
        } else {
            this.printClassJavadoc(out, "The udt <code>" + udt.getQualifiedInputName() + "</code>.");
        }
    }

    protected void generateUDTRoutines(SchemaDefinition schema) {
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            if (udt.getRoutines().size() <= 0) continue;
            try {
                log.info((Object)"Generating member routines");
                for (RoutineDefinition routine : udt.getRoutines()) {
                    try {
                        this.generateRoutine(schema, routine);
                    }
                    catch (Exception e) {
                        log.error((Object)("Error while generating member routines " + routine), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while generating UDT " + udt), (Throwable)e);
            }
            this.watch.splitInfo("Member procedures routines");
        }
    }

    protected void generateUDTReferences(Definition schemaOrPackage) {
        String logSuffix = schemaOrPackage instanceof SchemaDefinition ? "" : " for package " + schemaOrPackage.getOutputName();
        log.info((Object)("Generating UDT references" + logSuffix));
        JavaWriter out = this.newJavaWriter(this.getStrategy().getGlobalReferencesFile(schemaOrPackage, UDTDefinition.class));
        this.printGlobalReferencesPackage(out, schemaOrPackage, UDTDefinition.class);
        if (!this.kotlin) {
            this.printClassJavadoc(out, "Convenience access to all UDTs in " + this.schemaNameOrDefault(schemaOrPackage) + ".");
            this.printClassAnnotations(out, schemaOrPackage, GeneratorStrategy.Mode.DEFAULT);
        }
        String referencesClassName = this.getStrategy().getGlobalReferencesJavaClassName(schemaOrPackage, UDTDefinition.class);
        if (this.scala) {
            out.println("%sobject %s {", this.visibility(), referencesClassName);
        } else if (!this.kotlin) {
            out.println("%sclass %s {", this.visibility(), referencesClassName);
        }
        ArrayList<UDTDefinition> udts = new ArrayList<UDTDefinition>();
        if (schemaOrPackage instanceof SchemaDefinition) {
            for (UDTDefinition udt : this.database.getUDTs((SchemaDefinition)schemaOrPackage)) {
                if (udt.getPackage() != null) continue;
                udts.add(udt);
            }
        } else {
            udts.addAll(this.database.getUDTs((PackageDefinition)schemaOrPackage));
        }
        for (UDTDefinition udt : udts) {
            String className = out.ref(this.getStrategy().getFullJavaClassName((Definition)udt));
            String id = this.getStrategy().getJavaIdentifier((Definition)udt);
            String fullId = this.getStrategy().getFullJavaIdentifier((Definition)udt);
            out.javadoc("The type <code>%s</code>", udt.getQualifiedOutputName());
            if (this.scala) {
                out.println("%sdef %s = %s", this.visibility(), id, fullId);
                continue;
            }
            if (this.kotlin) {
                out.println("%sval %s: %s = %s", this.visibility(), id, className, fullId);
                continue;
            }
            out.println("%sstatic final %s %s = %s;", this.visibility(), className, id, fullId);
        }
        this.generateUDTReferencesClassFooter(schemaOrPackage, out);
        if (!this.kotlin) {
            out.println("}");
        }
        this.closeJavaWriter(out);
        this.watch.splitInfo("UDT references generated" + logSuffix);
        if (schemaOrPackage instanceof SchemaDefinition) {
            for (PackageDefinition pkg : this.database.getPackages((SchemaDefinition)schemaOrPackage)) {
                if (pkg.getUDTs().isEmpty()) continue;
                this.generateUDTReferences((Definition)pkg);
            }
        }
    }

    protected void generateUDTReferencesClassFooter(Definition schemaOrPackage, JavaWriter out) {
    }

    protected void generateUDTReferencesClassFooter(PackageDefinition pkg, JavaWriter out) {
    }

    protected void generateDomainReferences(SchemaDefinition schema) {
        log.info((Object)"Generating DOMAIN references");
        JavaWriter out = this.newJavaWriter(this.getStrategy().getGlobalReferencesFile((Definition)schema, DomainDefinition.class));
        out.refConflicts(this.getStrategy().getJavaIdentifiers(this.database.getDomains(schema)));
        this.printGlobalReferencesPackage(out, (Definition)schema, DomainDefinition.class);
        String schemaId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)schema), 2);
        if (!this.kotlin) {
            this.printClassJavadoc(out, "Convenience access to all Domains in " + this.schemaNameOrDefault((Definition)schema) + ".");
            this.printClassAnnotations(out, (Definition)schema, GeneratorStrategy.Mode.DOMAIN);
        }
        String referencesClassName = this.getStrategy().getGlobalReferencesJavaClassName((Definition)schema, DomainDefinition.class);
        if (this.scala) {
            out.println("%sobject %s {", this.visibility(), referencesClassName);
        } else if (!this.kotlin) {
            out.println("%sclass %s {", this.visibility(), referencesClassName);
        }
        for (DomainDefinition domain : this.database.getDomains(schema)) {
            String id = this.getStrategy().getJavaIdentifier((Definition)domain);
            String domainTypeFull = this.getJavaType(domain.getType(this.resolver(out)), out);
            String domainType = out.ref(domainTypeFull);
            String domainTypeRef = this.getJavaTypeReference(domain.getDatabase(), domain.getType(this.resolver(out)), out);
            out.javadoc("The domain <code>%s</code>.", domain.getQualifiedOutputName());
            if (this.scala) {
                out.println("%sval %s: %s[%s] = %s.createDomain(", this.visibility(), this.scalaWhitespaceSuffix(id), Domain.class, domainType, Internal.class);
                out.println("  schema");
                out.println(", %s.name(\"%s\")", DSL.class, this.escapeString(domain.getOutputName()));
                out.println(", %s", domainTypeRef);
                for (String check : domain.getCheckClauses()) {
                    out.println(", %s.createCheck(null, null, \"%s\")", Internal.class, this.escapeString(check));
                }
                out.println(")");
                continue;
            }
            if (this.kotlin) {
                out.println("%sval %s: %s<%s> = %s.createDomain(", this.visibility(), id, Domain.class, domainType, Internal.class);
                out.println("  schema()");
                out.println(", %s.name(\"%s\")", DSL.class, this.escapeString(domain.getOutputName()));
                out.println(", %s", domainTypeRef);
                for (String check : domain.getCheckClauses()) {
                    out.println(", %s.createCheck<%s>(null, null, \"%s\")", Internal.class, Record.class, this.escapeString(check));
                }
                out.println(")");
                continue;
            }
            out.println("%sstatic final %s<%s> %s = %s.createDomain(", this.visibility(), Domain.class, domainType, id, Internal.class);
            out.println("  schema()");
            out.println(", %s.name(\"%s\")", DSL.class, this.escapeString(domain.getOutputName()));
            out.println(", %s", domainTypeRef);
            for (String check : domain.getCheckClauses()) {
                out.println(", %s.createCheck(null, null, \"%s\")", Internal.class, this.escapeString(check));
            }
            out.println(");");
        }
        if (this.scala) {
            out.println();
            out.println("private def schema: %s = new %s(%s.name(\"%s\"), %s.comment(\"\"), () => %s)", Schema.class, LazySchema.class, DSL.class, this.escapeString(schema.getOutputName()), DSL.class, schemaId);
        } else if (this.kotlin) {
            out.println();
            out.println("private fun schema(): %s = %s(%s.name(\"%s\"), %s.comment(\"\"), %s { %s })", Schema.class, LazySchema.class, DSL.class, this.escapeString(schema.getOutputName()), DSL.class, LazySupplier.class, schemaId);
        } else {
            out.println();
            out.println("private static final %s schema() {", Schema.class);
            out.println("return new %s(%s.name(\"%s\"), %s.comment(\"\"), () -> %s);", LazySchema.class, DSL.class, this.escapeString(schema.getOutputName()), DSL.class, schemaId);
            out.println("}");
        }
        this.generateDomainReferencesClassFooter(schema, out);
        if (!this.kotlin) {
            out.println("}");
        }
        this.closeJavaWriter(out);
        this.watch.splitInfo("DOMAIN references generated");
    }

    protected void generateDomainReferencesClassFooter(SchemaDefinition schema, JavaWriter out) {
    }

    protected void generateArrays(SchemaDefinition schema) {
        log.info((Object)"Generating ARRAYs");
        for (ArrayDefinition array : this.database.getArrays(schema)) {
            try {
                this.generateArray(schema, array);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating ARRAY record " + array), (Throwable)e);
            }
        }
        this.watch.splitInfo("ARRAYs generated");
    }

    protected void generateArray(SchemaDefinition schema, ArrayDefinition array) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)array, GeneratorStrategy.Mode.RECORD));
        log.info((Object)"Generating ARRAY", (Object)out.file().getName());
        this.generateArray(array, out);
        this.closeJavaWriter(out);
    }

    protected void generateArray(ArrayDefinition array, JavaWriter out) {
    }

    protected void generateArrayClassFooter(ArrayDefinition array, JavaWriter out) {
    }

    protected void generateArrayClassJavadoc(ArrayDefinition array, JavaWriter out) {
        if (this.generateCommentsOnUDTs()) {
            this.printClassJavadoc(out, (Definition)array);
        } else {
            this.printClassJavadoc(out, "The type <code>" + array.getQualifiedInputName() + "</code>.");
        }
    }

    protected void generateEnums(SchemaDefinition schema) {
        log.info((Object)"Generating ENUMs");
        for (EnumDefinition e : this.database.getEnums(schema)) {
            try {
                this.generateEnum(e);
            }
            catch (Exception ex) {
                log.error((Object)("Error while generating enum " + e), (Throwable)ex);
            }
        }
        this.watch.splitInfo("Enums generated");
    }

    @Deprecated
    protected void generateDomains(SchemaDefinition schema) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateEnum(EnumDefinition e) {
        boolean s = this.scala;
        Language l = this.language;
        try {
            if (!this.generateEnumsAsScalaSealedTraits()) {
                this.scala = false;
                this.language = l == Language.SCALA ? Language.JAVA : l;
                this.getStrategy().setTargetLanguage(this.language);
            }
            JavaWriter out = this.newJavaWriter(this.getFile((Definition)e, GeneratorStrategy.Mode.ENUM));
            log.info((Object)"Generating ENUM", (Object)out.file().getName());
            this.generateEnum(e, out);
            this.closeJavaWriter(out);
        }
        finally {
            this.scala = s;
            this.language = l;
            this.getStrategy().setTargetLanguage(this.language);
        }
    }

    protected void generateEnum(EnumDefinition e, JavaWriter out) {
        boolean enumHasNoSchema;
        String className = this.getStrategy().getJavaClassName((Definition)e, GeneratorStrategy.Mode.ENUM);
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)e, GeneratorStrategy.Mode.ENUM));
        List literals = e.getLiterals();
        List<String> identifiers = this.getStrategy().getJavaEnumLiterals(e, literals);
        this.printPackage(out, (Definition)e);
        this.generateEnumClassJavadoc(e, out);
        this.printClassAnnotations(out, (Definition)e, GeneratorStrategy.Mode.ENUM);
        boolean bl = enumHasNoSchema = e.isSynthetic() || !(e.getDatabase() instanceof PostgresDatabase);
        if (this.scala) {
            int i;
            out.println("object %s {", className);
            out.println();
            for (String identifier : identifiers) {
                out.println("val %s: %s = %s.%s", this.scalaWhitespaceSuffix(identifier), className, this.getStrategy().getJavaPackageName((Definition)e), identifier);
            }
            out.println();
            out.println("def values: %s[%s] = %s(", out.ref("scala.Array"), className, out.ref("scala.Array"));
            for (i = 0; i < identifiers.size(); ++i) {
                out.print(i > 0 ? ", " : "  ");
                out.println(identifiers.get(i));
            }
            out.println(")");
            out.println();
            out.println("def valueOf(s: %s): %s = s match {", String.class, className);
            for (i = 0; i < identifiers.size(); ++i) {
                out.println("case \"%s\" => %s", literals.get(i), identifiers.get(i));
            }
            out.println("case _ => throw new %s()", IllegalArgumentException.class);
            out.println("}");
            out.println("}");
            out.println();
            out.println("sealed trait %s extends %s[[before= with ][%s]] {", className, EnumType.class, interfaces);
            if (enumHasNoSchema) {
                out.println("override def getCatalog: %s = null", Catalog.class);
            } else {
                out.println("override def getCatalog: %s = if (getSchema == null) null else getSchema().getCatalog()", Catalog.class);
            }
            out.println("override def getSchema: %s = %s", Schema.class, enumHasNoSchema ? "null" : out.ref(this.getStrategy().getFullJavaIdentifier((Definition)e.getSchema()), 2));
            out.println("override def getName: %s = %s", String.class, e.isSynthetic() ? "null" : "\"" + this.escapeString(e.getName()) + "\"");
            this.generateEnumClassFooter(e, out);
            out.println("}");
            for (i = 0; i < literals.size(); ++i) {
                out.println();
                out.println("case object %s extends %s {", identifiers.get(i), className);
                out.println("override def getLiteral: %s = \"%s\"", String.class, literals.get(i));
                out.println("}");
            }
        } else if (this.kotlin) {
            interfaces.add(out.ref(EnumType.class));
            out.println("%senum class %s(@get:JvmName(\"literal\") public val literal: String)[[before= : ][%s]] {", this.visibility(), className, interfaces);
            for (int i = 0; i < literals.size(); ++i) {
                out.println("%s(\"%s\")%s", identifiers.get(i), literals.get(i), i == literals.size() - 1 ? ";" : ",");
            }
            out.println("%soverride fun getCatalog(): %s? = %s", this.visibilityPublic(), Catalog.class, enumHasNoSchema ? "null" : "schema.catalog");
            out.println("%soverride fun getSchema(): %s%s = %s", this.visibilityPublic(), Schema.class, enumHasNoSchema ? "?" : "", enumHasNoSchema ? "null" : out.ref(this.getStrategy().getFullJavaIdentifier((Definition)e.getSchema()), 2));
            out.println("%soverride fun getName(): %s%s = %s", this.visibilityPublic(), String.class, e.isSynthetic() ? "?" : "", e.isSynthetic() ? "null" : "\"" + this.escapeString(e.getName()) + "\"");
            out.println("%soverride fun getLiteral(): String = literal", this.visibilityPublic());
            this.generateEnumClassFooter(e, out);
            out.println("}");
        } else {
            interfaces.add(out.ref(EnumType.class));
            out.println("%senum %s[[before= implements ][%s]] {", this.visibilityPublic(), className, interfaces);
            for (int i = 0; i < literals.size(); ++i) {
                out.println();
                out.println("%s(\"%s\")%s", identifiers.get(i), literals.get(i), i == literals.size() - 1 ? ";" : ",");
            }
            out.println();
            out.println("private final %s literal;", String.class);
            out.println();
            out.println("private %s(%s literal) {", className, String.class);
            out.println("this.literal = literal;");
            out.println("}");
            out.overrideInherit();
            out.println("%s%s getCatalog() {", this.visibilityPublic(), Catalog.class);
            if (enumHasNoSchema) {
                out.println("return null;");
            } else {
                out.println("return getSchema().getCatalog();");
            }
            out.println("}");
            out.overrideInherit();
            out.println("%s%s getSchema() {", this.visibilityPublic(), Schema.class);
            if (this.scalaConfigured) {
                out.println("return %s%s;", enumHasNoSchema ? "null" : this.getStrategy().getFullJavaIdentifier((Definition)e.getSchema()).replaceFirst("^(.*)\\.(.*?)$", "$1\\$.MODULE\\$.$2"), enumHasNoSchema ? "" : "()");
            } else {
                out.println("return %s;", enumHasNoSchema ? "null" : out.ref(this.getStrategy().getFullJavaIdentifier((Definition)e.getSchema()), 2));
            }
            out.println("}");
            out.overrideInherit();
            out.println("%s%s getName() {", this.visibilityPublic(), String.class);
            out.println("return %s;", e.isSynthetic() ? "null" : "\"" + this.escapeString(e.getName()) + "\"");
            out.println("}");
            out.overrideInherit();
            out.println("%s%s getLiteral() {", this.visibilityPublic(), String.class);
            out.println("return literal;");
            out.println("}");
            out.javadoc("Lookup a value of this EnumType by its literal", new Object[0]);
            out.println("%sstatic %s lookupLiteral(%s literal) {", this.visibilityPublic(), className, String.class);
            out.println("return %s.lookupLiteral(%s.class, literal);", EnumType.class, className);
            out.println("}");
            this.generateEnumClassFooter(e, out);
            out.println("}");
        }
    }

    protected void generateEnumClassFooter(EnumDefinition e, JavaWriter out) {
    }

    protected void generateEnumClassJavadoc(EnumDefinition e, JavaWriter out) {
        if (this.generateCommentsOnUDTs()) {
            this.printClassJavadoc(out, (Definition)e);
        } else {
            this.printClassJavadoc(out, "The enum <code>" + e.getQualifiedInputName() + "</code>.");
        }
    }

    @Deprecated
    protected void generateDomain(DomainDefinition d) {
    }

    @Deprecated
    protected void generateDomain(DomainDefinition d, JavaWriter out) {
    }

    @Deprecated
    protected void generateDomainClassFooter(DomainDefinition d, JavaWriter out) {
    }

    @Deprecated
    protected void generateDomainClassJavadoc(DomainDefinition e, JavaWriter out) {
    }

    protected void generateRoutines(SchemaDefinition schema) {
        log.info((Object)"Generating routines and table-valued functions");
        if (this.generateGlobalRoutineReferences()) {
            JavaWriter out = this.newJavaWriter(this.getStrategy().getGlobalReferencesFile((Definition)schema, RoutineDefinition.class));
            this.printGlobalReferencesPackage(out, (Definition)schema, RoutineDefinition.class);
            if (!this.kotlin) {
                this.printClassJavadoc(out, "Convenience access to all stored procedures and functions in " + this.schemaNameOrDefault((Definition)schema) + ".");
                this.printClassAnnotations(out, (Definition)schema, GeneratorStrategy.Mode.DEFAULT);
            }
            String referencesClassName = this.getStrategy().getGlobalReferencesJavaClassName((Definition)schema, RoutineDefinition.class);
            if (this.scala) {
                out.println("%sobject %s {", this.visibility(), referencesClassName);
            } else if (!this.kotlin) {
                out.println("%sclass %s {", this.visibility(), referencesClassName);
            }
            for (RoutineDefinition routine : this.database.getRoutines(schema)) {
                this.printRoutine(out, routine);
            }
            for (TableDefinition table : this.database.getTables(schema)) {
                if (!table.isTableValuedFunction()) continue;
                this.printTableValuedFunction(out, table, this.getStrategy().getJavaMethodName((Definition)table, GeneratorStrategy.Mode.DEFAULT));
            }
            this.generateRoutinesClassFooter(schema, out);
            if (!this.kotlin) {
                out.println("}");
            }
            this.closeJavaWriter(out);
        }
        for (RoutineDefinition routine : this.database.getRoutines(schema)) {
            try {
                this.generateRoutine(schema, routine);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating routine " + routine), (Throwable)e);
            }
        }
        this.watch.splitInfo("Routines generated");
    }

    protected void generateRoutinesClassFooter(SchemaDefinition schema, JavaWriter out) {
    }

    protected void printConstant(JavaWriter out, AttributeDefinition constant) {
    }

    protected void printRoutine(JavaWriter out, RoutineDefinition routine) {
        if (!routine.isSQLUsable()) {
            this.printConvenienceMethodProcedure(out, routine, false);
        } else {
            if (!routine.isAggregate()) {
                this.printConvenienceMethodFunction(out, routine, false);
            }
            this.printConvenienceMethodFunctionAsField(out, routine, false);
            this.printConvenienceMethodFunctionAsField(out, routine, true);
        }
    }

    protected void printTableValuedFunction(JavaWriter out, TableDefinition table, String javaMethodName) {
        this.printConvenienceMethodTableValuedFunction(out, table, javaMethodName);
        this.printConvenienceMethodTableValuedFunctionAsField(out, table, false, javaMethodName);
        this.printConvenienceMethodTableValuedFunctionAsField(out, table, true, javaMethodName);
    }

    protected void generatePackages(SchemaDefinition schema) {
    }

    protected void generatePackage(SchemaDefinition schema, PackageDefinition pkg) {
    }

    protected void generatePackage(PackageDefinition pkg, JavaWriter out) {
    }

    protected void generatePackageClassFooter(PackageDefinition pkg, JavaWriter out) {
    }

    protected void generatePackageClassJavadoc(PackageDefinition pkg, JavaWriter out) {
        this.printClassJavadoc(out, "Convenience access to all stored procedures and functions in " + pkg.getName());
    }

    protected void generateTableReferences(SchemaDefinition schema) {
        log.info((Object)"Generating table references");
        JavaWriter out = this.newJavaWriter(this.getStrategy().getGlobalReferencesFile((Definition)schema, TableDefinition.class));
        this.printGlobalReferencesPackage(out, (Definition)schema, TableDefinition.class);
        if (!this.kotlin) {
            this.printClassJavadoc(out, "Convenience access to all tables in " + this.schemaNameOrDefault((Definition)schema) + ".");
            this.printClassAnnotations(out, (Definition)schema, GeneratorStrategy.Mode.DEFAULT);
        }
        String referencesClassName = this.getStrategy().getGlobalReferencesJavaClassName((Definition)schema, TableDefinition.class);
        if (this.scala) {
            out.println("%sobject %s {", this.visibility(), referencesClassName);
        } else if (!this.kotlin) {
            out.println("%sclass %s {", this.visibility(), referencesClassName);
        }
        for (TableDefinition table : this.database.getTables(schema)) {
            String className = this.getStrategy().getJavaClassName((Definition)table);
            String fullClassName = this.scala ? "" : out.ref(this.getStrategy().getFullJavaClassName((Definition)table));
            String id = this.getStrategy().getJavaIdentifier((Definition)table);
            String referencedId = className.equals(id) ? this.getStrategy().getFullJavaIdentifier((Definition)table) : out.ref(this.getStrategy().getFullJavaIdentifier((Definition)table), 2);
            String comment = this.escapeEntities(this.comment((Definition)table));
            out.javadoc((String)(StringUtils.isBlank((String)comment) ? "The table <code>" + table.getQualifiedOutputName() + "</code>." : comment), new Object[0]);
            if (this.scala) {
                out.println("%sdef %s = %s", this.visibility(), id, referencedId);
            } else if (this.kotlin) {
                out.println("%sval %s: %s = %s", this.visibility(), id, fullClassName, referencedId);
            } else {
                out.println("%sstatic final %s %s = %s;", this.visibility(), fullClassName, id, referencedId);
            }
            if (!table.isTableValuedFunction()) continue;
            this.printTableValuedFunction(out, table, this.getStrategy().getJavaIdentifier((Definition)table));
        }
        this.generateTableReferencesClassFooter(schema, out);
        if (!this.kotlin) {
            out.println("}");
        }
        this.closeJavaWriter(out);
        this.watch.splitInfo("Table refs generated");
    }

    protected void generateTableReferencesClassFooter(SchemaDefinition schema, JavaWriter out) {
    }

    private String schemaNameOrDefault(Definition schema) {
        return StringUtils.isEmpty((String)schema.getOutputName()) ? "the default schema" : schema.getOutputName();
    }

    protected void generateDaos(SchemaDefinition schema) {
        log.info((Object)"Generating DAOs");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateDao(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table DAO " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table DAOs generated");
    }

    protected void generateDao(TableDefinition table) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)table, GeneratorStrategy.Mode.DAO));
        log.info((Object)"Generating DAO", (Object)out.file().getName());
        this.generateDao(table, out);
        this.closeJavaWriter(out);
    }

    protected void generateDao(TableDefinition table, JavaWriter out) {
        UniqueKeyDefinition key = table.getPrimaryKey();
        if (key == null) {
            log.info((Object)"Skipping DAO generation", (Object)out.file().getName());
            return;
        }
        String className = this.getStrategy().getJavaClassName((Definition)table, GeneratorStrategy.Mode.DAO);
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)table, GeneratorStrategy.Mode.DAO));
        String tableRecord = out.ref(this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
        String daoImpl = out.ref(DAOImpl.class);
        String tableIdentifier = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)table), 2);
        Object tType = this.scala || this.kotlin ? "Unit" : "Void";
        String pType = out.ref(this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO));
        List keyColumns = key.getKeyColumns();
        if (keyColumns.size() == 1) {
            tType = this.getJavaType(((ColumnDefinition)keyColumns.get(0)).getType(this.resolver(out)), out, GeneratorStrategy.Mode.POJO);
        } else if (keyColumns.size() <= 22) {
            StringBuilder generics = new StringBuilder();
            this.forEach(keyColumns, "", ", ", (column, separator) -> {
                generics.append(out.ref(this.getJavaType(column.getType(this.resolver(out)), out)));
                if (this.kotlin) {
                    generics.append("?");
                }
                generics.append((String)separator);
            });
            tType = this.scala ? Record.class.getName() + keyColumns.size() + "[" + generics + "]" : Record.class.getName() + keyColumns.size() + "<" + generics + ">";
        } else {
            tType = Record.class.getName();
        }
        tType = out.ref((String)tType);
        this.printPackage(out, (Definition)table, GeneratorStrategy.Mode.DAO);
        this.generateDaoClassJavadoc(table, out);
        this.printClassAnnotations(out, (Definition)table, GeneratorStrategy.Mode.DAO);
        if (this.generateSpringAnnotations()) {
            out.println("@%s", out.ref("org.springframework.stereotype.Repository"));
        }
        if (this.scala) {
            out.println("%sclass %s(configuration: %s) extends %s[%s, %s, %s](%s, classOf[%s], configuration)[[before= with ][separator= with ][%s]] {", this.visibility(), className, Configuration.class, daoImpl, tableRecord, pType, tType, tableIdentifier, pType, interfaces);
        } else if (this.kotlin) {
            out.println("%sopen class %s(configuration: %s?) : %s<%s, %s, %s>(%s, %s::class.java, configuration)[[before=, ][%s]] {", this.visibility(), className, Configuration.class, daoImpl, tableRecord, pType, tType, tableIdentifier, pType, interfaces);
        } else {
            out.println("%sclass %s extends %s<%s, %s, %s>[[before= implements ][%s]] {", this.visibility(), className, daoImpl, tableRecord, pType, tType, interfaces);
        }
        out.javadoc("Create a new %s without any configuration", className);
        if (this.scala) {
            out.println("%sdef this() = this(null)", this.visibility());
        } else if (this.kotlin) {
            out.println("%sconstructor(): this(null)", this.visibility());
        } else {
            out.println("%s%s() {", this.visibility(), className);
            out.println("super(%s, %s.class);", tableIdentifier, pType);
            out.println("}");
        }
        if (!this.scala && !this.kotlin) {
            out.javadoc("Create a new %s with an attached configuration", className);
            this.printDaoConstructorAnnotations(table, out);
            out.println("%s%s(%s configuration) {", this.visibility(), className, Configuration.class);
            out.println("super(%s, %s.class, configuration);", tableIdentifier, pType);
            out.println("}");
        }
        if (this.scala) {
            out.println();
            out.print("%soverride def getId(o: %s): %s = ", this.visibilityPublic(), pType, tType);
        } else if (this.kotlin) {
            out.println();
            out.print("%soverride fun getId(o: %s): %s? = ", this.visibilityPublic(), pType, tType);
        } else {
            out.overrideInherit();
            this.printNonnullAnnotation(out);
            out.println("%s%s getId(%s object) {", this.visibilityPublic(), tType, pType);
        }
        if (keyColumns.size() == 1) {
            if (this.scala) {
                out.println("o.%s", this.getStrategy().getJavaGetterName((Definition)keyColumns.get(0), GeneratorStrategy.Mode.POJO));
            } else if (this.kotlin) {
                out.println("o.%s", this.getStrategy().getJavaMemberName((Definition)keyColumns.get(0), GeneratorStrategy.Mode.POJO));
            } else {
                out.println("return object.%s();", this.generatePojosAsJavaRecordClasses() ? this.getStrategy().getJavaMemberName((Definition)keyColumns.get(0), GeneratorStrategy.Mode.POJO) : this.getStrategy().getJavaGetterName((Definition)keyColumns.get(0), GeneratorStrategy.Mode.POJO));
            }
        } else {
            StringBuilder params = new StringBuilder();
            this.forEach(keyColumns, "", ", ", (column, separator) -> {
                if (this.scala) {
                    params.append("o.").append(this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.POJO));
                } else if (this.kotlin) {
                    params.append("o.").append(this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO));
                } else {
                    params.append("object.").append(this.generatePojosAsJavaRecordClasses() ? this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO) : this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.POJO)).append("()");
                }
                params.append((String)separator);
            });
            if (this.scala || this.kotlin) {
                out.println("compositeKeyRecord(%s)", params.toString());
            } else {
                out.println("return compositeKeyRecord(%s);", params.toString());
            }
        }
        if (!this.scala && !this.kotlin) {
            out.println("}");
        }
        List<Definition> embeddablesAndUnreplacedColumns = this.embeddablesAndUnreplacedColumns((Definition)table);
        block0: for (Definition column2 : embeddablesAndUnreplacedColumns) {
            String colName = column2.getOutputName();
            String colClass = this.getStrategy().getJavaClassName(column2);
            String colTypeFull = this.getJavaType(column2, out, GeneratorStrategy.Mode.POJO);
            String colTypeRecord = out.ref(this.getJavaType(column2, out, GeneratorStrategy.Mode.RECORD));
            String colType = out.ref(colTypeFull);
            String colIdentifier = out.ref(this.getStrategy().getFullJavaIdentifier(column2), this.colRefSegments(column2));
            if (!this.printDeprecationIfUnknownType(out, colTypeFull)) {
                out.javadoc("Fetch records that have <code>%s BETWEEN lowerInclusive AND upperInclusive</code>", colName);
            }
            if (this.scala) {
                if (column2 instanceof EmbeddableDefinition) {
                    out.println("%sdef fetchRangeOf%s(lowerInclusive: %s, upperInclusive: %s): %s[%s] = fetchRange(%s, new %s(lowerInclusive), new %s(upperInclusive))", this.visibility(), colClass, colType, colType, List.class, pType, colIdentifier, colTypeRecord, colTypeRecord);
                } else {
                    out.println("%sdef fetchRangeOf%s(lowerInclusive: %s, upperInclusive: %s): %s[%s] = fetchRange(%s, lowerInclusive, upperInclusive)", this.visibility(), colClass, colType, colType, List.class, pType, colIdentifier);
                }
            } else if (this.kotlin) {
                if (column2 instanceof EmbeddableDefinition) {
                    out.println("%sfun fetchRangeOf%s(lowerInclusive: %s?, upperInclusive: %s?): %s<%s> = fetchRange(%s, if (lowerInclusive != null) %s(lowerInclusive) else null, if (upperInclusive != null) %s(upperInclusive) else null)", this.visibility(), colClass, colType, colType, out.ref(KLIST), pType, colIdentifier, colTypeRecord, colTypeRecord);
                } else {
                    out.println("%sfun fetchRangeOf%s(lowerInclusive: %s?, upperInclusive: %s?): %s<%s> = fetchRange(%s, lowerInclusive, upperInclusive)", this.visibility(), colClass, colType, colType, out.ref(KLIST), pType, colIdentifier);
                }
            } else {
                this.printNonnullAnnotation(out);
                out.println("%s%s<%s> fetchRangeOf%s(%s lowerInclusive, %s upperInclusive) {", this.visibility(), List.class, pType, colClass, colType, colType);
                if (column2 instanceof EmbeddableDefinition) {
                    out.println("return fetchRange(%s, new %s(lowerInclusive), new %s(upperInclusive));", colIdentifier, colTypeRecord, colTypeRecord);
                } else {
                    out.println("return fetchRange(%s, lowerInclusive, upperInclusive);", colIdentifier);
                }
                out.println("}");
            }
            if (!this.printDeprecationIfUnknownType(out, colTypeFull)) {
                out.javadoc("Fetch records that have <code>%s IN (values)</code>", colName);
            }
            if (this.scala) {
                if (column2 instanceof EmbeddableDefinition) {
                    out.println("%sdef fetchBy%s(values: %s*): %s[%s] = fetch(%s, values.map(v => new %s(v)).toArray:_*)", this.visibility(), colClass, colType, List.class, pType, colIdentifier, colTypeRecord);
                } else {
                    out.println("%sdef fetchBy%s(values: %s*): %s[%s] = fetch(%s, values:_*)", this.visibility(), colClass, colType, List.class, pType, colIdentifier);
                }
            } else if (this.kotlin) {
                String toTypedArray;
                String string = toTypedArray = PRIMITIVE_WRAPPERS.contains(colTypeFull) ? ".toTypedArray()" : "";
                if (column2 instanceof EmbeddableDefinition) {
                    out.println("%sfun fetchBy%s(vararg values: %s): %s<%s> = fetch(%s, values.map { %s(it) })", this.visibility(), colClass, colType, out.ref(KLIST), pType, colIdentifier, colTypeRecord);
                } else {
                    out.println("%sfun fetchBy%s(vararg values: %s): %s<%s> = fetch(%s, *values%s)", this.visibility(), colClass, colType, out.ref(KLIST), pType, colIdentifier, toTypedArray);
                }
            } else {
                this.printNonnullAnnotation(out);
                out.println("%s%s<%s> fetchBy%s(%s... values) {", this.visibility(), List.class, pType, colClass, colType);
                if (column2 instanceof EmbeddableDefinition) {
                    out.println("%s[] records = new %s[values.length];", colTypeRecord, colTypeRecord);
                    out.println();
                    out.println("for (int i = 0; i < values.length; i++)");
                    ((JavaWriter)out.tab(1)).println("records[i] = new %s(values[i]);", colTypeRecord);
                    out.println();
                    out.println("return fetch(%s, records);", colIdentifier);
                } else {
                    out.println("return fetch(%s, values);", colIdentifier);
                }
                out.println("}");
            }
            if (!(column2 instanceof ColumnDefinition)) continue;
            for (UniqueKeyDefinition uk : ((ColumnDefinition)column2).getKeys()) {
                if (uk.getKeyColumns().size() != 1 || !((ColumnDefinition)uk.getKeyColumns().get(0)).equals(column2)) continue;
                if (!this.printDeprecationIfUnknownType(out, colTypeFull)) {
                    out.javadoc("Fetch a unique record that has <code>%s = value</code>", colName);
                }
                if (this.scala) {
                    out.println("%sdef fetchOneBy%s(value: %s): %s = fetchOne(%s, value)", this.visibility(), colClass, colType, pType, colIdentifier);
                    continue block0;
                }
                if (this.kotlin) {
                    out.println("%sfun fetchOneBy%s(value: %s): %s? = fetchOne(%s, value)", this.visibility(), colClass, colType, pType, colIdentifier);
                    continue block0;
                }
                this.printNullableAnnotation(out);
                out.println("%s%s fetchOneBy%s(%s value) {", this.visibility(), pType, colClass, colType);
                out.println("return fetchOne(%s, value);", colIdentifier);
                out.println("}");
                if (!this.printDeprecationIfUnknownType(out, colTypeFull)) {
                    out.javadoc("Fetch a unique record that has <code>%s = value</code>", colName);
                }
                this.printNonnullAnnotation(out);
                out.println("%s%s<%s> fetchOptionalBy%s(%s value) {", this.visibility(), Optional.class, pType, colClass, colType);
                out.println("return fetchOptional(%s, value);", colIdentifier);
                out.println("}");
                continue block0;
            }
        }
        this.generateDaoClassFooter(table, out);
        out.println("}");
    }

    protected void printDaoConstructorAnnotations(TableDefinition table, JavaWriter out) {
        if (this.generateSpringAnnotations()) {
            out.println("@%s", out.ref("org.springframework.beans.factory.annotation.Autowired"));
        }
    }

    protected void generateDaoClassFooter(TableDefinition table, JavaWriter out) {
    }

    protected void generateDaoClassJavadoc(TableDefinition table, JavaWriter out) {
        if (this.generateCommentsOnTables()) {
            this.printClassJavadoc(out, (Definition)table);
        } else {
            this.printClassJavadoc(out, "The table <code>" + table.getQualifiedInputName() + "</code>.");
        }
    }

    protected void generatePojos(SchemaDefinition schema) {
        log.info((Object)"Generating table POJOs");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generatePojo(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table POJO " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table POJOs generated");
    }

    protected void generatePojo(TableDefinition table) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)table, GeneratorStrategy.Mode.POJO));
        log.info((Object)"Generating POJO", (Object)out.file().getName());
        this.generatePojo(table, out);
        this.closeJavaWriter(out);
    }

    protected void generateEmbeddablePojo(EmbeddableDefinition embeddable) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)embeddable, GeneratorStrategy.Mode.POJO));
        log.info((Object)"Generating POJO", (Object)out.file().getName());
        this.generatePojo0((Definition)embeddable, out);
        this.closeJavaWriter(out);
    }

    protected void generateUDTPojo(UDTDefinition udt) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)udt, GeneratorStrategy.Mode.POJO));
        log.info((Object)"Generating POJO", (Object)out.file().getName());
        this.generatePojo0((Definition)udt, out);
        this.closeJavaWriter(out);
    }

    protected void generatePojo(TableDefinition table, JavaWriter out) {
        this.generatePojo0((Definition)table, out);
    }

    protected void generateUDTPojo(UDTDefinition udt, JavaWriter out) {
        this.generatePojo0((Definition)udt, out);
    }

    /*
     * WARNING - void declaration
     */
    private final void generatePojo0(Definition tableUdtOrEmbeddable, JavaWriter out) {
        String className = this.getStrategy().getJavaClassName(tableUdtOrEmbeddable, GeneratorStrategy.Mode.POJO);
        String interfaceName = this.generateInterfaces() ? out.ref(this.getStrategy().getFullJavaClassName(tableUdtOrEmbeddable, GeneratorStrategy.Mode.INTERFACE)) : "";
        String superName = out.ref(this.getStrategy().getJavaClassExtends(tableUdtOrEmbeddable, GeneratorStrategy.Mode.POJO));
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements(tableUdtOrEmbeddable, GeneratorStrategy.Mode.POJO));
        if (this.generateInterfaces()) {
            interfaces.add(interfaceName);
        }
        List<String> superTypes = JavaGenerator.list(superName, interfaces);
        this.printPackage(out, tableUdtOrEmbeddable, GeneratorStrategy.Mode.POJO);
        if (tableUdtOrEmbeddable instanceof TableDefinition) {
            this.generatePojoClassJavadoc((TableDefinition)tableUdtOrEmbeddable, out);
        } else if (tableUdtOrEmbeddable instanceof EmbeddableDefinition) {
            this.generateEmbeddableClassJavadoc((EmbeddableDefinition)tableUdtOrEmbeddable, out);
        } else {
            this.generateUDTPojoClassJavadoc((UDTDefinition)tableUdtOrEmbeddable, out);
        }
        this.printClassAnnotations(out, tableUdtOrEmbeddable, GeneratorStrategy.Mode.POJO);
        if (tableUdtOrEmbeddable instanceof TableDefinition) {
            this.printTableJPAAnnotation(out, (TableDefinition)tableUdtOrEmbeddable);
        }
        int maxLength0 = 0;
        for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableUdtOrEmbeddable)) {
            maxLength0 = Math.max(maxLength0, out.ref(this.getJavaType(typedElementDefinition.getType(this.resolver(out, GeneratorStrategy.Mode.POJO)), out, GeneratorStrategy.Mode.POJO)).length());
        }
        int maxLength = maxLength0;
        if (this.scala) {
            out.println("%s%sclass %s(", this.visibility(), this.generatePojosAsScalaCaseClasses() ? "case " : "", className);
            this.forEach(this.getTypedElements(tableUdtOrEmbeddable), (column, separator) -> out.println("%s%s %s: %s%s", this.visibility(this.generateInterfaces()), this.generateImmutablePojos() ? "val" : "var", this.scalaWhitespaceSuffix(this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO)), out.ref(this.getJavaType(column.getType(this.resolver(out, GeneratorStrategy.Mode.POJO)), out, GeneratorStrategy.Mode.POJO)), separator));
            out.println(")[[before= extends ][%s]][[before= with ][separator= with ][%s]] {", JavaGenerator.first(superTypes), JavaGenerator.remaining(superTypes));
        } else if (this.kotlin) {
            out.println("%s%sclass %s(", this.visibility(), this.generatePojosAsKotlinDataClasses() ? "data " : "", className);
            this.forEach(this.getTypedElements(tableUdtOrEmbeddable), (column, separator) -> {
                String member = this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO);
                if (column instanceof ColumnDefinition) {
                    this.printColumnJPAAnnotation(out, (ColumnDefinition)column);
                }
                this.printValidationAnnotation(out, (TypedElementDefinition<?>)column);
                if (!this.generateImmutablePojos()) {
                    this.printKotlinSetterAnnotation(out, (TypedElementDefinition<?>)column, GeneratorStrategy.Mode.POJO);
                }
                out.println("%s%s%s %s: %s? = null%s", this.visibility(this.generateInterfaces()), this.generateInterfaces() ? "override " : "", this.generateImmutablePojos() ? "val" : "var", member, out.ref(this.getJavaType(column.getType(this.resolver(out, GeneratorStrategy.Mode.POJO)), out, GeneratorStrategy.Mode.POJO)), separator);
            });
            out.println(")[[before=: ][%s]] {", superTypes);
        } else {
            if (this.generatePojosAsJavaRecordClasses()) {
                out.println("%srecord %s(", this.visibility(), className);
                this.forEach(this.getTypedElements(tableUdtOrEmbeddable), (column, separator) -> out.println("%s %s%s", StringUtils.rightPad((String)out.ref(this.getJavaType(column.getType(this.resolver(out, GeneratorStrategy.Mode.POJO)), out, GeneratorStrategy.Mode.POJO)), (int)maxLength), this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO), separator));
                out.println(")[[before= implements ][%s]] {", interfaces);
            } else {
                out.println("%sclass %s[[before= extends ][%s]][[before= implements ][%s]] {", this.visibility(), className, JavaGenerator.list(superName), interfaces);
            }
            if (this.generateSerializablePojos() || this.generateSerializableInterfaces()) {
                out.printSerial();
            }
            out.println();
            if (!this.generatePojosAsJavaRecordClasses()) {
                for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableUdtOrEmbeddable)) {
                    out.println("private %s%s %s;", this.generateImmutablePojos() ? "final " : "", StringUtils.rightPad((String)out.ref(this.getJavaType(typedElementDefinition.getType(this.resolver(out, GeneratorStrategy.Mode.POJO)), out, GeneratorStrategy.Mode.POJO)), (int)maxLength0), this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO));
                }
            }
        }
        if (!this.generateImmutablePojos() && !this.generatePojosAsJavaRecordClasses()) {
            this.generatePojoDefaultConstructor(tableUdtOrEmbeddable, out);
        }
        if (!this.kotlin) {
            void var11_19;
            if (!this.generatePojosAsJavaRecordClasses()) {
                this.generatePojoCopyConstructor(tableUdtOrEmbeddable, out);
                this.generatePojoMultiConstructor(tableUdtOrEmbeddable, out);
            }
            List<? extends TypedElementDefinition<? extends Definition>> list = this.getTypedElements(tableUdtOrEmbeddable);
            boolean bl = false;
            while (var11_19 < list.size()) {
                TypedElementDefinition<? extends Definition> column4 = list.get((int)var11_19);
                if (!this.generatePojosAsJavaRecordClasses() || this.generateInterfaces()) {
                    if (tableUdtOrEmbeddable instanceof TableDefinition) {
                        this.generatePojoGetter(column4, (int)var11_19, out);
                    } else {
                        this.generateUDTPojoGetter(column4, (int)var11_19, out);
                    }
                }
                if (!this.generateImmutablePojos()) {
                    if (tableUdtOrEmbeddable instanceof TableDefinition) {
                        this.generatePojoSetter(column4, (int)var11_19, out);
                    } else {
                        this.generateUDTPojoSetter(column4, (int)var11_19, out);
                    }
                }
                ++var11_19;
            }
        }
        if (tableUdtOrEmbeddable instanceof TableDefinition) {
            void var11_21;
            List list = ((TableDefinition)tableUdtOrEmbeddable).getReferencedEmbeddables();
            boolean bl = false;
            while (var11_21 < list.size()) {
                EmbeddableDefinition embeddable = (EmbeddableDefinition)list.get((int)var11_21);
                if (!this.generateImmutablePojos()) {
                    this.generateEmbeddablePojoSetter(embeddable, (int)var11_21, out);
                }
                this.generateEmbeddablePojoGetter(embeddable, (int)var11_21, out);
                ++var11_21;
            }
        }
        if (this.generatePojosEqualsAndHashCode()) {
            this.generatePojoEqualsAndHashCode(tableUdtOrEmbeddable, out);
        }
        if (this.generatePojosToString()) {
            this.generatePojoToString(tableUdtOrEmbeddable, out);
        }
        if (this.generateInterfaces() && !this.generateImmutablePojos()) {
            this.printFromAndInto(out, tableUdtOrEmbeddable, GeneratorStrategy.Mode.POJO);
        }
        if (tableUdtOrEmbeddable instanceof TableDefinition) {
            this.generatePojoClassFooter((TableDefinition)tableUdtOrEmbeddable, out);
        } else if (tableUdtOrEmbeddable instanceof EmbeddableDefinition) {
            this.generateEmbeddableClassFooter((EmbeddableDefinition)tableUdtOrEmbeddable, out);
        } else {
            this.generateUDTPojoClassFooter((UDTDefinition)tableUdtOrEmbeddable, out);
        }
        out.println("}");
        this.closeJavaWriter(out);
    }

    protected void generatePojoMultiConstructor(Definition tableOrUDT, JavaWriter out) {
        String className = this.getStrategy().getJavaClassName(tableOrUDT, GeneratorStrategy.Mode.POJO);
        ArrayList<CallSite> properties = new ArrayList<CallSite>();
        int maxLength = 0;
        for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
            maxLength = Math.max(maxLength, out.ref(this.getJavaType(typedElementDefinition.getType(this.resolver(out, GeneratorStrategy.Mode.POJO)), out, GeneratorStrategy.Mode.POJO)).length());
            properties.add((CallSite)((Object)("\"" + this.escapeString(this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO)) + "\"")));
        }
        if (!this.scala && this.getTypedElements(tableOrUDT).size() > 0 && this.getTypedElements(tableOrUDT).size() < 256) {
            out.println();
            if (this.generateConstructorPropertiesAnnotationOnPojos()) {
                out.println("@%s({ [[%s]] })", out.ref("java.beans.ConstructorProperties"), properties);
            }
            out.print("%s%s(", this.visibility(), className);
            String separator1 = "";
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                String nullableAnnotation = this.nullableOrNonnullAnnotation(out, (Definition)typedElementDefinition);
                out.println(separator1);
                out.print("[[before=@][after= ][%s]]%s %s", JavaGenerator.list(nullableAnnotation), StringUtils.rightPad((String)out.ref(this.getJavaType(typedElementDefinition.getType(this.resolver(out, GeneratorStrategy.Mode.POJO)), out, GeneratorStrategy.Mode.POJO)), (int)maxLength), this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO));
                separator1 = ",";
            }
            out.println();
            out.println(") {");
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                String columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                out.println("this.%s = %s;", columnMember, columnMember);
            }
            out.println("}");
        }
    }

    protected void generatePojoCopyConstructor(Definition tableOrUDT, JavaWriter out) {
        String className = this.getStrategy().getJavaClassName(tableOrUDT, GeneratorStrategy.Mode.POJO);
        String interfaceName = this.generateInterfaces() ? out.ref(this.getStrategy().getFullJavaClassName(tableOrUDT, GeneratorStrategy.Mode.INTERFACE)) : "";
        out.println();
        if (this.scala) {
            out.println("%sdef this(value: %s) = this(", this.visibility(), this.generateInterfaces() ? interfaceName : className);
            this.forEach(this.getTypedElements(tableOrUDT), (column, separator) -> out.println("value.%s%s", this.generateInterfaces() ? this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.INTERFACE) : this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO), separator));
            out.println(")");
        } else if (!this.kotlin) {
            out.println("%s%s(%s value) {", this.visibility(), className, this.generateInterfaces() ? interfaceName : className);
            if (this.generatePojosAsJavaRecordClasses()) {
                out.println("this(");
                this.forEach(this.getTypedElements(tableOrUDT), (column, separator) -> out.println("value.%s%s%s", this.generateInterfaces() ? this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.INTERFACE) : this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO), this.generateInterfaces() ? "()" : "", separator));
                out.println(");");
            } else {
                for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                    out.println("this.%s = value.%s%s;", this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO), this.generateInterfaces() ? this.getStrategy().getJavaGetterName((Definition)typedElementDefinition, GeneratorStrategy.Mode.INTERFACE) : this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO), this.generateInterfaces() ? "()" : "");
                }
            }
            out.println("}");
        }
    }

    protected void generatePojoDefaultConstructor(Definition tableOrUDT, JavaWriter out) {
        String className = this.getStrategy().getJavaClassName(tableOrUDT, GeneratorStrategy.Mode.POJO);
        out.println();
        int size = this.getTypedElements(tableOrUDT).size();
        if (this.scala) {
            if (size > 0) {
                ArrayList<Object> nulls = new ArrayList<Object>(size);
                for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                    if (size == 1) {
                        nulls.add("null: " + out.ref(this.getJavaType(typedElementDefinition.getType(this.resolver(out, GeneratorStrategy.Mode.POJO)), out, GeneratorStrategy.Mode.POJO)));
                        continue;
                    }
                    nulls.add("null");
                }
                out.println("def this() = this([[%s]])", nulls);
            }
        } else if (!this.kotlin) {
            out.println("%s%s() {}", this.visibility(), className);
        }
    }

    protected void generatePojoGetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generatePojoGetter0(column, index, out);
    }

    protected void generateEmbeddablePojoGetter(EmbeddableDefinition embeddable, int index, JavaWriter out) {
        String columnTypeFull = this.getStrategy().getFullJavaClassName((Definition)embeddable, GeneratorStrategy.Mode.POJO);
        String columnType = out.ref(columnTypeFull);
        String columnGetter = this.getStrategy().getJavaGetterName((Definition)embeddable, GeneratorStrategy.Mode.POJO);
        String name = embeddable.getQualifiedOutputName();
        if (!this.kotlin && !this.printDeprecationIfUnknownType(out, columnTypeFull)) {
            out.javadoc("Getter for <code>%s</code>.", name);
        }
        this.printNonnullAnnotation(out);
        if (this.scala) {
            out.println("%sdef %s: %s = new %s(", this.visibility(this.generateInterfaces()), this.scalaWhitespaceSuffix(columnGetter), columnType, columnType);
        } else if (this.kotlin) {
            ((JavaWriter)out.tab(1)).println("get(): %s = %s(", columnType, columnType);
        } else {
            out.overrideIf(this.generateInterfaces());
            out.println("%s%s %s() {", this.visibility(this.generateInterfaces()), columnType, columnGetter);
            out.println("return new %s(", columnType);
        }
        this.forEach(embeddable.getColumns(), (column, separator) -> {
            if (this.kotlin) {
                ((JavaWriter)out.tab(1)).println("%s%s", this.getStrategy().getJavaMemberName((Definition)column.getReferencingColumn(), GeneratorStrategy.Mode.POJO), separator);
            } else {
                out.println("%s%s%s", this.generatePojosAsJavaRecordClasses() ? this.getStrategy().getJavaMemberName((Definition)column.getReferencingColumn(), GeneratorStrategy.Mode.POJO) : this.getStrategy().getJavaGetterName((Definition)column.getReferencingColumn(), GeneratorStrategy.Mode.POJO), this.emptyparens, separator);
            }
        });
        if (this.scala) {
            out.println(")");
        } else if (this.kotlin) {
            ((JavaWriter)out.tab(1)).println(")");
        } else {
            out.println(");");
            out.println("}");
        }
    }

    protected void generateUDTPojoGetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generatePojoGetter0(column, index, out);
    }

    private final void generatePojoGetter0(TypedElementDefinition<?> column, int index, JavaWriter out) {
        String columnTypeFull = this.getJavaType(column.getType(this.resolver(out, GeneratorStrategy.Mode.POJO)), out, GeneratorStrategy.Mode.POJO);
        String columnType = out.ref(columnTypeFull);
        String columnGetter = this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.POJO);
        String columnMember = this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO);
        String name = column.getQualifiedOutputName();
        if (!this.printDeprecationIfUnknownType(out, columnTypeFull)) {
            out.javadoc("Getter for <code>%s</code>.[[before= ][%s]]", name, JavaGenerator.list(this.escapeEntities(this.comment((Definition)column))));
        }
        if (column instanceof ColumnDefinition) {
            this.printColumnJPAAnnotation(out, (ColumnDefinition)column);
        }
        this.printValidationAnnotation(out, column);
        this.printNullableOrNonnullAnnotation(out, (Definition)column);
        if (this.scala) {
            out.println("%sdef %s: %s = this.%s", this.visibility(this.generateInterfaces()), this.scalaWhitespaceSuffix(columnGetter), columnType, columnMember);
        } else {
            out.overrideIf(this.generateInterfaces());
            out.println("%s%s %s() {", this.visibility(this.generateInterfaces()), columnType, columnGetter);
            out.println("return this.%s;", columnMember);
            out.println("}");
        }
    }

    protected void generatePojoSetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generatePojoSetter0(column, index, out);
    }

    protected void generateEmbeddablePojoSetter(EmbeddableDefinition embeddable, int index, JavaWriter out) {
        boolean override;
        String className = this.getStrategy().getJavaClassName((Definition)embeddable.getReferencingTable(), GeneratorStrategy.Mode.POJO);
        String columnTypeFull = this.getStrategy().getFullJavaClassName((Definition)embeddable, GeneratorStrategy.Mode.POJO);
        String columnType = out.ref(columnTypeFull);
        String columnSetterReturnType = this.generateFluentSetters() ? className : this.tokenVoid;
        String columnSetter = this.getStrategy().getJavaSetterName((Definition)embeddable, GeneratorStrategy.Mode.POJO);
        String columnMember = this.getStrategy().getJavaMemberName((Definition)embeddable, GeneratorStrategy.Mode.POJO);
        String name = embeddable.getQualifiedOutputName();
        boolean bl = override = this.generateInterfaces() && !this.generateImmutableInterfaces();
        if (!this.kotlin && !this.printDeprecationIfUnknownType(out, columnTypeFull)) {
            out.javadoc("Setter for <code>%s</code>.", name);
        }
        if (this.scala) {
            out.println("%sdef %s(value: %s): %s = {", this.visibility(override), columnSetter, columnType, columnSetterReturnType);
        } else if (this.kotlin) {
            out.println("%svar %s: %s", this.visibility(override), columnMember, columnType);
            ((JavaWriter)out.tab(1)).println("set(value): %s {", columnSetterReturnType);
        } else {
            out.overrideIf(override);
            out.println("%s%s %s([[before=@][after= ][%s]]%s value) {", this.visibility(), columnSetterReturnType, columnSetter, JavaGenerator.list(this.nonnullAnnotation(out)), columnType);
        }
        if (this.kotlin) {
            for (EmbeddableColumnDefinition column : embeddable.getColumns()) {
                String s = this.getStrategy().getJavaMemberName((Definition)column.getReferencingColumn(), GeneratorStrategy.Mode.POJO);
                String g = this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO);
                ((JavaWriter)out.tab(1)).println("%s = value.%s", s, g);
            }
        } else {
            for (EmbeddableColumnDefinition column : embeddable.getColumns()) {
                String s = this.getStrategy().getJavaSetterName((Definition)column.getReferencingColumn(), GeneratorStrategy.Mode.POJO);
                String g = this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.POJO);
                out.println("%s(value.%s%s)%s", s, g, this.emptyparens, this.semicolon);
            }
        }
        if (this.generateFluentSetters()) {
            out.println("return this;");
        }
        if (this.kotlin) {
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            out.println("}");
        }
    }

    protected void generateUDTPojoSetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generatePojoSetter0(column, index, out);
    }

    private final void generatePojoSetter0(TypedElementDefinition<?> column, int index, JavaWriter out) {
        String className = this.getStrategy().getJavaClassName(column.getContainer(), GeneratorStrategy.Mode.POJO);
        String columnTypeFull = this.getJavaType(column.getType(this.resolver(out, GeneratorStrategy.Mode.POJO)), out, GeneratorStrategy.Mode.POJO);
        String columnType = out.ref(columnTypeFull);
        String columnSetterReturnType = this.generateFluentSetters() ? className : this.tokenVoid;
        String columnSetter = this.getStrategy().getJavaSetterName((Definition)column, GeneratorStrategy.Mode.POJO);
        String columnMember = this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO);
        boolean isUDT = column.getType(this.resolver(out)).isUDT();
        boolean isUDTArray = column.getType(this.resolver(out)).isUDTArray();
        String name = column.getQualifiedOutputName();
        if (!this.generateInterfaces() || !isUDTArray) {
            if (!this.printDeprecationIfUnknownType(out, columnTypeFull)) {
                out.javadoc("Setter for <code>%s</code>.[[before= ][%s]]", name, JavaGenerator.list(this.escapeEntities(this.comment((Definition)column))));
            }
            if (this.scala) {
                out.println("%sdef %s(%s: %s): %s = {", this.visibility(), columnSetter, this.scalaWhitespaceSuffix(columnMember), columnType, columnSetterReturnType);
                out.println("this.%s = %s", columnMember, columnMember);
                if (this.generateFluentSetters()) {
                    out.println("this");
                }
                out.println("}");
            } else {
                String nullableAnnotation = this.nullableOrNonnullAnnotation(out, (Definition)column);
                out.overrideIf(this.generateInterfaces() && !this.generateImmutableInterfaces() && !isUDT);
                out.println("%s%s %s([[before=@][after= ][%s]]%s %s) {", this.visibility(), columnSetterReturnType, columnSetter, JavaGenerator.list(nullableAnnotation), this.varargsIfArray(columnType), columnMember);
                out.println("this.%s = %s;", columnMember, columnMember);
                if (this.generateFluentSetters()) {
                    out.println("return this;");
                }
                out.println("}");
            }
        }
        if (this.generateInterfaces() && (isUDT || isUDTArray)) {
            String columnTypeInterface = out.ref(this.getJavaType(column.getType(this.resolver(out, GeneratorStrategy.Mode.INTERFACE)), out, GeneratorStrategy.Mode.INTERFACE));
            out.println();
            if (this.scala) {
                out.println("%sdef %s(%s: %s): %s = {", this.visibility(), columnSetter, this.scalaWhitespaceSuffix(columnMember), columnTypeInterface, columnSetterReturnType);
                out.println("if (%s == null)", columnMember);
                out.println("this.%s = null", columnMember);
                out.println("else");
                out.println("this.%s = %s.into(new %s)", columnMember, columnMember, columnType);
                if (this.generateFluentSetters()) {
                    out.println("this");
                }
                out.println("}");
            } else {
                out.override();
                out.println("%s%s %s(%s %s) {", this.visibility(), columnSetterReturnType, columnSetter, this.varargsIfArray(columnTypeInterface), columnMember);
                out.println("if (%s == null)", columnMember);
                out.println("this.%s = null;", columnMember);
                if (isUDT) {
                    out.println("else");
                    out.println("this.%s = %s.into(new %s());", columnMember, columnMember, columnType);
                } else if (isUDTArray) {
                    ArrayDefinition array = this.database.getArray(column.getType(this.resolver(out)).getSchema(), column.getType(this.resolver(out)).getQualifiedUserType());
                    String componentType = out.ref(this.getJavaType(array.getElementType(this.resolver(out, GeneratorStrategy.Mode.POJO)), out, GeneratorStrategy.Mode.POJO));
                    String componentTypeInterface = out.ref(this.getJavaType(array.getElementType(this.resolver(out, GeneratorStrategy.Mode.INTERFACE)), out, GeneratorStrategy.Mode.INTERFACE));
                    out.println("else {");
                    out.println("this.%s = new %s();", columnMember, ArrayList.class);
                    out.println();
                    out.println("for (%s i : %s)", componentTypeInterface, columnMember);
                    out.println("this.%s.add(i.into(new %s()));", columnMember, componentType);
                    out.println("}");
                }
                if (this.generateFluentSetters()) {
                    out.println("return this;");
                }
                out.println("}");
            }
        }
    }

    protected void generatePojoEqualsAndHashCode(Definition tableOrUDT, JavaWriter out) {
        String columnMember;
        String className = this.getStrategy().getJavaClassName(tableOrUDT, GeneratorStrategy.Mode.POJO);
        out.println();
        if (this.scala) {
            out.println("%soverride def equals(obj: Any): scala.Boolean = {", this.visibilityPublic());
            out.println("if (this eq obj.asInstanceOf[AnyRef])");
            out.println("return true");
            out.println("if (obj == null)");
            out.println("return false");
            out.println("if (getClass() != obj.getClass())");
            out.println("return false");
            out.println("val other = obj.asInstanceOf[%s]", className);
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                out.println("if (%s == null) {", columnMember);
                out.println("if (other.%s != null)", columnMember);
                out.println("return false");
                out.println("}");
                if (this.isArrayType(this.getJavaType(typedElementDefinition.getType(this.resolver(out)), out))) {
                    out.println("else if (!(%s sameElements other.%s))", columnMember, columnMember);
                } else {
                    out.println("else if (!%s.equals(other.%s))", columnMember, columnMember);
                }
                out.println("return false");
            }
            out.println("true");
            out.println("}");
        } else if (this.kotlin) {
            out.println("%soverride fun equals(other: Any?): Boolean {", this.visibilityPublic());
            out.println("if (this === other)");
            out.println("return true");
            out.println("if (other === null)");
            out.println("return false");
            out.println("if (this::class != other::class)");
            out.println("return false");
            out.println("val o: %s = other as %s", className, className);
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                out.println("if (%s === null) {", columnMember);
                out.println("if (o.%s !== null)", columnMember);
                out.println("return false");
                out.println("}");
                if (this.isArrayType(this.getJavaType(typedElementDefinition.getType(this.resolver(out)), out))) {
                    out.println("else if (!%s.equals(%s, o.%s))", Arrays.class, columnMember, columnMember);
                } else {
                    out.println("else if (%s != o.%s)", columnMember, columnMember);
                }
                out.println("return false");
            }
            out.println("return true");
            out.println("}");
        } else {
            out.println("@Override");
            out.println("%sboolean equals(%s obj) {", this.visibilityPublic(), Object.class);
            out.println("if (this == obj)");
            out.println("return true;");
            out.println("if (obj == null)");
            out.println("return false;");
            out.println("if (getClass() != obj.getClass())");
            out.println("return false;");
            out.println("final %s other = (%s) obj;", className, className);
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                out.println("if (%s == null) {", columnMember);
                out.println("if (other.%s != null)", columnMember);
                out.println("return false;");
                out.println("}");
                if (this.isArrayType(this.getJavaType(typedElementDefinition.getType(this.resolver(out)), out))) {
                    out.println("else if (!%s.equals(%s, other.%s))", Arrays.class, columnMember, columnMember);
                } else {
                    out.println("else if (!%s.equals(other.%s))", columnMember, columnMember);
                }
                out.println("return false;");
            }
            out.println("return true;");
            out.println("}");
        }
        out.println();
        if (this.scala) {
            out.println("%soverride def hashCode: Int = {", this.visibilityPublic());
            out.println("val prime = 31");
            out.println("var result = 1");
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                if (this.isArrayType(this.getJavaType(typedElementDefinition.getType(this.resolver(out)), out))) {
                    out.println("result = prime * result + (if (this.%s == null) 0 else %s.toSeq.hashCode)", columnMember, columnMember);
                    continue;
                }
                out.println("result = prime * result + (if (this.%s == null) 0 else this.%s.hashCode)", columnMember, columnMember);
            }
            out.println("return result");
            out.println("}");
        } else if (this.kotlin) {
            out.println("%soverride fun hashCode(): Int {", this.visibilityPublic());
            out.println("val prime = 31");
            out.println("var result = 1");
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                if (this.isArrayType(this.getJavaType(typedElementDefinition.getType(this.resolver(out)), out))) {
                    out.println("result = prime * result + (if (this.%s === null) 0 else %s.hashCode(this.%s))", columnMember, Arrays.class, columnMember);
                    continue;
                }
                out.println("result = prime * result + (if (this.%s === null) 0 else this.%s.hashCode())", columnMember, columnMember);
            }
            out.println("return result");
            out.println("}");
        } else {
            out.println("@Override");
            out.println("%sint hashCode() {", this.visibilityPublic());
            out.println("final int prime = 31;");
            out.println("int result = 1;");
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                if (this.isArrayType(this.getJavaType(typedElementDefinition.getType(this.resolver(out)), out))) {
                    out.println("result = prime * result + ((this.%s == null) ? 0 : %s.hashCode(this.%s));", columnMember, Arrays.class, columnMember);
                    continue;
                }
                out.println("result = prime * result + ((this.%s == null) ? 0 : this.%s.hashCode());", columnMember, columnMember);
            }
            out.println("return result;");
            out.println("}");
        }
    }

    protected void generatePojoToString(Definition tableOrUDT, JavaWriter out) {
        String className = this.getStrategy().getJavaClassName(tableOrUDT, GeneratorStrategy.Mode.POJO);
        out.println();
        if (this.scala) {
            out.println("%soverride def toString: String = {", this.visibilityPublic());
            out.println("val sb = new %s(\"%s (\")", StringBuilder.class, className);
            out.println();
            String separator = "";
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                String columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                String columnType = this.getJavaType(typedElementDefinition.getType(this.resolver(out)), out);
                boolean array = this.isArrayType(columnType);
                if (columnType.equals("scala.Array[scala.Byte]")) {
                    out.println("sb%s.append(\"[binary...]\")", separator);
                } else if (array) {
                    out.println("sb%s.append(\"[\").append(if (this.%s == null) \"\" else %s.mkString(\", \")).append(\"]\")", separator, columnMember, columnMember);
                } else {
                    out.println("sb%s.append(%s)", separator, columnMember);
                }
                separator = ".append(\", \")";
            }
            out.println();
            out.println("sb.append(\")\")");
            out.println("sb.toString");
            out.println("}");
        } else if (this.kotlin) {
            out.println("%soverride fun toString(): String {", this.visibilityPublic());
            out.println("val sb = %s(\"%s (\")", StringBuilder.class, className);
            out.println();
            String separator = "";
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                String columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                String columnType = this.getJavaType(typedElementDefinition.getType(this.resolver(out)), out);
                boolean array = this.isArrayType(columnType);
                if (array && columnType.equals("kotlin.ByteArray")) {
                    out.println("sb%s.append(\"[binary...]\")", separator);
                } else if (array) {
                    out.println("sb%s.append(%s.toString(%s))", separator, Arrays.class, columnMember);
                } else {
                    out.println("sb%s.append(%s)", separator, columnMember);
                }
                separator = ".append(\", \")";
            }
            out.println();
            out.println("sb.append(\")\")");
            out.println("return sb.toString()");
            out.println("}");
        } else {
            out.println("@Override");
            out.println("%sString toString() {", this.visibilityPublic());
            out.println("%s sb = new %s(\"%s (\");", StringBuilder.class, StringBuilder.class, className);
            out.println();
            String separator = "";
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                String columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                String columnType = this.getJavaType(typedElementDefinition.getType(this.resolver(out)), out);
                boolean array = this.isArrayType(columnType);
                if (array && columnType.equals("byte[]")) {
                    out.println("sb%s.append(\"[binary...]\");", separator);
                } else if (array) {
                    out.println("sb%s.append(%s.toString(%s));", separator, Arrays.class, columnMember);
                } else {
                    out.println("sb%s.append(%s);", separator, columnMember);
                }
                separator = ".append(\", \")";
            }
            out.println();
            out.println("sb.append(\")\");");
            out.println("return sb.toString();");
            out.println("}");
        }
    }

    private List<? extends TypedElementDefinition<? extends Definition>> getTypedElements(Definition definition) {
        if (definition instanceof TableDefinition) {
            return ((TableDefinition)definition).getColumns();
        }
        if (definition instanceof EmbeddableDefinition) {
            return ((EmbeddableDefinition)definition).getColumns();
        }
        if (definition instanceof UDTDefinition) {
            return ((UDTDefinition)definition).getAttributes();
        }
        if (definition instanceof RoutineDefinition) {
            return ((RoutineDefinition)definition).getAllParameters();
        }
        throw new IllegalArgumentException("Unsupported type : " + definition);
    }

    protected void generatePojoClassFooter(TableDefinition table, JavaWriter out) {
    }

    protected void generatePojoClassJavadoc(TableDefinition table, JavaWriter out) {
        if (this.generateCommentsOnTables()) {
            this.printClassJavadoc(out, (Definition)table);
        } else {
            this.printClassJavadoc(out, "The table <code>" + table.getQualifiedInputName() + "</code>.");
        }
    }

    protected void generateTables(SchemaDefinition schema) {
        log.info((Object)"Generating tables");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateTable(schema, table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Tables generated");
    }

    protected void generateTable(SchemaDefinition schema, TableDefinition table) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)table));
        out.refConflicts(this.getStrategy().getJavaIdentifiers(table.getColumns()));
        out.refConflicts(this.getStrategy().getJavaIdentifiers(table.getReferencedEmbeddables()));
        log.info((Object)"Generating table", (Object)(out.file().getName() + " [input=" + table.getInputName() + ", output=" + table.getOutputName() + ", pk=" + (table.getPrimaryKey() != null ? table.getPrimaryKey().getName() : "N/A") + "]"));
        if (log.isDebugEnabled()) {
            for (ColumnDefinition column : table.getColumns()) {
                log.debug((Object)"With column", (Object)("name=" + column.getOutputName() + ", matching type names=" + column.getDefinedType().getMatchNames()));
            }
        }
        this.generateTable(table, out);
        this.closeJavaWriter(out);
    }

    protected void generateTable(TableDefinition table, JavaWriter out) {
        String columnId;
        String columnType;
        String columnTypeFull;
        Pattern p;
        List cc;
        List indexes;
        String columnType2;
        SchemaDefinition schema = table.getSchema();
        UniqueKeyDefinition primaryKey = table.getPrimaryKey();
        String className = this.getStrategy().getJavaClassName((Definition)table);
        String tableId = this.scala ? out.ref(this.getStrategy().getFullJavaIdentifier((Definition)table), 2) : this.getStrategy().getJavaIdentifier((Definition)table);
        String recordType = out.ref(this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)table, GeneratorStrategy.Mode.DEFAULT));
        String schemaId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)schema), 2);
        String tableType = table.isTemporary() ? "temporaryTable" : (table.isView() ? "view" : (table.isMaterializedView() ? "materializedView" : (table.isTableValuedFunction() ? "function" : "table")));
        List parameters = table.getParameters();
        this.printPackage(out, (Definition)table);
        if (this.scala) {
            out.println("object %s {", className);
            this.printSingletonInstance(out, (Definition)table);
            out.println("}");
            out.println();
        }
        this.generateTableClassJavadoc(table, out);
        this.printClassAnnotations(out, (Definition)table, GeneratorStrategy.Mode.DEFAULT);
        if (this.scala) {
            out.println("%sclass %s(", this.visibility(), className);
            out.println("alias: %s,", Name.class);
            out.println("child: %s[_ <: %s],", Table.class, Record.class);
            out.println("path: %s[_ <: %s, %s],", ForeignKey.class, Record.class, recordType);
            out.println("aliased: %s[%s],", Table.class, recordType);
            out.println("parameters: %s[ %s[_] ]", out.ref("scala.Array"), Field.class);
            out.println(")");
            out.println("extends %s[%s](", TableImpl.class, recordType);
            out.println("alias,");
            out.println("%s,", schemaId);
            out.println("child,");
            out.println("path,");
            out.println("aliased,");
            out.println("parameters,");
            out.println("%s.comment(\"%s\"),", DSL.class, this.escapeString(this.comment((Definition)table)));
            if ((this.generateSourcesOnViews() || table.isSynthetic()) && table.isView() && table.getSource() != null) {
                out.println("%s.%s(\"%s\")", TableOptions.class, tableType, this.escapeString(table.getSource()));
            } else if (table.isSynthetic() && table.isTableValuedFunction() && table.getSource() != null) {
                out.println("%s.%s(\"%s\")", TableOptions.class, tableType, this.escapeString(table.getSource()));
            } else {
                out.println("%s.%s", TableOptions.class, tableType);
            }
            out.println(")[[before= with ][separator= with ][%s]] {", interfaces);
        } else if (this.kotlin) {
            out.println("%sopen class %s(", this.visibility(), className);
            out.println("alias: %s,", Name.class);
            out.println("child: %s<out %s>?,", Table.class, Record.class);
            out.println("path: %s<out %s, %s>?,", ForeignKey.class, Record.class, recordType);
            out.println("aliased: %s<%s>?,", Table.class, recordType);
            out.println("parameters: Array<%s<*>?>?", Field.class);
            out.println("): %s<%s>(", TableImpl.class, recordType);
            out.println("alias,");
            out.println("%s,", schemaId);
            out.println("child,");
            out.println("path,");
            out.println("aliased,");
            out.println("parameters,");
            out.println("%s.comment(\"%s\"),", DSL.class, this.escapeString(this.comment((Definition)table)));
            if ((this.generateSourcesOnViews() || table.isSynthetic()) && table.isView() && table.getSource() != null) {
                out.println("%s.%s(\"%s\")", TableOptions.class, tableType, this.escapeString(table.getSource()));
            } else if (table.isSynthetic() && table.isTableValuedFunction() && table.getSource() != null) {
                out.println("%s.%s(\"%s\")", TableOptions.class, tableType, this.escapeString(table.getSource()));
            } else {
                out.println("%s.%s()", TableOptions.class, tableType);
            }
            out.println(")[[before=, ][%s]] {", interfaces);
            out.println("%scompanion object {", this.visibility());
            this.printSingletonInstance(out, (Definition)table);
            out.println("}");
        } else {
            out.println("%sclass %s extends %s<%s>[[before= implements ][%s]] {", this.visibility(), className, TableImpl.class, recordType, interfaces);
            out.printSerial();
            this.printSingletonInstance(out, (Definition)table);
        }
        this.printRecordTypeMethod(out, (Definition)table);
        if (table.isSynthetic()) {
            if (this.scala) {
                out.println();
                out.println("protected override def isSynthetic(): Boolean = true");
            } else if (this.kotlin) {
                out.println();
                out.println("protected override fun isSynthetic(): Boolean = true");
            } else {
                out.println();
                out.override();
                out.println("protected boolean isSynthetic() {");
                out.println("return true;");
                out.println("}");
            }
        }
        for (ColumnDefinition column : table.getColumns()) {
            String columnTypeFull2 = this.getJavaType(column.getType(this.resolver(out)), out);
            columnType2 = out.ref(columnTypeFull2);
            String columnTypeRef = this.getJavaTypeReference(column.getDatabase(), column.getType(this.resolver(out)), out);
            String columnId2 = out.ref(this.getStrategy().getJavaIdentifier((Definition)column), this.colRefSegments((Definition)column));
            String columnName = column.getName();
            List<String> converter = out.ref(JavaGenerator.list(column.getType(this.resolver(out)).getConverter()));
            List<String> binding = out.ref(JavaGenerator.list(column.getType(this.resolver(out)).getBinding()));
            String columnVisibility = this.visibility();
            if (!this.printDeprecationIfUnknownType(out, columnTypeFull2)) {
                out.javadoc("The column <code>%s</code>.[[before= ][%s]]", column.getQualifiedOutputName(), JavaGenerator.list(this.escapeEntities(this.comment((Definition)column))));
            }
            if (this.scala) {
                out.println("%sval %s: %s[%s, %s] = createField(%s.name(\"%s\"), %s, \"%s\"" + this.converterTemplate(converter) + this.converterTemplate(binding) + ")", columnVisibility, this.scalaWhitespaceSuffix(columnId2), TableField.class, recordType, columnType2, DSL.class, columnName, columnTypeRef, this.escapeString(this.comment((Definition)column)), converter, binding);
                continue;
            }
            if (this.kotlin) {
                out.println("%sval %s: %s<%s, %s?> = createField(%s.name(\"%s\"), %s, this, \"%s\"" + this.converterTemplate(converter) + this.converterTemplate(binding) + ")", columnVisibility, columnId2, TableField.class, recordType, columnType2, DSL.class, columnName, columnTypeRef, this.escapeString(this.comment((Definition)column)), converter, binding);
                continue;
            }
            String isStatic = this.generateInstanceFields() ? "" : "static ";
            String tableRef = this.generateInstanceFields() ? "this" : out.ref(this.getStrategy().getJavaIdentifier((Definition)table), 2);
            out.println("%s%sfinal %s<%s, %s> %s = createField(%s.name(\"%s\"), %s, %s, \"%s\"" + this.converterTemplate(converter) + this.converterTemplate(binding) + ");", columnVisibility, isStatic, TableField.class, recordType, columnType2, columnId2, DSL.class, columnName, columnTypeRef, tableRef, this.escapeString(this.comment((Definition)column)), converter, binding);
        }
        for (EmbeddableDefinition embeddable : table.getReferencedEmbeddables()) {
            String columnId3 = out.ref(this.getStrategy().getJavaIdentifier((Definition)embeddable), this.colRefSegments(null));
            columnType2 = out.ref(this.getStrategy().getFullJavaClassName((Definition)embeddable, GeneratorStrategy.Mode.RECORD));
            ArrayList<String> columnIds = new ArrayList<String>();
            for (EmbeddableColumnDefinition column : embeddable.getColumns()) {
                columnIds.add(out.ref(this.getStrategy().getJavaIdentifier((Definition)column.getReferencingColumn()), this.colRefSegments((Definition)column.getReferencingColumn())));
            }
            out.javadoc("The embeddable type <code>%s</code>.[[before= ][%s]]", embeddable.getOutputName(), JavaGenerator.list(this.escapeEntities(this.referencingComment(embeddable))));
            if (this.scala) {
                out.println("%sval %s: %s[%s, %s] = %s.createEmbeddable(%s.name(\"%s\"), classOf[%s], %s, this, [[%s]])", this.visibility(), this.scalaWhitespaceSuffix(columnId3), TableField.class, recordType, columnType2, Internal.class, DSL.class, this.escapeString(embeddable.getName()), columnType2, embeddable.replacesFields(), columnIds);
                continue;
            }
            if (this.kotlin) {
                out.println("%sval %s: %s<%s, %s> = %s.createEmbeddable(%s.name(\"%s\"), %s::class.java, %s, this, [[%s]])", this.visibility(), columnId3, TableField.class, recordType, columnType2, Internal.class, DSL.class, this.escapeString(embeddable.getName()), columnType2, embeddable.replacesFields(), columnIds);
                continue;
            }
            out.println("%sfinal %s<%s, %s> %s = %s.createEmbeddable(%s.name(\"%s\"), %s.class, %s, this, [[%s]]);", this.visibility(), TableField.class, recordType, columnType2, columnId3, Internal.class, DSL.class, this.escapeString(embeddable.getName()), columnType2, embeddable.replacesFields(), columnIds);
        }
        out.println();
        if (this.scala) {
            if (table.isTableValuedFunction()) {
                out.println("private def this(alias: %s, aliased: %s[%s]) = this(alias, null, null, aliased, %s(", Name.class, Table.class, recordType, out.ref("scala.Array"));
                this.forEach(parameters, (parameter, separator) -> {
                    String paramTypeRef = this.getJavaTypeReference(parameter.getDatabase(), parameter.getType(this.resolver(out)), out);
                    List<String> converter = out.ref(JavaGenerator.list(parameter.getType(this.resolver(out)).getConverter()));
                    List<String> binding = out.ref(JavaGenerator.list(parameter.getType(this.resolver(out)).getBinding()));
                    out.println("%s.value(null, %s" + this.converterTemplateForTableValuedFunction(converter) + this.converterTemplateForTableValuedFunction(binding) + ")%s", DSL.class, paramTypeRef, converter, binding, separator);
                });
                out.println("))");
            } else {
                out.println("private def this(alias: %s, aliased: %s[%s]) = this(alias, null, null, aliased, null)", Name.class, Table.class, recordType);
            }
        } else if (this.kotlin) {
            if (table.isTableValuedFunction()) {
                out.println("private constructor(alias: %s, aliased: %s<%s>?): this(alias, null, null, aliased, arrayOf(", Name.class, Table.class, recordType, Field.class, parameters.size());
                this.forEach(parameters, (parameter, separator) -> {
                    String paramTypeRef = this.getJavaTypeReference(parameter.getDatabase(), parameter.getType(this.resolver(out)), out);
                    List<String> converter = out.ref(JavaGenerator.list(parameter.getType(this.resolver(out)).getConverter()));
                    List<String> binding = out.ref(JavaGenerator.list(parameter.getType(this.resolver(out)).getBinding()));
                    out.println("%s.value(null, %s" + this.converterTemplateForTableValuedFunction(converter) + this.converterTemplateForTableValuedFunction(binding) + ")%s", DSL.class, paramTypeRef, converter, binding, separator);
                });
                out.println("))");
            } else {
                out.println("private constructor(alias: %s, aliased: %s<%s>?): this(alias, null, null, aliased, null)", Name.class, Table.class, recordType);
            }
            out.println("private constructor(alias: %s, aliased: %s<%s>?, parameters: Array<%s<*>?>?): this(alias, null, null, aliased, parameters)", Name.class, Table.class, recordType, Field.class);
        } else {
            out.println("private %s(%s alias, %s<%s> aliased) {", className, Name.class, Table.class, recordType);
            if (table.isTableValuedFunction()) {
                out.println("this(alias, aliased, new %s[] {", Field.class);
                this.forEach(parameters, (parameter, separator) -> {
                    String paramTypeRef = this.getJavaTypeReference(parameter.getDatabase(), parameter.getType(this.resolver(out)), out);
                    List<String> converter = out.ref(JavaGenerator.list(parameter.getType(this.resolver(out)).getConverter()));
                    List<String> binding = out.ref(JavaGenerator.list(parameter.getType(this.resolver(out)).getBinding()));
                    out.println("%s.val(null, %s" + this.converterTemplateForTableValuedFunction(converter) + this.converterTemplateForTableValuedFunction(binding) + ")%s", DSL.class, paramTypeRef, converter, binding, separator);
                });
                out.println("});");
            } else {
                out.println("this(alias, aliased, null);");
            }
            out.println("}");
            out.println();
            out.println("private %s(%s alias, %s<%s> aliased, %s<?>[] parameters) {", className, Name.class, Table.class, recordType, Field.class);
            if ((this.generateSourcesOnViews() || table.isSynthetic()) && table.isView() && table.getSource() != null) {
                out.println("super(alias, null, aliased, parameters, %s.comment(\"%s\"), %s.%s(\"%s\"));", DSL.class, this.escapeString(this.comment((Definition)table)), TableOptions.class, tableType, this.escapeString(table.getSource()));
            } else if (table.isSynthetic() && table.isTableValuedFunction() && table.getSource() != null) {
                out.println("super(alias, null, aliased, parameters, %s.comment(\"%s\"), %s.%s(\"%s\"));", DSL.class, this.escapeString(this.comment((Definition)table)), TableOptions.class, tableType, this.escapeString(table.getSource()));
            } else {
                out.println("super(alias, null, aliased, parameters, %s.comment(\"%s\"), %s.%s());", DSL.class, this.escapeString(this.comment((Definition)table)), TableOptions.class, tableType);
            }
            out.println("}");
        }
        if (this.scala) {
            out.javadoc("Create an aliased <code>%s</code> table reference", table.getQualifiedOutputName());
            out.println("%sdef this(alias: %s) = this(%s.name(alias), %s)", this.visibility(), String.class, DSL.class, tableId);
            out.javadoc("Create an aliased <code>%s</code> table reference", table.getQualifiedOutputName());
            out.println("%sdef this(alias: %s) = this(alias, %s)", this.visibility(), Name.class, tableId);
        } else if (this.kotlin) {
            out.javadoc("Create an aliased <code>%s</code> table reference", table.getQualifiedOutputName());
            out.println("%sconstructor(alias: %s): this(%s.name(alias))", this.visibility(), String.class, DSL.class);
            out.javadoc("Create an aliased <code>%s</code> table reference", table.getQualifiedOutputName());
            out.println("%sconstructor(alias: %s): this(alias, null)", this.visibility(), Name.class, tableId);
        } else if (this.generateInstanceFields()) {
            out.javadoc("Create an aliased <code>%s</code> table reference", table.getQualifiedOutputName());
            out.println("%s%s(%s alias) {", this.visibility(), className, String.class);
            out.println("this(%s.name(alias), %s);", DSL.class, tableId);
            out.println("}");
            out.javadoc("Create an aliased <code>%s</code> table reference", table.getQualifiedOutputName());
            out.println("%s%s(%s alias) {", this.visibility(), className, Name.class);
            out.println("this(alias, %s);", tableId);
            out.println("}");
        }
        if (this.scala) {
            out.javadoc("Create a <code>%s</code> table reference", table.getQualifiedOutputName());
            out.println("%sdef this() = this(%s.name(\"%s\"), null)", this.visibility(), DSL.class, this.escapeString(table.getOutputName()));
        } else if (this.kotlin) {
            out.javadoc("Create a <code>%s</code> table reference", table.getQualifiedOutputName());
            out.println("%sconstructor(): this(%s.name(\"%s\"), null)", this.visibility(), DSL.class, this.escapeString(table.getOutputName()));
        } else {
            if (this.generateInstanceFields()) {
                out.javadoc("Create a <code>%s</code> table reference", table.getQualifiedOutputName());
                out.println("%s%s() {", this.visibility(), className);
            } else {
                out.javadoc(NO_FURTHER_INSTANCES_ALLOWED, new Object[0]);
                out.println("private %s() {", className);
            }
            out.println("this(%s.name(\"%s\"), null);", DSL.class, this.escapeString(table.getOutputName()));
            out.println("}");
        }
        if (this.generateImplicitJoinPathsToOne() && this.generateGlobalKeyReferences() && !table.isTableValuedFunction()) {
            out.println();
            if (this.scala) {
                out.println("%sdef this(child: %s[_ <: %s], key: %s[_ <: %s, %s]) = this(%s.createPathAlias(child, key), child, key, %s, null)", this.visibility(), Table.class, Record.class, ForeignKey.class, Record.class, recordType, Internal.class, tableId);
            } else if (this.kotlin) {
                out.println("%sconstructor(child: %s<out %s>, key: %s<out %s, %s>): this(%s.createPathAlias(child, key), child, key, %s, null)", this.visibility(), Table.class, Record.class, ForeignKey.class, Record.class, recordType, Internal.class, tableId);
            } else {
                out.println("%s<O extends %s> %s(%s<O> child, %s<O, %s> key) {", this.visibility(), Record.class, className, Table.class, ForeignKey.class, recordType);
                out.println("super(child, key, %s);", tableId);
                out.println("}");
            }
        }
        if (this.scala) {
            out.println();
            out.println("%soverride def getSchema: %s = if (aliased()) null else %s", this.visibilityPublic(), Schema.class, schemaId);
        } else if (this.kotlin) {
            out.println("%soverride fun getSchema(): %s? = if (aliased()) null else %s", this.visibilityPublic(), Schema.class, schemaId);
        } else {
            out.overrideInherit();
            this.printNonnullAnnotation(out);
            out.println("%s%s getSchema() {", this.visibilityPublic(), Schema.class);
            out.println("return aliased() ? null : %s;", schemaId);
            out.println("}");
        }
        if (this.generateIndexes() && !(indexes = table.getIndexes()).isEmpty()) {
            if (this.generateGlobalIndexReferences()) {
                List<String> indexFullIds;
                List<String> list = indexFullIds = this.kotlin ? out.ref(this.getStrategy().getFullJavaIdentifiers(indexes)) : out.ref(this.getStrategy().getFullJavaIdentifiers(indexes), 2);
                if (this.scala) {
                    out.println();
                    out.println("%soverride def getIndexes: %s[%s] = %s.asList[ %s ]([[%s]])", this.visibilityPublic(), List.class, Index.class, Arrays.class, Index.class, indexFullIds);
                } else if (this.kotlin) {
                    out.println("%soverride fun getIndexes(): %s<%s> = listOf([[%s]])", this.visibilityPublic(), out.ref(KLIST), Index.class, indexFullIds);
                } else {
                    out.overrideInherit();
                    this.printNonnullAnnotation(out);
                    out.println("%s%s<%s> getIndexes() {", this.visibilityPublic(), List.class, Index.class);
                    out.println("return %s.asList([[%s]]);", Arrays.class, indexFullIds);
                    out.println("}");
                }
            } else if (this.scala) {
                out.println();
                out.println("%soverride def getIndexes: %s[%s] = %s.asList[%s](", this.visibilityPublic(), List.class, Index.class, Arrays.class, Index.class);
                this.forEach(indexes, "", ", ", (index, separator) -> {
                    this.printCreateIndex(out, (IndexDefinition)index);
                    out.println("%s", separator);
                });
                out.println(")");
            } else if (this.kotlin) {
                out.println("%soverride fun getIndexes(): %s<%s> = listOf(", this.visibilityPublic(), out.ref(KLIST), Index.class);
                this.forEach(indexes, "", ", ", (index, separator) -> {
                    this.printCreateIndex(out, (IndexDefinition)index);
                    out.println("%s", separator);
                });
                out.println(")");
            } else {
                out.overrideInherit();
                this.printNonnullAnnotation(out);
                out.println("%s%s<%s> getIndexes() {", this.visibilityPublic(), List.class, Index.class);
                out.println("return %s.asList(", Arrays.class);
                this.forEach(indexes, "", ", ", (index, separator) -> {
                    this.printCreateIndex(out, (IndexDefinition)index);
                    out.println("%s", separator);
                });
                out.println(");");
                out.println("}");
            }
        }
        if (this.generateRelations()) {
            List foreignKeys;
            String[] uniqueKeys;
            IdentityDefinition identity = table.getIdentity();
            if (identity != null) {
                String identityTypeFull = this.getJavaType(identity.getColumn().getType(this.resolver(out)), out);
                String identityType = out.ref(identityTypeFull);
                if (this.scala) {
                    out.println();
                    this.printDeprecationIfUnknownType(out, identityTypeFull);
                    out.println("%soverride def getIdentity: %s[%s, %s] = super.getIdentity.asInstanceOf[ %s[%s, %s] ]", this.visibilityPublic(), Identity.class, recordType, identityType, Identity.class, recordType, identityType);
                } else if (this.kotlin) {
                    this.printDeprecationIfUnknownType(out, identityTypeFull);
                    out.println("%soverride fun getIdentity(): %s<%s, %s?> = super.getIdentity() as %s<%s, %s?>", this.visibilityPublic(), Identity.class, recordType, identityType, Identity.class, recordType, identityType);
                } else {
                    if (this.printDeprecationIfUnknownType(out, identityTypeFull)) {
                        out.override();
                    } else {
                        out.overrideInherit();
                    }
                    this.printNonnullAnnotation(out);
                    out.println("%s%s<%s, %s> getIdentity() {", this.visibilityPublic(), Identity.class, recordType, identityType);
                    out.println("return (%s<%s, %s>) super.getIdentity();", Identity.class, recordType, identityType);
                    out.println("}");
                }
            }
            if (primaryKey != null) {
                String keyFullId;
                String string = this.generateGlobalKeyReferences() ? (this.kotlin ? out.ref(this.getStrategy().getFullJavaIdentifier((Definition)primaryKey)) : out.ref(this.getStrategy().getFullJavaIdentifier((Definition)primaryKey), 2)) : (keyFullId = null);
                if (this.scala) {
                    out.println();
                    out.print("%soverride def getPrimaryKey: %s[%s] = ", this.visibilityPublic(), UniqueKey.class, recordType);
                    if (keyFullId != null) {
                        out.print("%s", keyFullId);
                    } else {
                        this.printCreateUniqueKey(out, primaryKey);
                    }
                    out.println();
                } else if (this.kotlin) {
                    out.print("%soverride fun getPrimaryKey(): %s<%s> = ", this.visibilityPublic(), UniqueKey.class, recordType);
                    if (keyFullId != null) {
                        out.print("%s", keyFullId);
                    } else {
                        this.printCreateUniqueKey(out, primaryKey);
                    }
                    out.println();
                } else {
                    out.overrideInherit();
                    this.printNonnullAnnotation(out);
                    out.println("%s%s<%s> getPrimaryKey() {", this.visibilityPublic(), UniqueKey.class, recordType);
                    out.print("return ");
                    if (keyFullId != null) {
                        out.print("%s", keyFullId);
                    } else {
                        this.printCreateUniqueKey(out, primaryKey);
                    }
                    out.println(";");
                    out.println("}");
                }
            }
            if ((uniqueKeys = table.getUniqueKeys()).size() > 0) {
                if (this.generateGlobalKeyReferences()) {
                    List<String> keyFullIds;
                    List<String> list = keyFullIds = this.kotlin ? out.ref(this.getStrategy().getFullJavaIdentifiers((Collection<? extends Definition>)uniqueKeys)) : out.ref(this.getStrategy().getFullJavaIdentifiers((Collection<? extends Definition>)uniqueKeys), 2);
                    if (this.scala) {
                        out.println();
                        out.println("%soverride def getUniqueKeys: %s[ %s[%s] ] = %s.asList[ %s[%s] ]([[%s]])", this.visibilityPublic(), List.class, UniqueKey.class, recordType, Arrays.class, UniqueKey.class, recordType, keyFullIds);
                    } else if (this.kotlin) {
                        out.println("%soverride fun getUniqueKeys(): %s<%s<%s>> = listOf([[%s]])", this.visibilityPublic(), out.ref(KLIST), UniqueKey.class, recordType, keyFullIds);
                    } else {
                        out.overrideInherit();
                        this.printNonnullAnnotation(out);
                        out.println("%s%s<%s<%s>> getUniqueKeys() {", this.visibilityPublic(), List.class, UniqueKey.class, recordType);
                        out.println("return %s.asList([[%s]]);", Arrays.class, keyFullIds);
                        out.println("}");
                    }
                } else if (this.scala) {
                    out.println();
                    out.println("%soverride def getUniqueKeys: %s[ %s[%s] ] = %s.asList[ %s[%s] ](", this.visibilityPublic(), List.class, UniqueKey.class, recordType, Arrays.class, UniqueKey.class, recordType);
                    this.forEach((Collection)uniqueKeys, "", ", ", (BiConsumer)(uniqueKey, separator) -> {
                        this.printCreateUniqueKey(out, (UniqueKeyDefinition)uniqueKey);
                        out.println("%s", separator);
                    });
                    out.println(")");
                } else if (this.kotlin) {
                    out.println("%soverride fun getUniqueKeys(): %s<%s<%s>> = listOf(", this.visibilityPublic(), out.ref(KLIST), UniqueKey.class, recordType);
                    this.forEach((Collection)uniqueKeys, "", ", ", (BiConsumer)(uniqueKey, separator) -> {
                        this.printCreateUniqueKey(out, (UniqueKeyDefinition)uniqueKey);
                        out.println("%s", separator);
                    });
                    out.println(")");
                } else {
                    out.overrideInherit();
                    this.printNonnullAnnotation(out);
                    out.println("%s%s<%s<%s>> getUniqueKeys() {", this.visibilityPublic(), List.class, UniqueKey.class, recordType);
                    out.println("return %s.asList(", Arrays.class);
                    this.forEach((Collection)uniqueKeys, "", ", ", (BiConsumer)(uniqueKey, separator) -> {
                        this.printCreateUniqueKey(out, (UniqueKeyDefinition)uniqueKey);
                        out.println("%s", separator);
                    });
                    out.println(");");
                    out.println("}");
                }
            }
            if ((foreignKeys = table.getForeignKeys()).size() > 0 && this.generateGlobalKeyReferences()) {
                List<String> keyFullIds;
                List<String> list = keyFullIds = this.kotlin ? out.ref(this.getStrategy().getFullJavaIdentifiers(foreignKeys)) : out.ref(this.getStrategy().getFullJavaIdentifiers(foreignKeys), 2);
                if (this.scala) {
                    out.println();
                    out.println("%soverride def getReferences: %s[ %s[%s, _] ] = %s.asList[ %s[%s, _] ]([[%s]])", this.visibilityPublic(), List.class, ForeignKey.class, recordType, Arrays.class, ForeignKey.class, recordType, keyFullIds);
                } else if (this.kotlin) {
                    out.println("%soverride fun getReferences(): %s<%s<%s, *>> = listOf([[%s]])", this.visibilityPublic(), out.ref(KLIST), ForeignKey.class, recordType, keyFullIds);
                } else {
                    out.overrideInherit();
                    this.printNonnullAnnotation(out);
                    out.println("%s%s<%s<%s, ?>> getReferences() {", this.visibilityPublic(), List.class, ForeignKey.class, recordType);
                    out.println("return %s.asList([[%s]]);", Arrays.class, keyFullIds);
                    out.println("}");
                }
                if (this.generateImplicitJoinPathsToOne()) {
                    if (!this.scala) {
                        out.println();
                        for (ForeignKeyDefinition foreignKey : foreignKeys) {
                            String referencedTableClassName = out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getReferencedTable()));
                            String keyMethodName = out.ref(this.getStrategy().getJavaMethodName((Definition)foreignKey));
                            if (this.kotlin) {
                                out.println("private lateinit var _%s: %s", keyMethodName, referencedTableClassName);
                                continue;
                            }
                            out.println("private transient %s _%s;", referencedTableClassName, keyMethodName);
                        }
                    }
                    Map<TableDefinition, Long> pathCounts = foreignKeys.stream().collect(Collectors.groupingBy(ForeignKeyDefinition::getReferencedTable, Collectors.counting()));
                    for (ForeignKeyDefinition foreignKey : foreignKeys) {
                        String keyFullId = this.kotlin ? out.ref(this.getStrategy().getFullJavaIdentifier((Definition)foreignKey)) : out.ref(this.getStrategy().getFullJavaIdentifier((Definition)foreignKey), 2);
                        String referencedTableClassName = out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getReferencedTable()));
                        String keyMethodName = out.ref(this.getStrategy().getJavaMethodName((Definition)foreignKey));
                        out.javadoc("Get the implicit join path to the <code>" + foreignKey.getReferencedTable().getQualifiedName() + "</code> table" + (String)(pathCounts.get(foreignKey.getReferencedTable()) > 1L ? ", via the <code>" + foreignKey.getInputName() + "</code> key" : "") + ".", new Object[0]);
                        if (this.scala) {
                            out.println("%slazy val %s: %s = { new %s(this, %s) }", this.visibility(), this.scalaWhitespaceSuffix(keyMethodName), referencedTableClassName, referencedTableClassName, keyFullId);
                            continue;
                        }
                        if (this.kotlin) {
                            out.println("%sfun %s(): %s {", this.visibility(), keyMethodName, referencedTableClassName);
                            out.println("if (!this::_%s.isInitialized)", keyMethodName);
                            out.println("_%s = %s(this, %s)", keyMethodName, referencedTableClassName, keyFullId);
                            out.println();
                            out.println("return _%s;", keyMethodName);
                            out.println("}");
                            continue;
                        }
                        out.println("%s%s %s() {", this.visibility(), referencedTableClassName, keyMethodName);
                        out.println("if (_%s == null)", keyMethodName);
                        out.println("_%s = new %s(this, %s);", keyMethodName, referencedTableClassName, keyFullId);
                        out.println();
                        out.println("return _%s;", keyMethodName);
                        out.println("}");
                    }
                }
            }
        }
        if (!(cc = table.getCheckConstraints()).isEmpty()) {
            if (this.scala) {
                out.println("%soverride def getChecks: %s[ %s[%s] ] = %s.asList[ %s[%s] ](", this.visibilityPublic(), List.class, Check.class, recordType, Arrays.class, Check.class, recordType);
            } else if (this.kotlin) {
                out.println("%soverride fun getChecks(): %s<%s<%s>> = listOf(", this.visibilityPublic(), out.ref(KLIST), Check.class, recordType);
            } else {
                out.overrideInherit();
                this.printNonnullAnnotation(out);
                out.println("%s%s<%s<%s>> getChecks() {", this.visibilityPublic(), List.class, Check.class, recordType);
                out.println("return %s.asList(", Arrays.class);
            }
            this.forEach(cc, (c, separator) -> out.println("%s.createCheck(this, %s.name(\"%s\"), \"%s\", %s)%s", Internal.class, DSL.class, this.escapeString(c.getName()), this.escapeString(c.getCheckClause()), c.enforced(), separator));
            if (this.scala || this.kotlin) {
                out.println(")");
            } else {
                out.println(");");
                out.println("}");
            }
        }
        block5: for (String pattern : this.database.getRecordVersionFields()) {
            p = Pattern.compile(pattern, 4);
            for (ColumnDefinition column : table.getColumns()) {
                if (!p.matcher(column.getName()).matches() && !p.matcher(column.getQualifiedName()).matches()) continue;
                columnTypeFull = this.getJavaType(column.getType(this.resolver(out)), out);
                columnType = out.ref(columnTypeFull);
                columnId = this.getStrategy().getJavaIdentifier((Definition)column);
                if (this.scala) {
                    this.printDeprecationIfUnknownType(out, columnTypeFull);
                    out.println("%soverride def getRecordVersion: %s[%s, %s] = %s", this.visibilityPublic(), TableField.class, recordType, columnType, columnId);
                    break block5;
                }
                if (this.kotlin) {
                    this.printDeprecationIfUnknownType(out, columnTypeFull);
                    out.println("%soverride fun getRecordVersion(): %s<%s, %s?> = %s", this.visibilityPublic(), TableField.class, recordType, columnType, columnId);
                    break block5;
                }
                if (this.printDeprecationIfUnknownType(out, columnTypeFull)) {
                    out.override();
                } else {
                    out.overrideInherit();
                }
                this.printNonnullAnnotation(out);
                out.println("%s%s<%s, %s> getRecordVersion() {", this.visibilityPublic(), TableField.class, recordType, columnType);
                out.println("return %s;", columnId);
                out.println("}");
                break block5;
            }
        }
        block7: for (String pattern : this.database.getRecordTimestampFields()) {
            p = Pattern.compile(pattern, 4);
            for (ColumnDefinition column : table.getColumns()) {
                if (!p.matcher(column.getName()).matches() && !p.matcher(column.getQualifiedName()).matches()) continue;
                columnTypeFull = this.getJavaType(column.getType(this.resolver(out)), out);
                columnType = out.ref(columnTypeFull);
                columnId = this.getStrategy().getJavaIdentifier((Definition)column);
                if (this.scala) {
                    this.printDeprecationIfUnknownType(out, columnTypeFull);
                    out.println("%soverride def getRecordTimestamp: %s[%s, %s] = %s", this.visibilityPublic(), TableField.class, recordType, columnType, columnId);
                    break block7;
                }
                if (this.kotlin) {
                    this.printDeprecationIfUnknownType(out, columnTypeFull);
                    out.println("%soverride fun getRecordTimestamp(): %s<%s, %s?> = %s", this.visibilityPublic(), TableField.class, recordType, columnType, columnId);
                    break block7;
                }
                if (this.printDeprecationIfUnknownType(out, columnTypeFull)) {
                    out.override();
                } else {
                    out.overrideInherit();
                }
                this.printNonnullAnnotation(out);
                out.println("%s%s<%s, %s> getRecordTimestamp() {", this.visibilityPublic(), TableField.class, recordType, columnType);
                out.println("return %s;", columnId);
                out.println("}");
                break block7;
            }
        }
        if (this.scala) {
            out.print("%soverride def as(alias: %s): %s = ", this.visibilityPublic(), String.class, className);
            if (table.isTableValuedFunction()) {
                out.println("new %s(%s.name(alias), null, null, this, parameters)", className, DSL.class);
            } else {
                out.println("new %s(%s.name(alias), this)", className, DSL.class);
            }
            out.print("%soverride def as(alias: %s): %s = ", this.visibilityPublic(), Name.class, className);
            if (table.isTableValuedFunction()) {
                out.println("new %s(alias, null, null, this, parameters)", className);
            } else {
                out.println("new %s(alias, this)", className);
            }
        } else if (this.kotlin) {
            out.print("%soverride fun `as`(alias: %s): %s = ", this.visibilityPublic(), String.class, className);
            if (table.isTableValuedFunction()) {
                out.println("%s(%s.name(alias), this, parameters)", className, DSL.class);
            } else {
                out.println("%s(%s.name(alias), this)", className, DSL.class);
            }
            out.print("%soverride fun `as`(alias: %s): %s = ", this.visibilityPublic(), Name.class, className);
            if (table.isTableValuedFunction()) {
                out.println("%s(alias, this, parameters)", className);
            } else {
                out.println("%s(alias, this)", className);
            }
        } else if (this.generateInstanceFields()) {
            out.overrideInherit();
            this.printNonnullAnnotation(out);
            out.println("%s%s as(%s alias) {", this.visibilityPublic(), className, String.class);
            if (table.isTableValuedFunction()) {
                out.println("return new %s(%s.name(alias), this, parameters);", className, DSL.class);
            } else {
                out.println("return new %s(%s.name(alias), this);", className, DSL.class);
            }
            out.println("}");
            out.overrideInherit();
            this.printNonnullAnnotation(out);
            out.println("%s%s as(%s alias) {", this.visibilityPublic(), className, Name.class);
            if (table.isTableValuedFunction()) {
                out.println("return new %s(alias, this, parameters);", className);
            } else {
                out.println("return new %s(alias, this);", className);
            }
            out.println("}");
        }
        if (this.scala) {
            out.javadoc("Rename this table", new Object[0]);
            out.print("%soverride def rename(name: %s): %s = ", this.visibilityPublic(), String.class, className);
            if (table.isTableValuedFunction()) {
                out.println("new %s(%s.name(name), null, null, null, parameters)", className, DSL.class);
            } else {
                out.println("new %s(%s.name(name), null)", className, DSL.class);
            }
            out.javadoc("Rename this table", new Object[0]);
            out.print("%soverride def rename(name: %s): %s = ", this.visibilityPublic(), Name.class, className);
            if (table.isTableValuedFunction()) {
                out.println("new %s(name, null, null, null, parameters)", className);
            } else {
                out.println("new %s(name, null)", className);
            }
        } else if (this.kotlin) {
            out.javadoc("Rename this table", new Object[0]);
            out.print("%soverride fun rename(name: %s): %s = ", this.visibilityPublic(), String.class, className);
            if (table.isTableValuedFunction()) {
                out.println("%s(%s.name(name), null, parameters)", className, DSL.class);
            } else {
                out.println("%s(%s.name(name), null)", className, DSL.class);
            }
            out.javadoc("Rename this table", new Object[0]);
            out.print("%soverride fun rename(name: %s): %s = ", this.visibilityPublic(), Name.class, className);
            if (table.isTableValuedFunction()) {
                out.println("%s(name, null, parameters)", className);
            } else {
                out.println("%s(name, null)", className);
            }
        } else if (this.generateInstanceFields()) {
            out.javadoc("Rename this table", new Object[0]);
            out.override();
            this.printNonnullAnnotation(out);
            out.println("%s%s rename(%s name) {", this.visibilityPublic(), className, String.class);
            if (table.isTableValuedFunction()) {
                out.println("return new %s(%s.name(name), null, parameters);", className, DSL.class);
            } else {
                out.println("return new %s(%s.name(name), null);", className, DSL.class);
            }
            out.println("}");
            out.javadoc("Rename this table", new Object[0]);
            out.override();
            this.printNonnullAnnotation(out);
            out.println("%s%s rename(%s name) {", this.visibilityPublic(), className, Name.class);
            if (table.isTableValuedFunction()) {
                out.println("return new %s(name, null, parameters);", className);
            } else {
                out.println("return new %s(name, null);", className);
            }
            out.println("}");
        }
        List<Definition> replacingEmbeddablesAndUnreplacedColumns = this.replacingEmbeddablesAndUnreplacedColumns((Definition)table);
        int degree = replacingEmbeddablesAndUnreplacedColumns.size();
        String rowType = this.refRowType(out, replacingEmbeddablesAndUnreplacedColumns);
        if (this.generateRecordsImplementingRecordN() && degree > 0 && degree <= 22) {
            String rowNType = out.ref(Row.class.getName() + degree);
            out.header("Row%s type methods", degree);
            if (this.scala) {
                out.println("%soverride def fieldsRow: %s[%s] = super.fieldsRow.asInstanceOf[ %s[%s] ]", this.visibilityPublic(), rowNType, rowType, rowNType, rowType);
            } else if (this.kotlin) {
                out.println("%soverride fun fieldsRow(): %s<%s> = super.fieldsRow() as %s<%s>", this.visibilityPublic(), rowNType, rowType, rowNType, rowType);
            } else {
                out.overrideInherit();
                this.printNonnullAnnotation(out);
                out.println("%s%s<%s> fieldsRow() {", this.visibilityPublic(), rowNType, rowType);
                out.println("return (%s) super.fieldsRow();", rowNType);
                out.println("}");
            }
        }
        if (table.isTableValuedFunction()) {
            boolean parametersAsField;
            boolean[] blArray = new boolean[]{false, true};
            int n = blArray.length;
            for (int i = 0; !(i >= n || (parametersAsField = blArray[i]) && parameters.size() == 0); ++i) {
                out.javadoc("Call this table-valued function", new Object[0]);
                if (this.scala) {
                    ((JavaWriter)out.print("%sdef call(", this.visibility())).printlnIf(!parameters.isEmpty());
                    this.printParameterDeclarations(out, parameters, parametersAsField, "  ");
                    out.print("): %s = ", className);
                    ((JavaWriter)out.print("Option(new %s(%s.name(\"%s\"), null, null, null, %s(", className, DSL.class, this.escapeString(table.getOutputName()), out.ref("scala.Array"))).printlnIf(!parameters.isEmpty());
                    this.forEach(parameters, (parameter, separator) -> {
                        String paramArgName = this.getStrategy().getJavaMemberName((Definition)parameter);
                        String paramTypeRef = this.getJavaTypeReference(parameter.getDatabase(), parameter.getType(this.resolver(out)), out);
                        List<String> converter = out.ref(JavaGenerator.list(parameter.getType(this.resolver(out)).getConverter()));
                        List<String> binding = out.ref(JavaGenerator.list(parameter.getType(this.resolver(out)).getBinding()));
                        if (parametersAsField) {
                            out.println("%s%s", paramArgName, separator);
                        } else {
                            out.println("%s.value(%s, %s" + this.converterTemplateForTableValuedFunction(converter) + this.converterTemplateForTableValuedFunction(binding) + ")%s", DSL.class, paramArgName, paramTypeRef, converter, binding, separator);
                        }
                    });
                    out.println("))).map(r => if (aliased()) r.as(getUnqualifiedName) else r).get");
                    continue;
                }
                if (this.kotlin) {
                    ((JavaWriter)out.print("%sfun call(", this.visibility())).printlnIf(!parameters.isEmpty());
                    this.printParameterDeclarations(out, parameters, parametersAsField, "  ");
                    ((JavaWriter)out.print("): %s = %s(%s.name(\"%s\"), null, arrayOf(", className, className, DSL.class, this.escapeString(table.getOutputName()), Field.class)).printlnIf(!parameters.isEmpty());
                    this.forEach(parameters, (parameter, separator) -> {
                        String paramArgName = this.getStrategy().getJavaMemberName((Definition)parameter);
                        String paramTypeRef = this.getJavaTypeReference(parameter.getDatabase(), parameter.getType(this.resolver(out)), out);
                        List<String> converter = out.ref(JavaGenerator.list(parameter.getType(this.resolver(out)).getConverter()));
                        List<String> binding = out.ref(JavaGenerator.list(parameter.getType(this.resolver(out)).getBinding()));
                        if (parametersAsField) {
                            out.println("%s%s", paramArgName, separator);
                        } else {
                            out.println("%s.value(%s, %s" + this.converterTemplateForTableValuedFunction(converter) + this.converterTemplateForTableValuedFunction(binding) + ")%s", DSL.class, paramArgName, paramTypeRef, converter, binding, separator);
                        }
                    });
                    out.println(")).let { if (aliased()) it.`as`(unqualifiedName) else it }");
                    continue;
                }
                ((JavaWriter)out.print("%s%s call(", this.visibility(), className)).printlnIf(!parameters.isEmpty());
                this.printParameterDeclarations(out, parameters, parametersAsField, "  ");
                out.println(") {");
                ((JavaWriter)out.print("%s result = new %s(%s.name(\"%s\"), null, new %s[] {", className, className, DSL.class, this.escapeString(table.getOutputName()), Field.class)).printlnIf(!parameters.isEmpty());
                this.forEach(parameters, (parameter, separator) -> {
                    String paramArgName = this.getStrategy().getJavaMemberName((Definition)parameter);
                    String paramTypeRef = this.getJavaTypeReference(parameter.getDatabase(), parameter.getType(this.resolver(out)), out);
                    List<String> converter = out.ref(JavaGenerator.list(parameter.getType(this.resolver(out)).getConverter()));
                    List<String> binding = out.ref(JavaGenerator.list(parameter.getType(this.resolver(out)).getBinding()));
                    if (parametersAsField) {
                        out.println("%s%s", paramArgName, separator);
                    } else {
                        out.println("%s.val(%s, %s" + this.converterTemplateForTableValuedFunction(converter) + this.converterTemplateForTableValuedFunction(binding) + ")%s", DSL.class, paramArgName, paramTypeRef, converter, binding, separator);
                    }
                });
                out.println("});");
                out.println();
                out.println("return aliased() ? result.as(getUnqualifiedName()) : result;");
                out.println("}");
            }
        }
        this.generateTableClassFooter(table, out);
        out.println("}");
        this.closeJavaWriter(out);
    }

    private Iterable<EmbeddableDefinition> embeddables(SchemaDefinition schema) {
        LinkedHashSet<EmbeddableDefinition> embeddables = new LinkedHashSet<EmbeddableDefinition>(this.database.getEmbeddables(schema));
        for (EmbeddableDefinition embeddable : embeddables) {
            if (!embeddable.getTable().equals(embeddable.getReferencingTable())) continue;
            embeddables.add(embeddable);
        }
        return embeddables;
    }

    protected void generateEmbeddables(SchemaDefinition schema) {
        log.info((Object)"Generating embeddables");
        HashSet<File> duplicates = new HashSet<File>();
        for (EmbeddableDefinition embeddable : this.embeddables(schema)) {
            try {
                if (!duplicates.add(this.getFile((Definition)embeddable, GeneratorStrategy.Mode.RECORD))) continue;
                this.generateEmbeddable(schema, embeddable);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating embeddable " + embeddable), (Throwable)e);
            }
        }
        this.watch.splitInfo("Tables generated");
    }

    protected void generateEmbeddable(SchemaDefinition schema, EmbeddableDefinition embeddable) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)embeddable, GeneratorStrategy.Mode.RECORD));
        log.info((Object)"Generating embeddable", (Object)out.file().getName());
        this.generateRecord0((Definition)embeddable, out);
        this.closeJavaWriter(out);
    }

    protected void generateEmbeddablePojos(SchemaDefinition schema) {
        log.info((Object)"Generating embeddable POJOs");
        for (EmbeddableDefinition embeddable : this.embeddables(schema)) {
            try {
                this.generateEmbeddablePojo(embeddable);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating embeddable POJO " + embeddable), (Throwable)e);
            }
        }
        this.watch.splitInfo("Embeddable POJOs generated");
    }

    protected void generateEmbeddablePojoClassFooter(EmbeddableDefinition embeddable, JavaWriter out) {
    }

    protected void generateEmbeddablePojoClassJavadoc(EmbeddableDefinition embeddable, JavaWriter out) {
        if (this.generateCommentsOnEmbeddables()) {
            this.printClassJavadoc(out, (Definition)embeddable);
        } else {
            this.printClassJavadoc(out, "The embeddable <code>" + embeddable.getQualifiedInputName() + "</code>.");
        }
    }

    protected void generateEmbeddableInterfaces(SchemaDefinition schema) {
        log.info((Object)"Generating embeddable interfaces");
        for (EmbeddableDefinition embeddable : this.embeddables(schema)) {
            try {
                this.generateEmbeddableInterface(embeddable);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating embeddable interface " + embeddable), (Throwable)e);
            }
        }
        this.watch.splitInfo("embeddable interfaces generated");
    }

    protected void generateEmbeddableInterfaceClassFooter(EmbeddableDefinition embeddable, JavaWriter out) {
    }

    protected void generateEmbeddableInterfaceClassJavadoc(EmbeddableDefinition embeddable, JavaWriter out) {
        if (this.generateCommentsOnEmbeddables()) {
            this.printClassJavadoc(out, (Definition)embeddable);
        } else {
            this.printClassJavadoc(out, "The embeddable <code>" + embeddable.getQualifiedInputName() + "</code>.");
        }
    }

    private String converterTemplate(List<String> converter) {
        if (converter == null || converter.isEmpty()) {
            return "[[]]";
        }
        if (converter.size() > 1) {
            throw new IllegalArgumentException();
        }
        switch (GenerationUtil.expressionType(converter.get(0))) {
            case CONSTRUCTOR_REFERENCE: {
                switch (this.language) {
                    case KOTLIN: {
                        return "[[before=, ][%s()]]";
                    }
                }
                return "[[before=, ][new %s()]]";
            }
            case EXPRESSION: {
                return "[[before=, ][%s]]";
            }
        }
        throw new IllegalArgumentException();
    }

    private String converterTemplateForTableValuedFunction(List<String> converter) {
        if (converter == null || converter.isEmpty()) {
            return "[[]]";
        }
        if (converter.size() > 1) {
            throw new IllegalArgumentException();
        }
        switch (GenerationUtil.expressionType(converter.get(0))) {
            case CONSTRUCTOR_REFERENCE: {
                switch (this.language) {
                    case KOTLIN: {
                        return "[[before=.asConvertedDataType(][after=)][%s()]]";
                    }
                }
                return "[[before=.asConvertedDataType(][after=)][new %s()]]";
            }
            case EXPRESSION: {
                return "[[before=.asConvertedDataType(][after=)][%s]]";
            }
        }
        throw new IllegalArgumentException();
    }

    private String escapeString(String string) {
        if (string == null) {
            return null;
        }
        String result = string.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r");
        if (this.kotlin) {
            result = result.replace("$", "\\$");
        }
        int max = 16384;
        if (result.length() <= max) {
            return result;
        }
        StringBuilder sb = new StringBuilder("\" + \"");
        for (int i = 0; i < result.length(); i += max) {
            if (i > 0) {
                sb.append("\".toString() + \"");
            }
            sb.append(result, i, Math.min(i + max, result.length()));
        }
        return sb.append("\".toString() + \"").toString();
    }

    protected void generateTableClassFooter(TableDefinition table, JavaWriter out) {
    }

    protected void generateTableClassJavadoc(TableDefinition table, JavaWriter out) {
        if (this.generateCommentsOnTables()) {
            this.printClassJavadoc(out, (Definition)table);
        } else {
            this.printClassJavadoc(out, "The table <code>" + table.getQualifiedInputName() + "</code>.");
        }
    }

    protected void generateSequences(SchemaDefinition schema) {
        log.info((Object)"Generating sequences");
        JavaWriter out = this.newJavaWriter(this.getStrategy().getGlobalReferencesFile((Definition)schema, SequenceDefinition.class));
        out.refConflicts(this.getStrategy().getJavaIdentifiers(this.database.getSequences(schema)));
        this.printGlobalReferencesPackage(out, (Definition)schema, SequenceDefinition.class);
        if (!this.kotlin) {
            this.printClassJavadoc(out, "Convenience access to all sequences in " + this.schemaNameOrDefault((Definition)schema) + ".");
            this.printClassAnnotations(out, (Definition)schema, GeneratorStrategy.Mode.DEFAULT);
        }
        String referencesClassName = this.getStrategy().getGlobalReferencesJavaClassName((Definition)schema, SequenceDefinition.class);
        if (this.scala) {
            out.println("%sobject %s {", this.visibility(), referencesClassName);
        } else if (!this.kotlin) {
            out.println("%sclass %s {", this.visibility(), referencesClassName);
        }
        for (SequenceDefinition sequence : this.database.getSequences(schema)) {
            String seqTypeFull = this.getJavaType(sequence.getType(this.resolver(out)), out);
            String seqType = out.ref(seqTypeFull);
            String seqId = this.getStrategy().getJavaIdentifier((Definition)sequence);
            String seqName = sequence.getOutputName();
            String schemaId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)schema), 2);
            String typeRef = this.getJavaTypeReference(sequence.getDatabase(), sequence.getType(this.resolver(out)), out);
            if (!this.printDeprecationIfUnknownType(out, seqTypeFull)) {
                out.javadoc("The sequence <code>%s</code>", sequence.getQualifiedOutputName());
            }
            boolean flags = this.generateSequenceFlags();
            if (this.scala) {
                out.println("%sval %s: %s[%s] = %s.createSequence(\"%s\", %s, %s, %s, %s, %s, %s, %s, %s)", this.visibility(), this.scalaWhitespaceSuffix(seqId), Sequence.class, seqType, Internal.class, seqName, schemaId, typeRef, flags ? this.numberLiteral(sequence.getStartWith()) : "null", flags ? this.numberLiteral(sequence.getIncrementBy()) : "null", flags ? this.numberLiteral(sequence.getMinvalue()) : "null", flags ? this.numberLiteral(sequence.getMaxvalue()) : "null", flags && sequence.getCycle(), flags ? this.numberLiteral(sequence.getCache()) : "null");
                continue;
            }
            if (this.kotlin) {
                out.println("%sval %s: %s<%s> = %s.createSequence(\"%s\", %s, %s, %s, %s, %s, %s, %s, %s)", this.visibility(), seqId, Sequence.class, seqType, Internal.class, seqName, schemaId, typeRef, flags ? this.numberLiteral(sequence.getStartWith()) : "null", flags ? this.numberLiteral(sequence.getIncrementBy()) : "null", flags ? this.numberLiteral(sequence.getMinvalue()) : "null", flags ? this.numberLiteral(sequence.getMaxvalue()) : "null", flags && sequence.getCycle(), flags ? this.numberLiteral(sequence.getCache()) : "null");
                continue;
            }
            out.println("%sstatic final %s<%s> %s = %s.createSequence(\"%s\", %s, %s, %s, %s, %s, %s, %s, %s);", this.visibility(), Sequence.class, seqType, seqId, Internal.class, seqName, schemaId, typeRef, flags ? this.numberLiteral(sequence.getStartWith()) : "null", flags ? this.numberLiteral(sequence.getIncrementBy()) : "null", flags ? this.numberLiteral(sequence.getMinvalue()) : "null", flags ? this.numberLiteral(sequence.getMaxvalue()) : "null", flags && sequence.getCycle(), flags ? this.numberLiteral(sequence.getCache()) : "null");
        }
        this.generateSequencesClassFooter(schema, out);
        if (!this.kotlin) {
            out.println("}");
        }
        this.closeJavaWriter(out);
        this.watch.splitInfo("Sequences generated");
    }

    protected void generateSequencesClassFooter(SchemaDefinition schema, JavaWriter out) {
    }

    private String numberLiteral(Number n) {
        if (n instanceof BigInteger) {
            BigInteger bi = (BigInteger)n;
            int bitLength = ((BigInteger)n).bitLength();
            if (bitLength > 63) {
                return "new java.math.BigInteger(\"" + bi.toString() + "\")";
            }
            if (bitLength > 31) {
                return Long.toString(n.longValue()) + "L";
            }
            return Integer.toString(n.intValue());
        }
        if (n instanceof Integer || n instanceof Short || n instanceof Byte) {
            return Integer.toString(n.intValue());
        }
        if (n != null) {
            return Long.toString(n.longValue()) + "L";
        }
        return "null";
    }

    protected void generateCatalog(CatalogDefinition catalog) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)catalog));
        log.info((Object)"");
        log.info((Object)"Generating catalog", (Object)out.file().getName());
        log.info((Object)"==========================================================");
        this.generateCatalog(catalog, out);
        this.closeJavaWriter(out);
    }

    protected void generateCatalog(CatalogDefinition catalog, JavaWriter out) {
        String catalogId = this.getStrategy().getJavaIdentifier((Definition)catalog);
        String catalogName = !catalog.getQualifiedOutputName().isEmpty() ? catalog.getQualifiedOutputName() : catalogId;
        String className = this.getStrategy().getJavaClassName((Definition)catalog);
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)catalog, GeneratorStrategy.Mode.DEFAULT));
        this.printPackage(out, (Definition)catalog);
        if (this.scala) {
            out.println("object %s {", className);
            out.javadoc("The reference instance of <code>%s</code>", catalogName);
            out.println("val %s = new %s", catalogId, className);
            out.println("}");
            out.println();
        }
        this.generateCatalogClassJavadoc(catalog, out);
        this.printClassAnnotations(out, (Definition)catalog, GeneratorStrategy.Mode.DEFAULT);
        if (this.scala) {
            out.println("%sclass %s extends %s(\"%s\")[[before= with ][separator= with ][%s]] {", this.visibility(), className, CatalogImpl.class, catalog.getOutputName(), interfaces);
        } else if (this.kotlin) {
            out.println("%sopen class %s : %s(\"%s\")[[before=, ][%s]] {", this.visibility(), className, CatalogImpl.class, catalog.getOutputName(), interfaces);
            out.println("%scompanion object {", this.visibility());
            out.javadoc("The reference instance of <code>%s</code>", catalogName);
            out.println("public val %s: %s = %s()", catalogId, className, className);
            out.println("}");
        } else {
            out.println("%sclass %s extends %s[[before= implements ][%s]] {", this.visibility(), className, CatalogImpl.class, interfaces);
            out.printSerial();
            out.javadoc("The reference instance of <code>%s</code>", catalogName);
            out.println("%sstatic final %s %s = new %s();", this.visibility(), className, catalogId, className);
        }
        ArrayList<SchemaDefinition> schemas = new ArrayList<SchemaDefinition>();
        if (this.generateGlobalSchemaReferences()) {
            HashSet<String> fieldNames = new HashSet<String>();
            fieldNames.add(catalogId);
            for (SchemaDefinition schema : catalog.getSchemata()) {
                if (!this.generateSchemaIfEmpty(schema)) continue;
                fieldNames.add(this.getStrategy().getJavaIdentifier((Definition)schema));
            }
            for (SchemaDefinition schema : catalog.getSchemata()) {
                String schemaComment;
                if (!this.generateSchemaIfEmpty(schema)) continue;
                schemas.add(schema);
                String schemaClassName = out.ref(this.getStrategy().getFullJavaClassName((Definition)schema));
                String schemaId = this.getStrategy().getJavaIdentifier((Definition)schema);
                String schemaFullId = this.getStrategy().getFullJavaIdentifier((Definition)schema);
                String schemaShortId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)schema), 2);
                if (fieldNames.contains(schemaShortId.substring(0, schemaShortId.indexOf(46)))) {
                    schemaShortId = schemaFullId;
                }
                out.javadoc((String)(StringUtils.isBlank((String)(schemaComment = this.escapeEntities(this.comment((Definition)schema)))) ? "The schema <code>" + (!schema.getQualifiedOutputName().isEmpty() ? schema.getQualifiedOutputName() : schemaId) + "</code>." : schemaComment), new Object[0]);
                if (this.scala) {
                    out.println("%sdef %s = %s", this.visibility(), schemaId, schemaShortId);
                    continue;
                }
                if (this.kotlin) {
                    out.println("%sval %s: %s get(): %s = %s", this.visibility(), schemaId, schemaClassName, schemaClassName, schemaShortId);
                    continue;
                }
                out.println("%sfinal %s %s = %s;", this.visibility(), schemaClassName, schemaId, schemaShortId);
            }
        }
        if (!this.scala && !this.kotlin) {
            out.javadoc(NO_FURTHER_INSTANCES_ALLOWED, new Object[0]);
            out.println("private %s() {", className);
            out.println("super(\"%s\");", catalog.getOutputName());
            out.println("}");
        }
        this.printReferences(out, schemas, Schema.class, false);
        if (this.generateJooqVersionReference()) {
            String version = "3.16".replace(".", "_");
            out.javadoc("A reference to the 3.16 minor release of the code generator. If this doesn't compile, it's because the runtime library uses an older minor release, namely: 3.16. You can turn off the generation of this reference by specifying /configuration/generator/generate/jooqVersionReference", new Object[0]);
            if (this.scala) {
                out.println("private val REQUIRE_RUNTIME_JOOQ_VERSION = %s.VERSION_%s", Constants.class, version);
            } else if (this.kotlin) {
                out.println("private val REQUIRE_RUNTIME_JOOQ_VERSION = %s.VERSION_%s", Constants.class, version);
            } else {
                out.println("private static final String REQUIRE_RUNTIME_JOOQ_VERSION = %s.VERSION_%s;", Constants.class, version);
            }
        }
        this.generateCatalogClassFooter(catalog, out);
        out.println("}");
    }

    protected void generateCatalogClassFooter(CatalogDefinition schema, JavaWriter out) {
    }

    protected void generateCatalogClassJavadoc(CatalogDefinition catalog, JavaWriter out) {
        if (this.generateCommentsOnCatalogs()) {
            this.printClassJavadoc(out, (Definition)catalog);
        } else {
            this.printClassJavadoc(out, "The catalog <code>" + catalog.getQualifiedInputName() + "</code>.");
        }
    }

    protected void generateSchema(SchemaDefinition schema) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)schema));
        log.info((Object)"Generating schema", (Object)out.file().getName());
        log.info((Object)"----------------------------------------------------------");
        this.generateSchema(schema, out);
        this.closeJavaWriter(out);
    }

    protected void generateSchema(SchemaDefinition schema, JavaWriter out) {
        String catalogId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)schema.getCatalog()), 2);
        String schemaId = this.getStrategy().getJavaIdentifier((Definition)schema);
        String schemaName = !schema.getQualifiedOutputName().isEmpty() ? schema.getQualifiedOutputName() : schemaId;
        String className = this.getStrategy().getJavaClassName((Definition)schema);
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)schema, GeneratorStrategy.Mode.DEFAULT));
        this.printPackage(out, (Definition)schema);
        if (this.scala) {
            out.println("object %s {", className);
            out.javadoc("The reference instance of <code>%s</code>", schemaName);
            out.println("val %s = new %s", schemaId, className);
            out.println("}");
            out.println();
        }
        this.generateSchemaClassJavadoc(schema, out);
        this.printClassAnnotations(out, (Definition)schema, GeneratorStrategy.Mode.DEFAULT);
        if (this.scala) {
            out.println("%sclass %s extends %s(\"%s\", %s)[[before= with ][separator= with ][%s]] {", this.visibility(), className, SchemaImpl.class, this.escapeString(schema.getOutputName()), catalogId, interfaces);
        } else if (this.kotlin) {
            out.println("%sopen class %s : %s(\"%s\", %s)[[before=, ][%s]] {", this.visibility(), className, SchemaImpl.class, this.escapeString(schema.getOutputName()), catalogId, interfaces);
            out.println("public companion object {");
            out.javadoc("The reference instance of <code>%s</code>", schemaName);
            out.println("%sval %s: %s = %s()", this.visibility(), this.scalaWhitespaceSuffix(schemaId), className, className);
            out.println("}");
        } else {
            out.println("%sclass %s extends %s[[before= implements ][%s]] {", this.visibility(), className, SchemaImpl.class, interfaces);
            out.printSerial();
            out.javadoc("The reference instance of <code>%s</code>", schemaName);
            out.println("%sstatic final %s %s = new %s();", this.visibility(), className, schemaId, className);
        }
        if (this.generateGlobalTableReferences()) {
            Set<String> memberNames = this.getMemberNames(schema);
            for (TableDefinition table : schema.getTables()) {
                if (this.scala && table.isTableValuedFunction() && table.getParameters().isEmpty()) continue;
                String tableClassName = out.ref(this.getStrategy().getFullJavaClassName((Definition)table));
                String tableId = this.getStrategy().getJavaIdentifier((Definition)table);
                String tableShortId = this.getShortId(out, memberNames, (Definition)table);
                String tableComment = this.escapeEntities(this.comment((Definition)table));
                out.javadoc((String)(StringUtils.isBlank((String)tableComment) ? "The table <code>" + table.getQualifiedOutputName() + "</code>." : tableComment), new Object[0]);
                if (this.scala) {
                    out.println("%sdef %s = %s", this.visibility(), tableId, tableShortId);
                } else if (this.kotlin) {
                    out.println("%sval %s: %s get() = %s", this.visibility(), this.scalaWhitespaceSuffix(tableId), tableClassName, tableShortId);
                } else {
                    out.println("%sfinal %s %s = %s;", this.visibility(), tableClassName, tableId, tableShortId);
                }
                if (!table.isTableValuedFunction()) continue;
                this.printTableValuedFunction(out, table, this.getStrategy().getJavaIdentifier((Definition)table));
            }
        }
        if (!this.scala && !this.kotlin) {
            out.javadoc(NO_FURTHER_INSTANCES_ALLOWED, new Object[0]);
            out.println("private %s() {", className);
            out.println("super(\"%s\", null);", this.escapeString(schema.getOutputName()));
            out.println("}");
        }
        out.println();
        if (this.scala) {
            out.println("%soverride def getCatalog: %s = %s", this.visibilityPublic(), Catalog.class, catalogId);
        } else if (this.kotlin) {
            out.println("%soverride fun getCatalog(): %s = %s", this.visibilityPublic(), Catalog.class, catalogId);
        } else {
            out.overrideInherit();
            this.printNonnullAnnotation(out);
            out.println("%s%s getCatalog() {", this.visibilityPublic(), Catalog.class);
            out.println("return %s;", catalogId);
            out.println("}");
        }
        if (this.generateGlobalSequenceReferences()) {
            this.printReferences(out, this.database.getSequences(schema), Sequence.class, true);
        }
        if (this.generateGlobalDomainReferences()) {
            this.printReferences(out, this.database.getDomains(schema), Domain.class, true);
        }
        if (this.generateTables()) {
            this.printReferences(out, this.database.getTables(schema), Table.class, true);
        }
        if (this.generateUDTs()) {
            this.printReferences(out, this.database.getUDTs(schema), UDT.class, true);
        }
        this.generateSchemaClassFooter(schema, out);
        out.println("}");
    }

    private Set<String> getMemberNames(CatalogDefinition catalog) {
        HashSet<String> members = new HashSet<String>();
        members.add(this.getStrategy().getJavaIdentifier((Definition)catalog));
        for (SchemaDefinition table : catalog.getSchemata()) {
            members.add(this.getStrategy().getJavaIdentifier((Definition)table));
        }
        return members;
    }

    private Set<String> getMemberNames(SchemaDefinition schema) {
        HashSet<String> members = new HashSet<String>();
        members.add(this.getStrategy().getJavaIdentifier((Definition)schema));
        for (TableDefinition table : schema.getTables()) {
            members.add(this.getStrategy().getJavaIdentifier((Definition)table));
        }
        return members;
    }

    private String getShortId(JavaWriter out, Set<String> memberNames, Definition table) {
        String shortId = out.ref(this.getStrategy().getFullJavaIdentifier(table), 2);
        if (memberNames.contains(shortId.substring(0, shortId.indexOf(46)))) {
            shortId = this.getStrategy().getFullJavaIdentifier(table);
        }
        return shortId;
    }

    protected void generateSchemaClassFooter(SchemaDefinition schema, JavaWriter out) {
    }

    protected void generateSchemaClassJavadoc(SchemaDefinition schema, JavaWriter out) {
        if (this.generateCommentsOnSchemas()) {
            this.printClassJavadoc(out, (Definition)schema);
        } else {
            this.printClassJavadoc(out, "The schema <code>" + schema.getQualifiedInputName() + "</code>.");
        }
    }

    protected void printFromAndInto(JavaWriter out, TableDefinition table) {
        this.printFromAndInto(out, (Definition)table, GeneratorStrategy.Mode.DEFAULT);
    }

    private void printFromAndInto(JavaWriter out, Definition tableOrUDT, GeneratorStrategy.Mode mode) {
        boolean override;
        String qualified = out.ref(this.getStrategy().getFullJavaClassName(tableOrUDT, GeneratorStrategy.Mode.INTERFACE));
        out.header("FROM and INTO", new Object[0]);
        boolean bl = override = this.generateInterfaces() && !this.generateImmutableInterfaces();
        if (this.scala) {
            out.println();
            out.println("%s%sdef from(from: %s) {", this.visibilityPublic(), override ? "override " : "", qualified);
        } else if (this.kotlin) {
            out.println();
            out.println("%s%sfun from(from: %s) {", this.visibilityPublic(), override ? "override " : "", qualified);
        } else {
            out.overrideInheritIf(override);
            out.println("%svoid from(%s from) {", this.visibilityPublic(), qualified);
        }
        for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
            String setter = this.getStrategy().getJavaSetterName((Definition)typedElementDefinition, GeneratorStrategy.Mode.INTERFACE);
            String getter = this.getStrategy().getJavaGetterName((Definition)typedElementDefinition, GeneratorStrategy.Mode.INTERFACE);
            String member = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
            if (this.scala) {
                out.println("%s(from.%s)", setter, getter);
                continue;
            }
            if (this.kotlin) {
                out.println("%s = from.%s", member, member);
                continue;
            }
            out.println("%s(from.%s());", setter, getter);
        }
        out.println("}");
        if (override) {
            if (this.scala) {
                if (mode != GeneratorStrategy.Mode.POJO) {
                    out.println();
                    out.println("%soverride def into [E](into: E): E = {", this.visibilityPublic(), qualified);
                    out.println("if (into.isInstanceOf[%s])", qualified);
                    out.println("into.asInstanceOf[%s].from(this)", qualified);
                    out.println("else");
                    out.println("super.into(into)");
                    out.println("into");
                    out.println("}");
                }
            } else if (this.kotlin) {
                out.println();
                out.println("%s%sfun <E : %s> into(into: E): E {", this.visibilityPublic(), override ? "override " : "", qualified);
                out.println("into.from(this)");
                out.println("return into");
                out.println("}");
            } else {
                out.overrideInherit();
                out.println("%s<E extends %s> E into(E into) {", this.visibilityPublic(), qualified);
                out.println("into.from(this);");
                out.println("return into;");
                out.println("}");
            }
        }
    }

    protected void printReferences(JavaWriter out, List<? extends Definition> definitions, Class<?> type, boolean isGeneric) {
        if (out != null && !definitions.isEmpty()) {
            Set<String> memberNames;
            String generic = isGeneric ? (this.scala ? "[_]" : (this.kotlin ? "<*>" : "<?>")) : "";
            ArrayList<String> references = new ArrayList<String>();
            Definition first = definitions.get(0);
            if ((this.scala || this.kotlin) && (first instanceof TableDefinition || first instanceof UDTDefinition)) {
                memberNames = this.getMemberNames(first.getSchema());
                for (Definition definition : definitions) {
                    references.add(this.getShortId(out, memberNames, definition));
                }
            } else if ((this.scala || this.kotlin) && first instanceof SchemaDefinition) {
                memberNames = this.getMemberNames(first.getCatalog());
                for (Definition definition : definitions) {
                    references.add(this.getShortId(out, memberNames, definition));
                }
            } else {
                references.addAll(this.kotlin ? out.ref(this.getStrategy().getFullJavaIdentifiers(definitions)) : out.ref(this.getStrategy().getFullJavaIdentifiers(definitions), 2));
            }
            out.println();
            if (this.scala) {
                if (definitions.size() > this.maxMembersPerInitialiser()) {
                    out.println("%soverride def get%ss: %s[%s%s] = {", this.visibilityPublic(), type.getSimpleName(), List.class, type, generic);
                    out.println("val result = new %s[%s%s]", ArrayList.class, type, generic);
                    for (int i = 0; i < definitions.size(); i += this.maxMembersPerInitialiser()) {
                        out.println("result.addAll(get%ss%s)", type.getSimpleName(), i / this.maxMembersPerInitialiser());
                    }
                    out.println("result");
                    out.println("}");
                } else {
                    out.println("%soverride def get%ss: %s[%s%s] = %s.asList[%s%s](", this.visibilityPublic(), type.getSimpleName(), List.class, type, generic, Arrays.class, type, generic);
                    out.println("[[separator=,\n][%s]]", references);
                    out.println(")");
                }
            } else if (this.kotlin) {
                if (definitions.size() > this.maxMembersPerInitialiser()) {
                    out.println("%soverride fun get%ss(): %s<%s%s> {", this.visibilityPublic(), type.getSimpleName(), out.ref(KLIST), type, generic);
                    out.println("val result = mutableListOf<%s%s>()", type, generic);
                    for (int i = 0; i < definitions.size(); i += this.maxMembersPerInitialiser()) {
                        out.println("result.addAll(get%ss%s())", type.getSimpleName(), i / this.maxMembersPerInitialiser());
                    }
                    out.println("return result");
                    out.println("}");
                } else {
                    out.println("%soverride fun get%ss(): %s<%s%s> = listOf(", this.visibilityPublic(), type.getSimpleName(), out.ref(KLIST), type, generic);
                    out.println("[[separator=,\n][%s]]", references);
                    out.println(")");
                }
            } else {
                out.override();
                this.printNonnullAnnotation(out);
                out.println("%sfinal %s<%s%s> get%ss() {", this.visibilityPublic(), List.class, type, generic, type.getSimpleName());
                if (definitions.size() > this.maxMembersPerInitialiser()) {
                    out.println("%s result = new %s();", List.class, ArrayList.class);
                    for (int i = 0; i < definitions.size(); i += this.maxMembersPerInitialiser()) {
                        out.println("result.addAll(get%ss%s());", type.getSimpleName(), i / this.maxMembersPerInitialiser());
                    }
                    out.println("return result;");
                } else {
                    out.println("return %s.asList(", Arrays.class);
                    out.println("[[separator=,\n][%s]]", references);
                    out.println(");");
                }
                out.println("}");
            }
            if (definitions.size() > this.maxMembersPerInitialiser()) {
                for (int i = 0; i < definitions.size(); i += this.maxMembersPerInitialiser()) {
                    out.println();
                    if (this.scala) {
                        out.println("private def get%ss%s(): %s[%s%s] = %s.asList[%s%s](", type.getSimpleName(), i / this.maxMembersPerInitialiser(), List.class, type, generic, Arrays.class, type, generic);
                        out.println("[[separator=,\n][%s]]", references.subList(i, Math.min(i + this.maxMembersPerInitialiser(), references.size())));
                        out.println(")");
                        continue;
                    }
                    if (this.kotlin) {
                        out.println("private fun get%ss%s(): %s<%s%s> = listOf(", type.getSimpleName(), i / this.maxMembersPerInitialiser(), out.ref(KLIST), type, generic);
                        out.println("[[separator=,\n][%s]]", references.subList(i, Math.min(i + this.maxMembersPerInitialiser(), references.size())));
                        out.println(")");
                        continue;
                    }
                    out.println("private final %s<%s%s> get%ss%s() {", List.class, type, generic, type.getSimpleName(), i / this.maxMembersPerInitialiser());
                    out.println("return %s.asList(", Arrays.class);
                    out.println("[[separator=,\n][%s]]", references.subList(i, Math.min(i + this.maxMembersPerInitialiser(), references.size())));
                    out.println(");");
                    out.println("}");
                }
            }
        }
    }

    protected void printTableJPAAnnotation(JavaWriter out, TableDefinition table) {
        SchemaDefinition schema = table.getSchema();
        int indent = out.indent();
        if (this.generateJPAAnnotations()) {
            List indexes;
            List keys;
            out.println("@%s", out.ref("jakarta.persistence.Entity"));
            out.println("@%s(", out.ref("jakarta.persistence.Table"));
            out.print("name = \"", out.ref("jakarta.persistence.Table"));
            out.print(this.escapeString(table.getName()));
            out.print("\"");
            if (!schema.isDefaultSchema()) {
                out.println(",");
                out.print("schema = \"");
                out.print(this.escapeString(schema.getOutputName()));
                out.print("\"");
            }
            if (!(keys = table.getUniqueKeys()).isEmpty()) {
                out.println(",");
                out.print("uniqueConstraints = ");
                out.println(this.scala ? "Array(" : (this.kotlin ? "[" : "{"));
                for (int i = 0; i < keys.size(); ++i) {
                    UniqueKeyDefinition uk = (UniqueKeyDefinition)keys.get(i);
                    ((JavaWriter)((JavaWriter)out.print(this.scala ? "new " : (this.kotlin ? "" : "@"))).print(out.ref("jakarta.persistence.UniqueConstraint"))).print("(");
                    if (!StringUtils.isBlank((String)uk.getOutputName())) {
                        out.print("name = \"" + this.escapeString(uk.getOutputName()) + "\", ");
                    }
                    ((JavaWriter)out.print("columnNames = ")).print(this.scala ? "Array(" : (this.kotlin ? "[ " : "{ "));
                    List columns = uk.getKeyColumns();
                    for (int j = 0; j < columns.size(); ++j) {
                        out.print(j > 0 ? ", " : "");
                        out.print("\"");
                        out.print(this.escapeString(((ColumnDefinition)columns.get(j)).getName()));
                        out.print("\"");
                    }
                    ((JavaWriter)((JavaWriter)out.print(this.scala ? ")" : (this.kotlin ? " ]" : " }"))).print(")")).println(i < keys.size() - 1 ? "," : "");
                }
                out.print(this.scala ? ")" : (this.kotlin ? "]" : "}"));
            }
            if ((StringUtils.isBlank((String)this.generateJPAVersion()) || "2.1".compareTo(this.generateJPAVersion()) <= 0) && !(indexes = table.getIndexes()).isEmpty()) {
                out.println(",");
                ((JavaWriter)out.print("indexes = ")).println(this.scala ? "Array(" : (this.kotlin ? "[" : "{"));
                for (int i = 0; i < indexes.size(); ++i) {
                    IndexDefinition index = (IndexDefinition)indexes.get(i);
                    out.print(this.scala ? "new " : (this.kotlin ? "" : "@"));
                    out.print(out.ref("jakarta.persistence.Index"));
                    ((JavaWriter)((JavaWriter)out.print("(name = \"")).print(this.escapeString(index.getOutputName()))).print("\"");
                    if (index.isUnique()) {
                        out.print(", unique = true");
                    }
                    out.print(", columnList = \"");
                    List columns = index.getIndexColumns();
                    for (int j = 0; j < columns.size(); ++j) {
                        IndexColumnDefinition column = (IndexColumnDefinition)columns.get(j);
                        if (j > 0) {
                            out.print(", ");
                        }
                        out.print(this.escapeString(column.getOutputName()));
                        if (column.getSortOrder() == SortOrder.ASC) {
                            out.print(" ASC");
                            continue;
                        }
                        if (column.getSortOrder() != SortOrder.DESC) continue;
                        out.print(" DESC");
                    }
                    ((JavaWriter)out.print("\")")).println(i < indexes.size() - 1 ? "," : "");
                }
                out.print(this.scala ? ")" : (this.kotlin ? "]" : "}"));
            }
            out.println();
            out.println(")");
        }
        out.indent(indent);
    }

    protected void printColumnJPAAnnotation(JavaWriter out, ColumnDefinition column) {
        int indent = out.indent();
        if (this.generateJPAAnnotations()) {
            String prefix = this.kotlin ? "get:" : "";
            UniqueKeyDefinition pk = column.getPrimaryKey();
            if (pk != null && pk.getKeyColumns().size() == 1) {
                out.println("@%s%s", prefix, out.ref("jakarta.persistence.Id"));
                if (((ColumnDefinition)pk.getKeyColumns().get(0)).isIdentity()) {
                    out.println("@%s%s(strategy = %s.IDENTITY)", prefix, out.ref("jakarta.persistence.GeneratedValue"), out.ref("jakarta.persistence.GenerationType"));
                }
            }
            String nullable = "";
            if (!column.getType(this.resolver(out)).isNullable()) {
                nullable = ", nullable = false";
            }
            Object length = "";
            Object precision = "";
            Object scale = "";
            if (column.getType(this.resolver(out)).getLength() > 0) {
                length = ", length = " + column.getType(this.resolver(out)).getLength();
            } else if (column.getType(this.resolver(out)).getPrecision() > 0) {
                precision = ", precision = " + column.getType(this.resolver(out)).getPrecision();
                if (column.getType(this.resolver(out)).getScale() > 0) {
                    scale = ", scale = " + column.getType(this.resolver(out)).getScale();
                }
            }
            out.print("@%s%s(name = \"", prefix, out.ref("jakarta.persistence.Column"));
            out.print(this.escapeString(column.getName()));
            out.print("\"");
            out.print(nullable);
            out.print((String)length);
            out.print((String)precision);
            out.print((String)scale);
            out.println(")");
        }
        out.indent(indent);
    }

    @Deprecated
    protected void printColumnValidationAnnotation(JavaWriter out, ColumnDefinition column) {
        this.printValidationAnnotation(out, (TypedElementDefinition<?>)column);
    }

    private void printValidationAnnotation(JavaWriter out, TypedElementDefinition<?> column) {
        if (this.generateValidationAnnotations()) {
            int length;
            String javaType;
            String prefix = this.kotlin ? "get:" : "";
            DataTypeDefinition type = column.getType(this.resolver(out));
            if (!(column.getType(this.resolver(out)).isNullable() || column.getType(this.resolver(out)).isDefaulted() || column.getType(this.resolver(out)).isIdentity())) {
                out.println("@%s%s", prefix, out.ref("jakarta.validation.constraints.NotNull"));
            }
            if (("java.lang.String".equals(javaType = this.getJavaType(type, out)) || "byte[]".equals(javaType)) && (length = type.getLength()) > 0) {
                out.println("@%s%s(max = %s)", prefix, out.ref("jakarta.validation.constraints.Size"), length);
            }
        }
    }

    protected void printKotlinSetterAnnotation(JavaWriter out, TypedElementDefinition<?> column, GeneratorStrategy.Mode mode) {
        if (this.kotlin && this.generateKotlinSetterJvmNameAnnotationsOnIsPrefix() && column instanceof ColumnDefinition && P_IS.matcher(this.getStrategy().getJavaMemberName((Definition)column, mode)).matches()) {
            if (this.generateInterfaces()) {
                out.println("@Suppress(\"INAPPLICABLE_JVM_NAME\")");
            }
            out.println("@set:JvmName(\"%s\")", this.getStrategy().getJavaSetterName((Definition)column, mode));
        }
    }

    private String nullableAnnotation(JavaWriter out) {
        return this.generateNullableAnnotation() ? out.ref(this.generatedNullableAnnotationType()) : null;
    }

    private String nonnullAnnotation(JavaWriter out) {
        return this.generateNonnullAnnotation() ? out.ref(this.generatedNonnullAnnotationType()) : null;
    }

    private String nullableOrNonnullAnnotation(JavaWriter out, Definition column) {
        return column instanceof TypedElementDefinition && ((TypedElementDefinition)column).getType().isNullable() ? this.nullableAnnotation(out) : this.nonnullAnnotation(out);
    }

    private void printNullableOrNonnullAnnotation(JavaWriter out, Definition column) {
        if (column instanceof TypedElementDefinition && ((TypedElementDefinition)column).getType().isNullable()) {
            this.printNullableAnnotation(out);
        } else {
            this.printNonnullAnnotation(out);
        }
    }

    protected void printNullableAnnotation(JavaWriter out) {
        if (this.generateNullableAnnotation()) {
            out.println("@%s", out.ref(this.generatedNullableAnnotationType()));
        }
    }

    protected void printNonnullAnnotation(JavaWriter out) {
        if (this.generateNonnullAnnotation()) {
            out.println("@%s", out.ref(this.generatedNonnullAnnotationType()));
        }
    }

    private boolean printDeprecationIfUnknownTypes(JavaWriter out, Collection<? extends ParameterDefinition> params) {
        for (ParameterDefinition parameterDefinition : params) {
            if (!this.printDeprecationIfUnknownType(out, this.getJavaType(parameterDefinition.getType(this.resolver(out)), out))) continue;
            return true;
        }
        return false;
    }

    private boolean printDeprecationIfUnknownType(JavaWriter out, String type) {
        if (this.generateDeprecationOnUnknownTypes() && (Object.class.getName().equals(type) || this.kotlin && "Any".equals(type))) {
            if (this.kotlin) {
                out.println("@%s(message = \"%s\")", out.ref("kotlin.Deprecated"), this.escapeString("Unknown data type. If this is a qualified, user-defined type, it may have been excluded from code generation. If this is a built-in type, you can define an explicit org.jooq.Binding to specify how this type should be handled. Deprecation can be turned off using <deprecationOnUnknownTypes/> in your code generator configuration."));
            } else {
                out.javadoc("@deprecated Unknown data type. If this is a qualified, user-defined type, it may have been excluded from code generation. If this is a built-in type, you can define an explicit {@link org.jooq.Binding} to specify how this type should be handled. Deprecation can be turned off using {@literal <deprecationOnUnknownTypes/>} in your code generator configuration.", new Object[0]);
                out.println("@%s", out.ref(Deprecated.class));
            }
            return true;
        }
        return false;
    }

    protected void generateRoutine(SchemaDefinition schema, RoutineDefinition routine) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)routine));
        log.info((Object)"Generating routine", (Object)out.file().getName());
        if (log.isDebugEnabled()) {
            for (ParameterDefinition parameter : routine.getAllParameters()) {
                log.debug((Object)"With parameter", (Object)("name=" + parameter.getOutputName() + ", matching type names=" + parameter.getDefinedType().getMatchNames()));
            }
        }
        this.generateRoutine(routine, out);
        this.closeJavaWriter(out);
    }

    protected void generateRoutine(RoutineDefinition routine, JavaWriter out) {
        List<String> binding;
        List<String> converter;
        String isUnnamed;
        String isDefaulted;
        String paramName;
        String paramId;
        String paramTypeRef;
        String paramType;
        String paramTypeFull;
        SchemaDefinition schema = routine.getSchema();
        String className = this.getStrategy().getJavaClassName((Definition)routine);
        String returnTypeFull = routine.getReturnValue() == null ? Void.class.getName() : this.getJavaType(routine.getReturnType(this.resolver(out)), out);
        String returnType = routine.getReturnValue() == null ? Void.class.getName() : out.ref(returnTypeFull);
        List<String> returnTypeRef = JavaGenerator.list(routine.getReturnValue() != null ? this.getJavaTypeReference(this.database, routine.getReturnType(this.resolver(out)), out) : null);
        List<String> returnConverter = out.ref(JavaGenerator.list(routine.getReturnValue() != null ? routine.getReturnType(this.resolver(out)).getConverter() : null));
        List<String> returnBinding = out.ref(JavaGenerator.list(routine.getReturnValue() != null ? routine.getReturnType(this.resolver(out)).getBinding() : null));
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)routine, GeneratorStrategy.Mode.DEFAULT));
        String schemaId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)schema), 2);
        List<String> packageId = out.ref(this.getStrategy().getFullJavaIdentifiers(new Definition[]{routine.getPackage()}), 2);
        this.printPackage(out, (Definition)routine);
        if (this.scala) {
            out.println("object %s {", className);
            for (ParameterDefinition parameter : routine.getAllParameters()) {
                paramTypeFull = this.getJavaType(parameter.getType(this.resolver(out)), out);
                paramType = out.ref(paramTypeFull);
                paramTypeRef = this.getJavaTypeReference(parameter.getDatabase(), parameter.getType(this.resolver(out)), out);
                paramId = out.ref(this.getStrategy().getJavaIdentifier((Definition)parameter), 2);
                paramName = parameter.getName();
                isDefaulted = parameter.isDefaulted() ? "true" : "false";
                isUnnamed = parameter.isUnnamed() ? "true" : "false";
                converter = out.ref(JavaGenerator.list(parameter.getType(this.resolver(out)).getConverter()));
                binding = out.ref(JavaGenerator.list(parameter.getType(this.resolver(out)).getBinding()));
                if (!this.printDeprecationIfUnknownType(out, paramTypeFull)) {
                    out.javadoc("The parameter <code>%s</code>.[[before= ][%s]]", parameter.getQualifiedOutputName(), JavaGenerator.list(this.escapeEntities(this.comment((Definition)parameter))));
                }
                out.println("val %s: %s[%s] = %s.createParameter(\"%s\", %s, %s, %s" + this.converterTemplate(converter) + this.converterTemplate(binding) + ")", this.scalaWhitespaceSuffix(paramId), Parameter.class, paramType, Internal.class, this.escapeString(paramName), paramTypeRef, isDefaulted, isUnnamed, converter, binding);
            }
            out.println("}");
            out.println();
        }
        if (!this.printDeprecationIfUnknownType(out, returnTypeFull)) {
            this.generateRoutineClassJavadoc(routine, out);
        }
        this.printClassAnnotations(out, (Definition)routine, GeneratorStrategy.Mode.DEFAULT);
        if (this.scala) {
            out.println("%sclass %s extends %s[%s](\"%s\", %s[[before=, ][%s]][[before=, ][%s]]" + this.converterTemplate(returnConverter) + this.converterTemplate(returnBinding) + ")[[before= with ][separator= with ][%s]] {", this.visibility(), className, AbstractRoutine.class, returnType, this.escapeString(routine.getName()), schemaId, packageId, returnTypeRef, returnConverter, returnBinding, interfaces);
        } else {
            if (this.kotlin) {
                out.println("%sopen class %s : %s<%s>(\"%s\", %s[[before=, ][%s]][[before=, ][%s]]" + this.converterTemplate(returnConverter) + this.converterTemplate(returnBinding) + ")[[before=, ][%s]] {", this.visibility(), className, AbstractRoutine.class, returnType, this.escapeString(routine.getName()), schemaId, packageId, returnTypeRef, returnConverter, returnBinding, interfaces);
            } else {
                out.println("%sclass %s extends %s<%s>[[before= implements ][%s]] {", this.visibility(), className, AbstractRoutine.class, returnType, interfaces);
                out.printSerial();
            }
            if (this.kotlin) {
                out.println("%scompanion object {", this.visibility());
            }
            for (ParameterDefinition parameter : routine.getAllParameters()) {
                paramTypeFull = this.getJavaType(parameter.getType(this.resolver(out)), out);
                paramType = out.ref(paramTypeFull);
                paramTypeRef = this.getJavaTypeReference(parameter.getDatabase(), parameter.getType(this.resolver(out)), out);
                paramId = this.getStrategy().getJavaIdentifier((Definition)parameter);
                paramName = parameter.getName();
                isDefaulted = parameter.isDefaulted() ? "true" : "false";
                isUnnamed = parameter.isUnnamed() ? "true" : "false";
                converter = out.ref(JavaGenerator.list(parameter.getType(this.resolver(out)).getConverter()));
                binding = out.ref(JavaGenerator.list(parameter.getType(this.resolver(out)).getBinding()));
                if (!this.printDeprecationIfUnknownType(out, paramTypeFull)) {
                    out.javadoc("The parameter <code>%s</code>.[[before= ][%s]]", parameter.getQualifiedOutputName(), JavaGenerator.list(this.escapeEntities(this.comment((Definition)parameter))));
                }
                if (this.kotlin) {
                    out.println("%sval %s: %s<%s?> = %s.createParameter(\"%s\", %s, %s, %s" + this.converterTemplate(converter) + this.converterTemplate(binding) + ")", this.visibility(), this.scalaWhitespaceSuffix(paramId), Parameter.class, paramType, Internal.class, this.escapeString(paramName), paramTypeRef, isDefaulted, isUnnamed, converter, binding);
                    continue;
                }
                out.println("%sstatic final %s<%s> %s = %s.createParameter(\"%s\", %s, %s, %s" + this.converterTemplate(converter) + this.converterTemplate(binding) + ");", this.visibility(), Parameter.class, paramType, paramId, Internal.class, this.escapeString(paramName), paramTypeRef, isDefaulted, isUnnamed, converter, binding);
            }
            if (this.kotlin) {
                ((JavaWriter)out.println("}")).println();
            }
        }
        if (this.scala) {
            out.println("{");
        } else if (this.kotlin) {
            out.println("init {");
        } else {
            out.javadoc("Create a new routine call instance", new Object[0]);
            out.println("%s%s() {", this.visibility(), className);
            out.println("super(\"%s\", %s[[before=, ][%s]][[before=, ][%s]]" + this.converterTemplate(returnConverter) + this.converterTemplate(returnBinding) + ");", routine.getName(), schemaId, packageId, returnTypeRef, returnConverter, returnBinding);
            if (routine.getAllParameters().size() > 0) {
                out.println();
            }
        }
        for (ParameterDefinition parameter : routine.getAllParameters()) {
            String paramId2 = this.getStrategy().getJavaIdentifier((Definition)parameter);
            if (parameter.equals(routine.getReturnValue())) {
                if (parameter.isSynthetic()) {
                    if (this.scala) {
                        out.println("setSyntheticReturnParameter(%s.%s)", className, paramId2);
                        continue;
                    }
                    if (this.kotlin) {
                        out.println("syntheticReturnParameter = %s", paramId2);
                        continue;
                    }
                    out.println("setSyntheticReturnParameter(%s);", paramId2);
                    continue;
                }
                if (this.scala) {
                    out.println("setReturnParameter(%s.%s)", className, paramId2);
                    continue;
                }
                if (this.kotlin) {
                    out.println("returnParameter = %s", paramId2);
                    continue;
                }
                out.println("setReturnParameter(%s);", paramId2);
                continue;
            }
            if (routine.getInParameters().contains(parameter)) {
                if (routine.getOutParameters().contains(parameter)) {
                    if (this.scala) {
                        out.println("addInOutParameter(%s.%s)", className, paramId2);
                        continue;
                    }
                    if (this.kotlin) {
                        out.println("addInOutParameter(%s)", paramId2);
                        continue;
                    }
                    out.println("addInOutParameter(%s);", paramId2);
                    continue;
                }
                if (this.scala) {
                    out.println("addInParameter(%s.%s)", className, paramId2);
                    continue;
                }
                if (this.kotlin) {
                    out.println("addInParameter(%s)", paramId2);
                    continue;
                }
                out.println("addInParameter(%s);", paramId2);
                continue;
            }
            if (this.scala) {
                out.println("addOutParameter(%s.%s)", className, paramId2);
                continue;
            }
            if (this.kotlin) {
                out.println("addOutParameter(%s)", paramId2);
                continue;
            }
            out.println("addOutParameter(%s);", paramId2);
        }
        if (routine.getOverload() != null) {
            out.println("setOverloaded(true)%s", this.semicolon);
        }
        if (routine instanceof PostgresRoutineDefinition && ((PostgresRoutineDefinition)routine).isProcedure()) {
            out.println("setSQLUsable(false)%s", this.semicolon);
        }
        out.println("}");
        for (ParameterDefinition parameter : routine.getInParameters()) {
            String setterReturnType = this.generateFluentSetters() ? className : this.tokenVoid;
            String setter = this.getStrategy().getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            String numberValue = parameter.getType(this.resolver(out)).isGenericNumberType() ? "Number" : "Value";
            String numberField = parameter.getType(this.resolver(out)).isGenericNumberType() ? "Number" : "Field";
            String paramId3 = this.getStrategy().getJavaIdentifier((Definition)parameter);
            String paramName2 = "value".equals(paramId3) ? "value_" : "value";
            out.javadoc("Set the <code>%s</code> parameter IN value to the routine", parameter.getOutputName());
            if (this.scala) {
                out.println("%sdef %s(%s: %s) : Unit = set%s(%s.%s, %s)", this.visibility(), setter, this.scalaWhitespaceSuffix(paramName2), this.refNumberType(out, parameter.getType(this.resolver(out))), numberValue, className, paramId3, paramName2);
            } else if (this.kotlin) {
                out.println("%sfun %s(%s: %s?): Unit = set%s(%s, %s)", this.visibility(), setter, paramName2, this.refNumberType(out, parameter.getType(this.resolver(out))), numberValue, paramId3, paramName2);
            } else {
                out.println("%svoid %s(%s %s) {", this.visibility(), setter, this.varargsIfArray(this.refNumberType(out, parameter.getType(this.resolver(out)))), paramName2);
                out.println("set%s(%s, %s);", numberValue, paramId3, paramName2);
                out.println("}");
            }
            if (!routine.isSQLUsable()) continue;
            out.javadoc("Set the <code>%s</code> parameter to the function to be used with a {@link org.jooq.Select} statement", parameter.getOutputName());
            if (this.scala) {
                out.println("%sdef %s(field: %s[%s]): %s = {", this.visibility(), setter, Field.class, this.refExtendsNumberType(out, parameter.getType(this.resolver(out))), setterReturnType);
                out.println("set%s(%s.%s, field)", numberField, className, paramId3);
                if (this.generateFluentSetters()) {
                    out.println("this");
                }
                out.println("}");
                continue;
            }
            if (this.kotlin) {
                out.println("%sfun %s(field: %s<%s?>): %s {", this.visibility(), setter, Field.class, this.refExtendsNumberType(out, parameter.getType(this.resolver(out))), setterReturnType);
                out.println("set%s(%s, field)", numberField, paramId3);
                if (this.generateFluentSetters()) {
                    out.println("return this");
                }
                out.println("}");
                continue;
            }
            out.println("%s%s %s(%s<%s> field) {", this.visibility(), setterReturnType, setter, Field.class, this.refExtendsNumberType(out, parameter.getType(this.resolver(out))));
            out.println("set%s(%s, field);", numberField, paramId3);
            if (this.generateFluentSetters()) {
                out.println("return this;");
            }
            out.println("}");
        }
        for (ParameterDefinition parameter : routine.getAllParameters()) {
            boolean isReturnValue = parameter.equals(routine.getReturnValue());
            boolean isOutParameter = routine.getOutParameters().contains(parameter);
            if (!isOutParameter || isReturnValue) continue;
            String paramName3 = parameter.getOutputName();
            String paramTypeFull2 = this.getJavaType(parameter.getType(this.resolver(out)), out);
            String paramType2 = out.ref(paramTypeFull2);
            String paramGetter = this.getStrategy().getJavaGetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            String paramId4 = this.getStrategy().getJavaIdentifier((Definition)parameter);
            if (!this.printDeprecationIfUnknownType(out, paramTypeFull2)) {
                out.javadoc("Get the <code>%s</code> parameter OUT value from the routine", paramName3);
            }
            if (this.scala) {
                out.println("%sdef %s: %s = get(%s.%s)", this.visibility(), this.scalaWhitespaceSuffix(paramGetter), paramType2, className, paramId4);
                continue;
            }
            if (this.kotlin) {
                out.println("%sfun %s(): %s? = get(%s)", this.visibility(), paramGetter, paramType2, paramId4);
                continue;
            }
            out.println("%s%s %s() {", this.visibility(), paramType2, paramGetter);
            out.println("return get(%s);", paramId4);
            out.println("}");
        }
        this.generateRoutineClassFooter(routine, out);
        out.println("}");
    }

    protected void generateRoutineClassFooter(RoutineDefinition routine, JavaWriter out) {
    }

    protected void generateRoutineClassJavadoc(RoutineDefinition routine, JavaWriter out) {
        if (this.generateCommentsOnRoutines()) {
            this.printClassJavadoc(out, (Definition)routine);
        } else {
            this.printClassJavadoc(out, "The routine <code>" + routine.getQualifiedInputName() + "</code>.");
        }
    }

    protected void printConvenienceMethodFunctionAsField(JavaWriter out, RoutineDefinition function, boolean parametersAsField) {
        if (function.getInParameters().size() > 254) {
            log.info((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        if (parametersAsField && function.getInParameters().isEmpty()) {
            return;
        }
        String functionTypeFull = this.getJavaType(function.getReturnType(this.resolver(out)), out);
        String functionType = out.ref(functionTypeFull);
        String className = out.ref(this.getStrategy().getFullJavaClassName((Definition)function));
        String localVar = this.disambiguateJavaMemberName(function.getInParameters(), "f");
        String methodName = this.getStrategy().getJavaMethodName((Definition)function, GeneratorStrategy.Mode.DEFAULT);
        if (!this.printDeprecationIfUnknownType(out, functionTypeFull) && !this.printDeprecationIfUnknownTypes(out, function.getInParameters())) {
            out.javadoc("Get <code>%s</code> as a field.", function.getQualifiedOutputName());
        }
        if (this.scala) {
            out.print("%sdef %s(", this.visibility(), methodName);
        } else if (this.kotlin) {
            out.print("%sfun %s(", this.visibility(), methodName);
        } else {
            out.print("%sstatic %s<%s> %s(", this.visibility(), function.isAggregate() ? AggregateFunction.class : Field.class, functionType, methodName);
        }
        if (!function.getInParameters().isEmpty()) {
            out.println();
        }
        this.printParameterDeclarations(out, function.getInParameters(), parametersAsField, "  ");
        if (this.scala) {
            out.println("): %s[%s] = {", function.isAggregate() ? AggregateFunction.class : Field.class, functionType);
            out.println("val %s = new %s", localVar, className);
        } else if (this.kotlin) {
            out.println("): %s<%s?> {", function.isAggregate() ? AggregateFunction.class : Field.class, functionType);
            out.println("val %s = %s()", localVar, className);
        } else {
            out.println(") {");
            out.println("%s %s = new %s();", className, localVar, className);
        }
        for (ParameterDefinition parameter : function.getInParameters()) {
            String paramSetter = this.getStrategy().getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            String paramMember = this.getStrategy().getJavaMemberName((Definition)parameter);
            out.println("%s.%s(%s)%s", localVar, paramSetter, paramMember, this.semicolon);
        }
        out.println();
        out.println("return %s.as%s%s%s", localVar, function.isAggregate() ? "AggregateFunction" : "Field", this.emptyparens, this.semicolon);
        out.println("}");
    }

    protected void printConvenienceMethodTableValuedFunctionAsField(JavaWriter out, TableDefinition function, boolean parametersAsField, String methodName) {
        if (function.getParameters().size() > 254) {
            log.info((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        if (function.getParameters().isEmpty()) {
            if (parametersAsField) {
                return;
            }
            if (this.scala) {
                return;
            }
        }
        String className = out.ref(this.getStrategy().getFullJavaClassName((Definition)function));
        String functionIdentifier = this.getStrategy().getFullJavaIdentifier((Definition)function);
        if (!this.printDeprecationIfUnknownTypes(out, function.getParameters())) {
            out.javadoc("Get <code>%s</code> as a table.", function.getQualifiedOutputName());
        }
        if (this.scala) {
            out.print("%sdef %s(", this.visibility(), methodName);
        } else if (this.kotlin) {
            out.print("%sfun %s(", this.visibility(), methodName);
        } else {
            out.print("%sstatic %s %s(", this.visibility(), className, methodName);
        }
        if (!function.getParameters().isEmpty()) {
            out.println();
        }
        this.printParameterDeclarations(out, function.getParameters(), parametersAsField, "  ");
        if (this.scala || this.kotlin) {
            out.println("): %s = %s.call(", className, functionIdentifier);
        } else {
            out.println(") {");
            out.println("return %s.call(", functionIdentifier);
        }
        this.forEach(function.getParameters(), (parameter, separator) -> out.println("%s%s", this.getStrategy().getJavaMemberName((Definition)parameter), separator));
        if (this.scala || this.kotlin) {
            out.println(")");
        } else {
            ((JavaWriter)out.println(");")).println("}");
        }
    }

    private void printParameterDeclarations(JavaWriter out, List<ParameterDefinition> parameters, boolean parametersAsField, String separator) {
        for (ParameterDefinition parameter : parameters) {
            String memberName = this.getStrategy().getJavaMemberName((Definition)parameter);
            if (this.scala) {
                if (parametersAsField) {
                    out.println("%s%s: %s[%s]", separator, this.scalaWhitespaceSuffix(memberName), Field.class, this.refExtendsNumberType(out, parameter.getType(this.resolver(out))));
                } else {
                    out.println("%s%s: %s", separator, this.scalaWhitespaceSuffix(memberName), this.refNumberType(out, parameter.getType(this.resolver(out))));
                }
            } else if (this.kotlin) {
                if (parametersAsField) {
                    out.println("%s%s: %s<%s?>", separator, memberName, Field.class, this.refExtendsNumberType(out, parameter.getType(this.resolver(out))));
                } else {
                    out.println("%s%s: %s%s", separator, memberName, this.refNumberType(out, parameter.getType(this.resolver(out))), this.kotlinNullability((TypedElementDefinition<?>)parameter));
                }
            } else if (parametersAsField) {
                out.println("%s%s<%s> %s", separator, Field.class, this.refExtendsNumberType(out, parameter.getType(this.resolver(out))), memberName);
            } else {
                out.println("%s%s %s", separator, this.refNumberType(out, parameter.getType(this.resolver(out))), memberName);
            }
            separator = ", ";
        }
    }

    private String disambiguateJavaMemberName(Collection<? extends Definition> definitions, String defaultName) {
        HashSet<String> names = new HashSet<String>();
        for (Definition definition : definitions) {
            names.add(this.getStrategy().getJavaMemberName(definition));
        }
        Object name = defaultName;
        while (names.contains(name)) {
            name = (String)name + "_";
        }
        return name;
    }

    protected void printConvenienceMethodFunction(JavaWriter out, RoutineDefinition function, boolean instance) {
        String paramMember;
        if (function.getInParameters().size() > 254) {
            log.info((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        String className = out.ref(this.getStrategy().getFullJavaClassName((Definition)function));
        String functionName = function.getQualifiedOutputName();
        String functionTypeFull = this.getJavaType(function.getReturnType(this.resolver(out)), out);
        String functionType = out.ref(functionTypeFull);
        String methodName = this.getStrategy().getJavaMethodName((Definition)function, GeneratorStrategy.Mode.DEFAULT);
        String configurationArgument = this.disambiguateJavaMemberName(function.getInParameters(), "configuration");
        String localVar = this.disambiguateJavaMemberName(function.getInParameters(), "f");
        if (!this.printDeprecationIfUnknownType(out, functionTypeFull) && !this.printDeprecationIfUnknownTypes(out, function.getInParameters())) {
            out.javadoc("Call <code>%s</code>", functionName);
        }
        if (this.scala) {
            out.println("%sdef %s(", this.visibility(), methodName);
        } else if (this.kotlin) {
            out.println("%sfun %s(", this.visibility(), methodName);
        } else {
            out.println("%s%s%s %s(", this.visibility(), !instance ? "static " : "", functionType, methodName);
        }
        String separator = "  ";
        if (!instance) {
            if (this.scala) {
                out.println("%s%s: %s", separator, this.scalaWhitespaceSuffix(configurationArgument), Configuration.class);
            } else if (this.kotlin) {
                out.println("%s%s: %s", separator, configurationArgument, Configuration.class);
            } else {
                out.println("%s%s %s", separator, Configuration.class, configurationArgument);
            }
            separator = ", ";
        }
        for (ParameterDefinition parameter : function.getInParameters()) {
            if (instance && parameter.equals(function.getInParameters().get(0))) continue;
            String paramType = this.refNumberType(out, parameter.getType(this.resolver(out)));
            paramMember = this.getStrategy().getJavaMemberName((Definition)parameter);
            if (this.scala) {
                out.println("%s%s: %s", separator, this.scalaWhitespaceSuffix(paramMember), paramType);
            } else if (this.kotlin) {
                out.println("%s%s: %s%s", separator, paramMember, paramType, this.kotlinNullability((TypedElementDefinition<?>)parameter));
            } else {
                out.println("%s%s %s", separator, paramType, paramMember);
            }
            separator = ", ";
        }
        if (this.scala) {
            out.println("): %s = {", functionType);
            out.println("val %s = new %s()", localVar, className);
        } else if (this.kotlin) {
            out.println("): %s? {", functionType);
            out.println("val %s = %s()", localVar, className);
        } else {
            out.println(") {");
            out.println("%s %s = new %s();", className, localVar, className);
        }
        for (ParameterDefinition parameter : function.getInParameters()) {
            String paramSetter = this.getStrategy().getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            paramMember = instance && parameter.equals(function.getInParameters().get(0)) ? "this" : this.getStrategy().getJavaMemberName((Definition)parameter);
            out.println("%s.%s(%s)%s", localVar, paramSetter, paramMember, this.semicolon);
        }
        out.println();
        out.println("%s.execute(%s)%s", localVar, instance ? "configuration()" : configurationArgument, this.semicolon);
        if (this.scala) {
            out.println("%s.getReturnValue", localVar);
        } else if (this.kotlin) {
            out.println("return %s.returnValue", localVar);
        } else {
            out.println("return %s.getReturnValue();", localVar);
        }
        out.println("}");
    }

    protected void printConvenienceMethodProcedure(JavaWriter out, RoutineDefinition procedure, boolean instance) {
        String firstOutParamType;
        if (procedure.getInParameters().size() > 254) {
            log.info((Object)"Too many parameters", (Object)("Procedure " + procedure + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        String className = out.ref(this.getStrategy().getFullJavaClassName((Definition)procedure));
        String configurationArgument = this.disambiguateJavaMemberName(procedure.getInParameters(), "configuration");
        String localVar = this.disambiguateJavaMemberName(procedure.getInParameters(), "p");
        List<ParameterDefinition> outParams = JavaGenerator.list(procedure.getReturnValue(), procedure.getOutParameters());
        String methodName = this.getStrategy().getJavaMethodName((Definition)procedure, GeneratorStrategy.Mode.DEFAULT);
        String string = firstOutParamType = outParams.size() == 1 ? out.ref(this.getJavaType(outParams.get(0).getType(this.resolver(out)), out)) : "";
        if (!this.printDeprecationIfUnknownTypes(out, procedure.getAllParameters())) {
            out.javadoc("Call <code>%s</code>", procedure.getQualifiedOutputName());
        }
        if (this.scala) {
            out.println("%sdef %s(", this.visibility(), methodName);
        } else if (this.kotlin) {
            out.println("%sfun %s(", this.visibility(), methodName);
        } else {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.visibility();
            Object object = objectArray[1] = !instance ? "static " : "";
            objectArray[2] = outParams.size() == 0 ? "void" : (outParams.size() == 1 ? firstOutParamType : className);
            objectArray[3] = methodName;
            out.println("%s%s%s %s(", objectArray);
        }
        String separator = "  ";
        if (!instance) {
            if (this.scala) {
                out.println("%s%s: %s", separator, this.scalaWhitespaceSuffix(configurationArgument), Configuration.class);
            } else if (this.kotlin) {
                out.println("%s%s: %s", separator, configurationArgument, Configuration.class);
            } else {
                out.println("%s%s %s", separator, Configuration.class, configurationArgument);
            }
            separator = ", ";
        }
        for (ParameterDefinition parameter : procedure.getInParameters()) {
            if (instance && parameter.equals(procedure.getInParameters().get(0))) continue;
            String memberName = this.getStrategy().getJavaMemberName((Definition)parameter);
            String typeName = this.refNumberType(out, parameter.getType(this.resolver(out)));
            if (this.scala) {
                out.println("%s%s: %s", separator, this.scalaWhitespaceSuffix(memberName), typeName);
            } else if (this.kotlin) {
                out.println("%s%s: %s?", separator, memberName, typeName);
            } else {
                out.println("%s%s %s", separator, typeName, memberName);
            }
            separator = ", ";
        }
        if (this.scala) {
            out.println("): %s = {", outParams.size() == 0 ? "Unit" : (outParams.size() == 1 ? firstOutParamType : className));
            out.println("val %s = new %s", localVar, className);
        } else if (this.kotlin) {
            out.println("): %s%s {", outParams.size() == 0 ? "Unit" : (outParams.size() == 1 ? firstOutParamType : className), outParams.size() == 1 ? "?" : "");
            out.println("val %s = %s()", localVar, className);
        } else {
            out.println(") {");
            out.println("%s %s = new %s();", className, localVar, className);
        }
        for (ParameterDefinition parameter : procedure.getInParameters()) {
            String setter = this.getStrategy().getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            String arg = instance && parameter.equals(procedure.getInParameters().get(0)) ? "this" : this.getStrategy().getJavaMemberName((Definition)parameter);
            out.println("%s.%s(%s)%s", localVar, setter, arg, this.semicolon);
        }
        out.println();
        out.println("%s.execute(%s)%s", localVar, instance ? "configuration()" : configurationArgument, this.semicolon);
        if (outParams.size() > 0) {
            ParameterDefinition parameter = outParams.get(0);
            String getter = parameter == procedure.getReturnValue() ? "getReturnValue" : this.getStrategy().getJavaGetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            boolean isUDT = parameter.getType(this.resolver(out)).isUDT();
            if (instance) {
                if (this.generateInterfaces() && isUDT) {
                    String columnTypeInterface = out.ref(this.getJavaType(parameter.getType(this.resolver(out, GeneratorStrategy.Mode.INTERFACE)), out, GeneratorStrategy.Mode.INTERFACE));
                    if (this.scala) {
                        out.println("from(%s.%s.asInstanceOf[%s])", localVar, getter, columnTypeInterface);
                    } else if (this.kotlin) {
                        out.println("from(%s.%s() as %s);", localVar, getter, columnTypeInterface);
                    } else {
                        out.println("from((%s) %s.%s());", columnTypeInterface, localVar, getter);
                    }
                } else {
                    out.println("from(%s.%s%s)%s", localVar, getter, this.emptyparens, this.semicolon);
                }
            }
            if (outParams.size() == 1) {
                out.println("return %s.%s%s%s", localVar, getter, this.emptyparens, this.semicolon);
            } else if (outParams.size() > 1) {
                out.println("return %s%s", localVar, this.semicolon);
            }
        }
        out.println("}");
    }

    protected void printConvenienceMethodTableValuedFunction(JavaWriter out, TableDefinition function, String methodName) {
        if (function.getParameters().size() > 254) {
            log.info((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        String recordClassName = out.ref(this.getStrategy().getFullJavaClassName((Definition)function, GeneratorStrategy.Mode.RECORD));
        String configurationArgument = this.disambiguateJavaMemberName(function.getParameters(), "configuration");
        String functionName = this.getStrategy().getFullJavaIdentifier((Definition)function);
        if (!this.printDeprecationIfUnknownTypes(out, function.getParameters())) {
            out.javadoc("Call <code>%s</code>.", function.getQualifiedOutputName());
        }
        if (this.scala) {
            out.println("%sdef %s(", this.visibility(), methodName);
        } else if (this.kotlin) {
            out.println("%sfun %s(", this.visibility(), methodName);
        } else {
            out.println("%sstatic %s<%s> %s(", this.visibility(), Result.class, recordClassName, methodName);
        }
        String separator = "  ";
        if (this.scala) {
            out.println("%s%s: %s", separator, this.scalaWhitespaceSuffix(configurationArgument), Configuration.class);
        } else if (this.kotlin) {
            out.println("%s%s: %s", separator, configurationArgument, Configuration.class);
        } else {
            out.println("%s%s %s", separator, Configuration.class, configurationArgument);
        }
        this.printParameterDeclarations(out, function.getParameters(), false, ", ");
        if (this.scala) {
            out.println("): %s[%s] = %s.dsl().selectFrom(%s.call(", Result.class, recordClassName, configurationArgument, functionName);
        } else if (this.kotlin) {
            out.println("): %s<%s> = %s.dsl().selectFrom(%s.call(", Result.class, recordClassName, configurationArgument, functionName);
        } else {
            out.println(") {");
            out.println("return %s.dsl().selectFrom(%s.call(", configurationArgument, functionName);
        }
        separator = "  ";
        for (ParameterDefinition parameter : function.getParameters()) {
            out.println("%s%s", separator, this.getStrategy().getJavaMemberName((Definition)parameter));
            separator = ", ";
        }
        if (this.scala || this.kotlin) {
            out.println(")).fetch()");
        } else {
            ((JavaWriter)out.println(")).fetch();")).println("}");
        }
    }

    protected void printRecordTypeMethod(JavaWriter out, Definition definition) {
        String className = out.ref(this.getStrategy().getFullJavaClassName(definition, GeneratorStrategy.Mode.RECORD));
        out.javadoc("The class holding records for this type", new Object[0]);
        if (this.scala) {
            out.println("%soverride def getRecordType: %s[%s] = classOf[%s]", this.visibilityPublic(), Class.class, className, className);
        } else if (this.kotlin) {
            out.println("%soverride fun getRecordType(): %s<%s> = %s::class.java", this.visibilityPublic(), Class.class, className, className);
        } else {
            out.override();
            this.printNonnullAnnotation(out);
            out.println("%s%s<%s> getRecordType() {", this.visibilityPublic(), Class.class, className);
            out.println("return %s.class;", className);
            out.println("}");
        }
    }

    protected void printSingletonInstance(JavaWriter out, Definition definition) {
        String className = this.getStrategy().getJavaClassName(definition);
        String identifier = this.getStrategy().getJavaIdentifier(definition);
        out.javadoc("The reference instance of <code>%s</code>", definition.getQualifiedOutputName());
        if (this.scala) {
            out.println("%sval %s = new %s", this.visibility(), identifier, className);
        } else if (this.kotlin) {
            out.println("%sval %s: %s = %s()", this.visibility(), identifier, className, className);
        } else {
            out.println("%sstatic final %s %s = new %s();", this.visibility(), className, identifier, className);
        }
    }

    protected final String escapeEntities(String comment) {
        if (comment == null) {
            return null;
        }
        return comment.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    protected void printClassJavadoc(JavaWriter out, Definition definition) {
        this.printClassJavadoc(out, this.escapeEntities(definition.getComment()));
    }

    private String comment(Definition definition) {
        return definition instanceof CatalogDefinition && this.generateCommentsOnCatalogs() || definition instanceof SchemaDefinition && this.generateCommentsOnSchemas() || definition instanceof TableDefinition && this.generateCommentsOnTables() || definition instanceof ColumnDefinition && this.generateCommentsOnColumns() || definition instanceof EmbeddableDefinition && this.generateCommentsOnEmbeddables() || definition instanceof UDTDefinition && this.generateCommentsOnUDTs() || definition instanceof AttributeDefinition && this.generateCommentsOnAttributes() || definition instanceof PackageDefinition && this.generateCommentsOnPackages() || definition instanceof RoutineDefinition && this.generateCommentsOnRoutines() || definition instanceof ParameterDefinition && this.generateCommentsOnParameters() || definition instanceof SequenceDefinition && this.generateCommentsOnSequences() ? StringUtils.defaultIfBlank((String)definition.getComment(), (String)"") : "";
    }

    private String referencingComment(EmbeddableDefinition definition) {
        return this.generateCommentsOnEmbeddables() ? StringUtils.defaultIfBlank((String)definition.getReferencingComment(), (String)"") : "";
    }

    protected void printClassJavadoc(JavaWriter out, String comment) {
        if (this.generateJavadoc()) {
            out.println("/**");
            if (comment != null && comment.length() > 0) {
                out.println(JavaWriter.escapeJavadoc(comment));
            } else {
                out.println("This class is generated by jOOQ.");
            }
            out.println(" */");
        }
    }

    @Deprecated
    protected final void printClassAnnotations(JavaWriter out, SchemaDefinition schema) {
    }

    @Deprecated
    protected final void printClassAnnotations(JavaWriter out, SchemaDefinition schema, CatalogDefinition catalog) {
    }

    protected void printClassAnnotations(JavaWriter out, Definition definition, GeneratorStrategy.Mode mode) {
        if (this.generateGeneratedAnnotation()) {
            String generated;
            SchemaDefinition schema = definition.getSchema();
            CatalogDefinition catalog = definition.getCatalog();
            GeneratedAnnotationType type = this.generateGeneratedAnnotationType();
            if (type == null) {
                type = GeneratedAnnotationType.DETECT_FROM_JDK;
            }
            switch (type) {
                case DETECT_FROM_JDK: {
                    try {
                        Reflect.onClass((String)"java.util.Optional").call("of", new Object[]{new Object()}).call("stream");
                        generated = "javax.annotation.processing.Generated";
                    }
                    catch (ReflectException e) {
                        generated = "javax.annotation.Generated";
                    }
                    break;
                }
                case JAVAX_ANNOTATION_GENERATED: {
                    generated = "javax.annotation.Generated";
                    break;
                }
                case JAVAX_ANNOTATION_PROCESSING_GENERATED: {
                    generated = "javax.annotation.processing.Generated";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported type: " + type);
                }
            }
            out.println("@%s(", out.ref(generated));
            if (this.useSchemaVersionProvider() || this.useCatalogVersionProvider()) {
                boolean hasSchemaVersion;
                boolean hasCatalogVersion = !StringUtils.isBlank((String)this.catalogVersions.get(catalog));
                boolean bl = hasSchemaVersion = !StringUtils.isBlank((String)this.schemaVersions.get(schema));
                if (this.scala) {
                    out.println("value = %s(", out.ref("scala.Array"));
                } else if (this.kotlin) {
                    out.println("value = [");
                } else {
                    out.println("value = {");
                }
                out.println("\"https://www.jooq.org\",");
                out.println("\"jOOQ version:%s\"%s", "3.16.1", hasCatalogVersion || hasSchemaVersion ? "," : "");
                if (hasCatalogVersion) {
                    out.println("\"catalog version:%s\"%s", this.escapeString(this.catalogVersions.get(catalog)), hasSchemaVersion ? "," : "");
                }
                if (hasSchemaVersion) {
                    out.println("\"schema version:%s\"", this.escapeString(this.schemaVersions.get(schema)));
                }
                if (this.scala) {
                    out.println("),");
                } else if (this.kotlin) {
                    out.println("],");
                } else {
                    out.println("},");
                }
                if (this.generateGeneratedAnnotationDate()) {
                    out.println("date = \"" + this.isoDate + "\",");
                }
                out.println("comments = \"This class is generated by jOOQ\"");
            } else {
                if (this.scala) {
                    out.println("value = %s(", out.ref("scala.Array"));
                } else if (this.kotlin) {
                    out.println("value = [");
                } else {
                    out.println("value = {");
                }
                out.println("\"https://www.jooq.org\",");
                out.println("\"jOOQ version:%s\"", "3.16.1");
                if (this.scala) {
                    out.println("),");
                } else if (this.kotlin) {
                    out.println("],");
                } else {
                    out.println("},");
                }
                out.println("comments = \"This class is generated by jOOQ\"");
            }
            out.println(")");
        }
        if (!this.scala) {
            if (this.kotlin) {
                out.println("@Suppress(\"UNCHECKED_CAST\")");
            } else {
                out.println("@%s({ \"all\", \"unchecked\", \"rawtypes\" })", out.ref("java.lang.SuppressWarnings"));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readVersion(File file, String type) {
        try (RandomAccessFile f = new RandomAccessFile(file, "r");){
            byte[] bytes = new byte[(int)f.length()];
            f.readFully(bytes);
            String string = new String(bytes);
            Matcher matcher = Pattern.compile("@(?:javax\\.annotation\\.)?Generated\\(\\s*?value\\s*?=\\s*?" + (this.scala ? "Array\\([^)]*?" : "\\{[^}]*?") + "\"" + type + " version:([^\"]*?)\"").matcher(string);
            if (!matcher.find()) return null;
            String string2 = matcher.group(1);
            return string2;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    protected void printPackage(JavaWriter out, Definition definition) {
        this.printPackage(out, definition, GeneratorStrategy.Mode.DEFAULT);
    }

    protected void printPackage(JavaWriter out, Definition definition, GeneratorStrategy.Mode mode) {
        this.printPackageComment(out, definition, mode);
        out.printPackageSpecification(this.getStrategy().getJavaPackageName(definition, mode));
        out.println();
        out.printImports();
        out.println();
    }

    protected void printGlobalReferencesPackage(JavaWriter out, Definition container, Class<? extends Definition> objectType) {
        this.printGlobalReferencesPackageComment(out, container, objectType);
        out.printPackageSpecification(this.getStrategy().getGlobalReferencesJavaPackageName(container, objectType));
        out.println();
        out.printImports();
        out.println();
    }

    protected void printPackageComment(JavaWriter out, Definition definition, GeneratorStrategy.Mode mode) {
        String header = this.getStrategy().getFileHeader(definition, mode);
        if (!StringUtils.isBlank((String)header)) {
            out.println("/*");
            out.println(JavaWriter.escapeJavadoc(header));
            out.println(" */");
        }
    }

    protected void printGlobalReferencesPackageComment(JavaWriter out, Definition container, Class<? extends Definition> objectType) {
        String header = this.getStrategy().getGlobalReferencesFileHeader(container, objectType);
        if (!StringUtils.isBlank((String)header)) {
            out.println("/*");
            out.println(JavaWriter.escapeJavadoc(header));
            out.println(" */");
        }
    }

    private final <T> void forEach(Collection<T> list, BiConsumer<? super T, ? super String> definitionAndSeparator) {
        this.forEach(list, "", ",", definitionAndSeparator);
    }

    private final <T> void forEach(Collection<T> list, String nonSeparator, String separator, BiConsumer<? super T, ? super String> definitionAndSeparator) {
        int size = list.size();
        int i = 0;
        for (T d : list) {
            definitionAndSeparator.accept(d, i++ < size - 1 ? separator : nonSeparator);
        }
    }

    protected String refExtendsNumberType(JavaWriter out, DataTypeDefinition type) {
        if (type.isGenericNumberType()) {
            return (this.scala ? "_ <: " : (this.kotlin ? "out " : "? extends ")) + out.ref(Number.class);
        }
        return out.ref(this.getJavaType(type, out));
    }

    protected String refNumberType(JavaWriter out, DataTypeDefinition type) {
        if (type.isGenericNumberType()) {
            return out.ref(Number.class);
        }
        return out.ref(this.getJavaType(type, out));
    }

    protected String getJavaTypeReference(Database db, DataTypeDefinition type, JavaWriter out) {
        if (this.database.isArrayType(type.getType())) {
            Name baseType = GenerationUtil.getArrayBaseType(db.getDialect(), type.getType(), type.getQualifiedUserType());
            return this.getTypeReference(db, type.getSchema(), out, baseType.last(), type.getPrecision(), type.getScale(), type.getLength(), true, false, false, null, null, null, baseType) + ".getArrayDataType()";
        }
        return this.getTypeReference(db, type.getSchema(), out, type.getType(), type.getPrecision(), type.getScale(), type.getLength(), type.isNullable(), type.isIdentity(), type.isReadonly(), type.getGeneratedAlwaysAs(), type.getGenerationOption(), type.getDefaultValue(), type.getQualifiedUserType());
    }

    protected JavaTypeResolver resolver(JavaWriter out) {
        return new Resolver(out, null);
    }

    protected JavaTypeResolver resolver(JavaWriter out, GeneratorStrategy.Mode mode) {
        return new Resolver(out, mode);
    }

    protected boolean isArrayType(String javaType) {
        if (this.scala) {
            return javaType.startsWith("scala.Array");
        }
        if (this.kotlin) {
            return javaType.startsWith("kotlin.Array") || javaType.equals("kotlin.ByteArray");
        }
        return javaType.endsWith("[]");
    }

    protected String getArrayBaseType(String javaType) {
        return javaType.replace("[]", "").replaceAll("^scala.Array\\[(.*?)\\]$", "$1").replaceAll("^kotlin.Array<(.*?)\\??>$", "$1");
    }

    protected String getJavaType(DataTypeDefinition type, JavaWriter out) {
        return this.getJavaType(type, out, GeneratorStrategy.Mode.RECORD);
    }

    protected String getJavaType(DataTypeDefinition type, JavaWriter out, GeneratorStrategy.Mode udtMode) {
        return this.getType(type.getDatabase(), type.getSchema(), out, type.getType(), type.getPrecision(), type.getScale(), type.getQualifiedUserType(), type.getJavaType(), Object.class.getName(), udtMode);
    }

    @Deprecated
    protected String getType(Database db, SchemaDefinition schema, JavaWriter out, String t, int p, int s, String u, String javaType, String defaultType) {
        return this.getType(db, schema, out, t, p, s, DSL.name((String)u), javaType, defaultType);
    }

    protected String getType(Database db, SchemaDefinition schema, JavaWriter out, String t, int p, int s, Name u, String javaType, String defaultType) {
        return this.getType(db, schema, out, t, p, s, u, javaType, defaultType, GeneratorStrategy.Mode.RECORD);
    }

    @Deprecated
    protected String getType(Database db, SchemaDefinition schema, JavaWriter out, String t, int p, int s, String u, String javaType, String defaultType, GeneratorStrategy.Mode udtMode) {
        return this.getType(db, schema, out, t, p, s, DSL.name((String)u), javaType, defaultType, udtMode);
    }

    protected String getType(Database db, SchemaDefinition schema, JavaWriter out, String t, int p, int s, Name u, String javaType, String defaultType, GeneratorStrategy.Mode udtMode) {
        Object type;
        block21: {
            type = defaultType;
            if (javaType != null) {
                type = javaType;
            } else if (db.isArrayType(t)) {
                Name baseTypeName = GenerationUtil.getArrayBaseType(db.getDialect(), t, u);
                String last = t.equals(baseTypeName.last()) ? "OTHER" : baseTypeName.last();
                String baseType = this.getType(db, schema, out, last, p, s, baseTypeName, javaType, defaultType, udtMode);
                type = this.scala ? "scala.Array[" + baseType + "]" : (this.kotlin ? "kotlin.Array<" + baseType + "?>" : baseType + "[]");
            } else if (db.getArray(schema, u) != null) {
                boolean udtArray = db.getArray(schema, u).getElementType(this.resolver(out)).isUDT();
                type = udtMode == GeneratorStrategy.Mode.POJO || udtMode == GeneratorStrategy.Mode.INTERFACE && !udtArray ? (this.scala ? "java.util.List[" + this.getJavaType(db.getArray(schema, u).getElementType(this.resolver(out, udtMode)), out, udtMode) + "]" : "java.util.List<" + this.getJavaType(db.getArray(schema, u).getElementType(this.resolver(out, udtMode)), out, udtMode) + ">") : (udtMode == GeneratorStrategy.Mode.INTERFACE ? (this.scala ? "java.util.List[_ <:" + this.getJavaType(db.getArray(schema, u).getElementType(this.resolver(out, udtMode)), out, udtMode) + "]" : "java.util.List<? extends " + this.getJavaType(db.getArray(schema, u).getElementType(this.resolver(out, udtMode)), out, udtMode) + ">") : this.getStrategy().getFullJavaClassName((Definition)db.getArray(schema, u), GeneratorStrategy.Mode.RECORD));
            } else if (db.getDomain(schema, u) != null) {
                type = this.getJavaType(db.getDomain(schema, u).getDefinedType(), out);
            } else if (db.getEnum(schema, u) != null) {
                type = this.getStrategy().getFullJavaClassName((Definition)db.getEnum(schema, u), GeneratorStrategy.Mode.ENUM);
            } else if (db.getUDT(schema, u) != null) {
                type = this.getStrategy().getFullJavaClassName((Definition)db.getUDT(schema, u), udtMode);
            } else if (SUPPORT_TABLE_AS_UDT.contains(db.getDialect()) && db.getTable(schema, u) != null) {
                type = this.getStrategy().getFullJavaClassName((Definition)db.getTable(schema, u), udtMode);
            } else if (u != null && db.getConfiguredCustomType(u.last()) != null) {
                type = u.last();
            } else {
                try {
                    Class clazz = this.mapJavaTimeTypes(AbstractTypedElementDefinition.getDataType((Database)db, (String)t, (int)p, (int)s)).getType();
                    type = this.scala && clazz == byte[].class ? "scala.Array[scala.Byte]" : (this.kotlin && clazz == byte[].class ? "kotlin.ByteArray" : clazz.getCanonicalName());
                    if (clazz.getTypeParameters().length > 0) {
                        type = (String)type + (this.scala ? "[" : "<");
                        String separator = "";
                        for (TypeVariable var : clazz.getTypeParameters()) {
                            type = (String)type + separator;
                            type = (String)type + ((Class)var.getBounds()[0]).getCanonicalName();
                            separator = ", ";
                        }
                        type = (String)type + (this.scala ? "]" : ">");
                    }
                }
                catch (SQLDialectNotSupportedException e) {
                    if (defaultType != null) break block21;
                    throw e;
                }
            }
        }
        if (this.kotlin && Object.class.getName().equals(type)) {
            type = "Any";
        }
        return type;
    }

    protected String getTypeReference(Database db, SchemaDefinition schema, JavaWriter out, String t, int p, int s, int l, boolean n, boolean i, boolean r, String g, QOM.GenerationOption go, String d, Name u) {
        StringBuilder sb = new StringBuilder();
        if (db.getArray(schema, u) != null) {
            ArrayDefinition array = this.database.getArray(schema, u);
            sb.append(this.getJavaTypeReference(db, array.getElementType(this.resolver(out)), out));
            sb.append(array.getIndexType() != null ? ".asAssociativeArrayDataType(" : ".asArrayDataType(");
            sb.append(this.classOf(this.getStrategy().getFullJavaClassName((Definition)array, GeneratorStrategy.Mode.RECORD)));
            sb.append(")");
        } else if (db.getDomain(schema, u) != null) {
            sb.append(this.getStrategy().getFullJavaIdentifier((Definition)db.getDomain(schema, u)));
            sb.append(".getDataType()");
        } else if (db.getUDT(schema, u) != null) {
            sb.append(this.getStrategy().getFullJavaIdentifier((Definition)db.getUDT(schema, u)));
            sb.append(".getDataType()");
        } else if (SUPPORT_TABLE_AS_UDT.contains(db.getDialect()) && db.getTable(schema, u) != null) {
            sb.append(this.getStrategy().getFullJavaIdentifier((Definition)db.getTable(schema, u)));
            sb.append(".getDataType()");
        } else if (db.getEnum(schema, u) != null) {
            sb.append(this.getJavaTypeReference(db, (DataTypeDefinition)new DefaultDataTypeDefinition(db, schema, DefaultDataType.getDataType((SQLDialect)db.getDialect(), String.class).getTypeName(), (Number)l, (Number)p, (Number)s, Boolean.valueOf(n), d, (Name)null), out));
            sb.append(".asEnumDataType(");
            sb.append(this.classOf(this.getStrategy().getFullJavaClassName((Definition)db.getEnum(schema, u), GeneratorStrategy.Mode.ENUM)));
            sb.append(")");
        } else {
            String sqlDataTypeRef;
            DataType dataType;
            try {
                dataType = this.mapJavaTimeTypes(AbstractTypedElementDefinition.getDataType((Database)db, (String)t, (int)p, (int)s));
            }
            catch (SQLDialectNotSupportedException ignore) {
                dataType = SQLDataType.OTHER.nullable(n).identity(i);
                sb = new StringBuilder();
                sb.append(DefaultDataType.class.getName());
                sb.append(".getDefaultDataType(\"");
                sb.append(this.escapeString(u != null ? u.toString() : t));
                sb.append("\")");
            }
            dataType = dataType.nullable(n).identity(i);
            if (d != null) {
                dataType = dataType.defaultValue(DSL.field((String)d, (DataType)dataType));
            }
            if (dataType.getSQLDataType() != null && sb.length() == 0) {
                DataType sqlDataType = dataType.getSQLDataType();
                String literal = SQLDATATYPE_LITERAL_LOOKUP.get(sqlDataType);
                sqlDataTypeRef = out.ref(SQLDataType.class) + "." + literal;
                sb.append(sqlDataTypeRef);
                if (dataType.hasPrecision() && (dataType.isTimestamp() || p > 0)) {
                    if (SQLDATATYPE_WITH_PRECISION.contains(literal)) {
                        sb.append('(').append(p);
                    } else {
                        sb.append(".precision(").append(p);
                    }
                    if (dataType.hasScale() && s > 0) {
                        sb.append(", ").append(s);
                    }
                    sb.append(')');
                }
                if (dataType.hasLength() && l > 0) {
                    if (SQLDATATYPE_WITH_LENGTH.contains(literal)) {
                        sb.append("(").append(l).append(")");
                    } else {
                        sb.append(".length(").append(l).append(")");
                    }
                }
            } else {
                sqlDataTypeRef = SQLDataType.class.getCanonicalName() + ".OTHER";
                if (sb.length() == 0) {
                    sb.append(sqlDataTypeRef);
                }
            }
            if (!dataType.nullable()) {
                sb.append(".nullable(false)");
            }
            if (dataType.identity()) {
                sb.append(".identity(true)");
            }
            if (dataType.defaulted()) {
                sb.append(".defaultValue(");
                if (Arrays.asList(SQLDialect.MYSQL).contains(db.getDialect().family())) {
                    if (d != null && d.toLowerCase(this.getStrategy().getTargetLocale()).startsWith("current_timestamp")) {
                        sb.append(out.ref(DSL.class)).append(".field(\"").append(this.escapeString(d)).append("\"");
                    } else {
                        sb.append(out.ref(DSL.class)).append(".inline(\"").append(this.escapeString(d)).append("\"");
                    }
                } else {
                    sb.append(out.ref(DSL.class)).append(".field(\"").append(this.escapeString(d)).append("\"");
                }
                sb.append(", ").append(sqlDataTypeRef).append(")").append(this.kotlin && dataType.getType() == Object.class ? " as Any?" : "").append(")");
            }
        }
        return sb.toString();
    }

    private String kotlinNullability(TypedElementDefinition<?> typed) {
        return typed.getType().isNullable() ? "?" : "";
    }

    private DataType<?> mapJavaTimeTypes(DataType<?> dataType) {
        DataType result = dataType;
        if (dataType.isDateTime() && this.generateJavaTimeTypes) {
            if (dataType.getType() == Date.class) {
                result = SQLDataType.LOCALDATE;
            } else if (dataType.getType() == Time.class) {
                result = SQLDataType.LOCALTIME;
            } else if (dataType.getType() == Timestamp.class) {
                result = SQLDataType.LOCALDATETIME;
            }
        }
        return result;
    }

    @SafeVarargs
    private static final <T> List<T> list(T ... objects) {
        ArrayList<T> result = new ArrayList<T>();
        if (objects != null) {
            for (T object : objects) {
                if (object == null || "".equals(object)) continue;
                result.add(object);
            }
        }
        return result;
    }

    private static final <T> List<T> list(T first, List<T> remaining) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(JavaGenerator.list(first));
        result.addAll(remaining);
        return result;
    }

    private static final <T> List<T> first(Collection<T> objects) {
        ArrayList<T> result;
        block0: {
            Iterator<T> iterator;
            result = new ArrayList<T>();
            if (objects == null || !(iterator = objects.iterator()).hasNext()) break block0;
            T object = iterator.next();
            result.add(object);
        }
        return result;
    }

    private static final <T> List<T> remaining(Collection<T> objects) {
        ArrayList<T> result = new ArrayList<T>();
        if (objects != null) {
            result.addAll(objects);
            if (result.size() > 0) {
                result.remove(0);
            }
        }
        return result;
    }

    private String classOf(String string) {
        if (this.scala) {
            return "classOf[" + string + "]";
        }
        if (this.kotlin) {
            return string + "::class.java";
        }
        return string + ".class";
    }

    private String varargsIfArray(String type) {
        if (!this.generateVarargsSetters()) {
            return type;
        }
        if (this.scala) {
            return type;
        }
        return SQUARE_BRACKETS.matcher(type).replaceFirst("...");
    }

    protected JavaWriter newJavaWriter(File file) {
        file = this.fixSuffix(file);
        JavaWriter result = new JavaWriter(file, this.generateFullyQualifiedTypes(), this.targetEncoding, this.generateJavadoc(), this.fileCache, this.generatedSerialVersionUID());
        if (this.generateIndentation != null) {
            result.tabString(this.generateIndentation);
        }
        if (this.generateNewline != null) {
            result.newlineString(this.generateNewline);
        }
        result.printMarginForBlockComment(this.generatePrintMarginForBlockComment);
        return result;
    }

    protected File getFile(Definition definition) {
        return this.fixSuffix(this.getStrategy().getFile(definition));
    }

    protected File getFile(Definition definition, GeneratorStrategy.Mode mode) {
        return this.fixSuffix(this.getStrategy().getFile(definition, mode));
    }

    private File fixSuffix(File file) {
        if (this.scala) {
            file = new File(file.getParentFile(), file.getName().replace(".java", ".scala"));
        } else if (this.kotlin) {
            file = new File(file.getParentFile(), file.getName().replace(".java", ".kt"));
        }
        return file;
    }

    private String scalaWhitespaceSuffix(String string) {
        return string == null ? null : (P_SCALA_WHITESPACE_SUFFIX.matcher(string).matches() ? string + " " : string);
    }

    protected void closeJavaWriter(JavaWriter out) {
        GeneratorWriter.CloseResult result = out.close();
        if (result.affected) {
            this.affectedFiles.add(out.file());
        }
        if (result.modified) {
            this.modifiedFiles.add(out.file());
        }
    }

    static {
        PRIMITIVE_WRAPPERS = new HashSet<String>(Arrays.asList(Byte.class.getName(), Short.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName(), Boolean.class.getName(), Character.class.getName(), "kotlin.Byte", "kotlin.Short", "kotlin.Int", "kotlin.Long", "kotlin.Float", "kotlin.Double", "kotlin.Boolean", "kotlin.Char"));
        SQLDATATYPE_LITERAL_LOOKUP = new IdentityHashMap();
        SQLDATATYPE_WITH_LENGTH = new HashSet<String>();
        SQLDATATYPE_WITH_PRECISION = new HashSet<String>();
        try {
            for (java.lang.reflect.Field field : SQLDataType.class.getFields()) {
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                SQLDATATYPE_LITERAL_LOOKUP.put((DataType)field.get(SQLDataType.class), field.getName());
            }
            for (AccessibleObject accessibleObject : SQLDataType.class.getMethods()) {
                if (!Modifier.isPublic(((Method)accessibleObject).getModifiers()) || !Modifier.isStatic(((Method)accessibleObject).getModifiers()) || !((DataType)SQLDataType.class.getField(((Method)accessibleObject).getName()).get(SQLDataType.class)).hasPrecision()) continue;
                SQLDATATYPE_WITH_PRECISION.add(((Method)accessibleObject).getName());
            }
            for (AccessibleObject accessibleObject : SQLDataType.class.getMethods()) {
                if (!Modifier.isPublic(((Method)accessibleObject).getModifiers()) || !Modifier.isStatic(((Method)accessibleObject).getModifiers()) || !((DataType)SQLDataType.class.getField(((Method)accessibleObject).getName()).get(SQLDataType.class)).hasLength() || SQLDATATYPE_WITH_PRECISION.contains(((Method)accessibleObject).getName())) continue;
                SQLDATATYPE_WITH_LENGTH.add(((Method)accessibleObject).getName());
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        EMBEDDABLES_OR_COLUMNS = (result, duplicates, index, embeddable) -> {
            if (duplicates.add(embeddable)) {
                result.set(index, embeddable);
            } else {
                result.remove(index);
            }
        };
        EMBEDDABLES_AND_COLUMNS = (result, duplicates, index, embeddable) -> {
            if (duplicates.add(embeddable)) {
                result.add(index, embeddable);
            }
        };
        P_IS = Pattern.compile("^is[A-Z].*$");
        SQUARE_BRACKETS = Pattern.compile("\\[\\]$");
        P_SCALA_WHITESPACE_SUFFIX = Pattern.compile("^.*[^a-zA-Z0-9]$");
    }

    private class Resolver
    implements JavaTypeResolver {
        private final JavaWriter out;
        private final GeneratorStrategy.Mode mode;

        Resolver(JavaWriter out, GeneratorStrategy.Mode mode) {
            this.out = out;
            this.mode = mode;
        }

        public String resolve(DataTypeDefinition type) {
            return this.mode == null ? JavaGenerator.this.getJavaType(type, this.out) : JavaGenerator.this.getJavaType(type, this.out, this.mode);
        }

        public String classLiteral(String type) {
            String rawtype = type.replaceAll("<.*>", "").replaceAll("\\[.*\\]", "");
            boolean generic = !rawtype.equals(type);
            switch (JavaGenerator.this.language) {
                case SCALA: {
                    return "classOf[" + this.out.ref(type) + "]";
                }
                case KOTLIN: {
                    return this.out.ref(rawtype) + "::class.java" + (String)(generic ? " as " + this.out.ref(Class.class) + "<" + this.out.ref(type) + ">" : "");
                }
            }
            return (String)(generic ? "(" + this.out.ref(Class.class) + "<" + this.out.ref(type) + ">) (" + this.out.ref(Class.class) + ") " : "") + this.out.ref(rawtype) + ".class";
        }

        public String constructorCall(String type) {
            String rawtype = type.replaceAll("<.*>", "").replaceAll("\\[.*\\]", "");
            String typeParams = type.replace(rawtype, "");
            switch (JavaGenerator.this.language) {
                case SCALA: {
                    return "new " + this.out.ref(rawtype) + typeParams.replace("<", "[").replace(">", "]");
                }
                case KOTLIN: {
                    return this.out.ref(rawtype) + typeParams;
                }
            }
            return "new " + this.out.ref(rawtype) + typeParams;
        }

        public String ref(String type) {
            return this.out.ref(type);
        }

        public String ref(Class<?> type) {
            return this.out.ref(type);
        }
    }

    @FunctionalInterface
    private static interface EmbeddableFilter {
        public void accept(List<Definition> var1, Set<EmbeddableDefinition> var2, int var3, EmbeddableDefinition var4);
    }

    private class AvoidAmbiguousClassesFilter
    implements Database.Filter {
        private Map<String, String> included = new HashMap<String, String>();

        private AvoidAmbiguousClassesFilter() {
        }

        public boolean exclude(Definition definition) {
            if (definition instanceof ColumnDefinition || definition instanceof AttributeDefinition || definition instanceof ParameterDefinition) {
                return false;
            }
            String name = JavaGenerator.this.getStrategy().getFullJavaClassName(definition);
            String nameLC = name.toLowerCase(JavaGenerator.this.getStrategy().getTargetLocale());
            String existing = this.included.put(nameLC, name);
            if (existing == null) {
                return false;
            }
            log.warn((Object)"Ambiguous type name", (Object)("The object " + definition.getQualifiedOutputName() + " generates a type " + name + " which conflicts with the existing type " + existing + " on some operating systems. Use a custom generator strategy to disambiguate the types."));
            return true;
        }
    }
}

