/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.codegen.Files;
import org.jooq.codegen.GeneratorException;
import org.jooq.tools.StringUtils;

public abstract class GeneratorWriter<W extends GeneratorWriter<W>> {
    private static final Pattern PATTERN_LIST = Pattern.compile("\\[(?:\\[before=([^\\]]+)\\])?(?:\\[separator=([^\\]]+)\\])?(?:\\[after=([^\\]]+)\\])?(?:\\[(.*)\\])\\]", 32);
    private final Files files;
    private final File file;
    private final String encoding;
    private final StringBuilder sb;
    private int indentTabsThisLine;
    private int indentTabsAllLines;
    private String tabString = "    ";
    private String newlineString = "\n";
    private boolean newline = true;

    protected GeneratorWriter(File file) {
        this(file, null, null);
    }

    protected GeneratorWriter(File file, String encoding) {
        this(file, encoding, null);
    }

    protected GeneratorWriter(File file, Files files) {
        this(file, null, files);
    }

    protected GeneratorWriter(File file, String encoding, Files files) {
        this.files = files == null ? new Files() : files;
        this.file = file;
        this.encoding = encoding;
        this.sb = new StringBuilder();
        this.files.mkdirs(file.getParentFile());
    }

    public String tabString() {
        return this.tabString;
    }

    public void tabString(String string) {
        this.tabString = string.replace("\\t", "\t").replace("\\s", " ");
    }

    public String newlineString() {
        return this.newlineString;
    }

    public void newlineString(String string) {
        this.newlineString = string.replace("\\n", "\n").replace("\\r", "\r");
    }

    public File file() {
        return this.file;
    }

    public W print(char value) {
        this.print("" + value);
        return (W)this;
    }

    public W print(int value) {
        this.print("" + value);
        return (W)this;
    }

    public W print(String string) {
        this.print(string, new Object[0]);
        return (W)this;
    }

    /*
     * WARNING - void declaration
     */
    public W print(String string, Object ... args) {
        if ((string = string.replace("\n", this.newlineString).replace("\t", this.tabString)).startsWith("}") || string.startsWith("]") || string.startsWith(")")) {
            --this.indentTabsAllLines;
        }
        if (this.indentTabsAllLines < 0 && !Boolean.getBoolean("mute-indentation-error")) {
            new IllegalStateException("A formatting error has been produced by https://github.com/jOOQ/jOOQ/issues/10196").printStackTrace(System.err);
        }
        int indentTabsThisLine0 = this.indentTabsThisLine;
        if (this.newline && this.indentTabsThisLine + this.indentTabsAllLines > 0) {
            for (int i = 0; i < this.indentTabsThisLine + this.indentTabsAllLines; ++i) {
                this.sb.append(this.tabString);
            }
            this.newline = false;
            this.indentTabsThisLine = 0;
        }
        if (string.endsWith("{") || string.endsWith("[") || string.endsWith("(")) {
            ++this.indentTabsAllLines;
        } else if (string.startsWith("if") || string.startsWith("else") || string.startsWith("for") || string.startsWith("while")) {
            this.indentTabsThisLine = indentTabsThisLine0 + 1;
        }
        if (args.length > 0) {
            List<Object> originals = Arrays.asList(args);
            ArrayList<Object> translated = new ArrayList<Object>();
            while (true) {
                for (Object object : originals) {
                    if (object instanceof Class) {
                        translated.add(this.ref((Class)object));
                        continue;
                    }
                    if (object instanceof Object[] || object instanceof Collection) {
                        void var7_8;
                        if (object instanceof Collection) {
                            Object[] objectArray = ((Collection)object).toArray();
                        }
                        int start = string.indexOf("[[");
                        int end = string.indexOf("]]");
                        String expression = string.substring(start, end + 2);
                        StringBuilder replacement = new StringBuilder();
                        Matcher m = PATTERN_LIST.matcher(expression);
                        m.find();
                        String gBefore = StringUtils.defaultString((String)m.group(1));
                        String gSeparator = StringUtils.defaultString((String)m.group(2), (String)", ");
                        String gAfter = StringUtils.defaultString((String)m.group(3));
                        String gContent = m.group(4);
                        String separator = gBefore;
                        for (Object o : (Object[])var7_8) {
                            translated.add(o);
                            replacement.append(separator);
                            replacement.append(gContent);
                            separator = gSeparator;
                        }
                        if (((Object[])var7_8).length > 0) {
                            replacement.append(gAfter);
                        }
                        string = string.substring(0, start) + replacement + string.substring(end + 2);
                        continue;
                    }
                    translated.add(object);
                }
                if (!string.contains("[[")) break;
                originals = translated;
                translated = new ArrayList();
            }
            this.sb.append(String.format(string, translated.toArray()));
        } else {
            this.sb.append(string);
        }
        return (W)this;
    }

    public W printlnIf(boolean condition) {
        if (condition) {
            this.println();
        }
        return (W)this;
    }

    public W println() {
        if (this.sb.length() > 0) {
            this.sb.append(this.newlineString);
            this.newline = true;
        }
        return (W)this;
    }

    public W println(int value) {
        this.print(value);
        this.println();
        return (W)this;
    }

    public W println(String string) {
        this.print(string);
        this.println();
        return (W)this;
    }

    public W println(String string, Object ... args) {
        this.print(string, args);
        this.println();
        return (W)this;
    }

    public W indent(int tabs) {
        this.indentTabsAllLines = tabs;
        return (W)this;
    }

    public int indent() {
        return this.indentTabsAllLines;
    }

    public W tab(int tabs) {
        this.indentTabsThisLine = tabs;
        return (W)this;
    }

    public int tab() {
        return this.indentTabsThisLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseResult close() {
        String newContent = this.beforeClose(this.sb.toString());
        if (StringUtils.isBlank((String)newContent)) {
            return new CloseResult(false, false);
        }
        try {
            String oldContent = null;
            if (this.file.exists() && this.file.length() == (long)newContent.getBytes(this.encoding()).length) {
                try (RandomAccessFile old = null;){
                    old = new RandomAccessFile(this.file, "r");
                    byte[] oldBytes = new byte[(int)old.length()];
                    old.readFully(oldBytes);
                    oldContent = new String(oldBytes, this.encoding());
                }
            }
            if (oldContent == null || !oldContent.equals(newContent)) {
                if (oldContent != null) {
                    this.file.delete();
                }
                PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), this.encoding()));
                writer.append(newContent);
                writer.flush();
                writer.close();
                return new CloseResult(true, true);
            }
            return new CloseResult(true, false);
        }
        catch (IOException e) {
            throw new GeneratorException("Error writing " + this.file.getAbsolutePath(), e);
        }
    }

    protected String encoding() {
        return this.encoding != null ? this.encoding : "UTF-8";
    }

    protected String beforeClose(String string) {
        if (this.indentTabsAllLines > 0 && !Boolean.getBoolean("mute-indentation-error")) {
            new IllegalStateException("A formatting error has been produced by https://github.com/jOOQ/jOOQ/issues/10196").printStackTrace(System.err);
        }
        return string;
    }

    public String ref(Class<?> clazz) {
        return clazz == null ? null : this.ref(clazz.getName());
    }

    public String ref(String clazzOrId) {
        return clazzOrId == null ? null : this.ref(Arrays.asList(clazzOrId), 1).get(0);
    }

    public String[] ref(String[] clazzOrId) {
        return clazzOrId == null ? new String[]{} : this.ref(Arrays.asList(clazzOrId), 1).toArray(new String[clazzOrId.length]);
    }

    public List<String> ref(List<String> clazzOrId) {
        return clazzOrId == null ? Collections.emptyList() : this.ref(clazzOrId, 1);
    }

    protected String ref(String clazzOrId, int keepSegments) {
        return clazzOrId == null ? null : this.ref(Arrays.asList(clazzOrId), keepSegments).get(0);
    }

    protected String[] ref(String[] clazzOrId, int keepSegments) {
        return clazzOrId == null ? new String[]{} : this.ref(Arrays.asList(clazzOrId), keepSegments).toArray(new String[clazzOrId.length]);
    }

    protected List<String> ref(List<String> clazzOrId, int keepSegments) {
        return clazzOrId == null ? Collections.emptyList() : clazzOrId;
    }

    public String toString() {
        return "GenerationWriter [" + this.file + "]";
    }

    public static class CloseResult {
        public final boolean affected;
        public final boolean modified;

        CloseResult(boolean affected, boolean modified) {
            this.affected = affected;
            this.modified = modified;
        }
    }
}

