/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jooq.codegen.GeneratorStrategy;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.IdentityDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TypedElementDefinition;
import org.jooq.meta.UniqueKeyDefinition;

public abstract class AbstractGeneratorStrategy
implements GeneratorStrategy {
    @Override
    public final String getFileName(Definition definition) {
        return this.getFileName(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public final String getFileName(Definition definition, GeneratorStrategy.Mode mode) {
        return this.getJavaClassName(definition, mode) + ".java";
    }

    @Override
    public final File getFileRoot() {
        String dir = this.getTargetDirectory();
        String pkg = this.getTargetPackage().replaceAll("\\.", "/");
        return new File(dir + "/" + pkg);
    }

    @Override
    public final File getFile(Definition definition) {
        return this.getFile(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public final File getFile(Definition definition, GeneratorStrategy.Mode mode) {
        String dir = this.getTargetDirectory();
        String pkg = this.getJavaPackageName(definition, mode).replaceAll("\\.", "/");
        return new File(dir + "/" + pkg, this.getFileName(definition, mode));
    }

    @Override
    public final File getFile(String fileName) {
        String dir = this.getTargetDirectory();
        String pkg = this.getTargetPackage().replaceAll("\\.", "/");
        return new File(dir + "/" + pkg, fileName);
    }

    @Override
    public final String getFileHeader(Definition definition) {
        return this.getFileHeader(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public final String getFullJavaIdentifier(Definition definition) {
        StringBuilder sb = new StringBuilder();
        if (definition instanceof ColumnDefinition) {
            TypedElementDefinition e = (TypedElementDefinition)definition;
            if (this.getInstanceFields()) {
                sb.append(this.getFullJavaIdentifier(e.getContainer()));
            } else {
                sb.append(this.getFullJavaClassName(e.getContainer()));
            }
        } else if (definition instanceof SequenceDefinition) {
            sb.append(this.getJavaPackageName((Definition)definition.getSchema()));
            sb.append(".Sequences");
        } else if (definition instanceof TypedElementDefinition) {
            TypedElementDefinition e = (TypedElementDefinition)definition;
            sb.append(this.getFullJavaClassName(e.getContainer()));
        } else if (definition instanceof IndexDefinition) {
            sb.append(this.getJavaPackageName((Definition)definition.getSchema()));
            sb.append(".Indexes");
        } else if (definition instanceof IdentityDefinition) {
            sb.append(this.getJavaPackageName((Definition)definition.getSchema()));
            sb.append(".Keys");
        } else if (definition instanceof UniqueKeyDefinition) {
            sb.append(this.getJavaPackageName((Definition)definition.getSchema()));
            sb.append(".Keys");
        } else if (definition instanceof ForeignKeyDefinition) {
            sb.append(this.getJavaPackageName((Definition)definition.getSchema()));
            sb.append(".Keys");
        } else {
            sb.append(this.getFullJavaClassName(definition));
        }
        sb.append(".");
        sb.append(this.getJavaIdentifier(definition));
        return sb.toString();
    }

    @Override
    public final String getJavaSetterName(Definition definition) {
        return this.getJavaSetterName(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public final String getJavaGetterName(Definition definition) {
        return this.getJavaGetterName(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public final String getJavaMethodName(Definition definition) {
        return this.getJavaMethodName(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public final String getJavaClassExtends(Definition definition) {
        return this.getJavaClassExtends(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public final List<String> getJavaClassImplements(Definition definition) {
        return this.getJavaClassImplements(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public final String getJavaClassName(Definition definition) {
        return this.getJavaClassName(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public final String getJavaPackageName(Definition definition) {
        return this.getJavaPackageName(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public final String getJavaMemberName(Definition definition) {
        return this.getJavaMemberName(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public final String getFullJavaClassName(Definition definition) {
        return this.getFullJavaClassName(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public final String getFullJavaClassName(Definition definition, GeneratorStrategy.Mode mode) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getJavaPackageName(definition, mode));
        sb.append(".");
        sb.append(this.getJavaClassName(definition, mode));
        return sb.toString();
    }

    @Override
    public final List<String> getJavaIdentifiers(Collection<? extends Definition> definitions) {
        List<? extends Definition> nonNull = AbstractGeneratorStrategy.nonNull(definitions);
        ArrayList<String> result = new ArrayList<String>(nonNull.size());
        for (Definition definition : nonNull) {
            result.add(this.getJavaIdentifier(definition));
        }
        return result;
    }

    @Override
    public final List<String> getJavaIdentifiers(Definition ... definitions) {
        return this.getJavaIdentifiers(Arrays.asList(definitions));
    }

    @Override
    public final List<String> getFullJavaIdentifiers(Collection<? extends Definition> definitions) {
        List<? extends Definition> nonNull = AbstractGeneratorStrategy.nonNull(definitions);
        ArrayList<String> result = new ArrayList<String>(nonNull.size());
        for (Definition definition : nonNull) {
            result.add(this.getFullJavaIdentifier(definition));
        }
        return result;
    }

    @Override
    public final List<String> getFullJavaIdentifiers(Definition ... definitions) {
        return this.getFullJavaIdentifiers(Arrays.asList(definitions));
    }

    private static final <T> List<T> nonNull(Collection<? extends T> collection) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : collection) {
            if (t == null) continue;
            result.add(t);
        }
        return result;
    }

    final String getFixedJavaIdentifier(Definition definition) {
        if (definition instanceof IdentityDefinition) {
            return "IDENTITY_" + this.getJavaIdentifier(((IdentityDefinition)definition).getColumn().getContainer());
        }
        if (definition instanceof CatalogDefinition && ((CatalogDefinition)definition).isDefaultCatalog()) {
            return "DEFAULT_CATALOG";
        }
        if (definition instanceof SchemaDefinition && ((SchemaDefinition)definition).isDefaultSchema()) {
            return "DEFAULT_SCHEMA";
        }
        return null;
    }

    final String getFixedJavaClassName(Definition definition) {
        if (definition instanceof CatalogDefinition && ((CatalogDefinition)definition).isDefaultCatalog()) {
            return "DefaultCatalog";
        }
        if (definition instanceof SchemaDefinition && ((SchemaDefinition)definition).isDefaultSchema()) {
            return "DefaultSchema";
        }
        return null;
    }
}

