/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.TypeVariable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.jooq.AggregateFunction;
import org.jooq.Catalog;
import org.jooq.Configuration;
import org.jooq.DataType;
import org.jooq.EnumType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Package;
import org.jooq.Parameter;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UDT;
import org.jooq.UDTField;
import org.jooq.UniqueKey;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractKeys;
import org.jooq.impl.AbstractRoutine;
import org.jooq.impl.CatalogImpl;
import org.jooq.impl.DAOImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.SequenceImpl;
import org.jooq.impl.TableImpl;
import org.jooq.impl.TableRecordImpl;
import org.jooq.impl.UDTImpl;
import org.jooq.impl.UDTRecordImpl;
import org.jooq.impl.UpdatableRecordImpl;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StopWatch;
import org.jooq.tools.StringUtils;
import org.jooq.tools.reflect.Reflect;
import org.jooq.tools.reflect.ReflectException;
import org.jooq.util.AbstractGenerator;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.AttributeDefinition;
import org.jooq.util.CatalogDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.Database;
import org.jooq.util.Definition;
import org.jooq.util.DomainDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.ForeignKeyDefinition;
import org.jooq.util.GenerationUtil;
import org.jooq.util.GeneratorException;
import org.jooq.util.GeneratorStrategy;
import org.jooq.util.GeneratorWriter;
import org.jooq.util.IdentityDefinition;
import org.jooq.util.IndexColumnDefinition;
import org.jooq.util.IndexDefinition;
import org.jooq.util.JavaWriter;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ParameterDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.TypedElementDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.UniqueKeyDefinition;
import org.jooq.util.postgres.PostgresDatabase;

public class JavaGenerator
extends AbstractGenerator {
    private static final JooqLogger log = JooqLogger.getLogger(JavaGenerator.class);
    private static final String NO_FURTHER_INSTANCES_ALLOWED = "No further instances allowed";
    private static final int INITIALISER_SIZE = 500;
    private static final Map<DataType<?>, String> SQLDATATYPE_LITERAL_LOOKUP = new IdentityHashMap();
    private static final Set<String> SQLDATATYPE_WITH_LENGTH = new HashSet<String>();
    private static final Set<String> SQLDATATYPE_WITH_PRECISION = new HashSet<String>();
    private final StopWatch watch = new StopWatch();
    private Database database;
    private String isoDate;
    private Map<SchemaDefinition, String> schemaVersions;
    private Map<CatalogDefinition, String> catalogVersions;
    private Set<File> files = new LinkedHashSet<File>();
    private Set<File> directoriesNotForRemoval = new LinkedHashSet<File>();
    private final boolean scala;
    private final String tokenVoid;
    private static final Pattern SQUARE_BRACKETS;

    public JavaGenerator() {
        this(AbstractGenerator.Language.JAVA);
    }

    JavaGenerator(AbstractGenerator.Language language) {
        super(language);
        this.scala = language == AbstractGenerator.Language.SCALA;
        this.tokenVoid = this.scala ? "Unit" : "void";
    }

    @Override
    public final void generate(Database db) {
        this.isoDate = DatatypeConverter.printDateTime((Calendar)Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        this.schemaVersions = new LinkedHashMap<SchemaDefinition, String>();
        this.catalogVersions = new LinkedHashMap<CatalogDefinition, String>();
        this.database = db;
        this.database.addFilter((Database.Filter)new AvoidAmbiguousClassesFilter());
        this.database.setIncludeRelations(this.generateRelations());
        this.database.setTableValuedFunctions(this.generateTableValuedFunctions());
        this.logDatabaseParameters(db);
        log.info((Object)"");
        log.info((Object)"JavaGenerator parameters");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"  strategy", this.strategy.delegate.getClass());
        log.info((Object)"  deprecated", (Object)this.generateDeprecated());
        log.info((Object)"  generated annotation", (Object)(this.generateGeneratedAnnotation() + (!this.generateGeneratedAnnotation && (this.useSchemaVersionProvider || this.useCatalogVersionProvider) ? " (forced to true because of <schemaVersionProvider/> or <catalogVersionProvider/>)" : "")));
        log.info((Object)"  JPA annotations", (Object)this.generateJPAAnnotations());
        log.info((Object)"  validation annotations", (Object)this.generateValidationAnnotations());
        log.info((Object)"  instance fields", (Object)this.generateInstanceFields());
        log.info((Object)"  sequences", (Object)this.generateSequences());
        log.info((Object)"  udts", (Object)this.generateUDTs());
        log.info((Object)"  routines", (Object)this.generateRoutines());
        log.info((Object)"  tables", (Object)(this.generateTables() + (!this.generateTables && this.generateRecords ? " (forced to true because of <records/>)" : (!this.generateTables && this.generateDaos ? " (forced to true because of <daos/>)" : ""))));
        log.info((Object)"  records", (Object)(this.generateRecords() + (!this.generateRecords && this.generateDaos ? " (forced to true because of <daos/>)" : "")));
        log.info((Object)"  pojos", (Object)(this.generatePojos() + (!this.generatePojos && this.generateDaos ? " (forced to true because of <daos/>)" : (!this.generatePojos && this.generateImmutablePojos ? " (forced to true because of <immutablePojos/>)" : ""))));
        log.info((Object)"  immutable pojos", (Object)this.generateImmutablePojos());
        log.info((Object)"  interfaces", (Object)(this.generateInterfaces() + (!this.generateInterfaces && this.generateImmutableInterfaces ? " (forced to true because of <immutableInterfaces/>)" : "")));
        log.info((Object)"  immutable interfaces", (Object)this.generateInterfaces());
        log.info((Object)"  daos", (Object)this.generateDaos());
        log.info((Object)"  indexes", (Object)this.generateIndexes());
        log.info((Object)"  relations", (Object)(this.generateRelations() + (!this.generateRelations && this.generateTables ? " (forced to true because of <tables/>)" : (!this.generateRelations && this.generateDaos ? " (forced to true because of <daos/>)" : ""))));
        log.info((Object)"  table-valued functions", (Object)this.generateTableValuedFunctions());
        log.info((Object)"  global references", (Object)this.generateGlobalObjectReferences());
        log.info((Object)"----------------------------------------------------------");
        if (!this.generateInstanceFields()) {
            log.warn((Object)"");
            log.warn((Object)"Deprecation warnings");
            log.warn((Object)"----------------------------------------------------------");
            log.warn((Object)"  <generateInstanceFields/> = false is deprecated! Please adapt your configuration.");
        }
        log.info((Object)"");
        this.logGenerationRemarks(db);
        log.info((Object)"");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"Generating catalogs", (Object)("Total: " + this.database.getCatalogs().size()));
        for (CatalogDefinition catalog : this.database.getCatalogs()) {
            try {
                if (this.generateCatalogIfEmpty(catalog)) {
                    this.generate(catalog);
                    continue;
                }
                log.info((Object)"Excluding empty catalog", (Object)catalog);
            }
            catch (Exception e) {
                throw new GeneratorException("Error generating code for catalog " + catalog, e);
            }
        }
        log.info((Object)"Removing excess files");
        this.empty(this.getStrategy().getFileRoot(), this.scala ? ".scala" : ".java", this.files, this.directoriesNotForRemoval);
        this.directoriesNotForRemoval.clear();
        this.files.clear();
    }

    private boolean generateCatalogIfEmpty(CatalogDefinition catalog) {
        if (this.generateEmptyCatalogs()) {
            return true;
        }
        List schemas = catalog.getSchemata();
        if (schemas.isEmpty()) {
            return false;
        }
        for (SchemaDefinition schema : schemas) {
            if (!this.generateSchemaIfEmpty(schema)) continue;
            return true;
        }
        return false;
    }

    private final boolean generateSchemaIfEmpty(SchemaDefinition schema) {
        if (this.generateEmptySchemas()) {
            return true;
        }
        return !this.database.getArrays(schema).isEmpty() || !this.database.getEnums(schema).isEmpty() || !this.database.getPackages(schema).isEmpty() || !this.database.getRoutines(schema).isEmpty() || !this.database.getTables(schema).isEmpty() || !this.database.getUDTs(schema).isEmpty();
    }

    private void generate(CatalogDefinition catalog) {
        String newVersion = catalog.getDatabase().getCatalogVersionProvider().version(catalog);
        if (StringUtils.isBlank((String)newVersion)) {
            log.info((Object)("No schema version is applied for catalog " + catalog.getInputName() + ". Regenerating."));
        } else {
            this.catalogVersions.put(catalog, newVersion);
            String oldVersion = this.readVersion(this.getFile((Definition)catalog), "catalog");
            if (StringUtils.isBlank((String)oldVersion)) {
                log.info((Object)("No previous version available for catalog " + catalog.getInputName() + ". Regenerating."));
            } else if (!oldVersion.equals(newVersion)) {
                log.info((Object)("Existing version " + oldVersion + " is not up to date with " + newVersion + " for catalog " + catalog.getInputName() + ". Regenerating."));
            } else {
                log.info((Object)("Existing version " + oldVersion + " is up to date with " + newVersion + " for catalog " + catalog.getInputName() + ". Ignoring catalog."));
                this.directoriesNotForRemoval.add(this.getFile((Definition)catalog).getParentFile());
                return;
            }
        }
        this.generateCatalog(catalog);
        log.info((Object)"Generating schemata", (Object)("Total: " + catalog.getSchemata().size()));
        for (SchemaDefinition schema : catalog.getSchemata()) {
            try {
                if (this.generateSchemaIfEmpty(schema)) {
                    this.generate(schema);
                    continue;
                }
                log.info((Object)"Excluding empty schema", (Object)schema);
            }
            catch (Exception e) {
                throw new GeneratorException("Error generating code for schema " + schema, e);
            }
        }
    }

    private void generate(SchemaDefinition schema) {
        String newVersion = schema.getDatabase().getSchemaVersionProvider().version(schema);
        if (StringUtils.isBlank((String)newVersion)) {
            log.info((Object)("No schema version is applied for schema " + schema.getInputName() + ". Regenerating."));
        } else {
            this.schemaVersions.put(schema, newVersion);
            String oldVersion = this.readVersion(this.getFile((Definition)schema), "schema");
            if (StringUtils.isBlank((String)oldVersion)) {
                log.info((Object)("No previous version available for schema " + schema.getInputName() + ". Regenerating."));
            } else if (!oldVersion.equals(newVersion)) {
                log.info((Object)("Existing version " + oldVersion + " is not up to date with " + newVersion + " for schema " + schema.getInputName() + ". Regenerating."));
            } else {
                log.info((Object)("Existing version " + oldVersion + " is up to date with " + newVersion + " for schema " + schema.getInputName() + ". Ignoring schema."));
                this.directoriesNotForRemoval.add(this.getFile((Definition)schema).getParentFile());
                return;
            }
        }
        this.generateSchema(schema);
        if (this.generateGlobalSequenceReferences() && this.database.getSequences(schema).size() > 0) {
            this.generateSequences(schema);
        }
        if (this.generateTables() && this.database.getTables(schema).size() > 0) {
            this.generateTables(schema);
        }
        if (this.generatePojos() && this.database.getTables(schema).size() > 0) {
            this.generatePojos(schema);
        }
        if (this.generateDaos() && this.database.getTables(schema).size() > 0) {
            this.generateDaos(schema);
        }
        if (this.generateGlobalTableReferences() && this.database.getTables(schema).size() > 0) {
            this.generateTableReferences(schema);
        }
        if (this.generateRelations() && this.database.getTables(schema).size() > 0) {
            this.generateRelations(schema);
        }
        if (this.generateIndexes() && this.database.getTables(schema).size() > 0) {
            this.generateIndexes(schema);
        }
        if (this.generateRecords() && this.database.getTables(schema).size() > 0) {
            this.generateRecords(schema);
        }
        if (this.generateInterfaces() && this.database.getTables(schema).size() > 0) {
            this.generateInterfaces(schema);
        }
        if (this.generateUDTs() && this.database.getUDTs(schema).size() > 0) {
            this.generateUDTs(schema);
        }
        if (this.generatePojos() && this.database.getUDTs(schema).size() > 0) {
            this.generateUDTPojos(schema);
        }
        if (this.generateUDTs() && this.generateRecords() && this.database.getUDTs(schema).size() > 0) {
            this.generateUDTRecords(schema);
        }
        if (this.generateInterfaces() && this.database.getUDTs(schema).size() > 0) {
            this.generateUDTInterfaces(schema);
        }
        if (this.generateUDTs() && this.generateRoutines() && this.database.getUDTs(schema).size() > 0) {
            this.generateUDTRoutines(schema);
        }
        if (this.generateGlobalUDTReferences() && this.database.getUDTs(schema).size() > 0) {
            this.generateUDTReferences(schema);
        }
        if (this.generateUDTs() && this.database.getArrays(schema).size() > 0) {
            this.generateArrays(schema);
        }
        if (this.generateUDTs() && this.database.getEnums(schema).size() > 0) {
            this.generateEnums(schema);
        }
        if (this.generateUDTs() && this.database.getDomains(schema).size() > 0) {
            this.generateDomains(schema);
        }
        if (this.generateRoutines() && (this.database.getRoutines(schema).size() > 0 || this.hasTableValuedFunctions(schema))) {
            this.generateRoutines(schema);
        }
        this.watch.splitInfo("Generation finished: " + schema.getQualifiedName());
        log.info((Object)"");
    }

    private boolean hasTableValuedFunctions(SchemaDefinition schema) {
        for (TableDefinition table : this.database.getTables(schema)) {
            if (!table.isTableValuedFunction()) continue;
            return true;
        }
        return false;
    }

    protected void generateRelations(SchemaDefinition schema) {
        String keyType;
        int block;
        log.info((Object)"Generating Keys");
        boolean empty = true;
        JavaWriter out = this.newJavaWriter(new File(this.getFile((Definition)schema).getParentFile(), "Keys.java"));
        this.printPackage(out, (Definition)schema);
        this.printClassJavadoc(out, "A class modelling foreign key relationships and constraints of tables of the <code>" + schema.getOutputName() + "</code> schema.");
        this.printClassAnnotations(out, schema);
        if (this.scala) {
            out.println("object Keys {");
        } else {
            out.println("public class Keys {");
        }
        ArrayList<IdentityDefinition> allIdentities = new ArrayList<IdentityDefinition>();
        ArrayList<UniqueKeyDefinition> allUniqueKeys = new ArrayList<UniqueKeyDefinition>();
        ArrayList<ForeignKeyDefinition> allForeignKeys = new ArrayList<ForeignKeyDefinition>();
        ((JavaWriter)out.tab(1)).header("IDENTITY definitions", new Object[0]);
        out.println();
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                IdentityDefinition identity = table.getIdentity();
                if (identity == null) continue;
                empty = false;
                String identityType = out.ref(this.getStrategy().getFullJavaClassName(identity.getColumn().getContainer(), GeneratorStrategy.Mode.RECORD));
                String columnTypeFull = this.getJavaType(identity.getColumn().getType());
                String columnType = out.ref(columnTypeFull);
                String identityId = this.getStrategy().getJavaIdentifier(identity.getColumn().getContainer());
                block = allIdentities.size() / 500;
                this.printDeprecationIfUnknownType(out, columnTypeFull);
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("val IDENTITY_%s = Identities%s.IDENTITY_%s", identityId, block, identityId);
                } else {
                    ((JavaWriter)out.tab(1)).println("public static final %s<%s, %s> IDENTITY_%s = Identities%s.IDENTITY_%s;", Identity.class, identityType, columnType, identityId, block, identityId);
                }
                allIdentities.add(identity);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table " + table), (Throwable)e);
            }
        }
        ((JavaWriter)out.tab(1)).header("UNIQUE and PRIMARY KEY definitions", new Object[0]);
        out.println();
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                List uniqueKeys = table.getUniqueKeys();
                for (UniqueKeyDefinition uniqueKey : uniqueKeys) {
                    empty = false;
                    keyType = out.ref(this.getStrategy().getFullJavaClassName((Definition)uniqueKey.getTable(), GeneratorStrategy.Mode.RECORD));
                    String keyId = this.getStrategy().getJavaIdentifier((Definition)uniqueKey);
                    block = allUniqueKeys.size() / 500;
                    if (this.scala) {
                        ((JavaWriter)out.tab(1)).println("val %s = UniqueKeys%s.%s", keyId, block, keyId);
                    } else {
                        ((JavaWriter)out.tab(1)).println("public static final %s<%s> %s = UniqueKeys%s.%s;", UniqueKey.class, keyType, keyId, block, keyId);
                    }
                    allUniqueKeys.add(uniqueKey);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table " + table), (Throwable)e);
            }
        }
        ((JavaWriter)out.tab(1)).header("FOREIGN KEY definitions", new Object[0]);
        out.println();
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                List foreignKeys = table.getForeignKeys();
                for (ForeignKeyDefinition foreignKey : foreignKeys) {
                    empty = false;
                    keyType = out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getKeyTable(), GeneratorStrategy.Mode.RECORD));
                    String referencedType = out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getReferencedTable(), GeneratorStrategy.Mode.RECORD));
                    String keyId = this.getStrategy().getJavaIdentifier((Definition)foreignKey);
                    int block2 = allForeignKeys.size() / 500;
                    if (this.scala) {
                        ((JavaWriter)out.tab(1)).println("val %s = ForeignKeys%s.%s", keyId, block2, keyId);
                    } else {
                        ((JavaWriter)out.tab(1)).println("public static final %s<%s, %s> %s = ForeignKeys%s.%s;", ForeignKey.class, keyType, referencedType, keyId, block2, keyId);
                    }
                    allForeignKeys.add(foreignKey);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while generating reference " + table), (Throwable)e);
            }
        }
        int identityCounter = 0;
        int uniqueKeyCounter = 0;
        int foreignKeyCounter = 0;
        ((JavaWriter)out.tab(1)).header("[#1459] distribute members to avoid static initialisers > 64kb", new Object[0]);
        for (IdentityDefinition identity : allIdentities) {
            this.printIdentity(out, identityCounter, identity);
            ++identityCounter;
        }
        if (identityCounter > 0) {
            ((JavaWriter)out.tab(1)).println("}");
        }
        for (UniqueKeyDefinition uniqueKey : allUniqueKeys) {
            this.printUniqueKey(out, uniqueKeyCounter, uniqueKey);
            ++uniqueKeyCounter;
        }
        if (uniqueKeyCounter > 0) {
            ((JavaWriter)out.tab(1)).println("}");
        }
        for (ForeignKeyDefinition foreignKey : allForeignKeys) {
            this.printForeignKey(out, foreignKeyCounter, foreignKey);
            ++foreignKeyCounter;
        }
        if (foreignKeyCounter > 0) {
            ((JavaWriter)out.tab(1)).println("}");
        }
        out.println("}");
        if (empty) {
            log.info((Object)"Skipping empty keys");
        } else {
            this.closeJavaWriter(out);
            this.watch.splitInfo("Keys generated");
        }
    }

    protected void generateIndexes(SchemaDefinition schema) {
        log.info((Object)"Generating Indexes");
        if (this.database.getIndexes(schema).isEmpty()) {
            log.info((Object)"Skipping empty indexes");
            return;
        }
        JavaWriter out = this.newJavaWriter(new File(this.getFile((Definition)schema).getParentFile(), "Indexes.java"));
        this.printPackage(out, (Definition)schema);
        this.printClassJavadoc(out, "A class modelling indexes of tables of the <code>" + schema.getOutputName() + "</code> schema.");
        this.printClassAnnotations(out, schema);
        if (this.scala) {
            out.println("object Indexes {");
        } else {
            out.println("public class Indexes {");
        }
        ArrayList<IndexDefinition> allIndexes = new ArrayList<IndexDefinition>();
        ((JavaWriter)out.tab(1)).header("INDEX definitions", new Object[0]);
        out.println();
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                List indexes = table.getIndexes();
                for (IndexDefinition index : indexes) {
                    String keyId = this.getStrategy().getJavaIdentifier((Definition)index);
                    int block = allIndexes.size() / 500;
                    if (this.scala) {
                        ((JavaWriter)out.tab(1)).println("val %s = Indexes%s.%s", keyId, block, keyId);
                    } else {
                        ((JavaWriter)out.tab(1)).println("public static final %s %s = Indexes%s.%s;", Index.class, keyId, block, keyId);
                    }
                    allIndexes.add(index);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table " + table), (Throwable)e);
            }
        }
        int indexCounter = 0;
        ((JavaWriter)out.tab(1)).header("[#1459] distribute members to avoid static initialisers > 64kb", new Object[0]);
        for (IndexDefinition index : allIndexes) {
            this.printIndex(out, indexCounter, index);
            ++indexCounter;
        }
        if (indexCounter > 0) {
            ((JavaWriter)out.tab(1)).println("}");
        }
        out.println("}");
        this.closeJavaWriter(out);
        this.watch.splitInfo("Indexes generated");
    }

    protected void printIndex(JavaWriter out, int indexCounter, IndexDefinition index) {
        int block = indexCounter / 500;
        if (indexCounter % 500 == 0) {
            if (indexCounter > 0) {
                ((JavaWriter)out.tab(1)).println("}");
            }
            out.println();
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("private object Indexes%s extends %s {", block, AbstractKeys.class);
            } else {
                ((JavaWriter)out.tab(1)).println("private static class Indexes%s extends %s {", block, AbstractKeys.class);
            }
        }
        String sortFieldSeparator = "";
        StringBuilder orderFields = new StringBuilder();
        for (IndexColumnDefinition column : index.getIndexColumns()) {
            orderFields.append(sortFieldSeparator);
            orderFields.append(out.ref(this.getStrategy().getFullJavaIdentifier((Definition)column.getColumn()), this.colRefSegments(null)));
            orderFields.append(column.getSortOrder() == SortOrder.DESC ? ".desc()" : "");
            sortFieldSeparator = ", ";
        }
        if (this.scala) {
            ((JavaWriter)out.tab(2)).println("val %s : %s = %s.createIndex(\"%s\", %s, Array[%s [_] ](%s), %s)", this.getStrategy().getJavaIdentifier((Definition)index), Index.class, AbstractKeys.class, this.escapeString(index.getOutputName()), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)index.getTable()), 2), OrderField.class, orderFields, index.isUnique());
        } else {
            ((JavaWriter)out.tab(2)).println("public static %s %s = createIndex(\"%s\", %s, new %s[] { %s }, %s);", Index.class, this.getStrategy().getJavaIdentifier((Definition)index), this.escapeString(index.getOutputName()), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)index.getTable()), 2), OrderField.class, orderFields, index.isUnique());
        }
    }

    protected void printIdentity(JavaWriter out, int identityCounter, IdentityDefinition identity) {
        int block = identityCounter / 500;
        String identityTypeFull = this.getJavaType(identity.getColumn().getType());
        String identityType = out.ref(identityTypeFull);
        if (identityCounter % 500 == 0) {
            if (identityCounter > 0) {
                ((JavaWriter)out.tab(1)).println("}");
            }
            out.println();
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("private object Identities%s extends %s {", block, AbstractKeys.class);
            } else {
                ((JavaWriter)out.tab(1)).println("private static class Identities%s extends %s {", block, AbstractKeys.class);
            }
        }
        this.printDeprecationIfUnknownType(out, identityTypeFull);
        if (this.scala) {
            ((JavaWriter)out.tab(2)).println("val %s : %s[%s, %s] = %s.createIdentity(%s, %s)", this.getStrategy().getJavaIdentifier((Definition)identity), Identity.class, out.ref(this.getStrategy().getFullJavaClassName((Definition)identity.getTable(), GeneratorStrategy.Mode.RECORD)), identityType, AbstractKeys.class, out.ref(this.getStrategy().getFullJavaIdentifier(identity.getColumn().getContainer()), 2), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)identity.getColumn()), this.colRefSegments((TypedElementDefinition<?>)identity.getColumn())));
        } else {
            ((JavaWriter)out.tab(2)).println("public static %s<%s, %s> %s = createIdentity(%s, %s);", Identity.class, out.ref(this.getStrategy().getFullJavaClassName((Definition)identity.getTable(), GeneratorStrategy.Mode.RECORD)), identityType, this.getStrategy().getJavaIdentifier((Definition)identity), out.ref(this.getStrategy().getFullJavaIdentifier(identity.getColumn().getContainer()), 2), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)identity.getColumn()), this.colRefSegments((TypedElementDefinition<?>)identity.getColumn())));
        }
    }

    protected void printUniqueKey(JavaWriter out, int uniqueKeyCounter, UniqueKeyDefinition uniqueKey) {
        int block = uniqueKeyCounter / 500;
        if (uniqueKeyCounter % 500 == 0) {
            if (uniqueKeyCounter > 0) {
                ((JavaWriter)out.tab(1)).println("}");
            }
            out.println();
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("private object UniqueKeys%s extends %s {", block, AbstractKeys.class);
            } else {
                ((JavaWriter)out.tab(1)).println("private static class UniqueKeys%s extends %s {", block, AbstractKeys.class);
            }
        }
        if (this.scala) {
            ((JavaWriter)out.tab(2)).println("val %s : %s[%s] = %s.createUniqueKey(%s, \"%s\", [[%s]])", this.getStrategy().getJavaIdentifier((Definition)uniqueKey), UniqueKey.class, out.ref(this.getStrategy().getFullJavaClassName((Definition)uniqueKey.getTable(), GeneratorStrategy.Mode.RECORD)), AbstractKeys.class, out.ref(this.getStrategy().getFullJavaIdentifier((Definition)uniqueKey.getTable()), 2), this.escapeString(uniqueKey.getOutputName()), out.ref(this.getStrategy().getFullJavaIdentifiers(uniqueKey.getKeyColumns()), this.colRefSegments(null)));
        } else {
            ((JavaWriter)out.tab(2)).println("public static final %s<%s> %s = createUniqueKey(%s, \"%s\", [[%s]]);", UniqueKey.class, out.ref(this.getStrategy().getFullJavaClassName((Definition)uniqueKey.getTable(), GeneratorStrategy.Mode.RECORD)), this.getStrategy().getJavaIdentifier((Definition)uniqueKey), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)uniqueKey.getTable()), 2), this.escapeString(uniqueKey.getOutputName()), out.ref(this.getStrategy().getFullJavaIdentifiers(uniqueKey.getKeyColumns()), this.colRefSegments(null)));
        }
    }

    protected void printForeignKey(JavaWriter out, int foreignKeyCounter, ForeignKeyDefinition foreignKey) {
        int block = foreignKeyCounter / 500;
        if (foreignKeyCounter % 500 == 0) {
            if (foreignKeyCounter > 0) {
                ((JavaWriter)out.tab(1)).println("}");
            }
            out.println();
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("private object ForeignKeys%s extends %s {", block, AbstractKeys.class);
            } else {
                ((JavaWriter)out.tab(1)).println("private static class ForeignKeys%s extends %s {", block, AbstractKeys.class);
            }
        }
        if (this.scala) {
            ((JavaWriter)out.tab(2)).println("val %s : %s[%s, %s] = %s.createForeignKey(%s, %s, \"%s\", [[%s]])", this.getStrategy().getJavaIdentifier((Definition)foreignKey), ForeignKey.class, out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getKeyTable(), GeneratorStrategy.Mode.RECORD)), out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getReferencedTable(), GeneratorStrategy.Mode.RECORD)), AbstractKeys.class, out.ref(this.getStrategy().getFullJavaIdentifier((Definition)foreignKey.getReferencedKey()), 2), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)foreignKey.getKeyTable()), 2), this.escapeString(foreignKey.getOutputName()), out.ref(this.getStrategy().getFullJavaIdentifiers(foreignKey.getKeyColumns()), this.colRefSegments(null)));
        } else {
            ((JavaWriter)out.tab(2)).println("public static final %s<%s, %s> %s = createForeignKey(%s, %s, \"%s\", [[%s]]);", ForeignKey.class, out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getKeyTable(), GeneratorStrategy.Mode.RECORD)), out.ref(this.getStrategy().getFullJavaClassName((Definition)foreignKey.getReferencedTable(), GeneratorStrategy.Mode.RECORD)), this.getStrategy().getJavaIdentifier((Definition)foreignKey), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)foreignKey.getReferencedKey()), 2), out.ref(this.getStrategy().getFullJavaIdentifier((Definition)foreignKey.getKeyTable()), 2), this.escapeString(foreignKey.getOutputName()), out.ref(this.getStrategy().getFullJavaIdentifiers(foreignKey.getKeyColumns()), this.colRefSegments(null)));
        }
    }

    protected void generateRecords(SchemaDefinition schema) {
        log.info((Object)"Generating table records");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateRecord(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table record " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table records generated");
    }

    protected void generateRecord(TableDefinition table) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)table, GeneratorStrategy.Mode.RECORD));
        log.info((Object)"Generating record", (Object)out.file().getName());
        this.generateRecord(table, out);
        this.closeJavaWriter(out);
    }

    protected void generateUDTRecord(UDTDefinition udt) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)udt, GeneratorStrategy.Mode.RECORD));
        log.info((Object)"Generating record", (Object)out.file().getName());
        this.generateRecord0((Definition)udt, out);
        this.closeJavaWriter(out);
    }

    protected void generateRecord(TableDefinition table, JavaWriter out) {
        this.generateRecord0((Definition)table, out);
    }

    protected void generateUDTRecord(UDTDefinition udt, JavaWriter out) {
        this.generateRecord0((Definition)udt, out);
    }

    private final void generateRecord0(Definition tableOrUdt, JavaWriter out) {
        int keyDegree;
        TypedElementDefinition<? extends Definition> column;
        UniqueKeyDefinition key = tableOrUdt instanceof TableDefinition ? ((TableDefinition)tableOrUdt).getPrimaryKey() : null;
        String className = this.getStrategy().getJavaClassName(tableOrUdt, GeneratorStrategy.Mode.RECORD);
        String tableIdentifier = out.ref(this.getStrategy().getFullJavaIdentifier(tableOrUdt), 2);
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements(tableOrUdt, GeneratorStrategy.Mode.RECORD));
        List<? extends TypedElementDefinition<? extends Definition>> columns = this.getTypedElements(tableOrUdt);
        this.printPackage(out, tableOrUdt, GeneratorStrategy.Mode.RECORD);
        if (tableOrUdt instanceof TableDefinition) {
            this.generateRecordClassJavadoc((TableDefinition)tableOrUdt, out);
        } else {
            this.generateUDTRecordClassJavadoc((UDTDefinition)tableOrUdt, out);
        }
        this.printClassAnnotations(out, tableOrUdt.getSchema());
        if (tableOrUdt instanceof TableDefinition) {
            this.printTableJPAAnnotation(out, (TableDefinition)tableOrUdt);
        }
        Class baseClass = tableOrUdt instanceof UDTDefinition ? UDTRecordImpl.class : (this.generateRelations() && key != null ? UpdatableRecordImpl.class : TableRecordImpl.class);
        int degree = columns.size();
        String rowType = null;
        String rowTypeRecord = null;
        if (this.generateRecordsImplementingRecordN() && degree > 0 && degree <= 22) {
            rowType = this.refRowType(out, columns);
            rowTypeRecord = this.scala ? out.ref(Record.class.getName() + degree) + "[" + rowType + "]" : out.ref(Record.class.getName() + degree) + "<" + rowType + ">";
            interfaces.add(rowTypeRecord);
        }
        if (this.generateInterfaces()) {
            interfaces.add(out.ref(this.getStrategy().getFullJavaClassName(tableOrUdt, GeneratorStrategy.Mode.INTERFACE)));
        }
        if (this.scala) {
            out.println("class %s extends %s[%s](%s)[[before= with ][separator= with ][%s]] {", className, baseClass, className, tableIdentifier, interfaces);
        } else {
            out.println("public class %s extends %s<%s>[[before= implements ][%s]] {", className, baseClass, className, interfaces);
        }
        out.printSerial();
        for (int i = 0; i < degree; ++i) {
            column = columns.get(i);
            if (tableOrUdt instanceof TableDefinition) {
                this.generateRecordSetter(column, i, out);
                this.generateRecordGetter(column, i, out);
                continue;
            }
            this.generateUDTRecordSetter(column, i, out);
            this.generateUDTRecordGetter(column, i, out);
        }
        if (this.generateRelations() && key != null && (keyDegree = key.getKeyColumns().size()) <= 22) {
            String keyType = this.refRowType(out, key.getKeyColumns());
            ((JavaWriter)out.tab(1)).header("Primary key information", new Object[0]);
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("override def key : %s[%s] = {", out.ref(Record.class.getName() + keyDegree), keyType);
                ((JavaWriter)out.tab(2)).println("return super.key.asInstanceOf[ %s[%s] ]", out.ref(Record.class.getName() + keyDegree), keyType);
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public %s<%s> key() {", out.ref(Record.class.getName() + keyDegree), keyType);
                ((JavaWriter)out.tab(2)).println("return (%s) super.key();", out.ref(Record.class.getName() + keyDegree));
                ((JavaWriter)out.tab(1)).println("}");
            }
        }
        if (tableOrUdt instanceof UDTDefinition) {
            for (RoutineDefinition routine : ((UDTDefinition)tableOrUdt).getRoutines()) {
                boolean instance = routine.getInParameters().size() > 0 && ((ParameterDefinition)routine.getInParameters().get(0)).getInputName().toUpperCase().equals("SELF");
                try {
                    if (!routine.isSQLUsable()) {
                        this.printConvenienceMethodProcedure(out, routine, instance);
                        continue;
                    }
                    if (routine.isAggregate()) continue;
                    this.printConvenienceMethodFunction(out, routine, instance);
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating routine " + routine), (Throwable)e);
                }
            }
        }
        if (this.generateRecordsImplementingRecordN() && degree > 0 && degree <= 22) {
            String colGetter;
            String colType;
            int i;
            ((JavaWriter)out.tab(1)).header("Record%s type implementation", degree);
            if (this.scala) {
                out.println();
                ((JavaWriter)out.tab(1)).println("override def fieldsRow : %s[%s] = {", out.ref(Row.class.getName() + degree), rowType);
                ((JavaWriter)out.tab(2)).println("super.fieldsRow.asInstanceOf[ %s[%s] ]", out.ref(Row.class.getName() + degree), rowType);
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public %s<%s> fieldsRow() {", out.ref(Row.class.getName() + degree), rowType);
                ((JavaWriter)out.tab(2)).println("return (%s) super.fieldsRow();", out.ref(Row.class.getName() + degree));
                ((JavaWriter)out.tab(1)).println("}");
            }
            if (this.scala) {
                out.println();
                ((JavaWriter)out.tab(1)).println("override def valuesRow : %s[%s] = {", out.ref(Row.class.getName() + degree), rowType);
                ((JavaWriter)out.tab(2)).println("super.valuesRow.asInstanceOf[ %s[%s] ]", out.ref(Row.class.getName() + degree), rowType);
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public %s<%s> valuesRow() {", out.ref(Row.class.getName() + degree), rowType);
                ((JavaWriter)out.tab(2)).println("return (%s) super.valuesRow();", out.ref(Row.class.getName() + degree));
                ((JavaWriter)out.tab(1)).println("}");
            }
            for (i = 1; i <= degree; ++i) {
                column = columns.get(i - 1);
                String colTypeFull = this.getJavaType(column.getType());
                colType = out.ref(colTypeFull);
                String colIdentifier = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)column), this.colRefSegments(column));
                if (this.scala) {
                    this.printDeprecationIfUnknownType(out, colTypeFull);
                    ((JavaWriter)out.tab(1)).println("override def field%s : %s[%s] = %s", i, Field.class, colType, colIdentifier);
                    continue;
                }
                if (this.printDeprecationIfUnknownType(out, colTypeFull)) {
                    ((JavaWriter)out.tab(1)).override();
                } else {
                    ((JavaWriter)out.tab(1)).overrideInherit();
                }
                ((JavaWriter)out.tab(1)).println("public %s<%s> field%s() {", Field.class, colType, i);
                ((JavaWriter)out.tab(2)).println("return %s;", colIdentifier);
                ((JavaWriter)out.tab(1)).println("}");
            }
            for (i = 1; i <= degree; ++i) {
                column = columns.get(i - 1);
                String colTypeFull = this.getJavaType(column.getType());
                colType = out.ref(colTypeFull);
                colGetter = this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.RECORD);
                if (this.scala) {
                    this.printDeprecationIfUnknownType(out, colTypeFull);
                    ((JavaWriter)out.tab(1)).println("override def component%s : %s = %s", i, colType, colGetter);
                    continue;
                }
                if (this.printDeprecationIfUnknownType(out, colTypeFull)) {
                    ((JavaWriter)out.tab(1)).override();
                } else {
                    ((JavaWriter)out.tab(1)).overrideInherit();
                }
                ((JavaWriter)out.tab(1)).println("public %s component%s() {", colType, i);
                ((JavaWriter)out.tab(2)).println("return %s();", colGetter);
                ((JavaWriter)out.tab(1)).println("}");
            }
            for (i = 1; i <= degree; ++i) {
                column = columns.get(i - 1);
                String colTypeFull = this.getJavaType(column.getType());
                colType = out.ref(colTypeFull);
                colGetter = this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.RECORD);
                if (this.scala) {
                    this.printDeprecationIfUnknownType(out, colTypeFull);
                    ((JavaWriter)out.tab(1)).println("override def value%s : %s = %s", i, colType, colGetter);
                    continue;
                }
                if (this.printDeprecationIfUnknownType(out, colTypeFull)) {
                    ((JavaWriter)out.tab(1)).override();
                } else {
                    ((JavaWriter)out.tab(1)).overrideInherit();
                }
                ((JavaWriter)out.tab(1)).println("public %s value%s() {", colType, i);
                ((JavaWriter)out.tab(2)).println("return %s();", colGetter);
                ((JavaWriter)out.tab(1)).println("}");
            }
            for (i = 1; i <= degree; ++i) {
                column = columns.get(i - 1);
                String colTypeFull = this.getJavaType(column.getType());
                colType = out.ref(colTypeFull);
                String colSetter = this.getStrategy().getJavaSetterName((Definition)column, GeneratorStrategy.Mode.RECORD);
                if (this.scala) {
                    out.println();
                    this.printDeprecationIfUnknownType(out, colTypeFull);
                    ((JavaWriter)out.tab(1)).println("override def value%s(value : %s) : %s = {", i, colType, className);
                    ((JavaWriter)out.tab(2)).println("%s(value)", colSetter);
                    ((JavaWriter)out.tab(2)).println("this");
                    ((JavaWriter)out.tab(1)).println("}");
                    continue;
                }
                if (this.printDeprecationIfUnknownType(out, colTypeFull)) {
                    ((JavaWriter)out.tab(1)).override();
                } else {
                    ((JavaWriter)out.tab(1)).overrideInherit();
                }
                ((JavaWriter)out.tab(1)).println("public %s value%s(%s value) {", className, i, this.varargsIfArray(colType));
                ((JavaWriter)out.tab(2)).println("%s(value);", colSetter);
                ((JavaWriter)out.tab(2)).println("return this;");
                ((JavaWriter)out.tab(1)).println("}");
            }
            ArrayList<String> arguments = new ArrayList<String>();
            ArrayList<String> calls = new ArrayList<String>();
            for (int i2 = 1; i2 <= degree; ++i2) {
                TypedElementDefinition<? extends Definition> column2 = columns.get(i2 - 1);
                String colType2 = out.ref(this.getJavaType(column2.getType()));
                if (this.scala) {
                    arguments.add("value" + i2 + " : " + colType2);
                    calls.add("this.value" + i2 + "(value" + i2 + ")");
                    continue;
                }
                arguments.add(colType2 + " value" + i2);
                calls.add("value" + i2 + "(value" + i2 + ");");
            }
            if (this.scala) {
                out.println();
                ((JavaWriter)out.tab(1)).println("override def values([[%s]]) : %s = {", arguments, className);
                for (String call : calls) {
                    ((JavaWriter)out.tab(2)).println(call);
                }
                ((JavaWriter)out.tab(2)).println("this");
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public %s values([[%s]]) {", className, arguments);
                for (String call : calls) {
                    ((JavaWriter)out.tab(2)).println(call);
                }
                ((JavaWriter)out.tab(2)).println("return this;");
                ((JavaWriter)out.tab(1)).println("}");
            }
        }
        if (this.generateInterfaces()) {
            this.printFromAndInto(out, tableOrUdt);
        }
        if (!this.scala) {
            ((JavaWriter)out.tab(1)).header("Constructors", new Object[0]);
            ((JavaWriter)out.tab(1)).javadoc("Create a detached %s", className);
            ((JavaWriter)out.tab(1)).println("public %s() {", className);
            ((JavaWriter)out.tab(2)).println("super(%s);", tableIdentifier);
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (degree > 0 && degree < 256) {
            String columnMember;
            int i;
            ArrayList<String> arguments = new ArrayList<String>();
            for (i = 0; i < degree; ++i) {
                TypedElementDefinition<? extends Definition> column3 = columns.get(i);
                columnMember = this.getStrategy().getJavaMemberName((Definition)column3, GeneratorStrategy.Mode.DEFAULT);
                String type = out.ref(this.getJavaType(column3.getType()));
                if (this.scala) {
                    arguments.add(columnMember + " : " + type);
                    continue;
                }
                arguments.add(type + " " + columnMember);
            }
            ((JavaWriter)out.tab(1)).javadoc("Create a detached, initialised %s", className);
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def this([[%s]]) = {", arguments);
                ((JavaWriter)out.tab(2)).println("this()", tableIdentifier);
            } else {
                ((JavaWriter)out.tab(1)).println("public %s([[%s]]) {", className, arguments);
                ((JavaWriter)out.tab(2)).println("super(%s);", tableIdentifier);
            }
            out.println();
            for (i = 0; i < degree; ++i) {
                TypedElementDefinition<? extends Definition> column4 = columns.get(i);
                columnMember = this.getStrategy().getJavaMemberName((Definition)column4, GeneratorStrategy.Mode.DEFAULT);
                if (this.scala) {
                    ((JavaWriter)out.tab(2)).println("set(%s, %s)", i, columnMember);
                    continue;
                }
                ((JavaWriter)out.tab(2)).println("set(%s, %s);", i, columnMember);
            }
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (tableOrUdt instanceof TableDefinition) {
            this.generateRecordClassFooter((TableDefinition)tableOrUdt, out);
        } else {
            this.generateUDTRecordClassFooter((UDTDefinition)tableOrUdt, out);
        }
        out.println("}");
    }

    protected void generateRecordSetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generateRecordSetter0(column, index, out);
    }

    protected void generateUDTRecordSetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generateRecordSetter0(column, index, out);
    }

    private final void generateRecordSetter0(TypedElementDefinition<?> column, int index, JavaWriter out) {
        boolean isUDTArray;
        String comment = StringUtils.defaultString((String)column.getComment());
        String className = this.getStrategy().getJavaClassName(column.getContainer(), GeneratorStrategy.Mode.RECORD);
        String setterReturnType = this.generateFluentSetters() ? className : this.tokenVoid;
        String setter = this.getStrategy().getJavaSetterName((Definition)column, GeneratorStrategy.Mode.RECORD);
        String typeFull = this.getJavaType(column.getType());
        String type = out.ref(typeFull);
        String name = column.getQualifiedOutputName();
        boolean isUDT = column.getType().isUDT();
        boolean isArray = column.getType().isArray();
        boolean bl = isUDTArray = column.getType().isArray() && this.database.getArray(column.getType().getSchema(), column.getType().getQualifiedUserType()).getElementType().isUDT();
        if (!this.generateInterfaces() || !isArray) {
            if (!this.printDeprecationIfUnknownType(out, typeFull)) {
                ((JavaWriter)out.tab(1)).javadoc("Setter for <code>%s</code>.%s", name, StringUtils.defaultIfBlank((String)(" " + this.escapeEntities(comment)), (String)""));
            }
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def %s(value : %s) : %s = {", setter, type, setterReturnType);
                ((JavaWriter)out.tab(2)).println("set(%s, value)", index);
                if (this.generateFluentSetters()) {
                    ((JavaWriter)out.tab(2)).println("this");
                }
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).overrideIf(this.generateInterfaces() && !this.generateImmutableInterfaces() && !isUDT);
                ((JavaWriter)out.tab(1)).println("public %s %s(%s value) {", setterReturnType, setter, this.varargsIfArray(type));
                ((JavaWriter)out.tab(2)).println("set(%s, value);", index);
                if (this.generateFluentSetters()) {
                    ((JavaWriter)out.tab(2)).println("return this;");
                }
                ((JavaWriter)out.tab(1)).println("}");
            }
        }
        if (this.generateInterfaces() && !this.generateImmutableInterfaces() && (isUDT || isArray)) {
            String columnTypeFull = this.getJavaType(column.getType(), GeneratorStrategy.Mode.RECORD);
            String columnType = out.ref(columnTypeFull);
            String columnTypeInterface = out.ref(this.getJavaType(column.getType(), GeneratorStrategy.Mode.INTERFACE));
            if (!this.printDeprecationIfUnknownType(out, columnTypeFull)) {
                ((JavaWriter)out.tab(1)).javadoc("Setter for <code>%s</code>.%s", name, StringUtils.defaultIfBlank((String)(" " + comment), (String)""));
            }
            ((JavaWriter)out.tab(1)).override();
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def %s(value : %s) : %s = {", setter, columnTypeInterface, setterReturnType);
                ((JavaWriter)out.tab(2)).println("if (value == null)");
                ((JavaWriter)out.tab(3)).println("set(%s, null)", index);
                ((JavaWriter)out.tab(2)).println("else");
                ((JavaWriter)out.tab(3)).println("set(%s, value.into(new %s()))", index, type);
                if (this.generateFluentSetters()) {
                    ((JavaWriter)out.tab(2)).println("this");
                }
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).println("public %s %s(%s value) {", setterReturnType, setter, this.varargsIfArray(columnTypeInterface));
                ((JavaWriter)out.tab(2)).println("if (value == null)");
                ((JavaWriter)out.tab(3)).println("set(%s, null);", index);
                if (isUDT) {
                    ((JavaWriter)out.tab(2)).println("else");
                    ((JavaWriter)out.tab(3)).println("set(%s, value.into(new %s()));", index, type);
                } else if (isArray) {
                    ArrayDefinition array = this.database.getArray(column.getType().getSchema(), column.getType().getQualifiedUserType());
                    String componentType = out.ref(this.getJavaType(array.getElementType(), GeneratorStrategy.Mode.RECORD));
                    String componentTypeInterface = out.ref(this.getJavaType(array.getElementType(), GeneratorStrategy.Mode.INTERFACE));
                    ((JavaWriter)out.tab(2)).println("else {");
                    ((JavaWriter)out.tab(3)).println("%s a = new %s();", columnType, columnType);
                    out.println();
                    ((JavaWriter)out.tab(3)).println("for (%s i : value)", componentTypeInterface);
                    if (isUDTArray) {
                        ((JavaWriter)out.tab(4)).println("a.add(i.into(new %s()));", componentType);
                    } else {
                        ((JavaWriter)out.tab(4)).println("a.add(i);", componentType);
                    }
                    out.println();
                    ((JavaWriter)out.tab(3)).println("set(1, a);");
                    ((JavaWriter)out.tab(2)).println("}");
                }
                if (this.generateFluentSetters()) {
                    ((JavaWriter)out.tab(2)).println("return this;");
                }
                ((JavaWriter)out.tab(1)).println("}");
            }
        }
    }

    protected void generateRecordGetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generateRecordGetter0(column, index, out);
    }

    protected void generateUDTRecordGetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generateRecordGetter0(column, index, out);
    }

    private final void generateRecordGetter0(TypedElementDefinition<?> column, int index, JavaWriter out) {
        String comment = StringUtils.defaultString((String)column.getComment());
        String getter = this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.RECORD);
        String typeFull = this.getJavaType(column.getType());
        String type = out.ref(typeFull);
        String name = column.getQualifiedOutputName();
        if (!this.printDeprecationIfUnknownType(out, typeFull)) {
            ((JavaWriter)out.tab(1)).javadoc("Getter for <code>%s</code>.%s", name, StringUtils.defaultIfBlank((String)(" " + this.escapeEntities(comment)), (String)""));
        }
        if (column.getContainer() instanceof TableDefinition) {
            this.printColumnJPAAnnotation(out, (ColumnDefinition)column);
        }
        this.printValidationAnnotation(out, column);
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("def %s : %s = {", getter, type);
            ((JavaWriter)out.tab(2)).println("val r = get(%s)", index);
            ((JavaWriter)out.tab(2)).println("if (r == null) null else r.asInstanceOf[%s]", type);
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            ((JavaWriter)out.tab(1)).overrideIf(this.generateInterfaces());
            ((JavaWriter)out.tab(1)).println("public %s %s() {", type, getter);
            if ("java.lang.Object".equals(typeFull)) {
                ((JavaWriter)out.tab(2)).println("return get(%s);", index);
            } else {
                ((JavaWriter)out.tab(2)).println("return (%s) get(%s);", type, index);
            }
            ((JavaWriter)out.tab(1)).println("}");
        }
    }

    private int colRefSegments(TypedElementDefinition<?> column) {
        if (column != null && column.getContainer() instanceof UDTDefinition) {
            return 2;
        }
        if (!this.getStrategy().getInstanceFields()) {
            return 2;
        }
        return 3;
    }

    protected void generateRecordClassFooter(TableDefinition table, JavaWriter out) {
    }

    protected void generateRecordClassJavadoc(TableDefinition table, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)table);
    }

    private String refRowType(JavaWriter out, Collection<? extends TypedElementDefinition<?>> columns) {
        StringBuilder result = new StringBuilder();
        String separator = "";
        for (TypedElementDefinition<?> column : columns) {
            result.append(separator);
            result.append(out.ref(this.getJavaType(column.getType())));
            separator = ", ";
        }
        return result.toString();
    }

    protected void generateInterfaces(SchemaDefinition schema) {
        log.info((Object)"Generating table interfaces");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateInterface(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table interface " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table interfaces generated");
    }

    protected void generateInterface(TableDefinition table) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)table, GeneratorStrategy.Mode.INTERFACE));
        log.info((Object)"Generating interface", (Object)out.file().getName());
        this.generateInterface(table, out);
        this.closeJavaWriter(out);
    }

    protected void generateUDTInterface(UDTDefinition udt) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)udt, GeneratorStrategy.Mode.INTERFACE));
        log.info((Object)"Generating interface", (Object)out.file().getName());
        this.generateInterface0((Definition)udt, out);
        this.closeJavaWriter(out);
    }

    protected void generateInterface(TableDefinition table, JavaWriter out) {
        this.generateInterface0((Definition)table, out);
    }

    protected void generateUDTInterface(UDTDefinition udt, JavaWriter out) {
        this.generateInterface0((Definition)udt, out);
    }

    private final void generateInterface0(Definition tableOrUDT, JavaWriter out) {
        String className = this.getStrategy().getJavaClassName(tableOrUDT, GeneratorStrategy.Mode.INTERFACE);
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements(tableOrUDT, GeneratorStrategy.Mode.INTERFACE));
        this.printPackage(out, tableOrUDT, GeneratorStrategy.Mode.INTERFACE);
        if (tableOrUDT instanceof TableDefinition) {
            this.generateInterfaceClassJavadoc((TableDefinition)tableOrUDT, out);
        } else {
            this.generateUDTInterfaceClassJavadoc((UDTDefinition)tableOrUDT, out);
        }
        this.printClassAnnotations(out, tableOrUDT.getSchema());
        if (tableOrUDT instanceof TableDefinition) {
            this.printTableJPAAnnotation(out, (TableDefinition)tableOrUDT);
        }
        if (this.scala) {
            out.println("trait %s [[before=extends ][%s]] {", className, interfaces);
        } else {
            out.println("public interface %s [[before=extends ][%s]] {", className, interfaces);
        }
        List<? extends TypedElementDefinition<? extends Definition>> typedElements = this.getTypedElements(tableOrUDT);
        for (int i = 0; i < typedElements.size(); ++i) {
            TypedElementDefinition<? extends Definition> column = typedElements.get(i);
            if (!this.generateImmutableInterfaces()) {
                if (tableOrUDT instanceof TableDefinition) {
                    this.generateInterfaceSetter(column, i, out);
                } else {
                    this.generateUDTInterfaceSetter(column, i, out);
                }
            }
            if (tableOrUDT instanceof TableDefinition) {
                this.generateInterfaceGetter(column, i, out);
                continue;
            }
            this.generateUDTInterfaceGetter(column, i, out);
        }
        if (!this.generateImmutableInterfaces()) {
            String local = this.getStrategy().getJavaClassName(tableOrUDT, GeneratorStrategy.Mode.INTERFACE);
            String qualified = out.ref(this.getStrategy().getFullJavaClassName(tableOrUDT, GeneratorStrategy.Mode.INTERFACE));
            ((JavaWriter)out.tab(1)).header("FROM and INTO", new Object[0]);
            ((JavaWriter)out.tab(1)).javadoc("Load data from another generated Record/POJO implementing the common interface %s", local);
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def from(from : %s)", qualified);
            } else {
                ((JavaWriter)out.tab(1)).println("public void from(%s from);", qualified);
            }
            ((JavaWriter)out.tab(1)).javadoc("Copy data into another generated Record/POJO implementing the common interface %s", local);
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def into [E <: %s](into : E) : E", qualified);
            } else {
                ((JavaWriter)out.tab(1)).println("public <E extends %s> E into(E into);", qualified);
            }
        }
        if (tableOrUDT instanceof TableDefinition) {
            this.generateInterfaceClassFooter((TableDefinition)tableOrUDT, out);
        } else {
            this.generateUDTInterfaceClassFooter((UDTDefinition)tableOrUDT, out);
        }
        out.println("}");
    }

    protected void generateInterfaceSetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generateInterfaceSetter0(column, index, out);
    }

    protected void generateUDTInterfaceSetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generateInterfaceSetter0(column, index, out);
    }

    private final void generateInterfaceSetter0(TypedElementDefinition<?> column, int index, JavaWriter out) {
        String className = this.getStrategy().getJavaClassName(column.getContainer(), GeneratorStrategy.Mode.INTERFACE);
        String comment = StringUtils.defaultString((String)column.getComment());
        String setterReturnType = this.generateFluentSetters() ? className : "void";
        String setter = this.getStrategy().getJavaSetterName((Definition)column, GeneratorStrategy.Mode.INTERFACE);
        String typeFull = this.getJavaType(column.getType(), GeneratorStrategy.Mode.INTERFACE);
        String type = out.ref(typeFull);
        String name = column.getQualifiedOutputName();
        if (!this.printDeprecationIfUnknownType(out, typeFull)) {
            ((JavaWriter)out.tab(1)).javadoc("Setter for <code>%s</code>.%s", name, StringUtils.defaultIfBlank((String)(" " + this.escapeEntities(comment)), (String)""));
        }
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("def %s(value : %s) : %s", setter, type, setterReturnType);
        } else {
            ((JavaWriter)out.tab(1)).println("public %s %s(%s value);", setterReturnType, setter, this.varargsIfArray(type));
        }
    }

    protected void generateInterfaceGetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generateInterfaceGetter0(column, index, out);
    }

    protected void generateUDTInterfaceGetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generateInterfaceGetter0(column, index, out);
    }

    private final void generateInterfaceGetter0(TypedElementDefinition<?> column, int index, JavaWriter out) {
        String comment = StringUtils.defaultString((String)column.getComment());
        String getter = this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.INTERFACE);
        String typeFull = this.getJavaType(column.getType(), GeneratorStrategy.Mode.INTERFACE);
        String type = out.ref(typeFull);
        String name = column.getQualifiedOutputName();
        if (!this.printDeprecationIfUnknownType(out, typeFull)) {
            ((JavaWriter)out.tab(1)).javadoc("Getter for <code>%s</code>.%s", name, StringUtils.defaultIfBlank((String)(" " + this.escapeEntities(comment)), (String)""));
        }
        if (column instanceof ColumnDefinition) {
            this.printColumnJPAAnnotation(out, (ColumnDefinition)column);
        }
        this.printValidationAnnotation(out, column);
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("def %s : %s", getter, type);
        } else {
            ((JavaWriter)out.tab(1)).println("public %s %s();", type, getter);
        }
    }

    protected void generateInterfaceClassFooter(TableDefinition table, JavaWriter out) {
    }

    protected void generateInterfaceClassJavadoc(TableDefinition table, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)table);
    }

    protected void generateUDTs(SchemaDefinition schema) {
        log.info((Object)"Generating UDTs");
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            try {
                this.generateUDT(schema, udt);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating udt " + udt), (Throwable)e);
            }
        }
        this.watch.splitInfo("UDTs generated");
    }

    protected void generateUDT(SchemaDefinition schema, UDTDefinition udt) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)udt));
        log.info((Object)"Generating UDT ", (Object)out.file().getName());
        this.generateUDT(udt, out);
        this.closeJavaWriter(out);
    }

    protected void generateUDT(UDTDefinition udt, JavaWriter out) {
        SchemaDefinition schema = udt.getSchema();
        PackageDefinition pkg = udt.getPackage();
        boolean synthetic = udt.isSynthetic();
        String className = this.getStrategy().getJavaClassName((Definition)udt);
        String recordType = out.ref(this.getStrategy().getFullJavaClassName((Definition)udt, GeneratorStrategy.Mode.RECORD));
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)udt, GeneratorStrategy.Mode.DEFAULT));
        String schemaId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)schema), 2);
        String packageId = pkg == null ? null : out.ref(this.getStrategy().getFullJavaIdentifier((Definition)pkg), 2);
        String udtId = out.ref(this.getStrategy().getJavaIdentifier((Definition)udt), 2);
        this.printPackage(out, (Definition)udt);
        if (this.scala) {
            out.println("object %s {", className);
            this.printSingletonInstance(out, (Definition)udt);
            for (AttributeDefinition attribute : udt.getAttributes()) {
                String attrId = out.ref(this.getStrategy().getJavaIdentifier((Definition)attribute), 2);
                String attrComment = StringUtils.defaultString((String)attribute.getComment());
                ((JavaWriter)out.tab(1)).javadoc("The attribute <code>%s</code>.%s", attribute.getQualifiedOutputName(), StringUtils.defaultIfBlank((String)(" " + this.escapeEntities(attrComment)), (String)""));
                ((JavaWriter)out.tab(1)).println("val %s = %s.%s", attrId, udtId, attrId);
            }
            out.println("}");
            out.println();
        }
        this.generateUDTClassJavadoc(udt, out);
        this.printClassAnnotations(out, schema);
        if (udt.getRoutines().size() > 0) {
            interfaces.add(out.ref(Package.class));
        }
        if (this.scala) {
            out.println("class %s extends %s[%s](\"%s\", null, %s, %s)[[before= with ][separator= with ][%s]] {", className, UDTImpl.class, recordType, udt.getOutputName(), packageId, synthetic, interfaces);
        } else {
            out.println("public class %s extends %s<%s>[[before= implements ][%s]] {", className, UDTImpl.class, recordType, interfaces);
            out.printSerial();
            this.printSingletonInstance(out, (Definition)udt);
        }
        this.printRecordTypeMethod(out, (Definition)udt);
        for (AttributeDefinition attribute : udt.getAttributes()) {
            String attrTypeFull = this.getJavaType(attribute.getType());
            String attrType = out.ref(attrTypeFull);
            String attrTypeRef = this.getJavaTypeReference(attribute.getDatabase(), attribute.getType());
            String attrId = out.ref(this.getStrategy().getJavaIdentifier((Definition)attribute), 2);
            String attrName = attribute.getName();
            String attrComment = StringUtils.defaultString((String)attribute.getComment());
            List<String> converter = out.ref(JavaGenerator.list(attribute.getType().getConverter()));
            List<String> binding = out.ref(JavaGenerator.list(attribute.getType().getBinding()));
            if (this.scala) {
                this.printDeprecationIfUnknownType(out, attrTypeFull);
                ((JavaWriter)out.tab(1)).println("private val %s : %s[%s, %s] = %s.createField(\"%s\", %s, this, \"%s\"" + this.converterTemplate(converter) + this.converterTemplate(binding) + ")", attrId, UDTField.class, recordType, attrType, UDTImpl.class, attrName, attrTypeRef, this.escapeString(""), converter, binding);
                continue;
            }
            if (!this.printDeprecationIfUnknownType(out, attrTypeFull)) {
                ((JavaWriter)out.tab(1)).javadoc("The attribute <code>%s</code>.%s", attribute.getQualifiedOutputName(), StringUtils.defaultIfBlank((String)(" " + attrComment), (String)""));
            }
            ((JavaWriter)out.tab(1)).println("public static final %s<%s, %s> %s = createField(\"%s\", %s, %s, \"%s\"" + this.converterTemplate(converter) + this.converterTemplate(binding) + ");", UDTField.class, recordType, attrType, attrId, attrName, attrTypeRef, udtId, this.escapeString(""), converter, binding);
        }
        for (RoutineDefinition routine : udt.getRoutines()) {
            try {
                if (!routine.isSQLUsable()) {
                    this.printConvenienceMethodProcedure(out, routine, false);
                    continue;
                }
                if (!routine.isAggregate()) {
                    this.printConvenienceMethodFunction(out, routine, false);
                }
                this.printConvenienceMethodFunctionAsField(out, routine, false);
                this.printConvenienceMethodFunctionAsField(out, routine, true);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating routine " + routine), (Throwable)e);
            }
        }
        if (!this.scala) {
            ((JavaWriter)out.tab(1)).javadoc(NO_FURTHER_INSTANCES_ALLOWED, new Object[0]);
            ((JavaWriter)out.tab(1)).println("private %s() {", className);
            ((JavaWriter)out.tab(2)).println("super(\"%s\", null, %s, %s);", udt.getOutputName(), packageId, synthetic);
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.scala) {
            out.println();
            ((JavaWriter)out.tab(1)).println("override def getSchema : %s = %s", Schema.class, schemaId);
        } else {
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s getSchema() {", Schema.class);
            ((JavaWriter)out.tab(2)).println("return %s;", schemaId);
            ((JavaWriter)out.tab(1)).println("}");
        }
        this.generateUDTClassFooter(udt, out);
        out.println("}");
        this.closeJavaWriter(out);
    }

    protected void generateUDTClassFooter(UDTDefinition udt, JavaWriter out) {
    }

    protected void generateUDTClassJavadoc(UDTDefinition udt, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)udt);
    }

    protected void generateUDTPojos(SchemaDefinition schema) {
        log.info((Object)"Generating UDT POJOs");
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            try {
                this.generateUDTPojo(udt);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating UDT POJO " + udt), (Throwable)e);
            }
        }
        this.watch.splitInfo("UDT POJOs generated");
    }

    protected void generateUDTPojoClassFooter(UDTDefinition udt, JavaWriter out) {
    }

    protected void generateUDTPojoClassJavadoc(UDTDefinition udt, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)udt);
    }

    protected void generateUDTInterfaces(SchemaDefinition schema) {
        log.info((Object)"Generating UDT interfaces");
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            try {
                this.generateUDTInterface(udt);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating UDT interface " + udt), (Throwable)e);
            }
        }
        this.watch.splitInfo("UDT interfaces generated");
    }

    protected void generateUDTInterfaceClassFooter(UDTDefinition udt, JavaWriter out) {
    }

    protected void generateUDTInterfaceClassJavadoc(UDTDefinition udt, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)udt);
    }

    protected void generateUDTRecords(SchemaDefinition schema) {
        log.info((Object)"Generating UDT records");
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            try {
                this.generateUDTRecord(udt);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating UDT record " + udt), (Throwable)e);
            }
        }
        this.watch.splitInfo("UDT records generated");
    }

    protected void generateUDTRecordClassFooter(UDTDefinition udt, JavaWriter out) {
    }

    protected void generateUDTRecordClassJavadoc(UDTDefinition udt, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)udt);
    }

    protected void generateUDTRoutines(SchemaDefinition schema) {
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            if (udt.getRoutines().size() <= 0) continue;
            try {
                log.info((Object)"Generating member routines");
                for (RoutineDefinition routine : udt.getRoutines()) {
                    try {
                        this.generateRoutine(schema, routine);
                    }
                    catch (Exception e) {
                        log.error((Object)("Error while generating member routines " + routine), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while generating UDT " + udt), (Throwable)e);
            }
            this.watch.splitInfo("Member procedures routines");
        }
    }

    protected void generateUDTReferences(SchemaDefinition schema) {
        log.info((Object)"Generating UDT references");
        JavaWriter out = this.newJavaWriter(new File(this.getFile((Definition)schema).getParentFile(), "UDTs.java"));
        this.printPackage(out, (Definition)schema);
        this.printClassJavadoc(out, "Convenience access to all UDTs in " + schema.getOutputName());
        this.printClassAnnotations(out, schema);
        if (this.scala) {
            out.println("object UDTs {");
        } else {
            out.println("public class UDTs {");
        }
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            String className = out.ref(this.getStrategy().getFullJavaClassName((Definition)udt));
            String id = this.getStrategy().getJavaIdentifier((Definition)udt);
            String fullId = this.getStrategy().getFullJavaIdentifier((Definition)udt);
            ((JavaWriter)out.tab(1)).javadoc("The type <code>%s</code>", udt.getQualifiedOutputName());
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("val %s = %s", id, fullId);
                continue;
            }
            ((JavaWriter)out.tab(1)).println("public static %s %s = %s;", className, id, fullId);
        }
        out.println("}");
        this.closeJavaWriter(out);
        this.watch.splitInfo("UDT references generated");
    }

    protected void generateArrays(SchemaDefinition schema) {
        log.info((Object)"Generating ARRAYs");
        for (ArrayDefinition array : this.database.getArrays(schema)) {
            try {
                this.generateArray(schema, array);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating ARRAY record " + array), (Throwable)e);
            }
        }
        this.watch.splitInfo("ARRAYs generated");
    }

    protected void generateArray(SchemaDefinition schema, ArrayDefinition array) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)array, GeneratorStrategy.Mode.RECORD));
        log.info((Object)"Generating ARRAY", (Object)out.file().getName());
        this.generateArray(array, out);
        this.closeJavaWriter(out);
    }

    protected void generateArray(ArrayDefinition array, JavaWriter out) {
    }

    protected void generateArrayClassFooter(ArrayDefinition array, JavaWriter out) {
    }

    protected void generateArrayClassJavadoc(ArrayDefinition array, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)array);
    }

    protected void generateEnums(SchemaDefinition schema) {
        log.info((Object)"Generating ENUMs");
        for (EnumDefinition e : this.database.getEnums(schema)) {
            try {
                this.generateEnum(e);
            }
            catch (Exception ex) {
                log.error((Object)("Error while generating enum " + e), (Throwable)ex);
            }
        }
        this.watch.splitInfo("Enums generated");
    }

    protected void generateDomains(SchemaDefinition schema) {
        log.info((Object)"Generating DOMAINs");
        for (DomainDefinition d : this.database.getDomains(schema)) {
            try {
                this.generateDomain(d);
            }
            catch (Exception ex) {
                log.error((Object)("Error while generating domain " + d), (Throwable)ex);
            }
        }
        this.watch.splitInfo("Domains generated");
    }

    protected void generateEnum(EnumDefinition e) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)e, GeneratorStrategy.Mode.ENUM));
        log.info((Object)"Generating ENUM", (Object)out.file().getName());
        this.generateEnum(e, out);
        this.closeJavaWriter(out);
    }

    protected void generateEnum(EnumDefinition e, JavaWriter out) {
        boolean enumHasNoSchema;
        String className = this.getStrategy().getJavaClassName((Definition)e, GeneratorStrategy.Mode.ENUM);
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)e, GeneratorStrategy.Mode.ENUM));
        List literals = e.getLiterals();
        ArrayList<String> identifiers = new ArrayList<String>();
        for (int i = 0; i < literals.size(); ++i) {
            String identifier = GenerationUtil.convertToIdentifier((String)literals.get(i), this.language);
            if (identifier.equals(this.getStrategy().getJavaPackageName((Definition)e).replaceAll("\\..*", ""))) {
                identifier = identifier + "_";
            }
            identifiers.add(identifier);
        }
        this.printPackage(out, (Definition)e);
        this.generateEnumClassJavadoc(e, out);
        this.printClassAnnotations(out, e.getSchema());
        boolean bl = enumHasNoSchema = e.isSynthetic() || !(e.getDatabase() instanceof PostgresDatabase);
        if (this.scala) {
            int i;
            out.println("object %s {", className);
            out.println();
            for (i = 0; i < identifiers.size(); ++i) {
                ((JavaWriter)out.tab(1)).println("val %s : %s = %s.%s", identifiers.get(i), className, this.getStrategy().getJavaPackageName((Definition)e), identifiers.get(i));
            }
            out.println();
            ((JavaWriter)out.tab(1)).println("def values : %s[%s] = %s(", out.ref("scala.Array"), className, out.ref("scala.Array"));
            for (i = 0; i < identifiers.size(); ++i) {
                ((JavaWriter)out.tab(2)).print(i > 0 ? ", " : "  ");
                out.println((String)identifiers.get(i));
            }
            ((JavaWriter)out.tab(1)).println(")");
            out.println();
            ((JavaWriter)out.tab(1)).println("def valueOf(s : %s) : %s = s match {", String.class, className);
            for (i = 0; i < identifiers.size(); ++i) {
                ((JavaWriter)out.tab(2)).println("case \"%s\" => %s", literals.get(i), identifiers.get(i));
            }
            ((JavaWriter)out.tab(2)).println("case _ => throw new %s()", IllegalArgumentException.class);
            ((JavaWriter)out.tab(1)).println("}");
            out.println("}");
            out.println();
            out.println("sealed trait %s extends %s[[before= with ][%s]] {", className, EnumType.class, interfaces);
            if (enumHasNoSchema) {
                ((JavaWriter)out.tab(1)).println("override def getCatalog : %s = null", Catalog.class);
            } else {
                ((JavaWriter)out.tab(1)).println("override def getCatalog : %s = if (getSchema == null) null else getSchema().getCatalog()", Catalog.class);
            }
            ((JavaWriter)out.tab(1)).println("override def getSchema : %s = %s", Schema.class, enumHasNoSchema ? "null" : out.ref(this.getStrategy().getFullJavaIdentifier((Definition)e.getSchema()), 2));
            ((JavaWriter)out.tab(1)).println("override def getName : %s = %s", String.class, e.isSynthetic() ? "null" : "\"" + e.getName().replace("\"", "\\\"") + "\"");
            this.generateEnumClassFooter(e, out);
            out.println("}");
            for (i = 0; i < literals.size(); ++i) {
                out.println();
                out.println("case object %s extends %s {", identifiers.get(i), className);
                ((JavaWriter)out.tab(1)).println("override def getLiteral : %s = \"%s\"", String.class, literals.get(i));
                out.println("}");
            }
        } else {
            interfaces.add(out.ref(EnumType.class));
            out.println("public enum %s[[before= implements ][%s]] {", className, interfaces);
            for (int i = 0; i < literals.size(); ++i) {
                out.println();
                ((JavaWriter)out.tab(1)).println("%s(\"%s\")%s", identifiers.get(i), literals.get(i), i == literals.size() - 1 ? ";" : ",");
            }
            out.println();
            ((JavaWriter)out.tab(1)).println("private final %s literal;", String.class);
            out.println();
            ((JavaWriter)out.tab(1)).println("private %s(%s literal) {", className, String.class);
            ((JavaWriter)out.tab(2)).println("this.literal = literal;");
            ((JavaWriter)out.tab(1)).println("}");
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s getCatalog() {", Catalog.class);
            if (enumHasNoSchema) {
                ((JavaWriter)out.tab(2)).println("return null;");
            } else {
                ((JavaWriter)out.tab(2)).println("return getSchema() == null ? null : getSchema().getCatalog();");
            }
            ((JavaWriter)out.tab(1)).println("}");
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s getSchema() {", Schema.class);
            ((JavaWriter)out.tab(2)).println("return %s;", enumHasNoSchema ? "null" : out.ref(this.getStrategy().getFullJavaIdentifier((Definition)e.getSchema()), 2));
            ((JavaWriter)out.tab(1)).println("}");
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s getName() {", String.class);
            ((JavaWriter)out.tab(2)).println("return %s;", e.isSynthetic() ? "null" : "\"" + e.getName().replace("\"", "\\\"") + "\"");
            ((JavaWriter)out.tab(1)).println("}");
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s getLiteral() {", String.class);
            ((JavaWriter)out.tab(2)).println("return literal;");
            ((JavaWriter)out.tab(1)).println("}");
            this.generateEnumClassFooter(e, out);
            out.println("}");
        }
    }

    protected void generateEnumClassFooter(EnumDefinition e, JavaWriter out) {
    }

    protected void generateEnumClassJavadoc(EnumDefinition e, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)e);
    }

    protected void generateDomain(DomainDefinition d) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)d, GeneratorStrategy.Mode.DOMAIN));
        log.info((Object)"Generating DOMAIN", (Object)out.file().getName());
        this.generateDomain(d, out);
        this.closeJavaWriter(out);
    }

    protected void generateDomain(DomainDefinition d, JavaWriter out) {
        String className = this.getStrategy().getJavaClassName((Definition)d, GeneratorStrategy.Mode.DOMAIN);
        String superName = out.ref(this.getStrategy().getJavaClassExtends((Definition)d, GeneratorStrategy.Mode.DOMAIN));
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)d, GeneratorStrategy.Mode.DOMAIN));
        List<String> superTypes = JavaGenerator.list(superName, interfaces);
        this.printPackage(out, (Definition)d);
        this.generateDomainClassJavadoc(d, out);
        this.printClassAnnotations(out, d.getSchema());
        for (String clause : d.getCheckClauses()) {
            out.println("// " + clause);
        }
        if (this.scala) {
            out.println("class %s[[before= extends ][%s]][[before= with ][separator= with ][%s]] {", className, JavaGenerator.first(superTypes), JavaGenerator.remaining(superTypes));
        } else {
            out.println("public class %s[[before= extends ][%s]][[before= implements ][%s]] {", className, JavaGenerator.list(superName), interfaces);
        }
        this.generateDomainClassFooter(d, out);
        out.println("}");
    }

    protected void generateDomainClassFooter(DomainDefinition d, JavaWriter out) {
    }

    protected void generateDomainClassJavadoc(DomainDefinition e, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)e);
    }

    protected void generateRoutines(SchemaDefinition schema) {
        log.info((Object)"Generating routines and table-valued functions");
        if (this.generateGlobalRoutineReferences()) {
            JavaWriter out = this.newJavaWriter(new File(this.getFile((Definition)schema).getParentFile(), "Routines.java"));
            this.printPackage(out, (Definition)schema);
            this.printClassJavadoc(out, "Convenience access to all stored procedures and functions in " + schema.getOutputName());
            this.printClassAnnotations(out, schema);
            if (this.scala) {
                out.println("object Routines {");
            } else {
                out.println("public class Routines {");
            }
            for (RoutineDefinition routine : this.database.getRoutines(schema)) {
                this.printRoutine(out, routine);
            }
            for (TableDefinition table : this.database.getTables(schema)) {
                if (!table.isTableValuedFunction()) continue;
                this.printTableValuedFunction(out, table, this.getStrategy().getJavaMethodName((Definition)table, GeneratorStrategy.Mode.DEFAULT));
            }
            out.println("}");
            this.closeJavaWriter(out);
        }
        for (RoutineDefinition routine : this.database.getRoutines(schema)) {
            try {
                this.generateRoutine(schema, routine);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating routine " + routine), (Throwable)e);
            }
        }
        this.watch.splitInfo("Routines generated");
    }

    protected void printConstant(JavaWriter out, AttributeDefinition constant) {
    }

    protected void printRoutine(JavaWriter out, RoutineDefinition routine) {
        if (!routine.isSQLUsable()) {
            this.printConvenienceMethodProcedure(out, routine, false);
        } else {
            if (!routine.isAggregate()) {
                this.printConvenienceMethodFunction(out, routine, false);
            }
            this.printConvenienceMethodFunctionAsField(out, routine, false);
            this.printConvenienceMethodFunctionAsField(out, routine, true);
        }
    }

    protected void printTableValuedFunction(JavaWriter out, TableDefinition table, String javaMethodName) {
        this.printConvenienceMethodTableValuedFunction(out, table, javaMethodName);
        this.printConvenienceMethodTableValuedFunctionAsField(out, table, false, javaMethodName);
        this.printConvenienceMethodTableValuedFunctionAsField(out, table, true, javaMethodName);
    }

    protected void generatePackages(SchemaDefinition schema) {
    }

    protected void generatePackage(SchemaDefinition schema, PackageDefinition pkg) {
    }

    protected void generatePackage(PackageDefinition pkg, JavaWriter out) {
    }

    protected void generatePackageClassFooter(PackageDefinition pkg, JavaWriter out) {
    }

    protected void generatePackageClassJavadoc(PackageDefinition pkg, JavaWriter out) {
        this.printClassJavadoc(out, "Convenience access to all stored procedures and functions in " + pkg.getName());
    }

    protected void generateTableReferences(SchemaDefinition schema) {
        log.info((Object)"Generating table references");
        JavaWriter out = this.newJavaWriter(new File(this.getFile((Definition)schema).getParentFile(), "Tables.java"));
        this.printPackage(out, (Definition)schema);
        this.printClassJavadoc(out, "Convenience access to all tables in " + schema.getOutputName());
        this.printClassAnnotations(out, schema);
        if (this.scala) {
            out.println("object Tables {");
        } else {
            out.println("public class Tables {");
        }
        for (TableDefinition table : this.database.getTables(schema)) {
            String comment;
            String className = this.scala ? "" : out.ref(this.getStrategy().getFullJavaClassName((Definition)table));
            String id = this.getStrategy().getJavaIdentifier((Definition)table);
            String fullId = this.getStrategy().getFullJavaIdentifier((Definition)table);
            String string = comment = !StringUtils.isBlank((String)table.getComment()) ? this.escapeEntities(table.getComment()) : "The table <code>" + table.getQualifiedOutputName() + "</code>.";
            if (!(this.scala && table.isTableValuedFunction() && table.getParameters().isEmpty())) {
                ((JavaWriter)out.tab(1)).javadoc(comment, new Object[0]);
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("val %s = %s", id, fullId);
                } else {
                    ((JavaWriter)out.tab(1)).println("public static final %s %s = %s;", className, id, fullId);
                }
            }
            if (!table.isTableValuedFunction()) continue;
            this.printTableValuedFunction(out, table, this.getStrategy().getJavaIdentifier((Definition)table));
        }
        out.println("}");
        this.closeJavaWriter(out);
        this.watch.splitInfo("Table refs generated");
    }

    protected void generateDaos(SchemaDefinition schema) {
        log.info((Object)"Generating DAOs");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateDao(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table DAO " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table DAOs generated");
    }

    protected void generateDao(TableDefinition table) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)table, GeneratorStrategy.Mode.DAO));
        log.info((Object)"Generating DAO", (Object)out.file().getName());
        this.generateDao(table, out);
        this.closeJavaWriter(out);
    }

    protected void generateDao(TableDefinition table, JavaWriter out) {
        String separator;
        UniqueKeyDefinition key = table.getPrimaryKey();
        if (key == null) {
            log.info((Object)"Skipping DAO generation", (Object)out.file().getName());
            return;
        }
        String className = this.getStrategy().getJavaClassName((Definition)table, GeneratorStrategy.Mode.DAO);
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)table, GeneratorStrategy.Mode.DAO));
        String tableRecord = out.ref(this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
        String daoImpl = out.ref(DAOImpl.class);
        String tableIdentifier = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)table), 2);
        String tType = this.scala ? "Unit" : "Void";
        String pType = out.ref(this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO));
        List keyColumns = key.getKeyColumns();
        if (keyColumns.size() == 1) {
            tType = this.getJavaType(((ColumnDefinition)keyColumns.get(0)).getType());
        } else if (keyColumns.size() <= 22) {
            String generics = "";
            separator = "";
            for (ColumnDefinition column : keyColumns) {
                generics = generics + separator + out.ref(this.getJavaType(column.getType()));
                separator = ", ";
            }
            tType = this.scala ? Record.class.getName() + keyColumns.size() + "[" + generics + "]" : Record.class.getName() + keyColumns.size() + "<" + generics + ">";
        } else {
            tType = Record.class.getName();
        }
        tType = out.ref(tType);
        this.printPackage(out, (Definition)table, GeneratorStrategy.Mode.DAO);
        this.generateDaoClassJavadoc(table, out);
        this.printClassAnnotations(out, table.getSchema());
        if (this.generateSpringAnnotations()) {
            out.println("@%s", out.ref("org.springframework.stereotype.Repository"));
        }
        if (this.scala) {
            out.println("class %s(configuration : %s) extends %s[%s, %s, %s](%s, classOf[%s], configuration)[[before= with ][separator= with ][%s]] {", className, Configuration.class, daoImpl, tableRecord, pType, tType, tableIdentifier, pType, interfaces);
        } else {
            out.println("public class %s extends %s<%s, %s, %s>[[before= implements ][%s]] {", className, daoImpl, tableRecord, pType, tType, interfaces);
        }
        ((JavaWriter)out.tab(1)).javadoc("Create a new %s without any configuration", className);
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("def this() = {");
            ((JavaWriter)out.tab(2)).println("this(null)");
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            ((JavaWriter)out.tab(1)).println("public %s() {", className);
            ((JavaWriter)out.tab(2)).println("super(%s, %s.class);", tableIdentifier, pType);
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (!this.scala) {
            ((JavaWriter)out.tab(1)).javadoc("Create a new %s with an attached configuration", className);
            if (this.generateSpringAnnotations()) {
                ((JavaWriter)out.tab(1)).println("@%s", out.ref("org.springframework.beans.factory.annotation.Autowired"));
            }
            ((JavaWriter)out.tab(1)).println("public %s(%s configuration) {", className, Configuration.class);
            ((JavaWriter)out.tab(2)).println("super(%s, %s.class, configuration);", tableIdentifier, pType);
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.scala) {
            out.println();
            ((JavaWriter)out.tab(1)).println("override protected def getId(o : %s) : %s = {", pType, tType);
        } else {
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("protected %s getId(%s object) {", tType, pType);
        }
        if (keyColumns.size() == 1) {
            if (this.scala) {
                ((JavaWriter)out.tab(2)).println("o.%s", this.getStrategy().getJavaGetterName((Definition)keyColumns.get(0), GeneratorStrategy.Mode.POJO));
            } else {
                ((JavaWriter)out.tab(2)).println("return object.%s();", this.getStrategy().getJavaGetterName((Definition)keyColumns.get(0), GeneratorStrategy.Mode.POJO));
            }
        } else {
            String params = "";
            separator = "";
            for (ColumnDefinition column : keyColumns) {
                params = this.scala ? params + separator + "o." + this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.POJO) : params + separator + "object." + this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.POJO) + "()";
                separator = ", ";
            }
            if (this.scala) {
                ((JavaWriter)out.tab(2)).println("compositeKeyRecord(%s)", params);
            } else {
                ((JavaWriter)out.tab(2)).println("return compositeKeyRecord(%s);", params);
            }
        }
        ((JavaWriter)out.tab(1)).println("}");
        block2: for (ColumnDefinition column : table.getColumns()) {
            String colName = column.getOutputName();
            String colClass = this.getStrategy().getJavaClassName((Definition)column);
            String colTypeFull = this.getJavaType(column.getType());
            String colType = out.ref(colTypeFull);
            String colIdentifier = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)column), this.colRefSegments((TypedElementDefinition<?>)column));
            if (!this.printDeprecationIfUnknownType(out, colTypeFull)) {
                ((JavaWriter)out.tab(1)).javadoc("Fetch records that have <code>%s IN (values)</code>", colName);
            }
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def fetchBy%s(values : %s*) : %s[%s] = {", colClass, colType, List.class, pType);
                ((JavaWriter)out.tab(2)).println("fetch(%s, values:_*)", colIdentifier);
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).println("public %s<%s> fetchBy%s(%s... values) {", List.class, pType, colClass, colType);
                ((JavaWriter)out.tab(2)).println("return fetch(%s, values);", colIdentifier);
                ((JavaWriter)out.tab(1)).println("}");
            }
            for (UniqueKeyDefinition uk : column.getUniqueKeys()) {
                if (uk.getKeyColumns().size() != 1 || !((ColumnDefinition)uk.getKeyColumns().get(0)).equals(column)) continue;
                if (!this.printDeprecationIfUnknownType(out, colTypeFull)) {
                    ((JavaWriter)out.tab(1)).javadoc("Fetch a unique record that has <code>%s = value</code>", colName);
                }
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("def fetchOneBy%s(value : %s) : %s = {", colClass, colType, pType);
                    ((JavaWriter)out.tab(2)).println("fetchOne(%s, value)", colIdentifier);
                    ((JavaWriter)out.tab(1)).println("}");
                    continue block2;
                }
                ((JavaWriter)out.tab(1)).println("public %s fetchOneBy%s(%s value) {", pType, colClass, colType);
                ((JavaWriter)out.tab(2)).println("return fetchOne(%s, value);", colIdentifier);
                ((JavaWriter)out.tab(1)).println("}");
                continue block2;
            }
        }
        this.generateDaoClassFooter(table, out);
        out.println("}");
    }

    protected void generateDaoClassFooter(TableDefinition table, JavaWriter out) {
    }

    protected void generateDaoClassJavadoc(TableDefinition table, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)table);
    }

    protected void generatePojos(SchemaDefinition schema) {
        log.info((Object)"Generating table POJOs");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generatePojo(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table POJO " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table POJOs generated");
    }

    protected void generatePojo(TableDefinition table) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)table, GeneratorStrategy.Mode.POJO));
        log.info((Object)"Generating POJO", (Object)out.file().getName());
        this.generatePojo(table, out);
        this.closeJavaWriter(out);
    }

    protected void generateUDTPojo(UDTDefinition udt) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)udt, GeneratorStrategy.Mode.POJO));
        log.info((Object)"Generating POJO", (Object)out.file().getName());
        this.generatePojo0((Definition)udt, out);
        this.closeJavaWriter(out);
    }

    protected void generatePojo(TableDefinition table, JavaWriter out) {
        this.generatePojo0((Definition)table, out);
    }

    protected void generateUDTPojo(UDTDefinition udt, JavaWriter out) {
        this.generatePojo0((Definition)udt, out);
    }

    /*
     * WARNING - void declaration
     */
    private final void generatePojo0(Definition tableOrUDT, JavaWriter out) {
        void var9_26;
        String className = this.getStrategy().getJavaClassName(tableOrUDT, GeneratorStrategy.Mode.POJO);
        String superName = out.ref(this.getStrategy().getJavaClassExtends(tableOrUDT, GeneratorStrategy.Mode.POJO));
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements(tableOrUDT, GeneratorStrategy.Mode.POJO));
        List<String> superTypes = JavaGenerator.list(superName, interfaces);
        if (this.generateInterfaces()) {
            interfaces.add(out.ref(this.getStrategy().getFullJavaClassName(tableOrUDT, GeneratorStrategy.Mode.INTERFACE)));
        }
        this.printPackage(out, tableOrUDT, GeneratorStrategy.Mode.POJO);
        if (tableOrUDT instanceof TableDefinition) {
            this.generatePojoClassJavadoc((TableDefinition)tableOrUDT, out);
        } else {
            this.generateUDTPojoClassJavadoc((UDTDefinition)tableOrUDT, out);
        }
        this.printClassAnnotations(out, tableOrUDT.getSchema());
        if (tableOrUDT instanceof TableDefinition) {
            this.printTableJPAAnnotation(out, (TableDefinition)tableOrUDT);
        }
        int maxLength = 0;
        for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
            maxLength = Math.max(maxLength, out.ref(this.getJavaType(typedElementDefinition.getType(), GeneratorStrategy.Mode.POJO)).length());
        }
        if (this.scala) {
            out.println("%sclass %s(", this.generateImmutablePojos() ? "case " : "", className);
            Object separator = "  ";
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                ((JavaWriter)out.tab(1)).println("%s%s%s : %s", separator, this.generateImmutablePojos() ? "" : "private var ", this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO), StringUtils.rightPad((String)out.ref(this.getJavaType(typedElementDefinition.getType(), GeneratorStrategy.Mode.POJO)), (int)maxLength));
                separator = ", ";
            }
            out.println(")[[before= extends ][%s]][[before= with ][separator= with ][%s]] {", JavaGenerator.first(superTypes), JavaGenerator.remaining(superTypes));
        } else {
            out.println("public class %s[[before= extends ][%s]][[before= implements ][%s]] {", className, JavaGenerator.list(superName), interfaces);
            out.printSerial();
            out.println();
            for (TypedElementDefinition typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                ((JavaWriter)out.tab(1)).println("private %s%s %s;", this.generateImmutablePojos() ? "final " : "", StringUtils.rightPad((String)out.ref(this.getJavaType(typedElementDefinition.getType(), GeneratorStrategy.Mode.POJO)), (int)maxLength), this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO));
            }
        }
        if (!this.generateImmutablePojos()) {
            out.println();
            if (this.scala) {
                int size = this.getTypedElements(tableOrUDT).size();
                if (size > 0) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                        if (size == 1) {
                            arrayList.add("null : " + out.ref(this.getJavaType(typedElementDefinition.getType(), GeneratorStrategy.Mode.POJO)));
                            continue;
                        }
                        arrayList.add("null");
                    }
                    ((JavaWriter)out.tab(1)).println("def this() = {", className);
                    ((JavaWriter)out.tab(2)).println("this([[%s]])", arrayList);
                    ((JavaWriter)out.tab(1)).println("}");
                }
            } else {
                ((JavaWriter)out.tab(1)).println("public %s() {}", className);
            }
        }
        out.println();
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("def this (value : %s) = {", className, className);
            ((JavaWriter)out.tab(2)).println("this(");
            Object separator = "  ";
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                ((JavaWriter)out.tab(3)).println("%svalue.%s", separator, this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO), this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO));
                separator = ", ";
            }
            ((JavaWriter)out.tab(2)).println(")");
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            ((JavaWriter)out.tab(1)).println("public %s(%s value) {", className, className);
            for (TypedElementDefinition typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                ((JavaWriter)out.tab(2)).println("this.%s = value.%s;", this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO), this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO));
            }
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (!this.scala && this.getTypedElements(tableOrUDT).size() > 0 && this.getTypedElements(tableOrUDT).size() < 256) {
            out.println();
            ((JavaWriter)out.tab(1)).print("public %s(", className);
            String separator1 = "";
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                out.println(separator1);
                ((JavaWriter)out.tab(2)).print("%s %s", StringUtils.rightPad((String)out.ref(this.getJavaType(typedElementDefinition.getType(), GeneratorStrategy.Mode.POJO)), (int)maxLength), this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO));
                separator1 = ",";
            }
            out.println();
            ((JavaWriter)out.tab(1)).println(") {");
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                String string = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                ((JavaWriter)out.tab(2)).println("this.%s = %s;", string, string);
            }
            ((JavaWriter)out.tab(1)).println("}");
        }
        List<? extends TypedElementDefinition<? extends Definition>> elements = this.getTypedElements(tableOrUDT);
        boolean bl = false;
        while (var9_26 < elements.size()) {
            TypedElementDefinition<? extends Definition> typedElementDefinition = elements.get((int)var9_26);
            if (tableOrUDT instanceof TableDefinition) {
                this.generatePojoGetter(typedElementDefinition, (int)var9_26, out);
            } else {
                this.generateUDTPojoGetter(typedElementDefinition, (int)var9_26, out);
            }
            if (!this.generateImmutablePojos()) {
                if (tableOrUDT instanceof TableDefinition) {
                    this.generatePojoSetter(typedElementDefinition, (int)var9_26, out);
                } else {
                    this.generateUDTPojoSetter(typedElementDefinition, (int)var9_26, out);
                }
            }
            ++var9_26;
        }
        if (this.generatePojosEqualsAndHashCode()) {
            this.generatePojoEqualsAndHashCode(tableOrUDT, out);
        }
        if (this.generatePojosToString()) {
            this.generatePojoToString(tableOrUDT, out);
        }
        if (this.generateInterfaces() && !this.generateImmutablePojos()) {
            this.printFromAndInto(out, tableOrUDT);
        }
        if (tableOrUDT instanceof TableDefinition) {
            this.generatePojoClassFooter((TableDefinition)tableOrUDT, out);
        } else {
            this.generateUDTPojoClassFooter((UDTDefinition)tableOrUDT, out);
        }
        out.println("}");
        this.closeJavaWriter(out);
    }

    protected void generatePojoGetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generatePojoGetter0(column, index, out);
    }

    protected void generateUDTPojoGetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generatePojoGetter0(column, index, out);
    }

    private final void generatePojoGetter0(TypedElementDefinition<?> column, int index, JavaWriter out) {
        String columnTypeFull = this.getJavaType(column.getType(), GeneratorStrategy.Mode.POJO);
        String columnType = out.ref(columnTypeFull);
        String columnGetter = this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.POJO);
        String columnMember = this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO);
        out.println();
        this.printDeprecationIfUnknownType(out, columnTypeFull);
        if (column instanceof ColumnDefinition) {
            this.printColumnJPAAnnotation(out, (ColumnDefinition)column);
        }
        this.printValidationAnnotation(out, column);
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("def %s : %s = {", columnGetter, columnType);
            ((JavaWriter)out.tab(2)).println("this.%s", columnMember);
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            ((JavaWriter)out.tab(1)).overrideIf(this.generateInterfaces());
            ((JavaWriter)out.tab(1)).println("public %s %s() {", columnType, columnGetter);
            ((JavaWriter)out.tab(2)).println("return this.%s;", columnMember);
            ((JavaWriter)out.tab(1)).println("}");
        }
    }

    protected void generatePojoSetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generatePojoSetter0(column, index, out);
    }

    protected void generateUDTPojoSetter(TypedElementDefinition<?> column, int index, JavaWriter out) {
        this.generatePojoSetter0(column, index, out);
    }

    private final void generatePojoSetter0(TypedElementDefinition<?> column, int index, JavaWriter out) {
        boolean isUDTArray;
        String className = this.getStrategy().getJavaClassName(column.getContainer(), GeneratorStrategy.Mode.POJO);
        String columnTypeFull = this.getJavaType(column.getType(), GeneratorStrategy.Mode.POJO);
        String columnType = out.ref(columnTypeFull);
        String columnSetterReturnType = this.generateFluentSetters() ? className : (this.scala ? "Unit" : "void");
        String columnSetter = this.getStrategy().getJavaSetterName((Definition)column, GeneratorStrategy.Mode.POJO);
        String columnMember = this.getStrategy().getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO);
        boolean isUDT = column.getType().isUDT();
        boolean bl = isUDTArray = column.getType().isArray() && this.database.getArray(column.getType().getSchema(), column.getType().getQualifiedUserType()).getElementType().isUDT();
        if (!this.generateInterfaces() || !isUDTArray) {
            out.println();
            this.printDeprecationIfUnknownType(out, columnTypeFull);
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def %s(%s : %s) : %s = {", columnSetter, columnMember, columnType, columnSetterReturnType);
                ((JavaWriter)out.tab(2)).println("this.%s = %s", columnMember, columnMember);
                if (this.generateFluentSetters()) {
                    ((JavaWriter)out.tab(2)).println("this");
                }
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).overrideIf(this.generateInterfaces() && !this.generateImmutableInterfaces() && !isUDT);
                ((JavaWriter)out.tab(1)).println("public %s %s(%s %s) {", columnSetterReturnType, columnSetter, this.varargsIfArray(columnType), columnMember);
                ((JavaWriter)out.tab(2)).println("this.%s = %s;", columnMember, columnMember);
                if (this.generateFluentSetters()) {
                    ((JavaWriter)out.tab(2)).println("return this;");
                }
                ((JavaWriter)out.tab(1)).println("}");
            }
        }
        if (this.generateInterfaces() && (isUDT || isUDTArray)) {
            String columnTypeInterface = out.ref(this.getJavaType(column.getType(), GeneratorStrategy.Mode.INTERFACE));
            out.println();
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def %s(%s : %s) : %s = {", columnSetter, columnMember, columnTypeInterface, columnSetterReturnType);
                ((JavaWriter)out.tab(2)).println("if (%s == null)", columnMember);
                ((JavaWriter)out.tab(3)).println("this.%s = null", columnMember);
                ((JavaWriter)out.tab(2)).println("else");
                ((JavaWriter)out.tab(3)).println("this.%s = %s.into(new %s)", columnMember, columnMember, columnType);
                if (this.generateFluentSetters()) {
                    ((JavaWriter)out.tab(2)).println("this");
                }
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).override();
                ((JavaWriter)out.tab(1)).println("public %s %s(%s %s) {", columnSetterReturnType, columnSetter, this.varargsIfArray(columnTypeInterface), columnMember);
                ((JavaWriter)out.tab(2)).println("if (%s == null)", columnMember);
                ((JavaWriter)out.tab(3)).println("this.%s = null;", columnMember);
                if (isUDT) {
                    ((JavaWriter)out.tab(2)).println("else");
                    ((JavaWriter)out.tab(3)).println("this.%s = %s.into(new %s());", columnMember, columnMember, columnType);
                } else if (isUDTArray) {
                    ArrayDefinition array = this.database.getArray(column.getType().getSchema(), column.getType().getQualifiedUserType());
                    String componentType = out.ref(this.getJavaType(array.getElementType(), GeneratorStrategy.Mode.POJO));
                    String componentTypeInterface = out.ref(this.getJavaType(array.getElementType(), GeneratorStrategy.Mode.INTERFACE));
                    ((JavaWriter)out.tab(2)).println("else {");
                    ((JavaWriter)out.tab(3)).println("this.%s = new %s();", columnMember, ArrayList.class);
                    out.println();
                    ((JavaWriter)out.tab(3)).println("for (%s i : %s)", componentTypeInterface, columnMember);
                    ((JavaWriter)out.tab(4)).println("this.%s.add(i.into(new %s()));", columnMember, componentType);
                    ((JavaWriter)out.tab(2)).println("}");
                }
                if (this.generateFluentSetters()) {
                    ((JavaWriter)out.tab(2)).println("return this;");
                }
                ((JavaWriter)out.tab(1)).println("}");
            }
        }
    }

    protected void generatePojoEqualsAndHashCode(Definition tableOrUDT, JavaWriter out) {
        String columnMember;
        String className = this.getStrategy().getJavaClassName(tableOrUDT, GeneratorStrategy.Mode.POJO);
        out.println();
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("override def equals(obj : Any) : scala.Boolean = {");
            ((JavaWriter)out.tab(2)).println("if (this == obj)");
            ((JavaWriter)out.tab(3)).println("return true");
            ((JavaWriter)out.tab(2)).println("if (obj == null)");
            ((JavaWriter)out.tab(3)).println("return false");
            ((JavaWriter)out.tab(2)).println("if (getClass() != obj.getClass())");
            ((JavaWriter)out.tab(3)).println("return false");
            ((JavaWriter)out.tab(2)).println("val other = obj.asInstanceOf[%s]", className);
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                ((JavaWriter)out.tab(2)).println("if (%s == null) {", columnMember);
                ((JavaWriter)out.tab(3)).println("if (other.%s != null)", columnMember);
                ((JavaWriter)out.tab(4)).println("return false");
                ((JavaWriter)out.tab(2)).println("}");
                if (this.getJavaType(typedElementDefinition.getType()).endsWith("[]")) {
                    ((JavaWriter)out.tab(2)).println("else if (!%s.equals(%s, other.%s))", Arrays.class, columnMember, columnMember);
                } else {
                    ((JavaWriter)out.tab(2)).println("else if (!%s.equals(other.%s))", columnMember, columnMember);
                }
                ((JavaWriter)out.tab(3)).println("return false");
            }
            ((JavaWriter)out.tab(2)).println("return true");
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            ((JavaWriter)out.tab(1)).println("@Override");
            ((JavaWriter)out.tab(1)).println("public boolean equals(%s obj) {", Object.class);
            ((JavaWriter)out.tab(2)).println("if (this == obj)");
            ((JavaWriter)out.tab(3)).println("return true;");
            ((JavaWriter)out.tab(2)).println("if (obj == null)");
            ((JavaWriter)out.tab(3)).println("return false;");
            ((JavaWriter)out.tab(2)).println("if (getClass() != obj.getClass())");
            ((JavaWriter)out.tab(3)).println("return false;");
            ((JavaWriter)out.tab(2)).println("final %s other = (%s) obj;", className, className);
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                ((JavaWriter)out.tab(2)).println("if (%s == null) {", columnMember);
                ((JavaWriter)out.tab(3)).println("if (other.%s != null)", columnMember);
                ((JavaWriter)out.tab(4)).println("return false;");
                ((JavaWriter)out.tab(2)).println("}");
                if (this.getJavaType(typedElementDefinition.getType()).endsWith("[]")) {
                    ((JavaWriter)out.tab(2)).println("else if (!%s.equals(%s, other.%s))", Arrays.class, columnMember, columnMember);
                } else {
                    ((JavaWriter)out.tab(2)).println("else if (!%s.equals(other.%s))", columnMember, columnMember);
                }
                ((JavaWriter)out.tab(3)).println("return false;");
            }
            ((JavaWriter)out.tab(2)).println("return true;");
            ((JavaWriter)out.tab(1)).println("}");
        }
        out.println();
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("override def hashCode : Int = {");
            ((JavaWriter)out.tab(2)).println("val prime = 31");
            ((JavaWriter)out.tab(2)).println("var result = 1");
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                if (this.getJavaType(typedElementDefinition.getType()).endsWith("[]")) {
                    ((JavaWriter)out.tab(2)).println("result = prime * result + (if (this.%s == null) 0 else %s.hashCode(this.%s))", columnMember, Arrays.class, columnMember);
                    continue;
                }
                ((JavaWriter)out.tab(2)).println("result = prime * result + (if (this.%s == null) 0 else this.%s.hashCode())", columnMember, columnMember);
            }
            ((JavaWriter)out.tab(2)).println("return result");
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            ((JavaWriter)out.tab(1)).println("@Override");
            ((JavaWriter)out.tab(1)).println("public int hashCode() {");
            ((JavaWriter)out.tab(2)).println("final int prime = 31;");
            ((JavaWriter)out.tab(2)).println("int result = 1;");
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                if (this.getJavaType(typedElementDefinition.getType()).endsWith("[]")) {
                    ((JavaWriter)out.tab(2)).println("result = prime * result + ((this.%s == null) ? 0 : %s.hashCode(this.%s));", columnMember, Arrays.class, columnMember);
                    continue;
                }
                ((JavaWriter)out.tab(2)).println("result = prime * result + ((this.%s == null) ? 0 : this.%s.hashCode());", columnMember, columnMember);
            }
            ((JavaWriter)out.tab(2)).println("return result;");
            ((JavaWriter)out.tab(1)).println("}");
        }
    }

    protected void generatePojoToString(Definition tableOrUDT, JavaWriter out) {
        String className = this.getStrategy().getJavaClassName(tableOrUDT, GeneratorStrategy.Mode.POJO);
        out.println();
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("override def toString : String = {");
            ((JavaWriter)out.tab(2)).println("val sb = new %s(\"%s (\")", StringBuilder.class, className);
            ((JavaWriter)out.tab(2)).println();
            String separator = "";
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                String columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                String columnType = this.getJavaType(typedElementDefinition.getType());
                if (columnType.equals("scala.Array[scala.Byte]")) {
                    ((JavaWriter)out.tab(2)).println("sb%s.append(\"[binary...]\")", separator);
                } else {
                    ((JavaWriter)out.tab(2)).println("sb%s.append(%s)", separator, columnMember);
                }
                separator = ".append(\", \")";
            }
            ((JavaWriter)out.tab(2)).println();
            ((JavaWriter)out.tab(2)).println("sb.append(\")\");");
            ((JavaWriter)out.tab(2)).println("return sb.toString");
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            ((JavaWriter)out.tab(1)).println("@Override");
            ((JavaWriter)out.tab(1)).println("public String toString() {");
            ((JavaWriter)out.tab(2)).println("%s sb = new %s(\"%s (\");", StringBuilder.class, StringBuilder.class, className);
            ((JavaWriter)out.tab(2)).println();
            String separator = "";
            for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
                String columnMember = this.getStrategy().getJavaMemberName((Definition)typedElementDefinition, GeneratorStrategy.Mode.POJO);
                String columnType = this.getJavaType(typedElementDefinition.getType());
                boolean array = columnType.endsWith("[]");
                if (array && columnType.equals("byte[]")) {
                    ((JavaWriter)out.tab(2)).println("sb%s.append(\"[binary...]\");", separator);
                } else if (array) {
                    ((JavaWriter)out.tab(2)).println("sb%s.append(%s.toString(%s));", separator, Arrays.class, columnMember);
                } else {
                    ((JavaWriter)out.tab(2)).println("sb%s.append(%s);", separator, columnMember);
                }
                separator = ".append(\", \")";
            }
            ((JavaWriter)out.tab(2)).println();
            ((JavaWriter)out.tab(2)).println("sb.append(\")\");");
            ((JavaWriter)out.tab(2)).println("return sb.toString();");
            ((JavaWriter)out.tab(1)).println("}");
        }
    }

    private List<? extends TypedElementDefinition<? extends Definition>> getTypedElements(Definition definition) {
        if (definition instanceof TableDefinition) {
            return ((TableDefinition)definition).getColumns();
        }
        if (definition instanceof UDTDefinition) {
            return ((UDTDefinition)definition).getAttributes();
        }
        if (definition instanceof RoutineDefinition) {
            return ((RoutineDefinition)definition).getAllParameters();
        }
        throw new IllegalArgumentException("Unsupported type : " + definition);
    }

    protected void generatePojoClassFooter(TableDefinition table, JavaWriter out) {
    }

    protected void generatePojoClassJavadoc(TableDefinition table, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)table);
    }

    protected void generateTables(SchemaDefinition schema) {
        log.info((Object)"Generating tables");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateTable(schema, table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Tables generated");
    }

    protected void generateTable(SchemaDefinition schema, TableDefinition table) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)table));
        this.generateTable(table, out);
        this.closeJavaWriter(out);
    }

    protected void generateTable(TableDefinition table, JavaWriter out) {
        List list;
        SchemaDefinition schema = table.getSchema();
        UniqueKeyDefinition primaryKey = table.getPrimaryKey();
        boolean updatable = this.generateRelations() && primaryKey != null;
        String className = this.getStrategy().getJavaClassName((Definition)table);
        String tableId = this.scala ? out.ref(this.getStrategy().getFullJavaIdentifier((Definition)table), 2) : this.getStrategy().getJavaIdentifier((Definition)table);
        String recordType = out.ref(this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)table, GeneratorStrategy.Mode.DEFAULT));
        String schemaId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)schema), 2);
        String comment = StringUtils.defaultString((String)table.getComment());
        log.info((Object)"Generating table", (Object)(out.file().getName() + " [input=" + table.getInputName() + ", output=" + table.getOutputName() + ", pk=" + (primaryKey != null ? primaryKey.getName() : "N/A") + "]"));
        this.printPackage(out, (Definition)table);
        if (this.scala) {
            out.println("object %s {", className);
            this.printSingletonInstance(out, (Definition)table);
            out.println("}");
            out.println();
        }
        this.generateTableClassJavadoc(table, out);
        this.printClassAnnotations(out, schema);
        if (this.scala) {
            out.println("class %s(alias : %s, aliased : %s[%s], parameters : %s[ %s[_] ]) extends %s[%s](alias, %s, aliased, parameters, \"%s\")[[before= with ][separator= with ][%s]] {", className, Name.class, Table.class, recordType, out.ref("scala.Array"), Field.class, TableImpl.class, recordType, schemaId, this.escapeString(comment), interfaces);
        } else {
            out.println("public class %s extends %s<%s>[[before= implements ][%s]] {", className, TableImpl.class, recordType, interfaces);
            out.printSerial();
            this.printSingletonInstance(out, (Definition)table);
        }
        this.printRecordTypeMethod(out, (Definition)table);
        for (ColumnDefinition column : table.getColumns()) {
            String columnTypeFull = this.getJavaType(column.getType());
            String columnType = out.ref(columnTypeFull);
            String columnTypeRef = this.getJavaTypeReference(column.getDatabase(), column.getType());
            String columnId = out.ref(this.getStrategy().getJavaIdentifier((Definition)column), this.colRefSegments((TypedElementDefinition<?>)column));
            String columnName = column.getName();
            String columnComment = StringUtils.defaultString((String)column.getComment());
            List<String> converter = out.ref(JavaGenerator.list(column.getType().getConverter()));
            List<String> binding = out.ref(JavaGenerator.list(column.getType().getBinding()));
            if (!this.printDeprecationIfUnknownType(out, columnTypeFull)) {
                ((JavaWriter)out.tab(1)).javadoc("The column <code>%s</code>.%s", column.getQualifiedOutputName(), StringUtils.defaultIfBlank((String)(" " + this.escapeEntities(columnComment)), (String)""));
            }
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("val %s : %s[%s, %s] = createField(\"%s\", %s, \"%s\"" + this.converterTemplate(converter) + this.converterTemplate(binding) + ")", columnId, TableField.class, recordType, columnType, columnName, columnTypeRef, this.escapeString(columnComment), converter, binding);
                continue;
            }
            String isStatic = this.generateInstanceFields() ? "" : "static ";
            String tableRef = this.generateInstanceFields() ? "this" : out.ref(this.getStrategy().getJavaIdentifier((Definition)table), 2);
            ((JavaWriter)out.tab(1)).println("public %sfinal %s<%s, %s> %s = createField(\"%s\", %s, %s, \"%s\"" + this.converterTemplate(converter) + this.converterTemplate(binding) + ");", isStatic, TableField.class, recordType, columnType, columnId, columnName, columnTypeRef, tableRef, this.escapeString(columnComment), converter, binding);
        }
        if (this.scala) {
            ((JavaWriter)out.tab(1)).javadoc("Create a <code>%s</code> table reference", table.getQualifiedOutputName());
            ((JavaWriter)out.tab(1)).println("def this() = {");
            ((JavaWriter)out.tab(2)).println("this(%s.name(\"%s\"), null, null)", DSL.class, table.getOutputName());
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            if (this.generateInstanceFields()) {
                ((JavaWriter)out.tab(1)).javadoc("Create a <code>%s</code> table reference", table.getQualifiedOutputName());
                ((JavaWriter)out.tab(1)).println("public %s() {", className);
            } else {
                ((JavaWriter)out.tab(1)).javadoc(NO_FURTHER_INSTANCES_ALLOWED, new Object[0]);
                ((JavaWriter)out.tab(1)).println("private %s() {", className);
            }
            ((JavaWriter)out.tab(2)).println("this(%s.name(\"%s\"), null);", DSL.class, table.getOutputName());
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.scala) {
            ((JavaWriter)out.tab(1)).javadoc("Create an aliased <code>%s</code> table reference", table.getQualifiedOutputName());
            ((JavaWriter)out.tab(1)).println("def this(alias : %s) = {", String.class);
            ((JavaWriter)out.tab(2)).println("this(%s.name(alias), %s, null)", DSL.class, tableId);
            ((JavaWriter)out.tab(1)).println("}");
            ((JavaWriter)out.tab(1)).javadoc("Create an aliased <code>%s</code> table reference", table.getQualifiedOutputName());
            ((JavaWriter)out.tab(1)).println("def this(alias : %s) = {", Name.class);
            ((JavaWriter)out.tab(2)).println("this(alias, %s, null)", tableId);
            ((JavaWriter)out.tab(1)).println("}");
        } else if (this.generateInstanceFields()) {
            ((JavaWriter)out.tab(1)).javadoc("Create an aliased <code>%s</code> table reference", table.getQualifiedOutputName());
            ((JavaWriter)out.tab(1)).println("public %s(%s alias) {", className, String.class);
            ((JavaWriter)out.tab(2)).println("this(%s.name(alias), %s);", DSL.class, tableId);
            ((JavaWriter)out.tab(1)).println("}");
            ((JavaWriter)out.tab(1)).javadoc("Create an aliased <code>%s</code> table reference", table.getQualifiedOutputName());
            ((JavaWriter)out.tab(1)).println("public %s(%s alias) {", className, Name.class);
            ((JavaWriter)out.tab(2)).println("this(alias, %s);", tableId);
            ((JavaWriter)out.tab(1)).println("}");
        }
        out.println();
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("private def this(alias : %s, aliased : %s[%s]) = {", Name.class, Table.class, recordType);
            if (table.isTableValuedFunction()) {
                ((JavaWriter)out.tab(2)).println("this(alias, aliased, new %s[ %s[_] ](%s))", out.ref("scala.Array"), Field.class, table.getParameters().size());
            } else {
                ((JavaWriter)out.tab(2)).println("this(alias, aliased, null)");
            }
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            ((JavaWriter)out.tab(1)).println("private %s(%s alias, %s<%s> aliased) {", className, Name.class, Table.class, recordType);
            if (table.isTableValuedFunction()) {
                ((JavaWriter)out.tab(2)).println("this(alias, aliased, new %s[%s]);", Field.class, table.getParameters().size());
            } else {
                ((JavaWriter)out.tab(2)).println("this(alias, aliased, null);");
            }
            ((JavaWriter)out.tab(1)).println("}");
            out.println();
            ((JavaWriter)out.tab(1)).println("private %s(%s alias, %s<%s> aliased, %s<?>[] parameters) {", className, Name.class, Table.class, recordType, Field.class);
            ((JavaWriter)out.tab(2)).println("super(alias, null, aliased, parameters, \"%s\");", this.escapeString(comment));
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.scala) {
            out.println();
            ((JavaWriter)out.tab(1)).println("override def getSchema : %s = %s", Schema.class, schemaId);
        } else {
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s getSchema() {", Schema.class);
            ((JavaWriter)out.tab(2)).println("return %s;", schemaId);
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.generateIndexes() && !(list = table.getIndexes()).isEmpty()) {
            List<String> indexFullIds = out.ref(this.getStrategy().getFullJavaIdentifiers(list), 2);
            if (this.scala) {
                out.println();
                ((JavaWriter)out.tab(1)).println("override def getIndexes : %s[ %s ] = {", List.class, Index.class);
                ((JavaWriter)out.tab(2)).println("return %s.asList[ %s ]([[%s]])", Arrays.class, Index.class, indexFullIds);
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public %s<%s> getIndexes() {", List.class, Index.class);
                ((JavaWriter)out.tab(2)).println("return %s.<%s>asList([[%s]]);", Arrays.class, Index.class, indexFullIds);
                ((JavaWriter)out.tab(1)).println("}");
            }
        }
        if (this.generateRelations()) {
            List foreignKeys;
            List uniqueKeys;
            IdentityDefinition identityDefinition = table.getIdentity();
            if (identityDefinition != null) {
                String identityTypeFull = this.getJavaType(identityDefinition.getColumn().getType());
                String identityType = out.ref(identityTypeFull);
                String identityFullId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)identityDefinition), 2);
                if (this.scala) {
                    out.println();
                    this.printDeprecationIfUnknownType(out, identityTypeFull);
                    ((JavaWriter)out.tab(1)).println("override def getIdentity : %s[%s, %s] = {", Identity.class, recordType, identityType);
                    ((JavaWriter)out.tab(2)).println("%s", identityFullId);
                    ((JavaWriter)out.tab(1)).println("}");
                } else {
                    if (this.printDeprecationIfUnknownType(out, identityTypeFull)) {
                        ((JavaWriter)out.tab(1)).override();
                    } else {
                        ((JavaWriter)out.tab(1)).overrideInherit();
                    }
                    ((JavaWriter)out.tab(1)).println("public %s<%s, %s> getIdentity() {", Identity.class, recordType, identityType);
                    ((JavaWriter)out.tab(2)).println("return %s;", identityFullId);
                    ((JavaWriter)out.tab(1)).println("}");
                }
            }
            if (primaryKey != null) {
                String keyFullId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)primaryKey), 2);
                if (this.scala) {
                    out.println();
                    ((JavaWriter)out.tab(1)).println("override def getPrimaryKey : %s[%s] = {", UniqueKey.class, recordType);
                    ((JavaWriter)out.tab(2)).println("%s", keyFullId);
                    ((JavaWriter)out.tab(1)).println("}");
                } else {
                    ((JavaWriter)out.tab(1)).overrideInherit();
                    ((JavaWriter)out.tab(1)).println("public %s<%s> getPrimaryKey() {", UniqueKey.class, recordType);
                    ((JavaWriter)out.tab(2)).println("return %s;", keyFullId);
                    ((JavaWriter)out.tab(1)).println("}");
                }
            }
            if ((uniqueKeys = table.getUniqueKeys()).size() > 0) {
                List<String> keyFullIds = out.ref(this.getStrategy().getFullJavaIdentifiers(uniqueKeys), 2);
                if (this.scala) {
                    out.println();
                    ((JavaWriter)out.tab(1)).println("override def getKeys : %s[ %s[%s] ] = {", List.class, UniqueKey.class, recordType);
                    ((JavaWriter)out.tab(2)).println("return %s.asList[ %s[%s] ]([[%s]])", Arrays.class, UniqueKey.class, recordType, keyFullIds);
                    ((JavaWriter)out.tab(1)).println("}");
                } else {
                    ((JavaWriter)out.tab(1)).overrideInherit();
                    ((JavaWriter)out.tab(1)).println("public %s<%s<%s>> getKeys() {", List.class, UniqueKey.class, recordType);
                    ((JavaWriter)out.tab(2)).println("return %s.<%s<%s>>asList([[%s]]);", Arrays.class, UniqueKey.class, recordType, keyFullIds);
                    ((JavaWriter)out.tab(1)).println("}");
                }
            }
            if ((foreignKeys = table.getForeignKeys()).size() > 0) {
                List<String> keyFullIds = out.ref(this.getStrategy().getFullJavaIdentifiers(foreignKeys), 2);
                if (this.scala) {
                    out.println();
                    ((JavaWriter)out.tab(1)).println("override def getReferences : %s[ %s[%s, _] ] = {", List.class, ForeignKey.class, recordType);
                    ((JavaWriter)out.tab(2)).println("return %s.asList[ %s[%s, _] ]([[%s]])", Arrays.class, ForeignKey.class, recordType, keyFullIds);
                    ((JavaWriter)out.tab(1)).println("}");
                } else {
                    ((JavaWriter)out.tab(1)).overrideInherit();
                    ((JavaWriter)out.tab(1)).println("public %s<%s<%s, ?>> getReferences() {", List.class, ForeignKey.class, recordType);
                    ((JavaWriter)out.tab(2)).println("return %s.<%s<%s, ?>>asList([[%s]]);", Arrays.class, ForeignKey.class, recordType, keyFullIds);
                    ((JavaWriter)out.tab(1)).println("}");
                }
            }
        }
        if (updatable) {
            String columnId;
            String columnType;
            String columnTypeFull;
            Pattern p;
            block1: for (String pattern : this.database.getRecordVersionFields()) {
                p = Pattern.compile(pattern, 4);
                for (ColumnDefinition column : table.getColumns()) {
                    if (!p.matcher(column.getName()).matches() && !p.matcher(column.getQualifiedName()).matches()) continue;
                    columnTypeFull = this.getJavaType(column.getType());
                    columnType = out.ref(columnTypeFull);
                    columnId = this.getStrategy().getJavaIdentifier((Definition)column);
                    if (this.scala) {
                        out.println();
                        this.printDeprecationIfUnknownType(out, columnTypeFull);
                        ((JavaWriter)out.tab(1)).println("override def getRecordVersion : %s[%s, %s] = {", TableField.class, recordType, columnType);
                        ((JavaWriter)out.tab(2)).println("%s", columnId);
                        ((JavaWriter)out.tab(1)).println("}");
                        break block1;
                    }
                    if (this.printDeprecationIfUnknownType(out, columnTypeFull)) {
                        ((JavaWriter)out.tab(1)).override();
                    } else {
                        ((JavaWriter)out.tab(1)).overrideInherit();
                    }
                    ((JavaWriter)out.tab(1)).println("public %s<%s, %s> getRecordVersion() {", TableField.class, recordType, columnType);
                    ((JavaWriter)out.tab(2)).println("return %s;", columnId);
                    ((JavaWriter)out.tab(1)).println("}");
                    break block1;
                }
            }
            block3: for (String pattern : this.database.getRecordTimestampFields()) {
                p = Pattern.compile(pattern, 4);
                for (ColumnDefinition column : table.getColumns()) {
                    if (!p.matcher(column.getName()).matches() && !p.matcher(column.getQualifiedName()).matches()) continue;
                    columnTypeFull = this.getJavaType(column.getType());
                    columnType = out.ref(columnTypeFull);
                    columnId = this.getStrategy().getJavaIdentifier((Definition)column);
                    if (this.scala) {
                        out.println();
                        this.printDeprecationIfUnknownType(out, columnTypeFull);
                        ((JavaWriter)out.tab(1)).println("override def getRecordTimestamp : %s[%s, %s] = {", TableField.class, recordType, columnType);
                        ((JavaWriter)out.tab(2)).println("%s", columnId);
                        ((JavaWriter)out.tab(1)).println("}");
                        break block3;
                    }
                    if (this.printDeprecationIfUnknownType(out, columnTypeFull)) {
                        ((JavaWriter)out.tab(1)).override();
                    } else {
                        ((JavaWriter)out.tab(1)).overrideInherit();
                    }
                    ((JavaWriter)out.tab(1)).println("public %s<%s, %s> getRecordTimestamp() {", TableField.class, recordType, columnType);
                    ((JavaWriter)out.tab(2)).println("return %s;", columnId);
                    ((JavaWriter)out.tab(1)).println("}");
                    break block3;
                }
            }
        }
        if (this.scala) {
            out.println();
            ((JavaWriter)out.tab(1)).println("override def as(alias : %s) : %s = {", String.class, className);
            if (table.isTableValuedFunction()) {
                ((JavaWriter)out.tab(2)).println("new %s(%s.name(alias), this, parameters)", className, DSL.class);
            } else {
                ((JavaWriter)out.tab(2)).println("new %s(%s.name(alias), this)", className, DSL.class);
            }
            ((JavaWriter)out.tab(1)).println("}");
            out.println();
            ((JavaWriter)out.tab(1)).println("override def as(alias : %s) : %s = {", Name.class, className);
            if (table.isTableValuedFunction()) {
                ((JavaWriter)out.tab(2)).println("new %s(alias, this, parameters)", className);
            } else {
                ((JavaWriter)out.tab(2)).println("new %s(alias, this)", className);
            }
            ((JavaWriter)out.tab(1)).println("}");
        } else if (this.generateInstanceFields()) {
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s as(%s alias) {", className, String.class);
            if (table.isTableValuedFunction()) {
                ((JavaWriter)out.tab(2)).println("return new %s(%s.name(alias), this, parameters);", className, DSL.class);
            } else {
                ((JavaWriter)out.tab(2)).println("return new %s(%s.name(alias), this);", className, DSL.class);
            }
            ((JavaWriter)out.tab(1)).println("}");
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s as(%s alias) {", className, Name.class);
            if (table.isTableValuedFunction()) {
                ((JavaWriter)out.tab(2)).println("return new %s(alias, this, parameters);", className);
            } else {
                ((JavaWriter)out.tab(2)).println("return new %s(alias, this);", className);
            }
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.scala) {
            ((JavaWriter)out.tab(1)).javadoc("Rename this table", new Object[0]);
            ((JavaWriter)out.tab(1)).println("override def rename(name : %s) : %s = {", String.class, className);
            if (table.isTableValuedFunction()) {
                ((JavaWriter)out.tab(2)).println("new %s(%s.name(name), null, parameters)", className, DSL.class);
            } else {
                ((JavaWriter)out.tab(2)).println("new %s(%s.name(name), null)", className, DSL.class);
            }
            ((JavaWriter)out.tab(1)).println("}");
            ((JavaWriter)out.tab(1)).javadoc("Rename this table", new Object[0]);
            ((JavaWriter)out.tab(1)).println("override def rename(name : %s) : %s = {", Name.class, className);
            if (table.isTableValuedFunction()) {
                ((JavaWriter)out.tab(2)).println("new %s(name, null, parameters)", className);
            } else {
                ((JavaWriter)out.tab(2)).println("new %s(name, null)", className);
            }
            ((JavaWriter)out.tab(1)).println("}");
        } else if (this.generateInstanceFields()) {
            ((JavaWriter)out.tab(1)).javadoc("Rename this table", new Object[0]);
            ((JavaWriter)out.tab(1)).override();
            ((JavaWriter)out.tab(1)).println("public %s rename(%s name) {", className, String.class);
            if (table.isTableValuedFunction()) {
                ((JavaWriter)out.tab(2)).println("return new %s(%s.name(name), null, parameters);", className, DSL.class);
            } else {
                ((JavaWriter)out.tab(2)).println("return new %s(%s.name(name), null);", className, DSL.class);
            }
            ((JavaWriter)out.tab(1)).println("}");
            ((JavaWriter)out.tab(1)).javadoc("Rename this table", new Object[0]);
            ((JavaWriter)out.tab(1)).override();
            ((JavaWriter)out.tab(1)).println("public %s rename(%s name) {", className, Name.class);
            if (table.isTableValuedFunction()) {
                ((JavaWriter)out.tab(2)).println("return new %s(name, null, parameters);", className);
            } else {
                ((JavaWriter)out.tab(2)).println("return new %s(name, null);", className);
            }
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (table.isTableValuedFunction()) {
            boolean parametersAsField;
            boolean[] blArray = new boolean[]{false, true};
            int n = blArray.length;
            for (int i = 0; !(i >= n || (parametersAsField = blArray[i]) && table.getParameters().size() == 0); ++i) {
                String paramTypeRef;
                String paramArgName;
                String separator;
                ((JavaWriter)out.tab(1)).javadoc("Call this table-valued function", new Object[0]);
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).print("def call(");
                    this.printParameterDeclarations(out, table, parametersAsField);
                    out.println(") : %s = {", className);
                    ((JavaWriter)out.tab(2)).println("return new %s(%s.name(getName()), null, %s(", className, DSL.class, out.ref("scala.Array"));
                    separator = "  ";
                    for (ParameterDefinition parameter : table.getParameters()) {
                        paramArgName = this.getStrategy().getJavaMemberName((Definition)parameter);
                        paramTypeRef = this.getJavaTypeReference(parameter.getDatabase(), parameter.getType());
                        ((JavaWriter)out.tab(3)).print(separator);
                        if (parametersAsField) {
                            out.println("%s", paramArgName);
                        } else {
                            out.println("%s.value(%s, %s)", DSL.class, paramArgName, paramTypeRef);
                        }
                        separator = ", ";
                    }
                    ((JavaWriter)out.tab(2)).println("));");
                    ((JavaWriter)out.tab(1)).println("}");
                    continue;
                }
                ((JavaWriter)out.tab(1)).print("public %s call(", className);
                this.printParameterDeclarations(out, table, parametersAsField);
                out.println(") {");
                ((JavaWriter)out.tab(2)).println("return new %s(%s.name(getName()), null, new %s[] { ", className, DSL.class, Field.class);
                separator = "  ";
                for (ParameterDefinition parameter : table.getParameters()) {
                    paramArgName = this.getStrategy().getJavaMemberName((Definition)parameter);
                    paramTypeRef = this.getJavaTypeReference(parameter.getDatabase(), parameter.getType());
                    ((JavaWriter)out.tab(3)).print(separator);
                    if (parametersAsField) {
                        out.println("%s", paramArgName);
                    } else {
                        out.println("%s.val(%s, %s)", DSL.class, paramArgName, paramTypeRef);
                    }
                    separator = ", ";
                }
                ((JavaWriter)out.tab(2)).println("});");
                ((JavaWriter)out.tab(1)).println("}");
            }
        }
        this.generateTableClassFooter(table, out);
        out.println("}");
        this.closeJavaWriter(out);
    }

    private String converterTemplate(List<String> converter) {
        if (converter == null || converter.isEmpty()) {
            return "[[]]";
        }
        if (converter.size() > 1) {
            throw new IllegalArgumentException();
        }
        switch (GenerationUtil.expressionType(converter.get(0))) {
            case CONSTRUCTOR_REFERENCE: {
                return "[[before=, ][new %s()]]";
            }
            case EXPRESSION: {
                return "[[before=, ][%s]]";
            }
        }
        throw new IllegalArgumentException();
    }

    private String escapeString(String comment) {
        if (comment == null) {
            return null;
        }
        return comment.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r");
    }

    protected void generateTableClassFooter(TableDefinition table, JavaWriter out) {
    }

    protected void generateTableClassJavadoc(TableDefinition table, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)table);
    }

    protected void generateSequences(SchemaDefinition schema) {
        log.info((Object)"Generating sequences");
        JavaWriter out = this.newJavaWriter(new File(this.getFile((Definition)schema).getParentFile(), "Sequences.java"));
        this.printPackage(out, (Definition)schema);
        this.printClassJavadoc(out, "Convenience access to all sequences in " + schema.getOutputName());
        this.printClassAnnotations(out, schema);
        if (this.scala) {
            out.println("object Sequences {");
        } else {
            out.println("public class Sequences {");
        }
        for (SequenceDefinition sequence : this.database.getSequences(schema)) {
            String seqTypeFull = this.getJavaType(sequence.getType());
            String seqType = out.ref(seqTypeFull);
            String seqId = this.getStrategy().getJavaIdentifier((Definition)sequence);
            String seqName = sequence.getOutputName();
            String schemaId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)schema), 2);
            String typeRef = this.getJavaTypeReference(sequence.getDatabase(), sequence.getType());
            if (!this.printDeprecationIfUnknownType(out, seqTypeFull)) {
                ((JavaWriter)out.tab(1)).javadoc("The sequence <code>%s</code>", sequence.getQualifiedOutputName());
            }
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("val %s : %s[%s] = new %s[%s](\"%s\", %s, %s)", seqId, Sequence.class, seqType, SequenceImpl.class, seqType, seqName, schemaId, typeRef);
                continue;
            }
            ((JavaWriter)out.tab(1)).println("public static final %s<%s> %s = new %s<%s>(\"%s\", %s, %s);", Sequence.class, seqType, seqId, SequenceImpl.class, seqType, seqName, schemaId, typeRef);
        }
        out.println("}");
        this.closeJavaWriter(out);
        this.watch.splitInfo("Sequences generated");
    }

    protected void generateCatalog(CatalogDefinition catalog) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)catalog));
        log.info((Object)"");
        log.info((Object)"Generating catalog", (Object)out.file().getName());
        log.info((Object)"==========================================================");
        this.generateCatalog(catalog, out);
        this.closeJavaWriter(out);
    }

    protected void generateCatalog(CatalogDefinition catalog, JavaWriter out) {
        String catalogName = catalog.getQualifiedOutputName();
        String catalogId = this.getStrategy().getJavaIdentifier((Definition)catalog);
        String className = this.getStrategy().getJavaClassName((Definition)catalog);
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)catalog, GeneratorStrategy.Mode.DEFAULT));
        this.printPackage(out, (Definition)catalog);
        if (this.scala) {
            out.println("object %s {", className);
            ((JavaWriter)out.tab(1)).javadoc("The reference instance of <code>%s</code>", catalogName);
            ((JavaWriter)out.tab(1)).println("val %s = new %s", catalogId, className);
            out.println("}");
            out.println();
        }
        this.generateCatalogClassJavadoc(catalog, out);
        this.printClassAnnotations(out, null, catalog);
        if (this.scala) {
            out.println("class %s extends %s(\"%s\")[[before= with ][separator= with ][%s]] {", className, CatalogImpl.class, catalog.getOutputName(), interfaces);
        } else {
            out.println("public class %s extends %s[[before= implements ][%s]] {", className, CatalogImpl.class, interfaces);
            out.printSerial();
            ((JavaWriter)out.tab(1)).javadoc("The reference instance of <code>%s</code>", catalogName);
            ((JavaWriter)out.tab(1)).println("public static final %s %s = new %s();", className, catalogId, className);
        }
        ArrayList<SchemaDefinition> schemas = new ArrayList<SchemaDefinition>();
        if (this.generateGlobalSchemaReferences()) {
            for (SchemaDefinition schema : catalog.getSchemata()) {
                if (!this.generateSchemaIfEmpty(schema)) continue;
                schemas.add(schema);
                String schemaClassName = out.ref(this.getStrategy().getFullJavaClassName((Definition)schema));
                String schemaId = this.getStrategy().getJavaIdentifier((Definition)schema);
                String schemaFullId = this.getStrategy().getFullJavaIdentifier((Definition)schema);
                String schemaComment = !StringUtils.isBlank((String)schema.getComment()) ? this.escapeEntities(schema.getComment()) : "The schema <code>" + schema.getQualifiedOutputName() + "</code>.";
                ((JavaWriter)out.tab(1)).javadoc(schemaComment, new Object[0]);
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("val %s = %s", schemaId, schemaFullId);
                    continue;
                }
                ((JavaWriter)out.tab(1)).println("public final %s %s = %s;", schemaClassName, schemaId, schemaFullId);
            }
        }
        if (!this.scala) {
            ((JavaWriter)out.tab(1)).javadoc(NO_FURTHER_INSTANCES_ALLOWED, new Object[0]);
            ((JavaWriter)out.tab(1)).println("private %s() {", className);
            ((JavaWriter)out.tab(2)).println("super(\"%s\");", catalog.getOutputName());
            ((JavaWriter)out.tab(1)).println("}");
        }
        this.printReferences(out, schemas, Schema.class, false);
        this.generateCatalogClassFooter(catalog, out);
        out.println("}");
    }

    protected void generateCatalogClassFooter(CatalogDefinition schema, JavaWriter out) {
    }

    protected void generateCatalogClassJavadoc(CatalogDefinition schema, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)schema);
    }

    protected void generateSchema(SchemaDefinition schema) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)schema));
        log.info((Object)"Generating schema", (Object)out.file().getName());
        log.info((Object)"----------------------------------------------------------");
        this.generateSchema(schema, out);
        this.closeJavaWriter(out);
    }

    protected void generateSchema(SchemaDefinition schema, JavaWriter out) {
        String catalogId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)schema.getCatalog()), 2);
        String schemaName = schema.getQualifiedOutputName();
        String schemaId = this.getStrategy().getJavaIdentifier((Definition)schema);
        String className = this.getStrategy().getJavaClassName((Definition)schema);
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)schema, GeneratorStrategy.Mode.DEFAULT));
        this.printPackage(out, (Definition)schema);
        if (this.scala) {
            out.println("object %s {", className);
            ((JavaWriter)out.tab(1)).javadoc("The reference instance of <code>%s</code>", schemaName);
            ((JavaWriter)out.tab(1)).println("val %s = new %s", schemaId, className);
            out.println("}");
            out.println();
        }
        this.generateSchemaClassJavadoc(schema, out);
        this.printClassAnnotations(out, schema);
        if (this.scala) {
            out.println("class %s extends %s(\"%s\", %s)[[before= with ][separator= with ][%s]] {", className, SchemaImpl.class, schema.getOutputName(), catalogId, interfaces);
        } else {
            out.println("public class %s extends %s[[before= implements ][%s]] {", className, SchemaImpl.class, interfaces);
            out.printSerial();
            ((JavaWriter)out.tab(1)).javadoc("The reference instance of <code>%s</code>", schemaName);
            ((JavaWriter)out.tab(1)).println("public static final %s %s = new %s();", className, schemaId, className);
            if (this.generateGlobalTableReferences()) {
                for (TableDefinition table : schema.getTables()) {
                    String tableClassName = out.ref(this.getStrategy().getFullJavaClassName((Definition)table));
                    String tableId = this.getStrategy().getJavaIdentifier((Definition)table);
                    String tableFullId = this.getStrategy().getFullJavaIdentifier((Definition)table);
                    String tableComment = !StringUtils.isBlank((String)table.getComment()) ? this.escapeEntities(table.getComment()) : "The table <code>" + table.getQualifiedOutputName() + "</code>.";
                    ((JavaWriter)out.tab(1)).javadoc(tableComment, new Object[0]);
                    if (this.scala) {
                        ((JavaWriter)out.tab(1)).println("val %s = %s", tableId, tableFullId);
                    } else {
                        ((JavaWriter)out.tab(1)).println("public final %s %s = %s;", tableClassName, tableId, tableFullId);
                    }
                    if (!table.isTableValuedFunction()) continue;
                    this.printTableValuedFunction(out, table, this.getStrategy().getJavaIdentifier((Definition)table));
                }
            }
            ((JavaWriter)out.tab(1)).javadoc(NO_FURTHER_INSTANCES_ALLOWED, new Object[0]);
            ((JavaWriter)out.tab(1)).println("private %s() {", className);
            ((JavaWriter)out.tab(2)).println("super(\"%s\", null);", schema.getOutputName());
            ((JavaWriter)out.tab(1)).println("}");
        }
        out.println();
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("override def getCatalog : %s = %s", Catalog.class, catalogId);
        } else {
            ((JavaWriter)out.tab(1)).overrideInherit();
            ((JavaWriter)out.tab(1)).println("public %s getCatalog() {", Catalog.class);
            ((JavaWriter)out.tab(2)).println("return %s;", catalogId);
            ((JavaWriter)out.tab(1)).println("}");
        }
        if (this.generateGlobalSequenceReferences()) {
            this.printReferences(out, this.database.getSequences(schema), Sequence.class, true);
        }
        if (this.generateGlobalTableReferences()) {
            this.printReferences(out, this.database.getTables(schema), Table.class, true);
        }
        if (this.generateGlobalUDTReferences()) {
            this.printReferences(out, this.database.getUDTs(schema), UDT.class, true);
        }
        this.generateSchemaClassFooter(schema, out);
        out.println("}");
    }

    protected void generateSchemaClassFooter(SchemaDefinition schema, JavaWriter out) {
    }

    protected void generateSchemaClassJavadoc(SchemaDefinition schema, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)schema);
    }

    protected void printFromAndInto(JavaWriter out, TableDefinition table) {
        this.printFromAndInto(out, (Definition)table);
    }

    private void printFromAndInto(JavaWriter out, Definition tableOrUDT) {
        String qualified = out.ref(this.getStrategy().getFullJavaClassName(tableOrUDT, GeneratorStrategy.Mode.INTERFACE));
        ((JavaWriter)out.tab(1)).header("FROM and INTO", new Object[0]);
        ((JavaWriter)out.tab(1)).overrideInheritIf(this.generateInterfaces() && !this.generateImmutableInterfaces());
        ((JavaWriter)out.tab(1)).println("public void from(%s from) {", qualified);
        for (TypedElementDefinition<? extends Definition> typedElementDefinition : this.getTypedElements(tableOrUDT)) {
            String setter = this.getStrategy().getJavaSetterName((Definition)typedElementDefinition, GeneratorStrategy.Mode.INTERFACE);
            String getter = this.getStrategy().getJavaGetterName((Definition)typedElementDefinition, GeneratorStrategy.Mode.INTERFACE);
            if (this.scala) {
                ((JavaWriter)out.tab(2)).println("%s(from.%s)", setter, getter);
                continue;
            }
            ((JavaWriter)out.tab(2)).println("%s(from.%s());", setter, getter);
        }
        ((JavaWriter)out.tab(1)).println("}");
        if (this.generateInterfaces() && !this.generateImmutableInterfaces()) {
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("public <E extends %s> E into(E into) {", qualified);
                ((JavaWriter)out.tab(2)).println("into.from(this)");
                ((JavaWriter)out.tab(2)).println("return into");
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).overrideInherit();
                ((JavaWriter)out.tab(1)).println("public <E extends %s> E into(E into) {", qualified);
                ((JavaWriter)out.tab(2)).println("into.from(this);");
                ((JavaWriter)out.tab(2)).println("return into;");
                ((JavaWriter)out.tab(1)).println("}");
            }
        }
    }

    protected void printReferences(JavaWriter out, List<? extends Definition> definitions, Class<?> type, boolean isGeneric) {
        if (out != null && !definitions.isEmpty()) {
            int i;
            String generic = isGeneric ? (this.scala ? "[_]" : "<?>") : "";
            List<String> references = out.ref(this.getStrategy().getFullJavaIdentifiers(definitions), 2);
            out.println();
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("override def get%ss : %s[%s%s] = {", type.getSimpleName(), List.class, type, generic);
                ((JavaWriter)out.tab(2)).println("val result = new %s[%s%s]", ArrayList.class, type, generic);
                for (i = 0; i < definitions.size(); i += 500) {
                    ((JavaWriter)out.tab(2)).println("result.addAll(get%ss%s)", type.getSimpleName(), i / 500);
                }
                ((JavaWriter)out.tab(2)).println("result");
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).override();
                ((JavaWriter)out.tab(1)).println("public final %s<%s%s> get%ss() {", List.class, type, generic, type.getSimpleName());
                ((JavaWriter)out.tab(2)).println("%s result = new %s();", List.class, ArrayList.class);
                for (i = 0; i < definitions.size(); i += 500) {
                    ((JavaWriter)out.tab(2)).println("result.addAll(get%ss%s());", type.getSimpleName(), i / 500);
                }
                ((JavaWriter)out.tab(2)).println("return result;");
                ((JavaWriter)out.tab(1)).println("}");
            }
            for (i = 0; i < definitions.size(); i += 500) {
                out.println();
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("private def get%ss%s(): %s[%s%s] = {", type.getSimpleName(), i / 500, List.class, type, generic);
                    ((JavaWriter)out.tab(2)).println("return %s.asList[%s%s]([[before=\n\t\t\t][separator=,\n\t\t\t][%s]])", Arrays.class, type, generic, references.subList(i, Math.min(i + 500, references.size())));
                    ((JavaWriter)out.tab(1)).println("}");
                    continue;
                }
                ((JavaWriter)out.tab(1)).println("private final %s<%s%s> get%ss%s() {", List.class, type, generic, type.getSimpleName(), i / 500);
                ((JavaWriter)out.tab(2)).println("return %s.<%s%s>asList([[before=\n\t\t\t][separator=,\n\t\t\t][%s]]);", Arrays.class, type, generic, references.subList(i, Math.min(i + 500, references.size())));
                ((JavaWriter)out.tab(1)).println("}");
            }
        }
    }

    protected void printTableJPAAnnotation(JavaWriter out, TableDefinition table) {
        SchemaDefinition schema = table.getSchema();
        if (this.generateJPAAnnotations()) {
            out.println("@%s", out.ref("javax.persistence.Entity"));
            out.print("@%s(name = \"", out.ref("javax.persistence.Table"));
            out.print(table.getName().replace("\"", "\\\""));
            out.print("\"");
            if (!schema.isDefaultSchema()) {
                out.print(", schema = \"");
                out.print(schema.getOutputName().replace("\"", "\\\""));
                out.print("\"");
            }
            StringBuilder sb1 = new StringBuilder();
            String glue1 = "\n";
            for (UniqueKeyDefinition uk : table.getUniqueKeys()) {
                if (uk.getKeyColumns().size() <= 1) continue;
                sb1.append(glue1);
                sb1.append("\t").append(this.scala ? "new " : "@").append(out.ref("javax.persistence.UniqueConstraint")).append("(columnNames = ").append(this.scala ? "Array(" : "{");
                String glue1Inner = "";
                for (ColumnDefinition column : uk.getKeyColumns()) {
                    sb1.append(glue1Inner);
                    sb1.append("\"");
                    sb1.append(column.getName().replace("\"", "\\\""));
                    sb1.append("\"");
                    glue1Inner = ", ";
                }
                sb1.append(this.scala ? ")" : "}").append(")");
                glue1 = ",\n";
            }
            if (sb1.length() > 0) {
                ((JavaWriter)out.print(", uniqueConstraints = ")).print(this.scala ? "Array(" : "{");
                out.println(sb1.toString());
                out.print(this.scala ? ")" : "}");
            }
            StringBuilder sb2 = new StringBuilder();
            String glue2 = "\n";
            for (IndexDefinition index : table.getIndexes()) {
                sb2.append(glue2);
                sb2.append("\t").append(this.scala ? "new " : "@").append(out.ref("javax.persistence.Index")).append("(name = \"").append(index.getOutputName().replace("\"", "\\\"")).append("\"");
                if (index.isUnique()) {
                    sb2.append(", unique = true");
                }
                sb2.append(", columnList = \"");
                String glue2Inner = "";
                for (IndexColumnDefinition column : index.getIndexColumns()) {
                    sb2.append(glue2Inner).append(column.getOutputName().replace("\"", "\\\""));
                    if (column.getSortOrder() == SortOrder.ASC) {
                        sb2.append(" ASC");
                    } else if (column.getSortOrder() == SortOrder.DESC) {
                        sb2.append(" DESC");
                    }
                    glue2Inner = ", ";
                }
                sb2.append("\")");
                glue2 = ",\n";
            }
            if (sb2.length() > 0) {
                ((JavaWriter)out.print(", indexes = ")).print(this.scala ? "Array(" : "{");
                out.println(sb2.toString());
                out.print(this.scala ? ")" : "}");
            }
            out.println(")");
        }
    }

    protected void printColumnJPAAnnotation(JavaWriter out, ColumnDefinition column) {
        if (this.generateJPAAnnotations()) {
            UniqueKeyDefinition pk = column.getPrimaryKey();
            List uks = column.getUniqueKeys();
            if (pk != null && pk.getKeyColumns().size() == 1) {
                ((JavaWriter)out.tab(1)).println("@%s", out.ref("javax.persistence.Id"));
                if (((ColumnDefinition)pk.getKeyColumns().get(0)).isIdentity()) {
                    ((JavaWriter)out.tab(1)).println("@%s(strategy = %s.IDENTITY)", out.ref("javax.persistence.GeneratedValue"), out.ref("javax.persistence.GenerationType"));
                }
            }
            String unique = "";
            for (UniqueKeyDefinition uk : uks) {
                if (uk.getKeyColumns().size() != 1) continue;
                unique = ", unique = true";
                break;
            }
            String nullable = "";
            if (!column.getType().isNullable()) {
                nullable = ", nullable = false";
            }
            String length = "";
            String precision = "";
            String scale = "";
            if (column.getType().getLength() > 0) {
                length = ", length = " + column.getType().getLength();
            } else if (column.getType().getPrecision() > 0) {
                precision = ", precision = " + column.getType().getPrecision();
                if (column.getType().getScale() > 0) {
                    scale = ", scale = " + column.getType().getScale();
                }
            }
            out.print("\t@%s(name = \"", out.ref("javax.persistence.Column"));
            out.print(column.getName().replace("\"", "\\\""));
            out.print("\"");
            out.print(unique);
            out.print(nullable);
            out.print(length);
            out.print(precision);
            out.print(scale);
            out.println(")");
        }
    }

    @Deprecated
    protected void printColumnValidationAnnotation(JavaWriter out, ColumnDefinition column) {
        this.printValidationAnnotation(out, (TypedElementDefinition<?>)column);
    }

    private void printValidationAnnotation(JavaWriter out, TypedElementDefinition<?> column) {
        if (this.generateValidationAnnotations()) {
            int length;
            DataTypeDefinition type = column.getType();
            if (!(column.getType().isNullable() || column.getType().isDefaulted() || column.getType().isIdentity())) {
                ((JavaWriter)out.tab(1)).println("@%s", out.ref("javax.validation.constraints.NotNull"));
            }
            if ("java.lang.String".equals(this.getJavaType(type)) && (length = type.getLength()) > 0) {
                ((JavaWriter)out.tab(1)).println("@%s(max = %s)", out.ref("javax.validation.constraints.Size"), length);
            }
        }
    }

    private boolean printDeprecationIfUnknownTypes(JavaWriter out, Collection<? extends ParameterDefinition> params) {
        for (ParameterDefinition parameterDefinition : params) {
            if (!this.printDeprecationIfUnknownType(out, this.getJavaType(parameterDefinition.getType()))) continue;
            return true;
        }
        return false;
    }

    private boolean printDeprecationIfUnknownType(JavaWriter out, String type) {
        return this.printDeprecationIfUnknownType(out, type, 1);
    }

    private boolean printDeprecationIfUnknownType(JavaWriter out, String type, int indentation) {
        if (this.generateDeprecationOnUnknownTypes() && "java.lang.Object".equals(type)) {
            ((JavaWriter)out.tab(indentation)).javadoc("@deprecated Unknown data type. Please define an explicit {@link org.jooq.Binding} to specify how this type should be handled. Deprecation can be turned off using <deprecationOnUnknownTypes/> in your code generator configuration.", new Object[0]);
            ((JavaWriter)out.tab(indentation)).println("@java.lang.Deprecated");
            return true;
        }
        return false;
    }

    protected void generateRoutine(SchemaDefinition schema, RoutineDefinition routine) {
        JavaWriter out = this.newJavaWriter(this.getFile((Definition)routine));
        log.info((Object)"Generating routine", (Object)out.file().getName());
        this.generateRoutine(routine, out);
        this.closeJavaWriter(out);
    }

    protected void generateRoutine(RoutineDefinition routine, JavaWriter out) {
        String isUnnamed;
        String isDefaulted;
        String paramComment;
        String paramName;
        String paramId;
        String paramTypeRef;
        String paramType;
        String paramTypeFull;
        SchemaDefinition schema = routine.getSchema();
        String className = this.getStrategy().getJavaClassName((Definition)routine);
        String returnTypeFull = routine.getReturnValue() == null ? Void.class.getName() : this.getJavaType(routine.getReturnType());
        String returnType = routine.getReturnValue() == null ? Void.class.getName() : out.ref(returnTypeFull);
        List<String> returnTypeRef = JavaGenerator.list(routine.getReturnValue() != null ? this.getJavaTypeReference(this.database, routine.getReturnType()) : null);
        List<String> returnConverter = out.ref(JavaGenerator.list(routine.getReturnValue() != null ? routine.getReturnType().getConverter() : null));
        List<String> returnBinding = out.ref(JavaGenerator.list(routine.getReturnValue() != null ? routine.getReturnType().getBinding() : null));
        List<String> interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)routine, GeneratorStrategy.Mode.DEFAULT));
        String schemaId = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)schema), 2);
        List<String> packageId = out.ref(this.getStrategy().getFullJavaIdentifiers(new Definition[]{routine.getPackage()}), 2);
        this.printPackage(out, (Definition)routine);
        if (this.scala) {
            out.println("object %s {", className);
            for (ParameterDefinition parameter : routine.getAllParameters()) {
                paramTypeFull = this.getJavaType(parameter.getType());
                paramType = out.ref(paramTypeFull);
                paramTypeRef = this.getJavaTypeReference(parameter.getDatabase(), parameter.getType());
                paramId = out.ref(this.getStrategy().getJavaIdentifier((Definition)parameter), 2);
                paramName = parameter.getName();
                paramComment = StringUtils.defaultString((String)parameter.getComment());
                isDefaulted = parameter.isDefaulted() ? "true" : "false";
                isUnnamed = parameter.isUnnamed() ? "true" : "false";
                List<String> converters = out.ref(JavaGenerator.list(parameter.getType().getConverter(), parameter.getType().getBinding()));
                if (!this.printDeprecationIfUnknownType(out, paramTypeFull)) {
                    ((JavaWriter)out.tab(1)).javadoc("The parameter <code>%s</code>.%s", parameter.getQualifiedOutputName(), StringUtils.defaultIfBlank((String)(" " + this.escapeEntities(paramComment)), (String)""));
                }
                ((JavaWriter)out.tab(1)).println("val %s : %s[%s] = %s.createParameter(\"%s\", %s, %s, %s[[before=, ][new %s]])", paramId, Parameter.class, paramType, AbstractRoutine.class, paramName, paramTypeRef, isDefaulted, isUnnamed, converters);
            }
            out.println("}");
            out.println();
        }
        if (!this.printDeprecationIfUnknownType(out, returnTypeFull, 0)) {
            this.generateRoutineClassJavadoc(routine, out);
        }
        this.printClassAnnotations(out, schema);
        if (this.scala) {
            out.println("class %s extends %s[%s](\"%s\", %s[[before=, ][%s]][[before=, ][%s]]" + this.converterTemplate(returnConverter) + this.converterTemplate(returnBinding) + ")[[before= with ][separator= with ][%s]] {", className, AbstractRoutine.class, returnType, routine.getName(), schemaId, packageId, returnTypeRef, returnConverter, returnBinding, interfaces);
        } else {
            out.println("public class %s extends %s<%s>[[before= implements ][%s]] {", className, AbstractRoutine.class, returnType, interfaces);
            out.printSerial();
            for (ParameterDefinition parameter : routine.getAllParameters()) {
                paramTypeFull = this.getJavaType(parameter.getType());
                paramType = out.ref(paramTypeFull);
                paramTypeRef = this.getJavaTypeReference(parameter.getDatabase(), parameter.getType());
                paramId = out.ref(this.getStrategy().getJavaIdentifier((Definition)parameter), 2);
                paramName = parameter.getName();
                paramComment = StringUtils.defaultString((String)parameter.getComment());
                isDefaulted = parameter.isDefaulted() ? "true" : "false";
                isUnnamed = parameter.isUnnamed() ? "true" : "false";
                List<String> converter = out.ref(JavaGenerator.list(parameter.getType().getConverter()));
                List<String> binding = out.ref(JavaGenerator.list(parameter.getType().getBinding()));
                if (!this.printDeprecationIfUnknownType(out, paramTypeFull)) {
                    ((JavaWriter)out.tab(1)).javadoc("The parameter <code>%s</code>.%s", parameter.getQualifiedOutputName(), StringUtils.defaultIfBlank((String)(" " + paramComment), (String)""));
                }
                ((JavaWriter)out.tab(1)).println("public static final %s<%s> %s = createParameter(\"%s\", %s, %s, %s" + this.converterTemplate(converter) + this.converterTemplate(binding) + ");", Parameter.class, paramType, paramId, paramName, paramTypeRef, isDefaulted, isUnnamed, converter, binding);
            }
        }
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("{");
        } else {
            ((JavaWriter)out.tab(1)).javadoc("Create a new routine call instance", new Object[0]);
            ((JavaWriter)out.tab(1)).println("public %s() {", className);
            ((JavaWriter)out.tab(2)).println("super(\"%s\", %s[[before=, ][%s]][[before=, ][%s]]" + this.converterTemplate(returnConverter) + this.converterTemplate(returnBinding) + ");", routine.getName(), schemaId, packageId, returnTypeRef, returnConverter, returnBinding);
            if (routine.getAllParameters().size() > 0) {
                out.println();
            }
        }
        for (ParameterDefinition parameter : routine.getAllParameters()) {
            String paramId2 = this.getStrategy().getJavaIdentifier((Definition)parameter);
            if (parameter.equals(routine.getReturnValue())) {
                if (this.scala) {
                    ((JavaWriter)out.tab(2)).println("setReturnParameter(%s.%s)", className, paramId2);
                    continue;
                }
                ((JavaWriter)out.tab(2)).println("setReturnParameter(%s);", paramId2);
                continue;
            }
            if (routine.getInParameters().contains(parameter)) {
                if (routine.getOutParameters().contains(parameter)) {
                    if (this.scala) {
                        ((JavaWriter)out.tab(2)).println("addInOutParameter(%s.%s)", className, paramId2);
                        continue;
                    }
                    ((JavaWriter)out.tab(2)).println("addInOutParameter(%s);", paramId2);
                    continue;
                }
                if (this.scala) {
                    ((JavaWriter)out.tab(2)).println("addInParameter(%s.%s)", className, paramId2);
                    continue;
                }
                ((JavaWriter)out.tab(2)).println("addInParameter(%s);", paramId2);
                continue;
            }
            if (this.scala) {
                ((JavaWriter)out.tab(2)).println("addOutParameter(%s.%s)", className, paramId2);
                continue;
            }
            ((JavaWriter)out.tab(2)).println("addOutParameter(%s);", paramId2);
        }
        if (routine.getOverload() != null) {
            if (this.scala) {
                ((JavaWriter)out.tab(2)).println("setOverloaded(true)");
            } else {
                ((JavaWriter)out.tab(2)).println("setOverloaded(true);");
            }
        }
        ((JavaWriter)out.tab(1)).println("}");
        for (ParameterDefinition parameter : routine.getInParameters()) {
            String setterReturnType = this.generateFluentSetters() ? className : (this.scala ? "Unit" : "void");
            String setter = this.getStrategy().getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            String numberValue = parameter.getType().isGenericNumberType() ? "Number" : "Value";
            String numberField = parameter.getType().isGenericNumberType() ? "Number" : "Field";
            String paramId3 = this.getStrategy().getJavaIdentifier((Definition)parameter);
            String paramName2 = "value".equals(paramId3) ? "value_" : "value";
            ((JavaWriter)out.tab(1)).javadoc("Set the <code>%s</code> parameter IN value to the routine", parameter.getOutputName());
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def %s(%s : %s) : Unit = {", setter, paramName2, this.refNumberType(out, parameter.getType()));
                ((JavaWriter)out.tab(2)).println("set%s(%s.%s, %s)", numberValue, className, paramId3, paramName2);
                ((JavaWriter)out.tab(1)).println("}");
            } else {
                ((JavaWriter)out.tab(1)).println("public void %s(%s %s) {", setter, this.varargsIfArray(this.refNumberType(out, parameter.getType())), paramName2);
                ((JavaWriter)out.tab(2)).println("set%s(%s, %s);", numberValue, paramId3, paramName2);
                ((JavaWriter)out.tab(1)).println("}");
            }
            if (!routine.isSQLUsable()) continue;
            ((JavaWriter)out.tab(1)).javadoc("Set the <code>%s</code> parameter to the function to be used with a {@link org.jooq.Select} statement", parameter.getOutputName());
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def %s(field : %s[%s]) : %s = {", setter, Field.class, this.refExtendsNumberType(out, parameter.getType()), setterReturnType);
                ((JavaWriter)out.tab(2)).println("set%s(%s.%s, field)", numberField, className, paramId3);
                if (this.generateFluentSetters()) {
                    ((JavaWriter)out.tab(2)).println("this");
                }
                ((JavaWriter)out.tab(1)).println("}");
                continue;
            }
            ((JavaWriter)out.tab(1)).println("public %s %s(%s<%s> field) {", setterReturnType, setter, Field.class, this.refExtendsNumberType(out, parameter.getType()));
            ((JavaWriter)out.tab(2)).println("set%s(%s, field);", numberField, paramId3);
            if (this.generateFluentSetters()) {
                ((JavaWriter)out.tab(2)).println("return this;");
            }
            ((JavaWriter)out.tab(1)).println("}");
        }
        for (ParameterDefinition parameter : routine.getAllParameters()) {
            boolean isReturnValue = parameter.equals(routine.getReturnValue());
            boolean isOutParameter = routine.getOutParameters().contains(parameter);
            if (!isOutParameter || isReturnValue) continue;
            String paramName3 = parameter.getOutputName();
            String paramTypeFull2 = this.getJavaType(parameter.getType());
            String paramType2 = out.ref(paramTypeFull2);
            String paramGetter = this.getStrategy().getJavaGetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            String paramId4 = this.getStrategy().getJavaIdentifier((Definition)parameter);
            if (!this.printDeprecationIfUnknownType(out, paramTypeFull2)) {
                ((JavaWriter)out.tab(1)).javadoc("Get the <code>%s</code> parameter OUT value from the routine", paramName3);
            }
            if (this.scala) {
                ((JavaWriter)out.tab(1)).println("def %s : %s = {", paramGetter, paramType2);
                ((JavaWriter)out.tab(2)).println("get(%s.%s)", className, paramId4);
                ((JavaWriter)out.tab(1)).println("}");
                continue;
            }
            ((JavaWriter)out.tab(1)).println("public %s %s() {", paramType2, paramGetter);
            ((JavaWriter)out.tab(2)).println("return get(%s);", paramId4);
            ((JavaWriter)out.tab(1)).println("}");
        }
        this.generateRoutineClassFooter(routine, out);
        out.println("}");
    }

    protected void generateRoutineClassFooter(RoutineDefinition routine, JavaWriter out) {
    }

    protected void generateRoutineClassJavadoc(RoutineDefinition routine, JavaWriter out) {
        this.printClassJavadoc(out, (Definition)routine);
    }

    protected void printConvenienceMethodFunctionAsField(JavaWriter out, RoutineDefinition function, boolean parametersAsField) {
        if (function.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        if (parametersAsField && function.getInParameters().isEmpty()) {
            return;
        }
        String functionTypeFull = this.getJavaType(function.getReturnType());
        String functionType = out.ref(functionTypeFull);
        String className = out.ref(this.getStrategy().getFullJavaClassName((Definition)function));
        String localVar = this.disambiguateJavaMemberName(function.getInParameters(), "f");
        if (!this.printDeprecationIfUnknownType(out, functionTypeFull) && !this.printDeprecationIfUnknownTypes(out, function.getInParameters())) {
            ((JavaWriter)out.tab(1)).javadoc("Get <code>%s</code> as a field.", function.getQualifiedOutputName());
        }
        if (this.scala) {
            ((JavaWriter)out.tab(1)).print("def %s(", this.getStrategy().getJavaMethodName((Definition)function, GeneratorStrategy.Mode.DEFAULT));
        } else {
            ((JavaWriter)out.tab(1)).print("public static %s<%s> %s(", function.isAggregate() ? AggregateFunction.class : Field.class, functionType, this.getStrategy().getJavaMethodName((Definition)function, GeneratorStrategy.Mode.DEFAULT));
        }
        String separator = "";
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.print(separator);
            if (this.scala) {
                out.print("%s : ", this.getStrategy().getJavaMemberName((Definition)parameter));
                if (parametersAsField) {
                    out.print("%s[%s]", Field.class, this.refExtendsNumberType(out, parameter.getType()));
                } else {
                    out.print(this.refNumberType(out, parameter.getType()));
                }
            } else {
                if (parametersAsField) {
                    out.print("%s<%s>", Field.class, this.refExtendsNumberType(out, parameter.getType()));
                } else {
                    out.print(this.refNumberType(out, parameter.getType()));
                }
                out.print(" %s", this.getStrategy().getJavaMemberName((Definition)parameter));
            }
            separator = ", ";
        }
        if (this.scala) {
            out.println(") : %s[%s] = {", function.isAggregate() ? AggregateFunction.class : Field.class, functionType);
            ((JavaWriter)out.tab(2)).println("val %s = new %s", localVar, className);
        } else {
            out.println(") {");
            ((JavaWriter)out.tab(2)).println("%s %s = new %s();", className, localVar, className);
        }
        for (ParameterDefinition parameter : function.getInParameters()) {
            String paramSetter = this.getStrategy().getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            String paramMember = this.getStrategy().getJavaMemberName((Definition)parameter);
            if (this.scala) {
                ((JavaWriter)out.tab(2)).println("%s.%s(%s)", localVar, paramSetter, paramMember);
                continue;
            }
            ((JavaWriter)out.tab(2)).println("%s.%s(%s);", localVar, paramSetter, paramMember);
        }
        out.println();
        if (this.scala) {
            ((JavaWriter)out.tab(2)).println("return %s.as%s", localVar, function.isAggregate() ? "AggregateFunction" : "Field");
        } else {
            ((JavaWriter)out.tab(2)).println("return %s.as%s();", localVar, function.isAggregate() ? "AggregateFunction" : "Field");
        }
        ((JavaWriter)out.tab(1)).println("}");
    }

    protected void printConvenienceMethodTableValuedFunctionAsField(JavaWriter out, TableDefinition function, boolean parametersAsField, String javaMethodName) {
        if (function.getParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        if (parametersAsField && function.getParameters().isEmpty()) {
            return;
        }
        String className = out.ref(this.getStrategy().getFullJavaClassName((Definition)function));
        if (!this.printDeprecationIfUnknownTypes(out, function.getParameters())) {
            ((JavaWriter)out.tab(1)).javadoc("Get <code>%s</code> as a table.", function.getQualifiedOutputName());
        }
        if (this.scala) {
            ((JavaWriter)out.tab(1)).print("def %s(", javaMethodName);
        } else {
            ((JavaWriter)out.tab(1)).print("public static %s %s(", className, javaMethodName);
        }
        this.printParameterDeclarations(out, function, parametersAsField);
        if (this.scala) {
            out.println(") : %s = {", className);
            ((JavaWriter)out.tab(2)).print("%s.call(", this.getStrategy().getFullJavaIdentifier((Definition)function));
        } else {
            out.println(") {");
            ((JavaWriter)out.tab(2)).print("return %s.call(", this.getStrategy().getFullJavaIdentifier((Definition)function));
        }
        String separator = "";
        for (ParameterDefinition parameter : function.getParameters()) {
            out.print(separator);
            out.print("%s", this.getStrategy().getJavaMemberName((Definition)parameter));
            separator = ", ";
        }
        if (this.scala) {
            out.println(")");
        } else {
            out.println(");");
        }
        ((JavaWriter)out.tab(1)).println("}");
    }

    private void printParameterDeclarations(JavaWriter out, TableDefinition function, boolean parametersAsField) {
        String sep1 = "";
        for (ParameterDefinition parameter : function.getParameters()) {
            out.print(sep1);
            if (this.scala) {
                out.print("%s : ", this.getStrategy().getJavaMemberName((Definition)parameter));
                if (parametersAsField) {
                    out.print("%s[%s]", Field.class, this.refExtendsNumberType(out, parameter.getType()));
                } else {
                    out.print(this.refNumberType(out, parameter.getType()));
                }
            } else {
                if (parametersAsField) {
                    out.print("%s<%s>", Field.class, this.refExtendsNumberType(out, parameter.getType()));
                } else {
                    out.print(this.refNumberType(out, parameter.getType()));
                }
                out.print(" %s", this.getStrategy().getJavaMemberName((Definition)parameter));
            }
            sep1 = ", ";
        }
    }

    private String disambiguateJavaMemberName(Collection<? extends Definition> definitions, String defaultName) {
        HashSet<String> names = new HashSet<String>();
        for (Definition definition : definitions) {
            names.add(this.getStrategy().getJavaMemberName(definition));
        }
        String name = defaultName;
        while (names.contains(name)) {
            name = name + "_";
        }
        return name;
    }

    protected void printConvenienceMethodFunction(JavaWriter out, RoutineDefinition function, boolean instance) {
        String paramMember;
        if (function.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        String className = out.ref(this.getStrategy().getFullJavaClassName((Definition)function));
        String functionName = function.getQualifiedOutputName();
        String functionTypeFull = this.getJavaType(function.getReturnType());
        String functionType = out.ref(functionTypeFull);
        String methodName = this.getStrategy().getJavaMethodName((Definition)function, GeneratorStrategy.Mode.DEFAULT);
        String configurationArgument = this.disambiguateJavaMemberName(function.getInParameters(), "configuration");
        String localVar = this.disambiguateJavaMemberName(function.getInParameters(), "f");
        if (!this.printDeprecationIfUnknownType(out, functionTypeFull) && !this.printDeprecationIfUnknownTypes(out, function.getInParameters())) {
            ((JavaWriter)out.tab(1)).javadoc("Call <code>%s</code>", functionName);
        }
        if (this.scala) {
            ((JavaWriter)out.tab(1)).print("def %s(", methodName);
        } else {
            ((JavaWriter)out.tab(1)).print("public %s%s %s(", !instance ? "static " : "", functionType, methodName);
        }
        String glue = "";
        if (!instance) {
            if (this.scala) {
                out.print("%s : %s", configurationArgument, Configuration.class);
            } else {
                out.print("%s %s", Configuration.class, configurationArgument);
            }
            glue = ", ";
        }
        for (ParameterDefinition parameter : function.getInParameters()) {
            if (instance && parameter.equals(function.getInParameters().get(0))) continue;
            String paramType = this.refNumberType(out, parameter.getType());
            paramMember = this.getStrategy().getJavaMemberName((Definition)parameter);
            if (this.scala) {
                out.print("%s%s : %s", glue, paramMember, paramType);
            } else {
                out.print("%s%s %s", glue, paramType, paramMember);
            }
            glue = ", ";
        }
        if (this.scala) {
            out.println(") : %s = {", functionType);
            ((JavaWriter)out.tab(2)).println("val %s = new %s()", localVar, className);
        } else {
            out.println(") {");
            ((JavaWriter)out.tab(2)).println("%s %s = new %s();", className, localVar, className);
        }
        for (ParameterDefinition parameter : function.getInParameters()) {
            String paramSetter = this.getStrategy().getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            String string = paramMember = instance && parameter.equals(function.getInParameters().get(0)) ? "this" : this.getStrategy().getJavaMemberName((Definition)parameter);
            if (this.scala) {
                ((JavaWriter)out.tab(2)).println("%s.%s(%s)", localVar, paramSetter, paramMember);
                continue;
            }
            ((JavaWriter)out.tab(2)).println("%s.%s(%s);", localVar, paramSetter, paramMember);
        }
        out.println();
        if (this.scala) {
            ((JavaWriter)out.tab(2)).println("%s.execute(%s)", localVar, instance ? "configuration()" : configurationArgument);
        } else {
            ((JavaWriter)out.tab(2)).println("%s.execute(%s);", localVar, instance ? "configuration()" : configurationArgument);
        }
        if (this.scala) {
            ((JavaWriter)out.tab(2)).println("%s.getReturnValue", localVar);
        } else {
            ((JavaWriter)out.tab(2)).println("return %s.getReturnValue();", localVar);
        }
        ((JavaWriter)out.tab(1)).println("}");
    }

    protected void printConvenienceMethodProcedure(JavaWriter out, RoutineDefinition procedure, boolean instance) {
        if (procedure.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Procedure " + procedure + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        String className = out.ref(this.getStrategy().getFullJavaClassName((Definition)procedure));
        String configurationArgument = this.disambiguateJavaMemberName(procedure.getInParameters(), "configuration");
        String localVar = this.disambiguateJavaMemberName(procedure.getInParameters(), "p");
        List<ParameterDefinition> outParams = JavaGenerator.list(procedure.getReturnValue(), procedure.getOutParameters());
        if (!this.printDeprecationIfUnknownTypes(out, procedure.getAllParameters())) {
            ((JavaWriter)out.tab(1)).javadoc("Call <code>%s</code>", procedure.getQualifiedOutputName());
        }
        if (this.scala) {
            ((JavaWriter)out.tab(1)).print("def ");
        } else {
            ((JavaWriter)out.tab(1)).print("public ");
            if (!instance) {
                out.print("static ");
            }
            if (outParams.size() == 0) {
                out.print("void ");
            } else if (outParams.size() == 1) {
                out.print(out.ref(this.getJavaType(outParams.get(0).getType())));
                out.print(" ");
            } else {
                out.print(className + " ");
            }
        }
        out.print(this.getStrategy().getJavaMethodName((Definition)procedure, GeneratorStrategy.Mode.DEFAULT));
        out.print("(");
        String glue = "";
        if (!instance) {
            if (this.scala) {
                out.print("%s : %s", configurationArgument, Configuration.class);
            } else {
                out.print("%s %s", Configuration.class, configurationArgument);
            }
            glue = ", ";
        }
        for (ParameterDefinition parameter : procedure.getInParameters()) {
            if (instance && parameter.equals(procedure.getInParameters().get(0))) continue;
            out.print(glue);
            if (this.scala) {
                out.print("%s : %s", this.getStrategy().getJavaMemberName((Definition)parameter), this.refNumberType(out, parameter.getType()));
            } else {
                out.print("%s %s", this.refNumberType(out, parameter.getType()), this.getStrategy().getJavaMemberName((Definition)parameter));
            }
            glue = ", ";
        }
        if (this.scala) {
            out.print(") : ");
            if (outParams.size() == 0) {
                out.print("Unit");
            } else if (outParams.size() == 1) {
                out.print(out.ref(this.getJavaType(outParams.get(0).getType())));
            } else {
                out.print(className);
            }
            out.println(" = {");
            ((JavaWriter)out.tab(2)).println("val %s = new %s", localVar, className);
        } else {
            out.println(") {");
            ((JavaWriter)out.tab(2)).println("%s %s = new %s();", className, localVar, className);
        }
        for (ParameterDefinition parameter : procedure.getInParameters()) {
            String arg;
            String setter = this.getStrategy().getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            String string = arg = instance && parameter.equals(procedure.getInParameters().get(0)) ? "this" : this.getStrategy().getJavaMemberName((Definition)parameter);
            if (this.scala) {
                ((JavaWriter)out.tab(2)).println("%s.%s(%s)", localVar, setter, arg);
                continue;
            }
            ((JavaWriter)out.tab(2)).println("%s.%s(%s);", localVar, setter, arg);
        }
        out.println();
        if (this.scala) {
            ((JavaWriter)out.tab(2)).println("%s.execute(%s)", localVar, instance ? "configuration()" : configurationArgument);
        } else {
            ((JavaWriter)out.tab(2)).println("%s.execute(%s);", localVar, instance ? "configuration()" : configurationArgument);
        }
        if (outParams.size() > 0) {
            ParameterDefinition parameter = outParams.get(0);
            String getter = parameter == procedure.getReturnValue() ? "getReturnValue" : this.getStrategy().getJavaGetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT);
            boolean isUDT = parameter.getType().isUDT();
            if (instance) {
                if (this.generateInterfaces() && isUDT) {
                    String columnTypeInterface = out.ref(this.getJavaType(parameter.getType(), GeneratorStrategy.Mode.INTERFACE));
                    if (this.scala) {
                        ((JavaWriter)out.tab(2)).println("from(%s.%s.asInstanceOf[%s])", localVar, getter, columnTypeInterface);
                    } else {
                        ((JavaWriter)out.tab(2)).println("from((%s) %s.%s());", columnTypeInterface, localVar, getter);
                    }
                } else if (this.scala) {
                    ((JavaWriter)out.tab(2)).println("from(%s.%s)", localVar, getter);
                } else {
                    ((JavaWriter)out.tab(2)).println("from(%s.%s());", localVar, getter);
                }
            }
            if (outParams.size() == 1) {
                if (this.scala) {
                    ((JavaWriter)out.tab(2)).println("return %s.%s", localVar, getter);
                } else {
                    ((JavaWriter)out.tab(2)).println("return %s.%s();", localVar, getter);
                }
            } else if (outParams.size() > 1) {
                if (this.scala) {
                    ((JavaWriter)out.tab(2)).println("return %s", localVar);
                } else {
                    ((JavaWriter)out.tab(2)).println("return %s;", localVar);
                }
            }
        }
        ((JavaWriter)out.tab(1)).println("}");
    }

    protected void printConvenienceMethodTableValuedFunction(JavaWriter out, TableDefinition function, String javaMethodName) {
        if (function.getParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        String recordClassName = out.ref(this.getStrategy().getFullJavaClassName((Definition)function, GeneratorStrategy.Mode.RECORD));
        String configurationArgument = this.disambiguateJavaMemberName(function.getParameters(), "configuration");
        if (!this.printDeprecationIfUnknownTypes(out, function.getParameters())) {
            ((JavaWriter)out.tab(1)).javadoc("Call <code>%s</code>.", function.getQualifiedOutputName());
        }
        if (this.scala) {
            ((JavaWriter)out.tab(1)).print("def %s(%s : %s", javaMethodName, configurationArgument, Configuration.class);
        } else {
            ((JavaWriter)out.tab(1)).print("public static %s<%s> %s(%s %s", Result.class, recordClassName, javaMethodName, Configuration.class, configurationArgument);
        }
        if (!function.getParameters().isEmpty()) {
            out.print(", ");
        }
        this.printParameterDeclarations(out, function, false);
        if (this.scala) {
            out.println(") : %s[%s] = {", Result.class, recordClassName);
            ((JavaWriter)out.tab(2)).print("%s.using(%s).selectFrom(%s.call(", DSL.class, configurationArgument, this.getStrategy().getFullJavaIdentifier((Definition)function));
        } else {
            out.println(") {");
            ((JavaWriter)out.tab(2)).print("return %s.using(%s).selectFrom(%s.call(", DSL.class, configurationArgument, this.getStrategy().getFullJavaIdentifier((Definition)function));
        }
        String separator = "";
        for (ParameterDefinition parameter : function.getParameters()) {
            out.print(separator);
            out.print("%s", this.getStrategy().getJavaMemberName((Definition)parameter));
            separator = ", ";
        }
        out.print(")).fetch()");
        if (this.scala) {
            out.println();
        } else {
            out.println(";");
        }
        ((JavaWriter)out.tab(1)).println("}");
    }

    protected void printRecordTypeMethod(JavaWriter out, Definition definition) {
        String className = out.ref(this.getStrategy().getFullJavaClassName(definition, GeneratorStrategy.Mode.RECORD));
        ((JavaWriter)out.tab(1)).javadoc("The class holding records for this type", new Object[0]);
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("override def getRecordType : %s[%s] = {", Class.class, className);
            ((JavaWriter)out.tab(2)).println("classOf[%s]", className);
            ((JavaWriter)out.tab(1)).println("}");
        } else {
            ((JavaWriter)out.tab(1)).override();
            ((JavaWriter)out.tab(1)).println("public %s<%s> getRecordType() {", Class.class, className);
            ((JavaWriter)out.tab(2)).println("return %s.class;", className);
            ((JavaWriter)out.tab(1)).println("}");
        }
    }

    protected void printSingletonInstance(JavaWriter out, Definition definition) {
        String className = this.getStrategy().getJavaClassName(definition);
        String identifier = this.getStrategy().getJavaIdentifier(definition);
        ((JavaWriter)out.tab(1)).javadoc("The reference instance of <code>%s</code>", definition.getQualifiedOutputName());
        if (this.scala) {
            ((JavaWriter)out.tab(1)).println("val %s = new %s", identifier, className);
        } else {
            ((JavaWriter)out.tab(1)).println("public static final %s %s = new %s();", className, identifier, className);
        }
    }

    protected final String escapeEntities(String comment) {
        if (comment == null) {
            return null;
        }
        return comment.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    protected void printClassJavadoc(JavaWriter out, Definition definition) {
        this.printClassJavadoc(out, this.escapeEntities(definition.getComment()));
    }

    protected void printClassJavadoc(JavaWriter out, String comment) {
        out.println("/**");
        if (comment != null && comment.length() > 0) {
            this.printJavadocParagraph(out, comment, "");
        } else {
            out.println(" * This class is generated by jOOQ.");
        }
        out.println(" */");
    }

    protected void printClassAnnotations(JavaWriter out, SchemaDefinition schema) {
        this.printClassAnnotations(out, schema, schema.getCatalog());
    }

    protected void printClassAnnotations(JavaWriter out, SchemaDefinition schema, CatalogDefinition catalog) {
        if (this.generateGeneratedAnnotation()) {
            out.println("@%s(", out.ref("javax.annotation.Generated"));
            if (this.useSchemaVersionProvider() || this.useCatalogVersionProvider()) {
                boolean hasSchemaVersion;
                boolean hasCatalogVersion = !StringUtils.isBlank((String)this.catalogVersions.get(catalog));
                boolean bl = hasSchemaVersion = !StringUtils.isBlank((String)this.schemaVersions.get(schema));
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("value = %s(", out.ref("scala.Array"));
                } else {
                    ((JavaWriter)out.tab(1)).println("value = {");
                }
                ((JavaWriter)out.tab(2)).println("\"http://www.jooq.org\",");
                ((JavaWriter)out.tab(2)).println("\"jOOQ version:%s\"%s", "3.10.4", hasCatalogVersion || hasSchemaVersion ? "," : "");
                if (hasCatalogVersion) {
                    ((JavaWriter)out.tab(2)).println("\"catalog version:%s\"%s", this.catalogVersions.get(catalog).replace("\"", "\\\""), hasSchemaVersion ? "," : "");
                }
                if (hasSchemaVersion) {
                    ((JavaWriter)out.tab(2)).println("\"schema version:%s\"", this.schemaVersions.get(schema).replace("\"", "\\\""));
                }
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("),");
                } else {
                    ((JavaWriter)out.tab(1)).println("},");
                }
                ((JavaWriter)out.tab(1)).println("date = \"" + this.isoDate + "\",");
                ((JavaWriter)out.tab(1)).println("comments = \"This class is generated by jOOQ\"");
            } else {
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("value = %s(", out.ref("scala.Array"));
                } else {
                    ((JavaWriter)out.tab(1)).println("value = {");
                }
                ((JavaWriter)out.tab(2)).println("\"http://www.jooq.org\",");
                ((JavaWriter)out.tab(2)).println("\"jOOQ version:%s\"", "3.10.4");
                if (this.scala) {
                    ((JavaWriter)out.tab(1)).println("),");
                } else {
                    ((JavaWriter)out.tab(1)).println("},");
                }
                ((JavaWriter)out.tab(1)).println("comments = \"This class is generated by jOOQ\"");
            }
            out.println(")");
        }
        if (!this.scala) {
            out.println("@%s({ \"all\", \"unchecked\", \"rawtypes\" })", out.ref("java.lang.SuppressWarnings"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readVersion(File file, String type) {
        String result = null;
        try (RandomAccessFile f = new RandomAccessFile(file, "r");){
            byte[] bytes = new byte[(int)f.length()];
            f.readFully(bytes);
            String string = new String(bytes);
            Matcher matcher = Pattern.compile("@(?:javax\\.annotation\\.)?Generated\\(\\s*?value\\s*?=\\s*?" + (this.scala ? "Array\\([^)]*?" : "\\{[^}]*?") + "\"" + type + " version:([^\"]*?)\"").matcher(string);
            if (matcher.find()) {
                result = matcher.group(1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    protected void printJavadocParagraph(JavaWriter out, String comment, String indent) {
        String escaped = comment.replace("/*", "/ *").replace("*/", "* /");
        this.printParagraph(out, escaped, indent + " * ");
    }

    protected void printParagraph(GeneratorWriter<?> out, String comment, String indent) {
        boolean newLine = true;
        int lineLength = 0;
        for (int i = 0; i < comment.length(); ++i) {
            if (newLine) {
                out.print(indent);
                newLine = false;
            }
            out.print(comment.charAt(i));
            ++lineLength;
            if (comment.charAt(i) == '\n') {
                lineLength = 0;
                newLine = true;
                continue;
            }
            if (lineLength <= 70 || !Character.isWhitespace(comment.charAt(i))) continue;
            out.println();
            lineLength = 0;
            newLine = true;
        }
        if (!newLine) {
            out.println();
        }
    }

    protected void printPackage(JavaWriter out, Definition definition) {
        this.printPackage(out, definition, GeneratorStrategy.Mode.DEFAULT);
    }

    protected void printPackage(JavaWriter out, Definition definition, GeneratorStrategy.Mode mode) {
        this.printPackageComment(out, definition, mode);
        if (this.scala) {
            out.println("package %s", this.getStrategy().getJavaPackageName(definition, mode));
        } else {
            out.println("package %s;", this.getStrategy().getJavaPackageName(definition, mode));
        }
        out.println();
        out.printImports();
        out.println();
    }

    protected void printPackageComment(JavaWriter out, Definition definition, GeneratorStrategy.Mode mode) {
        String header = this.getStrategy().getFileHeader(definition, mode);
        if (!StringUtils.isBlank((String)header)) {
            out.println("/*");
            this.printJavadocParagraph(out, header, "");
            out.println("*/");
        }
    }

    @Deprecated
    protected String getExtendsNumberType(DataTypeDefinition type) {
        return this.getNumberType(type, this.scala ? "_ <: " : "? extends ");
    }

    protected String refExtendsNumberType(JavaWriter out, DataTypeDefinition type) {
        if (type.isGenericNumberType()) {
            return (this.scala ? "_ <: " : "? extends ") + out.ref(Number.class);
        }
        return out.ref(this.getJavaType(type));
    }

    @Deprecated
    protected String getNumberType(DataTypeDefinition type) {
        if (type.isGenericNumberType()) {
            return Number.class.getName();
        }
        return this.getJavaType(type);
    }

    protected String refNumberType(JavaWriter out, DataTypeDefinition type) {
        if (type.isGenericNumberType()) {
            return out.ref(Number.class);
        }
        return out.ref(this.getJavaType(type));
    }

    @Deprecated
    protected String getNumberType(DataTypeDefinition type, String prefix) {
        if (type.isGenericNumberType()) {
            return prefix + Number.class.getName();
        }
        return this.getJavaType(type);
    }

    @Deprecated
    protected String getSimpleJavaType(DataTypeDefinition type) {
        return GenerationUtil.getSimpleJavaType(this.getJavaType(type));
    }

    protected String getJavaTypeReference(Database db, DataTypeDefinition type) {
        if (this.database.isArrayType(type.getType())) {
            Name baseType = GenerationUtil.getArrayBaseType(db.getDialect(), type.getType(), type.getQualifiedUserType());
            return this.getTypeReference(db, type.getSchema(), baseType.last(), 0, 0, 0, true, false, null, baseType) + ".getArrayDataType()";
        }
        return this.getTypeReference(db, type.getSchema(), type.getType(), type.getPrecision(), type.getScale(), type.getLength(), type.isNullable(), type.isIdentity(), type.getDefaultValue(), type.getQualifiedUserType());
    }

    protected String getJavaType(DataTypeDefinition type) {
        return this.getJavaType(type, GeneratorStrategy.Mode.RECORD);
    }

    protected String getJavaType(DataTypeDefinition type, GeneratorStrategy.Mode udtMode) {
        return this.getType(type.getDatabase(), type.getSchema(), type.getType(), type.getPrecision(), type.getScale(), type.getQualifiedUserType(), type.getJavaType(), Object.class.getName(), udtMode);
    }

    @Deprecated
    protected String getType(Database db, SchemaDefinition schema, String t, int p, int s, String u, String javaType, String defaultType) {
        return this.getType(db, schema, t, p, s, DSL.name((String)u), javaType, defaultType);
    }

    protected String getType(Database db, SchemaDefinition schema, String t, int p, int s, Name u, String javaType, String defaultType) {
        return this.getType(db, schema, t, p, s, u, javaType, defaultType, GeneratorStrategy.Mode.RECORD);
    }

    @Deprecated
    protected String getType(Database db, SchemaDefinition schema, String t, int p, int s, String u, String javaType, String defaultType, GeneratorStrategy.Mode udtMode) {
        return this.getType(db, schema, t, p, s, DSL.name((String)u), javaType, defaultType, udtMode);
    }

    protected String getType(Database db, SchemaDefinition schema, String t, int p, int s, Name u, String javaType, String defaultType, GeneratorStrategy.Mode udtMode) {
        String type;
        block18: {
            type = defaultType;
            if (javaType != null) {
                type = javaType;
            } else if (db.isArrayType(t)) {
                Name baseType = GenerationUtil.getArrayBaseType(db.getDialect(), t, u);
                type = this.scala ? "scala.Array[" + this.getType(db, schema, baseType.last(), p, s, baseType, javaType, defaultType, udtMode) + "]" : this.getType(db, schema, baseType.last(), p, s, baseType, javaType, defaultType, udtMode) + "[]";
            } else if (db.getArray(schema, u) != null) {
                boolean udtArray = db.getArray(schema, u).getElementType().isUDT();
                type = udtMode == GeneratorStrategy.Mode.POJO || udtMode == GeneratorStrategy.Mode.INTERFACE && !udtArray ? (this.scala ? "java.util.List[" + this.getJavaType(db.getArray(schema, u).getElementType(), udtMode) + "]" : "java.util.List<" + this.getJavaType(db.getArray(schema, u).getElementType(), udtMode) + ">") : (udtMode == GeneratorStrategy.Mode.INTERFACE ? (this.scala ? "java.util.List[_ <:" + this.getJavaType(db.getArray(schema, u).getElementType(), udtMode) + "]" : "java.util.List<? extends " + this.getJavaType(db.getArray(schema, u).getElementType(), udtMode) + ">") : this.getStrategy().getFullJavaClassName((Definition)db.getArray(schema, u), GeneratorStrategy.Mode.RECORD));
            } else if (db.getEnum(schema, u) != null) {
                type = this.getStrategy().getFullJavaClassName((Definition)db.getEnum(schema, u));
            } else if (db.getUDT(schema, u) != null) {
                type = this.getStrategy().getFullJavaClassName((Definition)db.getUDT(schema, u), udtMode);
            } else if (db.getDialect().family() == SQLDialect.POSTGRES && db.getTable(schema, u) != null) {
                type = this.getStrategy().getFullJavaClassName((Definition)db.getTable(schema, u), udtMode);
            } else if (u != null && db.getConfiguredCustomType(u.last()) != null) {
                type = u.last();
            } else {
                try {
                    Class clazz = this.mapJavaTimeTypes(DefaultDataType.getDataType((SQLDialect)db.getDialect(), (String)t, (int)p, (int)s)).getType();
                    type = this.scala && clazz == byte[].class ? "scala.Array[scala.Byte]" : clazz.getCanonicalName();
                    if (clazz.getTypeParameters().length > 0) {
                        type = type + (this.scala ? "[" : "<");
                        String separator = "";
                        for (TypeVariable var : clazz.getTypeParameters()) {
                            type = type + separator;
                            type = type + ((Class)var.getBounds()[0]).getCanonicalName();
                            separator = ", ";
                        }
                        type = type + (this.scala ? "]" : ">");
                    }
                }
                catch (SQLDialectNotSupportedException e) {
                    if (defaultType != null) break block18;
                    throw e;
                }
            }
        }
        return type;
    }

    protected String getTypeReference(Database db, SchemaDefinition schema, String t, int p, int s, int l, boolean n, boolean i, String d, Name u) {
        StringBuilder sb = new StringBuilder();
        if (db.getArray(schema, u) != null) {
            ArrayDefinition array = this.database.getArray(schema, u);
            sb.append(this.getJavaTypeReference(db, array.getElementType()));
            sb.append(".asArrayDataType(");
            sb.append(this.classOf(this.getStrategy().getFullJavaClassName((Definition)array, GeneratorStrategy.Mode.RECORD)));
            sb.append(")");
        } else if (db.getUDT(schema, u) != null) {
            sb.append(this.getStrategy().getFullJavaIdentifier((Definition)db.getUDT(schema, u)));
            sb.append(".getDataType()");
        } else if (db.getDialect().family() == SQLDialect.POSTGRES && db.getTable(schema, u) != null) {
            sb.append(this.getStrategy().getFullJavaIdentifier((Definition)db.getTable(schema, u)));
            sb.append(".getDataType()");
        } else if (db.getEnum(schema, u) != null) {
            sb.append("org.jooq.util.");
            sb.append(db.getDialect().getName().toLowerCase());
            sb.append(".");
            sb.append(db.getDialect().getName());
            sb.append("DataType.");
            sb.append(DefaultDataType.normalise((String)DefaultDataType.getDataType((SQLDialect)db.getDialect(), String.class).getTypeName()));
            sb.append(".asEnumDataType(");
            sb.append(this.classOf(this.getStrategy().getFullJavaClassName((Definition)db.getEnum(schema, u))));
            sb.append(")");
        } else {
            DataType dataType = null;
            try {
                dataType = this.mapJavaTimeTypes(DefaultDataType.getDataType((SQLDialect)db.getDialect(), (String)t, (int)p, (int)s)).nullable(n).identity(i);
                if (d != null) {
                    dataType = dataType.defaultValue(DSL.field((String)d, (DataType)dataType));
                }
            }
            catch (SQLDialectNotSupportedException sQLDialectNotSupportedException) {
                // empty catch block
            }
            if (dataType != null && dataType.getSQLDataType() != null) {
                DataType sqlDataType = dataType.getSQLDataType();
                String literal = SQLDATATYPE_LITERAL_LOOKUP.get(sqlDataType);
                String sqlDataTypeRef = SQLDataType.class.getCanonicalName() + '.' + literal;
                sb.append(sqlDataTypeRef);
                if (dataType.hasPrecision() && p > 0) {
                    if (SQLDATATYPE_WITH_PRECISION.contains(literal)) {
                        sb.append('(').append(p);
                    } else {
                        sb.append(".precision(").append(p);
                    }
                    if (dataType.hasScale() && s > 0) {
                        sb.append(", ").append(s);
                    }
                    sb.append(')');
                }
                if (dataType.hasLength() && l > 0) {
                    if (SQLDATATYPE_WITH_LENGTH.contains(literal)) {
                        sb.append("(").append(l).append(")");
                    } else {
                        sb.append(".length(").append(l).append(")");
                    }
                }
                if (!dataType.nullable()) {
                    sb.append(".nullable(false)");
                }
                if (dataType.identity()) {
                    sb.append(".identity(true)");
                }
                if (dataType.defaulted()) {
                    sb.append(".defaultValue(");
                    if (SQLDialect.MYSQL == db.getDialect().family()) {
                        if (d != null && d.toLowerCase().startsWith("current_timestamp")) {
                            sb.append("org.jooq.impl.DSL.field(\"").append(this.escapeString(d)).append("\"");
                        } else {
                            sb.append("org.jooq.impl.DSL.inline(\"").append(this.escapeString(d)).append("\"");
                        }
                    } else {
                        sb.append("org.jooq.impl.DSL.field(\"").append(this.escapeString(d)).append("\"");
                    }
                    sb.append(", ").append(sqlDataTypeRef).append("))");
                }
            } else {
                try {
                    String typeClass = db.getDialect().getName() == null ? SQLDataType.class.getName() : "org.jooq.util." + db.getDialect().getName().toLowerCase() + "." + db.getDialect().getName() + "DataType";
                    sb.append(typeClass);
                    sb.append(".");
                    String type1 = this.getType(db, schema, t, p, s, u, null, null);
                    String type2 = this.getType(db, schema, t, 0, 0, u, null, null);
                    String typeName = DefaultDataType.normalise((String)t);
                    Reflect.on((String)typeClass).field(typeName);
                    sb.append(typeName);
                    if (!type1.equals(type2)) {
                        Class clazz = this.mapJavaTimeTypes(DefaultDataType.getDataType((SQLDialect)db.getDialect(), (String)t, (int)p, (int)s)).getType();
                        sb.append(".asNumberDataType(");
                        sb.append(this.classOf(clazz.getCanonicalName()));
                        sb.append(")");
                    }
                }
                catch (SQLDialectNotSupportedException e) {
                    sb = new StringBuilder();
                    sb.append(DefaultDataType.class.getName());
                    sb.append(".getDefaultDataType(\"");
                    sb.append(t.replace("\"", "\\\""));
                    sb.append("\")");
                }
                catch (ReflectException e) {
                    sb = new StringBuilder();
                    sb.append(DefaultDataType.class.getName());
                    sb.append(".getDefaultDataType(\"");
                    sb.append(t.replace("\"", "\\\""));
                    sb.append("\")");
                }
            }
        }
        return sb.toString();
    }

    private DataType<?> mapJavaTimeTypes(DataType<?> dataType) {
        DataType result = dataType;
        if (dataType.isDateTime() && this.generateJavaTimeTypes) {
            if (dataType.getType() == Date.class) {
                result = SQLDataType.LOCALDATE;
            } else if (dataType.getType() == Time.class) {
                result = SQLDataType.LOCALTIME;
            } else if (dataType.getType() == Timestamp.class) {
                result = SQLDataType.LOCALDATETIME;
            }
        }
        return result;
    }

    @Deprecated
    protected boolean match(DataTypeDefinition type1, DataTypeDefinition type2) {
        return this.getJavaType(type1).equals(this.getJavaType(type2));
    }

    @SafeVarargs
    private static final <T> List<T> list(T ... objects) {
        ArrayList<T> result = new ArrayList<T>();
        if (objects != null) {
            for (T object : objects) {
                if (object == null || "".equals(object)) continue;
                result.add(object);
            }
        }
        return result;
    }

    private static final <T> List<T> list(T first, List<T> remaining) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(JavaGenerator.list(first));
        result.addAll(remaining);
        return result;
    }

    private static final <T> List<T> first(Collection<T> objects) {
        ArrayList<T> result;
        block0: {
            Iterator<T> iterator;
            result = new ArrayList<T>();
            if (objects == null || !(iterator = objects.iterator()).hasNext()) break block0;
            T object = iterator.next();
            result.add(object);
        }
        return result;
    }

    private static final <T> List<T> remaining(Collection<T> objects) {
        ArrayList<T> result = new ArrayList<T>();
        if (objects != null) {
            result.addAll(objects);
            if (result.size() > 0) {
                result.remove(0);
            }
        }
        return result;
    }

    private String classOf(String string) {
        if (this.scala) {
            return "classOf[" + string + "]";
        }
        return string + ".class";
    }

    private String varargsIfArray(String type) {
        if (!this.generateVarargsSetters()) {
            return type;
        }
        if (this.scala) {
            return type;
        }
        return SQUARE_BRACKETS.matcher(type).replaceFirst("...");
    }

    protected JavaWriter newJavaWriter(File file) {
        file = this.fixSuffix(file);
        return new JavaWriter(file, this.generateFullyQualifiedTypes(), this.targetEncoding);
    }

    protected File getFile(Definition definition) {
        return this.fixSuffix(this.getStrategy().getFile(definition));
    }

    protected File getFile(Definition definition, GeneratorStrategy.Mode mode) {
        return this.fixSuffix(this.getStrategy().getFile(definition, mode));
    }

    private File fixSuffix(File file) {
        if (this.scala) {
            file = new File(file.getParentFile(), file.getName().replace(".java", ".scala"));
        }
        return file;
    }

    protected void closeJavaWriter(JavaWriter out) {
        if (out.close()) {
            this.files.add(out.file());
        }
    }

    static {
        try {
            for (java.lang.reflect.Field field : SQLDataType.class.getFields()) {
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                SQLDATATYPE_LITERAL_LOOKUP.put((DataType)field.get(SQLDataType.class), field.getName());
            }
            for (AccessibleObject accessibleObject : SQLDataType.class.getMethods()) {
                if (!Modifier.isPublic(((Method)accessibleObject).getModifiers()) || !Modifier.isStatic(((Method)accessibleObject).getModifiers()) || ((Method)accessibleObject).getParameterTypes().length != 2) continue;
                SQLDATATYPE_WITH_PRECISION.add(((Method)accessibleObject).getName());
            }
            for (AccessibleObject accessibleObject : SQLDataType.class.getMethods()) {
                if (!Modifier.isPublic(((Method)accessibleObject).getModifiers()) || !Modifier.isStatic(((Method)accessibleObject).getModifiers()) || ((Method)accessibleObject).getParameterTypes().length != 1 || SQLDATATYPE_WITH_PRECISION.contains(((Method)accessibleObject).getName())) continue;
                SQLDATATYPE_WITH_LENGTH.add(((Method)accessibleObject).getName());
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        SQUARE_BRACKETS = Pattern.compile("\\[\\]$");
    }

    private class AvoidAmbiguousClassesFilter
    implements Database.Filter {
        private Map<String, String> included = new HashMap<String, String>();

        private AvoidAmbiguousClassesFilter() {
        }

        public boolean exclude(Definition definition) {
            if (definition instanceof ColumnDefinition || definition instanceof AttributeDefinition || definition instanceof ParameterDefinition) {
                return false;
            }
            String name = JavaGenerator.this.getStrategy().getFullJavaClassName(definition);
            String nameLC = name.toLowerCase();
            String existing = this.included.put(nameLC, name);
            if (existing == null) {
                return false;
            }
            log.warn((Object)"Ambiguous type name", (Object)("The object " + definition.getQualifiedOutputName() + " generates a type " + name + " which conflicts with the existing type " + existing + " on some operating systems. Use a custom generator strategy to disambiguate the types."));
            return true;
        }
    }
}

