/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.File;
import java.lang.reflect.TypeVariable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.jooq.AggregateFunction;
import org.jooq.Configuration;
import org.jooq.DataType;
import org.jooq.EnumType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.MasterDataType;
import org.jooq.Package;
import org.jooq.Parameter;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.Sequence;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UDT;
import org.jooq.UDTField;
import org.jooq.UniqueKey;
import org.jooq.conf.Settings;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.DataAccessException;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractKeys;
import org.jooq.impl.AbstractRoutine;
import org.jooq.impl.ArrayRecordImpl;
import org.jooq.impl.DAOImpl;
import org.jooq.impl.Factory;
import org.jooq.impl.FieldTypeHelper;
import org.jooq.impl.PackageImpl;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.SequenceImpl;
import org.jooq.impl.TableImpl;
import org.jooq.impl.TableRecordImpl;
import org.jooq.impl.UDTImpl;
import org.jooq.impl.UDTRecordImpl;
import org.jooq.impl.UpdatableRecordImpl;
import org.jooq.impl.UpdatableTableImpl;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StopWatch;
import org.jooq.tools.StringUtils;
import org.jooq.tools.reflect.Reflect;
import org.jooq.tools.reflect.ReflectException;
import org.jooq.util.AbstractGenerator;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.AttributeDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.Database;
import org.jooq.util.Definition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.ForeignKeyDefinition;
import org.jooq.util.GenerationUtil;
import org.jooq.util.GenerationWriter;
import org.jooq.util.GeneratorException;
import org.jooq.util.GeneratorStrategy;
import org.jooq.util.IdentityDefinition;
import org.jooq.util.MasterDataTableDefinition;
import org.jooq.util.MasterDataTypeDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ParameterDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.TypedElementDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.UniqueKeyDefinition;

public class DefaultGenerator
extends AbstractGenerator {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultGenerator.class);
    private final StopWatch watch = new StopWatch();
    private Database database;
    private GenerationWriter outS = null;
    private GenerationWriter outF = null;

    @Override
    public void generate(Database db) {
        this.database = db;
        log.info((Object)"Database parameters");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"  dialect", (Object)this.database.getDialect());
        log.info((Object)"  target dir", (Object)this.getTargetDirectory());
        log.info((Object)"  target package", (Object)this.getTargetPackage());
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"");
        log.info((Object)"DefaultGenerator parameters");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"  strategy", this.strategy.delegate.getClass());
        log.info((Object)"  deprecated", (Object)this.generateDeprecated());
        log.info((Object)"  generated annotation", (Object)this.generateGeneratedAnnotation());
        log.info((Object)"  instance fields", (Object)this.generateInstanceFields());
        log.info((Object)"  JPA annotations", (Object)this.generateJPAAnnotations());
        log.info((Object)"  validation annotations", (Object)this.generateValidationAnnotations());
        log.info((Object)"  navigation methods", (Object)this.generateNavigationMethods());
        log.info((Object)"  records", (Object)(this.generateRecords() + (!this.generateRecords && this.generateDaos ? " (forced to true because of <daos/>)" : "")));
        log.info((Object)"  pojos", (Object)(this.generatePojos() + (!this.generatePojos && this.generateDaos ? " (forced to true because of <daos/>)" : (!this.generatePojos && this.generateImmutablePojos ? " (forced to true because of <immutablePojos/>)" : ""))));
        log.info((Object)"  immutable pojos", (Object)this.generateImmutablePojos());
        log.info((Object)"  interfaces", (Object)this.generateInterfaces());
        log.info((Object)"  daos", (Object)this.generateDaos());
        log.info((Object)"  relations", (Object)this.generateRelations());
        log.info((Object)"----------------------------------------------------------");
        String targetPackage = this.getTargetPackage();
        File targetPackageDir = new File(this.getTargetDirectory() + File.separator + targetPackage.replace('.', File.separatorChar));
        log.info((Object)"Emptying", (Object)targetPackageDir.getAbsolutePath());
        this.empty(targetPackageDir);
        log.info((Object)"Generating schemata", (Object)("Total: " + this.database.getSchemata().size()));
        for (SchemaDefinition schema : this.database.getSchemata()) {
            try {
                this.generate(schema);
            }
            catch (Exception e) {
                throw new GeneratorException("Error generating code for schema " + schema, e);
            }
        }
    }

    protected void generate(SchemaDefinition schema) {
        File targetSchemaDir = this.strategy.getFile((Definition)schema).getParentFile();
        if (!schema.isDefaultSchema()) {
            this.generateSchema(schema);
        }
        if (this.database.getSequences(schema).size() > 0) {
            this.generateSequences(schema, targetSchemaDir);
        }
        if (this.database.getMasterDataTables(schema).size() > 0) {
            this.generateMasterTables(schema);
        }
        if (this.database.getTables(schema).size() > 0) {
            this.generateTables(schema);
        }
        if (this.generatePojos() && this.database.getTables(schema).size() > 0) {
            this.generatePojos(schema);
        }
        if (this.generateDaos() && this.database.getTables(schema).size() > 0) {
            this.generateDaos(schema);
        }
        if (this.database.getTables(schema).size() > 0) {
            this.generateTableReferences(schema, targetSchemaDir);
        }
        if (this.generateRelations() && this.database.getTables(schema).size() > 0) {
            this.generateRelations(schema, targetSchemaDir);
        }
        if (this.generateRecords() && this.database.getTables(schema).size() > 0) {
            this.generateRecords(schema);
        }
        if (this.generateInterfaces() && this.database.getTables(schema).size() > 0) {
            this.generateInterfaces(schema);
        }
        if (this.database.getUDTs(schema).size() > 0) {
            this.generateUDTs(schema);
        }
        if (this.database.getUDTs(schema).size() > 0) {
            this.generateUDTRecords(schema);
        }
        if (this.database.getUDTs(schema).size() > 0) {
            this.generateUDTRoutines(schema);
        }
        if (this.database.getUDTs(schema).size() > 0) {
            this.generateUDTReferences(schema, targetSchemaDir);
        }
        if (this.database.getArrays(schema).size() > 0) {
            this.generateArrays(schema);
        }
        if (this.database.getEnums(schema).size() > 0) {
            this.generateEnums(schema);
        }
        if (this.database.getRoutines(schema).size() > 0) {
            this.generateRoutines(schema, targetSchemaDir);
        }
        if (this.database.getPackages(schema).size() > 0) {
            this.generatePackages(schema);
        }
        this.close();
        this.watch.splitInfo("GENERATION FINISHED!");
    }

    protected void generateRelations(SchemaDefinition schema, File targetSchemaDir) {
        log.info((Object)"Generating Keys");
        GenerationWriter out = new GenerationWriter(new File(targetSchemaDir, "Keys.java"));
        this.printHeader(out, (Definition)schema);
        this.printClassJavadoc(out, "A class modelling foreign key relationships between tables of the <code>" + schema.getOutputName() + "</code> schema");
        out.println("public class Keys {");
        out.println();
        out.println("\t// IDENTITY definitions");
        int INITIALISER_SIZE = 500;
        ArrayList<IdentityDefinition> allIdentities = new ArrayList<IdentityDefinition>();
        ArrayList<UniqueKeyDefinition> allUniqueKeys = new ArrayList<UniqueKeyDefinition>();
        ArrayList<ForeignKeyDefinition> allForeignKeys = new ArrayList<ForeignKeyDefinition>();
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                IdentityDefinition identity = table.getIdentity();
                if (identity == null) continue;
                out.print("\tpublic static final ");
                out.print(Identity.class);
                out.print("<");
                out.print(this.strategy.getFullJavaClassName(identity.getColumn().getContainer(), GeneratorStrategy.Mode.RECORD));
                out.print(", ");
                out.print(this.getJavaType(identity.getColumn().getType()));
                out.print("> IDENTITY_");
                out.print(this.strategy.getJavaIdentifier(identity.getColumn().getContainer()));
                out.print(" = Identities");
                out.print(allIdentities.size() / 500);
                out.print(".IDENTITY_");
                out.print(this.strategy.getJavaIdentifier(identity.getColumn().getContainer()));
                out.println(";");
                allIdentities.add(identity);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table " + table), (Throwable)e);
            }
        }
        out.println();
        out.println("\t// UNIQUE and PRIMARY KEY definitions");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                List uniqueKeys = table.getUniqueKeys();
                for (UniqueKeyDefinition uniqueKey : uniqueKeys) {
                    out.print("\tpublic static final ");
                    out.print(UniqueKey.class);
                    out.print("<");
                    out.print(this.strategy.getFullJavaClassName((Definition)uniqueKey.getTable(), GeneratorStrategy.Mode.RECORD));
                    out.print("> ");
                    out.print(this.strategy.getJavaIdentifier((Definition)uniqueKey));
                    out.print(" = UniqueKeys");
                    out.print(allUniqueKeys.size() / 500);
                    out.print(".");
                    out.print(this.strategy.getJavaIdentifier((Definition)uniqueKey));
                    out.println(";");
                    allUniqueKeys.add(uniqueKey);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table " + table), (Throwable)e);
            }
        }
        out.println();
        out.println("\t// FOREIGN KEY definitions");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                List foreignKeys = table.getForeignKeys();
                for (ForeignKeyDefinition foreignKey : foreignKeys) {
                    if (foreignKey.getReferencedTable() instanceof MasterDataTableDefinition) continue;
                    out.print("\tpublic static final ");
                    out.print(ForeignKey.class);
                    out.print("<");
                    out.print(this.strategy.getFullJavaClassName((Definition)foreignKey.getKeyTable(), GeneratorStrategy.Mode.RECORD));
                    out.print(", ");
                    out.print(this.strategy.getFullJavaClassName((Definition)foreignKey.getReferencedTable(), GeneratorStrategy.Mode.RECORD));
                    out.print("> ");
                    out.print(this.strategy.getJavaIdentifier((Definition)foreignKey));
                    out.print(" = ForeignKeys");
                    out.print(allForeignKeys.size() / 500);
                    out.print(".");
                    out.print(this.strategy.getJavaIdentifier((Definition)foreignKey));
                    out.println(";");
                    allForeignKeys.add(foreignKey);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while generating reference " + table), (Throwable)e);
            }
        }
        this.printPrivateConstructor(out, "Keys");
        int identityCounter = 0;
        int uniqueKeyCounter = 0;
        int foreignKeyCounter = 0;
        for (IdentityDefinition identity : allIdentities) {
            this.generateIdentity(out, 500, identityCounter, identity);
            ++identityCounter;
        }
        if (identityCounter > 0) {
            out.println("\t}");
        }
        for (UniqueKeyDefinition uniqueKey : allUniqueKeys) {
            this.generateUniqueKey(out, 500, uniqueKeyCounter, uniqueKey);
            ++uniqueKeyCounter;
        }
        if (uniqueKeyCounter > 0) {
            out.println("\t}");
        }
        for (ForeignKeyDefinition foreignKey : allForeignKeys) {
            this.generateForeignKey(out, 500, foreignKeyCounter, foreignKey);
            ++foreignKeyCounter;
        }
        if (foreignKeyCounter > 0) {
            out.println("\t}");
        }
        out.println("}");
        out.close();
        this.watch.splitInfo("Keys generated");
    }

    protected void generateIdentity(GenerationWriter out, int INITIALISER_SIZE, int identityCounter, IdentityDefinition identity) {
        if (identityCounter % INITIALISER_SIZE == 0) {
            if (identityCounter > 0) {
                out.println("\t}");
            }
            out.println();
            out.println("\t@SuppressWarnings(\"hiding\")");
            out.print("\tprivate static class Identities");
            out.print(identityCounter / INITIALISER_SIZE);
            out.print(" extends ");
            out.print(AbstractKeys.class);
            out.println(" {");
        }
        out.print("\t\tpublic static ");
        out.print(Identity.class);
        out.print("<");
        out.print(this.strategy.getFullJavaClassName((Definition)identity.getTable(), GeneratorStrategy.Mode.RECORD));
        out.print(", ");
        out.print(this.getJavaType(identity.getColumn().getType()));
        out.print("> ");
        out.print(this.strategy.getJavaIdentifier((Definition)identity));
        out.print(" = createIdentity(");
        out.print(this.strategy.getFullJavaIdentifier(identity.getColumn().getContainer()));
        out.print(", ");
        out.print(this.strategy.getFullJavaIdentifier((Definition)identity.getColumn()));
        out.println(");");
    }

    protected void generateUniqueKey(GenerationWriter out, int INITIALISER_SIZE, int uniqueKeyCounter, UniqueKeyDefinition uniqueKey) {
        if (uniqueKeyCounter % INITIALISER_SIZE == 0) {
            if (uniqueKeyCounter > 0) {
                out.println("\t}");
            }
            out.println();
            out.print("\t@SuppressWarnings({");
            this.generateUniqueKeySuppressHidingWarning(out, uniqueKey);
            out.println("\"unchecked\"})");
            out.print("\tprivate static class UniqueKeys");
            out.print(uniqueKeyCounter / INITIALISER_SIZE);
            out.print(" extends ");
            out.print(AbstractKeys.class);
            out.println(" {");
        }
        out.print("\t\tpublic static final ");
        out.print(UniqueKey.class);
        out.print("<");
        out.print(this.strategy.getFullJavaClassName((Definition)uniqueKey.getTable(), GeneratorStrategy.Mode.RECORD));
        out.print("> ");
        out.print(this.strategy.getJavaIdentifier((Definition)uniqueKey));
        out.print(" = createUniqueKey(");
        out.print(this.strategy.getFullJavaIdentifier((Definition)uniqueKey.getTable()));
        out.print(", ");
        String separator = "";
        for (ColumnDefinition column : uniqueKey.getKeyColumns()) {
            out.print(separator);
            out.print(this.strategy.getFullJavaIdentifier((Definition)column));
            separator = ", ";
        }
        out.println(");");
    }

    protected void generateUniqueKeySuppressHidingWarning(GenerationWriter out, UniqueKeyDefinition uniqueKey) {
        out.print("\"hiding\", ");
    }

    protected void generateForeignKey(GenerationWriter out, int INITIALISER_SIZE, int foreignKeyCounter, ForeignKeyDefinition foreignKey) {
        if (foreignKeyCounter % INITIALISER_SIZE == 0) {
            if (foreignKeyCounter > 0) {
                out.println("\t}");
            }
            out.println();
            out.print("\t@SuppressWarnings({");
            this.generateForeignKeySuppressHidingWarning(out, foreignKey);
            out.println("\"unchecked\"})");
            out.print("\tprivate static class ForeignKeys");
            out.print(foreignKeyCounter / INITIALISER_SIZE);
            out.print(" extends ");
            out.print(AbstractKeys.class);
            out.println(" {");
        }
        out.print("\t\tpublic static final ");
        out.print(ForeignKey.class);
        out.print("<");
        out.print(this.strategy.getFullJavaClassName((Definition)foreignKey.getKeyTable(), GeneratorStrategy.Mode.RECORD));
        out.print(", ");
        out.print(this.strategy.getFullJavaClassName((Definition)foreignKey.getReferencedTable(), GeneratorStrategy.Mode.RECORD));
        out.print("> ");
        out.print(this.strategy.getJavaIdentifier((Definition)foreignKey));
        out.print(" = createForeignKey(");
        out.print(this.strategy.getFullJavaIdentifier((Definition)foreignKey.getReferencedKey()));
        out.print(", ");
        out.print(this.strategy.getFullJavaIdentifier((Definition)foreignKey.getKeyTable()));
        out.print(", ");
        String separator = "";
        for (ColumnDefinition column : foreignKey.getKeyColumns()) {
            out.print(separator);
            out.print(this.strategy.getFullJavaIdentifier((Definition)column));
            separator = ", ";
        }
        out.println(");");
    }

    protected void generateForeignKeySuppressHidingWarning(GenerationWriter out, ForeignKeyDefinition foreignKey) {
        out.print("\"hiding\", ");
    }

    protected void generateRecords(SchemaDefinition schema) {
        log.info((Object)"Generating records");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateRecord(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table record " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table records generated");
    }

    protected void generateRecord(TableDefinition table) {
        log.info((Object)"Generating record", (Object)this.strategy.getFileName((Definition)table, GeneratorStrategy.Mode.RECORD));
        GenerationWriter out = new GenerationWriter(this.strategy.getFile((Definition)table, GeneratorStrategy.Mode.RECORD));
        this.printHeader(out, (Definition)table, GeneratorStrategy.Mode.RECORD);
        this.printClassJavadoc(out, (Definition)table);
        this.printTableJPAAnnotation(out, table);
        Class baseClass = this.generateRelations() && table.getMainUniqueKey() != null ? UpdatableRecordImpl.class : TableRecordImpl.class;
        out.print("public class ");
        out.print(this.strategy.getJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
        out.print(" extends ");
        out.print(baseClass);
        out.print("<");
        out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
        out.print(">");
        this.printImplements(out, (Definition)table, GeneratorStrategy.Mode.RECORD, new String[0]);
        out.println(" {");
        out.printSerial();
        for (ColumnDefinition column : table.getColumns()) {
            this.printGetterAndSetter(out, (TypedElementDefinition<?>)column);
        }
        out.println();
        out.println("\t/**");
        out.println("\t * Create a detached " + this.strategy.getJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
        out.println("\t */");
        out.println("\tpublic " + this.strategy.getJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD) + "() {");
        out.print("\t\tsuper(");
        out.print(this.strategy.getFullJavaIdentifier((Definition)table));
        out.println(");");
        out.println("\t}");
        out.println("}");
        out.close();
    }

    protected void generateInterfaces(SchemaDefinition schema) {
        log.info((Object)"Generating interfaces");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateInterface(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table record " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table records generated");
    }

    protected void generateInterface(TableDefinition table) {
        log.info((Object)"Generating interface", (Object)this.strategy.getFileName((Definition)table, GeneratorStrategy.Mode.INTERFACE));
        GenerationWriter out = new GenerationWriter(this.strategy.getFile((Definition)table, GeneratorStrategy.Mode.INTERFACE));
        this.printHeader(out, (Definition)table, GeneratorStrategy.Mode.INTERFACE);
        this.printClassJavadoc(out, (Definition)table);
        this.printTableJPAAnnotation(out, table);
        out.print("public interface ");
        out.print(this.strategy.getJavaClassName((Definition)table, GeneratorStrategy.Mode.INTERFACE));
        this.printImplements(out, (Definition)table, GeneratorStrategy.Mode.INTERFACE, new String[0]);
        out.println(" {");
        for (ColumnDefinition column : table.getColumns()) {
            this.printGetterAndSetter(out, (TypedElementDefinition<?>)column, false);
        }
        out.println("}");
        out.close();
    }

    protected void generateUDTs(SchemaDefinition schema) {
        log.info((Object)"Generating UDTs");
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            try {
                this.generateUDT(schema, udt);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating udt " + udt), (Throwable)e);
            }
        }
        this.registerInSchema(this.database.getUDTs(schema), UDT.class, true);
        this.watch.splitInfo("UDTs generated");
    }

    protected void generateUDT(SchemaDefinition schema, UDTDefinition udt) {
        log.info((Object)"Generating UDT ", (Object)this.strategy.getFileName((Definition)udt));
        GenerationWriter out = new GenerationWriter(this.strategy.getFile((Definition)udt));
        this.printHeader(out, (Definition)udt);
        this.printClassJavadoc(out, (Definition)udt);
        out.print("public class ");
        out.print(this.strategy.getJavaClassName((Definition)udt));
        out.print(" extends ");
        out.print(UDTImpl.class);
        out.print("<");
        out.print(this.strategy.getFullJavaClassName((Definition)udt, GeneratorStrategy.Mode.RECORD));
        out.print(">");
        if (udt.getRoutines().size() > 0) {
            this.printImplements(out, (Definition)udt, GeneratorStrategy.Mode.DEFAULT, Package.class.getName());
        } else {
            this.printImplements(out, (Definition)udt, GeneratorStrategy.Mode.DEFAULT, new String[0]);
        }
        out.println(" {");
        out.printSerial();
        this.printSingletonInstance((Definition)udt, out);
        this.printRecordTypeMethod((Definition)udt, out);
        for (AttributeDefinition attribute : udt.getAttributes()) {
            this.printUDTColumn(out, attribute, (Definition)udt);
        }
        for (RoutineDefinition routine : udt.getRoutines()) {
            try {
                if (!routine.isSQLUsable()) {
                    this.printConvenienceMethodProcedure(out, routine, false);
                    continue;
                }
                if (!routine.isAggregate()) {
                    this.printConvenienceMethodFunction(out, routine, false);
                }
                this.printConvenienceMethodFunctionAsField(out, routine, false);
                this.printConvenienceMethodFunctionAsField(out, routine, true);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating routine " + routine), (Throwable)e);
            }
        }
        out.println();
        this.printNoFurtherInstancesAllowedJavadoc(out);
        out.println("\tprivate " + this.strategy.getJavaClassName((Definition)udt) + "() {");
        if (!schema.isDefaultSchema()) {
            out.println("\t\tsuper(\"" + udt.getOutputName() + "\", " + this.strategy.getFullJavaIdentifier((Definition)schema) + ");");
        } else {
            out.println("\t\tsuper(\"" + udt.getOutputName() + "\");");
        }
        out.println();
        out.println("\t\t// Initialise data type");
        out.println("\t\tgetDataType();");
        out.println("\t}");
        out.println("}");
        out.close();
    }

    protected void generateUDTRecords(SchemaDefinition schema) {
        log.info((Object)"Generating UDT records");
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            try {
                this.generateUDTRecord(udt);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating UDT record " + udt), (Throwable)e);
            }
        }
        this.watch.splitInfo("UDT records generated");
    }

    protected void generateUDTRecord(UDTDefinition udt) {
        log.info((Object)"Generating UDT record", (Object)this.strategy.getFileName((Definition)udt, GeneratorStrategy.Mode.RECORD));
        GenerationWriter out = new GenerationWriter(this.strategy.getFile((Definition)udt, GeneratorStrategy.Mode.RECORD));
        this.printHeader(out, (Definition)udt, GeneratorStrategy.Mode.RECORD);
        this.printClassJavadoc(out, (Definition)udt);
        out.print("public class ");
        out.print(this.strategy.getJavaClassName((Definition)udt, GeneratorStrategy.Mode.RECORD));
        out.print(" extends ");
        out.print(UDTRecordImpl.class);
        out.print("<");
        out.print(this.strategy.getFullJavaClassName((Definition)udt, GeneratorStrategy.Mode.RECORD));
        out.print(">");
        this.printImplements(out, (Definition)udt, GeneratorStrategy.Mode.RECORD, new String[0]);
        out.println(" {");
        out.printSerial();
        out.println();
        for (AttributeDefinition attribute : udt.getAttributes()) {
            this.printGetterAndSetter(out, (TypedElementDefinition<?>)attribute);
        }
        for (RoutineDefinition routine : udt.getRoutines()) {
            boolean instance = routine.getInParameters().size() > 0 && ((ParameterDefinition)routine.getInParameters().get(0)).getInputName().toUpperCase().equals("SELF");
            try {
                if (!routine.isSQLUsable()) {
                    this.printConvenienceMethodProcedure(out, routine, instance);
                    continue;
                }
                if (routine.isAggregate()) continue;
                this.printConvenienceMethodFunction(out, routine, instance);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating routine " + routine), (Throwable)e);
            }
        }
        out.println();
        out.println("\tpublic " + this.strategy.getJavaClassName((Definition)udt, GeneratorStrategy.Mode.RECORD) + "() {");
        out.print("\t\tsuper(");
        out.print(this.strategy.getFullJavaIdentifier((Definition)udt));
        out.println(");");
        out.println("\t}");
        out.println("}");
        out.close();
    }

    protected void generateUDTRoutines(SchemaDefinition schema) {
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            if (udt.getRoutines().size() <= 0) continue;
            try {
                log.info((Object)"Generating member routines");
                for (RoutineDefinition routine : udt.getRoutines()) {
                    try {
                        this.printRoutine(schema, routine);
                    }
                    catch (Exception e) {
                        log.error((Object)("Error while generating member routines " + routine), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while generating UDT " + udt), (Throwable)e);
            }
            this.watch.splitInfo("Member procedures routines");
        }
    }

    protected void generateUDTReferences(SchemaDefinition schema, File targetSchemaDir) {
        log.info((Object)"Generating UDT references");
        GenerationWriter out = new GenerationWriter(new File(targetSchemaDir, "UDTs.java"));
        this.printHeader(out, (Definition)schema);
        this.printClassJavadoc(out, "Convenience access to all UDTs in " + schema.getOutputName());
        out.println("public final class UDTs {");
        for (UDTDefinition udt : this.database.getUDTs(schema)) {
            this.generateUDTReference(out, udt);
        }
        this.printPrivateConstructor(out, "UDTs");
        out.println("}");
        out.close();
        this.watch.splitInfo("UDT references generated");
    }

    protected void generateUDTReference(GenerationWriter out, UDTDefinition udt) {
        out.println();
        out.println("\t/**");
        out.println("\t * The type " + udt.getQualifiedOutputName());
        out.println("\t */");
        out.print("\tpublic static ");
        out.print(this.strategy.getFullJavaClassName((Definition)udt));
        out.print(" ");
        out.print(this.strategy.getJavaIdentifier((Definition)udt));
        out.print(" = ");
        out.print(this.strategy.getFullJavaIdentifier((Definition)udt));
        out.println(";");
    }

    protected void generateArrays(SchemaDefinition schema) {
        log.info((Object)"Generating ARRAYs");
        for (ArrayDefinition array : this.database.getArrays(schema)) {
            try {
                this.generateArray(schema, array);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating ARRAY record " + array), (Throwable)e);
            }
        }
        this.watch.splitInfo("ARRAYs generated");
    }

    protected void generateArray(SchemaDefinition schema, ArrayDefinition array) {
        log.info((Object)"Generating ARRAY", (Object)this.strategy.getFileName((Definition)array, GeneratorStrategy.Mode.RECORD));
        GenerationWriter out = new GenerationWriter(this.strategy.getFile((Definition)array, GeneratorStrategy.Mode.RECORD));
        this.printHeader(out, (Definition)array, GeneratorStrategy.Mode.RECORD);
        this.printClassJavadoc(out, (Definition)array);
        out.print("public class ");
        out.print(this.strategy.getJavaClassName((Definition)array, GeneratorStrategy.Mode.RECORD));
        out.print(" extends ");
        out.print(ArrayRecordImpl.class);
        out.print("<");
        out.print(this.getJavaType(array.getElementType()));
        out.print(">");
        this.printImplements(out, (Definition)array, GeneratorStrategy.Mode.RECORD, new String[0]);
        out.println(" {");
        out.printSerial();
        out.println();
        out.print("\tpublic ");
        out.print(this.strategy.getJavaClassName((Definition)array, GeneratorStrategy.Mode.RECORD));
        out.print("(");
        out.print(Configuration.class);
        out.println(" configuration) {");
        out.print("\t\tsuper(");
        out.print(this.strategy.getFullJavaIdentifier((Definition)schema));
        out.print(", \"");
        out.print(array.getOutputName());
        out.print("\", ");
        out.print(this.getJavaTypeReference(this.database, array.getElementType()));
        out.println(", configuration);");
        out.println("\t}");
        out.println();
        out.print("\tpublic ");
        out.print(this.strategy.getJavaClassName((Definition)array, GeneratorStrategy.Mode.RECORD));
        out.print("(");
        out.print(Configuration.class);
        out.print(" configuration, ");
        out.print(this.getJavaType(array.getElementType()));
        out.print("... array");
        out.println(") {");
        out.println("\t\tthis(configuration);");
        out.println("\t\tset(array);");
        out.println("\t}");
        out.println();
        out.print("\tpublic ");
        out.print(this.strategy.getJavaClassName((Definition)array, GeneratorStrategy.Mode.RECORD));
        out.print("(");
        out.print(Configuration.class);
        out.print(" configuration, ");
        out.print(List.class);
        out.print("<? extends ");
        out.print(this.getJavaType(array.getElementType()));
        out.print("> list");
        out.println(") {");
        out.println("\t\tthis(configuration);");
        out.println("\t\tsetList(list);");
        out.println("\t}");
        out.println("}");
        out.close();
    }

    protected void generateEnums(SchemaDefinition schema) {
        log.info((Object)"Generating ENUMs");
        for (EnumDefinition e : this.database.getEnums(schema)) {
            try {
                this.generateEnum(e);
            }
            catch (Exception ex) {
                log.error((Object)("Error while generating enum " + e), (Throwable)ex);
            }
        }
        this.watch.splitInfo("Enums generated");
    }

    protected void generateEnum(EnumDefinition e) {
        log.info((Object)"Generating ENUM", (Object)this.strategy.getFileName((Definition)e, GeneratorStrategy.Mode.ENUM));
        GenerationWriter out = new GenerationWriter(this.strategy.getFile((Definition)e, GeneratorStrategy.Mode.ENUM));
        this.printHeader(out, (Definition)e);
        this.printClassJavadoc(out, (Definition)e);
        out.print("public enum ");
        out.print(this.strategy.getJavaClassName((Definition)e, GeneratorStrategy.Mode.ENUM));
        this.printImplements(out, (Definition)e, GeneratorStrategy.Mode.ENUM, EnumType.class.getName());
        out.print(" {");
        out.println();
        for (String literal : e.getLiterals()) {
            out.println("\t" + GenerationUtil.convertToJavaIdentifier(literal) + "(\"" + literal + "\"),");
            out.println();
        }
        out.println("\t;");
        out.println();
        out.println("\tprivate final java.lang.String literal;");
        out.println();
        out.println("\tprivate " + this.strategy.getJavaClassName((Definition)e, GeneratorStrategy.Mode.ENUM) + "(java.lang.String literal) {");
        out.println("\t\tthis.literal = literal;");
        out.println("\t}");
        out.println();
        out.println("\t@Override");
        out.println("\tpublic java.lang.String getName() {");
        if (e.isSynthetic()) {
            out.println("\t\treturn null;");
        } else {
            out.println("\t\treturn \"" + e.getName() + "\";");
        }
        out.println("\t}");
        out.println();
        out.println("\t@Override");
        out.println("\tpublic java.lang.String getLiteral() {");
        out.println("\t\treturn literal;");
        out.println("\t}");
        out.println("}");
        out.close();
    }

    protected void generateRoutines(SchemaDefinition schema, File targetSchemaDir) {
        log.info((Object)"Generating routines");
        GenerationWriter outR = new GenerationWriter(new File(targetSchemaDir, "Routines.java"));
        this.printHeader(outR, (Definition)schema);
        this.printClassJavadoc(outR, "Convenience access to all stored procedures and functions in " + schema.getOutputName());
        outR.println("public final class Routines {");
        for (RoutineDefinition routine : this.database.getRoutines(schema)) {
            try {
                this.generateRoutine(schema, outR, routine);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating routine " + routine), (Throwable)e);
            }
        }
        this.printPrivateConstructor(outR, "Routines");
        outR.println("}");
        outR.close();
        this.watch.splitInfo("Routines generated");
    }

    protected void generateRoutine(SchemaDefinition schema, GenerationWriter outR, RoutineDefinition routine) {
        this.printRoutine(schema, routine);
        if (!routine.isSQLUsable()) {
            this.printConvenienceMethodProcedure(outR, routine, false);
        } else {
            if (!routine.isAggregate()) {
                this.printConvenienceMethodFunction(outR, routine, false);
            }
            this.printConvenienceMethodFunctionAsField(outR, routine, false);
            this.printConvenienceMethodFunctionAsField(outR, routine, true);
        }
    }

    protected void generatePackages(SchemaDefinition schema) {
        log.info((Object)"Generating packages");
        for (PackageDefinition pkg : this.database.getPackages(schema)) {
            try {
                this.generatePackage(schema, pkg);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating package " + pkg), (Throwable)e);
            }
        }
        this.watch.splitInfo("Packages generated");
    }

    protected void generatePackage(SchemaDefinition schema, PackageDefinition pkg) {
        log.info((Object)"Generating package", (Object)pkg);
        for (RoutineDefinition routine : pkg.getRoutines()) {
            try {
                this.printRoutine(schema, routine);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating routine " + routine), (Throwable)e);
            }
        }
        GenerationWriter outPkg = new GenerationWriter(this.strategy.getFile((Definition)pkg));
        this.printHeader(outPkg, (Definition)pkg);
        this.printClassJavadoc(outPkg, "Convenience access to all stored procedures and functions in " + pkg.getName());
        outPkg.print("public final class ");
        outPkg.print(this.strategy.getJavaClassName((Definition)pkg));
        outPkg.print(" extends ");
        outPkg.print(PackageImpl.class);
        this.printImplements(outPkg, (Definition)pkg, GeneratorStrategy.Mode.DEFAULT, new String[0]);
        outPkg.println(" {");
        outPkg.printSerial();
        this.printSingletonInstance((Definition)pkg, outPkg);
        for (RoutineDefinition routine : pkg.getRoutines()) {
            try {
                if (!routine.isSQLUsable()) {
                    this.printConvenienceMethodProcedure(outPkg, routine, false);
                    continue;
                }
                if (!routine.isAggregate()) {
                    this.printConvenienceMethodFunction(outPkg, routine, false);
                }
                this.printConvenienceMethodFunctionAsField(outPkg, routine, false);
                this.printConvenienceMethodFunctionAsField(outPkg, routine, true);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating routine " + routine), (Throwable)e);
            }
        }
        this.printNoFurtherInstancesAllowedJavadoc(outPkg);
        outPkg.println("\tprivate " + this.strategy.getJavaClassName((Definition)pkg) + "() {");
        outPkg.print("\t\tsuper(\"");
        outPkg.print(pkg.getOutputName());
        outPkg.print("\", ");
        outPkg.print(this.strategy.getFullJavaIdentifier((Definition)schema));
        outPkg.println(");");
        outPkg.println("\t}");
        outPkg.println("}");
        outPkg.close();
    }

    protected void close() {
        if (this.outS != null) {
            this.outS.println("}");
            this.outS.close();
        }
        if (this.outF != null) {
            this.outF.println("}");
            this.outF.close();
        }
    }

    protected void generateTableReferences(SchemaDefinition schema, File targetSchemaDir) {
        GenerationWriter out;
        log.info((Object)"Generating table references");
        File file = new File(targetSchemaDir, "Tables.java");
        try {
            out = new GenerationWriter(file);
        }
        catch (Exception e) {
            log.error((Object)("Error while generating " + file), (Throwable)e);
            return;
        }
        this.printHeader(out, (Definition)schema);
        this.printClassJavadoc(out, "Convenience access to all tables in " + schema.getOutputName());
        out.println("public final class Tables {");
        for (TableDefinition table : this.database.getTables(schema)) {
            this.generateTableReference(out, table);
        }
        this.printPrivateConstructor(out, "Tables");
        out.println("}");
        out.close();
        this.watch.splitInfo("Table references generated");
    }

    protected void generateTableReference(GenerationWriter out, TableDefinition table) {
        out.println();
        out.println("\t/**");
        if (!StringUtils.isBlank((String)table.getComment())) {
            out.println("\t * " + table.getComment());
        } else {
            out.println("\t * The table " + table.getQualifiedOutputName());
        }
        out.println("\t */");
        out.print("\tpublic static final ");
        out.print(this.strategy.getFullJavaClassName((Definition)table));
        out.print(" ");
        out.print(this.strategy.getJavaIdentifier((Definition)table));
        out.print(" = ");
        out.print(this.strategy.getFullJavaIdentifier((Definition)table));
        out.println(";");
    }

    protected void generateDaos(SchemaDefinition schema) {
        log.info((Object)"Generating DAOs");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateDao(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table DAO " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table DAOs generated");
    }

    protected void generateDao(TableDefinition table) {
        List columns;
        String tType = "Void";
        String pType = this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO);
        UniqueKeyDefinition key = table.getMainUniqueKey();
        ColumnDefinition keyColumn = null;
        if (key != null && (columns = key.getKeyColumns()).size() == 1) {
            keyColumn = (ColumnDefinition)columns.get(0);
            tType = this.getJavaType(keyColumn.getType());
        }
        if (keyColumn == null) {
            log.info((Object)"Skipping DAO generation", (Object)this.strategy.getFileName((Definition)table, GeneratorStrategy.Mode.DAO));
            return;
        }
        log.info((Object)"Generating DAO", (Object)this.strategy.getFileName((Definition)table, GeneratorStrategy.Mode.DAO));
        GenerationWriter out = new GenerationWriter(this.strategy.getFile((Definition)table, GeneratorStrategy.Mode.DAO));
        this.printHeader(out, (Definition)table, GeneratorStrategy.Mode.DAO);
        this.printClassJavadoc(out, (Definition)table);
        out.print("public class ");
        out.print(this.strategy.getJavaClassName((Definition)table, GeneratorStrategy.Mode.DAO));
        out.print(" extends ");
        out.print(DAOImpl.class);
        out.print("<");
        out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
        out.print(", ");
        out.print(pType);
        out.print(", ");
        out.print(tType);
        out.println("> {");
        out.println();
        this.printJavadoc(out, "Create a new " + this.strategy.getJavaClassName((Definition)table, GeneratorStrategy.Mode.DAO) + " without any factory");
        out.print("\tpublic ");
        out.print(this.strategy.getJavaClassName((Definition)table, GeneratorStrategy.Mode.DAO));
        out.println("() {");
        out.print("\t\tsuper(");
        out.print(this.strategy.getFullJavaIdentifier((Definition)table));
        out.print(", ");
        out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO));
        out.println(".class);");
        out.println("\t}");
        out.println();
        this.printJavadoc(out, "Create a new " + this.strategy.getJavaClassName((Definition)table, GeneratorStrategy.Mode.DAO) + " with an attached factory");
        out.print("\tpublic ");
        out.print(this.strategy.getJavaClassName((Definition)table, GeneratorStrategy.Mode.DAO));
        out.print("(");
        out.print(Factory.class);
        out.println(" factory) {");
        out.print("\t\tsuper(");
        out.print(this.strategy.getFullJavaIdentifier((Definition)table));
        out.print(", ");
        out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO));
        out.println(".class, factory);");
        out.println("\t}");
        out.println();
        this.printOverride(out);
        out.print("\tprotected ");
        out.print(tType);
        out.print(" getId(");
        out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO));
        out.println(" object) {");
        out.print("\t\treturn object.");
        out.print(this.strategy.getJavaGetterName((Definition)keyColumn, GeneratorStrategy.Mode.POJO));
        out.println("();");
        out.println("\t}");
        block0: for (ColumnDefinition column : table.getColumns()) {
            out.println();
            this.printJavadoc(out, "Fetch records that have <code>" + column.getOutputName() + " IN (values)</code>");
            out.print("\tpublic ");
            out.print(List.class);
            out.print("<");
            out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO));
            out.print("> fetchBy");
            out.print(this.strategy.getJavaClassName((Definition)column, GeneratorStrategy.Mode.POJO));
            out.print("(");
            out.print(this.getJavaType(column.getType()));
            out.println("... values) {");
            out.print("\t\treturn fetch(");
            out.print(this.strategy.getFullJavaIdentifier((Definition)column));
            out.println(", values);");
            out.println("\t}");
            for (UniqueKeyDefinition uk : column.getUniqueKeys()) {
                if (uk.getKeyColumns().size() != 1 || !((ColumnDefinition)uk.getKeyColumns().get(0)).equals(column)) continue;
                out.println();
                this.printJavadoc(out, "Fetch a unique that has <code>" + column.getOutputName() + " = value</code>");
                out.print("\tpublic ");
                out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO));
                out.print(" fetchOneBy");
                out.print(this.strategy.getJavaClassName((Definition)column, GeneratorStrategy.Mode.POJO));
                out.print("(");
                out.print(this.getJavaType(column.getType()));
                out.println(" value) {");
                out.print("\t\treturn fetchOne(");
                out.print(this.strategy.getFullJavaIdentifier((Definition)column));
                out.println(", value);");
                out.println("\t}");
                continue block0;
            }
        }
        out.println("}");
        out.close();
    }

    protected void generatePojos(SchemaDefinition schema) {
        log.info((Object)"Generating table POJOs");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generatePojo(table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table POJO " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Table POJOs generated");
    }

    protected void generatePojo(TableDefinition table) {
        log.info((Object)"Generating table POJO", (Object)this.strategy.getFileName((Definition)table, GeneratorStrategy.Mode.POJO));
        GenerationWriter out = new GenerationWriter(this.strategy.getFile((Definition)table, GeneratorStrategy.Mode.POJO));
        this.printHeader(out, (Definition)table, GeneratorStrategy.Mode.POJO);
        this.printClassJavadoc(out, (Definition)table);
        this.printTableJPAAnnotation(out, table);
        out.print("public class ");
        out.print(this.strategy.getJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO));
        this.printExtends(out, (Definition)table, GeneratorStrategy.Mode.POJO);
        this.printImplements(out, (Definition)table, GeneratorStrategy.Mode.POJO, new String[0]);
        out.print(" {");
        out.println();
        out.printSerial();
        out.println();
        int maxLength = 0;
        for (ColumnDefinition column : table.getColumns()) {
            maxLength = Math.max(maxLength, this.getJavaType(column.getType()).length());
        }
        for (ColumnDefinition column : table.getColumns()) {
            this.printColumnValidationAnnotation(out, column);
            out.print("\tprivate ");
            if (this.generateImmutablePojos()) {
                out.print("final ");
            }
            out.print(StringUtils.rightPad((String)this.getJavaType(column.getType()), (int)maxLength));
            out.print(" ");
            out.print(GenerationUtil.convertToJavaIdentifier(this.strategy.getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO)));
            out.println(";");
        }
        if (this.generateImmutablePojos()) {
            out.println();
            out.print("\tpublic ");
            out.print(this.strategy.getJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO));
            out.print("(");
            String separator1 = "";
            for (ColumnDefinition column : table.getColumns()) {
                out.println(separator1);
                out.print("\t\t");
                out.print(StringUtils.rightPad((String)this.getJavaType(column.getType()), (int)maxLength));
                out.print(" ");
                out.print(GenerationUtil.convertToJavaIdentifier(this.strategy.getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO)));
                separator1 = ",";
            }
            out.println();
            out.println("\t) {");
            for (ColumnDefinition column : table.getColumns()) {
                out.print("\t\tthis.");
                out.print(GenerationUtil.convertToJavaIdentifier(this.strategy.getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO)));
                out.print(" = ");
                out.print(GenerationUtil.convertToJavaIdentifier(this.strategy.getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO)));
                out.println(";");
            }
            out.println("\t}");
        }
        for (ColumnDefinition column : table.getColumns()) {
            out.println();
            this.printColumnJPAAnnotation(out, column);
            if (this.generateInterfaces()) {
                this.printOverride(out);
            }
            out.print("\tpublic ");
            out.print(this.getJavaType(column.getType()));
            out.print(" ");
            out.print(this.strategy.getJavaGetterName((Definition)column, GeneratorStrategy.Mode.POJO));
            out.println("() {");
            out.print("\t\treturn this.");
            out.print(GenerationUtil.convertToJavaIdentifier(this.strategy.getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO)));
            out.println(";");
            out.println("\t}");
            if (this.generateImmutablePojos()) continue;
            out.println();
            if (this.generateInterfaces()) {
                this.printOverride(out);
            }
            out.print("\tpublic void ");
            out.print(this.strategy.getJavaSetterName((Definition)column, GeneratorStrategy.Mode.POJO));
            out.print("(");
            out.print(this.getJavaType(column.getType()));
            out.print(" ");
            out.print(GenerationUtil.convertToJavaIdentifier(this.strategy.getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO)));
            out.println(") {");
            out.print("\t\tthis.");
            out.print(GenerationUtil.convertToJavaIdentifier(this.strategy.getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO)));
            out.print(" = ");
            out.print(GenerationUtil.convertToJavaIdentifier(this.strategy.getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO)));
            out.println(";");
            out.println("\t}");
        }
        out.println("}");
        out.close();
    }

    protected void generateTables(SchemaDefinition schema) {
        log.info((Object)"Generating tables");
        for (TableDefinition table : this.database.getTables(schema)) {
            try {
                this.generateTable(schema, table);
            }
            catch (Exception e) {
                log.error((Object)("Error while generating table " + table), (Throwable)e);
            }
        }
        this.registerInSchema(this.database.getTables(schema), Table.class, true);
        this.watch.splitInfo("Tables generated");
    }

    protected void generateTable(SchemaDefinition schema, TableDefinition table) {
        log.info((Object)"Generating table", (Object)this.strategy.getFileName((Definition)table));
        GenerationWriter out = new GenerationWriter(this.strategy.getFile((Definition)table));
        this.printHeader(out, (Definition)table);
        this.printClassJavadoc(out, (Definition)table);
        Class baseClass = this.generateRelations() && table.getMainUniqueKey() != null ? UpdatableTableImpl.class : TableImpl.class;
        out.print("public class ");
        out.print(this.strategy.getJavaClassName((Definition)table));
        out.print(" extends ");
        out.print(baseClass);
        out.print("<");
        out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
        out.print(">");
        this.printImplements(out, (Definition)table, GeneratorStrategy.Mode.DEFAULT, new String[0]);
        out.println(" {");
        out.printSerial();
        this.printSingletonInstance((Definition)table, out);
        this.printRecordTypeMethod((Definition)table, out);
        for (ColumnDefinition column : table.getColumns()) {
            this.printTableColumn(out, column, (Definition)table);
        }
        out.println();
        if (this.generateInstanceFields()) {
            out.print("\tpublic ");
        } else {
            this.printNoFurtherInstancesAllowedJavadoc(out);
            out.print("\tprivate ");
        }
        out.println(this.strategy.getJavaClassName((Definition)table) + "() {");
        if (!schema.isDefaultSchema()) {
            out.println("\t\tsuper(\"" + table.getOutputName() + "\", " + this.strategy.getFullJavaIdentifier((Definition)schema) + ");");
        } else {
            out.println("\t\tsuper(\"" + table.getOutputName() + "\");");
        }
        out.println("\t}");
        if (this.generateInstanceFields()) {
            out.println();
            out.print("\tpublic ");
            out.print(this.strategy.getJavaClassName((Definition)table));
            out.print("(");
            out.print(String.class);
            out.println(" alias) {");
            out.print("\t\tsuper(alias, ");
            if (schema.isDefaultSchema()) {
                out.print("null");
            } else {
                out.print(this.strategy.getFullJavaIdentifier((Definition)schema));
            }
            out.print(", ");
            out.print(this.strategy.getFullJavaIdentifier((Definition)table));
            out.println(");");
            out.println("\t}");
        }
        if (this.generateRelations()) {
            List foreignKeys;
            List uniqueKeys;
            UniqueKeyDefinition mainKey;
            IdentityDefinition identity = table.getIdentity();
            if (identity != null) {
                out.println();
                out.println("\t@Override");
                out.print("\tpublic ");
                out.print(Identity.class);
                out.print("<");
                out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
                out.print(", ");
                out.print(this.getJavaType(identity.getColumn().getType()));
                out.println("> getIdentity() {");
                out.print("\t\treturn ");
                out.print(this.strategy.getFullJavaIdentifier((Definition)identity));
                out.println(";");
                out.println("\t}");
            }
            if ((mainKey = table.getMainUniqueKey()) != null) {
                out.println();
                out.println("\t@Override");
                out.print("\tpublic ");
                out.print(UniqueKey.class);
                out.print("<");
                out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
                out.println("> getMainKey() {");
                out.print("\t\treturn ");
                out.print(this.strategy.getFullJavaIdentifier((Definition)mainKey));
                out.println(";");
                out.println("\t}");
            }
            if ((uniqueKeys = table.getUniqueKeys()).size() > 0) {
                out.println();
                out.println("\t@Override");
                out.println("\t@SuppressWarnings(\"unchecked\")");
                out.print("\tpublic ");
                out.print(List.class);
                out.print("<");
                out.print(UniqueKey.class);
                out.print("<");
                out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
                out.println(">> getKeys() {");
                out.print("\t\treturn ");
                out.print(Arrays.class);
                out.print(".<");
                out.print(UniqueKey.class);
                out.print("<");
                out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
                out.print(">>asList(");
                String separator = "";
                for (UniqueKeyDefinition uniqueKey : uniqueKeys) {
                    out.print(separator);
                    out.print(this.strategy.getFullJavaIdentifier((Definition)uniqueKey));
                    separator = ", ";
                }
                out.println(");");
                out.println("\t}");
            }
            if ((foreignKeys = table.getForeignKeys()).size() > 0) {
                out.println();
                out.println("\t@Override");
                out.println("\t@SuppressWarnings(\"unchecked\")");
                out.print("\tpublic ");
                out.print(List.class);
                out.print("<");
                out.print(ForeignKey.class);
                out.print("<");
                out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
                out.println(", ?>> getReferences() {");
                out.print("\t\treturn ");
                out.print(Arrays.class);
                out.print(".<");
                out.print(ForeignKey.class);
                out.print("<");
                out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
                out.print(", ?>>asList(");
                String separator = "";
                for (ForeignKeyDefinition foreignKey : foreignKeys) {
                    TableDefinition referencedTable = foreignKey.getReferencedTable();
                    if (referencedTable instanceof MasterDataTableDefinition) continue;
                    out.print(separator);
                    out.print(this.strategy.getFullJavaIdentifier((Definition)foreignKey));
                    separator = ", ";
                }
                out.println(");");
                out.println("\t}");
            }
        }
        if (baseClass == UpdatableTableImpl.class) {
            block3: for (String pattern : this.database.getRecordVersionFields()) {
                for (ColumnDefinition column : table.getColumns()) {
                    if (!column.getName().matches(pattern.trim()) && !column.getQualifiedName().matches(pattern.trim())) continue;
                    out.println();
                    out.println("\t@Override");
                    out.print("\tpublic ");
                    out.print(TableField.class);
                    out.print("<");
                    out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
                    out.print(", ");
                    out.print(this.getJavaType(column.getType()));
                    out.println("> getRecordVersion() {");
                    out.print("\t\treturn ");
                    out.print(this.strategy.getFullJavaIdentifier((Definition)column));
                    out.println(";");
                    out.println("\t}");
                    break block3;
                }
            }
            block5: for (String pattern : this.database.getRecordTimestampFields()) {
                for (ColumnDefinition column : table.getColumns()) {
                    if (!column.getName().matches(pattern.trim()) && !column.getQualifiedName().matches(pattern.trim())) continue;
                    out.println();
                    out.println("\t@Override");
                    out.print("\tpublic ");
                    out.print(TableField.class);
                    out.print("<");
                    out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
                    out.print(", ");
                    out.print(this.getJavaType(column.getType()));
                    out.println("> getRecordTimestamp() {");
                    out.print("\t\treturn ");
                    out.print(this.strategy.getFullJavaIdentifier((Definition)column));
                    out.println(";");
                    out.println("\t}");
                    break block5;
                }
            }
        }
        if (this.generateInstanceFields()) {
            out.println();
            out.println("\t@Override");
            out.print("\tpublic ");
            out.print(this.strategy.getFullJavaClassName((Definition)table));
            out.print(" as(");
            out.print(String.class);
            out.println(" alias) {");
            out.print("\t\treturn new ");
            out.print(this.strategy.getFullJavaClassName((Definition)table));
            out.println("(alias);");
            out.println("\t}");
        }
        out.printStaticInitialisationStatementsPlaceholder();
        out.println("}");
        out.close();
    }

    protected void generateMasterTables(SchemaDefinition schema) {
        log.info((Object)"Generating master data");
        for (MasterDataTableDefinition table : this.database.getMasterDataTables(schema)) {
            try {
                this.generateMasterTable(table);
            }
            catch (Exception e) {
                log.error((Object)("Exception while generating master data table " + table), (Throwable)e);
            }
        }
        this.watch.splitInfo("Master data generated");
    }

    protected void generateMasterTable(MasterDataTableDefinition table) {
        log.info((Object)"Generating table", (Object)this.strategy.getFileName((Definition)table));
        GenerationWriter out = new GenerationWriter(this.strategy.getFile((Definition)table));
        this.printHeader(out, (Definition)table);
        this.printClassJavadoc(out, (Definition)table);
        ColumnDefinition pk = table.getPrimaryKeyColumn();
        ColumnDefinition l = table.getLiteralColumn();
        ColumnDefinition d = table.getDescriptionColumn();
        Result data = table.getData();
        out.print("public enum ");
        out.print(this.strategy.getJavaClassName((Definition)table));
        this.printImplements(out, (Definition)table, GeneratorStrategy.Mode.ENUM, MasterDataType.class.getName() + "<" + this.getJavaType(pk.getType()) + ">");
        out.println(" {");
        LinkedHashSet<ColumnDefinition> columns = new LinkedHashSet<ColumnDefinition>(Arrays.asList(pk, l, d));
        for (Record record : data) {
            String literal = record.getValueAsString(l.getName());
            String description = record.getValueAsString(d.getName());
            if (!StringUtils.isEmpty((String)description)) {
                out.println();
                out.println("\t/**");
                out.println("\t * " + description);
                out.println("\t */");
            }
            out.print("\t");
            out.print(GenerationUtil.convertToJavaIdentifier(literal));
            out.print("(");
            String separator = "";
            for (ColumnDefinition column : columns) {
                out.print(separator);
                out.printNewJavaObject(this.getJavaType(column.getType()), record.getValue(column.getName()));
                separator = ", ";
            }
            out.println("),");
        }
        out.println("\t;");
        out.println();
        for (ColumnDefinition column : columns) {
            out.print("\tprivate final ");
            out.print(this.getJavaType(column.getType()));
            out.print(" ");
            out.println(this.strategy.getJavaMemberName((Definition)column) + ";");
        }
        out.println();
        out.print("\tprivate " + this.strategy.getJavaClassName((Definition)table) + "(");
        String separator = "";
        for (ColumnDefinition column : columns) {
            out.print(separator);
            out.print(this.getJavaType(column.getType()));
            out.print(" ");
            out.print(this.strategy.getJavaMemberName((Definition)column));
            separator = ", ";
        }
        out.println(") {");
        for (ColumnDefinition column : columns) {
            out.print("\t\tthis.");
            out.print(this.strategy.getJavaMemberName((Definition)column));
            out.print(" = ");
            out.print(this.strategy.getJavaMemberName((Definition)column));
            out.println(";");
        }
        out.println("\t}");
        out.println();
        this.printOverride(out);
        out.print("\tpublic ");
        out.print(this.getJavaType(pk.getType()));
        out.println(" getPrimaryKey() {");
        out.println("\t\treturn " + this.strategy.getJavaMemberName((Definition)pk) + ";");
        out.println("\t}");
        for (ColumnDefinition column : columns) {
            this.printFieldJavaDoc(out, (TypedElementDefinition<?>)column);
            out.print("\tpublic final ");
            out.print(this.getJavaType(column.getType()));
            out.print(" ");
            out.print(this.strategy.getJavaGetterName((Definition)column, GeneratorStrategy.Mode.DEFAULT));
            out.println("() {");
            out.print("\t\treturn ");
            out.print(this.strategy.getJavaMemberName((Definition)column));
            out.println(";");
            out.println("\t}");
        }
        out.println("}");
        out.close();
    }

    protected void generateSequences(SchemaDefinition schema, File targetSchemaDir) {
        log.info((Object)"Generating sequences");
        GenerationWriter out = new GenerationWriter(new File(targetSchemaDir, "Sequences.java"));
        this.printHeader(out, (Definition)schema);
        this.printClassJavadoc(out, "Convenience access to all sequences in " + schema.getOutputName());
        out.println("public final class Sequences {");
        for (SequenceDefinition sequence : this.database.getSequences(schema)) {
            out.println();
            out.println("\t/**");
            out.println("\t * The sequence " + sequence.getQualifiedOutputName());
            out.println("\t */");
            out.print("\tpublic static final ");
            out.print(Sequence.class);
            out.print("<");
            out.print(this.getJavaType(sequence.getType()));
            out.print(">");
            out.print(" ");
            out.print(this.strategy.getJavaIdentifier((Definition)sequence));
            out.print(" = new ");
            out.print(SequenceImpl.class);
            out.print("<");
            out.print(this.getJavaType(sequence.getType()));
            out.print(">");
            out.print("(\"");
            out.print(sequence.getOutputName());
            out.print("\"");
            if (!schema.isDefaultSchema()) {
                out.print(", ");
                out.print(this.strategy.getFullJavaIdentifier((Definition)schema));
            } else {
                out.print(", null");
            }
            out.print(", ");
            out.print(this.getJavaTypeReference(sequence.getDatabase(), sequence.getType()));
            out.println(");");
        }
        this.printPrivateConstructor(out, "Sequences");
        out.println("}");
        out.close();
        this.registerInSchema(this.database.getSequences(schema), Sequence.class, true);
        this.watch.splitInfo("Sequences generated");
    }

    protected void generateSchema(SchemaDefinition schema) {
        log.info((Object)"Generating schema", (Object)this.strategy.getFileName((Definition)schema));
        log.info((Object)"----------------------------------------------------------");
        this.outS = new GenerationWriter(this.strategy.getFile((Definition)schema));
        this.printHeader(this.outS, (Definition)schema);
        this.printClassJavadoc(this.outS, (Definition)schema);
        this.outS.print("public class ");
        this.outS.print(this.strategy.getJavaClassName((Definition)schema));
        this.outS.print(" extends ");
        this.outS.print(SchemaImpl.class);
        this.printImplements(this.outS, (Definition)schema, GeneratorStrategy.Mode.DEFAULT, new String[0]);
        this.outS.println(" {");
        this.outS.printSerial();
        this.outS.println();
        this.outS.println("\t/**");
        this.outS.println("\t * The singleton instance of " + schema.getQualifiedOutputName());
        this.outS.println("\t */");
        this.outS.println("\tpublic static final " + this.strategy.getJavaClassName((Definition)schema) + " " + this.strategy.getJavaIdentifier((Definition)schema) + " = new " + this.strategy.getJavaClassName((Definition)schema) + "();");
        this.outS.println();
        this.printNoFurtherInstancesAllowedJavadoc(this.outS);
        this.outS.println("\tprivate " + this.strategy.getJavaClassName((Definition)schema) + "() {");
        this.outS.println("\t\tsuper(\"" + schema.getOutputName() + "\");");
        this.outS.println("\t}");
        this.outS.printInitialisationStatementsPlaceholder();
        log.info((Object)"Generating factory", (Object)this.strategy.getFileName((Definition)schema, GeneratorStrategy.Mode.FACTORY));
        this.outF = new GenerationWriter(this.strategy.getFile((Definition)schema, GeneratorStrategy.Mode.FACTORY));
        this.printHeader(this.outF, (Definition)schema);
        this.printClassJavadoc(this.outF, "A Factory for specific use with the <code>" + schema.getOutputName() + "</code> schema.\n<p>\nThis Factory will not render the <code>" + schema.getOutputName() + "</code> schema's schema name in rendered SQL (assuming that you use it as the default schema on your connection!). Use the more generic {@link " + this.database.getDialect().getFactory().getName() + "} or the {@link " + Factory.class.getName() + "} instead, if you want to fully qualify tables, routines, etc.");
        this.outF.print("public class ");
        this.outF.print(this.strategy.getJavaClassName((Definition)schema, GeneratorStrategy.Mode.FACTORY));
        this.outF.print(" extends ");
        this.outF.print(this.database.getDialect().getFactory());
        this.printImplements(this.outF, (Definition)schema, GeneratorStrategy.Mode.FACTORY, new String[0]);
        this.outF.println(" {");
        this.outF.printSerial();
        this.outF.println();
        this.outF.println("\t/**");
        this.outF.println("\t * Create a factory with a connection");
        this.outF.println("\t *");
        this.outF.println("\t * @param connection The connection to use with objects created from this factory");
        this.outF.println("\t */");
        this.outF.print("\tpublic ");
        this.outF.print(this.strategy.getJavaClassName((Definition)schema, GeneratorStrategy.Mode.FACTORY));
        this.outF.print("(");
        this.outF.print(Connection.class);
        this.outF.println(" connection) {");
        this.outF.println("\t\tsuper(connection);");
        this.outF.println();
        this.outF.println("\t\tinitDefaultSchema();");
        this.outF.println("\t}");
        this.outF.println();
        this.outF.println("\t/**");
        this.outF.println("\t * Create a factory with a data source");
        this.outF.println("\t *");
        this.outF.println("\t * @param dataSource The data source to use with objects created from this factory");
        this.outF.println("\t */");
        this.outF.print("\tpublic ");
        this.outF.print(this.strategy.getJavaClassName((Definition)schema, GeneratorStrategy.Mode.FACTORY));
        this.outF.print("(");
        this.outF.print(DataSource.class);
        this.outF.println(" dataSource) {");
        this.outF.println("\t\tsuper(dataSource);");
        this.outF.println();
        this.outF.println("\t\tinitDefaultSchema();");
        this.outF.println("\t}");
        if (this.generateDeprecated()) {
            this.outF.println();
            this.outF.println("\t/**");
            this.outF.println("\t * Create a factory with a connection and a schema mapping");
            this.outF.println("\t * ");
            this.outF.print("\t * @deprecated - 2.0.5 - Use {@link #");
            this.outF.print(this.strategy.getJavaClassName((Definition)schema, GeneratorStrategy.Mode.FACTORY));
            this.outF.print("(");
            this.outF.print(Connection.class);
            this.outF.print(", ");
            this.outF.print(Settings.class);
            this.outF.println(")} instead");
            this.outF.println("\t */");
            this.outF.println("\t@Deprecated");
            this.outF.print("\tpublic ");
            this.outF.print(this.strategy.getJavaClassName((Definition)schema, GeneratorStrategy.Mode.FACTORY));
            this.outF.print("(");
            this.outF.print(Connection.class);
            this.outF.println(" connection, org.jooq.SchemaMapping mapping) {");
            this.outF.println("\t\tsuper(connection, mapping);");
            this.outF.println();
            this.outF.println("\t\tinitDefaultSchema();");
            this.outF.println("\t}");
        }
        this.outF.println();
        this.outF.println("\t/**");
        this.outF.println("\t * Create a factory with a connection and some settings");
        this.outF.println("\t *");
        this.outF.println("\t * @param connection The connection to use with objects created from this factory");
        this.outF.println("\t * @param settings The settings to apply to objects created from this factory");
        this.outF.println("\t */");
        this.outF.print("\tpublic ");
        this.outF.print(this.strategy.getJavaClassName((Definition)schema, GeneratorStrategy.Mode.FACTORY));
        this.outF.print("(");
        this.outF.print(Connection.class);
        this.outF.print(" connection, ");
        this.outF.print(Settings.class);
        this.outF.println(" settings) {");
        this.outF.println("\t\tsuper(connection, settings);");
        this.outF.println();
        this.outF.println("\t\tinitDefaultSchema();");
        this.outF.println("\t}");
        this.outF.println();
        this.outF.println("\t/**");
        this.outF.println("\t * Create a factory with a data source and some settings");
        this.outF.println("\t *");
        this.outF.println("\t * @param dataSource The data source to use with objects created from this factory");
        this.outF.println("\t * @param settings The settings to apply to objects created from this factory");
        this.outF.println("\t */");
        this.outF.print("\tpublic ");
        this.outF.print(this.strategy.getJavaClassName((Definition)schema, GeneratorStrategy.Mode.FACTORY));
        this.outF.print("(");
        this.outF.print(DataSource.class);
        this.outF.print(" dataSource, ");
        this.outF.print(Settings.class);
        this.outF.println(" settings) {");
        this.outF.println("\t\tsuper(dataSource, settings);");
        this.outF.println();
        this.outF.println("\t\tinitDefaultSchema();");
        this.outF.println("\t}");
        this.outF.println();
        this.outF.println("\t/**");
        this.outF.println("\t * Initialise the render mapping's default schema.");
        this.outF.println("\t * <p>");
        this.outF.println("\t * For convenience, this schema-specific factory should override any pre-existing setting");
        this.outF.println("\t */");
        this.outF.println("\tprivate final void initDefaultSchema() {");
        this.outF.print("\t\t");
        this.outF.print(SettingsTools.class);
        this.outF.print(".getRenderMapping(getSettings()).setDefaultSchema(");
        this.outF.print(this.strategy.getFullJavaIdentifier((Definition)schema));
        this.outF.println(".getName());");
        this.outF.println("\t}");
        this.watch.splitInfo("Factory generated");
    }

    protected void printExtends(GenerationWriter out, Definition definition, GeneratorStrategy.Mode mode) {
        String superclass = this.strategy.getJavaClassExtends(definition, mode);
        if (!StringUtils.isBlank((String)superclass)) {
            out.print(" extends ");
            out.print(superclass);
        }
    }

    protected void printImplements(GenerationWriter out, Definition definition, GeneratorStrategy.Mode mode, String ... forcedInterfaces) {
        List<String> interfaces = this.strategy.getJavaClassImplements(definition, mode);
        interfaces = new ArrayList(interfaces == null ? Collections.emptyList() : interfaces);
        interfaces.addAll(Arrays.asList(forcedInterfaces));
        if (this.generateInterfaces() && Arrays.asList(GeneratorStrategy.Mode.POJO, GeneratorStrategy.Mode.RECORD).contains((Object)mode) && definition instanceof TableDefinition) {
            interfaces.add(this.strategy.getFullJavaClassName(definition, GeneratorStrategy.Mode.INTERFACE));
        }
        if (!interfaces.isEmpty()) {
            String glue = mode == GeneratorStrategy.Mode.INTERFACE ? " extends " : " implements ";
            for (String i : new LinkedHashSet<String>(interfaces)) {
                if (StringUtils.isBlank((String)i)) continue;
                out.print(glue);
                out.print(i);
                glue = ", ";
            }
        }
    }

    protected void printTableJPAAnnotation(GenerationWriter out, TableDefinition table) {
        SchemaDefinition schema = table.getSchema();
        if (this.generateJPAAnnotations()) {
            out.println("@javax.persistence.Entity");
            out.print("@javax.persistence.Table(name = \"");
            out.print(table.getName().replace("\"", "\\\""));
            out.print("\"");
            if (!schema.isDefaultSchema()) {
                out.print(", schema = \"");
                out.print(schema.getOutputName().replace("\"", "\\\""));
                out.print("\"");
            }
            StringBuilder sb = new StringBuilder();
            String glue1 = "";
            for (UniqueKeyDefinition uk : table.getUniqueKeys()) {
                if (uk.getKeyColumns().size() <= 1) continue;
                sb.append(glue1);
                sb.append("\t@javax.persistence.UniqueConstraint(columnNames = {");
                String glue2 = "";
                for (ColumnDefinition column : uk.getKeyColumns()) {
                    sb.append(glue2);
                    sb.append("\"");
                    sb.append(column.getName().replace("\"", "\\\""));
                    sb.append("\"");
                    glue2 = ", ";
                }
                sb.append("})");
                glue1 = ",\n";
            }
            if (sb.length() > 0) {
                out.println(", uniqueConstraints = {");
                out.println(sb);
                out.print("}");
            }
            out.println(")");
        }
    }

    protected void printColumnJPAAnnotation(GenerationWriter out, ColumnDefinition column) {
        if (this.generateJPAAnnotations()) {
            UniqueKeyDefinition pk = column.getPrimaryKey();
            List uks = column.getUniqueKeys();
            if (pk != null && pk.getKeyColumns().size() == 1) {
                out.println("\t@javax.persistence.Id");
            }
            String unique = "";
            for (UniqueKeyDefinition uk : uks) {
                if (uk.getKeyColumns().size() != 1) continue;
                unique = ", unique = true";
                break;
            }
            String nullable = "";
            if (!column.isNullable()) {
                nullable = ", nullable = false";
            }
            String length = "";
            String precision = "";
            String scale = "";
            if (column.getType().getLength() > 0) {
                length = ", length = " + column.getType().getLength();
            } else if (column.getType().getPrecision() > 0) {
                precision = ", precision = " + column.getType().getPrecision();
                if (column.getType().getScale() > 0) {
                    scale = ", scale = " + column.getType().getScale();
                }
            }
            out.print("\t@javax.persistence.Column(name = \"");
            out.print(column.getName().replace("\"", "\\\""));
            out.print("\"");
            out.print(unique);
            out.print(nullable);
            out.print(length);
            out.print(precision);
            out.print(scale);
            out.println(")");
        }
    }

    protected void printColumnValidationAnnotation(GenerationWriter out, ColumnDefinition column) {
        if (this.generateValidationAnnotations()) {
            int length;
            DataTypeDefinition type = column.getType();
            boolean newline = true;
            if (!column.isNullable()) {
                newline = out.println(newline);
                out.println("\t@javax.validation.constraints.NotNull");
            }
            if ("java.lang.String".equals(this.getJavaType(type)) && (length = type.getLength()) > 0) {
                newline = out.println(newline);
                out.print("\t@javax.validation.constraints.Size(max = ");
                out.print(length);
                out.println(")");
            }
        }
    }

    protected void registerInSchema(List<? extends Definition> definitions, Class<?> type, boolean isGeneric) {
        if (this.outS != null) {
            this.outS.println();
            this.printOverride(this.outS);
            this.outS.print("\tpublic final ");
            this.outS.print(List.class);
            this.outS.print("<");
            this.outS.print(type);
            if (isGeneric) {
                this.outS.print("<?>");
            }
            this.outS.print("> get");
            this.outS.print(type.getSimpleName());
            this.outS.println("s() {");
            this.outS.print("\t\treturn ");
            this.outS.print(Arrays.class);
            this.outS.print(".<");
            this.outS.print(type);
            if (isGeneric) {
                this.outS.print("<?>");
            }
            this.outS.print(">asList(");
            if (definitions.size() > 1) {
                this.outS.print("\n\t\t\t");
            }
            for (int i = 0; i < definitions.size(); ++i) {
                Definition def = definitions.get(i);
                if (i > 0) {
                    this.outS.print(",\n\t\t\t");
                }
                this.printSingletonReference(this.outS, def);
            }
            this.outS.println(");");
            this.outS.println("\t}");
        }
    }

    protected void printRoutine(SchemaDefinition schema, RoutineDefinition routine) {
        log.info((Object)"Generating routine", (Object)this.strategy.getFileName((Definition)routine));
        GenerationWriter out = new GenerationWriter(this.strategy.getFile((Definition)routine));
        this.printHeader(out, (Definition)routine);
        this.printClassJavadoc(out, (Definition)routine);
        out.print("public class ");
        out.print(this.strategy.getJavaClassName((Definition)routine));
        out.print(" extends ");
        out.print(AbstractRoutine.class);
        out.print("<");
        if (routine.getReturnValue() == null) {
            out.print(Void.class);
        } else {
            out.print(this.getJavaType(routine.getReturnType()));
        }
        out.print(">");
        this.printImplements(out, (Definition)routine, GeneratorStrategy.Mode.DEFAULT, new String[0]);
        out.println(" {");
        out.printSerial();
        out.println();
        for (ParameterDefinition parameter : routine.getAllParameters()) {
            this.printParameter(out, parameter, (Definition)routine);
        }
        out.println();
        this.printJavadoc(out, "Create a new routine call instance");
        out.println("\tpublic " + this.strategy.getJavaClassName((Definition)routine) + "() {");
        out.print("\t\tsuper(");
        out.print("\"");
        out.print(routine.getName());
        out.print("\", ");
        out.print(this.strategy.getFullJavaIdentifier((Definition)schema));
        if (routine.getPackage() != null) {
            out.print(", ");
            out.print(this.strategy.getFullJavaIdentifier((Definition)routine.getPackage()));
        }
        if (routine.getReturnValue() != null) {
            out.print(", ");
            out.print(this.getJavaTypeReference(this.database, routine.getReturnType()));
        }
        out.println(");");
        if (routine.getAllParameters().size() > 0) {
            out.println();
        }
        for (ParameterDefinition parameter : routine.getAllParameters()) {
            out.print("\t\t");
            if (parameter.equals(routine.getReturnValue())) {
                out.println("setReturnParameter(" + this.strategy.getJavaIdentifier((Definition)parameter) + ");");
                continue;
            }
            if (routine.getInParameters().contains(parameter)) {
                if (routine.getOutParameters().contains(parameter)) {
                    out.println("addInOutParameter(" + this.strategy.getJavaIdentifier((Definition)parameter) + ");");
                    continue;
                }
                out.println("addInParameter(" + this.strategy.getJavaIdentifier((Definition)parameter) + ");");
                continue;
            }
            out.println("addOutParameter(" + this.strategy.getJavaIdentifier((Definition)parameter) + ");");
        }
        if (routine.getOverload() != null) {
            out.println("\t\tsetOverloaded(true);");
        }
        out.println("\t}");
        for (ParameterDefinition parameter : routine.getInParameters()) {
            out.println();
            out.println("\t/**");
            out.println("\t * Set the <code>" + parameter.getOutputName() + "</code> parameter IN value to the routine");
            out.println("\t */");
            out.print("\tpublic void ");
            out.print(this.strategy.getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT));
            out.print("(");
            this.printNumberType(out, parameter.getType());
            out.println(" value) {");
            out.print("\t\tset");
            if (parameter.getType().isGenericNumberType()) {
                out.print("Number");
            } else {
                out.print("Value");
            }
            out.print("(");
            out.print(this.strategy.getFullJavaIdentifier((Definition)parameter));
            out.println(", value);");
            out.println("\t}");
            if (!routine.isSQLUsable()) continue;
            out.println();
            out.println("\t/**");
            out.println("\t * Set the <code>" + parameter.getOutputName() + "</code> parameter to the function");
            out.println("\t * <p>");
            out.print("\t * Use this method only, if the function is called as a {@link ");
            out.print(Field.class);
            out.print("} in a {@link ");
            out.print(Select.class);
            out.println("} statement!");
            out.println("\t */");
            out.print("\tpublic void ");
            out.print(this.strategy.getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT));
            out.print("(");
            out.print(Field.class);
            out.print("<");
            this.printExtendsNumberType(out, parameter.getType());
            out.println("> field) {");
            out.print("\t\tset");
            if (parameter.getType().isGenericNumberType()) {
                out.print("Number");
            } else {
                out.print("Field");
            }
            out.print("(");
            out.print(this.strategy.getJavaIdentifier((Definition)parameter));
            out.println(", field);");
            out.println("\t}");
        }
        for (ParameterDefinition parameter : routine.getAllParameters()) {
            boolean isReturnValue = parameter.equals(routine.getReturnValue());
            boolean isOutParameter = routine.getOutParameters().contains(parameter);
            if (!isOutParameter || isReturnValue) continue;
            out.println();
            out.println("\t/**");
            out.println("\t * Get the <code>" + parameter.getOutputName() + "</code> parameter OUT value from the routine");
            out.println("\t */");
            out.print("\tpublic ");
            out.print(this.getJavaType(parameter.getType()));
            out.print(" ");
            out.print(this.strategy.getJavaGetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT));
            out.println("() {");
            out.print("\t\treturn getValue(");
            out.print(this.strategy.getJavaIdentifier((Definition)parameter));
            out.println(");");
            out.println("\t}");
        }
        out.println("}");
        out.close();
    }

    protected void printConvenienceMethodFunctionAsField(GenerationWriter out, RoutineDefinition function, boolean parametersAsField) {
        if (function.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        if (parametersAsField && function.getInParameters().isEmpty()) {
            return;
        }
        out.println();
        out.println("\t/**");
        out.println("\t * Get " + function.getQualifiedOutputName() + " as a field");
        out.println("\t *");
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.println("\t * @param " + this.strategy.getJavaMemberName((Definition)parameter));
        }
        out.println("\t */");
        out.print("\tpublic static ");
        out.print(function.isAggregate() ? AggregateFunction.class : Field.class);
        out.print("<");
        out.print(this.getJavaType(function.getReturnType()));
        out.print("> ");
        out.print(this.strategy.getJavaMethodName((Definition)function, GeneratorStrategy.Mode.DEFAULT));
        out.print("(");
        String separator = "";
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.print(separator);
            if (parametersAsField) {
                out.print(Field.class);
                out.print("<");
                this.printExtendsNumberType(out, parameter.getType());
                out.print(">");
            } else {
                this.printNumberType(out, parameter.getType());
            }
            out.print(" ");
            out.print(this.strategy.getJavaMemberName((Definition)parameter));
            separator = ", ";
        }
        out.println(") {");
        out.print("\t\t");
        out.print(this.strategy.getFullJavaClassName((Definition)function));
        out.print(" f = new ");
        out.print(this.strategy.getFullJavaClassName((Definition)function));
        out.println("();");
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.print("\t\tf.");
            out.print(this.strategy.getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT));
            out.print("(");
            out.print(this.strategy.getJavaMemberName((Definition)parameter));
            out.println(");");
        }
        out.println();
        if (function.isAggregate()) {
            out.println("\t\treturn f.asAggregateFunction();");
        } else {
            out.println("\t\treturn f.asField();");
        }
        out.println("\t}");
    }

    protected void printConvenienceMethodFunction(GenerationWriter out, RoutineDefinition function, boolean instance) {
        if (function.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        out.println();
        out.println("\t/**");
        out.println("\t * Call " + function.getQualifiedOutputName());
        out.println("\t *");
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.println("\t * @param " + this.strategy.getJavaMemberName((Definition)parameter));
        }
        this.printThrowsDataAccessException(out);
        out.println("\t */");
        out.print("\tpublic ");
        if (!instance) {
            out.print("static ");
        }
        out.print(this.getJavaType(function.getReturnType()));
        out.print(" ");
        out.print(this.strategy.getJavaMethodName((Definition)function, GeneratorStrategy.Mode.DEFAULT));
        out.print("(");
        String glue = "";
        if (!instance) {
            out.print(Configuration.class);
            out.print(" configuration");
            glue = ", ";
        }
        for (ParameterDefinition parameter : function.getInParameters()) {
            if (instance && parameter.equals(function.getInParameters().get(0))) continue;
            out.print(glue);
            this.printNumberType(out, parameter.getType());
            out.print(" ");
            out.print(this.strategy.getJavaMemberName((Definition)parameter));
            glue = ", ";
        }
        out.println(") {");
        out.print("\t\t");
        out.print(this.strategy.getFullJavaClassName((Definition)function));
        out.print(" f = new ");
        out.print(this.strategy.getFullJavaClassName((Definition)function));
        out.println("();");
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.print("\t\tf.");
            out.print(this.strategy.getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT));
            out.print("(");
            if (instance && parameter.equals(function.getInParameters().get(0))) {
                out.print("this");
            } else {
                out.print(this.strategy.getJavaMemberName((Definition)parameter));
            }
            out.println(");");
        }
        out.println();
        out.print("\t\tf.execute(");
        if (instance) {
            out.print("getConfiguration()");
        } else {
            out.print("configuration");
        }
        out.println(");");
        out.println("\t\treturn f.getReturnValue();");
        out.println("\t}");
    }

    protected void printThrowsDataAccessException(GenerationWriter out) {
        out.print("\t * @throws ");
        out.print(DataAccessException.class);
        out.print(" if something went wrong executing the query");
        out.println();
    }

    protected void printPrivateConstructor(GenerationWriter out, String javaClassName) {
        out.println();
        out.println("\t/**");
        out.println("\t * No instances");
        out.println("\t */");
        out.println("\tprivate " + javaClassName + "() {}");
    }

    protected void printConvenienceMethodProcedure(GenerationWriter out, RoutineDefinition procedure, boolean instance) {
        if (procedure.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Procedure " + procedure + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        out.println();
        out.println("\t/**");
        out.println("\t * Call " + procedure.getQualifiedOutputName());
        out.println("\t *");
        for (ParameterDefinition parameter : procedure.getAllParameters()) {
            out.print("\t * @param " + this.strategy.getJavaMemberName((Definition)parameter) + " ");
            if (procedure.getInParameters().contains(parameter)) {
                if (procedure.getOutParameters().contains(parameter)) {
                    out.println("IN OUT parameter");
                    continue;
                }
                out.println("IN parameter");
                continue;
            }
            out.println("OUT parameter");
        }
        this.printThrowsDataAccessException(out);
        out.println("\t */");
        out.print("\tpublic ");
        if (!instance) {
            out.print("static ");
        }
        if (procedure.getOutParameters().size() == 0) {
            out.print("void ");
        } else if (procedure.getOutParameters().size() == 1) {
            out.print(this.getJavaType(((ParameterDefinition)procedure.getOutParameters().get(0)).getType()));
            out.print(" ");
        } else {
            out.print(this.strategy.getFullJavaClassName((Definition)procedure) + " ");
        }
        out.print(this.strategy.getJavaMethodName((Definition)procedure, GeneratorStrategy.Mode.DEFAULT));
        out.print("(");
        String glue = "";
        if (!instance) {
            out.print(Configuration.class);
            out.print(" configuration");
            glue = ", ";
        }
        for (ParameterDefinition parameter : procedure.getInParameters()) {
            if (instance && parameter.equals(procedure.getInParameters().get(0))) continue;
            out.print(glue);
            this.printNumberType(out, parameter.getType());
            out.print(" ");
            out.print(this.strategy.getJavaMemberName((Definition)parameter));
            glue = ", ";
        }
        out.println(") {");
        out.print("\t\t");
        out.print(this.strategy.getFullJavaClassName((Definition)procedure));
        out.print(" p = new ");
        out.print(this.strategy.getFullJavaClassName((Definition)procedure));
        out.println("();");
        for (ParameterDefinition parameter : procedure.getInParameters()) {
            out.print("\t\tp.");
            out.print(this.strategy.getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT));
            out.print("(");
            if (instance && parameter.equals(procedure.getInParameters().get(0))) {
                out.print("this");
            } else {
                out.print(this.strategy.getJavaMemberName((Definition)parameter));
            }
            out.println(");");
        }
        out.println();
        out.print("\t\tp.execute(");
        if (instance) {
            out.print("getConfiguration()");
        } else {
            out.print("configuration");
        }
        out.println(");");
        if (procedure.getOutParameters().size() > 0) {
            if (instance) {
                out.print("\t\tfrom(p.");
                out.print(this.strategy.getJavaGetterName((Definition)procedure.getOutParameters().get(0), GeneratorStrategy.Mode.DEFAULT));
                out.println("());");
            }
            if (procedure.getOutParameters().size() == 1) {
                out.print("\t\treturn p.");
                out.print(this.strategy.getJavaGetterName((Definition)procedure.getOutParameters().get(0), GeneratorStrategy.Mode.DEFAULT));
                out.println("();");
            } else if (procedure.getOutParameters().size() > 1) {
                out.println("\t\treturn p;");
            }
        }
        out.println("\t}");
    }

    protected void printRecordTypeMethod(Definition definition, GenerationWriter out) {
        out.println();
        out.println("\t/**");
        out.println("\t * The class holding records for this type");
        out.println("\t */");
        this.printOverride(out);
        out.print("\tpublic ");
        out.print(Class.class);
        out.print("<");
        out.print(this.strategy.getFullJavaClassName(definition, GeneratorStrategy.Mode.RECORD));
        out.println("> getRecordType() {");
        out.print("\t\treturn ");
        out.print(this.strategy.getFullJavaClassName(definition, GeneratorStrategy.Mode.RECORD));
        out.println(".class;");
        out.println("\t}");
    }

    protected void printSingletonInstance(Definition definition, GenerationWriter out) {
        out.println();
        out.println("\t/**");
        out.println("\t * The singleton instance of " + definition.getQualifiedOutputName());
        out.println("\t */");
        out.print("\tpublic static final ");
        out.print(this.strategy.getFullJavaClassName(definition));
        out.print(" ");
        out.print(this.strategy.getJavaIdentifier(definition));
        out.print(" = new ");
        out.print(this.strategy.getFullJavaClassName(definition));
        out.println("();");
    }

    protected void printSingletonReference(GenerationWriter out, Definition definition) {
        if (definition instanceof SequenceDefinition) {
            out.print(this.strategy.getJavaPackageName((Definition)definition.getSchema()));
            out.print(".");
            out.print("Sequences");
            out.print(".");
            out.print(this.strategy.getJavaIdentifier(definition));
        } else {
            out.print(this.strategy.getFullJavaIdentifier(definition));
        }
    }

    protected void printOverride(GenerationWriter out) {
        out.println("\t@Override");
    }

    protected void empty(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                File[] children = file.listFiles();
                if (children != null) {
                    for (File child : children) {
                        this.empty(child);
                    }
                }
            } else if (file.getName().endsWith(".java")) {
                file.delete();
            }
        }
    }

    protected void printGetterAndSetter(GenerationWriter out, TypedElementDefinition<?> element) {
        this.printGetterAndSetter(out, element, true);
    }

    protected void printGetterAndSetter(GenerationWriter out, TypedElementDefinition<?> element, boolean printBody) {
        this.printFieldJavaDoc(out, element);
        if (printBody && this.generateInterfaces() && element instanceof ColumnDefinition) {
            this.printOverride(out);
        }
        this.printSetter(out, element, printBody);
        this.printFieldJavaDoc(out, element);
        if (element instanceof ColumnDefinition) {
            this.printColumnJPAAnnotation(out, (ColumnDefinition)element);
        }
        if (printBody && this.generateInterfaces() && element instanceof ColumnDefinition) {
            this.printOverride(out);
        }
        this.printGetter(out, element, printBody);
        if (printBody && this.generateRelations() && this.generateNavigationMethods() && element instanceof ColumnDefinition) {
            ColumnDefinition column = (ColumnDefinition)element;
            this.generateNavigateMethods(out, column);
        }
    }

    protected void printSetter(GenerationWriter out, TypedElementDefinition<?> element, boolean printBody) {
        out.print("\tpublic void ");
        out.print(this.strategy.getJavaSetterName((Definition)element, GeneratorStrategy.Mode.DEFAULT));
        out.print("(");
        out.print(this.getJavaType(element.getType()));
        out.print(" value)");
        if (printBody) {
            out.println(" {");
            out.println("\t\tsetValue(" + this.strategy.getFullJavaIdentifier((Definition)element) + ", value);");
            out.println("\t}");
        } else {
            out.println(";");
        }
    }

    protected void printGetter(GenerationWriter out, TypedElementDefinition<?> element, boolean printBody) {
        out.print("\tpublic ");
        out.print(this.getJavaType(element.getType()));
        out.print(" ");
        out.print(this.strategy.getJavaGetterName((Definition)element, GeneratorStrategy.Mode.DEFAULT));
        out.print("()");
        if (printBody) {
            out.println(" {");
            out.println("\t\treturn getValue(" + this.strategy.getFullJavaIdentifier((Definition)element) + ");");
            out.println("\t}");
        } else {
            out.println(";");
        }
    }

    protected void generateNavigateMethods(GenerationWriter out, ColumnDefinition column) {
        List uniqueKeys = column.getUniqueKeys();
        HashSet<String> fetchMethodNames = new HashSet<String>();
        for (UniqueKeyDefinition uniqueKey : uniqueKeys) {
            if (!out.printOnlyOnce(uniqueKey)) continue;
            for (ForeignKeyDefinition foreignKey : uniqueKey.getForeignKeys()) {
                this.generateFetchFKList(out, uniqueKey, foreignKey, column, fetchMethodNames);
            }
        }
        ForeignKeyDefinition foreignKey = column.getForeignKey();
        if (foreignKey != null && out.printOnlyOnce(foreignKey)) {
            this.generateFetchFK(out, column, foreignKey);
        }
    }

    protected void generateFetchFK(GenerationWriter out, ColumnDefinition column, ForeignKeyDefinition foreignKey) {
        if (foreignKey.getReferencedColumns().size() != foreignKey.getKeyColumns().size()) {
            log.warn((Object)"Foreign key mismatch", (Object)(foreignKey.getName() + " does not match its primary key! No code is generated for this key. See trac tickets #64 and #69"));
            return;
        }
        TableDefinition referenced = foreignKey.getReferencedTable();
        if (referenced instanceof MasterDataTableDefinition) {
            return;
        }
        this.printFetchMethod(out, column, foreignKey, referenced);
    }

    protected void printFKSetter(GenerationWriter out, ColumnDefinition column, ForeignKeyDefinition foreignKey, TableDefinition referencedTable) {
        int i;
        if (foreignKey.getKeyColumns().size() > 1) {
            return;
        }
        out.println("");
        out.println("\t/**");
        String comment = "Link this record to a given {@link " + this.getStrategy().getFullJavaClassName((Definition)referencedTable, GeneratorStrategy.Mode.RECORD) + " " + this.getStrategy().getJavaClassName((Definition)referencedTable, GeneratorStrategy.Mode.RECORD) + "}";
        this.printJavadocParagraph(out, comment, "\t");
        out.println("\t */");
        out.print("\tpublic void ");
        if (foreignKey.getKeyColumns().size() == 1) {
            out.print(this.getStrategy().getJavaSetterName((Definition)column, GeneratorStrategy.Mode.RECORD));
        } else {
            out.print(this.getStrategy().getJavaSetterName((Definition)referencedTable, GeneratorStrategy.Mode.RECORD));
        }
        out.print("(");
        out.print(this.getStrategy().getFullJavaClassName((Definition)referencedTable, GeneratorStrategy.Mode.RECORD));
        out.println(" value) {");
        out.println("\t\tif (value == null) {");
        for (i = 0; i < foreignKey.getKeyColumns().size(); ++i) {
            out.print("\t\t\tsetValue(");
            out.print(this.getStrategy().getFullJavaIdentifier((Definition)foreignKey.getKeyColumns().get(i)));
            out.println(", null);");
        }
        out.println("\t\t}");
        out.println("\t\telse {");
        for (i = 0; i < foreignKey.getKeyColumns().size(); ++i) {
            ColumnDefinition referencingColumn = (ColumnDefinition)foreignKey.getKeyColumns().get(i);
            ColumnDefinition referencedColumn = (ColumnDefinition)foreignKey.getReferencedColumns().get(i);
            DataTypeDefinition foreignType = referencingColumn.getType();
            DataTypeDefinition primaryType = referencedColumn.getType();
            out.print("\t\t\tsetValue(");
            out.print(this.getStrategy().getFullJavaIdentifier((Definition)referencingColumn));
            out.print(", value.getValue");
            if (!this.match(foreignType, primaryType)) {
                out.print("As");
                out.print(this.getSimpleJavaType(referencingColumn.getType()));
            }
            out.print("(");
            out.print(this.strategy.getFullJavaIdentifier((Definition)referencedColumn));
            out.println("));");
        }
        out.println("\t\t}");
        out.println("\t}");
    }

    protected void printFetchMethod(GenerationWriter out, ColumnDefinition column, ForeignKeyDefinition foreignKey, TableDefinition referenced) {
        this.printFKSetter(out, column, foreignKey, referenced);
        this.printFieldJavaDoc(out, (TypedElementDefinition<?>)column);
        out.print("\tpublic ");
        out.print(this.strategy.getFullJavaClassName((Definition)referenced, GeneratorStrategy.Mode.RECORD));
        out.print(" fetch");
        out.print(this.strategy.getJavaClassName((Definition)referenced));
        if (foreignKey.countSimilarReferences() > 1) {
            out.print("By");
            out.print(this.strategy.getJavaClassName((Definition)column));
        }
        out.println("() {");
        out.println("\t\treturn create()");
        out.print("\t\t\t.selectFrom(");
        out.print(this.strategy.getFullJavaIdentifier((Definition)referenced));
        out.println(")");
        String connector = "\t\t\t.where(";
        for (int i = 0; i < foreignKey.getReferencedColumns().size(); ++i) {
            out.print(connector);
            out.print(this.strategy.getFullJavaIdentifier((Definition)foreignKey.getReferencedColumns().get(i)));
            out.print(".equal(getValue");
            DataTypeDefinition foreignType = ((ColumnDefinition)foreignKey.getKeyColumns().get(i)).getType();
            DataTypeDefinition primaryType = ((ColumnDefinition)foreignKey.getReferencedColumns().get(i)).getType();
            if (!this.match(foreignType, primaryType)) {
                out.print("As");
                out.print(this.getSimpleJavaType(((ColumnDefinition)foreignKey.getReferencedColumns().get(i)).getType()));
            }
            out.print("(");
            out.print(this.strategy.getFullJavaIdentifier((Definition)foreignKey.getKeyColumns().get(i)));
            out.println(")))");
            connector = "\t\t\t.and(";
        }
        out.println("\t\t\t.fetchOne();");
        out.println("\t}");
    }

    private void generateFetchFKList(GenerationWriter out, UniqueKeyDefinition uniqueKey, ForeignKeyDefinition foreignKey, ColumnDefinition column, Set<String> fetchMethodNames) {
        if (foreignKey.getReferencedColumns().size() != foreignKey.getKeyColumns().size()) {
            log.warn((Object)"Foreign key mismatch", (Object)(foreignKey.getName() + " does not match its primary key! No code is generated for this key. See trac tickets #64 and #69"));
            return;
        }
        TableDefinition referencing = foreignKey.getKeyTable();
        StringBuilder fetchMethodName = new StringBuilder();
        fetchMethodName.append("fetch");
        fetchMethodName.append(this.strategy.getJavaClassName((Definition)referencing));
        fetchMethodName.append("List");
        if (foreignKey.countSimilarReferences() > 1) {
            fetchMethodName.append("By");
            fetchMethodName.append(this.strategy.getJavaClassName((Definition)foreignKey.getKeyColumns().get(0)));
        }
        if (fetchMethodNames.contains(fetchMethodName.toString())) {
            log.warn((Object)"Duplicate foreign key", (Object)(foreignKey.getName() + " has the same properties as another foreign key! No code is generated for this key. See trac ticket #1270"));
            return;
        }
        fetchMethodNames.add(fetchMethodName.toString());
        this.printFieldJavaDoc(out, (TypedElementDefinition<?>)column);
        out.print("\tpublic ");
        out.print(List.class);
        out.print("<");
        out.print(this.strategy.getFullJavaClassName((Definition)referencing, GeneratorStrategy.Mode.RECORD));
        out.print("> ");
        out.print(fetchMethodName);
        out.println("() {");
        out.println("\t\treturn create()");
        out.print("\t\t\t.selectFrom(");
        out.print(this.strategy.getFullJavaIdentifier((Definition)referencing));
        out.println(")");
        String connector = "\t\t\t.where(";
        for (int i = 0; i < foreignKey.getReferencedColumns().size(); ++i) {
            out.print(connector);
            out.print(this.strategy.getFullJavaIdentifier((Definition)foreignKey.getKeyColumns().get(i)));
            out.print(".equal(getValue");
            DataTypeDefinition foreignType = ((ColumnDefinition)foreignKey.getKeyColumns().get(i)).getType();
            DataTypeDefinition primaryType = ((ColumnDefinition)uniqueKey.getKeyColumns().get(i)).getType();
            if (!this.match(foreignType, primaryType)) {
                out.print("As");
                out.print(this.getSimpleJavaType(((ColumnDefinition)foreignKey.getKeyColumns().get(i)).getType()));
            }
            out.print("(");
            out.print(this.strategy.getFullJavaIdentifier((Definition)uniqueKey.getKeyColumns().get(i)));
            out.println(")))");
            connector = "\t\t\t.and(";
        }
        out.println("\t\t\t.fetch();");
        out.println("\t}");
    }

    protected void printUDTColumn(GenerationWriter out, AttributeDefinition attribute, Definition table) {
        Class<UDTField> declaredMemberClass = UDTField.class;
        this.printColumnDefinition(out, (TypedElementDefinition<?>)attribute, table, declaredMemberClass);
    }

    protected void printTableColumn(GenerationWriter out, ColumnDefinition column, Definition table) {
        Class<TableField> declaredMemberClass = TableField.class;
        this.printColumnDefinition(out, (TypedElementDefinition<?>)column, table, declaredMemberClass);
    }

    protected void printParameter(GenerationWriter out, ParameterDefinition parameter, Definition proc) {
        this.printColumnDefinition(out, (TypedElementDefinition<?>)parameter, proc, Parameter.class);
    }

    protected void printColumnDefinition(GenerationWriter out, TypedElementDefinition<?> column, Definition type, Class<?> declaredMemberClass) {
        boolean isDefaulted;
        this.printFieldJavaDoc(out, column);
        boolean hasType = type instanceof TableDefinition || type instanceof UDTDefinition;
        boolean bl = isDefaulted = column instanceof ParameterDefinition && ((ParameterDefinition)column).isDefaulted();
        if (type instanceof TableDefinition) {
            if (this.generateInstanceFields()) {
                out.print("\tpublic final ");
            } else {
                out.print("\tpublic static final ");
            }
        } else {
            out.print("\tpublic static final ");
        }
        out.print(declaredMemberClass);
        out.print("<");
        if (hasType) {
            out.print(this.strategy.getFullJavaClassName(type, GeneratorStrategy.Mode.RECORD));
            out.print(", ");
        }
        out.print(this.getJavaType(column.getType()));
        out.print("> ");
        out.print(this.strategy.getJavaIdentifier((Definition)column));
        if (declaredMemberClass == TableField.class) {
            out.print(" = createField");
        } else if (declaredMemberClass == UDTField.class) {
            out.print(" = createField");
        } else {
            out.print(" = createParameter");
        }
        out.print("(\"");
        out.print(column.getName());
        out.print("\", ");
        out.print(this.getJavaTypeReference(column.getDatabase(), column.getType()));
        if (hasType) {
            if (type instanceof TableDefinition) {
                if (this.generateInstanceFields()) {
                    out.print(", this");
                } else {
                    out.print(", " + this.strategy.getJavaIdentifier(type));
                }
            } else {
                out.print(", " + this.strategy.getJavaIdentifier(type));
            }
        }
        if (isDefaulted) {
            out.print(", true");
        }
        out.println(");");
    }

    protected void printFieldJavaDoc(GenerationWriter out, TypedElementDefinition<?> element) {
        this.printFieldJavaDoc(out, element, null);
    }

    protected void printFieldJavaDoc(GenerationWriter out, TypedElementDefinition<?> element, String deprecation) {
        out.println();
        out.println("\t/**");
        String comment = element.getComment();
        if (comment != null && comment.length() > 0) {
            out.println("\t * " + comment);
        } else {
            out.print("\t *");
            if (element instanceof ColumnDefinition) {
                out.print(" The table column");
            } else if (element instanceof ParameterDefinition) {
                out.print(" The procedure parameter");
            } else if (element instanceof AttributeDefinition) {
                out.print(" The UDT column");
            } else if (element instanceof SequenceDefinition) {
                out.print(" The sequence");
            }
            out.println(" <code>" + element.getQualifiedOutputName() + "</code>");
        }
        if (this.getJavaType(element.getType()).startsWith("java.lang.Object")) {
            String u;
            String t = element.getType().getType();
            String combined = t.equalsIgnoreCase(u = element.getType().getUserType()) ? t : t + ", " + u;
            out.println("\t * <p>");
            out.print("\t * The SQL type of this item (");
            out.print(combined);
            out.println(") could not be mapped.<br/>");
            out.println("\t * Deserialising this field might not work!");
            log.warn((Object)"Unknown type", (Object)(element.getQualifiedName() + " (" + combined + ")"));
        }
        if (element instanceof ColumnDefinition) {
            ColumnDefinition column = (ColumnDefinition)element;
            UniqueKeyDefinition primaryKey = column.getPrimaryKey();
            ForeignKeyDefinition foreignKey = column.getForeignKey();
            if (primaryKey != null) {
                out.println("\t * <p>");
                out.print("\t * This column is part of the table's PRIMARY KEY");
                out.println();
            }
            if (foreignKey != null) {
                out.println("\t * <p>");
                out.println("\t * This column is part of a FOREIGN KEY: <code><pre>");
                out.print("\t * CONSTRAINT ");
                out.println(foreignKey.getOutputName());
                out.print("\t * FOREIGN KEY (");
                String separator = "";
                for (ColumnDefinition fkColumn : foreignKey.getKeyColumns()) {
                    out.print(separator);
                    out.print(fkColumn.getOutputName());
                    separator = ", ";
                }
                out.println(")");
                out.print("\t * REFERENCES ");
                out.print(foreignKey.getReferencedTable().getQualifiedOutputName());
                out.print(" (");
                separator = "";
                for (ColumnDefinition fkColumn : foreignKey.getReferencedColumns()) {
                    out.print(separator);
                    out.print(fkColumn.getOutputName());
                    separator = ", ";
                }
                out.println(")");
                out.println("\t * </pre></code>");
            }
        }
        this.printDeprecation(out, deprecation);
        out.println("\t */");
        if (deprecation != null) {
            out.println("\t@Deprecated");
        }
    }

    protected void printDeprecation(GenerationWriter out, String deprecation) {
        if (deprecation != null) {
            out.println("\t *");
            String[] strings = deprecation.split("[\n\r]+");
            for (int i = 0; i < strings.length; ++i) {
                if (i == 0) {
                    out.println("\t * @deprecated " + strings[i]);
                    continue;
                }
                out.println("\t *             " + strings[i]);
            }
        }
    }

    protected void printNoFurtherInstancesAllowedJavadoc(GenerationWriter out) {
        this.printJavadoc(out, "No further instances allowed");
    }

    protected void printJavadoc(GenerationWriter out, String doc) {
        out.println("\t/**");
        out.println("\t * " + doc);
        out.println("\t */");
    }

    protected void printClassJavadoc(GenerationWriter out, Definition definition) {
        this.printClassJavadoc(out, definition.getComment());
    }

    protected void printClassJavadoc(GenerationWriter out, String comment) {
        this.printClassJavadoc(out, comment, null);
    }

    protected void printClassJavadoc(GenerationWriter out, String comment, String deprecation) {
        out.println("/**");
        out.println(" * This class is generated by jOOQ.");
        if (comment != null && comment.length() > 0) {
            out.println(" *");
            this.printJavadocParagraph(out, comment, "");
        }
        if (deprecation != null && deprecation.length() > 0) {
            out.println(" *");
            this.printJavadocParagraph(out, "@deprecated : " + deprecation, "");
        }
        out.println(" */");
        if (this.generateGeneratedAnnotation()) {
            out.println("@javax.annotation.Generated(value    = {\"http://www.jooq.org\", \"2.5.1\"},\n                            comments = \"This class is generated by jOOQ\")");
        }
        if (deprecation != null && deprecation.length() > 0) {
            out.println("@Deprecated");
        }
        out.printSuppressWarningsPlaceholder();
    }

    protected void printJavadocParagraph(GenerationWriter out, String comment, String indent) {
        boolean newLine = true;
        int lineLength = 0;
        for (int i = 0; i < comment.length(); ++i) {
            if (newLine) {
                out.print(indent);
                out.print(" * ");
                newLine = false;
            }
            out.print(comment.charAt(i));
            ++lineLength;
            if (comment.charAt(i) == '\n') {
                lineLength = 0;
                newLine = true;
                continue;
            }
            if (lineLength <= 70 || !Character.isWhitespace(comment.charAt(i))) continue;
            out.println();
            lineLength = 0;
            newLine = true;
        }
        if (!newLine) {
            out.println();
        }
    }

    protected void printHeader(GenerationWriter out, Definition definition) {
        this.printHeader(out, definition, GeneratorStrategy.Mode.DEFAULT);
    }

    protected void printHeader(GenerationWriter out, Definition definition, GeneratorStrategy.Mode mode) {
        out.println("/**");
        out.println(" * This class is generated by jOOQ");
        out.println(" */");
        out.println("package " + this.strategy.getJavaPackageName(definition, mode) + ";");
        out.println();
    }

    protected void printExtendsNumberType(GenerationWriter out, DataTypeDefinition type) {
        this.printNumberType(out, type, "? extends ");
    }

    protected void printNumberType(GenerationWriter out, DataTypeDefinition type) {
        this.printNumberType(out, type, "");
    }

    protected void printNumberType(GenerationWriter out, DataTypeDefinition type, String prefix) {
        if (type.isGenericNumberType()) {
            out.print(prefix);
            out.print(Number.class);
        } else {
            out.print(this.getJavaType(type));
        }
    }

    protected String getSimpleJavaType(DataTypeDefinition type) {
        return GenerationUtil.getSimpleJavaType(this.getJavaType(type));
    }

    protected String getJavaTypeReference(Database db, DataTypeDefinition type) {
        if (type instanceof MasterDataTypeDefinition) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getJavaTypeReference(db, ((MasterDataTypeDefinition)type).underlying));
            sb.append(".asMasterDataType(");
            sb.append(this.getJavaType(type));
            sb.append(".class)");
            return sb.toString();
        }
        if (this.database.isArrayType(type.getType())) {
            String baseType = GenerationUtil.getArrayBaseType(db.getDialect(), type.getType(), type.getUserType());
            return this.getTypeReference(db, type.getSchema(), baseType, 0, 0, baseType) + ".getArrayDataType()";
        }
        return this.getTypeReference(db, type.getSchema(), type.getType(), type.getPrecision(), type.getScale(), type.getUserType());
    }

    protected String getJavaType(DataTypeDefinition type) {
        if (type instanceof MasterDataTypeDefinition) {
            return this.strategy.getFullJavaClassName((Definition)((MasterDataTypeDefinition)type).table);
        }
        return this.getType(type.getDatabase(), type.getSchema(), type.getType(), type.getPrecision(), type.getScale(), type.getUserType(), Object.class.getName());
    }

    protected String getType(Database db, SchemaDefinition schema, String t, int p, int s, String u, String defaultType) {
        String type;
        block14: {
            type = defaultType;
            if (db.isArrayType(t)) {
                String baseType = GenerationUtil.getArrayBaseType(db.getDialect(), t, u);
                type = this.getType(db, schema, baseType, p, s, baseType, defaultType) + "[]";
            } else if (db.getArray(schema, u) != null) {
                type = this.strategy.getFullJavaClassName((Definition)db.getArray(schema, u), GeneratorStrategy.Mode.RECORD);
            } else if (db.getEnum(schema, u) != null) {
                type = this.strategy.getFullJavaClassName((Definition)db.getEnum(schema, u));
            } else if (db.getUDT(schema, u) != null) {
                type = this.strategy.getFullJavaClassName((Definition)db.getUDT(schema, u), GeneratorStrategy.Mode.RECORD);
            } else if (db.getConfiguredCustomType(u) != null) {
                type = u;
            } else {
                try {
                    Class clazz = FieldTypeHelper.getDialectJavaType((SQLDialect)db.getDialect(), (String)t, (int)p, (int)s);
                    type = clazz.getCanonicalName();
                    if (clazz.getTypeParameters().length > 0) {
                        type = type + "<";
                        String separator = "";
                        for (TypeVariable var : clazz.getTypeParameters()) {
                            type = type + separator;
                            type = type + ((Class)var.getBounds()[0]).getCanonicalName();
                            separator = ", ";
                        }
                        type = type + ">";
                    }
                }
                catch (SQLDialectNotSupportedException e) {
                    if (defaultType != null) break block14;
                    throw e;
                }
            }
        }
        return type;
    }

    protected String getTypeReference(Database db, SchemaDefinition schema, String t, int p, int s, String u) {
        StringBuilder sb = new StringBuilder();
        if (db.getArray(schema, u) != null) {
            ArrayDefinition array = this.database.getArray(schema, u);
            sb.append(this.getJavaTypeReference(db, array.getElementType()));
            sb.append(".asArrayDataType(");
            sb.append(this.strategy.getFullJavaClassName((Definition)array, GeneratorStrategy.Mode.RECORD));
            sb.append(".class)");
        } else if (db.getUDT(schema, u) != null) {
            UDTDefinition udt = db.getUDT(schema, u);
            sb.append(this.strategy.getFullJavaIdentifier((Definition)udt));
            sb.append(".getDataType()");
        } else if (db.getEnum(schema, u) != null) {
            sb.append("org.jooq.util.");
            sb.append(db.getDialect().getName().toLowerCase());
            sb.append(".");
            sb.append(db.getDialect().getName());
            sb.append("DataType.");
            sb.append(FieldTypeHelper.normalise((String)FieldTypeHelper.getDataType((SQLDialect)db.getDialect(), String.class).getTypeName()));
            sb.append(".asEnumDataType(");
            sb.append(this.strategy.getFullJavaClassName((Definition)db.getEnum(schema, u)));
            sb.append(".class)");
        } else {
            DataType dataType = null;
            try {
                dataType = FieldTypeHelper.getDialectDataType((SQLDialect)db.getDialect(), (String)t, (int)p, (int)s);
            }
            catch (SQLDialectNotSupportedException ignore) {
                // empty catch block
            }
            if (dataType != null && dataType.getSQLDataType() != null) {
                SQLDataType sqlDataType = dataType.getSQLDataType();
                sb.append(SQLDataType.class.getCanonicalName());
                sb.append(".");
                sb.append(FieldTypeHelper.normalise((String)sqlDataType.getTypeName()));
                if (db.getConfiguredCustomType(u) != null) {
                    sb.append(".asConvertedDataType(new ");
                    sb.append(db.getConfiguredCustomType(u).getConverter());
                    sb.append("())");
                }
            } else {
                String typeClass = "org.jooq.util." + db.getDialect().getName().toLowerCase() + "." + db.getDialect().getName() + "DataType";
                sb.append(typeClass);
                sb.append(".");
                try {
                    String type1 = this.getType(db, schema, t, p, s, u, null);
                    String type2 = this.getType(db, schema, t, 0, 0, u, null);
                    String typeName = FieldTypeHelper.normalise((String)t);
                    Reflect.on((String)typeClass).field(typeName);
                    sb.append(typeName);
                    if (!type1.equals(type2)) {
                        Class clazz = FieldTypeHelper.getDialectJavaType((SQLDialect)db.getDialect(), (String)t, (int)p, (int)s);
                        sb.append(".asNumberDataType(");
                        sb.append(clazz.getCanonicalName());
                        sb.append(".class)");
                    }
                }
                catch (SQLDialectNotSupportedException e) {
                    sb.append("getDefaultDataType(\"");
                    sb.append(t.replace("\"", "\\\""));
                    sb.append("\")");
                }
                catch (ReflectException e) {
                    sb.append("getDefaultDataType(\"");
                    sb.append(t.replace("\"", "\\\""));
                    sb.append("\")");
                }
            }
        }
        return sb.toString();
    }

    protected boolean match(DataTypeDefinition type1, DataTypeDefinition type2) {
        return this.getJavaType(type1).equals(this.getJavaType(type2));
    }
}

