/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.jooq.tools.StringUtils;

public class GenerationWriter {
    private static final String SUPPRESS_WARNINGS_STATEMENT = "__SUPPRESS_WARNINGS_STATEMENT__";
    private static final String STATIC_INITIALISATION_STATEMENT = "__STATIC_INITIALISATION_STATEMENT__";
    private static final String INITIALISATION_STATEMENT = "__INITIALISATION_STATEMENT__";
    private static final String SERIAL_STATEMENT = "__SERIAL_STATEMENT__";
    private final PrintWriter writer;
    private final StringBuilder sb;
    private final List<String> staticInitialisationStatements;
    private final List<String> initialisationStatements;
    private final Set<Object> alreadyPrinted;
    private final Set<String> suppressWarnings;

    public GenerationWriter(File file) throws FileNotFoundException {
        file.getParentFile().mkdirs();
        this.writer = new PrintWriter(file);
        this.sb = new StringBuilder();
        this.staticInitialisationStatements = new ArrayList<String>();
        this.initialisationStatements = new ArrayList<String>();
        this.alreadyPrinted = new HashSet<Object>();
        this.suppressWarnings = new TreeSet<String>();
    }

    public void printStaticInitialisationStatementsPlaceholder() {
        this.println(STATIC_INITIALISATION_STATEMENT);
    }

    public void printInitialisationStatementsPlaceholder() {
        this.println(INITIALISATION_STATEMENT);
    }

    public void printSuppressWarningsPlaceholder() {
        this.println(SUPPRESS_WARNINGS_STATEMENT);
    }

    public void printStaticInitialisationStatement(String statement) {
        this.staticInitialisationStatements.add(statement);
    }

    public void printInitialisationStatement(String statement) {
        this.initialisationStatements.add(statement);
    }

    public void print(int value) {
        this.sb.append(value);
    }

    public void print(CharSequence string) {
        this.sb.append(string);
    }

    public void println(int value) {
        this.print(value);
        this.println();
    }

    public void println(CharSequence string) {
        this.print(string);
        this.println();
    }

    public void println() {
        this.sb.append("\n");
    }

    public boolean println(boolean doPrint) {
        if (doPrint) {
            this.println();
        }
        return false;
    }

    public void print(Class<?> clazz) {
        this.print(clazz.getCanonicalName());
    }

    public boolean printOnlyOnce(Object object) {
        if (!this.alreadyPrinted.contains(object)) {
            this.alreadyPrinted.add(object);
            return true;
        }
        return false;
    }

    public void printSerial() {
        this.println();
        this.println("\tprivate static final long serialVersionUID = __SERIAL_STATEMENT__;");
    }

    public void close() {
        String string = this.sb.toString();
        StringBuilder staticInits = new StringBuilder();
        StringBuilder inits = new StringBuilder();
        StringBuilder warnings = new StringBuilder();
        boolean hasStaticInits = false;
        boolean hasInits = false;
        for (String statement : this.staticInitialisationStatements) {
            if (StringUtils.isBlank((String)statement)) continue;
            hasStaticInits = true;
            break;
        }
        for (String statement : this.initialisationStatements) {
            if (StringUtils.isBlank((String)statement)) continue;
            hasInits = true;
            break;
        }
        if (hasStaticInits) {
            staticInits.append("\n");
            staticInits.append("\t/*\n");
            staticInits.append("\t * static initialiser\n");
            staticInits.append("\t */\n");
            staticInits.append("\tstatic {\n");
            for (String statement : this.staticInitialisationStatements) {
                staticInits.append("\t\t" + statement + "\n");
            }
            staticInits.append("\t}\n");
        }
        if (hasInits) {
            inits.append("\n");
            inits.append("\t/*\n");
            inits.append("\t * instance initialiser\n");
            inits.append("\t */\n");
            inits.append("\t{\n");
            for (String statement : this.initialisationStatements) {
                inits.append("\t\t" + statement + "\n");
            }
            inits.append("\t}\n");
        }
        if (!this.suppressWarnings.isEmpty()) {
            warnings.append("@SuppressWarnings({");
            String separator = "";
            for (String warning : this.suppressWarnings) {
                warnings.append(separator);
                warnings.append("\"");
                warnings.append(warning);
                warnings.append("\"");
                separator = ", ";
            }
            warnings.append("})\n");
        }
        string = string.replaceAll("__STATIC_INITIALISATION_STATEMENT__\\n", Matcher.quoteReplacement(staticInits.toString()));
        string = string.replaceAll("__INITIALISATION_STATEMENT__\\n", Matcher.quoteReplacement(inits.toString()));
        string = string.replaceAll("__SUPPRESS_WARNINGS_STATEMENT__\\n", Matcher.quoteReplacement(warnings.toString()));
        string = string.replaceAll(SERIAL_STATEMENT, Matcher.quoteReplacement(String.valueOf(string.hashCode())));
        this.writer.append(string);
        this.writer.close();
    }

    public <T> void printNewJavaObject(String type, Object value) {
        this.print(this.getNewJavaObject(type, value));
    }

    private <T> String getNewJavaObject(String type, Object value) {
        if (value == null) {
            return "null";
        }
        if (type != Blob.class.getName()) {
            if (type == Boolean.class.getName()) {
                return Boolean.toString(this.getIsTrue(String.valueOf(value)));
            }
            if (type == BigInteger.class.getName()) {
                return "new java.math.BigInteger(\"" + value + "\")";
            }
            if (type == BigDecimal.class.getName()) {
                return "new java.math.BigDecimal(\"" + value + "\")";
            }
            if (type == Byte.class.getName()) {
                return "(byte) " + value;
            }
            if (type != byte[].class.getName() && type != Clob.class.getName()) {
                if (type == Date.class.getName()) {
                    return "new java.sql.Date(" + ((Date)value).getTime() + "L)";
                }
                if (type == Double.class.getName()) {
                    return Double.toString(Double.valueOf("" + value));
                }
                if (type == Float.class.getName()) {
                    return Float.toString(Float.valueOf("" + value).floatValue()) + "f";
                }
                if (type == Integer.class.getName()) {
                    return Integer.toString(Integer.valueOf("" + value));
                }
                if (type == Long.class.getName()) {
                    return Long.toString(Long.valueOf("" + value)) + "L";
                }
                if (type == Short.class.getName()) {
                    return "(short) " + value;
                }
                if (type == String.class.getName()) {
                    return "\"" + value.toString().replace("\"", "\\\"") + "\"";
                }
                if (type == Time.class.getName()) {
                    return "new java.sql.Time(" + ((Time)value).getTime() + "L)";
                }
                if (type == Timestamp.class.getName()) {
                    return "new java.sql.Timestamp(" + ((Timestamp)value).getTime() + "L)";
                }
            }
        }
        throw new UnsupportedOperationException("Class " + type + " is not supported");
    }

    private boolean getIsTrue(String string) {
        if ("1".equals(string)) {
            return true;
        }
        return "true".equalsIgnoreCase(string);
    }

    public void suppressWarnings(String string) {
        this.suppressWarnings.add(string);
    }
}

