/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.TypeVariable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jooq.Configuration;
import org.jooq.DataType;
import org.jooq.EnumType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.MasterDataType;
import org.jooq.Package;
import org.jooq.Parameter;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.Sequence;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UDT;
import org.jooq.UDTField;
import org.jooq.UniqueKey;
import org.jooq.conf.Settings;
import org.jooq.exception.DataAccessException;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractKeys;
import org.jooq.impl.AbstractRoutine;
import org.jooq.impl.ArrayRecordImpl;
import org.jooq.impl.FieldTypeHelper;
import org.jooq.impl.PackageImpl;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.SequenceImpl;
import org.jooq.impl.TableImpl;
import org.jooq.impl.TableRecordImpl;
import org.jooq.impl.UDTImpl;
import org.jooq.impl.UDTRecordImpl;
import org.jooq.impl.UpdatableRecordImpl;
import org.jooq.impl.UpdatableTableImpl;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StopWatch;
import org.jooq.tools.StringUtils;
import org.jooq.tools.reflect.Reflect;
import org.jooq.tools.reflect.ReflectException;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.AttributeDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.Database;
import org.jooq.util.Definition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.ForeignKeyDefinition;
import org.jooq.util.GenerationUtil;
import org.jooq.util.GenerationWriter;
import org.jooq.util.Generator;
import org.jooq.util.GeneratorStrategy;
import org.jooq.util.GeneratorStrategyWrapper;
import org.jooq.util.MasterDataTableDefinition;
import org.jooq.util.MasterDataTypeDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ParameterDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.TypedElementDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.UniqueKeyDefinition;

public class DefaultGenerator
implements Generator {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultGenerator.class);
    private boolean generateDeprecated = true;
    private boolean generateRelations = false;
    private boolean generateNavigationMethods = true;
    private boolean generateInstanceFields = true;
    private boolean generateGeneratedAnnotation = true;
    private boolean generatePojos = false;
    private boolean generateRecords = true;
    private boolean generateJPAAnnotations = false;
    private GeneratorStrategyWrapper strategy;

    @Override
    public void setStrategy(GeneratorStrategy strategy) {
        this.strategy = new GeneratorStrategyWrapper(this, strategy);
    }

    @Override
    public GeneratorStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public boolean generateDeprecated() {
        return this.generateDeprecated;
    }

    @Override
    public void setGenerateDeprecated(boolean generateDeprecated) {
        this.generateDeprecated = generateDeprecated;
    }

    @Override
    public boolean generateRelations() {
        return this.generateRelations;
    }

    @Override
    public void setGenerateRelations(boolean generateRelations) {
        this.generateRelations = generateRelations;
    }

    @Override
    public boolean generateInstanceFields() {
        return this.generateInstanceFields;
    }

    @Override
    public boolean generateNavigationMethods() {
        return this.generateNavigationMethods;
    }

    @Override
    public void setGenerateNavigationMethods(boolean generateNavigationMethods) {
        this.generateNavigationMethods = generateNavigationMethods;
    }

    @Override
    public void setGenerateInstanceFields(boolean generateInstanceFields) {
        this.generateInstanceFields = generateInstanceFields;
    }

    @Override
    public boolean generateGeneratedAnnotation() {
        return this.generateGeneratedAnnotation;
    }

    @Override
    public void setGenerateGeneratedAnnotation(boolean generateGeneratedAnnotation) {
        this.generateGeneratedAnnotation = generateGeneratedAnnotation;
    }

    @Override
    public boolean generatePojos() {
        return this.generatePojos;
    }

    @Override
    public void setGeneratePojos(boolean generatePojos) {
        this.generatePojos = generatePojos;
    }

    @Override
    public boolean generateRecords() {
        return this.generateRecords;
    }

    @Override
    public void setGenerateRecords(boolean generateRecords) {
        this.generateRecords = generateRecords;
    }

    @Override
    public boolean generateJPAAnnotations() {
        return this.generateJPAAnnotations;
    }

    @Override
    public void setGenerateJPAAnnotations(boolean generateJPAAnnotations) {
        this.generateJPAAnnotations = generateJPAAnnotations;
    }

    @Override
    public void setTargetDirectory(String directory) {
        this.strategy.setTargetDirectory(directory);
    }

    @Override
    public String getTargetDirectory() {
        return this.strategy.getTargetDirectory();
    }

    @Override
    public void setTargetPackage(String packageName) {
        this.strategy.setTargetPackage(packageName);
    }

    @Override
    public String getTargetPackage() {
        return this.strategy.getTargetPackage();
    }

    @Override
    public void generate(Database database) throws SQLException, IOException {
        StopWatch watch = new StopWatch();
        log.info((Object)"Database parameters");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"  dialect", (Object)database.getDialect());
        log.info((Object)"  target dir", (Object)this.getTargetDirectory());
        log.info((Object)"  target package", (Object)this.getTargetPackage());
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"");
        log.info((Object)"Generation parameters");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"  strategy", this.strategy.delegate.getClass());
        log.info((Object)"  deprecated", (Object)this.generateDeprecated());
        log.info((Object)"  generated annotation", (Object)this.generateGeneratedAnnotation());
        log.info((Object)"  instance fields", (Object)this.generateInstanceFields());
        log.info((Object)"  JPA annotations", (Object)this.generateJPAAnnotations());
        log.info((Object)"  navigation methods", (Object)this.generateNavigationMethods());
        log.info((Object)"  records", (Object)this.generateRecords());
        log.info((Object)"  pojos", (Object)this.generatePojos());
        log.info((Object)"  relations", (Object)this.generateRelations());
        log.info((Object)"----------------------------------------------------------");
        String targetPackage = this.getTargetPackage();
        File targetPackageDir = new File(this.getTargetDirectory() + File.separator + targetPackage.replace('.', File.separatorChar));
        log.info((Object)"Emptying", (Object)targetPackageDir.getCanonicalPath());
        this.empty(targetPackageDir);
        for (SchemaDefinition schema : database.getSchemata()) {
            this.generate(database, schema, watch);
        }
    }

    private void generate(Database database, SchemaDefinition schema, StopWatch watch) throws SQLException, IOException {
        String separator;
        GenerationWriter out;
        GenerationWriter out2;
        File targetSchemaDir = this.strategy.getFile((Definition)schema).getParentFile();
        GenerationWriter outS = null;
        GenerationWriter outF = null;
        if (!schema.isDefaultSchema()) {
            log.info((Object)"Generating schema", (Object)this.strategy.getFileName((Definition)schema));
            log.info((Object)"----------------------------------------------------------");
            outS = new GenerationWriter(this.strategy.getFile((Definition)schema));
            this.printHeader(outS, (Definition)schema);
            this.printClassJavadoc(outS, (Definition)schema);
            outS.print("public class ");
            outS.print(this.strategy.getJavaClassName((Definition)schema));
            outS.print(" extends ");
            outS.print(SchemaImpl.class);
            this.printImplements(outS, (Definition)schema, GeneratorStrategy.Mode.DEFAULT, new String[0]);
            outS.println(" {");
            outS.printSerial();
            outS.println();
            outS.println("\t/**");
            outS.println("\t * The singleton instance of " + schema.getQualifiedOutputName());
            outS.println("\t */");
            outS.println("\tpublic static final " + this.strategy.getJavaClassName((Definition)schema) + " " + this.strategy.getJavaIdentifier((Definition)schema) + " = new " + this.strategy.getJavaClassName((Definition)schema) + "();");
            outS.println();
            this.printNoFurtherInstancesAllowedJavadoc(outS);
            outS.println("\tprivate " + this.strategy.getJavaClassName((Definition)schema) + "() {");
            outS.println("\t\tsuper(\"" + schema.getOutputName() + "\");");
            outS.println("\t}");
            outS.printInitialisationStatementsPlaceholder();
            log.info((Object)"Generating factory", (Object)this.strategy.getFileName((Definition)schema, GeneratorStrategy.Mode.FACTORY));
            outF = new GenerationWriter(this.strategy.getFile((Definition)schema, GeneratorStrategy.Mode.FACTORY));
            this.printHeader(outF, (Definition)schema);
            this.printClassJavadoc(outF, (Definition)schema);
            outF.print("public class ");
            outF.print(this.strategy.getJavaClassName((Definition)schema, GeneratorStrategy.Mode.FACTORY));
            outF.print(" extends ");
            outF.print(database.getDialect().getFactory());
            this.printImplements(outF, (Definition)schema, GeneratorStrategy.Mode.FACTORY, new String[0]);
            outF.println(" {");
            outF.printSerial();
            outF.println();
            outF.println("\t/**");
            outF.println("\t * Create a factory with a connection");
            outF.println("\t *");
            outF.println("\t * @param connection The connection to use with objects created from this factory");
            outF.println("\t */");
            outF.print("\tpublic ");
            outF.print(this.strategy.getJavaClassName((Definition)schema, GeneratorStrategy.Mode.FACTORY));
            outF.print("(");
            outF.print(Connection.class);
            outF.println(" connection) {");
            outF.println("\t\tsuper(connection);");
            outF.println("\t}");
            if (this.generateDeprecated()) {
                outF.println();
                outF.println("\t/**");
                outF.println("\t * Create a factory with a connection and a schema mapping");
                outF.println("\t * ");
                outF.print("\t * @deprecated - 2.0.5 - Use {@link #");
                outF.print(this.strategy.getJavaClassName((Definition)schema, GeneratorStrategy.Mode.FACTORY));
                outF.print("(");
                outF.print(Connection.class);
                outF.print(", ");
                outF.print(Settings.class);
                outF.println(")} instead");
                outF.println("\t */");
                outF.println("\t@Deprecated");
                outF.print("\tpublic ");
                outF.print(this.strategy.getJavaClassName((Definition)schema, GeneratorStrategy.Mode.FACTORY));
                outF.print("(");
                outF.print(Connection.class);
                outF.println(" connection, org.jooq.SchemaMapping mapping) {");
                outF.println("\t\tsuper(connection, mapping);");
                outF.println("\t}");
            }
            outF.println();
            outF.println("\t/**");
            outF.println("\t * Create a factory with a connection and some settings");
            outF.println("\t *");
            outF.println("\t * @param connection The connection to use with objects created from this factory");
            outF.println("\t * @param settings The settings to apply to objects created from this factory");
            outF.println("\t */");
            outF.print("\tpublic ");
            outF.print(this.strategy.getJavaClassName((Definition)schema, GeneratorStrategy.Mode.FACTORY));
            outF.print("(");
            outF.print(Connection.class);
            outF.print(" connection, ");
            outF.print(Settings.class);
            outF.println(" settings) {");
            outF.println("\t\tsuper(connection, settings);");
            outF.println("\t}");
            watch.splitInfo("Schema generated");
        }
        if (database.getSequences(schema).size() > 0) {
            log.info((Object)"Generating sequences");
            out2 = new GenerationWriter(new File(targetSchemaDir, "Sequences.java"));
            this.printHeader(out2, (Definition)schema);
            this.printClassJavadoc(out2, "Convenience access to all sequences in " + schema.getOutputName());
            out2.println("public final class Sequences {");
            for (SequenceDefinition sequence : database.getSequences(schema)) {
                out2.println();
                out2.println("\t/**");
                out2.println("\t * The sequence " + sequence.getQualifiedOutputName());
                out2.println("\t */");
                out2.print("\tpublic static final ");
                out2.print(Sequence.class);
                out2.print("<");
                out2.print(this.getJavaType(sequence.getType()));
                out2.print(">");
                out2.print(" ");
                out2.print(this.strategy.getJavaIdentifier((Definition)sequence));
                out2.print(" = new ");
                out2.print(SequenceImpl.class);
                out2.print("<");
                out2.print(this.getJavaType(sequence.getType()));
                out2.print(">");
                out2.print("(\"");
                out2.print(sequence.getOutputName());
                out2.print("\"");
                if (!schema.isDefaultSchema()) {
                    out2.print(", ");
                    out2.print(this.strategy.getFullJavaIdentifier((Definition)schema));
                } else {
                    out2.print(", null");
                }
                out2.print(", ");
                out2.print(this.getJavaTypeReference(sequence.getDatabase(), sequence.getType()));
                out2.println(");");
            }
            this.printPrivateConstructor(out2, "Sequences");
            out2.println("}");
            out2.close();
            this.registerInSchema(outS, database.getSequences(schema), Sequence.class, true);
            watch.splitInfo("Sequences generated");
        }
        if (database.getMasterDataTables(schema).size() > 0) {
            log.info((Object)"Generating master data");
            for (MasterDataTableDefinition table : database.getMasterDataTables(schema)) {
                try {
                    log.info((Object)"Generating table", (Object)this.strategy.getFileName((Definition)table));
                    out = new GenerationWriter(this.strategy.getFile((Definition)table));
                    this.printHeader(out, (Definition)table);
                    this.printClassJavadoc(out, (Definition)table);
                    ColumnDefinition pk = table.getPrimaryKeyColumn();
                    ColumnDefinition l = table.getLiteralColumn();
                    ColumnDefinition d = table.getDescriptionColumn();
                    Result data = table.getData();
                    out.print("public enum ");
                    out.print(this.strategy.getJavaClassName((Definition)table));
                    this.printImplements(out, (Definition)table, GeneratorStrategy.Mode.ENUM, MasterDataType.class.getName() + "<" + this.getJavaType(pk.getType()) + ">");
                    out.println(" {");
                    LinkedHashSet<ColumnDefinition> columns = new LinkedHashSet<ColumnDefinition>(Arrays.asList(pk, l, d));
                    for (Record record : data) {
                        String literal = record.getValueAsString(l.getName());
                        String description = record.getValueAsString(d.getName());
                        if (!StringUtils.isEmpty((String)description)) {
                            out.println();
                            out.println("\t/**");
                            out.println("\t * " + description);
                            out.println("\t */");
                        }
                        out.print("\t");
                        out.print(GenerationUtil.convertToJavaIdentifier(literal));
                        out.print("(");
                        String separator2 = "";
                        for (ColumnDefinition column : columns) {
                            out.print(separator2);
                            out.printNewJavaObject(this.getJavaType(column.getType()), record.getValue(column.getName()));
                            separator2 = ", ";
                        }
                        out.println("),");
                    }
                    out.println("\t;");
                    out.println();
                    for (ColumnDefinition column : columns) {
                        out.print("\tprivate final ");
                        out.print(this.getJavaType(column.getType()));
                        out.print(" ");
                        out.println(this.strategy.getJavaMemberName((Definition)column) + ";");
                    }
                    out.println();
                    out.print("\tprivate " + this.strategy.getJavaClassName((Definition)table) + "(");
                    separator = "";
                    for (ColumnDefinition column : columns) {
                        out.print(separator);
                        out.print(this.getJavaType(column.getType()));
                        out.print(" ");
                        out.print(this.strategy.getJavaMemberName((Definition)column));
                        separator = ", ";
                    }
                    out.println(") {");
                    for (ColumnDefinition column : columns) {
                        out.print("\t\tthis.");
                        out.print(this.strategy.getJavaMemberName((Definition)column));
                        out.print(" = ");
                        out.print(this.strategy.getJavaMemberName((Definition)column));
                        out.println(";");
                    }
                    out.println("\t}");
                    out.println();
                    this.printOverride(out);
                    out.print("\tpublic ");
                    out.print(this.getJavaType(pk.getType()));
                    out.println(" getPrimaryKey() {");
                    out.println("\t\treturn " + this.strategy.getJavaMemberName((Definition)pk) + ";");
                    out.println("\t}");
                    for (ColumnDefinition column : columns) {
                        this.printFieldJavaDoc(out, (TypedElementDefinition<?>)column);
                        out.print("\tpublic final ");
                        out.print(this.getJavaType(column.getType()));
                        out.print(" ");
                        out.print(this.strategy.getJavaGetterName((Definition)column, GeneratorStrategy.Mode.DEFAULT));
                        out.println("() {");
                        out.print("\t\treturn ");
                        out.print(this.strategy.getJavaMemberName((Definition)column));
                        out.println(";");
                        out.println("\t}");
                    }
                    out.println("}");
                    out.close();
                }
                catch (Exception e) {
                    log.error((Object)("Exception while generating master data table " + table), (Throwable)e);
                }
            }
            watch.splitInfo("Master data generated");
        }
        if (database.getTables(schema).size() > 0) {
            log.info((Object)"Generating tables");
            for (MasterDataTableDefinition table : database.getTables(schema)) {
                try {
                    log.info((Object)"Generating table", (Object)this.strategy.getFileName((Definition)table));
                    out = new GenerationWriter(this.strategy.getFile((Definition)table));
                    this.printHeader(out, (Definition)table);
                    this.printClassJavadoc(out, (Definition)table);
                    Class baseClass = this.generateRelations() && table.getMainUniqueKey() != null ? UpdatableTableImpl.class : TableImpl.class;
                    out.print("public class ");
                    out.print(this.strategy.getJavaClassName((Definition)table));
                    out.print(" extends ");
                    out.print(baseClass);
                    out.print("<");
                    out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
                    out.print(">");
                    this.printImplements(out, (Definition)table, GeneratorStrategy.Mode.RECORD, new String[0]);
                    out.println(" {");
                    out.printSerial();
                    this.printSingletonInstance((Definition)table, out);
                    this.printRecordTypeMethod((Definition)table, out);
                    for (ColumnDefinition column : table.getColumns()) {
                        this.printTableColumn(out, column, (Definition)table);
                    }
                    out.println();
                    if (this.generateInstanceFields()) {
                        out.print("\tpublic ");
                    } else {
                        this.printNoFurtherInstancesAllowedJavadoc(out);
                        out.print("\tprivate ");
                    }
                    out.println(this.strategy.getJavaClassName((Definition)table) + "() {");
                    if (!schema.isDefaultSchema()) {
                        out.println("\t\tsuper(\"" + table.getOutputName() + "\", " + this.strategy.getFullJavaIdentifier((Definition)schema) + ");");
                    } else {
                        out.println("\t\tsuper(\"" + table.getOutputName() + "\");");
                    }
                    out.println("\t}");
                    if (this.generateInstanceFields()) {
                        out.println();
                        out.print("\tpublic ");
                        out.print(this.strategy.getJavaClassName((Definition)table));
                        out.print("(");
                        out.print(String.class);
                        out.println(" alias) {");
                        out.print("\t\tsuper(alias, ");
                        out.print(this.strategy.getFullJavaIdentifier((Definition)schema));
                        out.print(", ");
                        out.print(this.strategy.getFullJavaIdentifier((Definition)table));
                        out.println(");");
                        out.println("\t}");
                    }
                    if (this.generateRelations()) {
                        List foreignKeys;
                        List uniqueKeys;
                        UniqueKeyDefinition mainKey;
                        ColumnDefinition identity = table.getIdentity();
                        if (identity != null) {
                            out.println();
                            out.println("\t@Override");
                            out.print("\tpublic ");
                            out.print(Identity.class);
                            out.print("<");
                            out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
                            out.print(", ");
                            out.print(this.getJavaType(table.getIdentity().getType()));
                            out.println("> getIdentity() {");
                            out.print("\t\treturn ");
                            out.print(this.strategy.getJavaPackageName((Definition)schema));
                            out.print(".Keys.IDENTITY_");
                            out.print(this.strategy.getJavaIdentifier(identity.getContainer()));
                            out.println(";");
                            out.println("\t}");
                        }
                        if ((mainKey = table.getMainUniqueKey()) != null) {
                            out.println();
                            out.println("\t@Override");
                            out.print("\tpublic ");
                            out.print(UniqueKey.class);
                            out.print("<");
                            out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
                            out.println("> getMainKey() {");
                            out.print("\t\treturn ");
                            out.print(this.strategy.getJavaPackageName((Definition)schema));
                            out.print(".Keys.");
                            out.print(this.strategy.getJavaIdentifier((Definition)mainKey));
                            out.println(";");
                            out.println("\t}");
                        }
                        if ((uniqueKeys = table.getUniqueKeys()).size() > 0) {
                            out.println();
                            out.println("\t@Override");
                            out.println("\t@SuppressWarnings(\"unchecked\")");
                            out.print("\tpublic ");
                            out.print(List.class);
                            out.print("<");
                            out.print(UniqueKey.class);
                            out.print("<");
                            out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
                            out.println(">> getKeys() {");
                            out.print("\t\treturn ");
                            out.print(Arrays.class);
                            out.print(".<");
                            out.print(UniqueKey.class);
                            out.print("<");
                            out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
                            out.print(">>asList(");
                            String separator3 = "";
                            for (UniqueKeyDefinition uniqueKey : uniqueKeys) {
                                out.print(separator3);
                                out.print(this.strategy.getJavaPackageName((Definition)schema));
                                out.print(".Keys.");
                                out.print(this.strategy.getJavaIdentifier((Definition)uniqueKey));
                                separator3 = ", ";
                            }
                            out.println(");");
                            out.println("\t}");
                        }
                        if ((foreignKeys = table.getForeignKeys()).size() > 0) {
                            out.println();
                            out.println("\t@Override");
                            out.println("\t@SuppressWarnings(\"unchecked\")");
                            out.print("\tpublic ");
                            out.print(List.class);
                            out.print("<");
                            out.print(ForeignKey.class);
                            out.print("<");
                            out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
                            out.println(", ?>> getReferences() {");
                            out.print("\t\treturn ");
                            out.print(Arrays.class);
                            out.print(".<");
                            out.print(ForeignKey.class);
                            out.print("<");
                            out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
                            out.print(", ?>>asList(");
                            separator = "";
                            for (ForeignKeyDefinition foreignKey : foreignKeys) {
                                TableDefinition referencedTable = foreignKey.getReferencedTable();
                                if (referencedTable instanceof MasterDataTableDefinition) continue;
                                out.print(separator);
                                out.print(this.strategy.getJavaPackageName((Definition)schema));
                                out.print(".Keys.");
                                out.print(this.strategy.getJavaIdentifier((Definition)foreignKey));
                                separator = ", ";
                            }
                            out.println(");");
                            out.println("\t}");
                        }
                    }
                    if (this.generateInstanceFields()) {
                        out.println();
                        out.println("\t@Override");
                        out.print("\tpublic ");
                        out.print(this.strategy.getFullJavaClassName((Definition)table));
                        out.print(" as(");
                        out.print(String.class);
                        out.println(" alias) {");
                        out.print("\t\treturn new ");
                        out.print(this.strategy.getFullJavaClassName((Definition)table));
                        out.println("(alias);");
                        out.println("\t}");
                    }
                    out.printStaticInitialisationStatementsPlaceholder();
                    out.println("}");
                    out.close();
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating table " + table), (Throwable)e);
                }
            }
            this.registerInSchema(outS, database.getTables(schema), Table.class, true);
            watch.splitInfo("Tables generated");
        }
        if (this.generatePojos() && database.getTables(schema).size() > 0) {
            log.info((Object)"Generating table POJOs");
            for (MasterDataTableDefinition table : database.getTables(schema)) {
                try {
                    log.info((Object)"Generating table POJO", (Object)this.strategy.getFileName((Definition)table, GeneratorStrategy.Mode.POJO));
                    out = new GenerationWriter(this.strategy.getFile((Definition)table, GeneratorStrategy.Mode.POJO));
                    this.printHeader(out, (Definition)table, GeneratorStrategy.Mode.POJO);
                    this.printClassJavadoc(out, (Definition)table);
                    this.printTableJPAAnnotation(out, (TableDefinition)table);
                    out.print("public class ");
                    out.print(this.strategy.getJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO));
                    this.printExtends(out, (Definition)table, GeneratorStrategy.Mode.POJO);
                    this.printImplements(out, (Definition)table, GeneratorStrategy.Mode.POJO, new String[0]);
                    out.print(" {");
                    out.println();
                    out.printSerial();
                    out.println();
                    int maxLength = 0;
                    for (ColumnDefinition column : table.getColumns()) {
                        maxLength = Math.max(maxLength, this.getJavaType(column.getType()).length());
                    }
                    for (ColumnDefinition column : table.getColumns()) {
                        out.print("\tprivate ");
                        out.print(StringUtils.rightPad((String)this.getJavaType(column.getType()), (int)maxLength));
                        out.print(" ");
                        out.print(GenerationUtil.convertToJavaIdentifier(this.strategy.getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO)));
                        out.println(";");
                    }
                    for (ColumnDefinition column : table.getColumns()) {
                        out.println();
                        this.printColumnJPAAnnotation(out, column);
                        out.print("\tpublic ");
                        out.print(this.getJavaType(column.getType()));
                        out.print(" ");
                        out.print(this.strategy.getJavaGetterName((Definition)column, GeneratorStrategy.Mode.POJO));
                        out.println("() {");
                        out.print("\t\treturn this.");
                        out.print(GenerationUtil.convertToJavaIdentifier(this.strategy.getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO)));
                        out.println(";");
                        out.println("\t}");
                        out.println();
                        out.print("\tpublic void ");
                        out.print(this.strategy.getJavaSetterName((Definition)column, GeneratorStrategy.Mode.POJO));
                        out.print("(");
                        out.print(this.getJavaType(column.getType()));
                        out.print(" ");
                        out.print(GenerationUtil.convertToJavaIdentifier(this.strategy.getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO)));
                        out.println(") {");
                        out.print("\t\tthis.");
                        out.print(GenerationUtil.convertToJavaIdentifier(this.strategy.getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO)));
                        out.print(" = ");
                        out.print(GenerationUtil.convertToJavaIdentifier(this.strategy.getJavaMemberName((Definition)column, GeneratorStrategy.Mode.POJO)));
                        out.println(";");
                        out.println("\t}");
                    }
                    out.println("}");
                    out.close();
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating table POJO " + table), (Throwable)e);
                }
            }
            watch.splitInfo("Table POJOs generated");
        }
        if (database.getTables(schema).size() > 0) {
            log.info((Object)"Generating table references");
            out2 = new GenerationWriter(new File(targetSchemaDir, "Tables.java"));
            this.printHeader(out2, (Definition)schema);
            this.printClassJavadoc(out2, "Convenience access to all tables in " + schema.getOutputName());
            out2.println("public final class Tables {");
            for (TableDefinition table : database.getTables(schema)) {
                out2.println();
                out2.println("\t/**");
                if (!StringUtils.isBlank((String)table.getComment())) {
                    out2.println("\t * " + table.getComment());
                } else {
                    out2.println("\t * The table " + table.getQualifiedOutputName());
                }
                out2.println("\t */");
                out2.print("\tpublic static ");
                out2.print(this.strategy.getFullJavaClassName((Definition)table));
                out2.print(" ");
                out2.print(this.strategy.getJavaIdentifier((Definition)table));
                out2.print(" = ");
                out2.print(this.strategy.getFullJavaIdentifier((Definition)table));
                out2.println(";");
            }
            this.printPrivateConstructor(out2, "Tables");
            out2.println("}");
            out2.close();
            watch.splitInfo("Table references generated");
        }
        if (this.generateRelations() && database.getTables(schema).size() > 0) {
            String separator4;
            log.info((Object)"Generating Keys");
            out2 = new GenerationWriter(new File(targetSchemaDir, "Keys.java"));
            this.printHeader(out2, (Definition)schema);
            this.printClassJavadoc(out2, "A class modelling foreign key relationships between tables of the " + schema.getOutputName() + " schema");
            out2.suppressWarnings("unchecked");
            out2.print("public class Keys extends ");
            out2.print(AbstractKeys.class);
            out2.println(" {");
            out2.println();
            out2.println("\t// IDENTITY definitions");
            for (TableDefinition table : database.getTables(schema)) {
                try {
                    ColumnDefinition identity = table.getIdentity();
                    if (identity == null) continue;
                    out2.print("\tpublic static final ");
                    out2.print(Identity.class);
                    out2.print("<");
                    out2.print(this.strategy.getFullJavaClassName(identity.getContainer(), GeneratorStrategy.Mode.RECORD));
                    out2.print(", ");
                    out2.print(this.getJavaType(identity.getType()));
                    out2.print("> IDENTITY_");
                    out2.print(this.strategy.getJavaIdentifier(identity.getContainer()));
                    out2.print(" = createIdentity(");
                    out2.print(this.strategy.getFullJavaIdentifier(identity.getContainer()));
                    out2.print(", ");
                    out2.print(this.strategy.getFullJavaIdentifier((Definition)identity));
                    out2.println(");");
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating table " + table), (Throwable)e);
                }
            }
            out2.println();
            out2.println("\t// UNIQUE and PRIMARY KEY definitions");
            for (TableDefinition table : database.getTables(schema)) {
                try {
                    List uniqueKeys = table.getUniqueKeys();
                    if (uniqueKeys.size() <= 0) continue;
                    for (UniqueKeyDefinition uniqueKey : uniqueKeys) {
                        out2.print("\tpublic static final ");
                        out2.print(UniqueKey.class);
                        out2.print("<");
                        out2.print(this.strategy.getFullJavaClassName((Definition)uniqueKey.getTable(), GeneratorStrategy.Mode.RECORD));
                        out2.print("> ");
                        out2.print(this.strategy.getJavaIdentifier((Definition)uniqueKey));
                        out2.print(" = createUniqueKey(");
                        out2.print(this.strategy.getFullJavaIdentifier((Definition)uniqueKey.getTable()));
                        out2.print(", ");
                        separator4 = "";
                        for (ColumnDefinition column : uniqueKey.getKeyColumns()) {
                            out2.print(separator4);
                            out2.print(this.strategy.getFullJavaIdentifier((Definition)column));
                            separator4 = ", ";
                        }
                        out2.println(");");
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating table " + table), (Throwable)e);
                }
            }
            out2.println();
            out2.println("\t// FOREIGN KEY definitions");
            for (TableDefinition table : database.getTables(schema)) {
                try {
                    List foreignKeys = table.getForeignKeys();
                    if (foreignKeys.size() <= 0) continue;
                    for (ForeignKeyDefinition foreignKey : foreignKeys) {
                        if (foreignKey.getReferencedTable() instanceof MasterDataTableDefinition) continue;
                        out2.print("\tpublic static final ");
                        out2.print(ForeignKey.class);
                        out2.print("<");
                        out2.print(this.strategy.getFullJavaClassName((Definition)foreignKey.getKeyTable(), GeneratorStrategy.Mode.RECORD));
                        out2.print(", ");
                        out2.print(this.strategy.getFullJavaClassName((Definition)foreignKey.getReferencedTable(), GeneratorStrategy.Mode.RECORD));
                        out2.print("> ");
                        out2.print(this.strategy.getJavaIdentifier((Definition)foreignKey));
                        out2.print(" = createForeignKey(");
                        if (!foreignKey.getSchema().equals((Object)foreignKey.getReferencedKey().getSchema())) {
                            out2.print(this.strategy.getJavaPackageName((Definition)foreignKey.getReferencedKey().getSchema()));
                            out2.print(".Keys.");
                        }
                        out2.print(this.strategy.getJavaIdentifier((Definition)foreignKey.getReferencedKey()));
                        out2.print(", ");
                        out2.print(this.strategy.getFullJavaIdentifier((Definition)foreignKey.getKeyTable()));
                        out2.print(", ");
                        separator4 = "";
                        for (ColumnDefinition column : foreignKey.getKeyColumns()) {
                            out2.print(separator4);
                            out2.print(this.strategy.getFullJavaIdentifier((Definition)column));
                            separator4 = ", ";
                        }
                        out2.println(");");
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating reference " + table), (Throwable)e);
                }
            }
            this.printPrivateConstructor(out2, "Keys");
            out2.println("}");
            out2.close();
            watch.splitInfo("Keys generated");
        }
        if (this.generateRecords() && database.getTables(schema).size() > 0) {
            log.info((Object)"Generating records");
            for (MasterDataTableDefinition table : database.getTables(schema)) {
                try {
                    log.info((Object)"Generating record", (Object)this.strategy.getFileName((Definition)table, GeneratorStrategy.Mode.RECORD));
                    out = new GenerationWriter(this.strategy.getFile((Definition)table, GeneratorStrategy.Mode.RECORD));
                    this.printHeader(out, (Definition)table, GeneratorStrategy.Mode.RECORD);
                    this.printClassJavadoc(out, (Definition)table);
                    this.printTableJPAAnnotation(out, (TableDefinition)table);
                    Class baseClass = this.generateRelations() && table.getMainUniqueKey() != null ? UpdatableRecordImpl.class : TableRecordImpl.class;
                    out.print("public class ");
                    out.print(this.strategy.getJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
                    out.print(" extends ");
                    out.print(baseClass);
                    out.print("<");
                    out.print(this.strategy.getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
                    out.print(">");
                    this.printImplements(out, (Definition)table, GeneratorStrategy.Mode.RECORD, new String[0]);
                    out.println(" {");
                    out.printSerial();
                    for (ColumnDefinition column : table.getColumns()) {
                        this.printGetterAndSetter(out, (TypedElementDefinition<?>)column);
                    }
                    out.println();
                    out.println("\t/**");
                    out.println("\t * Create a detached " + this.strategy.getJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
                    out.println("\t */");
                    out.println("\tpublic " + this.strategy.getJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD) + "() {");
                    out.print("\t\tsuper(");
                    out.print(this.strategy.getFullJavaIdentifier((Definition)table));
                    out.println(");");
                    out.println("\t}");
                    out.println("}");
                    out.close();
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating table record " + table), (Throwable)e);
                }
            }
            watch.splitInfo("Table records generated");
        }
        if (database.getUDTs(schema).size() > 0) {
            log.info((Object)"Generating UDTs");
            for (UDTDefinition udt : database.getUDTs(schema)) {
                try {
                    log.info((Object)"Generating UDT ", (Object)this.strategy.getFileName((Definition)udt));
                    out = new GenerationWriter(this.strategy.getFile((Definition)udt));
                    this.printHeader(out, (Definition)udt);
                    this.printClassJavadoc(out, (Definition)udt);
                    out.print("public class ");
                    out.print(this.strategy.getJavaClassName((Definition)udt));
                    out.print(" extends ");
                    out.print(UDTImpl.class);
                    out.print("<");
                    out.print(this.strategy.getFullJavaClassName((Definition)udt, GeneratorStrategy.Mode.RECORD));
                    out.print(">");
                    if (udt.getRoutines().size() > 0) {
                        this.printImplements(out, (Definition)udt, GeneratorStrategy.Mode.DEFAULT, Package.class.getName());
                    } else {
                        this.printImplements(out, (Definition)udt, GeneratorStrategy.Mode.DEFAULT, new String[0]);
                    }
                    out.println(" {");
                    out.printSerial();
                    this.printSingletonInstance((Definition)udt, out);
                    this.printRecordTypeMethod((Definition)udt, out);
                    for (AttributeDefinition attribute : udt.getAttributes()) {
                        this.printUDTColumn(out, attribute, (Definition)udt);
                    }
                    for (RoutineDefinition routine : udt.getRoutines()) {
                        try {
                            if (!routine.isSQLUsable()) {
                                this.printConvenienceMethodProcedure(out, routine, false);
                                continue;
                            }
                            this.printConvenienceMethodFunction(out, routine, false);
                            this.printConvenienceMethodFunctionAsField(out, routine, false);
                            this.printConvenienceMethodFunctionAsField(out, routine, true);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error while generating routine " + routine), (Throwable)e);
                        }
                    }
                    out.println();
                    this.printNoFurtherInstancesAllowedJavadoc(out);
                    out.println("\tprivate " + this.strategy.getJavaClassName((Definition)udt) + "() {");
                    if (!schema.isDefaultSchema()) {
                        out.println("\t\tsuper(\"" + udt.getOutputName() + "\", " + this.strategy.getFullJavaIdentifier((Definition)schema) + ");");
                    } else {
                        out.println("\t\tsuper(\"" + udt.getOutputName() + "\");");
                    }
                    out.println("\t}");
                    out.println("}");
                    out.close();
                    if (outS == null) continue;
                    outS.printInitialisationStatement("addMapping(\"" + udt.getQualifiedOutputName() + "\", " + this.strategy.getFullJavaClassName((Definition)udt, GeneratorStrategy.Mode.RECORD) + ".class);");
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating udt " + udt), (Throwable)e);
                }
            }
            this.registerInSchema(outS, database.getUDTs(schema), UDT.class, true);
            watch.splitInfo("UDTs generated");
        }
        if (database.getUDTs(schema).size() > 0) {
            log.info((Object)"Generating UDT records");
            for (UDTDefinition udt : database.getUDTs(schema)) {
                try {
                    log.info((Object)"Generating UDT record", (Object)this.strategy.getFileName((Definition)udt, GeneratorStrategy.Mode.RECORD));
                    out = new GenerationWriter(this.strategy.getFile((Definition)udt, GeneratorStrategy.Mode.RECORD));
                    this.printHeader(out, (Definition)udt, GeneratorStrategy.Mode.RECORD);
                    this.printClassJavadoc(out, (Definition)udt);
                    out.print("public class ");
                    out.print(this.strategy.getJavaClassName((Definition)udt, GeneratorStrategy.Mode.RECORD));
                    out.print(" extends ");
                    out.print(UDTRecordImpl.class);
                    out.print("<");
                    out.print(this.strategy.getFullJavaClassName((Definition)udt, GeneratorStrategy.Mode.RECORD));
                    out.print(">");
                    this.printImplements(out, (Definition)udt, GeneratorStrategy.Mode.RECORD, new String[0]);
                    out.println(" {");
                    out.printSerial();
                    out.println();
                    for (AttributeDefinition attribute : udt.getAttributes()) {
                        this.printGetterAndSetter(out, (TypedElementDefinition<?>)attribute);
                    }
                    for (RoutineDefinition routine : udt.getRoutines()) {
                        try {
                            if (!routine.isSQLUsable()) {
                                this.printConvenienceMethodProcedure(out, routine, true);
                                continue;
                            }
                            this.printConvenienceMethodFunction(out, routine, true);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error while generating routine " + routine), (Throwable)e);
                        }
                    }
                    out.println();
                    out.println("\tpublic " + this.strategy.getJavaClassName((Definition)udt, GeneratorStrategy.Mode.RECORD) + "() {");
                    out.print("\t\tsuper(");
                    out.print(this.strategy.getFullJavaIdentifier((Definition)udt));
                    out.println(");");
                    out.println("\t}");
                    out.println("}");
                    out.close();
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating UDT record " + udt), (Throwable)e);
                }
            }
            watch.splitInfo("UDT records generated");
        }
        if (database.getUDTs(schema).size() > 0) {
            for (UDTDefinition udt : database.getUDTs(schema)) {
                if (udt.getRoutines().size() <= 0) continue;
                try {
                    log.info((Object)"Generating member routines");
                    for (RoutineDefinition routine : udt.getRoutines()) {
                        try {
                            this.printRoutine(database, schema, routine);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error while generating member routines " + routine), (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating UDT " + udt), (Throwable)e);
                }
                watch.splitInfo("Member procedures routines");
            }
        }
        if (database.getUDTs(schema).size() > 0) {
            log.info((Object)"Generating UDT references");
            out2 = new GenerationWriter(new File(targetSchemaDir, "UDTs.java"));
            this.printHeader(out2, (Definition)schema);
            this.printClassJavadoc(out2, "Convenience access to all UDTs in " + schema.getOutputName());
            out2.println("public final class UDTs {");
            for (UDTDefinition udt : database.getUDTs(schema)) {
                out2.println();
                out2.println("\t/**");
                out2.println("\t * The type " + udt.getQualifiedOutputName());
                out2.println("\t */");
                out2.print("\tpublic static ");
                out2.print(this.strategy.getFullJavaClassName((Definition)udt));
                out2.print(" ");
                out2.print(this.strategy.getJavaIdentifier((Definition)udt));
                out2.print(" = ");
                out2.print(this.strategy.getFullJavaIdentifier((Definition)udt));
                out2.println(";");
            }
            this.printPrivateConstructor(out2, "UDTs");
            out2.println("}");
            out2.close();
            watch.splitInfo("UDT references generated");
        }
        if (database.getArrays(schema).size() > 0) {
            log.info((Object)"Generating ARRAYs");
            for (ArrayDefinition array : database.getArrays(schema)) {
                try {
                    log.info((Object)"Generating ARRAY", (Object)this.strategy.getFileName((Definition)array, GeneratorStrategy.Mode.RECORD));
                    out = new GenerationWriter(this.strategy.getFile((Definition)array, GeneratorStrategy.Mode.RECORD));
                    this.printHeader(out, (Definition)array, GeneratorStrategy.Mode.RECORD);
                    this.printClassJavadoc(out, (Definition)array);
                    out.print("public class ");
                    out.print(this.strategy.getJavaClassName((Definition)array, GeneratorStrategy.Mode.RECORD));
                    out.print(" extends ");
                    out.print(ArrayRecordImpl.class);
                    out.print("<");
                    out.print(this.getJavaType(array.getElementType()));
                    out.print(">");
                    this.printImplements(out, (Definition)array, GeneratorStrategy.Mode.RECORD, new String[0]);
                    out.println(" {");
                    out.printSerial();
                    out.println();
                    out.print("\tpublic ");
                    out.print(this.strategy.getJavaClassName((Definition)array, GeneratorStrategy.Mode.RECORD));
                    out.print("(");
                    out.print(Configuration.class);
                    out.println(" configuration) {");
                    out.print("\t\tsuper(");
                    out.print(this.strategy.getFullJavaIdentifier((Definition)schema));
                    out.print(", \"");
                    out.print(array.getOutputName());
                    out.print("\", ");
                    out.print(this.getJavaTypeReference(database, array.getElementType()));
                    out.println(", configuration);");
                    out.println("\t}");
                    out.println();
                    out.print("\tpublic ");
                    out.print(this.strategy.getJavaClassName((Definition)array, GeneratorStrategy.Mode.RECORD));
                    out.print("(");
                    out.print(Configuration.class);
                    out.print(" configuration, ");
                    out.print(this.getJavaType(array.getElementType()));
                    out.print("... array");
                    out.println(") {");
                    out.println("\t\tthis(configuration);");
                    out.println("\t\tset(array);");
                    out.println("\t}");
                    out.println();
                    out.print("\tpublic ");
                    out.print(this.strategy.getJavaClassName((Definition)array, GeneratorStrategy.Mode.RECORD));
                    out.print("(");
                    out.print(Configuration.class);
                    out.print(" configuration, ");
                    out.print(List.class);
                    out.print("<? extends ");
                    out.print(this.getJavaType(array.getElementType()));
                    out.print("> list");
                    out.println(") {");
                    out.println("\t\tthis(configuration);");
                    out.println("\t\tsetList(list);");
                    out.println("\t}");
                    out.println("}");
                    out.close();
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating ARRAY record " + array), (Throwable)e);
                }
            }
            watch.splitInfo("ARRAYs generated");
        }
        if (database.getEnums(schema).size() > 0) {
            log.info((Object)"Generating ENUMs");
            for (EnumDefinition e : database.getEnums(schema)) {
                try {
                    log.info((Object)"Generating ENUM", (Object)this.strategy.getFileName((Definition)e, GeneratorStrategy.Mode.ENUM));
                    out = new GenerationWriter(this.strategy.getFile((Definition)e, GeneratorStrategy.Mode.ENUM));
                    this.printHeader(out, (Definition)e);
                    this.printClassJavadoc(out, (Definition)e);
                    out.print("public enum ");
                    out.print(this.strategy.getJavaClassName((Definition)e, GeneratorStrategy.Mode.ENUM));
                    this.printImplements(out, (Definition)e, GeneratorStrategy.Mode.ENUM, EnumType.class.getName());
                    out.print(" {");
                    out.println();
                    for (String literal : e.getLiterals()) {
                        out.println("\t" + GenerationUtil.convertToJavaIdentifier(literal) + "(\"" + literal + "\"),");
                        out.println();
                    }
                    out.println("\t;");
                    out.println();
                    out.println("\tprivate final java.lang.String literal;");
                    out.println();
                    out.println("\tprivate " + this.strategy.getJavaClassName((Definition)e, GeneratorStrategy.Mode.ENUM) + "(java.lang.String literal) {");
                    out.println("\t\tthis.literal = literal;");
                    out.println("\t}");
                    out.println();
                    out.println("\t@Override");
                    out.println("\tpublic java.lang.String getName() {");
                    if (e.isSynthetic()) {
                        out.println("\t\treturn null;");
                    } else {
                        out.println("\t\treturn \"" + e.getName() + "\";");
                    }
                    out.println("\t}");
                    out.println();
                    out.println("\t@Override");
                    out.println("\tpublic java.lang.String getLiteral() {");
                    out.println("\t\treturn literal;");
                    out.println("\t}");
                    out.println("}");
                    out.close();
                }
                catch (Exception ex) {
                    log.error((Object)("Error while generating enum " + e), (Throwable)ex);
                }
            }
            watch.splitInfo("Enums generated");
        }
        if (database.getRoutines(schema).size() > 0) {
            log.info((Object)"Generating routines");
            GenerationWriter outR = new GenerationWriter(new File(targetSchemaDir, "Routines.java"));
            this.printHeader(outR, (Definition)schema);
            this.printClassJavadoc(outR, "Convenience access to all stored procedures and functions in " + schema.getOutputName());
            outR.println("public final class Routines {");
            for (RoutineDefinition routine : database.getRoutines(schema)) {
                try {
                    this.printRoutine(database, schema, routine);
                    if (!routine.isSQLUsable()) {
                        this.printConvenienceMethodProcedure(outR, routine, false);
                        continue;
                    }
                    this.printConvenienceMethodFunction(outR, routine, false);
                    this.printConvenienceMethodFunctionAsField(outR, routine, false);
                    this.printConvenienceMethodFunctionAsField(outR, routine, true);
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating routine " + routine), (Throwable)e);
                }
            }
            this.printPrivateConstructor(outR, "Routines");
            outR.println("}");
            outR.close();
            watch.splitInfo("Routines generated");
        }
        if (database.getPackages(schema).size() > 0) {
            log.info((Object)"Generating packages");
            for (PackageDefinition pkg : database.getPackages(schema)) {
                try {
                    log.info((Object)"Generating package", (Object)pkg);
                    for (RoutineDefinition routine : pkg.getRoutines()) {
                        try {
                            this.printRoutine(database, schema, routine);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error while generating routine " + routine), (Throwable)e);
                        }
                    }
                    GenerationWriter outPkg = new GenerationWriter(this.strategy.getFile((Definition)pkg));
                    this.printHeader(outPkg, (Definition)pkg);
                    this.printClassJavadoc(outPkg, "Convenience access to all stored procedures and functions in " + pkg.getName());
                    outPkg.print("public final class ");
                    outPkg.print(this.strategy.getJavaClassName((Definition)pkg));
                    outPkg.print(" extends ");
                    outPkg.print(PackageImpl.class);
                    this.printImplements(outPkg, (Definition)pkg, GeneratorStrategy.Mode.DEFAULT, new String[0]);
                    outPkg.println(" {");
                    outPkg.printSerial();
                    this.printSingletonInstance((Definition)pkg, outPkg);
                    for (RoutineDefinition routine : pkg.getRoutines()) {
                        try {
                            if (!routine.isSQLUsable()) {
                                this.printConvenienceMethodProcedure(outPkg, routine, false);
                                continue;
                            }
                            this.printConvenienceMethodFunction(outPkg, routine, false);
                            this.printConvenienceMethodFunctionAsField(outPkg, routine, false);
                            this.printConvenienceMethodFunctionAsField(outPkg, routine, true);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error while generating routine " + routine), (Throwable)e);
                        }
                    }
                    this.printNoFurtherInstancesAllowedJavadoc(outPkg);
                    outPkg.println("\tprivate " + this.strategy.getJavaClassName((Definition)pkg) + "() {");
                    outPkg.print("\t\tsuper(\"");
                    outPkg.print(pkg.getOutputName());
                    outPkg.print("\", ");
                    outPkg.print(this.strategy.getFullJavaIdentifier((Definition)schema));
                    outPkg.println(");");
                    outPkg.println("\t}");
                    outPkg.println("}");
                    outPkg.close();
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating package " + pkg), (Throwable)e);
                }
            }
            watch.splitInfo("Packages generated");
        }
        if (outS != null) {
            outS.println("}");
            outS.close();
        }
        if (outF != null) {
            outF.println("}");
            outF.close();
        }
        watch.splitInfo("GENERATION FINISHED!");
    }

    private void printExtends(GenerationWriter out, Definition definition, GeneratorStrategy.Mode mode) {
        String superclass = this.strategy.getJavaClassExtends(definition, mode);
        if (!StringUtils.isBlank((String)superclass)) {
            out.print(" extends ");
            out.print(superclass);
        }
    }

    private void printImplements(GenerationWriter out, Definition definition, GeneratorStrategy.Mode mode, String ... forcedInterfaces) {
        List<String> interfaces = this.strategy.getJavaClassImplements(definition, mode);
        interfaces = new ArrayList(interfaces == null ? Collections.emptyList() : interfaces);
        interfaces.addAll(Arrays.asList(forcedInterfaces));
        if (!interfaces.isEmpty()) {
            String glue = " implements ";
            for (String i : new LinkedHashSet<String>(interfaces)) {
                if (StringUtils.isBlank((String)i)) continue;
                out.print(glue);
                out.print(i);
                glue = ", ";
            }
        }
    }

    private void printTableJPAAnnotation(GenerationWriter out, TableDefinition table) {
        SchemaDefinition schema = table.getSchema();
        if (this.generateJPAAnnotations()) {
            out.println("@javax.persistence.Entity");
            out.print("@javax.persistence.Table(name = \"");
            out.print(table.getName().replace("\"", "\\\""));
            out.print("\"");
            if (!schema.isDefaultSchema()) {
                out.print(", schema = \"");
                out.print(schema.getOutputName().replace("\"", "\\\""));
                out.print("\"");
            }
            StringBuilder sb = new StringBuilder();
            String glue1 = "";
            for (UniqueKeyDefinition uk : table.getUniqueKeys()) {
                if (uk.getKeyColumns().size() <= 1) continue;
                sb.append(glue1);
                sb.append("\t@javax.persistence.UniqueConstraint(columnNames = {");
                String glue2 = "";
                for (ColumnDefinition column : uk.getKeyColumns()) {
                    sb.append(glue2);
                    sb.append("\"");
                    sb.append(column.getName().replace("\"", "\\\""));
                    sb.append("\"");
                    glue2 = ", ";
                }
                sb.append("})");
                glue1 = ",\n";
            }
            if (sb.length() > 0) {
                out.println(", uniqueConstraints = {");
                out.println(sb);
                out.print("}");
            }
            out.println(")");
        }
    }

    private void printColumnJPAAnnotation(GenerationWriter out, ColumnDefinition column) {
        if (this.generateJPAAnnotations()) {
            UniqueKeyDefinition pk = column.getPrimaryKey();
            List uks = column.getUniqueKeys();
            if (pk != null && pk.getKeyColumns().size() == 1) {
                out.println("\t@javax.persistence.Id");
            }
            String unique = "";
            for (UniqueKeyDefinition uk : uks) {
                if (uk.getKeyColumns().size() != 1) continue;
                unique = ", unique = true";
                break;
            }
            String nullable = "";
            if (!column.isNullable()) {
                nullable = ", nullable = false";
            }
            String length = "";
            String precision = "";
            String scale = "";
            if (column.getType().getLength() > 0) {
                length = ", length = " + column.getType().getLength();
            } else if (column.getType().getPrecision() > 0) {
                precision = ", precision = " + column.getType().getPrecision();
                if (column.getType().getScale() > 0) {
                    scale = ", scale = " + column.getType().getScale();
                }
            }
            out.print("\t@javax.persistence.Column(name = \"");
            out.print(column.getName().replace("\"", "\\\""));
            out.print("\"");
            out.print(unique);
            out.print(nullable);
            out.print(length);
            out.print(precision);
            out.print(scale);
            out.println(")");
        }
    }

    private void registerInSchema(GenerationWriter outS, List<? extends Definition> definitions, Class<?> type, boolean isGeneric) {
        if (outS != null) {
            outS.println();
            this.printOverride(outS);
            outS.print("\tpublic final ");
            outS.print(List.class);
            outS.print("<");
            outS.print(type);
            if (isGeneric) {
                outS.print("<?>");
            }
            outS.print("> get");
            outS.print(type.getSimpleName());
            outS.println("s() {");
            outS.print("\t\treturn ");
            outS.print(Arrays.class);
            outS.print(".<");
            outS.print(type);
            if (isGeneric) {
                outS.print("<?>");
            }
            outS.print(">asList(");
            if (definitions.size() > 1) {
                outS.print("\n\t\t\t");
            }
            for (int i = 0; i < definitions.size(); ++i) {
                Definition def = definitions.get(i);
                if (i > 0) {
                    outS.print(",\n\t\t\t");
                }
                this.printSingletonReference(outS, def);
            }
            outS.println(");");
            outS.println("\t}");
        }
    }

    private void printRoutine(Database database, SchemaDefinition schema, RoutineDefinition routine) throws FileNotFoundException, SQLException {
        log.info((Object)"Generating routine", (Object)this.strategy.getFileName((Definition)routine));
        GenerationWriter out = new GenerationWriter(this.strategy.getFile((Definition)routine));
        this.printHeader(out, (Definition)routine);
        this.printClassJavadoc(out, (Definition)routine);
        out.print("public class ");
        out.print(this.strategy.getJavaClassName((Definition)routine));
        out.print(" extends ");
        out.print(AbstractRoutine.class);
        out.print("<");
        if (routine.getReturnValue() == null) {
            out.print(Void.class);
        } else {
            out.print(this.getJavaType(routine.getReturnType()));
        }
        out.print(">");
        this.printImplements(out, (Definition)routine, GeneratorStrategy.Mode.DEFAULT, new String[0]);
        out.println(" {");
        out.printSerial();
        out.println();
        for (ParameterDefinition parameter : routine.getAllParameters()) {
            this.printParameter(out, parameter, (Definition)routine);
        }
        out.println();
        this.printJavadoc(out, "Create a new routine call instance");
        out.println("\tpublic " + this.strategy.getJavaClassName((Definition)routine) + "() {");
        out.print("\t\tsuper(");
        out.print("\"");
        out.print(routine.getName());
        out.print("\", ");
        out.print(this.strategy.getFullJavaIdentifier((Definition)schema));
        if (routine.getPackage() != null) {
            out.print(", ");
            out.print(this.strategy.getFullJavaIdentifier((Definition)routine.getPackage()));
        }
        if (routine.getReturnValue() != null) {
            out.print(", ");
            out.print(this.getJavaTypeReference(database, routine.getReturnType()));
        }
        out.println(");");
        if (routine.getAllParameters().size() > 0) {
            out.println();
        }
        for (ParameterDefinition parameter : routine.getAllParameters()) {
            out.print("\t\t");
            if (parameter.equals(routine.getReturnValue())) {
                out.println("setReturnParameter(" + this.strategy.getJavaIdentifier((Definition)parameter) + ");");
                continue;
            }
            if (routine.getInParameters().contains(parameter)) {
                if (routine.getOutParameters().contains(parameter)) {
                    out.println("addInOutParameter(" + this.strategy.getJavaIdentifier((Definition)parameter) + ");");
                    continue;
                }
                out.println("addInParameter(" + this.strategy.getJavaIdentifier((Definition)parameter) + ");");
                continue;
            }
            out.println("addOutParameter(" + this.strategy.getJavaIdentifier((Definition)parameter) + ");");
        }
        if (routine.getOverload() != null) {
            out.println("\t\tsetOverloaded(true);");
        }
        out.println("\t}");
        for (ParameterDefinition parameter : routine.getInParameters()) {
            out.println();
            out.println("\t/**");
            out.println("\t * Set the <code>" + parameter.getOutputName() + "</code> parameter to the routine");
            out.println("\t */");
            out.print("\tpublic void ");
            out.print(this.strategy.getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT));
            out.print("(");
            this.printNumberType(out, parameter.getType());
            out.println(" value) {");
            out.print("\t\tset");
            if (parameter.getType().isGenericNumberType()) {
                out.print("Number");
            } else {
                out.print("Value");
            }
            out.print("(");
            out.print(this.strategy.getJavaIdentifier((Definition)parameter));
            out.println(", value);");
            out.println("\t}");
            if (!routine.isSQLUsable()) continue;
            out.println();
            out.println("\t/**");
            out.println("\t * Set the <code>" + parameter.getOutputName() + "</code> parameter to the function");
            out.println("\t * <p>");
            out.print("\t * Use this method only, if the function is called as a {@link ");
            out.print(Field.class);
            out.print("} in a {@link ");
            out.print(Select.class);
            out.println("} statement!");
            out.println("\t */");
            out.print("\tpublic void ");
            out.print(this.strategy.getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT));
            out.print("(");
            out.print(Field.class);
            out.print("<");
            this.printExtendsNumberType(out, parameter.getType());
            out.println("> field) {");
            out.print("\t\tset");
            if (parameter.getType().isGenericNumberType()) {
                out.print("Number");
            } else {
                out.print("Field");
            }
            out.print("(");
            out.print(this.strategy.getJavaIdentifier((Definition)parameter));
            out.println(", field);");
            out.println("\t}");
        }
        for (ParameterDefinition parameter : routine.getAllParameters()) {
            boolean isReturnValue = parameter.equals(routine.getReturnValue());
            boolean isOutParameter = routine.getOutParameters().contains(parameter);
            if (!isOutParameter || isReturnValue) continue;
            out.println();
            out.print("\tpublic ");
            out.print(this.getJavaType(parameter.getType()));
            out.print(" ");
            out.print(this.strategy.getJavaGetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT));
            out.println("() {");
            out.print("\t\treturn getValue(");
            out.print(this.strategy.getJavaIdentifier((Definition)parameter));
            out.println(");");
            out.println("\t}");
        }
        out.println("}");
        out.close();
    }

    private void printConvenienceMethodFunctionAsField(GenerationWriter out, RoutineDefinition function, boolean parametersAsField) throws SQLException {
        if (function.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        if (parametersAsField && function.getInParameters().isEmpty()) {
            return;
        }
        out.println();
        out.println("\t/**");
        out.println("\t * Get " + function.getQualifiedOutputName() + " as a field");
        out.println("\t *");
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.println("\t * @param " + this.strategy.getJavaMemberName((Definition)parameter));
        }
        out.println("\t */");
        out.print("\tpublic static ");
        out.print(Field.class);
        out.print("<");
        out.print(this.getJavaType(function.getReturnType()));
        out.print("> ");
        out.print(this.strategy.getJavaMethodName((Definition)function, GeneratorStrategy.Mode.DEFAULT));
        out.print("(");
        String separator = "";
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.print(separator);
            if (parametersAsField) {
                out.print(Field.class);
                out.print("<");
                this.printExtendsNumberType(out, parameter.getType());
                out.print(">");
            } else {
                this.printNumberType(out, parameter.getType());
            }
            out.print(" ");
            out.print(this.strategy.getJavaMemberName((Definition)parameter));
            separator = ", ";
        }
        out.println(") {");
        out.print("\t\t");
        out.print(this.strategy.getFullJavaClassName((Definition)function));
        out.print(" f = new ");
        out.print(this.strategy.getFullJavaClassName((Definition)function));
        out.println("();");
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.print("\t\tf.");
            out.print(this.strategy.getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT));
            out.print("(");
            out.print(this.strategy.getJavaMemberName((Definition)parameter));
            out.println(");");
        }
        out.println();
        out.println("\t\treturn f.asField();");
        out.println("\t}");
    }

    private void printConvenienceMethodFunction(GenerationWriter out, RoutineDefinition function, boolean instance) throws SQLException {
        if (function.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        out.println();
        out.println("\t/**");
        out.println("\t * Call " + function.getQualifiedOutputName());
        out.println("\t *");
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.println("\t * @param " + this.strategy.getJavaMemberName((Definition)parameter));
        }
        this.printThrowsDataAccessException(out);
        out.println("\t */");
        out.print("\tpublic ");
        if (!instance) {
            out.print("static ");
        }
        out.print(this.getJavaType(function.getReturnType()));
        out.print(" ");
        out.print(this.strategy.getJavaMethodName((Definition)function, GeneratorStrategy.Mode.DEFAULT));
        out.print("(");
        String glue = "";
        if (!instance) {
            out.print(Configuration.class);
            out.print(" configuration");
            glue = ", ";
        }
        for (ParameterDefinition parameter : function.getInParameters()) {
            if (instance && parameter.equals(function.getInParameters().get(0))) continue;
            out.print(glue);
            this.printNumberType(out, parameter.getType());
            out.print(" ");
            out.print(this.strategy.getJavaMemberName((Definition)parameter));
            glue = ", ";
        }
        out.println(") {");
        out.print("\t\t");
        out.print(this.strategy.getFullJavaClassName((Definition)function));
        out.print(" f = new ");
        out.print(this.strategy.getFullJavaClassName((Definition)function));
        out.println("();");
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.print("\t\tf.");
            out.print(this.strategy.getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT));
            out.print("(");
            if (instance && parameter.equals(function.getInParameters().get(0))) {
                out.print("this");
            } else {
                out.print(this.strategy.getJavaMemberName((Definition)parameter));
            }
            out.println(");");
        }
        out.println();
        out.print("\t\tf.execute(");
        if (instance) {
            out.print("getConfiguration()");
        } else {
            out.print("configuration");
        }
        out.println(");");
        out.println("\t\treturn f.getReturnValue();");
        out.println("\t}");
    }

    private void printThrowsDataAccessException(GenerationWriter out) {
        out.print("\t * @throws ");
        out.print(DataAccessException.class);
        out.print(" if something went wrong executing the query");
        out.println();
    }

    private void printPrivateConstructor(GenerationWriter out, String javaClassName) {
        out.println();
        out.println("\t/**");
        out.println("\t * No instances");
        out.println("\t */");
        out.println("\tprivate " + javaClassName + "() {}");
    }

    private void printConvenienceMethodProcedure(GenerationWriter out, RoutineDefinition procedure, boolean instance) throws SQLException {
        if (procedure.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Procedure " + procedure + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        out.println();
        out.println("\t/**");
        out.println("\t * Call " + procedure.getQualifiedOutputName());
        out.println("\t *");
        for (ParameterDefinition parameter : procedure.getAllParameters()) {
            out.print("\t * @param " + this.strategy.getJavaMemberName((Definition)parameter) + " ");
            if (procedure.getInParameters().contains(parameter)) {
                if (procedure.getOutParameters().contains(parameter)) {
                    out.println("IN OUT parameter");
                    continue;
                }
                out.println("IN parameter");
                continue;
            }
            out.println("OUT parameter");
        }
        this.printThrowsDataAccessException(out);
        out.println("\t */");
        out.print("\tpublic ");
        if (!instance) {
            out.print("static ");
        }
        if (procedure.getOutParameters().size() == 0) {
            out.print("void ");
        } else if (procedure.getOutParameters().size() == 1) {
            out.print(this.getJavaType(((ParameterDefinition)procedure.getOutParameters().get(0)).getType()));
            out.print(" ");
        } else {
            out.print(this.strategy.getFullJavaClassName((Definition)procedure) + " ");
        }
        out.print(this.strategy.getJavaMethodName((Definition)procedure, GeneratorStrategy.Mode.DEFAULT));
        out.print("(");
        String glue = "";
        if (!instance) {
            out.print(Configuration.class);
            out.print(" configuration");
            glue = ", ";
        }
        for (ParameterDefinition parameter : procedure.getInParameters()) {
            if (instance && parameter.equals(procedure.getInParameters().get(0))) continue;
            out.print(glue);
            this.printNumberType(out, parameter.getType());
            out.print(" ");
            out.print(this.strategy.getJavaMemberName((Definition)parameter));
            glue = ", ";
        }
        out.println(") {");
        out.print("\t\t");
        out.print(this.strategy.getFullJavaClassName((Definition)procedure));
        out.print(" p = new ");
        out.print(this.strategy.getFullJavaClassName((Definition)procedure));
        out.println("();");
        for (ParameterDefinition parameter : procedure.getInParameters()) {
            out.print("\t\tp.");
            out.print(this.strategy.getJavaSetterName((Definition)parameter, GeneratorStrategy.Mode.DEFAULT));
            out.print("(");
            if (instance && parameter.equals(procedure.getInParameters().get(0))) {
                out.print("this");
            } else {
                out.print(this.strategy.getJavaMemberName((Definition)parameter));
            }
            out.println(");");
        }
        out.println();
        out.print("\t\tp.execute(");
        if (instance) {
            out.print("getConfiguration()");
        } else {
            out.print("configuration");
        }
        out.println(");");
        if (procedure.getOutParameters().size() > 0) {
            if (instance) {
                out.print("\t\tfrom(p.");
                out.print(this.strategy.getJavaGetterName((Definition)procedure.getOutParameters().get(0), GeneratorStrategy.Mode.DEFAULT));
                out.println("());");
            }
            if (procedure.getOutParameters().size() == 1) {
                out.print("\t\treturn p.");
                out.print(this.strategy.getJavaGetterName((Definition)procedure.getOutParameters().get(0), GeneratorStrategy.Mode.DEFAULT));
                out.println("();");
            } else if (procedure.getOutParameters().size() > 1) {
                out.println("\t\treturn p;");
            }
        }
        out.println("\t}");
    }

    private void printRecordTypeMethod(Definition definition, GenerationWriter out) {
        out.println();
        out.println("\t/**");
        out.println("\t * The class holding records for this type");
        out.println("\t */");
        out.print("\tprivate static final ");
        out.print(Class.class);
        out.print("<");
        out.print(this.strategy.getFullJavaClassName(definition, GeneratorStrategy.Mode.RECORD));
        out.print("> __RECORD_TYPE = ");
        out.print(this.strategy.getFullJavaClassName(definition, GeneratorStrategy.Mode.RECORD));
        out.println(".class;");
        out.println();
        out.println("\t/**");
        out.println("\t * The class holding records for this type");
        out.println("\t */");
        this.printOverride(out);
        out.print("\tpublic ");
        out.print(Class.class);
        out.print("<");
        out.print(this.strategy.getFullJavaClassName(definition, GeneratorStrategy.Mode.RECORD));
        out.println("> getRecordType() {");
        out.println("\t\treturn __RECORD_TYPE;");
        out.println("\t}");
    }

    private void printSingletonInstance(Definition definition, GenerationWriter out) {
        out.println();
        out.println("\t/**");
        out.println("\t * The singleton instance of " + definition.getQualifiedOutputName());
        out.println("\t */");
        out.print("\tpublic static final ");
        out.print(this.strategy.getFullJavaClassName(definition));
        out.print(" ");
        out.print(this.strategy.getJavaIdentifier(definition));
        out.print(" = new ");
        out.print(this.strategy.getFullJavaClassName(definition));
        out.println("();");
    }

    private void printSingletonReference(GenerationWriter out, Definition definition) {
        if (definition instanceof SequenceDefinition) {
            out.print(this.strategy.getJavaPackageName((Definition)definition.getSchema()));
            out.print(".");
            out.print("Sequences");
            out.print(".");
            out.print(this.strategy.getJavaIdentifier(definition));
        } else {
            out.print(this.strategy.getFullJavaIdentifier(definition));
        }
    }

    private void printOverride(GenerationWriter out) {
        out.println("\t@Override");
    }

    private void empty(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                File[] children = file.listFiles();
                if (children != null) {
                    for (File child : children) {
                        this.empty(child);
                    }
                }
            } else if (file.getName().endsWith(".java")) {
                file.delete();
            }
        }
    }

    private void printGetterAndSetter(GenerationWriter out, TypedElementDefinition<?> element) throws SQLException {
        this.printFieldJavaDoc(out, element);
        out.println("\tpublic void " + this.strategy.getJavaSetterName((Definition)element, GeneratorStrategy.Mode.DEFAULT) + "(" + this.getJavaType(element.getType()) + " value) {");
        out.println("\t\tsetValue(" + this.strategy.getFullJavaIdentifier((Definition)element) + ", value);");
        out.println("\t}");
        this.printFieldJavaDoc(out, element);
        if (element instanceof ColumnDefinition) {
            this.printColumnJPAAnnotation(out, (ColumnDefinition)element);
        }
        out.println("\tpublic " + this.getJavaType(element.getType()) + " " + this.strategy.getJavaGetterName((Definition)element, GeneratorStrategy.Mode.DEFAULT) + "() {");
        out.println("\t\treturn getValue(" + this.strategy.getFullJavaIdentifier((Definition)element) + ");");
        out.println("\t}");
        if (this.generateRelations() && this.generateNavigationMethods() && element instanceof ColumnDefinition) {
            ColumnDefinition column = (ColumnDefinition)element;
            List uniqueKeys = column.getUniqueKeys();
            HashSet<String> fetchMethodNames = new HashSet<String>();
            for (UniqueKeyDefinition uniqueKey : uniqueKeys) {
                if (!out.printOnlyOnce(uniqueKey)) continue;
                for (ForeignKeyDefinition foreignKey : uniqueKey.getForeignKeys()) {
                    if (foreignKey.getReferencedColumns().size() != foreignKey.getKeyColumns().size()) {
                        log.warn((Object)"Foreign key mismatch", (Object)(foreignKey.getName() + " does not match its primary key! No code is generated for this key. See trac tickets #64 and #69"));
                        continue;
                    }
                    TableDefinition referencing = foreignKey.getKeyTable();
                    StringBuilder fetchMethodName = new StringBuilder();
                    fetchMethodName.append("fetch");
                    fetchMethodName.append(this.strategy.getJavaClassName((Definition)referencing));
                    fetchMethodName.append("List");
                    if (foreignKey.countSimilarReferences() > 1) {
                        fetchMethodName.append("By");
                        fetchMethodName.append(this.strategy.getJavaClassName((Definition)foreignKey.getKeyColumns().get(0)));
                    }
                    if (fetchMethodNames.contains(fetchMethodName.toString())) {
                        log.warn((Object)"Duplicate foreign key", (Object)(foreignKey.getName() + " has the same properties as another foreign key! No code is generated for this key. See trac ticket #1270"));
                        continue;
                    }
                    fetchMethodNames.add(fetchMethodName.toString());
                    this.printFieldJavaDoc(out, (TypedElementDefinition<?>)column);
                    out.print("\tpublic ");
                    out.print(List.class);
                    out.print("<");
                    out.print(this.strategy.getFullJavaClassName((Definition)referencing, GeneratorStrategy.Mode.RECORD));
                    out.print("> ");
                    out.print(fetchMethodName);
                    out.println("() {");
                    out.println("\t\treturn create()");
                    out.print("\t\t\t.selectFrom(");
                    out.print(this.strategy.getFullJavaIdentifier((Definition)referencing));
                    out.println(")");
                    String connector = "\t\t\t.where(";
                    for (int i = 0; i < foreignKey.getReferencedColumns().size(); ++i) {
                        out.print(connector);
                        out.print(this.strategy.getFullJavaIdentifier((Definition)foreignKey.getKeyColumns().get(i)));
                        out.print(".equal(getValue");
                        DataTypeDefinition foreignType = ((ColumnDefinition)foreignKey.getKeyColumns().get(i)).getType();
                        DataTypeDefinition primaryType = ((ColumnDefinition)uniqueKey.getKeyColumns().get(i)).getType();
                        if (!this.match(foreignType, primaryType)) {
                            out.print("As");
                            out.print(this.getSimpleJavaType(((ColumnDefinition)foreignKey.getKeyColumns().get(i)).getType()));
                        }
                        out.print("(");
                        out.print(this.strategy.getFullJavaIdentifier((Definition)uniqueKey.getKeyColumns().get(i)));
                        out.println(")))");
                        connector = "\t\t\t.and(";
                    }
                    out.println("\t\t\t.fetch();");
                    out.println("\t}");
                }
            }
            ForeignKeyDefinition foreignKey = column.getForeignKey();
            if (foreignKey != null && out.printOnlyOnce(foreignKey)) {
                TableDefinition referenced;
                boolean skipGeneration = false;
                if (foreignKey.getReferencedColumns().size() != foreignKey.getKeyColumns().size()) {
                    log.warn((Object)"Foreign key mismatch", (Object)(foreignKey.getName() + " does not match its primary key! No code is generated for this key. See trac tickets #64 and #69"));
                    skipGeneration = true;
                }
                if ((referenced = foreignKey.getReferencedTable()) instanceof MasterDataTableDefinition) {
                    skipGeneration = true;
                }
                if (!skipGeneration) {
                    this.printFieldJavaDoc(out, (TypedElementDefinition<?>)column);
                    out.print("\tpublic ");
                    out.print(this.strategy.getFullJavaClassName((Definition)referenced, GeneratorStrategy.Mode.RECORD));
                    out.print(" fetch");
                    out.print(this.strategy.getJavaClassName((Definition)referenced));
                    if (foreignKey.countSimilarReferences() > 1) {
                        out.print("By");
                        out.print(this.strategy.getJavaClassName((Definition)column));
                    }
                    out.println("() {");
                    out.println("\t\treturn create()");
                    out.print("\t\t\t.selectFrom(");
                    out.print(this.strategy.getFullJavaIdentifier((Definition)referenced));
                    out.println(")");
                    String connector = "\t\t\t.where(";
                    for (int i = 0; i < foreignKey.getReferencedColumns().size(); ++i) {
                        out.print(connector);
                        out.print(this.strategy.getFullJavaIdentifier((Definition)foreignKey.getReferencedColumns().get(i)));
                        out.print(".equal(getValue");
                        DataTypeDefinition foreignType = ((ColumnDefinition)foreignKey.getKeyColumns().get(i)).getType();
                        DataTypeDefinition primaryType = ((ColumnDefinition)foreignKey.getReferencedColumns().get(i)).getType();
                        if (!this.match(foreignType, primaryType)) {
                            out.print("As");
                            out.print(this.getSimpleJavaType(((ColumnDefinition)foreignKey.getReferencedColumns().get(i)).getType()));
                        }
                        out.print("(");
                        out.print(this.strategy.getFullJavaIdentifier((Definition)foreignKey.getKeyColumns().get(i)));
                        out.println(")))");
                        connector = "\t\t\t.and(";
                    }
                    out.println("\t\t\t.fetchOne();");
                    out.println("\t}");
                }
            }
        }
    }

    private void printUDTColumn(GenerationWriter out, AttributeDefinition attribute, Definition table) throws SQLException {
        Class<UDTField> declaredMemberClass = UDTField.class;
        this.printColumnDefinition(out, (TypedElementDefinition<?>)attribute, table, declaredMemberClass);
    }

    private void printTableColumn(GenerationWriter out, ColumnDefinition column, Definition table) throws SQLException {
        Class<TableField> declaredMemberClass = TableField.class;
        this.printColumnDefinition(out, (TypedElementDefinition<?>)column, table, declaredMemberClass);
    }

    private void printParameter(GenerationWriter out, ParameterDefinition parameter, Definition proc) throws SQLException {
        this.printColumnDefinition(out, (TypedElementDefinition<?>)parameter, proc, Parameter.class);
    }

    private void printColumnDefinition(GenerationWriter out, TypedElementDefinition<?> column, Definition type, Class<?> declaredMemberClass) throws SQLException {
        boolean isDefaulted;
        this.printFieldJavaDoc(out, column);
        boolean hasType = type instanceof TableDefinition || type instanceof UDTDefinition;
        boolean bl = isDefaulted = column instanceof ParameterDefinition && ((ParameterDefinition)column).isDefaulted();
        if (type instanceof TableDefinition) {
            if (this.generateInstanceFields()) {
                out.print("\tpublic final ");
            } else {
                out.print("\tpublic static final ");
            }
        } else {
            out.print("\tpublic static final ");
        }
        out.print(declaredMemberClass);
        out.print("<");
        if (hasType) {
            out.print(this.strategy.getFullJavaClassName(type, GeneratorStrategy.Mode.RECORD));
            out.print(", ");
        }
        out.print(this.getJavaType(column.getType()));
        out.print("> ");
        out.print(this.strategy.getJavaIdentifier((Definition)column));
        if (declaredMemberClass == TableField.class) {
            out.print(" = createField");
        } else if (declaredMemberClass == UDTField.class) {
            out.print(" = createField");
        } else {
            out.print(" = createParameter");
        }
        out.print("(\"");
        out.print(column.getName());
        out.print("\", ");
        out.print(this.getJavaTypeReference(column.getDatabase(), column.getType()));
        if (hasType) {
            if (type instanceof TableDefinition) {
                if (this.generateInstanceFields()) {
                    out.print(", this");
                } else {
                    out.print(", " + this.strategy.getJavaIdentifier(type));
                }
            } else {
                out.print(", " + this.strategy.getJavaIdentifier(type));
            }
        }
        if (isDefaulted) {
            out.print(", true");
        }
        out.println(");");
    }

    private void printFieldJavaDoc(GenerationWriter out, TypedElementDefinition<?> element) throws SQLException {
        this.printFieldJavaDoc(out, element, null);
    }

    private void printFieldJavaDoc(GenerationWriter out, TypedElementDefinition<?> element, String deprecation) throws SQLException {
        out.println();
        out.println("\t/**");
        String comment = element.getComment();
        if (comment != null && comment.length() > 0) {
            out.println("\t * " + comment);
        } else {
            out.println("\t * An uncommented item");
        }
        if (this.getJavaType(element.getType()).startsWith("java.lang.Object")) {
            String u;
            String t = element.getType().getType();
            String combined = t.equalsIgnoreCase(u = element.getType().getUserType()) ? t : t + ", " + u;
            out.println("\t * ");
            out.print("\t * The SQL type of this item (");
            out.print(combined);
            out.println(") could not be mapped.<br/>");
            out.println("\t * Deserialising this field might not work!");
            log.warn((Object)"Unknown type", (Object)(element.getQualifiedName() + " (" + combined + ")"));
        }
        if (element instanceof ColumnDefinition) {
            ColumnDefinition column = (ColumnDefinition)element;
            UniqueKeyDefinition primaryKey = column.getPrimaryKey();
            ForeignKeyDefinition foreignKey = column.getForeignKey();
            if (primaryKey != null) {
                out.println("\t * ");
                out.print("\t * PRIMARY KEY");
                out.println();
            }
            if (foreignKey != null) {
                out.println("\t * <p>");
                out.println("\t * <code><pre>");
                out.print("\t * CONSTRAINT ");
                out.println(foreignKey.getOutputName());
                out.print("\t * FOREIGN KEY (");
                String separator = "";
                for (ColumnDefinition fkColumn : foreignKey.getKeyColumns()) {
                    out.print(separator);
                    out.print(fkColumn.getOutputName());
                    separator = ", ";
                }
                out.println(")");
                out.print("\t * REFERENCES ");
                out.print(foreignKey.getReferencedTable().getQualifiedOutputName());
                out.print(" (");
                separator = "";
                for (ColumnDefinition fkColumn : foreignKey.getReferencedColumns()) {
                    out.print(separator);
                    out.print(fkColumn.getOutputName());
                    separator = ", ";
                }
                out.println(")");
                out.println("\t * </pre></code>");
            }
        }
        this.printDeprecation(out, deprecation);
        out.println("\t */");
        if (deprecation != null) {
            out.println("\t@Deprecated");
        }
    }

    private void printDeprecation(GenerationWriter out, String deprecation) {
        if (deprecation != null) {
            out.println("\t *");
            String[] strings = deprecation.split("[\n\r]+");
            for (int i = 0; i < strings.length; ++i) {
                if (i == 0) {
                    out.println("\t * @deprecated " + strings[i]);
                    continue;
                }
                out.println("\t *             " + strings[i]);
            }
        }
    }

    private void printNoFurtherInstancesAllowedJavadoc(GenerationWriter out) {
        this.printJavadoc(out, "No further instances allowed");
    }

    private void printJavadoc(GenerationWriter out, String doc) {
        out.println("\t/**");
        out.println("\t * " + doc);
        out.println("\t */");
    }

    private void printClassJavadoc(GenerationWriter out, Definition definition) {
        this.printClassJavadoc(out, definition.getComment());
    }

    private void printClassJavadoc(GenerationWriter out, String comment) {
        this.printClassJavadoc(out, comment, null);
    }

    private void printClassJavadoc(GenerationWriter out, String comment, String deprecation) {
        out.println("/**");
        out.println(" * This class is generated by jOOQ.");
        if (comment != null && comment.length() > 0) {
            out.println(" *");
            out.println(" * " + comment);
        }
        if (deprecation != null && deprecation.length() > 0) {
            out.println(" *");
            out.println(" * @deprecated : " + deprecation);
        }
        out.println(" */");
        if (this.generateGeneratedAnnotation()) {
            out.println("@javax.annotation.Generated(value    = {\"http://www.jooq.org\", \"2.2.2\"},\n                            comments = \"This class is generated by jOOQ\")");
        }
        if (deprecation != null && deprecation.length() > 0) {
            out.println("@Deprecated");
        }
        out.printSuppressWarningsPlaceholder();
    }

    private void printHeader(GenerationWriter out, Definition definition) {
        this.printHeader(out, definition, GeneratorStrategy.Mode.DEFAULT);
    }

    private void printHeader(GenerationWriter out, Definition definition, GeneratorStrategy.Mode mode) {
        out.println("/**");
        out.println(" * This class is generated by jOOQ");
        out.println(" */");
        out.println("package " + this.strategy.getJavaPackageName(definition, mode) + ";");
        out.println();
    }

    private void printExtendsNumberType(GenerationWriter out, DataTypeDefinition type) throws SQLException {
        this.printNumberType(out, type, "? extends ");
    }

    private void printNumberType(GenerationWriter out, DataTypeDefinition type) throws SQLException {
        this.printNumberType(out, type, "");
    }

    private void printNumberType(GenerationWriter out, DataTypeDefinition type, String prefix) throws SQLException {
        if (type.isGenericNumberType()) {
            out.print(prefix);
            out.print(Number.class);
        } else {
            out.print(this.getJavaType(type));
        }
    }

    private String getSimpleJavaType(DataTypeDefinition type) throws SQLException {
        return GenerationUtil.getSimpleJavaType(this.getJavaType(type));
    }

    private String getJavaTypeReference(Database db, DataTypeDefinition type) throws SQLException {
        if (type instanceof MasterDataTypeDefinition) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getJavaTypeReference(db, ((MasterDataTypeDefinition)type).underlying));
            sb.append(".asMasterDataType(");
            sb.append(this.getJavaType(type));
            sb.append(".class)");
            return sb.toString();
        }
        if (db.isArrayType(type.getType())) {
            String baseType = GenerationUtil.getArrayBaseType(db.getDialect(), type.getType(), type.getUserType());
            return this.getTypeReference(db, type.getSchema(), baseType, 0, 0, baseType) + ".getArrayDataType()";
        }
        return this.getTypeReference(db, type.getSchema(), type.getType(), type.getPrecision(), type.getScale(), type.getUserType());
    }

    private String getJavaType(DataTypeDefinition type) throws SQLException {
        if (type instanceof MasterDataTypeDefinition) {
            return this.strategy.getFullJavaClassName((Definition)((MasterDataTypeDefinition)type).table);
        }
        return this.getType(type.getDatabase(), type.getSchema(), type.getType(), type.getPrecision(), type.getScale(), type.getUserType(), Object.class.getName());
    }

    private String getType(Database db, SchemaDefinition schema, String t, int p, int s, String u, String defaultType) throws SQLException {
        String type;
        block14: {
            type = defaultType;
            if (db.isArrayType(t)) {
                String baseType = GenerationUtil.getArrayBaseType(db.getDialect(), t, u);
                type = this.getType(db, schema, baseType, p, s, baseType, defaultType) + "[]";
            } else if (db.getArray(schema, u) != null) {
                type = this.strategy.getFullJavaClassName((Definition)db.getArray(schema, u), GeneratorStrategy.Mode.RECORD);
            } else if (db.getEnum(schema, u) != null) {
                type = this.strategy.getFullJavaClassName((Definition)db.getEnum(schema, u));
            } else if (db.getUDT(schema, u) != null) {
                type = this.strategy.getFullJavaClassName((Definition)db.getUDT(schema, u), GeneratorStrategy.Mode.RECORD);
            } else if (db.getConfiguredCustomType(u) != null) {
                type = u;
            } else {
                try {
                    Class clazz = FieldTypeHelper.getDialectJavaType((SQLDialect)db.getDialect(), (String)t, (int)p, (int)s);
                    type = clazz.getCanonicalName();
                    if (clazz.getTypeParameters().length > 0) {
                        type = type + "<";
                        String separator = "";
                        for (TypeVariable var : clazz.getTypeParameters()) {
                            type = type + separator;
                            type = type + ((Class)var.getBounds()[0]).getCanonicalName();
                            separator = ", ";
                        }
                        type = type + ">";
                    }
                }
                catch (SQLDialectNotSupportedException e) {
                    if (defaultType != null) break block14;
                    throw e;
                }
            }
        }
        return type;
    }

    private String getTypeReference(Database db, SchemaDefinition schema, String t, int p, int s, String u) throws SQLException {
        StringBuilder sb = new StringBuilder();
        if (db.getArray(schema, u) != null) {
            ArrayDefinition array = db.getArray(schema, u);
            sb.append(this.getJavaTypeReference(db, array.getElementType()));
            sb.append(".asArrayDataType(");
            sb.append(this.strategy.getFullJavaClassName((Definition)array, GeneratorStrategy.Mode.RECORD));
            sb.append(".class)");
        } else if (db.getUDT(schema, u) != null) {
            UDTDefinition udt = db.getUDT(schema, u);
            sb.append(this.strategy.getFullJavaIdentifier((Definition)udt));
            sb.append(".getDataType()");
        } else if (db.getEnum(schema, u) != null) {
            sb.append("org.jooq.util.");
            sb.append(db.getDialect().getName().toLowerCase());
            sb.append(".");
            sb.append(db.getDialect().getName());
            sb.append("DataType.");
            sb.append(FieldTypeHelper.normalise((String)FieldTypeHelper.getDataType((SQLDialect)db.getDialect(), String.class).getTypeName()));
            sb.append(".asEnumDataType(");
            sb.append(this.strategy.getFullJavaClassName((Definition)db.getEnum(schema, u)));
            sb.append(".class)");
        } else {
            DataType dataType = null;
            try {
                dataType = FieldTypeHelper.getDialectDataType((SQLDialect)db.getDialect(), (String)t, (int)p, (int)s);
            }
            catch (SQLDialectNotSupportedException ignore) {
                // empty catch block
            }
            if (dataType != null && dataType.getSQLDataType() != null) {
                SQLDataType sqlDataType = dataType.getSQLDataType();
                sb.append(SQLDataType.class.getCanonicalName());
                sb.append(".");
                sb.append(FieldTypeHelper.normalise((String)sqlDataType.getTypeName()));
                if (db.getConfiguredCustomType(u) != null) {
                    sb.append(".asConvertedDataType(new ");
                    sb.append(db.getConfiguredCustomType(u).getConverter());
                    sb.append("())");
                }
            } else {
                String typeClass = "org.jooq.util." + db.getDialect().getName().toLowerCase() + "." + db.getDialect().getName() + "DataType";
                sb.append(typeClass);
                sb.append(".");
                try {
                    String type1 = this.getType(db, schema, t, p, s, u, null);
                    String type2 = this.getType(db, schema, t, 0, 0, u, null);
                    String typeName = FieldTypeHelper.normalise((String)t);
                    Reflect.on((String)typeClass).field(typeName);
                    sb.append(typeName);
                    if (!type1.equals(type2)) {
                        Class clazz = FieldTypeHelper.getDialectJavaType((SQLDialect)db.getDialect(), (String)t, (int)p, (int)s);
                        sb.append(".asNumberDataType(");
                        sb.append(clazz.getCanonicalName());
                        sb.append(".class)");
                    }
                }
                catch (SQLDialectNotSupportedException e) {
                    sb.append("getDefaultDataType(\"");
                    sb.append(t);
                    sb.append("\")");
                }
                catch (ReflectException e) {
                    sb.append("getDefaultDataType(\"");
                    sb.append(t);
                    sb.append("\")");
                }
            }
        }
        return sb.toString();
    }

    private boolean match(DataTypeDefinition type1, DataTypeDefinition type2) throws SQLException {
        return this.getJavaType(type1).equals(this.getJavaType(type2));
    }
}

