/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jooq.impl.TableRecordImpl;
import org.jooq.impl.UDTRecordImpl;
import org.jooq.impl.UpdatableRecordImpl;
import org.jooq.tools.StringUtils;
import org.jooq.util.AbstractGeneratorStrategy;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.AttributeDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Definition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.GenerationUtil;
import org.jooq.util.GeneratorStrategy;
import org.jooq.util.MasterDataTableDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.TypedElementDefinition;
import org.jooq.util.UDTDefinition;

public class DefaultGeneratorStrategy
extends AbstractGeneratorStrategy {
    private final Map<Class<?>, Set<String>> reservedColumns = new HashMap();
    private String targetDirectory;
    private String targetPackage;
    private boolean instanceFields;

    @Override
    public final void setInstanceFields(boolean instanceFields) {
        this.instanceFields = instanceFields;
    }

    @Override
    public final boolean getInstanceFields() {
        return this.instanceFields;
    }

    @Override
    public final String getTargetDirectory() {
        return this.targetDirectory;
    }

    @Override
    public final void setTargetDirectory(String directory) {
        this.targetDirectory = directory;
    }

    @Override
    public final String getTargetPackage() {
        return this.targetPackage;
    }

    @Override
    public final void setTargetPackage(String packageName) {
        this.targetPackage = packageName;
    }

    @Override
    public String getJavaIdentifier(Definition definition) {
        TypedElementDefinition e;
        String identifier = GenerationUtil.convertToJavaIdentifier(definition.getOutputName().toUpperCase());
        if ((definition instanceof ColumnDefinition || definition instanceof AttributeDefinition) && identifier.equals(this.getJavaIdentifier((e = (TypedElementDefinition)definition).getContainer()))) {
            return identifier + "_";
        }
        return identifier;
    }

    @Override
    public String getJavaSetterName(Definition definition, GeneratorStrategy.Mode mode) {
        return "set" + this.disambiguateMethod(definition, this.getJavaClassName0(definition, GeneratorStrategy.Mode.DEFAULT));
    }

    @Override
    public String getJavaGetterName(Definition definition, GeneratorStrategy.Mode mode) {
        return "get" + this.disambiguateMethod(definition, this.getJavaClassName0(definition, GeneratorStrategy.Mode.DEFAULT));
    }

    @Override
    public String getJavaMethodName(Definition definition, GeneratorStrategy.Mode mode) {
        return this.disambiguateMethod(definition, this.getJavaClassName0LC(definition, GeneratorStrategy.Mode.DEFAULT));
    }

    private String disambiguateMethod(Definition definition, String javaClassName) {
        Set<String> reserved = null;
        if (definition instanceof AttributeDefinition) {
            reserved = this.reservedColumns(UDTRecordImpl.class);
        } else if (definition instanceof ColumnDefinition) {
            reserved = ((TableDefinition)((ColumnDefinition)definition).getContainer()).getMainUniqueKey() != null ? this.reservedColumns(UpdatableRecordImpl.class) : this.reservedColumns(TableRecordImpl.class);
        }
        if (reserved != null && reserved.contains(javaClassName)) {
            return javaClassName + "_";
        }
        return javaClassName;
    }

    private Set<String> reservedColumns(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        Set<String> result = this.reservedColumns.get(clazz);
        if (result == null) {
            result = new HashSet<String>();
            this.reservedColumns.put(clazz, result);
            result.addAll(this.reservedColumns(clazz.getSuperclass()));
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                result.addAll(this.reservedColumns(clazz2));
            }
            for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
                String name = ((Method)genericDeclaration).getName();
                if (!name.startsWith("get") || ((Method)genericDeclaration).getParameterTypes().length != 0) continue;
                result.add(name.substring(3));
            }
        }
        return result;
    }

    @Override
    public String getJavaClassName(Definition definition, GeneratorStrategy.Mode mode) {
        return this.getJavaClassName0(definition, mode);
    }

    @Override
    public String getJavaPackageName(Definition definition, GeneratorStrategy.Mode mode) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTargetPackage());
        if (definition.getDatabase().getSchemata().size() > 1) {
            sb.append(".");
            sb.append(GenerationUtil.convertToJavaIdentifier(definition.getSchema().getOutputName()).toLowerCase());
        }
        if (!StringUtils.isBlank((String)this.getSubPackage(definition))) {
            sb.append(".");
            sb.append(this.getSubPackage(definition));
        }
        if (mode == GeneratorStrategy.Mode.RECORD) {
            sb.append(".records");
        } else if (mode == GeneratorStrategy.Mode.POJO) {
            sb.append(".pojos");
        }
        return sb.toString();
    }

    @Override
    public String getJavaMemberName(Definition definition, GeneratorStrategy.Mode mode) {
        return this.getJavaClassName0LC(definition, mode);
    }

    private String getJavaClassName0LC(Definition definition, GeneratorStrategy.Mode mode) {
        String result = this.getJavaClassName0(definition, mode);
        return result.substring(0, 1).toLowerCase() + result.substring(1);
    }

    private String getJavaClassName0(Definition definition, GeneratorStrategy.Mode mode) {
        StringBuilder result = new StringBuilder();
        String name = GenerationUtil.convertToJavaIdentifier(definition.getOutputName());
        result.append(StringUtils.toCamelCase((String)name));
        if (mode == GeneratorStrategy.Mode.RECORD) {
            result.append("Record");
        } else if (mode == GeneratorStrategy.Mode.FACTORY) {
            result.append("Factory");
        }
        if (!StringUtils.isBlank((String)definition.getOverload())) {
            result.append(definition.getOverload());
        }
        return result.toString();
    }

    private final String getSubPackage(Definition definition) {
        if (definition instanceof MasterDataTableDefinition) {
            return "enums";
        }
        if (definition instanceof TableDefinition) {
            return "tables";
        }
        if (definition instanceof UDTDefinition) {
            return "udt";
        }
        if (definition instanceof PackageDefinition) {
            return "packages";
        }
        if (definition instanceof RoutineDefinition) {
            RoutineDefinition routine = (RoutineDefinition)definition;
            if (routine.getPackage() instanceof UDTDefinition) {
                return "udt." + this.getJavaIdentifier((Definition)routine.getPackage()).toLowerCase();
            }
            if (routine.getPackage() != null) {
                return "packages." + this.getJavaIdentifier((Definition)routine.getPackage()).toLowerCase();
            }
            return "routines";
        }
        if (definition instanceof EnumDefinition) {
            return "enums";
        }
        if (definition instanceof ArrayDefinition) {
            return "udt";
        }
        return "";
    }
}

