/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.util.AbstractGeneratorStrategy;
import org.jooq.util.Definition;
import org.jooq.util.GenerationUtil;
import org.jooq.util.GeneratorStrategy;

class GeneratorStrategyWrapper
extends AbstractGeneratorStrategy {
    private static final JooqLogger log = JooqLogger.getLogger(GeneratorStrategyWrapper.class);
    final GeneratorStrategy delegate;

    GeneratorStrategyWrapper(GeneratorStrategy delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getTargetDirectory() {
        return this.delegate.getTargetDirectory();
    }

    @Override
    public void setTargetDirectory(String directory) {
        this.delegate.setTargetDirectory(directory);
    }

    @Override
    public String getTargetPackage() {
        return this.delegate.getTargetPackage();
    }

    @Override
    public void setTargetPackage(String packageName) {
        this.delegate.setTargetPackage(packageName);
    }

    @Override
    public void setInstanceFields(boolean instanceFields) {
        this.delegate.setInstanceFields(instanceFields);
    }

    @Override
    public boolean getInstanceFields() {
        return this.delegate.getInstanceFields();
    }

    @Override
    public String getJavaIdentifier(Definition definition) {
        return GenerationUtil.convertToJavaIdentifier(this.delegate.getJavaIdentifier(definition));
    }

    @Override
    public String getJavaSetterName(Definition definition, GeneratorStrategy.Mode mode) {
        return GenerationUtil.convertToJavaIdentifier(this.delegate.getJavaSetterName(definition, mode));
    }

    @Override
    public String getJavaGetterName(Definition definition, GeneratorStrategy.Mode mode) {
        return GenerationUtil.convertToJavaIdentifier(this.delegate.getJavaGetterName(definition, mode));
    }

    @Override
    public String getJavaMethodName(Definition definition, GeneratorStrategy.Mode mode) {
        return GenerationUtil.convertToJavaIdentifier(this.delegate.getJavaMethodName(definition, mode));
    }

    @Override
    public String getJavaClassName(Definition definition, GeneratorStrategy.Mode mode) {
        String alternative;
        String className = GenerationUtil.convertToJavaIdentifier(this.delegate.getJavaClassName(definition, mode));
        if (mode == GeneratorStrategy.Mode.FACTORY && className.equalsIgnoreCase(alternative = GenerationUtil.convertToJavaIdentifier(this.delegate.getJavaClassName(definition, GeneratorStrategy.Mode.DEFAULT)))) {
            log.warn((Object)"Configuration problem", (Object)"Factory has the same name as Schema, forcing Factory suffix. Consider correcting your strategy");
            className = className + "Factory";
        }
        return className;
    }

    @Override
    public String getJavaPackageName(Definition definition, GeneratorStrategy.Mode mode) {
        Object[] split = this.delegate.getJavaPackageName(definition, mode).split("\\.");
        for (int i = 0; i < split.length; ++i) {
            split[i] = GenerationUtil.convertToJavaIdentifier((String)split[i]);
        }
        return StringUtils.join((Object[])split, (String)".");
    }

    @Override
    public String getJavaMemberName(Definition definition, GeneratorStrategy.Mode mode) {
        return GenerationUtil.convertToJavaIdentifier(this.delegate.getJavaMemberName(definition, mode));
    }
}

