/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import org.jooq.SQLDialect;
import org.jooq.SQLDialectNotSupportedException;
import org.jooq.util.h2.H2DataType;

class GenerationUtil {
    GenerationUtil() {
    }

    static String convertToJavaIdentifier(String literal) {
        StringBuilder sb = new StringBuilder();
        if ("".equals(literal)) {
            return "_";
        }
        if (!Character.isJavaIdentifierStart(literal.charAt(0))) {
            sb.append("_");
        }
        for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                sb.append("_");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static String getSimpleJavaType(String qualifiedJavaType) {
        if (qualifiedJavaType == null) {
            return null;
        }
        return qualifiedJavaType.replaceAll(".*\\.", "");
    }

    static String getArrayBaseType(SQLDialect dialect, String t, String u) {
        switch (dialect) {
            case POSTGRES: {
                if (u != null && u.startsWith("_")) {
                    return u.substring(1);
                }
                return u;
            }
            case H2: {
                return H2DataType.OTHER.getTypeName();
            }
            case HSQLDB: {
                if ("ARRAY".equalsIgnoreCase(t)) {
                    return "OTHER";
                }
                return t.replace(" ARRAY", "");
            }
        }
        throw new SQLDialectNotSupportedException("getArrayBaseType() is not supported for dialect " + dialect);
    }
}

