/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.File;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jooq.impl.StringUtils;
import org.jooq.impl.TableRecordImpl;
import org.jooq.impl.UDTRecordImpl;
import org.jooq.impl.UpdatableRecordImpl;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.AttributeDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Definition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.GenerationUtil;
import org.jooq.util.GeneratorStrategy;
import org.jooq.util.MasterDataTableDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.TypedElementDefinition;
import org.jooq.util.UDTDefinition;

public class DefaultGeneratorStrategy
implements GeneratorStrategy {
    private final Map<Class<?>, Set<String>> reservedColumns = new HashMap();
    private String targetDirectory;
    private String targetPackage;
    private String tableClassPrefix;
    private String tableClassSuffix;
    private String recordClassPrefix;
    private String recordClassSuffix;
    private String scheme;

    @Override
    public void setMetaClassPrefix(String prefix) {
        this.tableClassPrefix = prefix;
    }

    @Override
    public void setMetaClassSuffix(String suffix) {
        this.tableClassSuffix = suffix;
    }

    @Override
    public void setRecordClassPrefix(String prefix) {
        this.recordClassPrefix = prefix;
    }

    @Override
    public void setRecordClassSuffix(String suffix) {
        this.recordClassSuffix = suffix;
    }

    @Override
    public void setMemberScheme(String scheme) {
        this.scheme = scheme;
    }

    @Override
    public final String getTargetDirectory() {
        return this.targetDirectory;
    }

    @Override
    public final void setTargetDirectory(String directory) {
        this.targetDirectory = directory;
    }

    @Override
    public final String getTargetPackage() {
        return this.targetPackage;
    }

    @Override
    public final void setTargetPackage(String packageName) {
        this.targetPackage = packageName;
    }

    @Override
    public final String getFileName(Definition definition) {
        return this.getJavaClassName(definition) + ".java";
    }

    @Override
    public final String getFileName(Definition definition, String suffix) {
        return this.getJavaClassName(definition) + suffix + ".java";
    }

    @Override
    public final File getFile(Definition definition) {
        return this.getFile(definition, "");
    }

    @Override
    public final File getFile(Definition definition, String suffix) {
        String dir = this.getTargetDirectory();
        String pkg = this.getJavaPackageName(definition, suffix).replaceAll("\\.", "/");
        return new File(dir + "/" + pkg, this.getFileName(definition, suffix));
    }

    @Override
    public final String getJavaIdentifier(Definition definition) {
        return GenerationUtil.convertToJavaIdentifier(definition.getName());
    }

    @Override
    public String getJavaIdentifierUC(Definition definition) {
        TypedElementDefinition e;
        String identifier = this.getJavaIdentifier(definition).toUpperCase();
        if ((definition instanceof ColumnDefinition || definition instanceof AttributeDefinition) && identifier.equals(this.getJavaIdentifierUC((e = (TypedElementDefinition)definition).getContainer()))) {
            return identifier + "_";
        }
        return identifier;
    }

    @Override
    public final String getFullJavaIdentifierUC(Definition definition) {
        StringBuilder sb = new StringBuilder();
        if (definition instanceof TypedElementDefinition) {
            sb.append(this.getFullJavaClassName(((TypedElementDefinition)definition).getContainer()));
        } else {
            sb.append(this.getFullJavaClassName(definition));
        }
        sb.append(".");
        sb.append(this.getJavaIdentifierUC(definition));
        return sb.toString();
    }

    @Override
    public String getJavaSetterName(Definition definition) {
        return "set" + this.disambiguateMethod(definition, this.getJavaClassName(definition));
    }

    @Override
    public String getJavaGetterName(Definition definition) {
        return "get" + this.disambiguateMethod(definition, this.getJavaClassName(definition));
    }

    private String disambiguateMethod(Definition definition, String javaClassName) {
        Set<String> reserved = null;
        if (definition instanceof AttributeDefinition) {
            reserved = this.reservedColumns(UDTRecordImpl.class);
        } else if (definition instanceof ColumnDefinition) {
            reserved = ((TableDefinition)((ColumnDefinition)definition).getContainer()).getMainUniqueKey() != null ? this.reservedColumns(UpdatableRecordImpl.class) : this.reservedColumns(TableRecordImpl.class);
        }
        if (reserved != null && reserved.contains(javaClassName)) {
            return javaClassName + "_";
        }
        return javaClassName;
    }

    private Set<String> reservedColumns(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        Set<String> result = this.reservedColumns.get(clazz);
        if (result == null) {
            result = new HashSet<String>();
            this.reservedColumns.put(clazz, result);
            result.addAll(this.reservedColumns(clazz.getSuperclass()));
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                result.addAll(this.reservedColumns(clazz2));
            }
            for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
                String name = ((Method)genericDeclaration).getName();
                if (!name.startsWith("get") || ((Method)genericDeclaration).getParameterTypes().length != 0) continue;
                result.add(name.substring(3));
            }
        }
        return result;
    }

    @Override
    public final String getJavaClassName(Definition definition) {
        return this.getJavaClassName(definition, "");
    }

    @Override
    public final String getJavaClassName(Definition definition, String suffix) {
        return this.getJavaClassName0(definition, suffix);
    }

    @Override
    public final String getJavaPackageName(Definition definition) {
        return this.getJavaPackageName(definition, "");
    }

    @Override
    public final String getJavaPackageName(Definition definition, String suffix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTargetPackage());
        if (!StringUtils.isBlank((String)this.getSubPackage(definition))) {
            sb.append(".");
            sb.append(this.getSubPackage(definition));
        }
        if ("Record".equals(suffix)) {
            sb.append(".records");
        }
        return sb.toString();
    }

    @Override
    public final String getJavaClassNameLC(Definition definition) {
        return this.getJavaClassNameLC(definition, "");
    }

    @Override
    public final String getJavaClassNameLC(Definition definition, String suffix) {
        String result = this.getJavaClassName0(definition, suffix);
        return result.substring(0, 1).toLowerCase() + result.substring(1);
    }

    private final String getJavaClassName0(Definition definition, String suffix) {
        StringBuilder result = new StringBuilder();
        String name = GenerationUtil.convertToJavaIdentifier(definition.getName());
        result.append(StringUtils.toCamelCase((String)name));
        if (!StringUtils.isEmpty((String)suffix)) {
            result.append(suffix);
        }
        if (!StringUtils.isBlank((String)definition.getOverload())) {
            result.append(definition.getOverload());
        }
        return result.toString();
    }

    @Override
    public final String getFullJavaClassName(Definition definition) {
        return this.getFullJavaClassName(definition, "");
    }

    @Override
    public final String getFullJavaClassName(Definition definition, String suffix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getJavaPackageName(definition, suffix));
        sb.append(".");
        sb.append(this.getJavaClassName(definition, suffix));
        return sb.toString();
    }

    @Override
    public final String getSubPackage(Definition definition) {
        if (definition instanceof MasterDataTableDefinition) {
            return "enums";
        }
        if (definition instanceof TableDefinition) {
            return "tables";
        }
        if (definition instanceof PackageDefinition) {
            return "packages";
        }
        if (definition instanceof RoutineDefinition) {
            RoutineDefinition routine = (RoutineDefinition)definition;
            if (routine.getPackage() != null) {
                return "packages." + this.getJavaIdentifierUC((Definition)routine.getPackage()).toLowerCase();
            }
            return "routines";
        }
        if (definition instanceof EnumDefinition) {
            return "enums";
        }
        if (definition instanceof ArrayDefinition) {
            return "udt";
        }
        if (definition instanceof UDTDefinition) {
            return "udt";
        }
        return "";
    }
}

