/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.File;
import org.jooq.impl.StringUtils;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.Definition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.GenerationUtil;
import org.jooq.util.GeneratorStrategy;
import org.jooq.util.MasterDataTableDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.TypedElementDefinition;
import org.jooq.util.UDTDefinition;

public class DefaultGeneratorStrategy
implements GeneratorStrategy {
    private String targetDirectory;
    private String targetPackage;
    private String tableClassPrefix;
    private String tableClassSuffix;
    private String recordClassPrefix;
    private String recordClassSuffix;
    private String scheme;

    @Override
    public void setMetaClassPrefix(String prefix) {
        this.tableClassPrefix = prefix;
    }

    @Override
    public void setMetaClassSuffix(String suffix) {
        this.tableClassSuffix = suffix;
    }

    @Override
    public void setRecordClassPrefix(String prefix) {
        this.recordClassPrefix = prefix;
    }

    @Override
    public void setRecordClassSuffix(String suffix) {
        this.recordClassSuffix = suffix;
    }

    @Override
    public void setMemberScheme(String scheme) {
        this.scheme = scheme;
    }

    @Override
    public final String getTargetDirectory() {
        return this.targetDirectory;
    }

    @Override
    public final void setTargetDirectory(String directory) {
        this.targetDirectory = directory;
    }

    @Override
    public final String getTargetPackage() {
        return this.targetPackage;
    }

    @Override
    public final void setTargetPackage(String packageName) {
        this.targetPackage = packageName;
    }

    @Override
    public final String getFileName(Definition definition) {
        return this.getJavaClassName(definition) + ".java";
    }

    @Override
    public final String getFileName(Definition definition, String suffix) {
        return this.getJavaClassName(definition) + suffix + ".java";
    }

    @Override
    public final File getFile(Definition definition) {
        return this.getFile(definition, "");
    }

    @Override
    public final File getFile(Definition definition, String suffix) {
        String dir = this.getTargetDirectory();
        String pkg = this.getJavaPackageName(definition, suffix).replaceAll("\\.", "/");
        return new File(dir + "/" + pkg, this.getFileName(definition, suffix));
    }

    @Override
    public final String getJavaIdentifier(Definition definition) {
        return GenerationUtil.convertToJavaIdentifier(definition.getName());
    }

    @Override
    public final String getJavaIdentifierUC(Definition definition) {
        return this.getJavaIdentifier(definition).toUpperCase();
    }

    @Override
    public final String getFullJavaIdentifierUC(Definition definition) {
        StringBuilder sb = new StringBuilder();
        if (definition instanceof TypedElementDefinition) {
            sb.append(this.getFullJavaClassName(((TypedElementDefinition)definition).getContainer()));
        } else {
            sb.append(this.getFullJavaClassName(definition));
        }
        sb.append(".");
        sb.append(this.getJavaIdentifierUC(definition));
        return sb.toString();
    }

    @Override
    public final String getJavaClassName(Definition definition) {
        return this.getJavaClassName(definition, "");
    }

    @Override
    public final String getJavaClassName(Definition definition, String suffix) {
        return this.getJavaClassName0(definition, suffix);
    }

    @Override
    public final String getJavaPackageName(Definition definition) {
        return this.getJavaPackageName(definition, "");
    }

    @Override
    public final String getJavaPackageName(Definition definition, String suffix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTargetPackage());
        if (!StringUtils.isBlank((String)this.getSubPackage(definition))) {
            sb.append(".");
            sb.append(this.getSubPackage(definition));
        }
        if ("Record".equals(suffix)) {
            sb.append(".records");
        }
        return sb.toString();
    }

    @Override
    public final String getJavaClassNameLC(Definition definition) {
        return this.getJavaClassNameLC(definition, "");
    }

    @Override
    public final String getJavaClassNameLC(Definition definition, String suffix) {
        String result = this.getJavaClassName0(definition, suffix);
        return result.substring(0, 1).toLowerCase() + result.substring(1);
    }

    private final String getJavaClassName0(Definition definition, String suffix) {
        StringBuilder result = new StringBuilder();
        String name = GenerationUtil.convertToJavaIdentifier(definition.getName());
        result.append(StringUtils.toCamelCase((String)name));
        if (!StringUtils.isEmpty((String)suffix)) {
            result.append(suffix);
        }
        if (!StringUtils.isBlank((String)definition.getOverload())) {
            result.append(definition.getOverload());
        }
        return result.toString();
    }

    @Override
    public final String getFullJavaClassName(Definition definition) {
        return this.getFullJavaClassName(definition, "");
    }

    @Override
    public final String getFullJavaClassName(Definition definition, String suffix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getJavaPackageName(definition, suffix));
        sb.append(".");
        sb.append(this.getJavaClassName(definition, suffix));
        return sb.toString();
    }

    @Override
    public final String getSubPackage(Definition definition) {
        if (definition instanceof MasterDataTableDefinition) {
            return "enums";
        }
        if (definition instanceof TableDefinition) {
            return "tables";
        }
        if (definition instanceof PackageDefinition) {
            return "packages";
        }
        if (definition instanceof RoutineDefinition) {
            RoutineDefinition routine = (RoutineDefinition)definition;
            if (routine.getPackage() != null) {
                return "packages." + this.getJavaIdentifierUC((Definition)routine.getPackage()).toLowerCase();
            }
            return "routines";
        }
        if (definition instanceof EnumDefinition) {
            return "enums";
        }
        if (definition instanceof ArrayDefinition) {
            return "udt";
        }
        if (definition instanceof UDTDefinition) {
            return "udt";
        }
        return "";
    }
}

