/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import org.jooq.DataType;
import org.jooq.SQLDialect;
import org.jooq.SQLDialectNotSupportedException;
import org.jooq.impl.FieldTypeHelper;
import org.jooq.util.db2.DB2DataType;
import org.jooq.util.derby.DerbyDataType;
import org.jooq.util.h2.H2DataType;
import org.jooq.util.hsqldb.HSQLDBDataType;
import org.jooq.util.ingres.IngresDataType;
import org.jooq.util.mysql.MySQLDataType;
import org.jooq.util.oracle.OracleDataType;
import org.jooq.util.postgres.PostgresDataType;
import org.jooq.util.sqlite.SQLiteDataType;
import org.jooq.util.sqlserver.SQLServerDataType;
import org.jooq.util.sybase.SybaseDataType;

class GenerationUtil {
    GenerationUtil() {
    }

    static String convertToJavaIdentifier(String literal) {
        StringBuilder sb = new StringBuilder();
        if ("".equals(literal)) {
            return "_";
        }
        if (!Character.isJavaIdentifierStart(literal.charAt(0))) {
            sb.append("_");
        }
        for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                sb.append("_");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static String getSimpleJavaType(String qualifiedJavaType) {
        if (qualifiedJavaType == null) {
            return null;
        }
        return qualifiedJavaType.replaceAll(".*\\.", "");
    }

    static DataType<?> getDialectDataType(SQLDialect dialect, String t, int p, int s) throws SQLDialectNotSupportedException {
        switch (dialect) {
            case DB2: {
                return DB2DataType.getDataType((String)FieldTypeHelper.normalise((String)t));
            }
            case DERBY: {
                return DerbyDataType.getDataType((String)FieldTypeHelper.normalise((String)t));
            }
            case H2: {
                return H2DataType.getDataType((String)FieldTypeHelper.normalise((String)t));
            }
            case HSQLDB: {
                return HSQLDBDataType.getDataType((String)FieldTypeHelper.normalise((String)t));
            }
            case INGRES: {
                return IngresDataType.getDataType((String)FieldTypeHelper.normalise((String)t));
            }
            case MYSQL: {
                return MySQLDataType.getDataType((String)FieldTypeHelper.normalise((String)t));
            }
            case ORACLE: {
                DataType dataType = OracleDataType.getDataType((String)FieldTypeHelper.normalise((String)t));
                if (dataType == OracleDataType.NUMBER) {
                    dataType = OracleDataType.getDataType((Class)FieldTypeHelper.getClass((int)2, (int)p, (int)s));
                }
                return dataType;
            }
            case POSTGRES: {
                return PostgresDataType.getDataType((String)FieldTypeHelper.normalise((String)t));
            }
            case SQLITE: {
                return SQLiteDataType.getDataType((String)FieldTypeHelper.normalise((String)t));
            }
            case SQLSERVER: {
                return SQLServerDataType.getDataType((String)FieldTypeHelper.normalise((String)t));
            }
            case SYBASE: {
                return SybaseDataType.getDataType((String)FieldTypeHelper.normalise((String)t));
            }
        }
        throw new SQLDialectNotSupportedException("This method is not yet implemented for dialect " + dialect);
    }

    static Class<?> getDialectJavaType(SQLDialect dialect, String t, int p, int s) throws SQLDialectNotSupportedException {
        return GenerationUtil.getDialectDataType(dialect, t, p, s).getType(p, s);
    }

    static String getArrayBaseType(SQLDialect dialect, String t, String u) {
        switch (dialect) {
            case POSTGRES: {
                if (u != null && u.startsWith("_")) {
                    return u.substring(1);
                }
                return u;
            }
            case H2: {
                return H2DataType.OTHER.getTypeName();
            }
            case HSQLDB: {
                return t.replace(" ARRAY", "");
            }
        }
        throw new SQLDialectNotSupportedException("getArrayBaseType() is not supported for dialect " + dialect);
    }
}

