/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import org.jooq.Configuration;
import org.jooq.EnumType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.MasterDataType;
import org.jooq.Parameter;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.SQLDialectNotSupportedException;
import org.jooq.SchemaMapping;
import org.jooq.Select;
import org.jooq.Sequence;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UDT;
import org.jooq.UDTField;
import org.jooq.UniqueKey;
import org.jooq.impl.AbstractKeys;
import org.jooq.impl.ArrayRecordImpl;
import org.jooq.impl.FieldTypeHelper;
import org.jooq.impl.JooqLogger;
import org.jooq.impl.PackageImpl;
import org.jooq.impl.ParameterImpl;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.SequenceImpl;
import org.jooq.impl.StopWatch;
import org.jooq.impl.StoredFunctionImpl;
import org.jooq.impl.StoredProcedureImpl;
import org.jooq.impl.StringUtils;
import org.jooq.impl.TableFieldImpl;
import org.jooq.impl.TableImpl;
import org.jooq.impl.TableRecordImpl;
import org.jooq.impl.UDTFieldImpl;
import org.jooq.impl.UDTImpl;
import org.jooq.impl.UDTRecordImpl;
import org.jooq.impl.UpdatableRecordImpl;
import org.jooq.impl.UpdatableTableImpl;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.AttributeDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.Database;
import org.jooq.util.Definition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.ForeignKeyDefinition;
import org.jooq.util.FunctionDefinition;
import org.jooq.util.GenerationUtil;
import org.jooq.util.GenerationWriter;
import org.jooq.util.Generator;
import org.jooq.util.GeneratorStrategy;
import org.jooq.util.MasterDataTableDefinition;
import org.jooq.util.MasterDataTypeDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ParameterDefinition;
import org.jooq.util.ProcedureDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.TypedElementDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.UniqueKeyDefinition;
import org.jooq.util.postgres.PostgresSingleUDTOutParameterProcedure;

public class DefaultGenerator
implements Generator {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultGenerator.class);
    private static final Map<Class<?>, Set<String>> reservedColumns = new HashMap();
    private boolean generateDeprecated = true;
    private boolean generateRelations = false;
    private GeneratorStrategy strategy;

    @Override
    public void setStrategy(GeneratorStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public GeneratorStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public boolean generateDeprecated() {
        return this.generateDeprecated;
    }

    @Override
    public void setGenerateDeprecated(boolean generateDeprecated) {
        this.generateDeprecated = generateDeprecated;
    }

    @Override
    public boolean generateRelations() {
        return this.generateRelations;
    }

    @Override
    public void setGenerateRelations(boolean generateRelations) {
        this.generateRelations = generateRelations;
    }

    @Override
    public void setTargetDirectory(String directory) {
        this.strategy.setTargetDirectory(directory);
    }

    @Override
    public String getTargetDirectory() {
        return this.strategy.getTargetDirectory();
    }

    @Override
    public void setTargetPackage(String packageName) {
        this.strategy.setTargetPackage(packageName);
    }

    @Override
    public String getTargetPackage() {
        return this.strategy.getTargetPackage();
    }

    @Override
    public void generate(Database database) throws SQLException, IOException {
        String separator;
        StopWatch watch = new StopWatch();
        log.info((Object)"Database parameters");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"  dialect", (Object)database.getDialect());
        log.info((Object)"  schema", (Object)database.getSchemaName());
        log.info((Object)"  target dir", (Object)this.getTargetDirectory());
        log.info((Object)"  target package", (Object)this.getTargetPackage());
        log.info((Object)"----------------------------------------------------------");
        String targetPackage = this.getTargetPackage();
        File targetPackageDir = new File(this.getTargetDirectory() + File.separator + targetPackage.replace('.', File.separatorChar));
        log.info((Object)"Emptying", (Object)targetPackageDir.getCanonicalPath());
        this.empty(targetPackageDir);
        log.info((Object)"Generating classes in", (Object)targetPackageDir.getCanonicalPath());
        SchemaDefinition schema = database.getSchema();
        GenerationWriter outS = null;
        GenerationWriter outF = null;
        if (!schema.isDefaultSchema()) {
            targetPackageDir.mkdirs();
            log.info((Object)"Generating schema", (Object)this.strategy.getFileName((Definition)schema));
            outS = new GenerationWriter(new PrintWriter(new File(targetPackageDir, this.strategy.getFileName((Definition)schema))));
            this.printHeader(outS, targetPackage);
            this.printClassJavadoc(outS, (Definition)schema);
            outS.println("public class " + this.strategy.getJavaClassName((Definition)schema) + " extends SchemaImpl {");
            outS.printSerial();
            outS.printImport(SchemaImpl.class);
            outS.println();
            outS.println("\t/**");
            outS.println("\t * The singleton instance of " + schema.getName());
            outS.println("\t */");
            outS.println("\tpublic static final " + this.strategy.getJavaClassName((Definition)schema) + " " + schema.getNameUC() + " = new " + this.strategy.getJavaClassName((Definition)schema) + "();");
            outS.println();
            this.printNoFurtherInstancesAllowedJavadoc(outS);
            outS.printImport(SQLDialect.class);
            outS.println("\tprivate " + this.strategy.getJavaClassName((Definition)schema) + "() {");
            outS.println("\t\tsuper(SQLDialect." + database.getDialect().name() + ", \"" + schema.getName() + "\");");
            outS.println("\t}");
            outS.printInitialisationStatementsPlaceholder();
            log.info((Object)"Generating factory", (Object)this.strategy.getFileName((Definition)schema, "Factory"));
            outF = new GenerationWriter(new PrintWriter(new File(targetPackageDir, this.strategy.getFileName((Definition)schema, "Factory"))));
            this.printHeader(outF, targetPackage);
            this.printClassJavadoc(outF, (Definition)schema);
            outF.print("public class ");
            outF.print(this.strategy.getJavaClassName((Definition)schema, "Factory"));
            outF.print(" extends ");
            outF.print(database.getDialect().getName());
            outF.println("Factory {");
            outF.printSerial();
            outF.printImport(database.getDialect().getFactory());
            outF.printImport(Connection.class);
            outF.printImport(SchemaMapping.class);
            outF.println();
            outF.println("\t/**");
            outF.println("\t * Create a factory with a connection");
            outF.println("\t *");
            outF.println("\t * @param connection The connection to use with objects created from this factory");
            outF.println("\t */");
            outF.println("\tpublic " + this.strategy.getJavaClassName((Definition)schema, "Factory") + "(Connection connection) {");
            outF.println("\t\tsuper(connection);");
            outF.println("\t}");
            outF.println();
            outF.println("\t/**");
            outF.println("\t * Create a factory with a connection and a schema mapping");
            outF.println("\t *");
            outF.println("\t * @param connection The connection to use with objects created from this factory");
            outF.println("\t * @param mapping The schema mapping to use with objects created from this factory");
            outF.println("\t */");
            outF.println("\tpublic " + this.strategy.getJavaClassName((Definition)schema, "Factory") + "(Connection connection, SchemaMapping mapping) {");
            outF.println("\t\tsuper(connection, mapping);");
            outF.println("\t}");
            watch.splitInfo("Schema generated");
        }
        if (database.getSequences().size() > 0) {
            log.info((Object)"Generating sequences", (Object)targetPackageDir.getCanonicalPath());
            targetPackageDir.mkdirs();
            GenerationWriter out = new GenerationWriter(new PrintWriter(new File(targetPackageDir, "Sequences.java")));
            this.printHeader(out, targetPackage);
            this.printClassJavadoc(out, "Convenience access to all sequences in " + schema.getName());
            out.println("public final class Sequences {");
            for (SequenceDefinition sequence : database.getSequences()) {
                out.println();
                out.println("\t/**");
                out.println("\t * The sequence " + sequence.getNameUC());
                out.println("\t */");
                out.print("\tpublic static final Sequence ");
                out.print(sequence.getNameUC());
                out.print(" = new SequenceImpl(SQLDialect.");
                out.print(database.getDialect().name());
                out.print(", \"");
                out.print(sequence.getName());
                out.print("\"");
                if (!schema.isDefaultSchema()) {
                    out.print(", ");
                    out.print(this.strategy.getJavaClassName((Definition)schema) + "." + schema.getNameUC());
                    out.printImport(this.strategy.getFullJavaClassName((Definition)schema));
                } else {
                    out.print(", null");
                }
                out.println(");");
                out.printImport(SQLDialect.class);
                out.printImport(Sequence.class);
                out.printImport(SequenceImpl.class);
            }
            this.printPrivateConstructor(out, "Sequences");
            out.println("}");
            out.close();
            this.registerInSchema(outS, database.getSequences(), Sequence.class, false);
            watch.splitInfo("Sequences generated");
        }
        File targetMasterDataTablePackageDir = new File(targetPackageDir, "enums");
        if (database.getMasterDataTables().size() > 0) {
            log.info((Object)"Generating master data", (Object)targetMasterDataTablePackageDir.getCanonicalPath());
            for (MasterDataTableDefinition table : database.getMasterDataTables()) {
                try {
                    targetMasterDataTablePackageDir.mkdirs();
                    log.info((Object)"Generating table", (Object)this.strategy.getFileName((Definition)table));
                    GenerationWriter out = new GenerationWriter(new PrintWriter(new File(targetMasterDataTablePackageDir, this.strategy.getFileName((Definition)table))));
                    this.printHeader(out, targetPackage + ".enums");
                    this.printClassJavadoc(out, (Definition)table);
                    ColumnDefinition primaryKey = table.getPrimaryKeyColumn();
                    out.print("public enum ");
                    out.print(this.strategy.getJavaClassName((Definition)table));
                    out.print(" implements MasterDataType<");
                    this.print(out, primaryKey.getType());
                    out.println("> {");
                    out.printImport(MasterDataType.class);
                    for (Record record : table.getData()) {
                        String description;
                        String literal = String.valueOf(record.getValue(1));
                        ColumnDefinition descriptionColumn = table.getDescriptionColumn();
                        if (descriptionColumn != null && !StringUtils.isEmpty((String)(description = String.valueOf(record.getValue(2))))) {
                            out.println();
                            out.println("\t/**");
                            out.println("\t * " + description);
                            out.println("\t */");
                        }
                        out.print("\t");
                        out.print(GenerationUtil.convertToJavaIdentifier(literal));
                        out.print("(");
                        separator = "";
                        for (Field field : record.getFields()) {
                            out.print(separator);
                            out.printNewJavaObject(record.getValue(field), field);
                            separator = ", ";
                        }
                        out.println("),");
                    }
                    out.println("\t;");
                    out.println();
                    for (ColumnDefinition column : table.getColumns()) {
                        out.print("\tprivate final ");
                        this.print(out, column.getType());
                        out.print(" ");
                        out.println(this.strategy.getJavaClassNameLC((Definition)column) + ";");
                    }
                    out.println();
                    out.print("\tprivate " + this.strategy.getJavaClassName((Definition)table) + "(");
                    String separator2 = "";
                    for (ColumnDefinition column : table.getColumns()) {
                        out.print(separator2);
                        this.print(out, column.getType());
                        out.print(" ");
                        out.print(this.strategy.getJavaClassNameLC((Definition)column));
                        separator2 = ", ";
                    }
                    out.println(") {");
                    for (ColumnDefinition column : table.getColumns()) {
                        out.print("\t\tthis.");
                        out.print(this.strategy.getJavaClassNameLC((Definition)column));
                        out.print(" = ");
                        out.print(this.strategy.getJavaClassNameLC((Definition)column));
                        out.println(";");
                    }
                    out.println("\t}");
                    out.println();
                    this.printOverride(out);
                    out.print("\tpublic ");
                    this.print(out, primaryKey.getType());
                    out.println(" getPrimaryKey() {");
                    out.println("\t\treturn " + this.strategy.getJavaClassNameLC((Definition)primaryKey) + ";");
                    out.println("\t}");
                    for (ColumnDefinition column : table.getColumns()) {
                        this.printFieldJavaDoc(out, "", (TypedElementDefinition)column);
                        out.print("\tpublic final ");
                        this.print(out, column.getType());
                        out.print(" get");
                        out.print(this.strategy.getJavaClassName((Definition)column));
                        out.println("() {");
                        out.print("\t\treturn ");
                        out.print(this.strategy.getJavaClassNameLC((Definition)column));
                        out.println(";");
                        out.println("\t}");
                    }
                    out.println("}");
                    out.close();
                }
                catch (Exception e) {
                    log.error((Object)("Exception while generating master data table " + table), (Throwable)e);
                }
            }
            watch.splitInfo("Master data generated");
        }
        File targetTablePackageDir = new File(targetPackageDir, "tables");
        if (database.getTables().size() > 0) {
            log.info((Object)"Generating tables", (Object)targetTablePackageDir.getCanonicalPath());
            for (TableDefinition table : database.getTables()) {
                try {
                    String baseClass;
                    targetTablePackageDir.mkdirs();
                    log.info((Object)"Generating table", (Object)this.strategy.getFileName((Definition)table));
                    GenerationWriter out = new GenerationWriter(new PrintWriter(new File(targetTablePackageDir, this.strategy.getFileName((Definition)table))));
                    this.printHeader(out, targetPackage + ".tables");
                    this.printClassJavadoc(out, (Definition)table);
                    if (this.generateRelations() && table.getMainUniqueKey() != null) {
                        baseClass = "UpdatableTableImpl";
                        out.printImport(UpdatableTableImpl.class);
                    } else {
                        baseClass = "TableImpl";
                        out.printImport(TableImpl.class);
                    }
                    out.println("public class " + this.strategy.getJavaClassName((Definition)table) + " extends " + baseClass + "<" + this.strategy.getJavaClassName((Definition)table, "Record") + "> {");
                    out.printSerial();
                    this.printSingletonInstance((Definition)table, out);
                    this.printRecordTypeMethod(targetPackage, (Definition)table, out);
                    for (ColumnDefinition column : table.getColumns()) {
                        this.printTableColumn(out, column, (Definition)table);
                    }
                    out.println();
                    this.printNoFurtherInstancesAllowedJavadoc(out);
                    out.println("\tprivate " + this.strategy.getJavaClassName((Definition)table) + "() {");
                    out.printImport(SQLDialect.class);
                    if (!schema.isDefaultSchema()) {
                        out.println("\t\tsuper(SQLDialect." + database.getDialect().name() + ", \"" + table.getName() + "\", " + this.strategy.getJavaClassName((Definition)schema) + "." + schema.getNameUC() + ");");
                        out.printImport(this.strategy.getFullJavaClassName((Definition)schema));
                    } else {
                        out.println("\t\tsuper(SQLDialect." + database.getDialect().name() + ", \"" + table.getName() + "\");");
                    }
                    out.println("\t}");
                    if (this.generateRelations()) {
                        List foreignKeys;
                        List uniqueKeys;
                        UniqueKeyDefinition mainKey;
                        ColumnDefinition identity = table.getIdentity();
                        if (identity != null) {
                            out.println();
                            out.println("\t@Override");
                            out.print("\tpublic Identity<");
                            out.print(this.strategy.getJavaClassName((Definition)table, "Record"));
                            out.print(", ");
                            out.print(this.getSimpleJavaType(table.getIdentity().getType()));
                            out.println("> getIdentity() {");
                            out.print("\t\treturn Keys.IDENTITY_");
                            out.print(this.strategy.getJavaIdentifier((Definition)identity.getTable()));
                            out.println(";");
                            out.println("\t}");
                            out.printImport(Identity.class);
                            out.printImport(this.strategy.getTargetPackage() + ".Keys");
                        }
                        if ((mainKey = table.getMainUniqueKey()) != null) {
                            out.println();
                            out.println("\t@Override");
                            out.print("\tpublic UniqueKey<");
                            out.print(this.strategy.getJavaClassName((Definition)table, "Record"));
                            out.println("> getMainKey() {");
                            out.print("\t\treturn Keys.");
                            out.print(this.strategy.getJavaIdentifier((Definition)mainKey));
                            out.println(";");
                            out.println("\t}");
                            out.printImport(UniqueKey.class);
                            out.printImport(this.strategy.getTargetPackage() + ".Keys");
                        }
                        if ((uniqueKeys = table.getUniqueKeys()).size() > 0) {
                            out.println();
                            out.println("\t@Override");
                            out.println("\t@SuppressWarnings(\"unchecked\")");
                            out.print("\tpublic List<UniqueKey<");
                            out.print(this.strategy.getJavaClassName((Definition)table, "Record"));
                            out.println(">> getKeys() {");
                            out.print("\t\treturn Arrays.<UniqueKey<");
                            out.print(this.strategy.getJavaClassName((Definition)table, "Record"));
                            out.print(">>asList(");
                            separator = "";
                            for (UniqueKeyDefinition uniqueKey : uniqueKeys) {
                                out.print(separator);
                                out.print("Keys.");
                                out.print(this.strategy.getJavaIdentifier((Definition)uniqueKey));
                                separator = ", ";
                            }
                            out.println(");");
                            out.println("\t}");
                            out.printImport(Arrays.class);
                            out.printImport(List.class);
                            out.printImport(UniqueKey.class);
                            out.printImport(this.strategy.getTargetPackage() + ".Keys");
                        }
                        if ((foreignKeys = table.getForeignKeys()).size() > 0) {
                            out.println();
                            out.println("\t@Override");
                            out.println("\t@SuppressWarnings(\"unchecked\")");
                            out.print("\tpublic List<ForeignKey<");
                            out.print(this.strategy.getJavaClassName((Definition)table, "Record"));
                            out.println(", ?>> getReferences() {");
                            out.print("\t\treturn Arrays.<ForeignKey<");
                            out.print(this.strategy.getJavaClassName((Definition)table, "Record"));
                            out.print(", ?>>asList(");
                            String separator3 = "";
                            for (ForeignKeyDefinition foreignKey : foreignKeys) {
                                TableDefinition referencedTable = foreignKey.getReferencedTable();
                                if (referencedTable instanceof MasterDataTableDefinition) continue;
                                out.print(separator3);
                                out.print("Keys.");
                                out.print(this.strategy.getJavaIdentifier((Definition)foreignKey));
                                separator3 = ", ";
                            }
                            out.println(");");
                            out.println("\t}");
                            out.printImport(Arrays.class);
                            out.printImport(List.class);
                            out.printImport(ForeignKey.class);
                            out.printImport(this.strategy.getTargetPackage() + ".Keys");
                        }
                    }
                    out.printStaticInitialisationStatementsPlaceholder();
                    out.println("}");
                    out.close();
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating table" + table), (Throwable)e);
                }
            }
            this.registerInSchema(outS, database.getTables(), Table.class, true);
            watch.splitInfo("Tables generated");
        }
        if (this.generateRelations() && database.getTables().size() > 0) {
            String separator4;
            log.info((Object)"Generating Keys", (Object)targetTablePackageDir.getCanonicalPath());
            targetPackageDir.mkdirs();
            GenerationWriter out = new GenerationWriter(new PrintWriter(new File(targetPackageDir, "Keys.java")));
            this.printHeader(out, targetPackage);
            this.printClassJavadoc(out, "A class modelling foreign key relationships between tables of the " + schema.getName() + " schema");
            out.suppressWarnings("unchecked");
            out.println("public class Keys extends AbstractKeys {");
            out.println();
            out.println("\t// IDENTITY definitions");
            for (TableDefinition table : database.getTables()) {
                try {
                    ColumnDefinition identity = table.getIdentity();
                    if (identity == null) continue;
                    out.print("\tpublic static final Identity<");
                    out.print(this.strategy.getJavaClassName((Definition)identity.getTable(), "Record"));
                    out.print(", ");
                    out.print(this.getSimpleJavaType(identity.getType()));
                    out.print("> IDENTITY_");
                    out.print(this.strategy.getJavaIdentifier((Definition)identity.getTable()));
                    out.print(" = createIdentity(");
                    out.print(this.strategy.getJavaClassName((Definition)identity.getTable()));
                    out.print(".");
                    out.print(identity.getTable().getNameUC());
                    out.print(", ");
                    out.print(this.strategy.getJavaClassName((Definition)identity.getTable()));
                    out.print(".");
                    out.print(identity.getNameUC());
                    out.println(");");
                    out.printImport(Identity.class);
                    out.printImport(this.strategy.getFullJavaClassName((Definition)identity.getTable()));
                    out.printImport(this.strategy.getFullJavaClassName((Definition)identity.getTable(), "Record"));
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating table " + table), (Throwable)e);
                }
            }
            out.println();
            out.println("\t// UNIQUE and PRIMARY KEY definitions");
            for (TableDefinition table : database.getTables()) {
                try {
                    List uniqueKeys = table.getUniqueKeys();
                    if (uniqueKeys.size() <= 0) continue;
                    for (UniqueKeyDefinition uniqueKey : uniqueKeys) {
                        out.print("\tpublic static final UniqueKey<");
                        out.print(this.strategy.getJavaClassName((Definition)uniqueKey.getTable(), "Record"));
                        out.print("> ");
                        out.print(this.strategy.getJavaIdentifier((Definition)uniqueKey));
                        out.print(" = createUniqueKey(");
                        out.print(this.strategy.getJavaClassName((Definition)uniqueKey.getTable()));
                        out.print(".");
                        out.print(uniqueKey.getTable().getNameUC());
                        out.print(", ");
                        separator4 = "";
                        for (ColumnDefinition column : uniqueKey.getKeyColumns()) {
                            out.print(separator4);
                            out.print(this.strategy.getJavaClassName((Definition)uniqueKey.getTable()));
                            out.print(".");
                            out.print(column.getNameUC());
                            separator4 = ", ";
                        }
                        out.println(");");
                        out.printImport(UniqueKey.class);
                        out.printImport(this.strategy.getFullJavaClassName((Definition)uniqueKey.getTable()));
                        out.printImport(this.strategy.getFullJavaClassName((Definition)uniqueKey.getTable(), "Record"));
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating table " + table), (Throwable)e);
                }
            }
            out.println();
            out.println("\t// FOREIGN KEY definitions");
            for (TableDefinition table : database.getTables()) {
                try {
                    List foreignKeys = table.getForeignKeys();
                    if (foreignKeys.size() <= 0) continue;
                    for (ForeignKeyDefinition foreignKey : foreignKeys) {
                        if (foreignKey.getReferencedTable() instanceof MasterDataTableDefinition) continue;
                        out.print("\tpublic static final ForeignKey<");
                        out.print(this.strategy.getJavaClassName((Definition)foreignKey.getKeyTable(), "Record"));
                        out.print(", ");
                        out.print(this.strategy.getJavaClassName((Definition)foreignKey.getReferencedTable(), "Record"));
                        out.print("> ");
                        out.print(this.strategy.getJavaIdentifier((Definition)foreignKey));
                        out.print(" = createForeignKey(");
                        out.print(this.strategy.getJavaIdentifier((Definition)foreignKey.getReferencedKey()));
                        out.print(", ");
                        out.print(this.strategy.getJavaClassName((Definition)foreignKey.getKeyTable()));
                        out.print(".");
                        out.print(foreignKey.getKeyTable().getNameUC());
                        out.print(", ");
                        separator4 = "";
                        for (ColumnDefinition column : foreignKey.getKeyColumns()) {
                            out.print(separator4);
                            out.print(this.strategy.getJavaClassName((Definition)foreignKey.getKeyTable()));
                            out.print(".");
                            out.print(column.getNameUC());
                            separator4 = ", ";
                        }
                        out.println(");");
                        out.printImport(ForeignKey.class);
                        out.printImport(this.strategy.getFullJavaClassName((Definition)foreignKey.getKeyTable()));
                        out.printImport(this.strategy.getFullJavaClassName((Definition)foreignKey.getKeyTable(), "Record"));
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating reference " + table), (Throwable)e);
                }
            }
            this.printPrivateConstructor(out, "Keys");
            out.printImport(AbstractKeys.class);
            out.println("}");
            out.close();
            watch.splitInfo("Keys generated");
        }
        File targetTableRecordPackageDir = new File(new File(targetPackageDir, "tables"), "records");
        if (database.getTables().size() > 0) {
            log.info((Object)"Generating records", (Object)targetTableRecordPackageDir.getCanonicalPath());
            for (TableDefinition table : database.getTables()) {
                try {
                    Set<String> reserved;
                    String baseClass;
                    targetTableRecordPackageDir.mkdirs();
                    log.info((Object)"Generating record", (Object)this.strategy.getFileName((Definition)table, "Record"));
                    GenerationWriter out = new GenerationWriter(new PrintWriter(new File(targetTableRecordPackageDir, this.strategy.getFileName((Definition)table, "Record"))));
                    this.printHeader(out, targetPackage + ".tables.records");
                    this.printClassJavadoc(out, (Definition)table);
                    if (this.generateRelations() && table.getMainUniqueKey() != null) {
                        baseClass = "UpdatableRecordImpl";
                        out.printImport(UpdatableRecordImpl.class);
                        reserved = this.reservedColumns(UpdatableRecordImpl.class);
                    } else {
                        baseClass = "TableRecordImpl";
                        out.printImport(TableRecordImpl.class);
                        reserved = this.reservedColumns(TableRecordImpl.class);
                    }
                    out.println("public class " + this.strategy.getJavaClassName((Definition)table, "Record") + " extends " + baseClass + "<" + this.strategy.getJavaClassName((Definition)table, "Record") + "> {");
                    out.printSerial();
                    out.printImport(this.strategy.getFullJavaClassName((Definition)table));
                    for (ColumnDefinition column : table.getColumns()) {
                        this.printGetterAndSetter(out, (TypedElementDefinition)column, (Definition)table, targetPackage + ".tables", reserved);
                    }
                    out.println("\t/**");
                    out.println("\t * Create a detached " + this.strategy.getJavaClassName((Definition)table, "Record"));
                    out.println("\t */");
                    out.println("\tpublic " + this.strategy.getJavaClassName((Definition)table, "Record") + "() {");
                    out.print("\t\tsuper(");
                    out.print(this.strategy.getJavaClassName((Definition)table));
                    out.print(".");
                    out.print(table.getNameUC());
                    out.println(");");
                    out.println("\t}");
                    if (!"TableRecordImpl".equals(baseClass) || this.generateDeprecated()) {
                        out.println();
                        out.println("\t/**");
                        out.println("\t * Create an attached " + this.strategy.getJavaClassName((Definition)table, "Record"));
                        if ("TableRecordImpl".equals(baseClass)) {
                            out.println("\t * @deprecated - (#363) use the other constructor instead");
                        }
                        out.println("\t */");
                        if ("TableRecordImpl".equals(baseClass)) {
                            out.println("\t@Deprecated");
                        }
                        out.println("\tpublic " + this.strategy.getJavaClassName((Definition)table, "Record") + "(Configuration configuration) {");
                        out.print("\t\tsuper(");
                        out.print(this.strategy.getJavaClassName((Definition)table));
                        out.print(".");
                        out.print(table.getNameUC());
                        out.println(", configuration);");
                        out.println("\t}");
                        out.printImport(Configuration.class);
                    }
                    out.println("}");
                    out.close();
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating table record " + table), (Throwable)e);
                }
            }
            watch.splitInfo("Table records generated");
        }
        File targetUDTPackageDir = new File(targetPackageDir, "udt");
        if (database.getUDTs().size() > 0) {
            log.info((Object)"Generating UDTs", (Object)targetUDTPackageDir.getCanonicalPath());
            for (UDTDefinition udt : database.getUDTs()) {
                try {
                    targetUDTPackageDir.mkdirs();
                    log.info((Object)"Generating UDT ", (Object)this.strategy.getFileName((Definition)udt));
                    GenerationWriter out = new GenerationWriter(new PrintWriter(new File(targetUDTPackageDir, this.strategy.getFileName((Definition)udt))));
                    this.printHeader(out, targetPackage + ".udt");
                    this.printClassJavadoc(out, (Definition)udt);
                    out.println("public class " + this.strategy.getJavaClassName((Definition)udt) + " extends UDTImpl<" + this.strategy.getJavaClassName((Definition)udt, "Record") + "> {");
                    out.printImport(UDTImpl.class);
                    out.printSerial();
                    this.printSingletonInstance((Definition)udt, out);
                    this.printRecordTypeMethod(targetPackage, (Definition)udt, out);
                    for (AttributeDefinition attribute : udt.getAttributes()) {
                        this.printUDTColumn(out, attribute, (Definition)udt);
                    }
                    out.println();
                    this.printNoFurtherInstancesAllowedJavadoc(out);
                    out.println("\tprivate " + this.strategy.getJavaClassName((Definition)udt) + "() {");
                    out.printImport(SQLDialect.class);
                    if (!schema.isDefaultSchema()) {
                        out.println("\t\tsuper(SQLDialect." + database.getDialect().name() + ", \"" + udt.getName() + "\", " + this.strategy.getJavaClassName((Definition)schema) + "." + schema.getNameUC() + ");");
                        out.printImport(targetPackage + "." + this.strategy.getJavaClassName((Definition)schema));
                    } else {
                        out.println("\t\tsuper(SQLDialect." + database.getDialect().name() + ", \"" + udt.getName() + "\");");
                    }
                    out.println("\t}");
                    out.println("}");
                    out.close();
                    if (outS == null) continue;
                    outS.printInitialisationStatement("addMapping(\"" + schema.getName() + "." + udt.getName() + "\", " + this.strategy.getJavaClassName((Definition)udt, "Record") + ".class);");
                    outS.printImport(this.strategy.getFullJavaClassName((Definition)udt, "Record"));
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating udt " + udt), (Throwable)e);
                }
            }
            this.registerInSchema(outS, database.getUDTs(), UDT.class, true);
            watch.splitInfo("UDTs generated");
        }
        File targetRecordUDTPackageDir = new File(new File(targetPackageDir, "udt"), "records");
        if (database.getUDTs().size() > 0) {
            log.info((Object)"Generating UDT records", (Object)targetRecordUDTPackageDir.getCanonicalPath());
            for (UDTDefinition udt : database.getUDTs()) {
                try {
                    targetRecordUDTPackageDir.mkdirs();
                    log.info((Object)"Generating UDT record", (Object)this.strategy.getFileName((Definition)udt, "Record"));
                    GenerationWriter out = new GenerationWriter(new PrintWriter(new File(targetRecordUDTPackageDir, this.strategy.getFileName((Definition)udt, "Record"))));
                    this.printHeader(out, targetPackage + ".udt.records");
                    this.printClassJavadoc(out, (Definition)udt);
                    out.println("public class " + this.strategy.getJavaClassName((Definition)udt, "Record") + " extends UDTRecordImpl<" + this.strategy.getJavaClassName((Definition)udt, "Record") + "> {");
                    out.printImport(UDTRecordImpl.class);
                    Set<String> reserved = this.reservedColumns(UDTRecordImpl.class);
                    out.printSerial();
                    out.println();
                    out.printImport(this.strategy.getFullJavaClassName((Definition)udt));
                    for (AttributeDefinition attribute : udt.getAttributes()) {
                        this.printGetterAndSetter(out, (TypedElementDefinition)attribute, (Definition)udt, targetPackage + ".udt", reserved);
                    }
                    out.println();
                    out.println("\tpublic " + this.strategy.getJavaClassName((Definition)udt, "Record") + "() {");
                    out.print("\t\tsuper(");
                    out.print(this.strategy.getJavaClassName((Definition)udt));
                    out.print(".");
                    out.print(udt.getNameUC());
                    out.println(");");
                    out.println("\t}");
                    out.println("}");
                    out.close();
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating UDT record " + udt), (Throwable)e);
                }
            }
            watch.splitInfo("UDT records generated");
        }
        File targetRecordARRAYPackageDir = new File(new File(targetPackageDir, "udt"), "records");
        if (database.getArrays().size() > 0) {
            log.info((Object)"Generating ARRAYs", (Object)targetRecordARRAYPackageDir.getCanonicalPath());
            for (ArrayDefinition array : database.getArrays()) {
                try {
                    targetRecordARRAYPackageDir.mkdirs();
                    log.info((Object)"Generating ARRAY", (Object)this.strategy.getFileName((Definition)array, "Record"));
                    GenerationWriter out = new GenerationWriter(new PrintWriter(new File(targetRecordARRAYPackageDir, this.strategy.getFileName((Definition)array, "Record"))));
                    this.printHeader(out, targetPackage + ".udt.records");
                    this.printClassJavadoc(out, (Definition)array);
                    out.print("public class ");
                    out.print(this.strategy.getJavaClassName((Definition)array, "Record"));
                    out.print(" extends ArrayRecordImpl<");
                    this.print(out, array.getElementType());
                    out.println("> {");
                    out.printImport(ArrayRecordImpl.class);
                    out.printImport(Configuration.class);
                    out.printSerial();
                    out.println();
                    out.println("\tpublic " + this.strategy.getJavaClassName((Definition)array, "Record") + "(Configuration configuration) {");
                    out.print("\t\tsuper(\"");
                    out.print(array.getSchemaName());
                    out.print(".");
                    out.print(array.getName());
                    out.print("\", ");
                    out.print(this.getJavaTypeReference(database, out, array.getElementType()));
                    out.println(", configuration);");
                    out.println("\t}");
                    out.println();
                    out.print("\tpublic ");
                    out.print(this.strategy.getJavaClassName((Definition)array, "Record"));
                    out.print("(Configuration configuration, ");
                    this.print(out, array.getElementType());
                    out.print("... array");
                    out.println(") {");
                    out.println("\t\tthis(configuration);");
                    out.println("\t\tset(array);");
                    out.println("\t}");
                    out.println();
                    out.print("\tpublic ");
                    out.print(this.strategy.getJavaClassName((Definition)array, "Record"));
                    out.print("(Configuration configuration, List<? extends ");
                    this.print(out, array.getElementType());
                    out.print("> list");
                    out.println(") {");
                    out.println("\t\tthis(configuration);");
                    out.println("\t\tsetList(list);");
                    out.println("\t}");
                    out.printImport(List.class);
                    out.println("}");
                    out.close();
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating ARRAY record " + array), (Throwable)e);
                }
            }
            watch.splitInfo("ARRAYs generated");
        }
        File targetEnumPackageDir = new File(targetPackageDir, "enums");
        if (database.getEnums().size() > 0) {
            log.info((Object)"Generating ENUMs", (Object)targetEnumPackageDir.getCanonicalPath());
            for (EnumDefinition e : database.getEnums()) {
                try {
                    targetEnumPackageDir.mkdirs();
                    log.info((Object)"Generating ENUM", (Object)this.strategy.getFileName((Definition)e));
                    GenerationWriter out = new GenerationWriter(new PrintWriter(new File(targetEnumPackageDir, this.strategy.getFileName((Definition)e))));
                    this.printHeader(out, targetPackage + ".enums");
                    this.printClassJavadoc(out, (Definition)e);
                    out.println("public enum " + this.strategy.getJavaClassName((Definition)e) + " implements EnumType {");
                    out.printImport(EnumType.class);
                    out.println();
                    for (String literal : e.getLiterals()) {
                        out.println("\t" + GenerationUtil.convertToJavaIdentifier(literal) + "(\"" + literal + "\"),");
                        out.println();
                    }
                    out.println("\t;");
                    out.println();
                    out.println("\tprivate final String literal;");
                    out.println();
                    out.println("\tprivate " + this.strategy.getJavaClassName((Definition)e) + "(String literal) {");
                    out.println("\t\tthis.literal = literal;");
                    out.println("\t}");
                    out.println();
                    out.println("\t@Override");
                    out.println("\tpublic String getName() {");
                    out.println("\t\treturn \"" + e.getName() + "\";");
                    out.println("\t}");
                    out.println();
                    out.println("\t@Override");
                    out.println("\tpublic String getLiteral() {");
                    out.println("\t\treturn literal;");
                    out.println("\t}");
                    out.println("}");
                    out.close();
                }
                catch (Exception ex) {
                    log.error((Object)("Error while generating enum " + e), (Throwable)ex);
                }
            }
            watch.splitInfo("Enums generated");
        }
        if (database.getProcedures().size() > 0) {
            File targetProcedurePackageDir = new File(targetPackageDir, "procedures");
            log.info((Object)"Generating procedures", (Object)targetProcedurePackageDir.getCanonicalPath());
            GenerationWriter outP = new GenerationWriter(new PrintWriter(new File(targetPackageDir, "Procedures.java")));
            this.printHeader(outP, targetPackage);
            this.printClassJavadoc(outP, "Convenience access to all stored procedures in " + schema.getName());
            outP.println("public final class Procedures {");
            for (ProcedureDefinition procedure : database.getProcedures()) {
                try {
                    this.printProcedure(database, schema, procedure);
                    this.printConvenienceMethodProcedure(outP, procedure);
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating procedure " + procedure), (Throwable)e);
                }
            }
            this.printPrivateConstructor(outP, "Procedures");
            outP.println("}");
            outP.close();
            watch.splitInfo("Procedures generated");
        }
        if (database.getFunctions().size() > 0) {
            File targetFunctionPackageDir = new File(targetPackageDir, "functions");
            log.info((Object)"Generating functions", (Object)targetFunctionPackageDir.getCanonicalPath());
            GenerationWriter outFn = new GenerationWriter(new PrintWriter(new File(targetPackageDir, "Functions.java")));
            this.printHeader(outFn, targetPackage);
            this.printClassJavadoc(outFn, "Convenience access to all stored functions in " + schema.getName());
            outFn.println("public final class Functions {");
            for (FunctionDefinition function : database.getFunctions()) {
                try {
                    this.printFunction(database, schema, function);
                    this.printConvenienceMethodFunction(outFn, function);
                    this.printConvenienceMethodFunctionAsField(outFn, function, false);
                    this.printConvenienceMethodFunctionAsField(outFn, function, true);
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating function " + function), (Throwable)e);
                }
            }
            this.printPrivateConstructor(outFn, "Functions");
            outFn.println("}");
            outFn.close();
            watch.splitInfo("Functions generated");
        }
        File targetPackagesPackageDir = new File(targetPackageDir, "packages");
        if (database.getPackages().size() > 0) {
            log.info((Object)"Generating packages", (Object)targetPackagesPackageDir.getCanonicalPath());
            for (PackageDefinition pkg : database.getPackages()) {
                try {
                    File targetPackagePackageDir = new File(targetPackagesPackageDir, pkg.getNameLC());
                    targetPackagePackageDir.mkdirs();
                    log.info((Object)"Generating package", (Object)targetPackagePackageDir.getCanonicalPath());
                    for (ProcedureDefinition procedure : pkg.getProcedures()) {
                        try {
                            this.printProcedure(database, schema, procedure);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error while generating procedure " + procedure), (Throwable)e);
                        }
                    }
                    for (FunctionDefinition function : pkg.getFunctions()) {
                        try {
                            this.printFunction(database, schema, function);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error while generating function " + function), (Throwable)e);
                        }
                    }
                    GenerationWriter outPkg = new GenerationWriter(new PrintWriter(new File(targetPackagesPackageDir, this.strategy.getFileName((Definition)pkg))));
                    this.printHeader(outPkg, targetPackage + ".packages");
                    this.printClassJavadoc(outPkg, "Convenience access to all stored procedures and functions in " + pkg.getName());
                    outPkg.println("public final class " + this.strategy.getJavaClassName((Definition)pkg) + " extends PackageImpl {");
                    outPkg.printImport(PackageImpl.class);
                    outPkg.printSerial();
                    outPkg.println();
                    outPkg.println("\t/**");
                    outPkg.println("\t * The singleton instance of " + this.strategy.getJavaIdentifier((Definition)pkg));
                    outPkg.println("\t */");
                    outPkg.print("\tpublic static ");
                    outPkg.print(this.strategy.getJavaClassName((Definition)pkg));
                    outPkg.print(" ");
                    outPkg.print(this.strategy.getJavaIdentifier((Definition)pkg));
                    outPkg.print(" = new ");
                    outPkg.print(this.strategy.getJavaClassName((Definition)pkg));
                    outPkg.println("();");
                    for (ProcedureDefinition procedure : pkg.getProcedures()) {
                        try {
                            this.printConvenienceMethodProcedure(outPkg, procedure);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error while generating procedure " + procedure), (Throwable)e);
                        }
                    }
                    for (FunctionDefinition function : pkg.getFunctions()) {
                        try {
                            this.printConvenienceMethodFunction(outPkg, function);
                            this.printConvenienceMethodFunctionAsField(outPkg, function, false);
                            this.printConvenienceMethodFunctionAsField(outPkg, function, true);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error while generating function " + function), (Throwable)e);
                        }
                    }
                    this.printNoFurtherInstancesAllowedJavadoc(outPkg);
                    outPkg.println("\tprivate " + this.strategy.getJavaClassName((Definition)pkg) + "() {");
                    outPkg.print("\t\tsuper(SQLDialect.");
                    outPkg.print(database.getDialect().name());
                    outPkg.print(", \"");
                    outPkg.print(this.strategy.getJavaIdentifier((Definition)pkg));
                    outPkg.print("\", ");
                    outPkg.print(this.strategy.getJavaClassName((Definition)schema) + "." + schema.getNameUC());
                    outPkg.println(");");
                    outPkg.println("\t}");
                    outPkg.println("}");
                    outPkg.printImport(SQLDialect.class);
                    outPkg.printImport(this.strategy.getFullJavaClassName((Definition)schema));
                    outPkg.close();
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating package " + pkg), (Throwable)e);
                }
            }
            watch.splitInfo("Packages generated");
        }
        if (outS != null) {
            outS.println("}");
            outS.close();
        }
        if (outF != null) {
            outF.println("}");
            outF.close();
        }
        watch.splitInfo("GENERATION FINISHED!");
    }

    private void registerInSchema(GenerationWriter outS, List<? extends Definition> definitions, Class<?> type, boolean isGeneric) {
        if (outS != null) {
            outS.println();
            this.printOverride(outS);
            outS.print("\tpublic final List<");
            outS.print(type.getSimpleName());
            if (isGeneric) {
                outS.print("<?>");
            }
            outS.print("> get");
            outS.print(type.getSimpleName());
            outS.println("s() {");
            outS.print("\t\treturn Arrays.<");
            outS.print(type.getSimpleName());
            if (isGeneric) {
                outS.print("<?>");
            }
            outS.print(">asList(");
            if (definitions.size() > 1) {
                outS.print("\n\t\t\t");
            }
            for (int i = 0; i < definitions.size(); ++i) {
                Definition def = definitions.get(i);
                if (i > 0) {
                    outS.print(",\n\t\t\t");
                }
                this.printSingletonReference(outS, def);
                if (def instanceof SequenceDefinition) continue;
                outS.printImport(this.strategy.getFullJavaClassName(def));
            }
            outS.println(");");
            outS.println("\t}");
            outS.printImport(List.class);
            outS.printImport(type);
            outS.printImport(Arrays.class);
        }
    }

    private Set<String> reservedColumns(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        Set<String> result = reservedColumns.get(clazz);
        if (result == null) {
            result = new HashSet<String>();
            reservedColumns.put(clazz, result);
            result.addAll(this.reservedColumns(clazz.getSuperclass()));
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                result.addAll(this.reservedColumns(clazz2));
            }
            for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
                String name = ((Method)genericDeclaration).getName();
                if (!name.startsWith("get") || ((Method)genericDeclaration).getParameterTypes().length != 0) continue;
                result.add(name.substring(3));
            }
        }
        return result;
    }

    private void printProcedure(Database database, SchemaDefinition schema, ProcedureDefinition procedure) throws FileNotFoundException, SQLException {
        this.strategy.getFile((Definition)procedure).getParentFile().mkdirs();
        log.info((Object)"Generating procedure", (Object)this.strategy.getFileName((Definition)procedure));
        GenerationWriter out = new GenerationWriter(new PrintWriter(this.strategy.getFile((Definition)procedure)));
        this.printHeader(out, this.strategy.getJavaPackageName((Definition)procedure));
        this.printClassJavadoc(out, (Definition)procedure);
        Class<StoredProcedureImpl> procedureClass = StoredProcedureImpl.class;
        if (database.getDialect() == SQLDialect.POSTGRES && procedure.getOutParameters().size() == 1 && ((ParameterDefinition)procedure.getOutParameters().get(0)).getType().isUDT()) {
            procedureClass = PostgresSingleUDTOutParameterProcedure.class;
        }
        out.println("public class " + this.strategy.getJavaClassName((Definition)procedure) + " extends " + procedureClass.getSimpleName() + " {");
        out.printSerial();
        out.printImport(procedureClass);
        out.println();
        for (ParameterDefinition parameter : procedure.getAllParameters()) {
            this.printParameter(out, parameter, (Definition)procedure);
        }
        out.println();
        this.printJavadoc(out, "Create a new procedure call instance");
        out.println("\tpublic " + this.strategy.getJavaClassName((Definition)procedure) + "() {");
        out.printImport(SQLDialect.class);
        out.printImport(this.strategy.getFullJavaClassName((Definition)schema));
        out.print("\t\tsuper(SQLDialect.");
        out.print(database.getDialect().name());
        out.print(", \"");
        out.print(procedure.getName());
        out.print("\", ");
        out.print(this.strategy.getJavaClassName((Definition)schema));
        out.print(".");
        out.print(schema.getNameUC());
        if (procedure.getPackage() != null) {
            out.print(", ");
            out.print(this.strategy.getJavaClassName((Definition)procedure.getPackage()));
            out.print(".");
            out.print(this.strategy.getJavaIdentifier((Definition)procedure.getPackage()));
            out.printImport(this.strategy.getFullJavaClassName((Definition)procedure.getPackage()));
        }
        out.println(");");
        if (procedure.getAllParameters().size() > 0) {
            out.println();
        }
        for (ParameterDefinition parameter : procedure.getAllParameters()) {
            String parameterNameUC = parameter.getName().toUpperCase();
            out.print("\t\t");
            if (parameter.equals(procedure.getReturnValue())) {
                out.println("setReturnParameter(" + parameterNameUC + ");");
                continue;
            }
            if (procedure.getInParameters().contains(parameter)) {
                if (procedure.getOutParameters().contains(parameter)) {
                    out.println("addInOutParameter(" + parameterNameUC + ");");
                    continue;
                }
                out.println("addInParameter(" + parameterNameUC + ");");
                continue;
            }
            out.println("addOutParameter(" + parameterNameUC + ");");
        }
        if (procedure.getOverload() != null) {
            out.println("\t\tsetOverloaded(true);");
        }
        out.println("\t}");
        for (ParameterDefinition parameter : procedure.getInParameters()) {
            out.println();
            out.print("\tpublic void set");
            out.print(this.strategy.getJavaClassName((Definition)parameter));
            out.print("(");
            this.printNumberType(out, parameter.getType());
            out.println(" value) {");
            out.print("\t\tset");
            if (parameter.getType().isGenericNumberType()) {
                out.print("Number");
            } else {
                out.print("Value");
            }
            out.print("(");
            out.print(parameter.getNameUC());
            out.println(", value);");
            out.println("\t}");
        }
        for (ParameterDefinition parameter : procedure.getAllParameters()) {
            if (!parameter.equals(procedure.getReturnValue()) && !procedure.getOutParameters().contains(parameter)) continue;
            out.println();
            out.println("\tpublic " + this.getSimpleJavaType(parameter.getType()) + " get" + this.strategy.getJavaClassName((Definition)parameter) + "() {");
            out.println("\t\treturn getValue(" + parameter.getNameUC() + ");");
            out.println("\t}");
        }
        out.println("}");
        out.close();
    }

    private void printFunction(Database database, SchemaDefinition schema, FunctionDefinition function) throws SQLException, FileNotFoundException {
        this.strategy.getFile((Definition)function).getParentFile().mkdirs();
        log.info((Object)"Generating function", (Object)this.strategy.getFileName((Definition)function));
        GenerationWriter out = new GenerationWriter(new PrintWriter(this.strategy.getFile((Definition)function)));
        this.printHeader(out, this.strategy.getJavaPackageName((Definition)function));
        this.printClassJavadoc(out, (Definition)function);
        out.print("public class ");
        out.print(this.strategy.getJavaClassName((Definition)function));
        out.print(" extends StoredFunctionImpl<");
        this.print(out, function.getReturnType());
        out.println("> {");
        out.printSerial();
        out.printImport(StoredFunctionImpl.class);
        out.println();
        for (ParameterDefinition parameter : function.getInParameters()) {
            this.printParameter(out, parameter, (Definition)function);
        }
        out.println();
        this.printJavadoc(out, "Create a new function call instance");
        out.println("\tpublic " + this.strategy.getJavaClassName((Definition)function) + "() {");
        out.printImport(SQLDialect.class);
        out.printImport(this.strategy.getFullJavaClassName((Definition)schema));
        out.printImportForDialectDataTypes(database.getDialect());
        out.print("\t\tsuper(SQLDialect.");
        out.print(database.getDialect().name());
        out.print(", \"");
        out.print(function.getName());
        out.print("\", ");
        out.print(this.strategy.getJavaClassName((Definition)schema));
        out.print(".");
        out.print(schema.getNameUC());
        out.print(", ");
        if (function.getPackage() != null) {
            out.print(this.strategy.getJavaClassName((Definition)function.getPackage()));
            out.print(".");
            out.print(this.strategy.getJavaIdentifier((Definition)function.getPackage()));
            out.print(", ");
            out.printImport(this.strategy.getFullJavaClassName((Definition)function.getPackage()));
        }
        out.print(this.getJavaTypeReference(database, out, function.getReturnType()));
        out.println(");");
        if (function.getInParameters().size() > 0) {
            out.println();
        }
        for (ParameterDefinition parameter : function.getInParameters()) {
            String parameterNameUC = parameter.getName().toUpperCase();
            out.print("\t\t");
            out.println("addInParameter(" + parameterNameUC + ");");
        }
        if (function.getOverload() != null) {
            out.println("\t\tsetOverloaded(true);");
        }
        out.println("\t}");
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.println();
            out.println("\t/**");
            out.println("\t * Set the <code>" + parameter.getName() + "</code> parameter to the function");
            out.println("\t */");
            out.print("\tpublic void set");
            out.print(this.strategy.getJavaClassName((Definition)parameter));
            out.print("(");
            this.printNumberType(out, parameter.getType());
            out.println(" value) {");
            out.print("\t\tset");
            if (parameter.getType().isGenericNumberType()) {
                out.print("Number");
            } else {
                out.print("Value");
            }
            out.print("(");
            out.print(parameter.getNameUC());
            out.println(", value);");
            out.println("\t}");
            out.println();
            out.println("\t/**");
            out.println("\t * Set the <code>" + parameter.getName() + "</code> parameter to the function");
            out.println("\t * <p>");
            out.println("\t * Use this method only, if the function is called as a {@link Field} in a {@link Select} statement!");
            out.println("\t */");
            out.print("\tpublic void set");
            out.print(this.strategy.getJavaClassName((Definition)parameter));
            out.print("(Field<");
            this.printExtendsNumberType(out, parameter.getType());
            out.println("> field) {");
            out.print("\t\tset");
            if (parameter.getType().isGenericNumberType()) {
                out.print("Number");
            } else {
                out.print("Field");
            }
            out.print("(");
            out.print(parameter.getNameUC());
            out.println(", field);");
            out.println("\t}");
            out.printImport(Select.class);
            out.printImport(Field.class);
        }
        out.println("}");
        out.close();
    }

    private void printConvenienceMethodFunctionAsField(GenerationWriter out, FunctionDefinition function, boolean parametersAsField) throws SQLException {
        if (function.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        if (parametersAsField && function.getInParameters().isEmpty()) {
            return;
        }
        out.println();
        out.println("\t/**");
        out.println("\t * Get " + function.getNameUC() + " as a field");
        out.println("\t *");
        out.printImport(this.strategy.getFullJavaClassName((Definition)function));
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.println("\t * @param " + this.strategy.getJavaClassNameLC((Definition)parameter));
        }
        out.println("\t */");
        out.print("\tpublic static Field<");
        this.print(out, function.getReturnType());
        out.print("> ");
        out.print(this.strategy.getJavaClassNameLC((Definition)function));
        out.print("(");
        out.printImport(Field.class);
        String separator = "";
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.print(separator);
            if (parametersAsField) {
                out.print("Field<");
                this.printExtendsNumberType(out, parameter.getType());
                out.print(">");
                out.printImport(Field.class);
            } else {
                this.printNumberType(out, parameter.getType());
            }
            out.print(" ");
            out.print(this.strategy.getJavaClassNameLC((Definition)parameter));
            separator = ", ";
        }
        out.println(") {");
        out.println("\t\t" + this.strategy.getJavaClassName((Definition)function) + " f = new " + this.strategy.getJavaClassName((Definition)function) + "();");
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.println("\t\tf.set" + this.strategy.getJavaClassName((Definition)parameter) + "(" + this.strategy.getJavaClassNameLC((Definition)parameter) + ");");
        }
        out.println();
        out.println("\t\treturn f.asField();");
        out.println("\t}");
    }

    private void printConvenienceMethodFunction(GenerationWriter out, FunctionDefinition function) throws SQLException {
        if (function.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        out.println();
        out.println("\t/**");
        out.println("\t * Invoke " + function.getNameUC());
        out.println("\t *");
        out.printImport(this.strategy.getFullJavaClassName((Definition)function));
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.println("\t * @param " + this.strategy.getJavaClassNameLC((Definition)parameter));
        }
        out.println("\t */");
        out.print("\tpublic static ");
        this.print(out, function.getReturnType());
        out.print(" ");
        out.print(this.strategy.getJavaClassNameLC((Definition)function));
        out.print("(Connection connection");
        out.printImport(Connection.class);
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.print(", ");
            this.printNumberType(out, parameter.getType());
            out.print(" ");
            out.print(this.strategy.getJavaClassNameLC((Definition)parameter));
        }
        out.println(") throws SQLException {");
        out.printImport(SQLException.class);
        out.println("\t\t" + this.strategy.getJavaClassName((Definition)function) + " f = new " + this.strategy.getJavaClassName((Definition)function) + "();");
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.println("\t\tf.set" + this.strategy.getJavaClassName((Definition)parameter) + "(" + this.strategy.getJavaClassNameLC((Definition)parameter) + ");");
        }
        out.println();
        out.println("\t\tf.execute(connection);");
        out.println("\t\treturn f.getReturnValue();");
        out.println("\t}");
    }

    private void printPrivateConstructor(GenerationWriter out, String javaClassName) {
        out.println();
        out.println("\t/**");
        out.println("\t * No instances");
        out.println("\t */");
        out.println("\tprivate " + javaClassName + "() {}");
    }

    private void printConvenienceMethodProcedure(GenerationWriter out, ProcedureDefinition procedure) throws SQLException {
        if (procedure.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Procedure " + procedure + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        out.println();
        out.println("\t/**");
        out.println("\t * Invoke " + procedure.getNameUC());
        out.println("\t *");
        out.printImport(this.strategy.getFullJavaClassName((Definition)procedure));
        for (ParameterDefinition parameter : procedure.getAllParameters()) {
            out.print("\t * @param " + this.strategy.getJavaClassNameLC((Definition)parameter) + " ");
            if (procedure.getInParameters().contains(parameter)) {
                if (procedure.getOutParameters().contains(parameter)) {
                    out.println("IN OUT parameter");
                    continue;
                }
                out.println("IN parameter");
                continue;
            }
            out.println("OUT parameter");
        }
        out.println("\t */");
        out.print("\tpublic static ");
        if (procedure.getOutParameters().size() == 0) {
            out.print("void ");
        } else if (procedure.getOutParameters().size() == 1) {
            this.print(out, ((ParameterDefinition)procedure.getOutParameters().get(0)).getType());
            out.print(" ");
        } else {
            out.print(this.strategy.getJavaClassName((Definition)procedure) + " ");
        }
        out.print(this.strategy.getJavaClassNameLC((Definition)procedure));
        out.print("(Connection connection");
        out.printImport(Connection.class);
        for (ParameterDefinition parameter : procedure.getInParameters()) {
            out.print(", ");
            this.printNumberType(out, parameter.getType());
            out.print(" ");
            out.print(this.strategy.getJavaClassNameLC((Definition)parameter));
        }
        out.println(") throws SQLException {");
        out.printImport(SQLException.class);
        out.println("\t\t" + this.strategy.getJavaClassName((Definition)procedure) + " p = new " + this.strategy.getJavaClassName((Definition)procedure) + "();");
        for (ParameterDefinition parameter : procedure.getInParameters()) {
            out.println("\t\tp.set" + this.strategy.getJavaClassName((Definition)parameter) + "(" + this.strategy.getJavaClassNameLC((Definition)parameter) + ");");
        }
        out.println();
        out.println("\t\tp.execute(connection);");
        if (procedure.getOutParameters().size() == 1) {
            out.println("\t\treturn p.get" + this.strategy.getJavaClassName((Definition)procedure.getOutParameters().get(0)) + "();");
        } else if (procedure.getOutParameters().size() > 1) {
            out.println("\t\treturn p;");
        }
        out.println("\t}");
    }

    private void printRecordTypeMethod(String targetPackage, Definition definition, GenerationWriter out) {
        out.println();
        out.println("\t/**");
        out.println("\t * The class holding records for this type");
        out.println("\t */");
        out.println("\tprivate static final Class<" + this.strategy.getJavaClassName(definition, "Record") + "> __RECORD_TYPE = " + this.strategy.getJavaClassName(definition, "Record") + ".class;");
        out.println();
        out.println("\t/**");
        out.println("\t * The class holding records for this type");
        out.println("\t */");
        this.printOverride(out);
        out.println("\tpublic Class<" + this.strategy.getJavaClassName(definition, "Record") + "> getRecordType() {");
        out.println("\t\treturn __RECORD_TYPE;");
        out.println("\t}");
        out.printImport(targetPackage + "." + this.strategy.getSubPackage(definition) + ".records." + this.strategy.getJavaClassName(definition, "Record"));
    }

    private void printSingletonInstance(Definition definition, GenerationWriter out) {
        out.println();
        out.println("\t/**");
        out.println("\t * The singleton instance of " + definition.getName());
        out.println("\t */");
        out.println("\tpublic static final " + this.strategy.getJavaClassName(definition) + " " + definition.getNameUC() + " = new " + this.strategy.getJavaClassName(definition) + "();");
    }

    private void printSingletonReference(GenerationWriter out, Definition definition) {
        if (definition instanceof SequenceDefinition) {
            out.print("Sequences.");
            out.print(definition.getNameUC());
        } else {
            out.print(this.strategy.getJavaClassName(definition));
            out.print(".");
            out.print(definition.getNameUC());
        }
    }

    private void printOverride(GenerationWriter out) {
        out.println("\t@Override");
    }

    private void empty(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                File[] children = file.listFiles();
                if (children != null) {
                    for (File child : children) {
                        this.empty(child);
                    }
                }
            } else if (file.getName().endsWith(".java")) {
                file.delete();
            }
        }
    }

    private void printGetterAndSetter(GenerationWriter out, TypedElementDefinition element, Definition type, String tablePackage, Set<String> reserved) throws SQLException {
        String columnDisambiguationSuffix = "";
        String getterDisambiguationSuffix = "";
        if (element.getNameUC().equals(type.getNameUC())) {
            columnDisambiguationSuffix = "_";
        }
        if (reserved.contains(this.strategy.getJavaClassName((Definition)element))) {
            getterDisambiguationSuffix = "_";
        }
        this.printFieldJavaDoc(out, getterDisambiguationSuffix, element);
        out.println("\tpublic void set" + this.strategy.getJavaClassName((Definition)element) + getterDisambiguationSuffix + "(" + this.getSimpleJavaType(element.getType()) + " value) {");
        out.println("\t\tsetValue(" + this.strategy.getJavaClassName(type) + "." + element.getNameUC() + columnDisambiguationSuffix + ", value);");
        out.println("\t}");
        this.printFieldJavaDoc(out, getterDisambiguationSuffix, element);
        out.println("\tpublic " + this.getSimpleJavaType(element.getType()) + " get" + this.strategy.getJavaClassName((Definition)element) + getterDisambiguationSuffix + "() {");
        out.println("\t\treturn getValue(" + this.strategy.getJavaClassName(type) + "." + element.getNameUC() + columnDisambiguationSuffix + ");");
        out.println("\t}");
        if (this.generateRelations() && element instanceof ColumnDefinition) {
            ColumnDefinition column = (ColumnDefinition)element;
            List uniqueKeys = column.getUniqueKeys();
            for (UniqueKeyDefinition uniqueKey : uniqueKeys) {
                if (!out.printOnlyOnce(uniqueKey)) continue;
                for (ForeignKeyDefinition foreignKey : uniqueKey.getForeignKeys()) {
                    if (foreignKey.getReferencedColumns().size() != foreignKey.getKeyColumns().size()) {
                        log.warn((Object)"Foreign key mismatch", (Object)(foreignKey.getName() + " does not match its primary key! No code is generated for this key. See trac tickets #64 and #69"));
                        continue;
                    }
                    TableDefinition referencing = foreignKey.getKeyTable();
                    for (String prefix : new String[]{"fetch", "get"}) {
                        String deprecation = null;
                        if ("get".equals(prefix)) {
                            if (!this.generateDeprecated()) continue;
                            deprecation = "Because of risk of ambiguity (#187), code generation for this<br/>\nmethod will not be supported anymore, soon.<br/><br/>\nIf you wish to remove this method, adapt your configuration:<br/>\n<code>generator.generate.deprecated=false</code>";
                        }
                        this.printFieldJavaDoc(out, null, (TypedElementDefinition)column, deprecation);
                        out.print("\tpublic List<");
                        out.print(this.strategy.getJavaClassName((Definition)referencing, "Record"));
                        out.print("> ");
                        out.print(prefix);
                        out.print(this.strategy.getJavaClassName((Definition)referencing));
                        out.print("List");
                        if (foreignKey.countSimilarReferences() > 1) {
                            out.print("By");
                            out.print(this.strategy.getJavaClassName((Definition)foreignKey.getKeyColumns().get(0)));
                        }
                        out.println("() throws SQLException {");
                        out.println("\t\treturn create()");
                        out.print("\t\t\t.selectFrom(");
                        out.print(this.strategy.getJavaClassName((Definition)referencing));
                        out.print(".");
                        out.print(referencing.getNameUC());
                        out.println(")");
                        String connector = "\t\t\t.where(";
                        for (int i = 0; i < foreignKey.getReferencedColumns().size(); ++i) {
                            out.print(connector);
                            out.print(this.strategy.getJavaClassName((Definition)referencing));
                            out.print(".");
                            out.print(((ColumnDefinition)foreignKey.getKeyColumns().get(i)).getNameUC());
                            out.print(".equal(getValue");
                            DataTypeDefinition foreignType = ((ColumnDefinition)foreignKey.getKeyColumns().get(i)).getType();
                            DataTypeDefinition primaryType = ((ColumnDefinition)uniqueKey.getKeyColumns().get(i)).getType();
                            if (!this.match(foreignType, primaryType)) {
                                out.print("As");
                                out.print(this.getSimpleJavaType(((ColumnDefinition)foreignKey.getKeyColumns().get(i)).getType()));
                            }
                            out.print("(");
                            out.print(this.strategy.getJavaClassName(type));
                            out.print(".");
                            out.print(((ColumnDefinition)uniqueKey.getKeyColumns().get(i)).getName().toUpperCase());
                            out.println(")))");
                            connector = "\t\t\t.and(";
                        }
                        out.println("\t\t\t.fetch()");
                        out.println("\t\t\t.getRecords();");
                        out.println("\t}");
                    }
                    out.printImport(tablePackage + "." + this.strategy.getJavaClassName((Definition)referencing));
                    out.printImport(SQLException.class);
                    out.printImport(List.class);
                }
            }
            ForeignKeyDefinition foreignKey = column.getForeignKey();
            if (foreignKey != null && out.printOnlyOnce(foreignKey)) {
                TableDefinition referenced;
                boolean skipGeneration = false;
                if (foreignKey.getReferencedColumns().size() != foreignKey.getKeyColumns().size()) {
                    log.warn((Object)"Foreign key mismatch", (Object)(foreignKey.getName() + " does not match its primary key! No code is generated for this key. See trac tickets #64 and #69"));
                    skipGeneration = true;
                }
                if ((referenced = foreignKey.getReferencedTable()) instanceof MasterDataTableDefinition) {
                    skipGeneration = true;
                }
                if (!skipGeneration) {
                    for (String prefix : new String[]{"fetch", "get"}) {
                        String deprecation = null;
                        if ("get".equals(prefix)) {
                            if (!this.generateDeprecated()) continue;
                            deprecation = "Because of risk of ambiguity (#187), code generation for this<br/>\nmethod will not be supported anymore, soon.<br/><br/>\nIf you wish to remove this method, adapt your configuration:<br/>\n<code>generator.generate.deprecated=false</code>";
                        }
                        this.printFieldJavaDoc(out, null, (TypedElementDefinition)column, deprecation);
                        out.print("\tpublic ");
                        out.print(this.strategy.getJavaClassName((Definition)referenced, "Record"));
                        out.print(" ");
                        out.print(prefix);
                        out.print(this.strategy.getJavaClassName((Definition)referenced));
                        if (foreignKey.countSimilarReferences() > 1) {
                            out.print("By");
                            out.print(this.strategy.getJavaClassName((Definition)column));
                        }
                        out.println("() throws SQLException {");
                        out.println("\t\treturn create()");
                        out.print("\t\t\t.selectFrom(");
                        out.print(this.strategy.getJavaClassName((Definition)referenced));
                        out.print(".");
                        out.print(referenced.getNameUC());
                        out.println(")");
                        String connector = "\t\t\t.where(";
                        for (int i = 0; i < foreignKey.getReferencedColumns().size(); ++i) {
                            out.print(connector);
                            out.print(this.strategy.getJavaClassName((Definition)referenced));
                            out.print(".");
                            out.print(((ColumnDefinition)foreignKey.getReferencedColumns().get(i)).getNameUC());
                            out.print(".equal(getValue");
                            DataTypeDefinition foreignType = ((ColumnDefinition)foreignKey.getKeyColumns().get(i)).getType();
                            DataTypeDefinition primaryType = ((ColumnDefinition)foreignKey.getReferencedColumns().get(i)).getType();
                            if (!this.match(foreignType, primaryType)) {
                                out.print("As");
                                out.print(this.getSimpleJavaType(((ColumnDefinition)foreignKey.getReferencedColumns().get(i)).getType()));
                            }
                            out.print("(");
                            out.print(this.strategy.getJavaClassName(type));
                            out.print(".");
                            out.print(((ColumnDefinition)foreignKey.getKeyColumns().get(i)).getName().toUpperCase());
                            out.println(")))");
                            connector = "\t\t\t.and(";
                        }
                        out.println("\t\t\t.fetchOne();");
                        out.println("\t}");
                    }
                    out.printImport(tablePackage + "." + this.strategy.getJavaClassName((Definition)referenced));
                    out.printImport(SQLException.class);
                }
            }
        }
        this.printImport(out, element.getType());
    }

    private void printUDTColumn(GenerationWriter out, AttributeDefinition attribute, Definition table) throws SQLException {
        Class<UDTField> declaredMemberClass = UDTField.class;
        Class<UDTFieldImpl> concreteMemberClass = UDTFieldImpl.class;
        this.printColumnDefinition(out, (TypedElementDefinition)attribute, table, declaredMemberClass, concreteMemberClass);
    }

    private void printTableColumn(GenerationWriter out, ColumnDefinition column, Definition table) throws SQLException {
        Class<TableField> declaredMemberClass = TableField.class;
        Class<TableFieldImpl> concreteMemberClass = TableFieldImpl.class;
        this.printColumnDefinition(out, (TypedElementDefinition)column, table, declaredMemberClass, concreteMemberClass);
    }

    private void printParameter(GenerationWriter out, ParameterDefinition parameter, Definition proc) throws SQLException {
        this.printColumnDefinition(out, (TypedElementDefinition)parameter, proc, Parameter.class, ParameterImpl.class);
    }

    private void printColumnDefinition(GenerationWriter out, TypedElementDefinition column, Definition type, Class<?> declaredMemberClass, Class<?> concreteMemberClass) throws SQLException {
        boolean hasType;
        String concreteMemberType = concreteMemberClass.getSimpleName();
        String declaredMemberType = declaredMemberClass.getSimpleName();
        String columnDisambiguationSuffix = column.getNameUC().equals(type.getNameUC()) ? "_" : "";
        this.printFieldJavaDoc(out, columnDisambiguationSuffix, column);
        String genericPrefix = "<";
        boolean bl = hasType = type instanceof TableDefinition || type instanceof UDTDefinition;
        if (hasType) {
            genericPrefix = genericPrefix + this.strategy.getJavaClassName(type, "Record") + ", ";
        }
        out.print("\tpublic static final ");
        out.print(declaredMemberType);
        out.print(genericPrefix);
        this.print(out, column.getType());
        out.print("> ");
        out.print(column.getNameUC());
        out.print(columnDisambiguationSuffix);
        out.print(" = new ");
        out.print(concreteMemberType);
        out.print(genericPrefix);
        this.print(out, column.getType());
        out.print(">(SQLDialect.");
        out.print(column.getDatabase().getDialect().name());
        out.print(", \"");
        out.print(column.getName());
        out.print("\", ");
        out.print(this.getJavaTypeReference(column.getDatabase(), out, column.getType()));
        if (hasType) {
            out.print(", " + type.getNameUC());
        }
        out.println(");");
        out.printImport(SQLDialect.class);
        out.printImport(declaredMemberClass);
        out.printImport(concreteMemberClass);
    }

    private void printFieldJavaDoc(GenerationWriter out, String disambiguationSuffix, TypedElementDefinition element) throws SQLException {
        this.printFieldJavaDoc(out, disambiguationSuffix, element, null);
    }

    private void printFieldJavaDoc(GenerationWriter out, String disambiguationSuffix, TypedElementDefinition element, String deprecation) throws SQLException {
        out.println();
        out.println("\t/**");
        String comment = element.getComment();
        if (comment != null && comment.length() > 0) {
            out.println("\t * " + comment);
        } else {
            out.println("\t * An uncommented item");
        }
        if (this.getJavaType(element.getType()).startsWith("java.lang.Object")) {
            String u;
            String t = element.getType().getType();
            String combined = t.equalsIgnoreCase(u = element.getType().getUserType()) ? t : t + ", " + u;
            out.println("\t * ");
            out.print("\t * The SQL type of this item (");
            out.print(combined);
            out.println(") could not be mapped.<br/>");
            out.println("\t * Deserialising this field might not work!");
            log.warn((Object)"Unknown type", (Object)(element.getQualifiedName() + " (" + combined + ")"));
        }
        if (element instanceof ColumnDefinition) {
            ColumnDefinition column = (ColumnDefinition)element;
            UniqueKeyDefinition primaryKey = column.getPrimaryKey();
            ForeignKeyDefinition foreignKey = column.getForeignKey();
            if (primaryKey != null) {
                out.println("\t * ");
                out.print("\t * PRIMARY KEY");
                out.println();
            }
            if (foreignKey != null) {
                out.println("\t * <p>");
                out.println("\t * <code><pre>");
                out.print("\t * FOREIGN KEY ");
                out.println(foreignKey.getKeyColumns().toString());
                out.print("\t * REFERENCES ");
                out.print(foreignKey.getReferencedTable().getName());
                out.print(" ");
                out.println(foreignKey.getReferencedColumns().toString());
                out.println("\t * </pre></code>");
            }
        }
        if (disambiguationSuffix != null && disambiguationSuffix.length() > 0) {
            out.println("\t * ");
            out.println("\t * This item causes a name clash. That is why an underline character was appended to the Java field name");
        }
        if (deprecation != null) {
            out.println("\t *");
            String[] strings = deprecation.split("[\n\r]+");
            for (int i = 0; i < strings.length; ++i) {
                if (i == 0) {
                    out.println("\t * @deprecated " + strings[i]);
                    continue;
                }
                out.println("\t *             " + strings[i]);
            }
        }
        out.println("\t */");
        if (deprecation != null) {
            out.println("\t@Deprecated");
        }
    }

    private void printNoFurtherInstancesAllowedJavadoc(GenerationWriter out) {
        this.printJavadoc(out, "No further instances allowed");
    }

    private void printJavadoc(GenerationWriter out, String doc) {
        out.println("\t/**");
        out.println("\t * " + doc);
        out.println("\t */");
    }

    private void printClassJavadoc(GenerationWriter out, Definition definition) {
        this.printClassJavadoc(out, definition.getComment());
    }

    private void printClassJavadoc(GenerationWriter out, String comment) {
        this.printClassJavadoc(out, comment, null);
    }

    private void printClassJavadoc(GenerationWriter out, String comment, String deprecation) {
        out.println("/**");
        out.println(" * This class is generated by jOOQ.");
        if (comment != null && comment.length() > 0) {
            out.println(" *");
            out.println(" * " + comment);
        }
        if (deprecation != null && deprecation.length() > 0) {
            out.println(" *");
            out.println(" * @deprecated : " + deprecation);
        }
        out.println(" */");
        out.println("@Generated(value    = \"http://jooq.sourceforge.net\",\n           comments = \"This class is generated by jOOQ\")");
        if (deprecation != null && deprecation.length() > 0) {
            out.println("@Deprecated");
        }
        out.printSuppressWarningsPlaceholder();
        out.printImport(Generated.class);
    }

    private void printHeader(GenerationWriter out, String packageName) {
        out.println("/**");
        out.println(" * This class is generated by jOOQ");
        out.println(" */");
        out.println("package " + packageName + ";");
        out.println();
        out.printImportPlaceholder();
        out.println();
    }

    private void printImport(GenerationWriter out, DataTypeDefinition type) throws SQLException {
        out.printImport(this.getJavaType(type));
    }

    private void printExtendsNumberType(GenerationWriter out, DataTypeDefinition type) throws SQLException {
        this.printNumberType(out, type, "? extends ");
    }

    private void printNumberType(GenerationWriter out, DataTypeDefinition type) throws SQLException {
        this.printNumberType(out, type, "");
    }

    private void printNumberType(GenerationWriter out, DataTypeDefinition type, String prefix) throws SQLException {
        if (type.isGenericNumberType()) {
            out.print(prefix);
            out.print(Number.class.getSimpleName());
        } else {
            out.print(this.getSimpleJavaType(type));
            out.printImport(this.getJavaType(type));
        }
    }

    private void print(GenerationWriter out, DataTypeDefinition type) throws SQLException {
        out.print(this.getSimpleJavaType(type));
        out.printImport(this.getJavaType(type));
    }

    private String getSimpleJavaType(DataTypeDefinition type) throws SQLException {
        return GenerationUtil.getSimpleJavaType(this.getJavaType(type));
    }

    private String getJavaTypeReference(Database db, GenerationWriter out, DataTypeDefinition type) throws SQLException {
        if (type instanceof MasterDataTypeDefinition) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getJavaTypeReference(db, out, ((MasterDataTypeDefinition)type).underlying));
            sb.append(".asMasterDataType(");
            sb.append(this.getSimpleJavaType(type));
            sb.append(".class)");
            return sb.toString();
        }
        if (db.isArrayType(type.getType())) {
            String baseType = GenerationUtil.getArrayBaseType(db.getDialect(), type.getType(), type.getUserType());
            return this.getTypeReference(db, out, baseType, 0, 0, baseType) + ".getArrayDataType()";
        }
        return this.getTypeReference(db, out, type.getType(), type.getPrecision(), type.getScale(), type.getUserType());
    }

    private String getJavaType(DataTypeDefinition type) throws SQLException {
        if (type instanceof MasterDataTypeDefinition) {
            return this.strategy.getFullJavaClassName((Definition)((MasterDataTypeDefinition)type).table);
        }
        return this.getType(type.getDatabase(), type.getType(), type.getPrecision(), type.getScale(), type.getUserType(), Object.class.getName());
    }

    private String getType(Database db, String t, int p, int s, String u, String defaultType) throws SQLException {
        String type;
        block10: {
            type = defaultType;
            if (db.isArrayType(t)) {
                String baseType = GenerationUtil.getArrayBaseType(db.getDialect(), t, u);
                type = this.getType(db, baseType, p, s, baseType, defaultType) + "[]";
            } else if (db.getArray(u) != null) {
                type = this.strategy.getFullJavaClassName((Definition)db.getArray(u), "Record");
            } else if (db.getEnum(u) != null) {
                type = this.strategy.getFullJavaClassName((Definition)db.getEnum(u));
            } else if (db.getUDT(u) != null) {
                type = this.strategy.getFullJavaClassName((Definition)db.getUDT(u), "Record");
            } else {
                try {
                    type = GenerationUtil.getDialectSQLType(db.getDialect(), t, p, s).getCanonicalName();
                }
                catch (SQLDialectNotSupportedException e) {
                    if (defaultType != null) break block10;
                    throw e;
                }
            }
        }
        return type;
    }

    private String getTypeReference(Database db, GenerationWriter out, String t, int p, int s, String u) throws SQLException {
        StringBuilder sb = new StringBuilder();
        if (db.getArray(u) != null) {
            ArrayDefinition array = db.getArray(u);
            sb.append(this.getJavaTypeReference(db, out, array.getElementType()));
            sb.append(".asArrayDataType(");
            sb.append(this.strategy.getJavaClassName((Definition)array, "Record"));
            sb.append(".class)");
        } else if (db.getUDT(u) != null) {
            UDTDefinition udt = db.getUDT(u);
            if (out != null) {
                out.printImport(this.strategy.getFullJavaClassName((Definition)udt));
            }
            sb.append(this.strategy.getJavaClassName((Definition)udt));
            sb.append(".");
            sb.append(udt.getNameUC());
            sb.append(".getDataType()");
        } else if (db.getEnum(u) != null) {
            if (out != null) {
                out.printImportForDialectDataTypes(db.getDialect());
            }
            sb.append(db.getDialect().getName());
            sb.append("DataType.");
            sb.append(FieldTypeHelper.normalise((String)FieldTypeHelper.getDataType((SQLDialect)db.getDialect(), String.class).getTypeName()));
            sb.append(".asEnumDataType(");
            sb.append(this.strategy.getJavaClassName((Definition)db.getEnum(u)));
            sb.append(".class)");
        } else {
            if (out != null) {
                out.printImportForDialectDataTypes(db.getDialect());
            }
            sb.append(db.getDialect().getName());
            sb.append("DataType.");
            try {
                String type1 = this.getType(db, t, p, s, u, null);
                String type2 = this.getType(db, t, 0, 0, u, null);
                sb.append(FieldTypeHelper.normalise((String)t));
                if (!type1.equals(type2)) {
                    Class<?> clazz = GenerationUtil.getDialectSQLType(db.getDialect(), t, p, s);
                    sb.append(".asNumberDataType(");
                    sb.append(clazz.getSimpleName());
                    sb.append(".class)");
                    if (out != null) {
                        out.printImport(clazz);
                    }
                }
            }
            catch (SQLDialectNotSupportedException e) {
                sb.append("getDefaultDataType(\"");
                sb.append(t);
                sb.append("\")");
            }
        }
        return sb.toString();
    }

    private boolean match(DataTypeDefinition type1, DataTypeDefinition type2) throws SQLException {
        return this.getJavaType(type1).equals(this.getJavaType(type2));
    }
}

