/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.File;
import org.jooq.impl.StringUtils;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.CallableDefinition;
import org.jooq.util.Definition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.FunctionDefinition;
import org.jooq.util.GeneratorStrategy;
import org.jooq.util.MasterDataTableDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ProcedureDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;

public class DefaultGeneratorStrategy
implements GeneratorStrategy {
    private String targetDirectory;
    private String targetPackage;

    @Override
    public final String getTargetDirectory() {
        return this.targetDirectory;
    }

    @Override
    public final void setTargetDirectory(String directory) {
        this.targetDirectory = directory;
    }

    @Override
    public final String getTargetPackage() {
        return this.targetPackage;
    }

    @Override
    public final void setTargetPackage(String packageName) {
        this.targetPackage = packageName;
    }

    @Override
    public final String getFileName(Definition definition) {
        return String.valueOf(this.getJavaClassName(definition)) + ".java";
    }

    @Override
    public final String getFileName(Definition definition, String suffix) {
        return String.valueOf(this.getJavaClassName(definition)) + suffix + ".java";
    }

    @Override
    public final File getFile(Definition definition) {
        return this.getFile(definition, "");
    }

    @Override
    public final File getFile(Definition definition, String suffix) {
        String dir = this.getTargetDirectory();
        String pkg = this.getJavaPackageName(definition, suffix).replaceAll("\\.", "/");
        return new File(String.valueOf(dir) + "/" + pkg, this.getFileName(definition, suffix));
    }

    @Override
    public final String getJavaClassName(Definition definition) {
        return this.getJavaClassName(definition, "");
    }

    @Override
    public final String getJavaPackageName(Definition definition) {
        return this.getJavaPackageName(definition, "");
    }

    @Override
    public final String getJavaPackageName(Definition definition, String suffix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTargetPackage());
        if (!StringUtils.isBlank((String)this.getSubPackage(definition))) {
            sb.append(".");
            sb.append(this.getSubPackage(definition));
        }
        if ("Record".equals(suffix)) {
            sb.append(".records");
        }
        return sb.toString();
    }

    @Override
    public final String getJavaClassNameLC(Definition definition) {
        return this.getJavaClassNameLC(definition, "");
    }

    @Override
    public final String getJavaClassNameLC(Definition definition, String suffix) {
        String result = this.getJavaClassName0(definition, suffix);
        return String.valueOf(result.substring(0, 1).toLowerCase()) + result.substring(1);
    }

    @Override
    public final String getJavaClassName(Definition definition, String suffix) {
        String result = this.getJavaClassName0(definition, suffix);
        if (this.isReserved(result)) {
            return String.valueOf(result) + "_";
        }
        return result;
    }

    private final String getJavaClassName0(Definition definition, String suffix) {
        StringBuilder result = new StringBuilder();
        String[] stringArray = definition.getName().split("_");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (word.length() > 0) {
                if (Character.isDigit(word.charAt(0))) {
                    result.append("_");
                }
                result.append(String.valueOf(word.substring(0, 1).toUpperCase()) + word.substring(1).toLowerCase());
            } else {
                result.append("_");
            }
            ++n2;
        }
        if (!StringUtils.isEmpty((String)suffix)) {
            result.append(suffix);
        }
        if (!StringUtils.isBlank((String)definition.getOverload())) {
            result.append(definition.getOverload());
        }
        return result.toString();
    }

    private final boolean isReserved(String className) {
        String[] stringArray = new String[]{"java.lang.", "java.math."};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            try {
                Class.forName(String.valueOf(prefix) + className);
                return true;
            }
            catch (Exception exception) {
                ++n2;
            }
        }
        return false;
    }

    @Override
    public final String getFullJavaClassName(Definition definition) {
        return this.getFullJavaClassName(definition, "");
    }

    @Override
    public final String getFullJavaClassName(Definition definition, String suffix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getJavaPackageName(definition, suffix));
        sb.append(".");
        sb.append(this.getJavaClassName(definition, suffix));
        return sb.toString();
    }

    @Override
    public final String getSubPackage(Definition definition) {
        if (definition instanceof MasterDataTableDefinition) {
            return "enums";
        }
        if (definition instanceof TableDefinition) {
            return "tables";
        }
        if (definition instanceof PackageDefinition) {
            return "packages." + definition.getNameLC();
        }
        if (definition instanceof CallableDefinition) {
            CallableDefinition callable = (CallableDefinition)definition;
            if (callable.getPackage() != null) {
                return "packages." + callable.getPackage().getNameLC();
            }
            if (definition instanceof FunctionDefinition) {
                return "functions";
            }
            if (definition instanceof ProcedureDefinition) {
                return "procedures";
            }
        } else {
            if (definition instanceof EnumDefinition) {
                return "enums";
            }
            if (definition instanceof ArrayDefinition) {
                return "udt";
            }
            if (definition instanceof UDTDefinition) {
                return "udt";
            }
        }
        return "";
    }
}

