/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.postgres;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.Factory;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.AbstractDefinition;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultEnumDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.FunctionDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ProcedureDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.postgres.PostgresFunctionDefinition;
import org.jooq.util.postgres.PostgresProcedureDefinition;
import org.jooq.util.postgres.PostgresTableDefinition;
import org.jooq.util.postgres.PostgresUDTDefinition;
import org.jooq.util.postgres.information_schema.InformationSchemaFactory;
import org.jooq.util.postgres.information_schema.tables.Attributes;
import org.jooq.util.postgres.information_schema.tables.KeyColumnUsage;
import org.jooq.util.postgres.information_schema.tables.Parameters;
import org.jooq.util.postgres.information_schema.tables.ReferentialConstraints;
import org.jooq.util.postgres.information_schema.tables.Routines;
import org.jooq.util.postgres.information_schema.tables.Sequences;
import org.jooq.util.postgres.information_schema.tables.TableConstraints;
import org.jooq.util.postgres.information_schema.tables.Tables;
import org.jooq.util.postgres.information_schema.tables.records.RoutinesRecord;
import org.jooq.util.postgres.pg_catalog.tables.PgEnum;
import org.jooq.util.postgres.pg_catalog.tables.PgType;

public class PostgresDatabase
extends AbstractDatabase {
    @Override
    protected void loadPrimaryKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("PRIMARY KEY")) {
            String key = (String)record.getValue(KeyColumnUsage.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(KeyColumnUsage.TABLE_NAME);
            String columnName = (String)record.getValue(KeyColumnUsage.COLUMN_NAME);
            TableDefinition table = this.getTable(tableName);
            if (table == null) continue;
            relations.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("UNIQUE")) {
            String key = (String)record.getValue(KeyColumnUsage.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(KeyColumnUsage.TABLE_NAME);
            String columnName = (String)record.getValue(KeyColumnUsage.COLUMN_NAME);
            TableDefinition table = this.getTable(tableName);
            if (table == null) continue;
            relations.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    private Result<Record> fetchKeys(String constraintType) throws SQLException {
        return this.create().select(new Field[]{KeyColumnUsage.CONSTRAINT_NAME, KeyColumnUsage.TABLE_NAME, KeyColumnUsage.COLUMN_NAME}).from(new TableLike[]{TableConstraints.TABLE_CONSTRAINTS}).join((TableLike)KeyColumnUsage.KEY_COLUMN_USAGE).on(new Condition[]{TableConstraints.CONSTRAINT_NAME.equal(KeyColumnUsage.CONSTRAINT_NAME)}).where(new Condition[]{TableConstraints.CONSTRAINT_TYPE.equal((Object)constraintType).and(TableConstraints.CONSTRAINT_SCHEMA.equal((Object)this.getSchemaName()))}).orderBy(new SortField[]{KeyColumnUsage.TABLE_SCHEMA.ascending(), KeyColumnUsage.TABLE_NAME.ascending(), KeyColumnUsage.ORDINAL_POSITION.ascending()}).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations) throws SQLException {
        Result records = this.create().selectDistinct(new Field[]{ReferentialConstraints.UNIQUE_CONSTRAINT_NAME, KeyColumnUsage.CONSTRAINT_NAME, KeyColumnUsage.TABLE_NAME, KeyColumnUsage.COLUMN_NAME}).from(new TableLike[]{ReferentialConstraints.REFERENTIAL_CONSTRAINTS}).join((TableLike)KeyColumnUsage.KEY_COLUMN_USAGE).on(new Condition[]{ReferentialConstraints.CONSTRAINT_NAME.equal(KeyColumnUsage.CONSTRAINT_NAME)}).where(new Condition[]{ReferentialConstraints.CONSTRAINT_SCHEMA.equal((Object)this.getSchemaName())}).orderBy(new SortField[]{KeyColumnUsage.CONSTRAINT_NAME.ascending(), KeyColumnUsage.TABLE_NAME.ascending(), KeyColumnUsage.COLUMN_NAME.ascending()}).fetch();
        for (Record record : records) {
            String foreignKey = (String)record.getValue(ReferentialConstraints.CONSTRAINT_NAME);
            String foreignKeyTable = (String)record.getValue(KeyColumnUsage.TABLE_NAME);
            String foreignKeyColumn = (String)record.getValue(KeyColumnUsage.COLUMN_NAME);
            String uniqueKey = (String)record.getValue(ReferentialConstraints.UNIQUE_CONSTRAINT_NAME);
            TableDefinition referencingTable = this.getTable(foreignKeyTable);
            if (referencingTable == null) continue;
            ColumnDefinition referencingColumn = referencingTable.getColumn(foreignKeyColumn);
            relations.addForeignKey(foreignKey, uniqueKey, referencingColumn);
        }
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (String name : this.create().select(new Field[]{Sequences.SEQUENCE_NAME}).from(new TableLike[]{Sequences.SEQUENCES}).where(new Condition[]{Sequences.SEQUENCE_SCHEMA.equal((Object)this.getSchemaName())}).orderBy(new Field[]{Sequences.SEQUENCE_NAME}).fetch(Sequences.SEQUENCE_NAME)) {
            result.add(new DefaultSequenceDefinition(this, name));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (String name : this.create().select(new Field[]{Tables.TABLE_NAME}).from(new TableLike[]{Tables.TABLES}).where(new Condition[]{Tables.TABLE_SCHEMA.equal((Object)this.getSchemaName())}).orderBy(new Field[]{Tables.TABLE_NAME}).fetch(Tables.TABLE_NAME)) {
            PostgresTableDefinition table = new PostgresTableDefinition(this, name, null);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        Result records = this.create().select(new Field[]{PgType.TYPNAME, PgEnum.ENUMLABEL}).from(new TableLike[]{PgEnum.PG_ENUM}).join((TableLike)PgType.PG_TYPE).on("pg_enum.enumtypid = pg_type.oid").orderBy(new Field[]{PgEnum.ENUMTYPID}).fetch();
        AbstractDefinition definition = null;
        for (Record record : records) {
            String typeName = String.valueOf(record.getValue(PgType.TYPNAME));
            if (definition == null || !definition.getName().equals(typeName)) {
                definition = new DefaultEnumDefinition(this, typeName, null);
                result.add((EnumDefinition)((Object)definition));
            }
            ((DefaultEnumDefinition)definition).addLiteral(String.valueOf(record.getValue(PgEnum.ENUMLABEL)));
        }
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        for (String name : this.create().selectDistinct(new Field[]{Attributes.UDT_NAME}).from(new TableLike[]{Attributes.ATTRIBUTES}).where(new Condition[]{Attributes.UDT_SCHEMA.equal((Object)this.getSchemaName())}).orderBy(new Field[]{Attributes.UDT_NAME}).fetch(Attributes.UDT_NAME)) {
            result.add(new PostgresUDTDefinition(this, name, null));
        }
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<ProcedureDefinition> getProcedures0() throws SQLException {
        ArrayList<ProcedureDefinition> result = new ArrayList<ProcedureDefinition>();
        Table r1 = Routines.ROUTINES.as("r1");
        Table r2 = Routines.ROUTINES.as("r2");
        for (Record record : this.create().select(new Field[]{r1.getField(Routines.ROUTINE_NAME), r1.getField(Routines.SPECIFIC_NAME), r1.getField(Routines.DATA_TYPE), r1.getField(Routines.TYPE_UDT_NAME), this.getOverloadField((Table<RoutinesRecord>)r1, (Table<RoutinesRecord>)r2)}).from(new TableLike[]{r1}).where(new Condition[]{r1.getField(Routines.ROUTINE_SCHEMA).equal((Object)this.getSchemaName())}).and(r1.getField(Routines.DATA_TYPE).lower().in((Object[])new String[]{"void", "record"}).orExists((Select)this.create().select(new Object[]{1}).from(new TableLike[]{Parameters.PARAMETERS}).where(new Condition[]{Parameters.SPECIFIC_SCHEMA.equal((Object)this.getSchemaName())}).and(Parameters.SPECIFIC_NAME.equal(r1.getField(Routines.SPECIFIC_NAME))).and(Parameters.PARAMETER_MODE.lower().in((Object[])new String[]{"out", "inout"})))).orderBy(new SortField[]{r1.getField(Routines.ROUTINE_NAME).ascending()}).fetch()) {
            result.add(new PostgresProcedureDefinition(this, record));
        }
        return result;
    }

    private Field<Object> getOverloadField(Table<RoutinesRecord> r1, Table<RoutinesRecord> r2) {
        return this.create().decode().when(this.create().exists((Select)this.create().select(new Object[]{1}).from(new TableLike[]{r2}).where(new Condition[]{r2.getField(Routines.ROUTINE_SCHEMA).equal((Object)this.getSchemaName())}).and(r2.getField(Routines.ROUTINE_NAME).equal(r1.getField(Routines.ROUTINE_NAME))).and(r2.getField(Routines.SPECIFIC_NAME).notEqual(r1.getField(Routines.SPECIFIC_NAME)))), this.create().select(new Field[]{this.create().count()}).from(new TableLike[]{r2}).where(new Condition[]{r2.getField(Routines.ROUTINE_SCHEMA).equal((Object)this.getSchemaName())}).and(r2.getField(Routines.ROUTINE_NAME).equal(r1.getField(Routines.ROUTINE_NAME))).and(r2.getField(Routines.SPECIFIC_NAME).lessOrEqual(r1.getField(Routines.SPECIFIC_NAME))).asField()).as("overload");
    }

    @Override
    protected List<FunctionDefinition> getFunctions0() throws SQLException {
        ArrayList<FunctionDefinition> result = new ArrayList<FunctionDefinition>();
        Table r1 = Routines.ROUTINES.as("r1");
        Table r2 = Routines.ROUTINES.as("r2");
        for (Record record : this.create().select(new Field[]{r1.getField(Routines.ROUTINE_NAME), r1.getField(Routines.SPECIFIC_NAME), r1.getField(Routines.DATA_TYPE), r1.getField(Routines.TYPE_UDT_NAME), this.getOverloadField((Table<RoutinesRecord>)r1, (Table<RoutinesRecord>)r2)}).from(new TableLike[]{r1}).where(new Condition[]{r1.getField(Routines.ROUTINE_SCHEMA).equal((Object)this.getSchemaName())}).and(r1.getField(Routines.DATA_TYPE).lower().notIn((Object[])new String[]{"void", "record"})).andNotExists((Select)this.create().select(new Object[]{1}).from(new TableLike[]{Parameters.PARAMETERS}).where(new Condition[]{Parameters.SPECIFIC_SCHEMA.equal((Object)this.getSchemaName())}).and(Parameters.SPECIFIC_NAME.equal(r1.getField(Routines.SPECIFIC_NAME))).and(Parameters.PARAMETER_MODE.lower().in((Object[])new String[]{"out", "inout"}))).orderBy(new SortField[]{r1.getField(Routines.ROUTINE_NAME).ascending()}).fetch()) {
            result.add(new PostgresFunctionDefinition(this, record));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    public Factory create() {
        return new InformationSchemaFactory(this.getConnection());
    }
}

