/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.oracle;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.impl.StringUtils;
import org.jooq.util.AbstractProcedureDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultColumnDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.InOutDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.oracle.sys.tables.AllArguments;

public class OracleProcedureDefinition
extends AbstractProcedureDefinition {
    private final BigDecimal objectId;

    public OracleProcedureDefinition(Database database, PackageDefinition pkg, String name, String comment, BigDecimal objectId, String overload) {
        super(database, pkg, name, comment, overload);
        this.objectId = objectId;
    }

    @Override
    protected void init0() throws SQLException {
        Result result = this.create().select(new Field[]{AllArguments.IN_OUT, AllArguments.ARGUMENT_NAME, AllArguments.DATA_TYPE, AllArguments.TYPE_NAME, AllArguments.POSITION}).from(new TableLike[]{AllArguments.ALL_ARGUMENTS}).where(new Condition[]{AllArguments.OWNER.equal((Object)this.getSchemaName()).and(AllArguments.OBJECT_NAME.equal((Object)this.getName())).and(AllArguments.OBJECT_ID.equal((Object)this.objectId)).and(AllArguments.OVERLOAD.equal((Object)this.getOverload()))}).and(AllArguments.DATA_LEVEL.equal((Object)BigDecimal.ZERO)).and(AllArguments.DATA_TYPE.isNotNull()).orderBy(new SortField[]{AllArguments.POSITION.ascending()}).fetch();
        for (Record record : result) {
            InOutDefinition inOut = InOutDefinition.getFromString((String)record.getValue(AllArguments.IN_OUT));
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), (String)record.getValue(AllArguments.DATA_TYPE), (String)record.getValue(AllArguments.TYPE_NAME));
            String name = (String)record.getValue(AllArguments.ARGUMENT_NAME);
            Integer position = record.getValueAsInteger(AllArguments.POSITION);
            if (StringUtils.isBlank((String)name) && position == 0) {
                inOut = InOutDefinition.RETURN;
                name = "RETURN_VALUE";
            }
            DefaultColumnDefinition column = new DefaultColumnDefinition(this.getDatabase(), this.getName(), name, position, type, null);
            this.addParameter(inOut, column);
        }
    }
}

