/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.hsqldb;

import java.sql.SQLException;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.util.AbstractProcedureDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultColumnDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.InOutDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.hsqldb.information_schema.tables.Parameters;

public class HSQLDBProcedureDefinition
extends AbstractProcedureDefinition {
    private final String specificName;

    public HSQLDBProcedureDefinition(Database database, PackageDefinition pkg, String name, String specificName) {
        super(database, pkg, name, null, null);
        this.specificName = specificName;
    }

    @Override
    protected void init0() throws SQLException {
        Result result = this.create().select(new Field[]{Parameters.PARAMETER_MODE, Parameters.PARAMETER_NAME, Parameters.DATA_TYPE, Parameters.ORDINAL_POSITION}).from(new TableLike[]{Parameters.PARAMETERS}).where(new Condition[]{Parameters.SPECIFIC_SCHEMA.equal((Object)this.getSchemaName())}).and(Parameters.SPECIFIC_NAME.equal((Object)this.specificName)).orderBy(new SortField[]{Parameters.ORDINAL_POSITION.ascending()}).fetch();
        for (Record record : result) {
            String inOut = (String)record.getValue(Parameters.PARAMETER_MODE);
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), (String)record.getValue(Parameters.DATA_TYPE));
            DefaultColumnDefinition column = new DefaultColumnDefinition(this.getDatabase(), this.getName(), (String)record.getValue(Parameters.PARAMETER_NAME), record.getValueAsInteger(Parameters.ORDINAL_POSITION), type, null);
            this.addParameter(InOutDefinition.getFromString(inOut), column);
        }
    }
}

