/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.JooqLogger;
import org.jooq.util.AbstractDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.MasterDataTableDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UniqueKeyDefinition;

public class DefaultMasterDataTableDefinition
extends AbstractDefinition
implements MasterDataTableDefinition {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultMasterDataTableDefinition.class);
    private final TableDefinition delegate;
    private List<Record> data;

    public DefaultMasterDataTableDefinition(TableDefinition delegate) {
        super(delegate.getDatabase(), delegate.getName(), delegate.getComment());
        this.delegate = delegate;
    }

    @Override
    public ColumnDefinition getPrimaryKeyColumn() {
        for (ColumnDefinition column : this.getColumns()) {
            if (this.getDatabase().getRelations().getPrimaryKey(column) == null) continue;
            return column;
        }
        return null;
    }

    @Override
    public ColumnDefinition getLiteralColumn() {
        String columnName = this.getDatabase().getProperty("generator.generate.master-data-table-literal." + this.getName());
        return this.getColumn(columnName);
    }

    @Override
    public ColumnDefinition getDescriptionColumn() {
        String columnName = this.getDatabase().getProperty("generator.generate.master-data-table-description." + this.getName());
        return this.getColumn(columnName);
    }

    @Override
    public List<Record> getData() {
        if (this.data == null) {
            this.data = new ArrayList<Record>();
            try {
                this.data = this.create().select(new Field[0]).from(new TableLike[]{this.delegate.getTable()}).orderBy(new Field[]{this.create().plainSQLField(this.getPrimaryKeyColumn().getName())}).fetch().getRecords();
            }
            catch (SQLException e) {
                log.error((Object)"Error while initialising master data", (Throwable)e);
            }
        }
        return this.data;
    }

    @Override
    public UniqueKeyDefinition getMainUniqueKey() {
        return this.delegate.getMainUniqueKey();
    }

    @Override
    public List<ColumnDefinition> getColumns() {
        return this.delegate.getColumns();
    }

    @Override
    public ColumnDefinition getColumn(String columnName) {
        return this.delegate.getColumn(columnName);
    }

    @Override
    public ColumnDefinition getColumn(int columnIndex) {
        return this.delegate.getColumn(columnIndex);
    }

    @Override
    public Table<Record> getTable() {
        return this.delegate.getTable();
    }
}

