/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import org.jooq.SQLDialect;
import org.jooq.impl.FieldTypeHelper;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.Database;
import org.jooq.util.oracle.OracleDataType;

public class DefaultDataTypeDefinition
implements DataTypeDefinition {
    private final Database database;
    private final String typeName;
    private final String udtName;
    private final int precision;
    private final int scale;

    public DefaultDataTypeDefinition(Database database, String typeName) {
        this(database, typeName, typeName, 0, 0);
    }

    public DefaultDataTypeDefinition(Database database, String typeName, String udtName) {
        this(database, typeName, udtName, 0, 0);
    }

    public DefaultDataTypeDefinition(Database database, String typeName, int precision, int scale) {
        this(database, typeName, typeName, precision, scale);
    }

    private DefaultDataTypeDefinition(Database database, String typeName, String udtName, int precision, int scale) {
        this.database = database;
        this.typeName = typeName;
        this.udtName = udtName;
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public final Database getDatabase() {
        return this.database;
    }

    private final SQLDialect getDialect() {
        return this.getDatabase().getDialect();
    }

    @Override
    public final boolean isUDT() {
        return this.getDatabase().getUDT(this.udtName) != null;
    }

    @Override
    public final String getType() {
        return this.typeName;
    }

    @Override
    public final int getPrecision() {
        return this.precision;
    }

    @Override
    public final int getScale() {
        return this.scale;
    }

    @Override
    public final String getUserType() {
        return this.udtName;
    }

    @Override
    public final boolean isGenericNumberType() {
        switch (this.getDialect()) {
            case ORACLE: {
                return OracleDataType.NUMBER.getTypeName().equalsIgnoreCase(this.typeName) && this.precision == 0 && this.scale == 0;
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        result = 31 * result + (this.udtName == null ? 0 : this.udtName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultDataTypeDefinition) {
            DefaultDataTypeDefinition other = (DefaultDataTypeDefinition)obj;
            if (FieldTypeHelper.normalise((String)this.typeName).equals(FieldTypeHelper.normalise((String)other.typeName)) && FieldTypeHelper.normalise((String)this.udtName).equals(FieldTypeHelper.normalise((String)other.udtName))) {
                return true;
            }
        }
        return false;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DataType [ t=");
        sb.append(this.typeName);
        sb.append("; p=");
        sb.append(this.precision);
        sb.append("; s=");
        sb.append(this.scale);
        sb.append("; u=");
        sb.append(this.udtName);
        sb.append(" ]");
        return sb.toString();
    }
}

