/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.util.List;
import org.jooq.impl.JooqLogger;
import org.jooq.impl.StringUtils;
import org.jooq.util.AbstractDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.Database;
import org.jooq.util.ForeignKeyDefinition;
import org.jooq.util.MasterDataTableDefinition;
import org.jooq.util.MasterDataTypeDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UniqueKeyDefinition;

public class DefaultColumnDefinition
extends AbstractDefinition
implements ColumnDefinition {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultColumnDefinition.class);
    private final String table;
    private final int position;
    private final DataTypeDefinition underlying;
    private DataTypeDefinition type;
    private boolean primaryKeyLoaded;
    private UniqueKeyDefinition primaryKey;
    private List<UniqueKeyDefinition> uniqueKeys;
    private boolean foreignKeyLoaded;
    private ForeignKeyDefinition foreignKey;

    public DefaultColumnDefinition(Database database, String table, String name, int position, DataTypeDefinition type, String comment) {
        super(database, DefaultColumnDefinition.protectName(table, name, position), comment);
        this.table = table;
        this.position = position;
        this.underlying = type;
    }

    private static String protectName(String table, String name, int position) {
        if (name == null) {
            log.warn((Object)"Missing name", (Object)("Object " + table + " holds a column without a name at position " + position));
            return "_" + position;
        }
        return name;
    }

    @Override
    public final int getPosition() {
        return this.position;
    }

    @Override
    public final String getTableName() {
        return this.table;
    }

    @Override
    public final DataTypeDefinition getType() {
        if (this.type == null) {
            TableDefinition referencedTable;
            ForeignKeyDefinition fk = this.getDatabase().getRelations().getForeignKey(this);
            if (fk != null && (referencedTable = fk.getReferencedTable()) instanceof MasterDataTableDefinition) {
                this.type = new MasterDataTypeDefinition(referencedTable, this.underlying);
            }
            if (this.type == null) {
                this.type = this.underlying;
            }
        }
        return this.type;
    }

    @Override
    public final String getQualifiedName() {
        if (StringUtils.isBlank((String)this.getSchemaName())) {
            return this.getTableName() + "." + this.getName();
        }
        return this.getSchemaName() + "." + this.getTableName() + "." + this.getName();
    }

    @Override
    public final UniqueKeyDefinition getPrimaryKey() {
        if (!this.primaryKeyLoaded) {
            this.primaryKeyLoaded = true;
            this.primaryKey = this.getDatabase().getRelations().getPrimaryKey(this);
        }
        return this.primaryKey;
    }

    @Override
    public List<UniqueKeyDefinition> getUniqueKeys() {
        if (this.uniqueKeys == null) {
            this.uniqueKeys = this.getDatabase().getRelations().getUniqueKeys(this);
        }
        return this.uniqueKeys;
    }

    @Override
    public final ForeignKeyDefinition getForeignKey() {
        if (!this.foreignKeyLoaded) {
            this.foreignKeyLoaded = true;
            this.foreignKey = this.getDatabase().getRelations().getForeignKey(this);
        }
        return this.foreignKey;
    }
}

