/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.impl.JooqLogger;
import org.jooq.util.AbstractCallableDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.InOutDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ProcedureDefinition;

public abstract class AbstractProcedureDefinition
extends AbstractCallableDefinition
implements ProcedureDefinition {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractProcedureDefinition.class);
    private List<ColumnDefinition> inParameters;
    private List<ColumnDefinition> outParameters;
    private ColumnDefinition returnValue;
    private List<ColumnDefinition> allParameters;

    public AbstractProcedureDefinition(Database database, PackageDefinition pkg, String name, String comment, String overload) {
        super(database, pkg, name, comment, overload);
    }

    private void init() {
        this.inParameters = new ArrayList<ColumnDefinition>();
        this.outParameters = new ArrayList<ColumnDefinition>();
        this.allParameters = new ArrayList<ColumnDefinition>();
        try {
            this.init0();
        }
        catch (SQLException e) {
            log.error((Object)"Error while initialising procedure", (Throwable)e);
        }
    }

    protected abstract void init0() throws SQLException;

    @Override
    public final List<ColumnDefinition> getInParameters() {
        if (this.inParameters == null) {
            this.init();
        }
        return this.inParameters;
    }

    @Override
    public final List<ColumnDefinition> getOutParameters() {
        if (this.outParameters == null) {
            this.init();
        }
        return this.outParameters;
    }

    @Override
    public final List<ColumnDefinition> getAllParameters() {
        if (this.allParameters == null) {
            this.init();
        }
        return this.allParameters;
    }

    @Override
    public final ColumnDefinition getReturnValue() {
        if (this.allParameters == null) {
            this.init();
        }
        return this.returnValue;
    }

    protected final void addParameter(InOutDefinition inOut, ColumnDefinition column) {
        this.allParameters.add(column);
        switch (inOut) {
            case IN: {
                this.inParameters.add(column);
                break;
            }
            case OUT: {
                this.outParameters.add(column);
                break;
            }
            case INOUT: {
                this.inParameters.add(column);
                this.outParameters.add(column);
                break;
            }
            case RETURN: {
                this.returnValue = column;
            }
        }
    }
}

