/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.sql.Connection;
import org.jooq.SQLDialect;
import org.jooq.impl.Factory;
import org.jooq.util.Database;
import org.jooq.util.Definition;

public abstract class AbstractDefinition
implements Definition {
    private final Database database;
    private final String name;
    private final String comment;
    private final String overload;

    public AbstractDefinition(Database database, String name, String comment) {
        this(database, name, comment, null);
    }

    public AbstractDefinition(Database database, String name, String comment, String overload) {
        this.database = database;
        this.name = name;
        this.comment = comment;
        this.overload = overload;
    }

    @Override
    public final String getOverload() {
        return this.overload;
    }

    @Override
    public final String getSchemaName() {
        return this.database.getSchemaName();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getNameUC() {
        return this.name.toUpperCase();
    }

    @Override
    public final String getNameLC() {
        return this.name.toLowerCase();
    }

    @Override
    public final String getComment() {
        return this.comment;
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    public final Database getDatabase() {
        return this.database;
    }

    protected final Connection getConnection() {
        return this.database.getConnection();
    }

    public final String toString() {
        return this.getQualifiedName();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof Definition) {
            Definition that = (Definition)obj;
            return that.getQualifiedName().equals(this.getQualifiedName());
        }
        return false;
    }

    public final int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    protected final Factory create() {
        return this.database.create();
    }

    protected final SQLDialect getDialect() {
        return this.create().getDialect();
    }
}

