/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.h2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectLimitStep;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.impl.Factory;
import org.jooq.impl.JooqLogger;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.FunctionDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ProcedureDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.h2.H2FunctionDefinition;
import org.jooq.util.h2.H2ProcedureDefinition;
import org.jooq.util.h2.H2TableDefinition;
import org.jooq.util.h2.information_schema.InformationSchemaFactory;
import org.jooq.util.h2.information_schema.tables.Constraints;
import org.jooq.util.h2.information_schema.tables.CrossReferences;
import org.jooq.util.h2.information_schema.tables.FunctionAliases;
import org.jooq.util.h2.information_schema.tables.Sequences;
import org.jooq.util.h2.information_schema.tables.Tables;
import org.jooq.util.h2.information_schema.tables.TypeInfo;

public class H2Database
extends AbstractDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(H2Database.class);

    @Override
    public Factory create() {
        return new InformationSchemaFactory(this.getConnection());
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("PRIMARY KEY")) {
            String[] columnNames;
            String tableName = (String)record.getValue(Constraints.TABLE_NAME);
            String columnList = (String)record.getValue(Constraints.COLUMN_LIST);
            String primaryKey = "KEY_" + tableName;
            TableDefinition table = this.getTable(tableName);
            if (table == null) continue;
            for (String columnName : columnNames = columnList.split("[,]+")) {
                relations.addPrimaryKey(primaryKey, table.getColumn(columnName));
            }
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("UNIQUE")) {
            String[] columnNames;
            String tableName = (String)record.getValue(Constraints.TABLE_NAME);
            String columnList = (String)record.getValue(Constraints.COLUMN_LIST);
            String primaryKey = "KEY_" + tableName;
            TableDefinition table = this.getTable(tableName);
            if (table == null) continue;
            for (String columnName : columnNames = columnList.split("[,]+")) {
                relations.addUniqueKey(primaryKey, table.getColumn(columnName));
            }
        }
    }

    private List<Record> fetchKeys(String constraintType) throws SQLException {
        return this.create().select(new Field[]{Constraints.TABLE_NAME, Constraints.COLUMN_LIST}).from(new TableLike[]{Constraints.CONSTRAINTS}).where(new Condition[]{Constraints.TABLE_SCHEMA.equal((Object)this.getSchemaName())}).and(Constraints.CONSTRAINT_TYPE.equal((Object)constraintType)).fetch().getRecords();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.create().select(new Field[]{CrossReferences.PKTABLE_NAME, CrossReferences.FK_NAME, CrossReferences.FKTABLE_NAME, CrossReferences.FKCOLUMN_NAME}).from(new TableLike[]{CrossReferences.CROSS_REFERENCES}).where(new Condition[]{CrossReferences.FKTABLE_SCHEMA.equal((Object)this.getSchemaName())}).orderBy(new SortField[]{CrossReferences.FK_NAME.ascending(), CrossReferences.ORDINAL_POSITION.ascending()}).fetch()) {
            String foreignKeyTableName = (String)record.getValue(CrossReferences.FKTABLE_NAME);
            String foreignKeyColumn = (String)record.getValue(CrossReferences.FKCOLUMN_NAME);
            String foreignKey = (String)record.getValue(CrossReferences.FK_NAME);
            String uniqueKeyTableName = (String)record.getValue(CrossReferences.PKTABLE_NAME);
            String uniqueKey = "KEY_" + uniqueKeyTableName;
            TableDefinition foreignKeyTable = this.getTable(foreignKeyTableName);
            if (foreignKeyTable == null) continue;
            ColumnDefinition referencingColumn = foreignKeyTable.getColumn(foreignKeyColumn);
            relations.addForeignKey(foreignKey, uniqueKey, referencingColumn);
        }
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (String name : this.create().select(new Field[]{Sequences.SEQUENCE_NAME}).from(new TableLike[]{Sequences.SEQUENCES}).where(new Condition[]{Sequences.SEQUENCE_SCHEMA.equal((Object)this.getSchemaName())}).orderBy(new Field[]{Sequences.SEQUENCE_NAME}).fetch(Sequences.SEQUENCE_NAME)) {
            result.add(new DefaultSequenceDefinition(this, name));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(new Field[]{Tables.TABLE_NAME, Tables.REMARKS}).from(new TableLike[]{Tables.TABLES}).where(new Condition[]{Tables.TABLE_SCHEMA.equal((Object)this.getSchemaName())}).orderBy(new Field[]{Tables.ID}).fetch()) {
            String name = (String)record.getValue(Tables.TABLE_NAME);
            String comment = (String)record.getValue(Tables.REMARKS);
            H2TableDefinition table = new H2TableDefinition(this, name, comment);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<ProcedureDefinition> getProcedures0() throws SQLException {
        ArrayList<ProcedureDefinition> result = new ArrayList<ProcedureDefinition>();
        SelectLimitStep query = this.create().select(new Field[]{FunctionAliases.ALIAS_NAME, FunctionAliases.REMARKS, FunctionAliases.DATA_TYPE, FunctionAliases.RETURNS_RESULT}).from(new TableLike[]{FunctionAliases.FUNCTION_ALIASES}).where(new Condition[]{FunctionAliases.ALIAS_SCHEMA.equal((Object)this.getSchemaName())}).and(FunctionAliases.RETURNS_RESULT.equal((Object)1)).orderBy(new Field[]{FunctionAliases.ALIAS_NAME});
        for (Record record : query.fetch()) {
            String name = (String)record.getValue(FunctionAliases.ALIAS_NAME);
            String comment = (String)record.getValue(FunctionAliases.REMARKS);
            result.add(new H2ProcedureDefinition(this, name, comment));
        }
        return result;
    }

    @Override
    protected List<FunctionDefinition> getFunctions0() throws SQLException {
        ArrayList<FunctionDefinition> result = new ArrayList<FunctionDefinition>();
        SelectLimitStep query = this.create().select(new Field[]{FunctionAliases.ALIAS_NAME, FunctionAliases.REMARKS, FunctionAliases.DATA_TYPE, FunctionAliases.RETURNS_RESULT, TypeInfo.TYPE_NAME}).from(new TableLike[]{FunctionAliases.FUNCTION_ALIASES}).join((TableLike)TypeInfo.TYPE_INFO).on(new Condition[]{FunctionAliases.DATA_TYPE.equal(TypeInfo.DATA_TYPE)}).where(new Condition[]{FunctionAliases.ALIAS_SCHEMA.equal((Object)this.getSchemaName())}).and(FunctionAliases.RETURNS_RESULT.equal((Object)2)).orderBy(new Field[]{FunctionAliases.ALIAS_NAME});
        for (Record record : query.fetch()) {
            String name = (String)record.getValue(FunctionAliases.ALIAS_NAME);
            String comment = (String)record.getValue(FunctionAliases.REMARKS);
            int dataType = (Integer)record.getValue(FunctionAliases.DATA_TYPE);
            String typeName = (String)record.getValue(TypeInfo.TYPE_NAME);
            if (dataType == 0) {
                log.warn((Object)"Unsupported data type", (Object)("Function return type for alias, name : " + name));
                continue;
            }
            H2FunctionDefinition function = new H2FunctionDefinition(this, name, comment, typeName);
            result.add(function);
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }
}

