/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.db2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectQuery;
import org.jooq.TableLike;
import org.jooq.util.AbstractTableDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultColumnDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.db2.syscat.tables.Columns;

public class DB2TableDefinition
extends AbstractTableDefinition {
    public DB2TableDefinition(Database database, String name, String comment) {
        super(database, name, comment);
    }

    @Override
    public List<ColumnDefinition> getColumns0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        SelectQuery q = this.create().selectQuery();
        q.addFrom(new TableLike[]{Columns.COLUMNS});
        q.addSelect(new Field[]{Columns.COLNAME});
        q.addSelect(new Field[]{Columns.COLNO});
        q.addSelect(new Field[]{Columns.TYPENAME});
        q.addConditions(new Condition[]{Columns.TABSCHEMA.equal((Object)this.getSchemaName())});
        q.addConditions(new Condition[]{Columns.TABNAME.equal((Object)this.getName())});
        q.addOrderBy(new Field[]{Columns.COLNO});
        q.execute();
        for (Record record : q.getResult()) {
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), (String)record.getValue(Columns.TYPENAME));
            DefaultColumnDefinition column = new DefaultColumnDefinition(this.getDatabase(), this.getName(), (String)record.getValue(Columns.COLNAME), ((Short)record.getValue(Columns.COLNO)).shortValue(), type, null);
            result.add(column);
        }
        return result;
    }
}

