/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.jooq.impl.JooqLogger;
import org.jooq.impl.StringUtils;
import org.jooq.util.Database;
import org.jooq.util.DefaultGenerator;
import org.jooq.util.DefaultGeneratorStrategy;
import org.jooq.util.Generator;
import org.jooq.util.GeneratorStrategy;

public class GenerationTool {
    private static final JooqLogger log = JooqLogger.getLogger(GenerationTool.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        InputStream in;
        if (args.length != 1) {
            GenerationTool.error();
        }
        if ((in = GenerationTool.class.getResourceAsStream(args[0])) == null) {
            log.error((Object)("Cannot find " + args[0]));
            log.error((Object)"-----------");
            log.error((Object)"Please be sure it is located on the classpath and qualified as a classpath location.");
            log.error((Object)"If it is located at the current working directory, try adding a '/' to the path");
            GenerationTool.error();
        }
        log.info((Object)"Initialising properties", (Object)args[0]);
        Properties properties = new Properties();
        try {
            properties.load(in);
        }
        catch (Exception e) {
            log.error((Object)("Cannot read " + args[0] + ". Error : " + e.getMessage()));
            GenerationTool.error();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        GenerationTool.main(properties);
    }

    public static void main(Properties properties) throws Exception {
        Class.forName(properties.getProperty("jdbc.Driver"));
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(properties.getProperty("jdbc.URL"), properties.getProperty("jdbc.User"), properties.getProperty("jdbc.Password"));
            Class<DefaultGenerator> generatorClass = properties.containsKey("generator") ? Class.forName(properties.getProperty("generator")) : DefaultGenerator.class;
            Generator generator = (Generator)generatorClass.newInstance();
            Class<DefaultGeneratorStrategy> strategyClass = properties.containsKey("generator.strategy") ? Class.forName(properties.getProperty("generator.strategy")) : DefaultGeneratorStrategy.class;
            generator.setStrategy((GeneratorStrategy)strategyClass.newInstance());
            Class<?> databaseClass = Class.forName(properties.getProperty("generator.database"));
            Database database = (Database)databaseClass.newInstance();
            database.setConnection(connection);
            database.setSchemaName(properties.getProperty("jdbc.Schema"));
            database.setIncludes(StringUtils.defaultString((String)properties.getProperty("generator.database.includes")).split(","));
            database.setExcludes(StringUtils.defaultString((String)properties.getProperty("generator.database.excludes")).split(","));
            database.setMasterDataTableNames(StringUtils.defaultString((String)properties.getProperty("generator.generate.master-data-tables")).split(","));
            database.setProperties(properties);
            generator.setTargetPackage(properties.getProperty("generator.target.package"));
            generator.setTargetDirectory(properties.getProperty("generator.target.directory"));
            generator.setGenerateRelations("true".equalsIgnoreCase(properties.getProperty("generator.generate.relations")));
            generator.setGenerateDeprecated(!"false".equalsIgnoreCase(properties.getProperty("generator.generate.deprecated")));
            generator.generate(database);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private static void error() {
        log.error((Object)"Usage : GenerationTool <configuration-file>");
        System.exit(-1);
    }
}

