/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.ssl;

import com.typesafe.config.Config;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.net.ssl.SSLContext;
import org.jooby.funzy.Try;
import org.jooby.internal.ssl.SslContext;

public class SslContextProvider
implements Provider<SSLContext> {
    private Config conf;

    @Inject
    public SslContextProvider(Config conf) {
        this.conf = Objects.requireNonNull(conf, "SSL config is required.");
    }

    public SSLContext get() {
        return (SSLContext)Try.apply(() -> {
            String tmpdir = this.conf.getString("application.tmpdir");
            File keyStoreCert = this.toFile(this.conf.getString("ssl.keystore.cert"), tmpdir);
            File keyStoreKey = this.toFile(this.conf.getString("ssl.keystore.key"), tmpdir);
            String keyStorePass = this.conf.hasPath("ssl.keystore.password") ? this.conf.getString("ssl.keystore.password") : null;
            File trustCert = this.conf.hasPath("ssl.trust.cert") ? this.toFile(this.conf.getString("ssl.trust.cert"), tmpdir) : null;
            return SslContext.newServerContextInternal(trustCert, keyStoreCert, keyStoreKey, keyStorePass, this.conf.getLong("ssl.session.cacheSize"), this.conf.getLong("ssl.session.timeout")).context();
        }).get();
    }

    private File toFile(String path, String tmpdir) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            return file;
        }
        file = new File(tmpdir, Paths.get(path, new String[0]).getFileName().toString());
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(path);){
            if (in == null) {
                throw new FileNotFoundException(path);
            }
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        file.deleteOnExit();
        return file;
    }
}

