/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.ssl;

import com.google.common.io.BaseEncoding;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PemReader {
    private static final Pattern CERT_PATTERN = Pattern.compile("-+BEGIN\\s+.*CERTIFICATE[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*CERTIFICATE[^-]*-+", 2);
    private static final Pattern KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*PRIVATE\\s+KEY[^-]*-+", 2);

    static List<ByteBuffer> readCertificates(File file) throws CertificateException, IOException {
        String content = Files.toString((File)file, (Charset)StandardCharsets.US_ASCII);
        BaseEncoding base64 = PemReader.base64();
        ArrayList<ByteBuffer> certs = new ArrayList<ByteBuffer>();
        Matcher m = CERT_PATTERN.matcher(content);
        int start = 0;
        while (m.find(start)) {
            ByteBuffer buffer = ByteBuffer.wrap(base64.decode((CharSequence)m.group(1)));
            certs.add(buffer);
            start = m.end();
        }
        if (certs.isEmpty()) {
            throw new CertificateException("found no certificates: " + file);
        }
        return certs;
    }

    private static BaseEncoding base64() {
        return BaseEncoding.base64().withSeparator("\n", 10);
    }

    static ByteBuffer readPrivateKey(File file) throws KeyException, IOException {
        String content = Files.toString((File)file, (Charset)StandardCharsets.US_ASCII);
        Matcher m = KEY_PATTERN.matcher(content);
        if (!m.find()) {
            throw new KeyException("found no private key: " + file);
        }
        String value = m.group(1);
        return ByteBuffer.wrap(PemReader.base64().decode((CharSequence)value));
    }

    private PemReader() {
    }
}

