/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.parser.bean;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.jooby.Request;
import org.jooby.funzy.Throwing;
import org.jooby.internal.ParameterNameProvider;
import org.jooby.internal.mvc.RequestParam;
import org.jooby.internal.mvc.RequestParamNameProviderImpl;
import org.jooby.internal.mvc.RequestParamProviderImpl;
import org.jooby.internal.parser.bean.BeanComplexPath;
import org.jooby.internal.parser.bean.BeanFieldPath;
import org.jooby.internal.parser.bean.BeanIndexedPath;
import org.jooby.internal.parser.bean.BeanMethodPath;
import org.jooby.internal.parser.bean.BeanPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanPlan {
    private final Logger log = LoggerFactory.getLogger(Request.class);
    private Constructor<?> constructor;
    private List<RequestParam> parameters;
    private TypeLiteral beanType;
    private Map<Object, BeanPath> cache = new ConcurrentHashMap<Object, BeanPath>();

    public BeanPlan(ParameterNameProvider classInfo, Class beanType) {
        this(classInfo, TypeLiteral.get((Class)beanType));
    }

    public BeanPlan(ParameterNameProvider classInfo, TypeLiteral beanType) {
        Constructor<?> constructor;
        Constructor<?>[] cons;
        Constructor<?> inject = null;
        Constructor<?> def = null;
        Class<ArrayList> rawType = beanType.getRawType();
        if (rawType == List.class) {
            rawType = ArrayList.class;
        }
        if ((cons = rawType.getDeclaredConstructors()).length == 1) {
            def = cons[0];
        } else {
            for (Constructor<?> c : cons) {
                if (c.isAnnotationPresent(Inject.class)) {
                    if (inject != null) {
                        throw new IllegalStateException("Ambigous constructor found: " + rawType.getName() + ". Only one @" + Inject.class.getName() + " allowed");
                    }
                    inject = c;
                    continue;
                }
                if (c.getParameterCount() != 0) continue;
                def = c;
            }
        }
        Constructor<?> constructor2 = constructor = inject == null ? def : inject;
        if (constructor == null) {
            throw new IllegalStateException("Ambigous constructor found: " + rawType.getName() + ". Bean/Form type must have a no-args constructor or must be annotated with @" + Inject.class.getName());
        }
        this.beanType = beanType;
        this.constructor = constructor;
        this.parameters = new RequestParamProviderImpl(new RequestParamNameProviderImpl(classInfo)).parameters(constructor);
    }

    public Object newBean(Throwing.Function<RequestParam, Object> lookup, Set<String> params) throws Throwable {
        this.log.debug("instantiating object {}", this.constructor);
        Object[] args = new Object[this.parameters.size()];
        ArrayList<String> names = new ArrayList<String>(params);
        for (int i = 0; i < args.length; ++i) {
            RequestParam param = this.parameters.get(i);
            args[i] = lookup.apply((Object)param);
            names.remove(param.name);
        }
        Object bean = this.constructor.newInstance(args);
        List<BeanPath> paths = this.compile(names.stream().sorted().iterator(), this.beanType);
        for (BeanPath path : paths) {
            String rawpath = path.toString();
            this.log.debug("  setting {}", (Object)rawpath);
            path.set(bean, lookup.apply((Object)new RequestParam(path.setelem(), rawpath, path.settype())));
        }
        return bean;
    }

    private List<BeanPath> compile(Iterator<String> it, TypeLiteral beanType) {
        ArrayList<BeanPath> result = new ArrayList<BeanPath>();
        while (it.hasNext()) {
            String path = it.next();
            List<Object> ckey = Arrays.asList(beanType, path);
            BeanPath cached = this.cache.get(ckey);
            if (cached == null) {
                List<Object[]> segments = this.segments(path);
                ArrayList<BeanPath> chain = new ArrayList<BeanPath>();
                TypeLiteral ittype = beanType;
                for (int i = 0; i < segments.size() - 1; ++i) {
                    BeanPath getter;
                    BeanPath cpath;
                    Object[] segment = segments.get(i);
                    if (segment[1] != null) {
                        if (segment[0] == null) {
                            cpath = new BeanIndexedPath(null, (int)((Integer)segment[1]), ittype);
                        } else {
                            getter = this.member("get", (String)segment[0], ittype, 0);
                            if (getter instanceof BeanMethodPath) {
                                ((BeanMethodPath)getter).setter = this.member("set", (String)segment[0], ittype, 1);
                            }
                            cpath = new BeanIndexedPath(getter, (int)((Integer)segment[1]), ittype);
                        }
                    } else {
                        getter = this.member("get", (String)segment[0], ittype, 0);
                        if (getter instanceof BeanMethodPath) {
                            ((BeanMethodPath)getter).setter = this.member("set", (String)segment[0], ittype, 1);
                        }
                        cpath = getter;
                    }
                    if (cpath == null) continue;
                    chain.add(cpath);
                    ittype = TypeLiteral.get((Type)cpath.type());
                }
                Object[] last = segments.get(segments.size() - 1);
                BeanPath cpath = this.member("set", (String)last[0], ittype, 1);
                if (cpath != null) {
                    if (last[1] != null) {
                        BeanPath getter = this.member("get", (String)last[0], ittype, 0);
                        if (getter instanceof BeanMethodPath) {
                            ((BeanMethodPath)getter).setter = cpath;
                        }
                        cpath = new BeanIndexedPath(getter, (int)((Integer)last[1]), ittype);
                    }
                    cached = chain.size() == 0 ? cpath : new BeanComplexPath(chain, cpath, path);
                    this.cache.put(ckey, cached);
                }
            }
            if (cached == null) continue;
            result.add(cached);
        }
        return result;
    }

    private List<Object[]> segments(String path) {
        List segments = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"[].")).trimResults().omitEmptyStrings().splitToList((CharSequence)path);
        ArrayList<Object[]> result = new ArrayList<Object[]>(segments.size());
        for (int i = 0; i < segments.size(); ++i) {
            String segment = (String)segments.get(i);
            try {
                int idx = Integer.parseInt(segment);
                if (result.size() > 0) {
                    result.set(result.size() - 1, new Object[]{((Object[])result.get(result.size() - 1))[0], idx});
                    continue;
                }
                result.add(new Object[]{null, idx});
                continue;
            }
            catch (NumberFormatException x) {
                result.add(new Object[]{segment, null});
            }
        }
        return result;
    }

    private BeanPath member(String prefix, String name, TypeLiteral root, int pcount) {
        Class superclass;
        Class rawType = root.getRawType();
        BeanPath fn = this.method(prefix, name, rawType.getDeclaredMethods(), pcount);
        if (fn == null && (fn = this.field(name, rawType.getDeclaredFields())) == null && (superclass = rawType.getSuperclass()) != Object.class) {
            return this.member(prefix, name, TypeLiteral.get((Type)rawType.getGenericSuperclass()), pcount);
        }
        return fn;
    }

    private BeanFieldPath field(String name, Field[] fields) {
        for (Field f : fields) {
            if (!f.getName().equals(name)) continue;
            return new BeanFieldPath(name, f);
        }
        return null;
    }

    private BeanMethodPath method(String prefix, String name, Method[] methods, int pcount) {
        String bname = this.javaBeanMethod(new StringBuilder(prefix), name);
        for (Method m : methods) {
            String mname = m.getName();
            if (!bname.equals(mname) && !name.equals(mname) || m.getParameterCount() != pcount) continue;
            return new BeanMethodPath(name, m);
        }
        return null;
    }

    private String javaBeanMethod(StringBuilder prefix, String name) {
        return prefix.append(Character.toUpperCase(name.charAt(0))).append(name, 1, name.length()).toString();
    }
}

