/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.parser;

import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jooby.MediaType;
import org.jooby.Mutant;
import org.jooby.Parser;
import org.jooby.Status;
import org.jooby.internal.StatusCodeProvider;
import org.jooby.internal.StrParamReferenceImpl;
import org.jooby.internal.parser.ParserBuilder;

public class ParserExecutor {
    public static final Object NO_PARSER = new Object();
    private List<Parser> parsers;
    private Injector injector;
    private StatusCodeProvider sc;

    @Inject
    public ParserExecutor(Injector injector, Set<Parser> parsers, StatusCodeProvider sc) {
        this.injector = injector;
        this.parsers = ImmutableList.copyOf(parsers);
        this.sc = sc;
    }

    public Status statusCode(Throwable cause) {
        return this.sc.apply(cause);
    }

    public <T> T convert(TypeLiteral<?> type, Object data) throws Throwable {
        return this.convert(type, MediaType.plain, data);
    }

    public <T> T convert(TypeLiteral<?> type, MediaType contentType, Object data) throws Throwable {
        Object result = ParserExecutor.ctx(this.injector, contentType, type, this.parsers, data).next(type, data);
        return (T)result;
    }

    private static Parser.Context ctx(final Injector injector, final MediaType contentType, final TypeLiteral<?> seedType, final List<Parser> parsers, final Object seed) {
        return new Parser.Context(){
            int cursor = 0;
            TypeLiteral<?> type = seedType;
            ParserBuilder builder = new ParserBuilder(this, this.type, seed);

            @Override
            public MediaType type() {
                return contentType;
            }

            @Override
            public Parser.Builder body(Parser.Callback<Parser.BodyReference> callback) {
                return this.builder.body(callback);
            }

            @Override
            public Parser.Builder ifbody(Parser.Callback<Parser.BodyReference> callback) {
                return this.builder.ifbody(callback);
            }

            @Override
            public Parser.Builder param(Parser.Callback<Parser.ParamReference<String>> callback) {
                return this.builder.param(callback);
            }

            @Override
            public Parser.Builder ifparam(Parser.Callback<Parser.ParamReference<String>> callback) {
                return this.builder.ifparam(callback);
            }

            @Override
            public Parser.Builder params(Parser.Callback<Map<String, Mutant>> callback) {
                return this.builder.params(callback);
            }

            @Override
            public Parser.Builder ifparams(Parser.Callback<Map<String, Mutant>> callback) {
                return this.builder.ifparams(callback);
            }

            @Override
            public Object next() throws Throwable {
                return this.next(this.builder.toType, this.builder.value);
            }

            @Override
            public Object next(TypeLiteral<?> type) throws Throwable {
                return this.next(type, this.builder.value);
            }

            @Override
            public Object next(TypeLiteral<?> nexttype, Object nextval) throws Throwable {
                if (this.cursor == parsers.size()) {
                    return NO_PARSER;
                }
                if (!this.type.equals(nexttype)) {
                    this.cursor = 0;
                    this.type = nexttype;
                }
                Parser next = (Parser)parsers.get(this.cursor);
                ++this.cursor;
                ParserBuilder current = this.builder;
                this.builder = new ParserBuilder(this, nexttype, this.wrap(nextval, this.builder.value));
                Object result = next.parse(nexttype, this);
                if (result instanceof ParserBuilder) {
                    result = ((ParserBuilder)result).parse();
                }
                this.builder = current;
                --this.cursor;
                return result;
            }

            private Object wrap(Object nextval, Object value) {
                if (nextval instanceof String) {
                    Parser.ParamReference pref = (Parser.ParamReference)value;
                    return new StrParamReferenceImpl(pref.type(), pref.name(), (List<String>)ImmutableList.of((Object)((String)nextval)));
                }
                return nextval;
            }

            @Override
            public <T> T require(Key<T> key) {
                return (T)injector.getInstance(key);
            }

            @Override
            public <T> T require(Class<T> type) {
                return (T)injector.getInstance(type);
            }

            @Override
            public <T> T require(TypeLiteral<T> type) {
                return (T)injector.getInstance(Key.get(type));
            }

            public String toString() {
                return parsers.toString();
            }
        };
    }
}

