/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.parser;

import com.google.common.collect.ImmutableMap;
import com.google.inject.TypeLiteral;
import java.util.Map;
import org.jooby.Mutant;
import org.jooby.Parser;
import org.jooby.internal.BodyReferenceImpl;
import org.jooby.internal.EmptyBodyReference;
import org.jooby.internal.StrParamReferenceImpl;

public class ParserBuilder
implements Parser.Builder {
    private ImmutableMap.Builder<TypeLiteral<?>, Parser.Callback> strategies = ImmutableMap.builder();
    public final TypeLiteral<?> toType;
    private final TypeLiteral<?> type;
    public final Object value;
    private Parser.Context ctx;

    public ParserBuilder(Parser.Context ctx, TypeLiteral<?> toType, Object value) {
        this.ctx = ctx;
        this.toType = toType;
        this.type = this.typeOf(value);
        this.value = value;
    }

    private TypeLiteral<?> typeOf(Object value) {
        if (value instanceof Map) {
            return TypeLiteral.get(Map.class);
        }
        return TypeLiteral.get(value.getClass());
    }

    @Override
    public Parser.Builder body(Parser.Callback<Parser.BodyReference> callback) {
        this.strategies.put((Object)TypeLiteral.get(BodyReferenceImpl.class), callback);
        this.strategies.put((Object)TypeLiteral.get(EmptyBodyReference.class), callback);
        return this;
    }

    @Override
    public Parser.Builder ifbody(Parser.Callback<Parser.BodyReference> callback) {
        return this.body(callback);
    }

    @Override
    public Parser.Builder param(Parser.Callback<Parser.ParamReference<String>> callback) {
        this.strategies.put((Object)TypeLiteral.get(StrParamReferenceImpl.class), callback);
        return this;
    }

    @Override
    public Parser.Builder ifparam(Parser.Callback<Parser.ParamReference<String>> callback) {
        return this.param(callback);
    }

    @Override
    public Parser.Builder params(Parser.Callback<Map<String, Mutant>> callback) {
        this.strategies.put((Object)TypeLiteral.get(Map.class), callback);
        return this;
    }

    @Override
    public Parser.Builder ifparams(Parser.Callback<Map<String, Mutant>> callback) {
        return this.params(callback);
    }

    public Object parse() throws Throwable {
        ImmutableMap map = this.strategies.build();
        Parser.Callback callback = (Parser.Callback)map.get(this.type);
        if (callback == null) {
            return this.ctx.next(this.toType, this.value);
        }
        return callback.invoke(this.value);
    }
}

