/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.mvc;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jooby.internal.mvc.RequestParam;
import org.jooby.internal.mvc.RequestParamNameProviderImpl;
import org.jooby.internal.mvc.RequestParamProvider;

public class RequestParamProviderImpl
implements RequestParamProvider {
    private RequestParamNameProviderImpl provider;

    public RequestParamProviderImpl(RequestParamNameProviderImpl provider) {
        this.provider = Objects.requireNonNull(provider, "Parameter name provider is required.");
    }

    @Override
    public List<RequestParam> parameters(Executable exec) {
        Parameter[] parameters = exec.getParameters();
        if (parameters.length == 0) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter parameter : parameters) {
            builder.add((Object)new RequestParam(parameter, this.provider.name(parameter)));
        }
        return builder.build();
    }
}

