/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.mvc;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Predicate;
import org.jooby.Mutant;
import org.jooby.Request;
import org.jooby.WebSocket;

public class MvcWebSocket
implements WebSocket.Handler<Mutant> {
    private Object handler;
    private TypeLiteral messageType;

    MvcWebSocket(WebSocket ws, Class handler) {
        Injector injector = ws.require(Injector.class).createChildInjector(new Module[]{binder -> binder.bind(WebSocket.class).toInstance((Object)ws)});
        this.handler = injector.getInstance(handler);
        this.messageType = TypeLiteral.get((Type)MvcWebSocket.messageType(handler));
    }

    public static WebSocket.OnOpen newWebSocket(Class handler) {
        return (req, ws) -> {
            MvcWebSocket socket = new MvcWebSocket(ws, handler);
            socket.onOpen(req, ws);
            if (socket.isClose()) {
                ws.onClose(socket::onClose);
            }
            if (socket.isError()) {
                ws.onError(socket::onError);
            }
            ws.onMessage(socket::onMessage);
        };
    }

    @Override
    public void onClose(WebSocket.CloseStatus status) throws Exception {
        if (this.isClose()) {
            ((WebSocket.OnClose)this.handler).onClose(status);
        }
    }

    @Override
    public void onMessage(Mutant data) throws Exception {
        ((WebSocket.OnMessage)this.handler).onMessage(data.to(this.messageType));
    }

    @Override
    public void onError(Throwable err) {
        if (this.isError()) {
            ((WebSocket.OnError)this.handler).onError(err);
        }
    }

    @Override
    public void onOpen(Request req, WebSocket ws) throws Exception {
        if (this.handler instanceof WebSocket.OnOpen) {
            ((WebSocket.OnOpen)this.handler).onOpen(req, ws);
        }
    }

    private boolean isClose() {
        return this.handler instanceof WebSocket.OnClose;
    }

    private boolean isError() {
        return this.handler instanceof WebSocket.OnError;
    }

    static Type messageType(Class handler) {
        return Arrays.asList(handler.getGenericInterfaces()).stream().filter(MvcWebSocket.rawTypeIs(WebSocket.Handler.class).or(MvcWebSocket.rawTypeIs(WebSocket.OnMessage.class))).findFirst().filter(ParameterizedType.class::isInstance).map(it -> ((ParameterizedType)it).getActualTypeArguments()[0]).orElseThrow(() -> new IllegalArgumentException("Can't extract message type from: " + handler.getName()));
    }

    private static Predicate<Type> rawTypeIs(Class<?> type) {
        return it -> TypeLiteral.get((Type)it).getRawType().isAssignableFrom(type);
    }
}

