/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.mvc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Status;
import org.jooby.funzy.Try;
import org.jooby.internal.mvc.RequestParam;
import org.jooby.internal.mvc.RequestParamProvider;

public class MvcHandler
implements Route.MethodHandler {
    private Method handler;
    private Class<?> implementingClass;
    private RequestParamProvider provider;

    public MvcHandler(Method handler, Class<?> implementingClass, RequestParamProvider provider) {
        this.handler = Objects.requireNonNull(handler, "Handler method is required.");
        this.implementingClass = Objects.requireNonNull(implementingClass, "Implementing class is required.");
        this.provider = Objects.requireNonNull(provider, "Param prodiver is required.");
    }

    @Override
    public Method method() {
        return this.handler;
    }

    @Override
    public Class<?> implementingClass() {
        return this.implementingClass;
    }

    @Override
    public void handle(Request req, Response rsp, Route.Chain chain) throws Throwable {
        Object result = this.invoke(req, rsp, chain);
        if (!rsp.committed()) {
            Class<?> returnType = this.handler.getReturnType();
            if (returnType == Void.TYPE) {
                rsp.status(Status.NO_CONTENT);
            } else {
                rsp.status(Status.OK);
                rsp.send(result);
            }
        }
        chain.next(req, rsp);
    }

    @Override
    public void handle(Request req, Response rsp) throws Throwable {
    }

    public Object invoke(Request req, Response rsp, Route.Chain chain) {
        return Try.apply(() -> {
            Object target = req.require(this.implementingClass);
            List<RequestParam> parameters = this.provider.parameters(this.handler);
            Object[] args = new Object[parameters.size()];
            for (int i = 0; i < parameters.size(); ++i) {
                args[i] = parameters.get(i).value(req, rsp, chain);
            }
            Object result = this.handler.invoke(target, args);
            return result;
        }).unwrap(InvocationTargetException.class).get();
    }
}

