/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.handlers;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.jooby.MediaType;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Status;

public class OptionsHandler
implements Route.Handler {
    private static final String SEP = ", ";
    private static final String ALLOW = "Allow";
    private Set<Route.Definition> routes;

    @Inject
    public OptionsHandler(Set<Route.Definition> routes) {
        this.routes = Objects.requireNonNull(routes, "Routes are required.");
    }

    @Override
    public void handle(Request req, Response rsp) throws Exception {
        if (!rsp.header(ALLOW).isSet()) {
            LinkedHashSet allow = new LinkedHashSet();
            LinkedHashSet<String> methods = new LinkedHashSet<String>(Route.METHODS);
            String path = req.path();
            methods.remove(req.method());
            for (String method : methods) {
                this.routes.stream().filter(route -> route.matches(method, path, MediaType.all, MediaType.ALL).isPresent()).forEach(route -> allow.add(route.method()));
            }
            rsp.header(ALLOW, (Object)Joiner.on((String)SEP).join(allow)).length(0L).status(Status.OK);
        }
    }
}

