/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jooby.MediaType;
import org.jooby.Renderer;
import org.jooby.WebSocket;
import org.jooby.internal.AbstractRendererContext;
import org.jooby.spi.NativeWebSocket;

public class WebSocketRendererContext
extends AbstractRendererContext {
    private NativeWebSocket ws;
    private WebSocket.SuccessCallback success;
    private WebSocket.OnError err;
    private MediaType type;

    public WebSocketRendererContext(List<Renderer> renderers, NativeWebSocket ws, MediaType type, Charset charset, Locale locale, WebSocket.SuccessCallback success, WebSocket.OnError err) {
        super(renderers, (List<MediaType>)ImmutableList.of((Object)type), charset, locale, Collections.emptyMap());
        this.ws = ws;
        this.type = type;
        this.success = success;
        this.err = err;
    }

    @Override
    public void send(String text) throws Exception {
        this.ws.sendText(text, this.success, this.err);
        this.setCommitted();
    }

    @Override
    protected void _send(byte[] bytes) throws Exception {
        if (this.type.isText()) {
            this.ws.sendText(bytes, this.success, this.err);
        } else {
            this.ws.sendBytes(bytes, this.success, this.err);
        }
    }

    @Override
    protected void _send(ByteBuffer buffer) throws Exception {
        if (this.type.isText()) {
            this.ws.sendText(buffer, this.success, this.err);
        } else {
            this.ws.sendBytes(buffer, this.success, this.err);
        }
    }

    @Override
    protected void _send(FileChannel file) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void _send(InputStream stream) throws Exception {
        throw new UnsupportedOperationException();
    }
}

