/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.primitives.Primitives;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.spi.TypeConverter;
import java.util.Locale;
import org.jooby.internal.LocaleUtils;
import org.jooby.internal.parser.StringConstructorParser;

class StringConstructTypeConverter<T>
extends AbstractMatcher<TypeLiteral<T>>
implements TypeConverter {
    StringConstructTypeConverter() {
    }

    public Object convert(String value, TypeLiteral<?> type) {
        Class rawType = type.getRawType();
        try {
            if (rawType == Locale.class) {
                return LocaleUtils.parseOne(value);
            }
            return StringConstructorParser.parse(type, value);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Can't convert: " + value + " to " + type, ex);
        }
    }

    public boolean matches(TypeLiteral<T> type) {
        Class rawType = type.getRawType();
        if (Primitives.isWrapperType((Class)rawType)) {
            return false;
        }
        return new StringConstructorParser().matches(type);
    }

    public String toString() {
        return "TypeConverter init(java.lang.String)";
    }
}

