/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.io.ByteSource;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jooby.MediaType;
import org.jooby.Renderer;
import org.jooby.Sse;
import org.jooby.internal.AbstractRendererContext;

public class SseRenderer
extends AbstractRendererContext {
    static final ByteSource ID = SseRenderer.bytes("id:");
    static final ByteSource EVENT = SseRenderer.bytes("event:");
    static final ByteSource RETRY = SseRenderer.bytes("retry:");
    static final ByteSource DATA = SseRenderer.bytes("data:");
    static final ByteSource COMMENT = SseRenderer.bytes(":");
    static final byte nl = 10;
    static final ByteSource NL = SseRenderer.bytes("\n");
    private ByteSource data;

    public SseRenderer(List<Renderer> renderers, List<MediaType> produces, Charset charset, Locale locale, Map<String, Object> locals) {
        super(renderers, produces, charset, locale, locals);
    }

    public byte[] format(Sse.Event event) throws Exception {
        this.data = event.comment().map(comment -> ByteSource.concat((ByteSource[])new ByteSource[]{COMMENT, SseRenderer.bytes(comment), NL})).orElse(ByteSource.empty());
        this.data = event.id().map(id -> ByteSource.concat((ByteSource[])new ByteSource[]{this.data, ID, SseRenderer.bytes(id.toString()), NL})).orElse(this.data);
        this.data = event.name().map(name -> ByteSource.concat((ByteSource[])new ByteSource[]{this.data, EVENT, SseRenderer.bytes(name), NL})).orElse(this.data);
        this.data = event.retry().map(retry -> ByteSource.concat((ByteSource[])new ByteSource[]{this.data, RETRY, SseRenderer.bytes(Long.toString(retry)), NL})).orElse(this.data);
        Optional<Object> value = event.data();
        if (value.isPresent()) {
            this.render(value.get());
        }
        this.data = ByteSource.concat((ByteSource[])new ByteSource[]{this.data, NL});
        byte[] bytes = this.data.read();
        this.data = null;
        return bytes;
    }

    @Override
    protected void _send(byte[] bytes) throws Exception {
        List<Integer[]> lines = SseRenderer.split(bytes);
        if (lines.size() == 1) {
            this.data = ByteSource.concat((ByteSource[])new ByteSource[]{this.data, DATA, ByteSource.wrap((byte[])bytes), NL});
        } else {
            for (Integer[] line : lines) {
                this.data = ByteSource.concat((ByteSource[])new ByteSource[]{this.data, DATA, ByteSource.wrap((byte[])bytes).slice((long)line[0].intValue(), (long)(line[1] - line[0])), NL});
            }
        }
    }

    @Override
    protected void _send(ByteBuffer buffer) throws Exception {
        if (buffer.hasArray()) {
            this._send(buffer.array());
        } else {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            this._send(bytes);
        }
    }

    @Override
    protected void _send(FileChannel file) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void _send(InputStream stream) throws Exception {
        throw new UnsupportedOperationException();
    }

    private static ByteSource bytes(String value) {
        return ByteSource.wrap((byte[])value.getBytes(StandardCharsets.UTF_8));
    }

    private static List<Integer[]> split(byte[] bytes) {
        ArrayList<Integer[]> range = new ArrayList<Integer[]>();
        Function<Integer, Integer> nextLine = start -> {
            for (int i = start.intValue(); i < bytes.length; ++i) {
                if (bytes[i] != 10) continue;
                return i;
            }
            return bytes.length;
        };
        int from = 0;
        int to = nextLine.apply(from);
        int len = bytes.length;
        range.add(new Integer[]{from, to});
        while (to != len) {
            from = to + 1;
            if ((to = nextLine.apply(from).intValue()) <= from) continue;
            range.add(new Integer[]{from, to});
        }
        return range;
    }
}

