/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jooby.Mutant;
import org.jooby.Session;
import org.jooby.internal.MutantImpl;
import org.jooby.internal.StrParamReferenceImpl;
import org.jooby.internal.parser.ParserExecutor;

public class SessionImpl
implements Session {
    private ConcurrentMap<String, String> attributes = new ConcurrentHashMap<String, String>();
    private String sessionId;
    private long createdAt;
    private volatile long accessedAt;
    private volatile long timeout;
    private volatile boolean isNew;
    private volatile boolean dirty;
    private volatile long savedAt;
    private volatile boolean destroyed;
    private ParserExecutor resolver;

    public SessionImpl(ParserExecutor resolver, boolean isNew, String sessionId, long timeout) {
        long now;
        this.resolver = resolver;
        this.isNew = isNew;
        this.sessionId = sessionId;
        this.createdAt = now = "cookieSession".equals(sessionId) ? -1L : System.currentTimeMillis();
        this.accessedAt = now;
        this.savedAt = -1L;
        this.timeout = timeout;
    }

    @Override
    public String id() {
        return this.sessionId;
    }

    @Override
    public long createdAt() {
        return this.createdAt;
    }

    @Override
    public long accessedAt() {
        return this.accessedAt;
    }

    @Override
    public long expiryAt() {
        if (this.timeout <= 0L) {
            return -1L;
        }
        return this.accessedAt + this.timeout;
    }

    @Override
    public Mutant get(String name) {
        String value = (String)this.attributes.get(name);
        ImmutableList values = value == null ? Collections.emptyList() : ImmutableList.of((Object)value);
        return new MutantImpl(this.resolver, new StrParamReferenceImpl("session attribute", name, (List<String>)values));
    }

    @Override
    public boolean isSet(String name) {
        return this.attributes.containsKey(name);
    }

    @Override
    public Map<String, String> attributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public Session set(String name, String value) {
        Objects.requireNonNull(name, "An attribute name is required.");
        Objects.requireNonNull(value, "An attribute value is required.");
        String existing = this.attributes.put(name, value);
        this.dirty = existing == null || !existing.equals(value);
        return this;
    }

    @Override
    public Mutant unset(String name) {
        String value = (String)this.attributes.remove(name);
        ImmutableList values = Collections.emptyList();
        if (value != null) {
            values = ImmutableList.of((Object)value);
            this.dirty = true;
        }
        return new MutantImpl(this.resolver, new StrParamReferenceImpl("session attribute", name, (List<String>)values));
    }

    @Override
    public Session unset() {
        this.attributes.clear();
        this.dirty = true;
        return this;
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        this.unset();
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public long savedAt() {
        return this.savedAt;
    }

    void markAsSaved() {
        this.isNew = false;
        this.dirty = false;
    }

    @Override
    public Session renewId() {
        return this;
    }

    public void renewId(String newId) {
        this.sessionId = newId;
        this.isNew = true;
    }

    public void touch() {
        this.accessedAt = System.currentTimeMillis();
    }

    public String toString() {
        return this.sessionId;
    }

    public void aboutToSave() {
        this.savedAt = System.currentTimeMillis();
    }

    static class Builder
    implements Session.Builder {
        private SessionImpl session;

        public Builder(ParserExecutor resolver, boolean isNew, String sessionId, long timeout) {
            this.session = new SessionImpl(resolver, isNew, sessionId, timeout);
        }

        @Override
        public String sessionId() {
            return this.session.sessionId;
        }

        @Override
        public Session.Builder set(String name, String value) {
            this.session.attributes.put(name, value);
            return this;
        }

        @Override
        public Session.Builder set(Map<String, String> attributes) {
            this.session.attributes.putAll(attributes);
            return this;
        }

        @Override
        public Session.Builder createdAt(long createdAt) {
            this.session.createdAt = createdAt;
            return this;
        }

        @Override
        public Session.Builder accessedAt(long accessedAt) {
            this.session.accessedAt = accessedAt;
            return this;
        }

        @Override
        public Session.Builder savedAt(long savedAt) {
            this.session.savedAt = savedAt;
            return this;
        }

        @Override
        public Session build() {
            Objects.requireNonNull(this.session.sessionId, "Session's id wasn't set.");
            return this.session;
        }
    }
}

