/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.typesafe.config.Config;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jooby.Cookie;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Session;
import org.jooby.internal.RequestScopedSession;
import org.jooby.internal.SessionImpl;
import org.jooby.internal.SessionManager;
import org.jooby.internal.parser.ParserExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ServerSessionManager
implements SessionManager {
    private final Logger log = LoggerFactory.getLogger(SessionManager.class);
    private final Session.Store store;
    private final Cookie.Definition template;
    private final String secret;
    private final long saveInterval;
    private final ParserExecutor resolver;
    private final long timeout;

    @Inject
    public ServerSessionManager(Config config, Session.Definition def, Session.Store store, ParserExecutor resolver) {
        this.store = store;
        this.resolver = resolver;
        this.secret = config.hasPath("application.secret") ? config.getString("application.secret") : null;
        this.template = def.cookie();
        this.saveInterval = def.saveInterval().get();
        this.timeout = Math.max(-1L, TimeUnit.SECONDS.toMillis(this.template.maxAge().get().intValue()));
    }

    @Override
    public Session create(Request req, Response rsp) {
        Session session = new SessionImpl.Builder(this.resolver, true, this.store.generateID(), this.timeout).build();
        this.log.debug("session created: {}", (Object)session);
        Cookie.Definition cookie = this.cookie(session);
        this.log.debug("  new cookie: {}", (Object)cookie);
        rsp.cookie(cookie);
        return session;
    }

    @Override
    public Session get(Request req, Response rsp) {
        return req.cookie(this.template.name().get()).toOptional().map(cookie -> {
            String sessionId = this.unsign((String)cookie);
            this.log.debug("loading session: {}", (Object)sessionId);
            Session session = this.store.get(new SessionImpl.Builder(this.resolver, false, sessionId, this.timeout));
            if (this.timeout > 0L && session != null) {
                Cookie.Definition setCookie = this.cookie(session);
                this.log.debug("  touch cookie: {}", (Object)setCookie);
                rsp.cookie(setCookie);
            }
            return session;
        }).orElse(null);
    }

    @Override
    public void destroy(Session session) {
        String sid = session.id();
        this.log.debug("  deleting: {}", (Object)sid);
        this.store.delete(sid);
    }

    @Override
    public void requestDone(Session session) {
        try {
            this.createOrUpdate((SessionImpl)((RequestScopedSession)session).session());
        }
        catch (Exception ex) {
            this.log.error("Unable to create/update HTTP session", (Throwable)ex);
        }
    }

    @Override
    public void renewId(Session session, Response rsp) {
        this.destroy(session);
        ((SessionImpl)session).renewId(this.store.generateID());
        Cookie.Definition cookie = this.cookie(session);
        this.log.debug("  renewing cookie: {}", (Object)cookie);
        rsp.cookie(cookie);
    }

    @Override
    public Cookie.Definition cookie() {
        return new Cookie.Definition(this.template);
    }

    private void createOrUpdate(SessionImpl session) {
        session.touch();
        if (session.isNew()) {
            session.aboutToSave();
            this.store.create(session);
        } else if (session.isDirty()) {
            session.aboutToSave();
            this.store.save(session);
        } else {
            long now = System.currentTimeMillis();
            long interval = now - session.savedAt();
            if (interval >= this.saveInterval) {
                session.aboutToSave();
                this.store.save(session);
            }
        }
        session.markAsSaved();
    }

    private String sign(String sessionId) {
        return this.secret == null ? sessionId : Cookie.Signature.sign(sessionId, this.secret);
    }

    private String unsign(String sessionId) {
        if (this.secret == null) {
            return sessionId;
        }
        return Cookie.Signature.unsign(sessionId, this.secret);
    }

    private Cookie.Definition cookie(Session session) {
        return new Cookie.Definition(this.template).value(this.sign(session.id()));
    }
}

