/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.jooby.spi.Server;

public class ServerExecutorProvider
implements Provider<Executor> {
    private Executor executor;

    @Inject
    public ServerExecutorProvider(ServerHolder serverHolder) {
        Objects.requireNonNull(serverHolder, "Server holder is required.");
        this.executor = serverHolder.server != null ? serverHolder.server.executor().orElse(MoreExecutors.directExecutor()) : MoreExecutors.directExecutor();
    }

    public Executor get() {
        return this.executor;
    }

    static class ServerHolder {
        @Inject(optional=true)
        Server server = null;

        ServerHolder() {
        }
    }
}

