/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.Closeables;
import com.google.common.io.Resources;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jooby.Env;
import org.jooby.funzy.Try;
import org.jooby.internal.ParameterNameProvider;
import org.jooby.internal.asm.ClassReader;
import org.jooby.internal.asm.ClassVisitor;
import org.jooby.internal.asm.Label;
import org.jooby.internal.asm.MethodVisitor;
import org.jooby.internal.asm.Type;

public class RouteMetadata
implements ParameterNameProvider {
    private static final String[] NO_ARG = new String[0];
    private final LoadingCache<Class<?>, Map<String, Object>> cache;

    public RouteMetadata(Env env) {
        CacheLoader loader = CacheLoader.from(RouteMetadata::extractMetadata);
        this.cache = env.name().equals("dev") ? CacheBuilder.newBuilder().maximumSize(0L).build(loader) : CacheBuilder.newBuilder().build(loader);
    }

    @Override
    public String[] names(Executable exec) {
        Map<String, Object> md = this.md(exec);
        String key = RouteMetadata.paramsKey(exec);
        return (String[])md.get(key);
    }

    public int startAt(Executable exec) {
        Map<String, Object> md = this.md(exec);
        return (Integer)md.getOrDefault(RouteMetadata.startAtKey(exec), -1);
    }

    private Map<String, Object> md(Executable exec) {
        return (Map)Try.apply(() -> (Map)this.cache.getUnchecked(exec.getDeclaringClass())).unwrap(UncheckedExecutionException.class).get();
    }

    private static Map<String, Object> extractMetadata(Class<?> owner) {
        HashMap<String, Object> hashMap;
        InputStream stream = null;
        try {
            HashMap<String, Object> md = new HashMap<String, Object>();
            stream = Resources.getResource(owner, (String)RouteMetadata.classfile(owner)).openStream();
            new ClassReader(stream).accept(RouteMetadata.visitor(md), 0);
            hashMap = md;
        }
        catch (Exception ex) {
            try {
                throw new IllegalStateException("Can't read class: " + owner.getName(), ex);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(stream);
                throw throwable;
            }
        }
        Closeables.closeQuietly((InputStream)stream);
        return hashMap;
    }

    private static String classfile(Class<?> owner) {
        StringBuilder sb = new StringBuilder();
        for (Class<?> dc = owner.getDeclaringClass(); dc != null; dc = dc.getDeclaringClass()) {
            sb.insert(0, dc.getSimpleName()).append("$");
        }
        sb.append(owner.getSimpleName());
        sb.append(".class");
        return sb.toString();
    }

    private static ClassVisitor visitor(final Map<String, Object> md) {
        return new ClassVisitor(327680){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                boolean isStatic;
                boolean isPublic = (access & 1) > 0;
                boolean bl = isStatic = (access & 8) > 0;
                if (!isPublic || isStatic) {
                    return null;
                }
                final String seed = name + desc;
                Type[] args = Type.getArgumentTypes(desc);
                final String[] names = args.length == 0 ? NO_ARG : new String[args.length];
                md.put(RouteMetadata.paramsKey(seed), names);
                final int minIdx = (access & 8) > 0 ? 0 : 1;
                final int maxIdx = Arrays.stream(args).mapToInt(Type::getSize).sum();
                return new MethodVisitor(327680){
                    private int i;
                    private boolean skipLocalTable;
                    {
                        super(x0);
                        this.i = 0;
                        this.skipLocalTable = false;
                    }

                    @Override
                    public void visitParameter(String name, int access) {
                        this.skipLocalTable = true;
                        names[this.i] = name;
                        ++this.i;
                    }

                    @Override
                    public void visitLineNumber(int line, Label start) {
                        md.putIfAbsent(RouteMetadata.startAtKey(seed), line);
                    }

                    @Override
                    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                        if (!this.skipLocalTable && index >= minIdx && index <= maxIdx) {
                            names[this.i] = name;
                            ++this.i;
                        }
                    }
                };
            }
        };
    }

    private static String paramsKey(Executable exec) {
        return RouteMetadata.paramsKey(RouteMetadata.key(exec));
    }

    private static String paramsKey(String key) {
        return key + ".params";
    }

    private static String startAtKey(Executable exec) {
        return RouteMetadata.startAtKey(RouteMetadata.key(exec));
    }

    private static String startAtKey(String key) {
        return key + ".startAt";
    }

    private static String key(Executable exec) {
        if (exec instanceof Method) {
            return exec.getName() + Type.getMethodDescriptor((Method)exec);
        }
        return "<init>" + Type.getConstructorDescriptor((Constructor)exec);
    }
}

