/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import java.util.List;
import java.util.Map;
import org.jooby.Err;
import org.jooby.MediaType;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Status;
import org.jooby.funzy.Throwing;
import org.jooby.internal.FallbackRoute;
import org.jooby.internal.MappedHandler;
import org.jooby.internal.RouteWithFilter;
import org.jooby.internal.mvc.MvcHandler;

public class RouteImpl
implements RouteWithFilter {
    private Route.Definition route;
    private String path;
    private Map<Object, String> vars;
    private Route.Filter filter;
    private List<MediaType> produces;
    private String method;
    private Route.Source source;

    public static RouteWithFilter notFound(String method, String path) {
        return new FallbackRoute("404", method, path, MediaType.ALL, (req, rsp, chain) -> {
            if (!rsp.status().isPresent()) {
                throw new Err(Status.NOT_FOUND, req.path(true));
            }
        });
    }

    public static RouteWithFilter fallback(Route.Filter filter, String method, String path, String name, List<MediaType> produces) {
        return new FallbackRoute(name, method, path, produces, filter);
    }

    public RouteImpl(Route.Filter filter, Route.Definition route, String method, String path, List<MediaType> produces, Map<Object, String> vars, Route.Mapper<?> mapper, Route.Source source) {
        this.filter = filter;
        if (mapper != null) {
            this.filter = filter instanceof Route.OneArgHandler ? new MappedHandler((Throwing.Function2<Request, Response, Object>)((Throwing.Function2)(req, rsp) -> ((Route.OneArgHandler)filter).handle((Request)req)), mapper) : (filter instanceof Route.ZeroArgHandler ? new MappedHandler((Throwing.Function2<Request, Response, Object>)((Throwing.Function2)(req, rsp) -> ((Route.ZeroArgHandler)filter).handle()), mapper) : (filter instanceof MvcHandler ? (((MvcHandler)filter).method().getReturnType() == Void.TYPE ? filter : new MappedHandler((Throwing.Function3<Request, Response, Route.Chain, Object>)((Throwing.Function3)(req, rsp, chain) -> ((MvcHandler)filter).invoke((Request)req, (Response)rsp, (Route.Chain)chain)), mapper)) : filter));
        }
        this.route = route;
        this.method = method;
        this.produces = produces;
        this.vars = vars;
        this.source = source;
        this.path = Route.unerrpath(path);
    }

    @Override
    public void handle(Request request, Response response, Route.Chain chain) throws Throwable {
        this.filter.handle(request, response, chain);
    }

    @Override
    public Map<String, Object> attributes() {
        return this.route.attributes();
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public String pattern() {
        return this.route.pattern().substring(this.route.pattern().indexOf(47));
    }

    @Override
    public String name() {
        return this.route.name();
    }

    @Override
    public Map<Object, String> vars() {
        return this.vars;
    }

    @Override
    public List<MediaType> consumes() {
        return this.route.consumes();
    }

    @Override
    public List<MediaType> produces() {
        return this.produces;
    }

    @Override
    public boolean glob() {
        return this.route.glob();
    }

    @Override
    public String reverse(Map<String, Object> vars) {
        return this.route.reverse(vars);
    }

    @Override
    public String reverse(Object ... values) {
        return this.route.reverse(values);
    }

    @Override
    public Route.Source source() {
        return this.source;
    }

    @Override
    public String renderer() {
        return this.route.renderer();
    }

    public String toString() {
        return this.print();
    }
}

