/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.collect.ImmutableMap;
import com.google.inject.TypeLiteral;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jooby.Err;
import org.jooby.MediaType;
import org.jooby.Mutant;
import org.jooby.Parser;
import org.jooby.Status;
import org.jooby.internal.ParamReferenceImpl;
import org.jooby.internal.parser.ParserExecutor;

public class MutantImpl
implements Mutant {
    private static final String REQUIRED = "Required %s is not present";
    private static final String FAILURE = "Failed to parse %s to '%s'";
    private final Map<Object, Object> results = new HashMap<Object, Object>(1);
    private final ParserExecutor parser;
    private Object data;
    private MediaType type;

    public MutantImpl(ParserExecutor parser, MediaType type, Object data) {
        this.parser = parser;
        this.type = type;
        this.data = data;
    }

    public MutantImpl(ParserExecutor parser, Object data) {
        this(parser, MediaType.plain, data);
    }

    @Override
    public <T> T to(TypeLiteral<T> type) {
        return this.to(type, this.type);
    }

    @Override
    public <T> T to(TypeLiteral<T> type, MediaType mtype) {
        Object result = this.results.get(type);
        if (result == null) {
            try {
                result = this.parser.convert(type, mtype, this.data);
                if (result == ParserExecutor.NO_PARSER) {
                    Object[] md = this.md();
                    throw new Err((Status)md[2], String.format(FAILURE, md[1], type));
                }
                this.results.put(type, result);
            }
            catch (NoSuchElementException ex) {
                Object[] md = this.md();
                throw new Err.Missing(String.format(REQUIRED, md[1]));
            }
            catch (Err ex) {
                throw ex;
            }
            catch (Throwable ex) {
                Object[] md = this.md();
                throw new Err(this.parser.statusCode(ex), String.format(FAILURE, md[1], type), ex);
            }
        }
        return (T)result;
    }

    @Override
    public Map<String, Mutant> toMap() {
        if (this.data instanceof Map) {
            return (Map)this.data;
        }
        return ImmutableMap.of((Object)((String)this.md()[0]), (Object)this);
    }

    @Override
    public boolean isSet() {
        if (this.data instanceof ParamReferenceImpl) {
            return ((ParamReferenceImpl)this.data).size() > 0;
        }
        if (this.data instanceof Parser.BodyReference) {
            return ((Parser.BodyReference)this.data).length() > 0L;
        }
        return ((Map)this.data).size() > 0;
    }

    private Object[] md() {
        if (this.data instanceof ParamReferenceImpl) {
            ParamReferenceImpl p = (ParamReferenceImpl)this.data;
            return new Object[]{p.name(), p.type() + " '" + p.name() + "'", Status.BAD_REQUEST};
        }
        if (this.data instanceof Parser.BodyReference) {
            return new Object[]{"body", "body", Status.UNSUPPORTED_MEDIA_TYPE};
        }
        return new Object[]{"params", "parameters", Status.BAD_REQUEST};
    }

    public String toString() {
        return this.data.toString();
    }
}

